package software.amazon.awscdk.services.s3tables;

/**
 * Properties for defining a <code>CfnTable</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3tables.*;
 * CfnTableProps cfnTableProps = CfnTableProps.builder()
 *         .namespace("namespace")
 *         .openTableFormat("openTableFormat")
 *         .tableBucketArn("tableBucketArn")
 *         .tableName("tableName")
 *         // the properties below are optional
 *         .compaction(CompactionProperty.builder()
 *                 .status("status")
 *                 .targetFileSizeMb(123)
 *                 .build())
 *         .icebergMetadata(IcebergMetadataProperty.builder()
 *                 .icebergSchema(IcebergSchemaProperty.builder()
 *                         .schemaFieldList(List.of(SchemaFieldProperty.builder()
 *                                 .name("name")
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .required(false)
 *                                 .build()))
 *                         .build())
 *                 .build())
 *         .snapshotManagement(SnapshotManagementProperty.builder()
 *                 .maxSnapshotAgeHours(123)
 *                 .minSnapshotsToKeep(123)
 *                 .status("status")
 *                 .build())
 *         .withoutMetadata("withoutMetadata")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:43.845Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3tables.CfnTableProps")
@software.amazon.jsii.Jsii.Proxy(CfnTableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the namespace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-namespace</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

    /**
     * Format of the table.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-opentableformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-opentableformat</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getOpenTableFormat();

    /**
     * The Amazon Resource Name (ARN) of the specified table bucket.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-tablebucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-tablebucketarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableBucketArn();

    /**
     * The name for the table.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-tablename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTableName();

    /**
     * Settings governing the Compaction maintenance action.
     * <p>
     * Contains details about the compaction settings for an Iceberg table.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-compaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-compaction</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCompaction() {
        return null;
    }

    /**
     * Contains details about the metadata for an Iceberg table.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-icebergmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-icebergmetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIcebergMetadata() {
        return null;
    }

    /**
     * Contains details about the snapshot management settings for an Iceberg table.
     * <p>
     * A snapshot is expired when it exceeds MinSnapshotsToKeep and MaxSnapshotAgeHours.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-snapshotmanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-snapshotmanagement</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotManagement() {
        return null;
    }

    /**
     * Indicates that you don't want to specify a schema for the table.
     * <p>
     * This property is mutually exclusive to 'IcebergMetadata', and its only possible value is 'Yes'.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-withoutmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-s3tables-table.html#cfn-s3tables-table-withoutmetadata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getWithoutMetadata() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTableProps> {
        java.lang.String namespace;
        java.lang.String openTableFormat;
        java.lang.String tableBucketArn;
        java.lang.String tableName;
        java.lang.Object compaction;
        java.lang.Object icebergMetadata;
        java.lang.Object snapshotManagement;
        java.lang.String withoutMetadata;

        /**
         * Sets the value of {@link CfnTableProps#getNamespace}
         * @param namespace The name of the namespace. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getOpenTableFormat}
         * @param openTableFormat Format of the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openTableFormat(java.lang.String openTableFormat) {
            this.openTableFormat = openTableFormat;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTableBucketArn}
         * @param tableBucketArn The Amazon Resource Name (ARN) of the specified table bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableBucketArn(java.lang.String tableBucketArn) {
            this.tableBucketArn = tableBucketArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTableName}
         * @param tableName The name for the table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getCompaction}
         * @param compaction Settings governing the Compaction maintenance action.
         *                   Contains details about the compaction settings for an Iceberg table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compaction(software.amazon.awscdk.IResolvable compaction) {
            this.compaction = compaction;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getCompaction}
         * @param compaction Settings governing the Compaction maintenance action.
         *                   Contains details about the compaction settings for an Iceberg table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compaction(software.amazon.awscdk.services.s3tables.CfnTable.CompactionProperty compaction) {
            this.compaction = compaction;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getIcebergMetadata}
         * @param icebergMetadata Contains details about the metadata for an Iceberg table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder icebergMetadata(software.amazon.awscdk.IResolvable icebergMetadata) {
            this.icebergMetadata = icebergMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getIcebergMetadata}
         * @param icebergMetadata Contains details about the metadata for an Iceberg table.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder icebergMetadata(software.amazon.awscdk.services.s3tables.CfnTable.IcebergMetadataProperty icebergMetadata) {
            this.icebergMetadata = icebergMetadata;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getSnapshotManagement}
         * @param snapshotManagement Contains details about the snapshot management settings for an Iceberg table.
         *                           A snapshot is expired when it exceeds MinSnapshotsToKeep and MaxSnapshotAgeHours.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotManagement(software.amazon.awscdk.IResolvable snapshotManagement) {
            this.snapshotManagement = snapshotManagement;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getSnapshotManagement}
         * @param snapshotManagement Contains details about the snapshot management settings for an Iceberg table.
         *                           A snapshot is expired when it exceeds MinSnapshotsToKeep and MaxSnapshotAgeHours.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotManagement(software.amazon.awscdk.services.s3tables.CfnTable.SnapshotManagementProperty snapshotManagement) {
            this.snapshotManagement = snapshotManagement;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getWithoutMetadata}
         * @param withoutMetadata Indicates that you don't want to specify a schema for the table.
         *                        This property is mutually exclusive to 'IcebergMetadata', and its only possible value is 'Yes'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withoutMetadata(java.lang.String withoutMetadata) {
            this.withoutMetadata = withoutMetadata;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTableProps {
        private final java.lang.String namespace;
        private final java.lang.String openTableFormat;
        private final java.lang.String tableBucketArn;
        private final java.lang.String tableName;
        private final java.lang.Object compaction;
        private final java.lang.Object icebergMetadata;
        private final java.lang.Object snapshotManagement;
        private final java.lang.String withoutMetadata;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.openTableFormat = software.amazon.jsii.Kernel.get(this, "openTableFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableBucketArn = software.amazon.jsii.Kernel.get(this, "tableBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.compaction = software.amazon.jsii.Kernel.get(this, "compaction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.icebergMetadata = software.amazon.jsii.Kernel.get(this, "icebergMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.snapshotManagement = software.amazon.jsii.Kernel.get(this, "snapshotManagement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.withoutMetadata = software.amazon.jsii.Kernel.get(this, "withoutMetadata", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
            this.openTableFormat = java.util.Objects.requireNonNull(builder.openTableFormat, "openTableFormat is required");
            this.tableBucketArn = java.util.Objects.requireNonNull(builder.tableBucketArn, "tableBucketArn is required");
            this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            this.compaction = builder.compaction;
            this.icebergMetadata = builder.icebergMetadata;
            this.snapshotManagement = builder.snapshotManagement;
            this.withoutMetadata = builder.withoutMetadata;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.lang.String getOpenTableFormat() {
            return this.openTableFormat;
        }

        @Override
        public final java.lang.String getTableBucketArn() {
            return this.tableBucketArn;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.lang.Object getCompaction() {
            return this.compaction;
        }

        @Override
        public final java.lang.Object getIcebergMetadata() {
            return this.icebergMetadata;
        }

        @Override
        public final java.lang.Object getSnapshotManagement() {
            return this.snapshotManagement;
        }

        @Override
        public final java.lang.String getWithoutMetadata() {
            return this.withoutMetadata;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("namespace", om.valueToTree(this.getNamespace()));
            data.set("openTableFormat", om.valueToTree(this.getOpenTableFormat()));
            data.set("tableBucketArn", om.valueToTree(this.getTableBucketArn()));
            data.set("tableName", om.valueToTree(this.getTableName()));
            if (this.getCompaction() != null) {
                data.set("compaction", om.valueToTree(this.getCompaction()));
            }
            if (this.getIcebergMetadata() != null) {
                data.set("icebergMetadata", om.valueToTree(this.getIcebergMetadata()));
            }
            if (this.getSnapshotManagement() != null) {
                data.set("snapshotManagement", om.valueToTree(this.getSnapshotManagement()));
            }
            if (this.getWithoutMetadata() != null) {
                data.set("withoutMetadata", om.valueToTree(this.getWithoutMetadata()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3tables.CfnTableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTableProps.Jsii$Proxy that = (CfnTableProps.Jsii$Proxy) o;

            if (!namespace.equals(that.namespace)) return false;
            if (!openTableFormat.equals(that.openTableFormat)) return false;
            if (!tableBucketArn.equals(that.tableBucketArn)) return false;
            if (!tableName.equals(that.tableName)) return false;
            if (this.compaction != null ? !this.compaction.equals(that.compaction) : that.compaction != null) return false;
            if (this.icebergMetadata != null ? !this.icebergMetadata.equals(that.icebergMetadata) : that.icebergMetadata != null) return false;
            if (this.snapshotManagement != null ? !this.snapshotManagement.equals(that.snapshotManagement) : that.snapshotManagement != null) return false;
            return this.withoutMetadata != null ? this.withoutMetadata.equals(that.withoutMetadata) : that.withoutMetadata == null;
        }

        @Override
        public final int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + (this.openTableFormat.hashCode());
            result = 31 * result + (this.tableBucketArn.hashCode());
            result = 31 * result + (this.tableName.hashCode());
            result = 31 * result + (this.compaction != null ? this.compaction.hashCode() : 0);
            result = 31 * result + (this.icebergMetadata != null ? this.icebergMetadata.hashCode() : 0);
            result = 31 * result + (this.snapshotManagement != null ? this.snapshotManagement.hashCode() : 0);
            result = 31 * result + (this.withoutMetadata != null ? this.withoutMetadata.hashCode() : 0);
            return result;
        }
    }
}
