package software.amazon.awscdk.services.sagemaker;

/**
 * Create a new <code>FeatureGroup</code> .
 * <p>
 * A <code>FeatureGroup</code> is a group of <code>Features</code> defined in the <code>FeatureStore</code> to describe a <code>Record</code> .
 * <p>
 * The <code>FeatureGroup</code> defines the schema and features contained in the FeatureGroup. A <code>FeatureGroup</code> definition is composed of a list of <code>Features</code> , a <code>RecordIdentifierFeatureName</code> , an <code>EventTimeFeatureName</code> and configurations for its <code>OnlineStore</code> and <code>OfflineStore</code> . Check <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS service quotas</a> to see the <code>FeatureGroup</code> s quota for your AWS account.
 * <p>
 * <blockquote>
 * <p>
 * You must include at least one of <code>OnlineStoreConfig</code> and <code>OfflineStoreConfig</code> to create a <code>FeatureGroup</code> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * Object offlineStoreConfig;
 * Object onlineStoreConfig;
 * CfnFeatureGroup cfnFeatureGroup = CfnFeatureGroup.Builder.create(this, "MyCfnFeatureGroup")
 *         .eventTimeFeatureName("eventTimeFeatureName")
 *         .featureDefinitions(List.of(FeatureDefinitionProperty.builder()
 *                 .featureName("featureName")
 *                 .featureType("featureType")
 *                 .build()))
 *         .featureGroupName("featureGroupName")
 *         .recordIdentifierFeatureName("recordIdentifierFeatureName")
 *         // the properties below are optional
 *         .description("description")
 *         .offlineStoreConfig(offlineStoreConfig)
 *         .onlineStoreConfig(onlineStoreConfig)
 *         .roleArn("roleArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .throughputConfig(ThroughputConfigProperty.builder()
 *                 .throughputMode("throughputMode")
 *                 // the properties below are optional
 *                 .provisionedReadCapacityUnits(123)
 *                 .provisionedWriteCapacityUnits(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:43.945Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnFeatureGroup")
public class CfnFeatureGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnFeatureGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFeatureGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFeatureGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sagemaker.CfnFeatureGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time a <code>FeatureGroup</code> was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A <code>FeatureGroup</code> status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFeatureGroupStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrFeatureGroupStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventTimeFeatureName() {
        return software.amazon.jsii.Kernel.get(this, "eventTimeFeatureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventTimeFeatureName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "eventTimeFeatureName", java.util.Objects.requireNonNull(value, "eventTimeFeatureName is required"));
    }

    /**
     * A list of <code>Feature</code> s.
     * <p>
     * Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFeatureDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "featureDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of <code>Feature</code> s.
     * <p>
     * Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeatureDefinitions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "featureDefinitions", java.util.Objects.requireNonNull(value, "featureDefinitions is required"));
    }

    /**
     * A list of <code>Feature</code> s.
     * <p>
     * Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeatureDefinitions(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.FeatureDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.FeatureDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "featureDefinitions", java.util.Objects.requireNonNull(value, "featureDefinitions is required"));
    }

    /**
     * The name of the <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFeatureGroupName() {
        return software.amazon.jsii.Kernel.get(this, "featureGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFeatureGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "featureGroupName", java.util.Objects.requireNonNull(value, "featureGroupName is required"));
    }

    /**
     * The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureGroup</code> <code>FeatureDefinitions</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRecordIdentifierFeatureName() {
        return software.amazon.jsii.Kernel.get(this, "recordIdentifierFeatureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureGroup</code> <code>FeatureDefinitions</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecordIdentifierFeatureName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "recordIdentifierFeatureName", java.util.Objects.requireNonNull(value, "recordIdentifierFeatureName is required"));
    }

    /**
     * A free form description of a <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A free form description of a <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The configuration of an <code>OfflineStore</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOfflineStoreConfig() {
        return software.amazon.jsii.Kernel.get(this, "offlineStoreConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of an <code>OfflineStore</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOfflineStoreConfig(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "offlineStoreConfig", value);
    }

    /**
     * The configuration of an <code>OnlineStore</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOnlineStoreConfig() {
        return software.amazon.jsii.Kernel.get(this, "onlineStoreConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration of an <code>OnlineStore</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnlineStoreConfig(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "onlineStoreConfig", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * Tags used to define a <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags used to define a <code>FeatureGroup</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Used to set feature group throughput configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getThroughputConfig() {
        return software.amazon.jsii.Kernel.get(this, "throughputConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Used to set feature group throughput configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThroughputConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "throughputConfig", value);
    }

    /**
     * Used to set feature group throughput configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setThroughputConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.ThroughputConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "throughputConfig", value);
    }
    /**
     * The meta data of the Glue table which serves as data catalog for the <code>OfflineStore</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * DataCatalogConfigProperty dataCatalogConfigProperty = DataCatalogConfigProperty.builder()
     *         .catalog("catalog")
     *         .database("database")
     *         .tableName("tableName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.DataCatalogConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DataCatalogConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataCatalogConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Glue table catalog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-catalog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-catalog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCatalog();

        /**
         * The name of the Glue table database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-database">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-database</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabase();

        /**
         * The name of the Glue table.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-datacatalogconfig.html#cfn-sagemaker-featuregroup-datacatalogconfig-tablename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTableName();

        /**
         * @return a {@link Builder} of {@link DataCatalogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataCatalogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataCatalogConfigProperty> {
            java.lang.String catalog;
            java.lang.String database;
            java.lang.String tableName;

            /**
             * Sets the value of {@link DataCatalogConfigProperty#getCatalog}
             * @param catalog The name of the Glue table catalog. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder catalog(java.lang.String catalog) {
                this.catalog = catalog;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogConfigProperty#getDatabase}
             * @param database The name of the Glue table database. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder database(java.lang.String database) {
                this.database = database;
                return this;
            }

            /**
             * Sets the value of {@link DataCatalogConfigProperty#getTableName}
             * @param tableName The name of the Glue table. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableName(java.lang.String tableName) {
                this.tableName = tableName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataCatalogConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataCatalogConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataCatalogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataCatalogConfigProperty {
            private final java.lang.String catalog;
            private final java.lang.String database;
            private final java.lang.String tableName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.catalog = software.amazon.jsii.Kernel.get(this, "catalog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.database = software.amazon.jsii.Kernel.get(this, "database", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.catalog = java.util.Objects.requireNonNull(builder.catalog, "catalog is required");
                this.database = java.util.Objects.requireNonNull(builder.database, "database is required");
                this.tableName = java.util.Objects.requireNonNull(builder.tableName, "tableName is required");
            }

            @Override
            public final java.lang.String getCatalog() {
                return this.catalog;
            }

            @Override
            public final java.lang.String getDatabase() {
                return this.database;
            }

            @Override
            public final java.lang.String getTableName() {
                return this.tableName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("catalog", om.valueToTree(this.getCatalog()));
                data.set("database", om.valueToTree(this.getDatabase()));
                data.set("tableName", om.valueToTree(this.getTableName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.DataCatalogConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataCatalogConfigProperty.Jsii$Proxy that = (DataCatalogConfigProperty.Jsii$Proxy) o;

                if (!catalog.equals(that.catalog)) return false;
                if (!database.equals(that.database)) return false;
                return this.tableName.equals(that.tableName);
            }

            @Override
            public final int hashCode() {
                int result = this.catalog.hashCode();
                result = 31 * result + (this.database.hashCode());
                result = 31 * result + (this.tableName.hashCode());
                return result;
            }
        }
    }
    /**
     * A list of features.
     * <p>
     * You must include <code>FeatureName</code> and <code>FeatureType</code> . Valid feature <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * FeatureDefinitionProperty featureDefinitionProperty = FeatureDefinitionProperty.builder()
     *         .featureName("featureName")
     *         .featureType("featureType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.FeatureDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(FeatureDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FeatureDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a feature.
         * <p>
         * The type must be a string. <code>FeatureName</code> cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
         * <p>
         * The name:
         * <p>
         * <ul>
         * <li>Must start with an alphanumeric character.</li>
         * <li>Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featurename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featurename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFeatureName();

        /**
         * The value type of a feature.
         * <p>
         * Valid values are Integral, Fractional, or String.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featuretype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-featuredefinition.html#cfn-sagemaker-featuregroup-featuredefinition-featuretype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFeatureType();

        /**
         * @return a {@link Builder} of {@link FeatureDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FeatureDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FeatureDefinitionProperty> {
            java.lang.String featureName;
            java.lang.String featureType;

            /**
             * Sets the value of {@link FeatureDefinitionProperty#getFeatureName}
             * @param featureName The name of a feature. This parameter is required.
             *                    The type must be a string. <code>FeatureName</code> cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
             *                    <p>
             *                    The name:
             *                    <p>
             *                    <ul>
             *                    <li>Must start with an alphanumeric character.</li>
             *                    <li>Can only include alphanumeric characters, underscores, and hyphens. Spaces are not allowed.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureName(java.lang.String featureName) {
                this.featureName = featureName;
                return this;
            }

            /**
             * Sets the value of {@link FeatureDefinitionProperty#getFeatureType}
             * @param featureType The value type of a feature. This parameter is required.
             *                    Valid values are Integral, Fractional, or String.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder featureType(java.lang.String featureType) {
                this.featureType = featureType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FeatureDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FeatureDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FeatureDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FeatureDefinitionProperty {
            private final java.lang.String featureName;
            private final java.lang.String featureType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.featureName = software.amazon.jsii.Kernel.get(this, "featureName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.featureType = software.amazon.jsii.Kernel.get(this, "featureType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.featureName = java.util.Objects.requireNonNull(builder.featureName, "featureName is required");
                this.featureType = java.util.Objects.requireNonNull(builder.featureType, "featureType is required");
            }

            @Override
            public final java.lang.String getFeatureName() {
                return this.featureName;
            }

            @Override
            public final java.lang.String getFeatureType() {
                return this.featureType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("featureName", om.valueToTree(this.getFeatureName()));
                data.set("featureType", om.valueToTree(this.getFeatureType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.FeatureDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FeatureDefinitionProperty.Jsii$Proxy that = (FeatureDefinitionProperty.Jsii$Proxy) o;

                if (!featureName.equals(that.featureName)) return false;
                return this.featureType.equals(that.featureType);
            }

            @Override
            public final int hashCode() {
                int result = this.featureName.hashCode();
                result = 31 * result + (this.featureType.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration of an <code>OfflineStore</code> .
     * <p>
     * Provide an <code>OfflineStoreConfig</code> in a request to <code>CreateFeatureGroup</code> to create an <code>OfflineStore</code> .
     * <p>
     * To encrypt an <code>OfflineStore</code> using at rest data encryption, specify AWS Key Management Service (KMS) key ID, or <code>KMSKeyId</code> , in <code>S3StorageConfig</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * OfflineStoreConfigProperty offlineStoreConfigProperty = OfflineStoreConfigProperty.builder()
     *         .s3StorageConfig(S3StorageConfigProperty.builder()
     *                 .s3Uri("s3Uri")
     *                 // the properties below are optional
     *                 .kmsKeyId("kmsKeyId")
     *                 .build())
     *         // the properties below are optional
     *         .dataCatalogConfig(DataCatalogConfigProperty.builder()
     *                 .catalog("catalog")
     *                 .database("database")
     *                 .tableName("tableName")
     *                 .build())
     *         .disableGlueTableCreation(false)
     *         .tableFormat("tableFormat")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OfflineStoreConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OfflineStoreConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OfflineStoreConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-s3storageconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-s3storageconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3StorageConfig();

        /**
         * The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-datacatalogconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-datacatalogconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataCatalogConfig() {
            return null;
        }

        /**
         * Set to <code>True</code> to disable the automatic creation of an AWS Glue table when configuring an <code>OfflineStore</code> .
         * <p>
         * If set to <code>False</code> , Feature Store will name the <code>OfflineStore</code> Glue table following <a href="https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html">Athena's naming recommendations</a> .
         * <p>
         * The default value is <code>False</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-disablegluetablecreation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-disablegluetablecreation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDisableGlueTableCreation() {
            return null;
        }

        /**
         * Format for the offline store table.
         * <p>
         * Supported formats are Glue (Default) and <a href="https://docs.aws.amazon.com/https://iceberg.apache.org/">Apache Iceberg</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-tableformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-offlinestoreconfig.html#cfn-sagemaker-featuregroup-offlinestoreconfig-tableformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTableFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OfflineStoreConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OfflineStoreConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OfflineStoreConfigProperty> {
            java.lang.Object s3StorageConfig;
            java.lang.Object dataCatalogConfig;
            java.lang.Object disableGlueTableCreation;
            java.lang.String tableFormat;

            /**
             * Sets the value of {@link OfflineStoreConfigProperty#getS3StorageConfig}
             * @param s3StorageConfig The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3StorageConfig(software.amazon.awscdk.IResolvable s3StorageConfig) {
                this.s3StorageConfig = s3StorageConfig;
                return this;
            }

            /**
             * Sets the value of {@link OfflineStoreConfigProperty#getS3StorageConfig}
             * @param s3StorageConfig The Amazon Simple Storage (Amazon S3) location of <code>OfflineStore</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3StorageConfig(software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.S3StorageConfigProperty s3StorageConfig) {
                this.s3StorageConfig = s3StorageConfig;
                return this;
            }

            /**
             * Sets the value of {@link OfflineStoreConfigProperty#getDataCatalogConfig}
             * @param dataCatalogConfig The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCatalogConfig(software.amazon.awscdk.IResolvable dataCatalogConfig) {
                this.dataCatalogConfig = dataCatalogConfig;
                return this;
            }

            /**
             * Sets the value of {@link OfflineStoreConfigProperty#getDataCatalogConfig}
             * @param dataCatalogConfig The meta data of the Glue table that is autogenerated when an <code>OfflineStore</code> is created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataCatalogConfig(software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.DataCatalogConfigProperty dataCatalogConfig) {
                this.dataCatalogConfig = dataCatalogConfig;
                return this;
            }

            /**
             * Sets the value of {@link OfflineStoreConfigProperty#getDisableGlueTableCreation}
             * @param disableGlueTableCreation Set to <code>True</code> to disable the automatic creation of an AWS Glue table when configuring an <code>OfflineStore</code> .
             *                                 If set to <code>False</code> , Feature Store will name the <code>OfflineStore</code> Glue table following <a href="https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html">Athena's naming recommendations</a> .
             *                                 <p>
             *                                 The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableGlueTableCreation(java.lang.Boolean disableGlueTableCreation) {
                this.disableGlueTableCreation = disableGlueTableCreation;
                return this;
            }

            /**
             * Sets the value of {@link OfflineStoreConfigProperty#getDisableGlueTableCreation}
             * @param disableGlueTableCreation Set to <code>True</code> to disable the automatic creation of an AWS Glue table when configuring an <code>OfflineStore</code> .
             *                                 If set to <code>False</code> , Feature Store will name the <code>OfflineStore</code> Glue table following <a href="https://docs.aws.amazon.com/athena/latest/ug/tables-databases-columns-names.html">Athena's naming recommendations</a> .
             *                                 <p>
             *                                 The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder disableGlueTableCreation(software.amazon.awscdk.IResolvable disableGlueTableCreation) {
                this.disableGlueTableCreation = disableGlueTableCreation;
                return this;
            }

            /**
             * Sets the value of {@link OfflineStoreConfigProperty#getTableFormat}
             * @param tableFormat Format for the offline store table.
             *                    Supported formats are Glue (Default) and <a href="https://docs.aws.amazon.com/https://iceberg.apache.org/">Apache Iceberg</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tableFormat(java.lang.String tableFormat) {
                this.tableFormat = tableFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OfflineStoreConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OfflineStoreConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OfflineStoreConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OfflineStoreConfigProperty {
            private final java.lang.Object s3StorageConfig;
            private final java.lang.Object dataCatalogConfig;
            private final java.lang.Object disableGlueTableCreation;
            private final java.lang.String tableFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3StorageConfig = software.amazon.jsii.Kernel.get(this, "s3StorageConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataCatalogConfig = software.amazon.jsii.Kernel.get(this, "dataCatalogConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.disableGlueTableCreation = software.amazon.jsii.Kernel.get(this, "disableGlueTableCreation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tableFormat = software.amazon.jsii.Kernel.get(this, "tableFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3StorageConfig = java.util.Objects.requireNonNull(builder.s3StorageConfig, "s3StorageConfig is required");
                this.dataCatalogConfig = builder.dataCatalogConfig;
                this.disableGlueTableCreation = builder.disableGlueTableCreation;
                this.tableFormat = builder.tableFormat;
            }

            @Override
            public final java.lang.Object getS3StorageConfig() {
                return this.s3StorageConfig;
            }

            @Override
            public final java.lang.Object getDataCatalogConfig() {
                return this.dataCatalogConfig;
            }

            @Override
            public final java.lang.Object getDisableGlueTableCreation() {
                return this.disableGlueTableCreation;
            }

            @Override
            public final java.lang.String getTableFormat() {
                return this.tableFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3StorageConfig", om.valueToTree(this.getS3StorageConfig()));
                if (this.getDataCatalogConfig() != null) {
                    data.set("dataCatalogConfig", om.valueToTree(this.getDataCatalogConfig()));
                }
                if (this.getDisableGlueTableCreation() != null) {
                    data.set("disableGlueTableCreation", om.valueToTree(this.getDisableGlueTableCreation()));
                }
                if (this.getTableFormat() != null) {
                    data.set("tableFormat", om.valueToTree(this.getTableFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OfflineStoreConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OfflineStoreConfigProperty.Jsii$Proxy that = (OfflineStoreConfigProperty.Jsii$Proxy) o;

                if (!s3StorageConfig.equals(that.s3StorageConfig)) return false;
                if (this.dataCatalogConfig != null ? !this.dataCatalogConfig.equals(that.dataCatalogConfig) : that.dataCatalogConfig != null) return false;
                if (this.disableGlueTableCreation != null ? !this.disableGlueTableCreation.equals(that.disableGlueTableCreation) : that.disableGlueTableCreation != null) return false;
                return this.tableFormat != null ? this.tableFormat.equals(that.tableFormat) : that.tableFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3StorageConfig.hashCode();
                result = 31 * result + (this.dataCatalogConfig != null ? this.dataCatalogConfig.hashCode() : 0);
                result = 31 * result + (this.disableGlueTableCreation != null ? this.disableGlueTableCreation.hashCode() : 0);
                result = 31 * result + (this.tableFormat != null ? this.tableFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use this to specify the AWS Key Management Service (KMS) Key ID, or <code>KMSKeyId</code> , for at rest data encryption.
     * <p>
     * You can turn <code>OnlineStore</code> on or off by specifying the <code>EnableOnlineStore</code> flag at General Assembly.
     * <p>
     * The default value is <code>False</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * OnlineStoreConfigProperty onlineStoreConfigProperty = OnlineStoreConfigProperty.builder()
     *         .enableOnlineStore(false)
     *         .securityConfig(OnlineStoreSecurityConfigProperty.builder()
     *                 .kmsKeyId("kmsKeyId")
     *                 .build())
     *         .storageType("storageType")
     *         .ttlDuration(TtlDurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OnlineStoreConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OnlineStoreConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnlineStoreConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Turn <code>OnlineStore</code> off by specifying <code>False</code> for the <code>EnableOnlineStore</code> flag.
         * <p>
         * Turn <code>OnlineStore</code> on by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag.
         * <p>
         * The default value is <code>False</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-enableonlinestore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-enableonlinestore</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableOnlineStore() {
            return null;
        }

        /**
         * Use to specify KMS Key ID ( <code>KMSKeyId</code> ) for at-rest encryption of your <code>OnlineStore</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-securityconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-securityconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecurityConfig() {
            return null;
        }

        /**
         * Option for different tiers of low latency storage for real-time data retrieval.
         * <p>
         * <ul>
         * <li><code>Standard</code> : A managed low latency data store for feature groups.</li>
         * <li><code>InMemory</code> : A managed data store for feature groups that supports very low latency retrieval.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-storagetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
            return null;
        }

        /**
         * Time to live duration, where the record is hard deleted after the expiration time is reached;
         * <p>
         * <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code> . For information on HardDelete, see the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html">DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-ttlduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoreconfig.html#cfn-sagemaker-featuregroup-onlinestoreconfig-ttlduration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTtlDuration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnlineStoreConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnlineStoreConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnlineStoreConfigProperty> {
            java.lang.Object enableOnlineStore;
            java.lang.Object securityConfig;
            java.lang.String storageType;
            java.lang.Object ttlDuration;

            /**
             * Sets the value of {@link OnlineStoreConfigProperty#getEnableOnlineStore}
             * @param enableOnlineStore Turn <code>OnlineStore</code> off by specifying <code>False</code> for the <code>EnableOnlineStore</code> flag.
             *                          Turn <code>OnlineStore</code> on by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag.
             *                          <p>
             *                          The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableOnlineStore(java.lang.Boolean enableOnlineStore) {
                this.enableOnlineStore = enableOnlineStore;
                return this;
            }

            /**
             * Sets the value of {@link OnlineStoreConfigProperty#getEnableOnlineStore}
             * @param enableOnlineStore Turn <code>OnlineStore</code> off by specifying <code>False</code> for the <code>EnableOnlineStore</code> flag.
             *                          Turn <code>OnlineStore</code> on by specifying <code>True</code> for the <code>EnableOnlineStore</code> flag.
             *                          <p>
             *                          The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableOnlineStore(software.amazon.awscdk.IResolvable enableOnlineStore) {
                this.enableOnlineStore = enableOnlineStore;
                return this;
            }

            /**
             * Sets the value of {@link OnlineStoreConfigProperty#getSecurityConfig}
             * @param securityConfig Use to specify KMS Key ID ( <code>KMSKeyId</code> ) for at-rest encryption of your <code>OnlineStore</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityConfig(software.amazon.awscdk.IResolvable securityConfig) {
                this.securityConfig = securityConfig;
                return this;
            }

            /**
             * Sets the value of {@link OnlineStoreConfigProperty#getSecurityConfig}
             * @param securityConfig Use to specify KMS Key ID ( <code>KMSKeyId</code> ) for at-rest encryption of your <code>OnlineStore</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityConfig(software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty securityConfig) {
                this.securityConfig = securityConfig;
                return this;
            }

            /**
             * Sets the value of {@link OnlineStoreConfigProperty#getStorageType}
             * @param storageType Option for different tiers of low latency storage for real-time data retrieval.
             *                    <ul>
             *                    <li><code>Standard</code> : A managed low latency data store for feature groups.</li>
             *                    <li><code>InMemory</code> : A managed data store for feature groups that supports very low latency retrieval.</li>
             *                    </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageType(java.lang.String storageType) {
                this.storageType = storageType;
                return this;
            }

            /**
             * Sets the value of {@link OnlineStoreConfigProperty#getTtlDuration}
             * @param ttlDuration Time to live duration, where the record is hard deleted after the expiration time is reached;.
             *                    <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code> . For information on HardDelete, see the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html">DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttlDuration(software.amazon.awscdk.IResolvable ttlDuration) {
                this.ttlDuration = ttlDuration;
                return this;
            }

            /**
             * Sets the value of {@link OnlineStoreConfigProperty#getTtlDuration}
             * @param ttlDuration Time to live duration, where the record is hard deleted after the expiration time is reached;.
             *                    <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code> . For information on HardDelete, see the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html">DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ttlDuration(software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.TtlDurationProperty ttlDuration) {
                this.ttlDuration = ttlDuration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnlineStoreConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnlineStoreConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnlineStoreConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnlineStoreConfigProperty {
            private final java.lang.Object enableOnlineStore;
            private final java.lang.Object securityConfig;
            private final java.lang.String storageType;
            private final java.lang.Object ttlDuration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableOnlineStore = software.amazon.jsii.Kernel.get(this, "enableOnlineStore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityConfig = software.amazon.jsii.Kernel.get(this, "securityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.storageType = software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ttlDuration = software.amazon.jsii.Kernel.get(this, "ttlDuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableOnlineStore = builder.enableOnlineStore;
                this.securityConfig = builder.securityConfig;
                this.storageType = builder.storageType;
                this.ttlDuration = builder.ttlDuration;
            }

            @Override
            public final java.lang.Object getEnableOnlineStore() {
                return this.enableOnlineStore;
            }

            @Override
            public final java.lang.Object getSecurityConfig() {
                return this.securityConfig;
            }

            @Override
            public final java.lang.String getStorageType() {
                return this.storageType;
            }

            @Override
            public final java.lang.Object getTtlDuration() {
                return this.ttlDuration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnableOnlineStore() != null) {
                    data.set("enableOnlineStore", om.valueToTree(this.getEnableOnlineStore()));
                }
                if (this.getSecurityConfig() != null) {
                    data.set("securityConfig", om.valueToTree(this.getSecurityConfig()));
                }
                if (this.getStorageType() != null) {
                    data.set("storageType", om.valueToTree(this.getStorageType()));
                }
                if (this.getTtlDuration() != null) {
                    data.set("ttlDuration", om.valueToTree(this.getTtlDuration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OnlineStoreConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnlineStoreConfigProperty.Jsii$Proxy that = (OnlineStoreConfigProperty.Jsii$Proxy) o;

                if (this.enableOnlineStore != null ? !this.enableOnlineStore.equals(that.enableOnlineStore) : that.enableOnlineStore != null) return false;
                if (this.securityConfig != null ? !this.securityConfig.equals(that.securityConfig) : that.securityConfig != null) return false;
                if (this.storageType != null ? !this.storageType.equals(that.storageType) : that.storageType != null) return false;
                return this.ttlDuration != null ? this.ttlDuration.equals(that.ttlDuration) : that.ttlDuration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableOnlineStore != null ? this.enableOnlineStore.hashCode() : 0;
                result = 31 * result + (this.securityConfig != null ? this.securityConfig.hashCode() : 0);
                result = 31 * result + (this.storageType != null ? this.storageType.hashCode() : 0);
                result = 31 * result + (this.ttlDuration != null ? this.ttlDuration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The security configuration for <code>OnlineStore</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * OnlineStoreSecurityConfigProperty onlineStoreSecurityConfigProperty = OnlineStoreSecurityConfigProperty.builder()
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoresecurityconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoresecurityconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OnlineStoreSecurityConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnlineStoreSecurityConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
         * <p>
         * The caller (either user or IAM role) of <code>CreateFeatureGroup</code> must have below permissions to the <code>OnlineStore</code> <code>KmsKeyId</code> :
         * <p>
         * <ul>
         * <li><code>"kms:Encrypt"</code></li>
         * <li><code>"kms:Decrypt"</code></li>
         * <li><code>"kms:DescribeKey"</code></li>
         * <li><code>"kms:CreateGrant"</code></li>
         * <li><code>"kms:RetireGrant"</code></li>
         * <li><code>"kms:ReEncryptFrom"</code></li>
         * <li><code>"kms:ReEncryptTo"</code></li>
         * <li><code>"kms:GenerateDataKey"</code></li>
         * <li><code>"kms:ListAliases"</code></li>
         * <li><code>"kms:ListGrants"</code></li>
         * <li><code>"kms:RevokeGrant"</code></li>
         * </ul>
         * <p>
         * The caller (either user or IAM role) to all DataPlane operations ( <code>PutRecord</code> , <code>GetRecord</code> , <code>DeleteRecord</code> ) must have the following permissions to the <code>KmsKeyId</code> :
         * <p>
         * <ul>
         * <li><code>"kms:Decrypt"</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoresecurityconfig.html#cfn-sagemaker-featuregroup-onlinestoresecurityconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-onlinestoresecurityconfig.html#cfn-sagemaker-featuregroup-onlinestoresecurityconfig-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OnlineStoreSecurityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnlineStoreSecurityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnlineStoreSecurityConfigProperty> {
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link OnlineStoreSecurityConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service (KMS) key ARN that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
             *                 The caller (either user or IAM role) of <code>CreateFeatureGroup</code> must have below permissions to the <code>OnlineStore</code> <code>KmsKeyId</code> :
             *                 <p>
             *                 <ul>
             *                 <li><code>"kms:Encrypt"</code></li>
             *                 <li><code>"kms:Decrypt"</code></li>
             *                 <li><code>"kms:DescribeKey"</code></li>
             *                 <li><code>"kms:CreateGrant"</code></li>
             *                 <li><code>"kms:RetireGrant"</code></li>
             *                 <li><code>"kms:ReEncryptFrom"</code></li>
             *                 <li><code>"kms:ReEncryptTo"</code></li>
             *                 <li><code>"kms:GenerateDataKey"</code></li>
             *                 <li><code>"kms:ListAliases"</code></li>
             *                 <li><code>"kms:ListGrants"</code></li>
             *                 <li><code>"kms:RevokeGrant"</code></li>
             *                 </ul>
             *                 <p>
             *                 The caller (either user or IAM role) to all DataPlane operations ( <code>PutRecord</code> , <code>GetRecord</code> , <code>DeleteRecord</code> ) must have the following permissions to the <code>KmsKeyId</code> :
             *                 <p>
             *                 <ul>
             *                 <li><code>"kms:Decrypt"</code></li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnlineStoreSecurityConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnlineStoreSecurityConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnlineStoreSecurityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnlineStoreSecurityConfigProperty {
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.OnlineStoreSecurityConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnlineStoreSecurityConfigProperty.Jsii$Proxy that = (OnlineStoreSecurityConfigProperty.Jsii$Proxy) o;

                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The Amazon Simple Storage (Amazon S3) location and security configuration for <code>OfflineStore</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * S3StorageConfigProperty s3StorageConfigProperty = S3StorageConfigProperty.builder()
     *         .s3Uri("s3Uri")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.S3StorageConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3StorageConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3StorageConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 URI, or location in Amazon S3, of <code>OfflineStore</code> .
         * <p>
         * S3 URIs have a format similar to the following: <code>s3://example-bucket/prefix/</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html#cfn-sagemaker-featuregroup-s3storageconfig-s3uri">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html#cfn-sagemaker-featuregroup-s3storageconfig-s3uri</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Uri();

        /**
         * The AWS Key Management Service (KMS) key ARN of the key used to encrypt any objects written into the <code>OfflineStore</code> S3 location.
         * <p>
         * The IAM <code>roleARN</code> that is passed as a parameter to <code>CreateFeatureGroup</code> must have below permissions to the <code>KmsKeyId</code> :
         * <p>
         * <ul>
         * <li><code>"kms:GenerateDataKey"</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html#cfn-sagemaker-featuregroup-s3storageconfig-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-s3storageconfig.html#cfn-sagemaker-featuregroup-s3storageconfig-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3StorageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3StorageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3StorageConfigProperty> {
            java.lang.String s3Uri;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link S3StorageConfigProperty#getS3Uri}
             * @param s3Uri The S3 URI, or location in Amazon S3, of <code>OfflineStore</code> . This parameter is required.
             *              S3 URIs have a format similar to the following: <code>s3://example-bucket/prefix/</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Uri(java.lang.String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            /**
             * Sets the value of {@link S3StorageConfigProperty#getKmsKeyId}
             * @param kmsKeyId The AWS Key Management Service (KMS) key ARN of the key used to encrypt any objects written into the <code>OfflineStore</code> S3 location.
             *                 The IAM <code>roleARN</code> that is passed as a parameter to <code>CreateFeatureGroup</code> must have below permissions to the <code>KmsKeyId</code> :
             *                 <p>
             *                 <ul>
             *                 <li><code>"kms:GenerateDataKey"</code></li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3StorageConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3StorageConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3StorageConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3StorageConfigProperty {
            private final java.lang.String s3Uri;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Uri = software.amazon.jsii.Kernel.get(this, "s3Uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Uri = java.util.Objects.requireNonNull(builder.s3Uri, "s3Uri is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.String getS3Uri() {
                return this.s3Uri;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Uri", om.valueToTree(this.getS3Uri()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.S3StorageConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3StorageConfigProperty.Jsii$Proxy that = (S3StorageConfigProperty.Jsii$Proxy) o;

                if (!s3Uri.equals(that.s3Uri)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Uri.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Used to set feature group throughput configuration.
     * <p>
     * There are two modes: <code>ON_DEMAND</code> and <code>PROVISIONED</code> . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
     * <p>
     * Note: <code>PROVISIONED</code> throughput mode is supported only for feature groups that are offline-only, or use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType"><code>Standard</code></a> tier online store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * ThroughputConfigProperty throughputConfigProperty = ThroughputConfigProperty.builder()
     *         .throughputMode("throughputMode")
     *         // the properties below are optional
     *         .provisionedReadCapacityUnits(123)
     *         .provisionedWriteCapacityUnits(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.ThroughputConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ThroughputConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ThroughputConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The mode used for your feature group throughput: <code>ON_DEMAND</code> or <code>PROVISIONED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html#cfn-sagemaker-featuregroup-throughputconfig-throughputmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html#cfn-sagemaker-featuregroup-throughputconfig-throughputmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getThroughputMode();

        /**
         * For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling.
         * <p>
         * This field is not applicable for on-demand feature groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html#cfn-sagemaker-featuregroup-throughputconfig-provisionedreadcapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html#cfn-sagemaker-featuregroup-throughputconfig-provisionedreadcapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProvisionedReadCapacityUnits() {
            return null;
        }

        /**
         * For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling.
         * <p>
         * This field is not applicable for on-demand feature groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html#cfn-sagemaker-featuregroup-throughputconfig-provisionedwritecapacityunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-throughputconfig.html#cfn-sagemaker-featuregroup-throughputconfig-provisionedwritecapacityunits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProvisionedWriteCapacityUnits() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ThroughputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ThroughputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ThroughputConfigProperty> {
            java.lang.String throughputMode;
            java.lang.Number provisionedReadCapacityUnits;
            java.lang.Number provisionedWriteCapacityUnits;

            /**
             * Sets the value of {@link ThroughputConfigProperty#getThroughputMode}
             * @param throughputMode The mode used for your feature group throughput: <code>ON_DEMAND</code> or <code>PROVISIONED</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughputMode(java.lang.String throughputMode) {
                this.throughputMode = throughputMode;
                return this;
            }

            /**
             * Sets the value of {@link ThroughputConfigProperty#getProvisionedReadCapacityUnits}
             * @param provisionedReadCapacityUnits For provisioned feature groups with online store enabled, this indicates the read throughput you are billed for and can consume without throttling.
             *                                     This field is not applicable for on-demand feature groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedReadCapacityUnits(java.lang.Number provisionedReadCapacityUnits) {
                this.provisionedReadCapacityUnits = provisionedReadCapacityUnits;
                return this;
            }

            /**
             * Sets the value of {@link ThroughputConfigProperty#getProvisionedWriteCapacityUnits}
             * @param provisionedWriteCapacityUnits For provisioned feature groups, this indicates the write throughput you are billed for and can consume without throttling.
             *                                      This field is not applicable for on-demand feature groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedWriteCapacityUnits(java.lang.Number provisionedWriteCapacityUnits) {
                this.provisionedWriteCapacityUnits = provisionedWriteCapacityUnits;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ThroughputConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ThroughputConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ThroughputConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ThroughputConfigProperty {
            private final java.lang.String throughputMode;
            private final java.lang.Number provisionedReadCapacityUnits;
            private final java.lang.Number provisionedWriteCapacityUnits;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.throughputMode = software.amazon.jsii.Kernel.get(this, "throughputMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.provisionedReadCapacityUnits = software.amazon.jsii.Kernel.get(this, "provisionedReadCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.provisionedWriteCapacityUnits = software.amazon.jsii.Kernel.get(this, "provisionedWriteCapacityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.throughputMode = java.util.Objects.requireNonNull(builder.throughputMode, "throughputMode is required");
                this.provisionedReadCapacityUnits = builder.provisionedReadCapacityUnits;
                this.provisionedWriteCapacityUnits = builder.provisionedWriteCapacityUnits;
            }

            @Override
            public final java.lang.String getThroughputMode() {
                return this.throughputMode;
            }

            @Override
            public final java.lang.Number getProvisionedReadCapacityUnits() {
                return this.provisionedReadCapacityUnits;
            }

            @Override
            public final java.lang.Number getProvisionedWriteCapacityUnits() {
                return this.provisionedWriteCapacityUnits;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("throughputMode", om.valueToTree(this.getThroughputMode()));
                if (this.getProvisionedReadCapacityUnits() != null) {
                    data.set("provisionedReadCapacityUnits", om.valueToTree(this.getProvisionedReadCapacityUnits()));
                }
                if (this.getProvisionedWriteCapacityUnits() != null) {
                    data.set("provisionedWriteCapacityUnits", om.valueToTree(this.getProvisionedWriteCapacityUnits()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.ThroughputConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ThroughputConfigProperty.Jsii$Proxy that = (ThroughputConfigProperty.Jsii$Proxy) o;

                if (!throughputMode.equals(that.throughputMode)) return false;
                if (this.provisionedReadCapacityUnits != null ? !this.provisionedReadCapacityUnits.equals(that.provisionedReadCapacityUnits) : that.provisionedReadCapacityUnits != null) return false;
                return this.provisionedWriteCapacityUnits != null ? this.provisionedWriteCapacityUnits.equals(that.provisionedWriteCapacityUnits) : that.provisionedWriteCapacityUnits == null;
            }

            @Override
            public final int hashCode() {
                int result = this.throughputMode.hashCode();
                result = 31 * result + (this.provisionedReadCapacityUnits != null ? this.provisionedReadCapacityUnits.hashCode() : 0);
                result = 31 * result + (this.provisionedWriteCapacityUnits != null ? this.provisionedWriteCapacityUnits.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Time to live duration, where the record is hard deleted after the expiration time is reached;
     * <p>
     * <code>ExpiresAt</code> = <code>EventTime</code> + <code>TtlDuration</code> . For information on HardDelete, see the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_feature_store_DeleteRecord.html">DeleteRecord</a> API in the Amazon SageMaker API Reference guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.sagemaker.*;
     * TtlDurationProperty ttlDurationProperty = TtlDurationProperty.builder()
     *         .unit("unit")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-ttlduration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-ttlduration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.TtlDurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TtlDurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TtlDurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * <code>TtlDuration</code> time unit.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-ttlduration.html#cfn-sagemaker-featuregroup-ttlduration-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-ttlduration.html#cfn-sagemaker-featuregroup-ttlduration-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnit() {
            return null;
        }

        /**
         * <code>TtlDuration</code> time value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-ttlduration.html#cfn-sagemaker-featuregroup-ttlduration-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-sagemaker-featuregroup-ttlduration.html#cfn-sagemaker-featuregroup-ttlduration-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TtlDurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TtlDurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TtlDurationProperty> {
            java.lang.String unit;
            java.lang.Number value;

            /**
             * Sets the value of {@link TtlDurationProperty#getUnit}
             * @param unit <code>TtlDuration</code> time unit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link TtlDurationProperty#getValue}
             * @param value <code>TtlDuration</code> time value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TtlDurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TtlDurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TtlDurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TtlDurationProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = builder.unit;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUnit() != null) {
                    data.set("unit", om.valueToTree(this.getUnit()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnFeatureGroup.TtlDurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TtlDurationProperty.Jsii$Proxy that = (TtlDurationProperty.Jsii$Proxy) o;

                if (this.unit != null ? !this.unit.equals(that.unit) : that.unit != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.unit != null ? this.unit.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.sagemaker.CfnFeatureGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.sagemaker.CfnFeatureGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.sagemaker.CfnFeatureGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.sagemaker.CfnFeatureGroupProps.Builder();
        }

        /**
         * The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code> .
         * <p>
         * A <code>EventTime</code> is point in time when a new event occurs that corresponds to the creation or update of a <code>Record</code> in <code>FeatureGroup</code> . All <code>Records</code> in the <code>FeatureGroup</code> must have a corresponding <code>EventTime</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-eventtimefeaturename</a>
         * @param eventTimeFeatureName The name of the feature that stores the <code>EventTime</code> of a Record in a <code>FeatureGroup</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventTimeFeatureName(final java.lang.String eventTimeFeatureName) {
            this.props.eventTimeFeatureName(eventTimeFeatureName);
            return this;
        }

        /**
         * A list of <code>Feature</code> s. Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code> .
         * <p>
         * Valid <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
         * <p>
         * <code>FeatureName</code> s cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
         * <p>
         * You can create up to 2,500 <code>FeatureDefinition</code> s per <code>FeatureGroup</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions</a>
         * @param featureDefinitions A list of <code>Feature</code> s. Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featureDefinitions(final software.amazon.awscdk.IResolvable featureDefinitions) {
            this.props.featureDefinitions(featureDefinitions);
            return this;
        }
        /**
         * A list of <code>Feature</code> s. Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code> .
         * <p>
         * Valid <code>FeatureType</code> s are <code>Integral</code> , <code>Fractional</code> and <code>String</code> .
         * <p>
         * <code>FeatureName</code> s cannot be any of the following: <code>is_deleted</code> , <code>write_time</code> , <code>api_invocation_time</code> .
         * <p>
         * You can create up to 2,500 <code>FeatureDefinition</code> s per <code>FeatureGroup</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuredefinitions</a>
         * @param featureDefinitions A list of <code>Feature</code> s. Each <code>Feature</code> must include a <code>FeatureName</code> and a <code>FeatureType</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featureDefinitions(final java.util.List<? extends java.lang.Object> featureDefinitions) {
            this.props.featureDefinitions(featureDefinitions);
            return this;
        }

        /**
         * The name of the <code>FeatureGroup</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-featuregroupname</a>
         * @param featureGroupName The name of the <code>FeatureGroup</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featureGroupName(final java.lang.String featureGroupName) {
            this.props.featureGroupName(featureGroupName);
            return this;
        }

        /**
         * The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureGroup</code> <code>FeatureDefinitions</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-recordidentifierfeaturename</a>
         * @param recordIdentifierFeatureName The name of the <code>Feature</code> whose value uniquely identifies a <code>Record</code> defined in the <code>FeatureGroup</code> <code>FeatureDefinitions</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordIdentifierFeatureName(final java.lang.String recordIdentifierFeatureName) {
            this.props.recordIdentifierFeatureName(recordIdentifierFeatureName);
            return this;
        }

        /**
         * A free form description of a <code>FeatureGroup</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-description</a>
         * @param description A free form description of a <code>FeatureGroup</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The configuration of an <code>OfflineStore</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-offlinestoreconfig</a>
         * @param offlineStoreConfig The configuration of an <code>OfflineStore</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offlineStoreConfig(final java.lang.Object offlineStoreConfig) {
            this.props.offlineStoreConfig(offlineStoreConfig);
            return this;
        }

        /**
         * The configuration of an <code>OnlineStore</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-onlinestoreconfig</a>
         * @param onlineStoreConfig The configuration of an <code>OnlineStore</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onlineStoreConfig(final java.lang.Object onlineStoreConfig) {
            this.props.onlineStoreConfig(onlineStoreConfig);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) of the IAM execution role used to create the feature group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Tags used to define a <code>FeatureGroup</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-tags</a>
         * @param tags Tags used to define a <code>FeatureGroup</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Used to set feature group throughput configuration.
         * <p>
         * There are two modes: <code>ON_DEMAND</code> and <code>PROVISIONED</code> . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
         * <p>
         * Note: <code>PROVISIONED</code> throughput mode is supported only for feature groups that are offline-only, or use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType"><code>Standard</code></a> tier online store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-throughputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-throughputconfig</a>
         * @param throughputConfig Used to set feature group throughput configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputConfig(final software.amazon.awscdk.IResolvable throughputConfig) {
            this.props.throughputConfig(throughputConfig);
            return this;
        }
        /**
         * Used to set feature group throughput configuration.
         * <p>
         * There are two modes: <code>ON_DEMAND</code> and <code>PROVISIONED</code> . With on-demand mode, you are charged for data reads and writes that your application performs on your feature group. You do not need to specify read and write throughput because Feature Store accommodates your workloads as they ramp up and down. You can switch a feature group to on-demand only once in a 24 hour period. With provisioned throughput mode, you specify the read and write capacity per second that you expect your application to require, and you are billed based on those limits. Exceeding provisioned throughput will result in your requests being throttled.
         * <p>
         * Note: <code>PROVISIONED</code> throughput mode is supported only for feature groups that are offline-only, or use the <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_OnlineStoreConfig.html#sagemaker-Type-OnlineStoreConfig-StorageType"><code>Standard</code></a> tier online store.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-throughputconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-featuregroup.html#cfn-sagemaker-featuregroup-throughputconfig</a>
         * @param throughputConfig Used to set feature group throughput configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughputConfig(final software.amazon.awscdk.services.sagemaker.CfnFeatureGroup.ThroughputConfigProperty throughputConfig) {
            this.props.throughputConfig(throughputConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.sagemaker.CfnFeatureGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.sagemaker.CfnFeatureGroup build() {
            return new software.amazon.awscdk.services.sagemaker.CfnFeatureGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
