package software.amazon.awscdk.services.scheduler;

/**
 * Properties for a Schedule Group.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaInvoke target;
 * ScheduleGroup scheduleGroup = ScheduleGroup.Builder.create(this, "ScheduleGroup")
 *         .scheduleGroupName("MyScheduleGroup")
 *         .build();
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.rate(Duration.minutes(10)))
 *         .target(target)
 *         .scheduleGroup(scheduleGroup)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:44.315Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler.ScheduleGroupProps")
@software.amazon.jsii.Jsii.Proxy(ScheduleGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduleGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The removal policy for the group.
     * <p>
     * If the group is removed also all schedules are removed.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * The name of the schedule group.
     * <p>
     * Up to 64 letters (uppercase and lowercase), numbers, hyphens, underscores and dots are allowed.
     * <p>
     * Default: - A unique name will be generated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheduleGroupName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ScheduleGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduleGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduleGroupProps> {
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        java.lang.String scheduleGroupName;

        /**
         * Sets the value of {@link ScheduleGroupProps#getRemovalPolicy}
         * @param removalPolicy The removal policy for the group.
         *                      If the group is removed also all schedules are removed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link ScheduleGroupProps#getScheduleGroupName}
         * @param scheduleGroupName The name of the schedule group.
         *                          Up to 64 letters (uppercase and lowercase), numbers, hyphens, underscores and dots are allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleGroupName(java.lang.String scheduleGroupName) {
            this.scheduleGroupName = scheduleGroupName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduleGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduleGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScheduleGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleGroupProps {
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final java.lang.String scheduleGroupName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.scheduleGroupName = software.amazon.jsii.Kernel.get(this, "scheduleGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.removalPolicy = builder.removalPolicy;
            this.scheduleGroupName = builder.scheduleGroupName;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.lang.String getScheduleGroupName() {
            return this.scheduleGroupName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getScheduleGroupName() != null) {
                data.set("scheduleGroupName", om.valueToTree(this.getScheduleGroupName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_scheduler.ScheduleGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduleGroupProps.Jsii$Proxy that = (ScheduleGroupProps.Jsii$Proxy) o;

            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            return this.scheduleGroupName != null ? this.scheduleGroupName.equals(that.scheduleGroupName) : that.scheduleGroupName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.removalPolicy != null ? this.removalPolicy.hashCode() : 0;
            result = 31 * result + (this.scheduleGroupName != null ? this.scheduleGroupName.hashCode() : 0);
            return result;
        }
    }
}
