package software.amazon.awscdk.services.securityhub;

/**
 * Properties for defining a <code>CfnAutomationRuleV2</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securityhub.*;
 * CfnAutomationRuleV2Props cfnAutomationRuleV2Props = CfnAutomationRuleV2Props.builder()
 *         .actions(List.of(AutomationRulesActionV2Property.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .externalIntegrationConfiguration(ExternalIntegrationConfigurationProperty.builder()
 *                         .connectorArn("connectorArn")
 *                         .build())
 *                 .findingFieldsUpdate(AutomationRulesFindingFieldsUpdateV2Property.builder()
 *                         .comment("comment")
 *                         .severityId(123)
 *                         .statusId(123)
 *                         .build())
 *                 .build()))
 *         .criteria(CriteriaProperty.builder()
 *                 .ocsfFindingCriteria(OcsfFindingFiltersProperty.builder()
 *                         .compositeFilters(List.of(CompositeFilterProperty.builder()
 *                                 .booleanFilters(List.of(OcsfBooleanFilterProperty.builder()
 *                                         .fieldName("fieldName")
 *                                         .filter(BooleanFilterProperty.builder()
 *                                                 .value(false)
 *                                                 .build())
 *                                         .build()))
 *                                 .dateFilters(List.of(OcsfDateFilterProperty.builder()
 *                                         .fieldName("fieldName")
 *                                         .filter(DateFilterProperty.builder()
 *                                                 .dateRange(DateRangeProperty.builder()
 *                                                         .unit("unit")
 *                                                         .value(123)
 *                                                         .build())
 *                                                 .end("end")
 *                                                 .start("start")
 *                                                 .build())
 *                                         .build()))
 *                                 .mapFilters(List.of(OcsfMapFilterProperty.builder()
 *                                         .fieldName("fieldName")
 *                                         .filter(MapFilterProperty.builder()
 *                                                 .comparison("comparison")
 *                                                 .key("key")
 *                                                 .value("value")
 *                                                 .build())
 *                                         .build()))
 *                                 .numberFilters(List.of(OcsfNumberFilterProperty.builder()
 *                                         .fieldName("fieldName")
 *                                         .filter(NumberFilterProperty.builder()
 *                                                 .eq(123)
 *                                                 .gte(123)
 *                                                 .lte(123)
 *                                                 .build())
 *                                         .build()))
 *                                 .operator("operator")
 *                                 .stringFilters(List.of(OcsfStringFilterProperty.builder()
 *                                         .fieldName("fieldName")
 *                                         .filter(StringFilterProperty.builder()
 *                                                 .comparison("comparison")
 *                                                 .value("value")
 *                                                 .build())
 *                                         .build()))
 *                                 .build()))
 *                         .compositeOperator("compositeOperator")
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .ruleName("ruleName")
 *         .ruleOrder(123)
 *         // the properties below are optional
 *         .ruleStatus("ruleStatus")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:44.454Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2Props")
@software.amazon.jsii.Jsii.Proxy(CfnAutomationRuleV2Props.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAutomationRuleV2Props extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of actions to be performed when the rule criteria is met.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-actions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getActions();

    /**
     * The filtering type and configuration of the automation rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-criteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-criteria</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCriteria();

    /**
     * A description of the V2 automation rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The name of the V2 automation rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-rulename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-rulename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRuleName();

    /**
     * The value for the rule priority.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-ruleorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-ruleorder</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getRuleOrder();

    /**
     * The status of the V2 automation rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-rulestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-rulestatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRuleStatus() {
        return null;
    }

    /**
     * A list of key-value pairs associated with the V2 automation rule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrulev2.html#cfn-securityhub-automationrulev2-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAutomationRuleV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAutomationRuleV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAutomationRuleV2Props> {
        java.lang.Object actions;
        java.lang.Object criteria;
        java.lang.String description;
        java.lang.String ruleName;
        java.lang.Number ruleOrder;
        java.lang.String ruleStatus;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnAutomationRuleV2Props#getActions}
         * @param actions A list of actions to be performed when the rule criteria is met. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleV2Props#getActions}
         * @param actions A list of actions to be performed when the rule criteria is met. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.List<? extends java.lang.Object> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleV2Props#getCriteria}
         * @param criteria The filtering type and configuration of the automation rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criteria(software.amazon.awscdk.IResolvable criteria) {
            this.criteria = criteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleV2Props#getCriteria}
         * @param criteria The filtering type and configuration of the automation rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder criteria(software.amazon.awscdk.services.securityhub.CfnAutomationRuleV2.CriteriaProperty criteria) {
            this.criteria = criteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleV2Props#getDescription}
         * @param description A description of the V2 automation rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleV2Props#getRuleName}
         * @param ruleName The name of the V2 automation rule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleName(java.lang.String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleV2Props#getRuleOrder}
         * @param ruleOrder The value for the rule priority. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleOrder(java.lang.Number ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleV2Props#getRuleStatus}
         * @param ruleStatus The status of the V2 automation rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleStatus(java.lang.String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnAutomationRuleV2Props#getTags}
         * @param tags A list of key-value pairs associated with the V2 automation rule.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAutomationRuleV2Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAutomationRuleV2Props build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAutomationRuleV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAutomationRuleV2Props {
        private final java.lang.Object actions;
        private final java.lang.Object criteria;
        private final java.lang.String description;
        private final java.lang.String ruleName;
        private final java.lang.Number ruleOrder;
        private final java.lang.String ruleStatus;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.criteria = software.amazon.jsii.Kernel.get(this, "criteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleName = software.amazon.jsii.Kernel.get(this, "ruleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleOrder = software.amazon.jsii.Kernel.get(this, "ruleOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ruleStatus = software.amazon.jsii.Kernel.get(this, "ruleStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
            this.criteria = java.util.Objects.requireNonNull(builder.criteria, "criteria is required");
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.ruleName = java.util.Objects.requireNonNull(builder.ruleName, "ruleName is required");
            this.ruleOrder = java.util.Objects.requireNonNull(builder.ruleOrder, "ruleOrder is required");
            this.ruleStatus = builder.ruleStatus;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.Object getCriteria() {
            return this.criteria;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final java.lang.Number getRuleOrder() {
            return this.ruleOrder;
        }

        @Override
        public final java.lang.String getRuleStatus() {
            return this.ruleStatus;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("actions", om.valueToTree(this.getActions()));
            data.set("criteria", om.valueToTree(this.getCriteria()));
            data.set("description", om.valueToTree(this.getDescription()));
            data.set("ruleName", om.valueToTree(this.getRuleName()));
            data.set("ruleOrder", om.valueToTree(this.getRuleOrder()));
            if (this.getRuleStatus() != null) {
                data.set("ruleStatus", om.valueToTree(this.getRuleStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securityhub.CfnAutomationRuleV2Props"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAutomationRuleV2Props.Jsii$Proxy that = (CfnAutomationRuleV2Props.Jsii$Proxy) o;

            if (!actions.equals(that.actions)) return false;
            if (!criteria.equals(that.criteria)) return false;
            if (!description.equals(that.description)) return false;
            if (!ruleName.equals(that.ruleName)) return false;
            if (!ruleOrder.equals(that.ruleOrder)) return false;
            if (this.ruleStatus != null ? !this.ruleStatus.equals(that.ruleStatus) : that.ruleStatus != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.actions.hashCode();
            result = 31 * result + (this.criteria.hashCode());
            result = 31 * result + (this.description.hashCode());
            result = 31 * result + (this.ruleName.hashCode());
            result = 31 * result + (this.ruleOrder.hashCode());
            result = 31 * result + (this.ruleStatus != null ? this.ruleStatus.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
