package software.amazon.awscdk.services.securitylake;

/**
 * Properties for defining a <code>CfnAwsLogSource</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securitylake.*;
 * CfnAwsLogSourceProps cfnAwsLogSourceProps = CfnAwsLogSourceProps.builder()
 *         .dataLakeArn("dataLakeArn")
 *         .sourceName("sourceName")
 *         .sourceVersion("sourceVersion")
 *         // the properties below are optional
 *         .accounts(List.of("accounts"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-awslogsource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-awslogsource.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:44.519Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securitylake.CfnAwsLogSourceProps")
@software.amazon.jsii.Jsii.Proxy(CfnAwsLogSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAwsLogSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) used to create the data lake.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-awslogsource.html#cfn-securitylake-awslogsource-datalakearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-awslogsource.html#cfn-securitylake-awslogsource-datalakearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataLakeArn();

    /**
     * The name for a AWS source.
     * <p>
     * This must be a Regionally unique value. For the list of sources supported by Amazon Security Lake see <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/internal-sources.html">Collecting data from AWS services</a> in the Amazon Security Lake User Guide.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-awslogsource.html#cfn-securitylake-awslogsource-sourcename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-awslogsource.html#cfn-securitylake-awslogsource-sourcename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceName();

    /**
     * The version for a AWS source.
     * <p>
     * For more details about source versions supported by Amazon Security Lake see <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/open-cybersecurity-schema-framework.html#ocsf-source-identification">OCSF source identification</a> in the Amazon Security Lake User Guide. This must be a Regionally unique value.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-awslogsource.html#cfn-securitylake-awslogsource-sourceversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-awslogsource.html#cfn-securitylake-awslogsource-sourceversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceVersion();

    /**
     * Specify the AWS account information where you want to enable Security Lake.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-awslogsource.html#cfn-securitylake-awslogsource-accounts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-awslogsource.html#cfn-securitylake-awslogsource-accounts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAccounts() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAwsLogSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAwsLogSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAwsLogSourceProps> {
        java.lang.String dataLakeArn;
        java.lang.String sourceName;
        java.lang.String sourceVersion;
        java.util.List<java.lang.String> accounts;

        /**
         * Sets the value of {@link CfnAwsLogSourceProps#getDataLakeArn}
         * @param dataLakeArn The Amazon Resource Name (ARN) used to create the data lake. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataLakeArn(java.lang.String dataLakeArn) {
            this.dataLakeArn = dataLakeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAwsLogSourceProps#getSourceName}
         * @param sourceName The name for a AWS source. This parameter is required.
         *                   This must be a Regionally unique value. For the list of sources supported by Amazon Security Lake see <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/internal-sources.html">Collecting data from AWS services</a> in the Amazon Security Lake User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceName(java.lang.String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAwsLogSourceProps#getSourceVersion}
         * @param sourceVersion The version for a AWS source. This parameter is required.
         *                      For more details about source versions supported by Amazon Security Lake see <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/open-cybersecurity-schema-framework.html#ocsf-source-identification">OCSF source identification</a> in the Amazon Security Lake User Guide. This must be a Regionally unique value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceVersion(java.lang.String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnAwsLogSourceProps#getAccounts}
         * @param accounts Specify the AWS account information where you want to enable Security Lake.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accounts(java.util.List<java.lang.String> accounts) {
            this.accounts = accounts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAwsLogSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAwsLogSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAwsLogSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAwsLogSourceProps {
        private final java.lang.String dataLakeArn;
        private final java.lang.String sourceName;
        private final java.lang.String sourceVersion;
        private final java.util.List<java.lang.String> accounts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataLakeArn = software.amazon.jsii.Kernel.get(this, "dataLakeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceName = software.amazon.jsii.Kernel.get(this, "sourceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sourceVersion = software.amazon.jsii.Kernel.get(this, "sourceVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accounts = software.amazon.jsii.Kernel.get(this, "accounts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataLakeArn = java.util.Objects.requireNonNull(builder.dataLakeArn, "dataLakeArn is required");
            this.sourceName = java.util.Objects.requireNonNull(builder.sourceName, "sourceName is required");
            this.sourceVersion = java.util.Objects.requireNonNull(builder.sourceVersion, "sourceVersion is required");
            this.accounts = builder.accounts;
        }

        @Override
        public final java.lang.String getDataLakeArn() {
            return this.dataLakeArn;
        }

        @Override
        public final java.lang.String getSourceName() {
            return this.sourceName;
        }

        @Override
        public final java.lang.String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public final java.util.List<java.lang.String> getAccounts() {
            return this.accounts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataLakeArn", om.valueToTree(this.getDataLakeArn()));
            data.set("sourceName", om.valueToTree(this.getSourceName()));
            data.set("sourceVersion", om.valueToTree(this.getSourceVersion()));
            if (this.getAccounts() != null) {
                data.set("accounts", om.valueToTree(this.getAccounts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securitylake.CfnAwsLogSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAwsLogSourceProps.Jsii$Proxy that = (CfnAwsLogSourceProps.Jsii$Proxy) o;

            if (!dataLakeArn.equals(that.dataLakeArn)) return false;
            if (!sourceName.equals(that.sourceName)) return false;
            if (!sourceVersion.equals(that.sourceVersion)) return false;
            return this.accounts != null ? this.accounts.equals(that.accounts) : that.accounts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataLakeArn.hashCode();
            result = 31 * result + (this.sourceName.hashCode());
            result = 31 * result + (this.sourceVersion.hashCode());
            result = 31 * result + (this.accounts != null ? this.accounts.hashCode() : 0);
            return result;
        }
    }
}
