package software.amazon.awscdk.services.servicecatalog;

/**
 * Represents the Product Provisioning Artifact Template.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * public class S3BucketProduct extends ProductStack {
 *     public S3BucketProduct(Construct scope, String id) {
 *         super(scope, id);
 *         new Bucket(this, "BucketProduct");
 *     }
 * }
 * CloudFormationProduct product = CloudFormationProduct.Builder.create(this, "Product")
 *         .productName("My Product")
 *         .owner("Product Owner")
 *         .productVersions(List.of(CloudFormationProductVersion.builder()
 *                 .productVersionName("v1")
 *                 .cloudFormationTemplate(CloudFormationTemplate.fromProductStack(new S3BucketProduct(this, "S3BucketProduct")))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:44.578Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicecatalog.CloudFormationTemplate")
public abstract class CloudFormationTemplate extends software.amazon.jsii.JsiiObject {

    protected CloudFormationTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CloudFormationTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected CloudFormationTemplate() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Loads the provisioning artifacts template from a local disk path.
     * <p>
     * @param path A file containing the provisioning artifacts. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Loads the provisioning artifacts template from a local disk path.
     * <p>
     * @param path A file containing the provisioning artifacts. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Creates a product with the resources defined in the given product stack.
     * <p>
     * @param productStack This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate fromProductStack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.ProductStack productStack) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate.class, "fromProductStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate.class), new Object[] { java.util.Objects.requireNonNull(productStack, "productStack is required") });
    }

    /**
     * Template from URL.
     * <p>
     * @param url The url that points to the provisioning artifacts template. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate fromUrl(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate.class, "fromUrl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * Called when the product is initialized to allow this object to bind to the stack, add resources and have fun.
     * <p>
     * @param scope The binding scope. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationTemplateConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.servicecatalog.CloudFormationTemplate {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the product is initialized to allow this object to bind to the stack, add resources and have fun.
         * <p>
         * @param scope The binding scope. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicecatalog.CloudFormationTemplateConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicecatalog.CloudFormationTemplateConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
