package software.amazon.awscdk.services.stepfunctions;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Pass jsonata = Pass.jsonata(this, "JSONata");
 * Pass jsonPath = Pass.jsonPath(this, "JSONPath");
 * Chain definition = jsonata.next(jsonPath);
 * StateMachine.Builder.create(this, "MixedStateMachine")
 *         // queryLanguage: sfn.QueryLanguage.JSON_PATH, // default
 *         .definitionBody(DefinitionBody.fromChainable(definition))
 *         .build();
 * // This throws an error. If JSONata is specified at the top level, JSONPath cannot be used in the state machine definition.
 * // This throws an error. If JSONata is specified at the top level, JSONPath cannot be used in the state machine definition.
 * StateMachine.Builder.create(this, "JSONataOnlyStateMachine")
 *         .queryLanguage(QueryLanguage.JSONATA)
 *         .definitionBody(DefinitionBody.fromChainable(definition))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:45.127Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.DefinitionBody")
public abstract class DefinitionBody extends software.amazon.jsii.JsiiObject {

    protected DefinitionBody(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DefinitionBody(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected DefinitionBody() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * @param chainable This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.DefinitionBody fromChainable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable chainable) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.DefinitionBody.class, "fromChainable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.DefinitionBody.class), new Object[] { java.util.Objects.requireNonNull(chainable, "chainable is required") });
    }

    /**
     * @param path This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.DefinitionBody fromFile(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.DefinitionBody.class, "fromFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.DefinitionBody.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * @param path This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.DefinitionBody fromFile(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.DefinitionBody.class, "fromFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.DefinitionBody.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * @param definition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.DefinitionBody fromString(final @org.jetbrains.annotations.NotNull java.lang.String definition) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.DefinitionBody.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.DefinitionBody.class), new Object[] { java.util.Objects.requireNonNull(definition, "definition is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param sfnPrincipal This parameter is required.
     * @param sfnProps This parameter is required.
     * @param graph
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.DefinitionConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal sfnPrincipal, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateMachineProps sfnProps, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateGraph graph);

    /**
     * @param scope This parameter is required.
     * @param sfnPrincipal This parameter is required.
     * @param sfnProps This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.DefinitionConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal sfnPrincipal, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateMachineProps sfnProps);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.stepfunctions.DefinitionBody {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * @param scope This parameter is required.
         * @param sfnPrincipal This parameter is required.
         * @param sfnProps This parameter is required.
         * @param graph
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.DefinitionConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal sfnPrincipal, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateMachineProps sfnProps, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.DefinitionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(sfnPrincipal, "sfnPrincipal is required"), java.util.Objects.requireNonNull(sfnProps, "sfnProps is required"), graph });
        }

        /**
         * @param scope This parameter is required.
         * @param sfnPrincipal This parameter is required.
         * @param sfnProps This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.DefinitionConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal sfnPrincipal, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateMachineProps sfnProps) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.DefinitionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(sfnPrincipal, "sfnPrincipal is required"), java.util.Objects.requireNonNull(sfnProps, "sfnProps is required") });
        }
    }
}
