package software.amazon.awscdk.services.stepfunctions;

/**
 * Execution type for the Map workflow.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Map map = Map.Builder.create(this, "Map State")
 *         .maxConcurrency(1)
 *         .itemsPath(JsonPath.stringAt("$.inputForMap"))
 *         .itemSelector(Map.of(
 *                 "item", JsonPath.stringAt("$.Map.Item.Value")))
 *         .resultPath("$.mapOutput")
 *         .build();
 * map.itemProcessor(new Pass(this, "Pass State"), ProcessorConfig.builder()
 *         .mode(ProcessorMode.DISTRIBUTED)
 *         .executionType(ProcessorType.STANDARD)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:45.178Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ProcessorType")
public enum ProcessorType {
    /**
     * Standard execution type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD,
    /**
     * Express execution type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXPRESS,
}
