package software.amazon.awscdk.services.stepfunctions;

/**
 * Configuration to format the output.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.*;
 * // create a bucket
 * Bucket bucket = new Bucket(this, "Bucket");
 * // create a WriterConfig
 * DistributedMap distributedMap = DistributedMap.Builder.create(this, "Distributed Map State")
 *         .resultWriterV2(ResultWriterV2.Builder.create()
 *                 .bucket(bucket)
 *                 .prefix("my-prefix")
 *                 .writerConfig(Map.of(
 *                         "outputType", OutputType.JSONL,
 *                         "transformation", Transformation.NONE))
 *                 .build())
 *         .build();
 * distributedMap.itemProcessor(new Pass(this, "Pass State"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:45.221Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.WriterConfig")
public class WriterConfig extends software.amazon.jsii.JsiiObject {

    protected WriterConfig(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WriterConfig(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public WriterConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.WriterConfigProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The format of the Output of the child workflow executions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.OutputType getOutputType() {
        return software.amazon.jsii.Kernel.get(this, "outputType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.OutputType.class));
    }

    /**
     * The transformation to be applied to the Output of the Child Workflow executions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Transformation getTransformation() {
        return software.amazon.jsii.Kernel.get(this, "transformation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Transformation.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.WriterConfig}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.WriterConfig> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.stepfunctions.WriterConfigProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.stepfunctions.WriterConfigProps.Builder();
        }

        /**
         * The format of the Output of the child workflow executions.
         * <p>
         * @return {@code this}
         * @param outputType The format of the Output of the child workflow executions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputType(final software.amazon.awscdk.services.stepfunctions.OutputType outputType) {
            this.props.outputType(outputType);
            return this;
        }

        /**
         * The transformation to be applied to the Output of the Child Workflow executions.
         * <p>
         * @return {@code this}
         * @param transformation The transformation to be applied to the Output of the Child Workflow executions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transformation(final software.amazon.awscdk.services.stepfunctions.Transformation transformation) {
            this.props.transformation(transformation);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.WriterConfig}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.WriterConfig build() {
            return new software.amazon.awscdk.services.stepfunctions.WriterConfig(
                this.props.build()
            );
        }
    }
}
