package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for calling an HTTP API Endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpApi httpApi = new HttpApi(this, "MyHttpApi");
 * CallApiGatewayHttpApiEndpoint invokeTask = CallApiGatewayHttpApiEndpoint.Builder.create(this, "Call HTTP API")
 *         .apiId(httpApi.getApiId())
 *         .apiStack(Stack.of(httpApi))
 *         .method(HttpMethod.GET)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:45.328Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.CallApiGatewayHttpApiEndpointProps")
@software.amazon.jsii.Jsii.Proxy(CallApiGatewayHttpApiEndpointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CallApiGatewayHttpApiEndpointProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.tasks.CallApiGatewayEndpointBaseProps, software.amazon.awscdk.services.stepfunctions.tasks.CallApiGatewayHttpApiEndpointOptions {

    /**
     * @return a {@link Builder} of {@link CallApiGatewayHttpApiEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CallApiGatewayHttpApiEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CallApiGatewayHttpApiEndpointProps> {
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        software.amazon.awscdk.Duration heartbeat;
        software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.lang.String inputPath;
        java.lang.String outputPath;
        java.lang.Object outputs;
        software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod method;
        java.lang.String apiPath;
        software.amazon.awscdk.services.stepfunctions.tasks.AuthType authType;
        software.amazon.awscdk.services.stepfunctions.TaskInput headers;
        software.amazon.awscdk.services.stepfunctions.TaskInput queryParameters;
        software.amazon.awscdk.services.stepfunctions.TaskInput requestBody;
        java.lang.String apiId;
        software.amazon.awscdk.Stack apiStack;
        java.lang.String stageName;

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getCredentials}
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task.
         *                    This enables cross-account resource invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         * @deprecated use `heartbeatTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Timeout for the heartbeat.
         *                         [disable-awslint:duration-prop-type] is needed because all props interface in
         *                         aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns.
         *                           <p>
         *                           Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getTaskTimeout}
         * @param taskTimeout Timeout for the task.
         *                    [disable-awslint:duration-prop-type] is needed because all props interface in
         *                    aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getTimeout}
         * @param timeout Timeout for the task.
         * @return {@code this}
         * @deprecated use `taskTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getOutputPath}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getMethod}
         * @param method Http method for the API. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getApiPath}
         * @param apiPath Path parameters appended after API endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiPath(java.lang.String apiPath) {
            this.apiPath = apiPath;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getAuthType}
         * @param authType Authentication methods.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(software.amazon.awscdk.services.stepfunctions.tasks.AuthType authType) {
            this.authType = authType;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getHeaders}
         * @param headers HTTP request information that does not relate to contents of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headers(software.amazon.awscdk.services.stepfunctions.TaskInput headers) {
            this.headers = headers;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getQueryParameters}
         * @param queryParameters Query strings attatched to end of request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryParameters(software.amazon.awscdk.services.stepfunctions.TaskInput queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getRequestBody}
         * @param requestBody HTTP Request body.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestBody(software.amazon.awscdk.services.stepfunctions.TaskInput requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getApiId}
         * @param apiId The Id of the API to call. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getApiStack}
         * @param apiStack The Stack in which the API is defined. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStack(software.amazon.awscdk.Stack apiStack) {
            this.apiStack = apiStack;
            return this;
        }

        /**
         * Sets the value of {@link CallApiGatewayHttpApiEndpointProps#getStageName}
         * @param stageName Name of the stage where the API is deployed to in API Gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CallApiGatewayHttpApiEndpointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CallApiGatewayHttpApiEndpointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CallApiGatewayHttpApiEndpointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CallApiGatewayHttpApiEndpointProps {
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        private final software.amazon.awscdk.Duration heartbeat;
        private final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.lang.String inputPath;
        private final java.lang.String outputPath;
        private final java.lang.Object outputs;
        private final software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod method;
        private final java.lang.String apiPath;
        private final software.amazon.awscdk.services.stepfunctions.tasks.AuthType authType;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput headers;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput queryParameters;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput requestBody;
        private final java.lang.String apiId;
        private final software.amazon.awscdk.Stack apiStack;
        private final java.lang.String stageName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Credentials.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.taskTimeout = software.amazon.jsii.Kernel.get(this, "taskTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod.class));
            this.apiPath = software.amazon.jsii.Kernel.get(this, "apiPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authType = software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.AuthType.class));
            this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.queryParameters = software.amazon.jsii.Kernel.get(this, "queryParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.requestBody = software.amazon.jsii.Kernel.get(this, "requestBody", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiStack = software.amazon.jsii.Kernel.get(this, "apiStack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
            this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.credentials = builder.credentials;
            this.heartbeat = builder.heartbeat;
            this.heartbeatTimeout = builder.heartbeatTimeout;
            this.integrationPattern = builder.integrationPattern;
            this.taskTimeout = builder.taskTimeout;
            this.timeout = builder.timeout;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.inputPath = builder.inputPath;
            this.outputPath = builder.outputPath;
            this.outputs = builder.outputs;
            this.method = java.util.Objects.requireNonNull(builder.method, "method is required");
            this.apiPath = builder.apiPath;
            this.authType = builder.authType;
            this.headers = builder.headers;
            this.queryParameters = builder.queryParameters;
            this.requestBody = builder.requestBody;
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.apiStack = java.util.Objects.requireNonNull(builder.apiStack, "apiStack is required");
            this.stageName = builder.stageName;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getTaskTimeout() {
            return this.taskTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.HttpMethod getMethod() {
            return this.method;
        }

        @Override
        public final java.lang.String getApiPath() {
            return this.apiPath;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.AuthType getAuthType() {
            return this.authType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getHeaders() {
            return this.headers;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getQueryParameters() {
            return this.queryParameters;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getRequestBody() {
            return this.requestBody;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final software.amazon.awscdk.Stack getApiStack() {
            return this.apiStack;
        }

        @Override
        public final java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getTaskTimeout() != null) {
                data.set("taskTimeout", om.valueToTree(this.getTaskTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            data.set("method", om.valueToTree(this.getMethod()));
            if (this.getApiPath() != null) {
                data.set("apiPath", om.valueToTree(this.getApiPath()));
            }
            if (this.getAuthType() != null) {
                data.set("authType", om.valueToTree(this.getAuthType()));
            }
            if (this.getHeaders() != null) {
                data.set("headers", om.valueToTree(this.getHeaders()));
            }
            if (this.getQueryParameters() != null) {
                data.set("queryParameters", om.valueToTree(this.getQueryParameters()));
            }
            if (this.getRequestBody() != null) {
                data.set("requestBody", om.valueToTree(this.getRequestBody()));
            }
            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("apiStack", om.valueToTree(this.getApiStack()));
            if (this.getStageName() != null) {
                data.set("stageName", om.valueToTree(this.getStageName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.CallApiGatewayHttpApiEndpointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CallApiGatewayHttpApiEndpointProps.Jsii$Proxy that = (CallApiGatewayHttpApiEndpointProps.Jsii$Proxy) o;

            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.taskTimeout != null ? !this.taskTimeout.equals(that.taskTimeout) : that.taskTimeout != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            if (!method.equals(that.method)) return false;
            if (this.apiPath != null ? !this.apiPath.equals(that.apiPath) : that.apiPath != null) return false;
            if (this.authType != null ? !this.authType.equals(that.authType) : that.authType != null) return false;
            if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
            if (this.queryParameters != null ? !this.queryParameters.equals(that.queryParameters) : that.queryParameters != null) return false;
            if (this.requestBody != null ? !this.requestBody.equals(that.requestBody) : that.requestBody != null) return false;
            if (!apiId.equals(that.apiId)) return false;
            if (!apiStack.equals(that.apiStack)) return false;
            return this.stageName != null ? this.stageName.equals(that.stageName) : that.stageName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resultPath != null ? this.resultPath.hashCode() : 0;
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.taskTimeout != null ? this.taskTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.method.hashCode());
            result = 31 * result + (this.apiPath != null ? this.apiPath.hashCode() : 0);
            result = 31 * result + (this.authType != null ? this.authType.hashCode() : 0);
            result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
            result = 31 * result + (this.queryParameters != null ? this.queryParameters.hashCode() : 0);
            result = 31 * result + (this.requestBody != null ? this.requestBody.hashCode() : 0);
            result = 31 * result + (this.apiId.hashCode());
            result = 31 * result + (this.apiStack.hashCode());
            result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
            return result;
        }
    }
}
