package software.amazon.awscdk.services.timestream;

/**
 * The CreateTable operation adds a new table to an existing database in your account.
 * <p>
 * In an AWS account, table names must be at least unique within each Region if they are in the same database. You may have identical table names in the same Region if the tables are in separate databases. While creating the table, you must specify the table name, database name, and the retention properties. <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Service quotas apply</a> . See <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/code-samples.create-table.html">code sample</a> for details.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.timestream.*;
 * Object magneticStoreWriteProperties;
 * Object retentionProperties;
 * CfnTable cfnTable = CfnTable.Builder.create(this, "MyCfnTable")
 *         .databaseName("databaseName")
 *         // the properties below are optional
 *         .magneticStoreWriteProperties(magneticStoreWriteProperties)
 *         .retentionProperties(retentionProperties)
 *         .schema(SchemaProperty.builder()
 *                 .compositePartitionKey(List.of(PartitionKeyProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .enforcementInRecord("enforcementInRecord")
 *                         .name("name")
 *                         .build()))
 *                 .build())
 *         .tableName("tableName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:45.796Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnTable")
public class CfnTable extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnTable(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTable(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.timestream.CfnTable.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTable(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.timestream.CfnTableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The <code>arn</code> of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the Timestream database that contains this table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName() {
        return software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Timestream database that contains this table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatabaseName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "databaseName", java.util.Objects.requireNonNull(value, "databaseName is required"));
    }

    /**
     * Contains properties to set on the table when enabling magnetic store writes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMagneticStoreWriteProperties() {
        return software.amazon.jsii.Kernel.get(this, "magneticStoreWriteProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains properties to set on the table when enabling magnetic store writes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMagneticStoreWriteProperties(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "magneticStoreWriteProperties", value);
    }

    /**
     * The retention duration for the memory store and magnetic store.
     * <p>
     * This object has the following attributes:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRetentionProperties() {
        return software.amazon.jsii.Kernel.get(this, "retentionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The retention duration for the memory store and magnetic store.
     * <p>
     * This object has the following attributes:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRetentionProperties(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "retentionProperties", value);
    }

    /**
     * The schema of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchema() {
        return software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The schema of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchema(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schema", value);
    }

    /**
     * The schema of the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchema(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.timestream.CfnTable.SchemaProperty value) {
        software.amazon.jsii.Kernel.set(this, "schema", value);
    }

    /**
     * The name of the Timestream table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Timestream table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTableName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tableName", value);
    }

    /**
     * The tags to add to the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags to add to the table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The location to write error reports for records rejected, asynchronously, during magnetic store writes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * MagneticStoreRejectedDataLocationProperty magneticStoreRejectedDataLocationProperty = MagneticStoreRejectedDataLocationProperty.builder()
     *         .s3Configuration(S3ConfigurationProperty.builder()
     *                 .bucketName("bucketName")
     *                 .encryptionOption("encryptionOption")
     *                 // the properties below are optional
     *                 .kmsKeyId("kmsKeyId")
     *                 .objectKeyPrefix("objectKeyPrefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-magneticstorerejecteddatalocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-magneticstorerejecteddatalocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnTable.MagneticStoreRejectedDataLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(MagneticStoreRejectedDataLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MagneticStoreRejectedDataLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-magneticstorerejecteddatalocation.html#cfn-timestream-table-magneticstorerejecteddatalocation-s3configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-magneticstorerejecteddatalocation.html#cfn-timestream-table-magneticstorerejecteddatalocation-s3configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Configuration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MagneticStoreRejectedDataLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MagneticStoreRejectedDataLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MagneticStoreRejectedDataLocationProperty> {
            java.lang.Object s3Configuration;

            /**
             * Sets the value of {@link MagneticStoreRejectedDataLocationProperty#getS3Configuration}
             * @param s3Configuration Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.IResolvable s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Sets the value of {@link MagneticStoreRejectedDataLocationProperty#getS3Configuration}
             * @param s3Configuration Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic store writes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Configuration(software.amazon.awscdk.services.timestream.CfnTable.S3ConfigurationProperty s3Configuration) {
                this.s3Configuration = s3Configuration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MagneticStoreRejectedDataLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MagneticStoreRejectedDataLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MagneticStoreRejectedDataLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MagneticStoreRejectedDataLocationProperty {
            private final java.lang.Object s3Configuration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Configuration = software.amazon.jsii.Kernel.get(this, "s3Configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Configuration = builder.s3Configuration;
            }

            @Override
            public final java.lang.Object getS3Configuration() {
                return this.s3Configuration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3Configuration() != null) {
                    data.set("s3Configuration", om.valueToTree(this.getS3Configuration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnTable.MagneticStoreRejectedDataLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MagneticStoreRejectedDataLocationProperty.Jsii$Proxy that = (MagneticStoreRejectedDataLocationProperty.Jsii$Proxy) o;

                return this.s3Configuration != null ? this.s3Configuration.equals(that.s3Configuration) : that.s3Configuration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Configuration != null ? this.s3Configuration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The set of properties on a table for configuring magnetic store writes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * MagneticStoreWritePropertiesProperty magneticStoreWritePropertiesProperty = MagneticStoreWritePropertiesProperty.builder()
     *         .enableMagneticStoreWrites(false)
     *         // the properties below are optional
     *         .magneticStoreRejectedDataLocation(MagneticStoreRejectedDataLocationProperty.builder()
     *                 .s3Configuration(S3ConfigurationProperty.builder()
     *                         .bucketName("bucketName")
     *                         .encryptionOption("encryptionOption")
     *                         // the properties below are optional
     *                         .kmsKeyId("kmsKeyId")
     *                         .objectKeyPrefix("objectKeyPrefix")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-magneticstorewriteproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-magneticstorewriteproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnTable.MagneticStoreWritePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MagneticStoreWritePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MagneticStoreWritePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A flag to enable magnetic store writes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-magneticstorewriteproperties.html#cfn-timestream-table-magneticstorewriteproperties-enablemagneticstorewrites">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-magneticstorewriteproperties.html#cfn-timestream-table-magneticstorewriteproperties-enablemagneticstorewrites</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnableMagneticStoreWrites();

        /**
         * The location to write error reports for records rejected asynchronously during magnetic store writes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-magneticstorewriteproperties.html#cfn-timestream-table-magneticstorewriteproperties-magneticstorerejecteddatalocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-magneticstorewriteproperties.html#cfn-timestream-table-magneticstorewriteproperties-magneticstorerejecteddatalocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMagneticStoreRejectedDataLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MagneticStoreWritePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MagneticStoreWritePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MagneticStoreWritePropertiesProperty> {
            java.lang.Object enableMagneticStoreWrites;
            java.lang.Object magneticStoreRejectedDataLocation;

            /**
             * Sets the value of {@link MagneticStoreWritePropertiesProperty#getEnableMagneticStoreWrites}
             * @param enableMagneticStoreWrites A flag to enable magnetic store writes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableMagneticStoreWrites(java.lang.Boolean enableMagneticStoreWrites) {
                this.enableMagneticStoreWrites = enableMagneticStoreWrites;
                return this;
            }

            /**
             * Sets the value of {@link MagneticStoreWritePropertiesProperty#getEnableMagneticStoreWrites}
             * @param enableMagneticStoreWrites A flag to enable magnetic store writes. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableMagneticStoreWrites(software.amazon.awscdk.IResolvable enableMagneticStoreWrites) {
                this.enableMagneticStoreWrites = enableMagneticStoreWrites;
                return this;
            }

            /**
             * Sets the value of {@link MagneticStoreWritePropertiesProperty#getMagneticStoreRejectedDataLocation}
             * @param magneticStoreRejectedDataLocation The location to write error reports for records rejected asynchronously during magnetic store writes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder magneticStoreRejectedDataLocation(software.amazon.awscdk.IResolvable magneticStoreRejectedDataLocation) {
                this.magneticStoreRejectedDataLocation = magneticStoreRejectedDataLocation;
                return this;
            }

            /**
             * Sets the value of {@link MagneticStoreWritePropertiesProperty#getMagneticStoreRejectedDataLocation}
             * @param magneticStoreRejectedDataLocation The location to write error reports for records rejected asynchronously during magnetic store writes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder magneticStoreRejectedDataLocation(software.amazon.awscdk.services.timestream.CfnTable.MagneticStoreRejectedDataLocationProperty magneticStoreRejectedDataLocation) {
                this.magneticStoreRejectedDataLocation = magneticStoreRejectedDataLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MagneticStoreWritePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MagneticStoreWritePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MagneticStoreWritePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MagneticStoreWritePropertiesProperty {
            private final java.lang.Object enableMagneticStoreWrites;
            private final java.lang.Object magneticStoreRejectedDataLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enableMagneticStoreWrites = software.amazon.jsii.Kernel.get(this, "enableMagneticStoreWrites", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.magneticStoreRejectedDataLocation = software.amazon.jsii.Kernel.get(this, "magneticStoreRejectedDataLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enableMagneticStoreWrites = java.util.Objects.requireNonNull(builder.enableMagneticStoreWrites, "enableMagneticStoreWrites is required");
                this.magneticStoreRejectedDataLocation = builder.magneticStoreRejectedDataLocation;
            }

            @Override
            public final java.lang.Object getEnableMagneticStoreWrites() {
                return this.enableMagneticStoreWrites;
            }

            @Override
            public final java.lang.Object getMagneticStoreRejectedDataLocation() {
                return this.magneticStoreRejectedDataLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enableMagneticStoreWrites", om.valueToTree(this.getEnableMagneticStoreWrites()));
                if (this.getMagneticStoreRejectedDataLocation() != null) {
                    data.set("magneticStoreRejectedDataLocation", om.valueToTree(this.getMagneticStoreRejectedDataLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnTable.MagneticStoreWritePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MagneticStoreWritePropertiesProperty.Jsii$Proxy that = (MagneticStoreWritePropertiesProperty.Jsii$Proxy) o;

                if (!enableMagneticStoreWrites.equals(that.enableMagneticStoreWrites)) return false;
                return this.magneticStoreRejectedDataLocation != null ? this.magneticStoreRejectedDataLocation.equals(that.magneticStoreRejectedDataLocation) : that.magneticStoreRejectedDataLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enableMagneticStoreWrites.hashCode();
                result = 31 * result + (this.magneticStoreRejectedDataLocation != null ? this.magneticStoreRejectedDataLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An attribute used in partitioning data in a table.
     * <p>
     * A dimension key partitions data using the values of the dimension specified by the dimension-name as partition key, while a measure key partitions data using measure names (values of the 'measure_name' column).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * PartitionKeyProperty partitionKeyProperty = PartitionKeyProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .enforcementInRecord("enforcementInRecord")
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-partitionkey.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-partitionkey.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnTable.PartitionKeyProperty")
    @software.amazon.jsii.Jsii.Proxy(PartitionKeyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PartitionKeyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the partition key.
         * <p>
         * Options are DIMENSION (dimension key) and MEASURE (measure key).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-partitionkey.html#cfn-timestream-table-partitionkey-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-partitionkey.html#cfn-timestream-table-partitionkey-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The level of enforcement for the specification of a dimension key in ingested records.
         * <p>
         * Options are REQUIRED (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-partitionkey.html#cfn-timestream-table-partitionkey-enforcementinrecord">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-partitionkey.html#cfn-timestream-table-partitionkey-enforcementinrecord</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEnforcementInRecord() {
            return null;
        }

        /**
         * The name of the attribute used for a dimension key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-partitionkey.html#cfn-timestream-table-partitionkey-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-partitionkey.html#cfn-timestream-table-partitionkey-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PartitionKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PartitionKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PartitionKeyProperty> {
            java.lang.String type;
            java.lang.String enforcementInRecord;
            java.lang.String name;

            /**
             * Sets the value of {@link PartitionKeyProperty#getType}
             * @param type The type of the partition key. This parameter is required.
             *             Options are DIMENSION (dimension key) and MEASURE (measure key).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link PartitionKeyProperty#getEnforcementInRecord}
             * @param enforcementInRecord The level of enforcement for the specification of a dimension key in ingested records.
             *                            Options are REQUIRED (dimension key must be specified) and OPTIONAL (dimension key does not have to be specified).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforcementInRecord(java.lang.String enforcementInRecord) {
                this.enforcementInRecord = enforcementInRecord;
                return this;
            }

            /**
             * Sets the value of {@link PartitionKeyProperty#getName}
             * @param name The name of the attribute used for a dimension key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PartitionKeyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PartitionKeyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PartitionKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PartitionKeyProperty {
            private final java.lang.String type;
            private final java.lang.String enforcementInRecord;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enforcementInRecord = software.amazon.jsii.Kernel.get(this, "enforcementInRecord", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.enforcementInRecord = builder.enforcementInRecord;
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getEnforcementInRecord() {
                return this.enforcementInRecord;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getEnforcementInRecord() != null) {
                    data.set("enforcementInRecord", om.valueToTree(this.getEnforcementInRecord()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnTable.PartitionKeyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PartitionKeyProperty.Jsii$Proxy that = (PartitionKeyProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.enforcementInRecord != null ? !this.enforcementInRecord.equals(that.enforcementInRecord) : that.enforcementInRecord != null) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.enforcementInRecord != null ? this.enforcementInRecord.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Retention properties contain the duration for which your time-series data must be stored in the magnetic store and the memory store.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * RetentionPropertiesProperty retentionPropertiesProperty = RetentionPropertiesProperty.builder()
     *         .magneticStoreRetentionPeriodInDays("magneticStoreRetentionPeriodInDays")
     *         .memoryStoreRetentionPeriodInHours("memoryStoreRetentionPeriodInHours")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-retentionproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-retentionproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnTable.RetentionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(RetentionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetentionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The duration for which data must be stored in the magnetic store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-retentionproperties.html#cfn-timestream-table-retentionproperties-magneticstoreretentionperiodindays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-retentionproperties.html#cfn-timestream-table-retentionproperties-magneticstoreretentionperiodindays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMagneticStoreRetentionPeriodInDays() {
            return null;
        }

        /**
         * The duration for which data must be stored in the memory store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-retentionproperties.html#cfn-timestream-table-retentionproperties-memorystoreretentionperiodinhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-retentionproperties.html#cfn-timestream-table-retentionproperties-memorystoreretentionperiodinhours</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMemoryStoreRetentionPeriodInHours() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetentionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetentionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetentionPropertiesProperty> {
            java.lang.String magneticStoreRetentionPeriodInDays;
            java.lang.String memoryStoreRetentionPeriodInHours;

            /**
             * Sets the value of {@link RetentionPropertiesProperty#getMagneticStoreRetentionPeriodInDays}
             * @param magneticStoreRetentionPeriodInDays The duration for which data must be stored in the magnetic store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder magneticStoreRetentionPeriodInDays(java.lang.String magneticStoreRetentionPeriodInDays) {
                this.magneticStoreRetentionPeriodInDays = magneticStoreRetentionPeriodInDays;
                return this;
            }

            /**
             * Sets the value of {@link RetentionPropertiesProperty#getMemoryStoreRetentionPeriodInHours}
             * @param memoryStoreRetentionPeriodInHours The duration for which data must be stored in the memory store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memoryStoreRetentionPeriodInHours(java.lang.String memoryStoreRetentionPeriodInHours) {
                this.memoryStoreRetentionPeriodInHours = memoryStoreRetentionPeriodInHours;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetentionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetentionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetentionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetentionPropertiesProperty {
            private final java.lang.String magneticStoreRetentionPeriodInDays;
            private final java.lang.String memoryStoreRetentionPeriodInHours;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.magneticStoreRetentionPeriodInDays = software.amazon.jsii.Kernel.get(this, "magneticStoreRetentionPeriodInDays", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memoryStoreRetentionPeriodInHours = software.amazon.jsii.Kernel.get(this, "memoryStoreRetentionPeriodInHours", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.magneticStoreRetentionPeriodInDays = builder.magneticStoreRetentionPeriodInDays;
                this.memoryStoreRetentionPeriodInHours = builder.memoryStoreRetentionPeriodInHours;
            }

            @Override
            public final java.lang.String getMagneticStoreRetentionPeriodInDays() {
                return this.magneticStoreRetentionPeriodInDays;
            }

            @Override
            public final java.lang.String getMemoryStoreRetentionPeriodInHours() {
                return this.memoryStoreRetentionPeriodInHours;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMagneticStoreRetentionPeriodInDays() != null) {
                    data.set("magneticStoreRetentionPeriodInDays", om.valueToTree(this.getMagneticStoreRetentionPeriodInDays()));
                }
                if (this.getMemoryStoreRetentionPeriodInHours() != null) {
                    data.set("memoryStoreRetentionPeriodInHours", om.valueToTree(this.getMemoryStoreRetentionPeriodInHours()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnTable.RetentionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetentionPropertiesProperty.Jsii$Proxy that = (RetentionPropertiesProperty.Jsii$Proxy) o;

                if (this.magneticStoreRetentionPeriodInDays != null ? !this.magneticStoreRetentionPeriodInDays.equals(that.magneticStoreRetentionPeriodInDays) : that.magneticStoreRetentionPeriodInDays != null) return false;
                return this.memoryStoreRetentionPeriodInHours != null ? this.memoryStoreRetentionPeriodInHours.equals(that.memoryStoreRetentionPeriodInHours) : that.memoryStoreRetentionPeriodInHours == null;
            }

            @Override
            public final int hashCode() {
                int result = this.magneticStoreRetentionPeriodInDays != null ? this.magneticStoreRetentionPeriodInDays.hashCode() : 0;
                result = 31 * result + (this.memoryStoreRetentionPeriodInHours != null ? this.memoryStoreRetentionPeriodInHours.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that specifies an S3 location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * S3ConfigurationProperty s3ConfigurationProperty = S3ConfigurationProperty.builder()
     *         .bucketName("bucketName")
     *         .encryptionOption("encryptionOption")
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .objectKeyPrefix("objectKeyPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-s3configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-s3configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnTable.S3ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The bucket name of the customer S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-s3configuration.html#cfn-timestream-table-s3configuration-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-s3configuration.html#cfn-timestream-table-s3configuration-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The encryption option for the customer S3 location.
         * <p>
         * Options are S3 server-side encryption with an S3 managed key or AWS managed key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-s3configuration.html#cfn-timestream-table-s3configuration-encryptionoption">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-s3configuration.html#cfn-timestream-table-s3configuration-encryptionoption</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEncryptionOption();

        /**
         * The AWS KMS key ID for the customer S3 location when encrypting with an AWS managed key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-s3configuration.html#cfn-timestream-table-s3configuration-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-s3configuration.html#cfn-timestream-table-s3configuration-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The object key preview for the customer S3 location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-s3configuration.html#cfn-timestream-table-s3configuration-objectkeyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-s3configuration.html#cfn-timestream-table-s3configuration-objectkeyprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObjectKeyPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ConfigurationProperty> {
            java.lang.String bucketName;
            java.lang.String encryptionOption;
            java.lang.String kmsKeyId;
            java.lang.String objectKeyPrefix;

            /**
             * Sets the value of {@link S3ConfigurationProperty#getBucketName}
             * @param bucketName The bucket name of the customer S3 bucket. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigurationProperty#getEncryptionOption}
             * @param encryptionOption The encryption option for the customer S3 location. This parameter is required.
             *                         Options are S3 server-side encryption with an S3 managed key or AWS managed key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionOption(java.lang.String encryptionOption) {
                this.encryptionOption = encryptionOption;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId The AWS KMS key ID for the customer S3 location when encrypting with an AWS managed key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link S3ConfigurationProperty#getObjectKeyPrefix}
             * @param objectKeyPrefix The object key preview for the customer S3 location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectKeyPrefix(java.lang.String objectKeyPrefix) {
                this.objectKeyPrefix = objectKeyPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ConfigurationProperty {
            private final java.lang.String bucketName;
            private final java.lang.String encryptionOption;
            private final java.lang.String kmsKeyId;
            private final java.lang.String objectKeyPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionOption = software.amazon.jsii.Kernel.get(this, "encryptionOption", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.objectKeyPrefix = software.amazon.jsii.Kernel.get(this, "objectKeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.encryptionOption = java.util.Objects.requireNonNull(builder.encryptionOption, "encryptionOption is required");
                this.kmsKeyId = builder.kmsKeyId;
                this.objectKeyPrefix = builder.objectKeyPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getEncryptionOption() {
                return this.encryptionOption;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.String getObjectKeyPrefix() {
                return this.objectKeyPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("encryptionOption", om.valueToTree(this.getEncryptionOption()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getObjectKeyPrefix() != null) {
                    data.set("objectKeyPrefix", om.valueToTree(this.getObjectKeyPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnTable.S3ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ConfigurationProperty.Jsii$Proxy that = (S3ConfigurationProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!encryptionOption.equals(that.encryptionOption)) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                return this.objectKeyPrefix != null ? this.objectKeyPrefix.equals(that.objectKeyPrefix) : that.objectKeyPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.encryptionOption.hashCode());
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.objectKeyPrefix != null ? this.objectKeyPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A Schema specifies the expected data model of the table.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.timestream.*;
     * SchemaProperty schemaProperty = SchemaProperty.builder()
     *         .compositePartitionKey(List.of(PartitionKeyProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .enforcementInRecord("enforcementInRecord")
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-schema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-schema.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_timestream.CfnTable.SchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(SchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A non-empty list of partition keys defining the attributes used to partition the table data.
         * <p>
         * The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-schema.html#cfn-timestream-table-schema-compositepartitionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-timestream-table-schema.html#cfn-timestream-table-schema-compositepartitionkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompositePartitionKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SchemaProperty> {
            java.lang.Object compositePartitionKey;

            /**
             * Sets the value of {@link SchemaProperty#getCompositePartitionKey}
             * @param compositePartitionKey A non-empty list of partition keys defining the attributes used to partition the table data.
             *                              The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compositePartitionKey(software.amazon.awscdk.IResolvable compositePartitionKey) {
                this.compositePartitionKey = compositePartitionKey;
                return this;
            }

            /**
             * Sets the value of {@link SchemaProperty#getCompositePartitionKey}
             * @param compositePartitionKey A non-empty list of partition keys defining the attributes used to partition the table data.
             *                              The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compositePartitionKey(java.util.List<? extends java.lang.Object> compositePartitionKey) {
                this.compositePartitionKey = compositePartitionKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SchemaProperty {
            private final java.lang.Object compositePartitionKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.compositePartitionKey = software.amazon.jsii.Kernel.get(this, "compositePartitionKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.compositePartitionKey = builder.compositePartitionKey;
            }

            @Override
            public final java.lang.Object getCompositePartitionKey() {
                return this.compositePartitionKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCompositePartitionKey() != null) {
                    data.set("compositePartitionKey", om.valueToTree(this.getCompositePartitionKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_timestream.CfnTable.SchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SchemaProperty.Jsii$Proxy that = (SchemaProperty.Jsii$Proxy) o;

                return this.compositePartitionKey != null ? this.compositePartitionKey.equals(that.compositePartitionKey) : that.compositePartitionKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.compositePartitionKey != null ? this.compositePartitionKey.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.timestream.CfnTable}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.timestream.CfnTable> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.timestream.CfnTableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.timestream.CfnTableProps.Builder();
        }

        /**
         * The name of the Timestream database that contains this table.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-databasename</a>
         * @param databaseName The name of the Timestream database that contains this table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseName(final java.lang.String databaseName) {
            this.props.databaseName(databaseName);
            return this;
        }

        /**
         * Contains properties to set on the table when enabling magnetic store writes.
         * <p>
         * This object has the following attributes:
         * <p>
         * <ul>
         * <li><em>EnableMagneticStoreWrites</em> : A <code>boolean</code> flag to enable magnetic store writes.</li>
         * <li><em>MagneticStoreRejectedDataLocation</em> : The location to write error reports for records rejected, asynchronously, during magnetic store writes. Only <code>S3Configuration</code> objects are allowed. The <code>S3Configuration</code> object has the following attributes:</li>
         * <li><em>BucketName</em> : The name of the S3 bucket.</li>
         * <li><em>EncryptionOption</em> : The encryption option for the S3 location. Valid values are S3 server-side encryption with an S3 managed key ( <code>SSE_S3</code> ) or AWS managed key ( <code>SSE_KMS</code> ).</li>
         * <li><em>KmsKeyId</em> : The AWS KMS key ID to use when encrypting with an AWS managed key.</li>
         * <li><em>ObjectKeyPrefix</em> : The prefix to use option for the objects stored in S3.</li>
         * </ul>
         * <p>
         * Both <code>BucketName</code> and <code>EncryptionOption</code> are <em>required</em> when <code>S3Configuration</code> is specified. If you specify <code>SSE_KMS</code> as your <code>EncryptionOption</code> then <code>KmsKeyId</code> is <em>required</em> .
         * <p>
         * <code>EnableMagneticStoreWrites</code> attribute is <em>required</em> when <code>MagneticStoreWriteProperties</code> is specified. <code>MagneticStoreRejectedDataLocation</code> attribute is <em>required</em> when <code>EnableMagneticStoreWrites</code> is set to <code>true</code> .
         * <p>
         * See the following examples:
         * <p>
         * <em>JSON</em>
         * <p>
         * <blockquote><pre>
         * { "Type" : AWS::Timestream::Table", "Properties":{ "DatabaseName":"TestDatabase", "TableName":"TestTable", "MagneticStoreWriteProperties":{ "EnableMagneticStoreWrites":true, "MagneticStoreRejectedDataLocation":{ "S3Configuration":{ "BucketName":" amzn-s3-demo-bucket ", "EncryptionOption":"SSE_KMS", "KmsKeyId":"1234abcd-12ab-34cd-56ef-1234567890ab", "ObjectKeyPrefix":"prefix" } } } }
         * }
         * </pre></blockquote>
         * <p>
         * <em>YAML</em>
         * <p>
         * <blockquote><pre>
         * Type: AWS::Timestream::Table
         * DependsOn: TestDatabase
         * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" MagneticStoreWriteProperties: EnableMagneticStoreWrites: true MagneticStoreRejectedDataLocation: S3Configuration: BucketName: " amzn-s3-demo-bucket " EncryptionOption: "SSE_KMS" KmsKeyId: "1234abcd-12ab-34cd-56ef-1234567890ab" ObjectKeyPrefix: "prefix"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-magneticstorewriteproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-magneticstorewriteproperties</a>
         * @param magneticStoreWriteProperties Contains properties to set on the table when enabling magnetic store writes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder magneticStoreWriteProperties(final java.lang.Object magneticStoreWriteProperties) {
            this.props.magneticStoreWriteProperties(magneticStoreWriteProperties);
            return this;
        }

        /**
         * The retention duration for the memory store and magnetic store. This object has the following attributes:.
         * <p>
         * <ul>
         * <li><em>MemoryStoreRetentionPeriodInHours</em> : Retention duration for memory store, in hours.</li>
         * <li><em>MagneticStoreRetentionPeriodInDays</em> : Retention duration for magnetic store, in days.</li>
         * </ul>
         * <p>
         * Both attributes are of type <code>string</code> . Both attributes are <em>required</em> when <code>RetentionProperties</code> is specified.
         * <p>
         * See the following examples:
         * <p>
         * <em>JSON</em>
         * <p>
         * <code>{ "Type" : AWS::Timestream::Table", "Properties" : { "DatabaseName" : "TestDatabase", "TableName" : "TestTable", "RetentionProperties" : { "MemoryStoreRetentionPeriodInHours": "24", "MagneticStoreRetentionPeriodInDays": "7" } } }</code>
         * <p>
         * <em>YAML</em>
         * <p>
         * <blockquote><pre>
         * Type: AWS::Timestream::Table
         * DependsOn: TestDatabase
         * Properties: TableName: "TestTable" DatabaseName: "TestDatabase" RetentionProperties: MemoryStoreRetentionPeriodInHours: "24" MagneticStoreRetentionPeriodInDays: "7"
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-retentionproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-retentionproperties</a>
         * @param retentionProperties The retention duration for the memory store and magnetic store. This object has the following attributes:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionProperties(final java.lang.Object retentionProperties) {
            this.props.retentionProperties(retentionProperties);
            return this;
        }

        /**
         * The schema of the table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-schema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-schema</a>
         * @param schema The schema of the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(final software.amazon.awscdk.IResolvable schema) {
            this.props.schema(schema);
            return this;
        }
        /**
         * The schema of the table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-schema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-schema</a>
         * @param schema The schema of the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(final software.amazon.awscdk.services.timestream.CfnTable.SchemaProperty schema) {
            this.props.schema(schema);
            return this;
        }

        /**
         * The name of the Timestream table.
         * <p>
         * <em>Length Constraints</em> : Minimum length of 3 bytes. Maximum length of 256 bytes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-tablename</a>
         * @param tableName The name of the Timestream table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * The tags to add to the table.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-timestream-table.html#cfn-timestream-table-tags</a>
         * @param tags The tags to add to the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.timestream.CfnTable}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.timestream.CfnTable build() {
            return new software.amazon.awscdk.services.timestream.CfnTable(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
