package software.amazon.awscdk.services.verifiedpermissions;

/**
 * Creates or updates a Cedar policy and saves it in the specified policy store.
 * <p>
 * You can create either a static policy or a policy linked to a policy template.
 * <p>
 * You can directly update only static policies. To update a template-linked policy, you must update its linked policy template instead.
 * <p>
 * <ul>
 * <li>To create a static policy, in the <code>Definition</code> include a <code>Static</code> element that includes the Cedar policy text in the <code>Statement</code> element.</li>
 * <li>To create a policy that is dynamically linked to a policy template, in the <code>Definition</code> include a <code>Templatelinked</code> element that specifies the policy template ID and the principal and resource to associate with this policy. If the policy template is ever updated, any policies linked to the policy template automatically use the updated template.</li>
 * </ul>
 * <p>
 * <blockquote>
 * <p>
 * <ul>
 * <li>If policy validation is enabled in the policy store, then updating a static policy causes Verified Permissions to validate the policy against the schema in the policy store. If the updated static policy doesn't pass validation, the operation fails and the update isn't stored.</li>
 * <li>When you edit a static policy, You can change only certain elements of a static policy:</li>
 * <li>The action referenced by the policy.</li>
 * <li>A condition clause, such as when and unless.</li>
 * </ul>
 * <p>
 * You can't change these elements of a static policy:
 * <p>
 * <ul>
 * <li>Changing a policy from a static policy to a template-linked policy.</li>
 * <li>Changing the effect of a static policy from permit or forbid.</li>
 * <li>The principal referenced by a static policy.</li>
 * <li>The resource referenced by a static policy.</li>
 * <li>To update a template-linked policy, you must update the template instead.</li>
 * </ul>
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.verifiedpermissions.*;
 * CfnPolicy cfnPolicy = CfnPolicy.Builder.create(this, "MyCfnPolicy")
 *         .definition(PolicyDefinitionProperty.builder()
 *                 .static(StaticPolicyDefinitionProperty.builder()
 *                         .statement("statement")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build())
 *                 .templateLinked(TemplateLinkedPolicyDefinitionProperty.builder()
 *                         .policyTemplateId("policyTemplateId")
 *                         // the properties below are optional
 *                         .principal(EntityIdentifierProperty.builder()
 *                                 .entityId("entityId")
 *                                 .entityType("entityType")
 *                                 .build())
 *                         .resource(EntityIdentifierProperty.builder()
 *                                 .entityId("entityId")
 *                                 .entityType("entityType")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .policyStoreId("policyStoreId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:45.867Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnPolicy")
public class CfnPolicy extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.verifiedpermissions.CfnPolicy.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.verifiedpermissions.CfnPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique ID of the new or updated policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPolicyId() {
        return software.amazon.jsii.Kernel.get(this, "attrPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the policy. This is one of the following values:.
     * <p>
     * <ul>
     * <li>Static</li>
     * <li>TemplateLinked</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPolicyType() {
        return software.amazon.jsii.Kernel.get(this, "attrPolicyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies the policy type and content to use for the new or updated policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefinition() {
        return software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the policy type and content to use for the new or updated policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * Specifies the policy type and content to use for the new or updated policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.verifiedpermissions.CfnPolicy.PolicyDefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPolicyStoreId() {
        return software.amazon.jsii.Kernel.get(this, "policyStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPolicyStoreId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "policyStoreId", java.util.Objects.requireNonNull(value, "policyStoreId is required"));
    }
    /**
     * Contains the identifier of an entity in a policy, including its ID and type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * EntityIdentifierProperty entityIdentifierProperty = EntityIdentifierProperty.builder()
     *         .entityId("entityId")
     *         .entityType("entityType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-entityidentifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-entityidentifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnPolicy.EntityIdentifierProperty")
    @software.amazon.jsii.Jsii.Proxy(EntityIdentifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EntityIdentifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier of an entity.
         * <p>
         * <code>"entityId":" *identifier* "</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-entityidentifier.html#cfn-verifiedpermissions-policy-entityidentifier-entityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-entityidentifier.html#cfn-verifiedpermissions-policy-entityidentifier-entityid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEntityId();

        /**
         * The type of an entity.
         * <p>
         * Example: <code>"entityType":" *typeName* "</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-entityidentifier.html#cfn-verifiedpermissions-policy-entityidentifier-entitytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-entityidentifier.html#cfn-verifiedpermissions-policy-entityidentifier-entitytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEntityType();

        /**
         * @return a {@link Builder} of {@link EntityIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EntityIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EntityIdentifierProperty> {
            java.lang.String entityId;
            java.lang.String entityType;

            /**
             * Sets the value of {@link EntityIdentifierProperty#getEntityId}
             * @param entityId The identifier of an entity. This parameter is required.
             *                 <code>"entityId":" *identifier* "</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityId(java.lang.String entityId) {
                this.entityId = entityId;
                return this;
            }

            /**
             * Sets the value of {@link EntityIdentifierProperty#getEntityType}
             * @param entityType The type of an entity. This parameter is required.
             *                   Example: <code>"entityType":" *typeName* "</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityType(java.lang.String entityType) {
                this.entityType = entityType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EntityIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EntityIdentifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EntityIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EntityIdentifierProperty {
            private final java.lang.String entityId;
            private final java.lang.String entityType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityId = software.amazon.jsii.Kernel.get(this, "entityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.entityType = software.amazon.jsii.Kernel.get(this, "entityType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityId = java.util.Objects.requireNonNull(builder.entityId, "entityId is required");
                this.entityType = java.util.Objects.requireNonNull(builder.entityType, "entityType is required");
            }

            @Override
            public final java.lang.String getEntityId() {
                return this.entityId;
            }

            @Override
            public final java.lang.String getEntityType() {
                return this.entityType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entityId", om.valueToTree(this.getEntityId()));
                data.set("entityType", om.valueToTree(this.getEntityType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnPolicy.EntityIdentifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EntityIdentifierProperty.Jsii$Proxy that = (EntityIdentifierProperty.Jsii$Proxy) o;

                if (!entityId.equals(that.entityId)) return false;
                return this.entityType.equals(that.entityType);
            }

            @Override
            public final int hashCode() {
                int result = this.entityId.hashCode();
                result = 31 * result + (this.entityType.hashCode());
                return result;
            }
        }
    }
    /**
     * A structure that defines a Cedar policy.
     * <p>
     * It includes the policy type, a description, and a policy body. This is a top level data type used to create a policy.
     * <p>
     * This data type is used as a request parameter for the <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a> operation. This structure must always have either an <code>Static</code> or a <code>TemplateLinked</code> element.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * PolicyDefinitionProperty policyDefinitionProperty = PolicyDefinitionProperty.builder()
     *         .static(StaticPolicyDefinitionProperty.builder()
     *                 .statement("statement")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .build())
     *         .templateLinked(TemplateLinkedPolicyDefinitionProperty.builder()
     *                 .policyTemplateId("policyTemplateId")
     *                 // the properties below are optional
     *                 .principal(EntityIdentifierProperty.builder()
     *                         .entityId("entityId")
     *                         .entityType("entityType")
     *                         .build())
     *                 .resource(EntityIdentifierProperty.builder()
     *                         .entityId("entityId")
     *                         .entityType("entityType")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-policydefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-policydefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnPolicy.PolicyDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(PolicyDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PolicyDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure that describes a static policy.
         * <p>
         * An static policy doesn't use a template or allow placeholders for entities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-policydefinition.html#cfn-verifiedpermissions-policy-policydefinition-static">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-policydefinition.html#cfn-verifiedpermissions-policy-policydefinition-static</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStaticValue() {
            return null;
        }

        /**
         * A structure that describes a policy that was instantiated from a template.
         * <p>
         * The template can specify placeholders for <code>principal</code> and <code>resource</code> . When you use <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a> to create a policy from a template, you specify the exact principal and resource to use for the instantiated policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-policydefinition.html#cfn-verifiedpermissions-policy-policydefinition-templatelinked">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-policydefinition.html#cfn-verifiedpermissions-policy-policydefinition-templatelinked</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTemplateLinked() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PolicyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PolicyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PolicyDefinitionProperty> {
            java.lang.Object staticValue;
            java.lang.Object templateLinked;

            /**
             * Sets the value of {@link PolicyDefinitionProperty#getStaticValue}
             * @param staticValue A structure that describes a static policy.
             *                    An static policy doesn't use a template or allow placeholders for entities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValue(software.amazon.awscdk.IResolvable staticValue) {
                this.staticValue = staticValue;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDefinitionProperty#getStaticValue}
             * @param staticValue A structure that describes a static policy.
             *                    An static policy doesn't use a template or allow placeholders for entities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder staticValue(software.amazon.awscdk.services.verifiedpermissions.CfnPolicy.StaticPolicyDefinitionProperty staticValue) {
                this.staticValue = staticValue;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDefinitionProperty#getTemplateLinked}
             * @param templateLinked A structure that describes a policy that was instantiated from a template.
             *                       The template can specify placeholders for <code>principal</code> and <code>resource</code> . When you use <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a> to create a policy from a template, you specify the exact principal and resource to use for the instantiated policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateLinked(software.amazon.awscdk.IResolvable templateLinked) {
                this.templateLinked = templateLinked;
                return this;
            }

            /**
             * Sets the value of {@link PolicyDefinitionProperty#getTemplateLinked}
             * @param templateLinked A structure that describes a policy that was instantiated from a template.
             *                       The template can specify placeholders for <code>principal</code> and <code>resource</code> . When you use <a href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreatePolicy.html">CreatePolicy</a> to create a policy from a template, you specify the exact principal and resource to use for the instantiated policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateLinked(software.amazon.awscdk.services.verifiedpermissions.CfnPolicy.TemplateLinkedPolicyDefinitionProperty templateLinked) {
                this.templateLinked = templateLinked;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PolicyDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PolicyDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PolicyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PolicyDefinitionProperty {
            private final java.lang.Object staticValue;
            private final java.lang.Object templateLinked;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.staticValue = software.amazon.jsii.Kernel.get(this, "static", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.templateLinked = software.amazon.jsii.Kernel.get(this, "templateLinked", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.staticValue = builder.staticValue;
                this.templateLinked = builder.templateLinked;
            }

            @Override
            public final java.lang.Object getStaticValue() {
                return this.staticValue;
            }

            @Override
            public final java.lang.Object getTemplateLinked() {
                return this.templateLinked;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getStaticValue() != null) {
                    data.set("static", om.valueToTree(this.getStaticValue()));
                }
                if (this.getTemplateLinked() != null) {
                    data.set("templateLinked", om.valueToTree(this.getTemplateLinked()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnPolicy.PolicyDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PolicyDefinitionProperty.Jsii$Proxy that = (PolicyDefinitionProperty.Jsii$Proxy) o;

                if (this.staticValue != null ? !this.staticValue.equals(that.staticValue) : that.staticValue != null) return false;
                return this.templateLinked != null ? this.templateLinked.equals(that.templateLinked) : that.templateLinked == null;
            }

            @Override
            public final int hashCode() {
                int result = this.staticValue != null ? this.staticValue.hashCode() : 0;
                result = 31 * result + (this.templateLinked != null ? this.templateLinked.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that defines a static policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * StaticPolicyDefinitionProperty staticPolicyDefinitionProperty = StaticPolicyDefinitionProperty.builder()
     *         .statement("statement")
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-staticpolicydefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-staticpolicydefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnPolicy.StaticPolicyDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(StaticPolicyDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StaticPolicyDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The policy content of the static policy, written in the Cedar policy language.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-staticpolicydefinition.html#cfn-verifiedpermissions-policy-staticpolicydefinition-statement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-staticpolicydefinition.html#cfn-verifiedpermissions-policy-staticpolicydefinition-statement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatement();

        /**
         * The description of the static policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-staticpolicydefinition.html#cfn-verifiedpermissions-policy-staticpolicydefinition-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-staticpolicydefinition.html#cfn-verifiedpermissions-policy-staticpolicydefinition-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StaticPolicyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StaticPolicyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StaticPolicyDefinitionProperty> {
            java.lang.String statement;
            java.lang.String description;

            /**
             * Sets the value of {@link StaticPolicyDefinitionProperty#getStatement}
             * @param statement The policy content of the static policy, written in the Cedar policy language. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statement(java.lang.String statement) {
                this.statement = statement;
                return this;
            }

            /**
             * Sets the value of {@link StaticPolicyDefinitionProperty#getDescription}
             * @param description The description of the static policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StaticPolicyDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StaticPolicyDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StaticPolicyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StaticPolicyDefinitionProperty {
            private final java.lang.String statement;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statement = java.util.Objects.requireNonNull(builder.statement, "statement is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getStatement() {
                return this.statement;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statement", om.valueToTree(this.getStatement()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnPolicy.StaticPolicyDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StaticPolicyDefinitionProperty.Jsii$Proxy that = (StaticPolicyDefinitionProperty.Jsii$Proxy) o;

                if (!statement.equals(that.statement)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.statement.hashCode();
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure that describes a policy created by instantiating a policy template.
     * <p>
     * <blockquote>
     * <p>
     * You can't directly update a template-linked policy. You must update the associated policy template instead.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.verifiedpermissions.*;
     * TemplateLinkedPolicyDefinitionProperty templateLinkedPolicyDefinitionProperty = TemplateLinkedPolicyDefinitionProperty.builder()
     *         .policyTemplateId("policyTemplateId")
     *         // the properties below are optional
     *         .principal(EntityIdentifierProperty.builder()
     *                 .entityId("entityId")
     *                 .entityType("entityType")
     *                 .build())
     *         .resource(EntityIdentifierProperty.builder()
     *                 .entityId("entityId")
     *                 .entityType("entityType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-templatelinkedpolicydefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-templatelinkedpolicydefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_verifiedpermissions.CfnPolicy.TemplateLinkedPolicyDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(TemplateLinkedPolicyDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TemplateLinkedPolicyDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the policy template used to create this policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-templatelinkedpolicydefinition.html#cfn-verifiedpermissions-policy-templatelinkedpolicydefinition-policytemplateid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-templatelinkedpolicydefinition.html#cfn-verifiedpermissions-policy-templatelinkedpolicydefinition-policytemplateid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPolicyTemplateId();

        /**
         * The principal associated with this template-linked policy.
         * <p>
         * Verified Permissions substitutes this principal for the <code>?principal</code> placeholder in the policy template when it evaluates an authorization request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-templatelinkedpolicydefinition.html#cfn-verifiedpermissions-policy-templatelinkedpolicydefinition-principal">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-templatelinkedpolicydefinition.html#cfn-verifiedpermissions-policy-templatelinkedpolicydefinition-principal</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrincipal() {
            return null;
        }

        /**
         * The resource associated with this template-linked policy.
         * <p>
         * Verified Permissions substitutes this resource for the <code>?resource</code> placeholder in the policy template when it evaluates an authorization request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-templatelinkedpolicydefinition.html#cfn-verifiedpermissions-policy-templatelinkedpolicydefinition-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-verifiedpermissions-policy-templatelinkedpolicydefinition.html#cfn-verifiedpermissions-policy-templatelinkedpolicydefinition-resource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TemplateLinkedPolicyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TemplateLinkedPolicyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TemplateLinkedPolicyDefinitionProperty> {
            java.lang.String policyTemplateId;
            java.lang.Object principal;
            java.lang.Object resource;

            /**
             * Sets the value of {@link TemplateLinkedPolicyDefinitionProperty#getPolicyTemplateId}
             * @param policyTemplateId The unique identifier of the policy template used to create this policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder policyTemplateId(java.lang.String policyTemplateId) {
                this.policyTemplateId = policyTemplateId;
                return this;
            }

            /**
             * Sets the value of {@link TemplateLinkedPolicyDefinitionProperty#getPrincipal}
             * @param principal The principal associated with this template-linked policy.
             *                  Verified Permissions substitutes this principal for the <code>?principal</code> placeholder in the policy template when it evaluates an authorization request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(software.amazon.awscdk.IResolvable principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Sets the value of {@link TemplateLinkedPolicyDefinitionProperty#getPrincipal}
             * @param principal The principal associated with this template-linked policy.
             *                  Verified Permissions substitutes this principal for the <code>?principal</code> placeholder in the policy template when it evaluates an authorization request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder principal(software.amazon.awscdk.services.verifiedpermissions.CfnPolicy.EntityIdentifierProperty principal) {
                this.principal = principal;
                return this;
            }

            /**
             * Sets the value of {@link TemplateLinkedPolicyDefinitionProperty#getResource}
             * @param resource The resource associated with this template-linked policy.
             *                 Verified Permissions substitutes this resource for the <code>?resource</code> placeholder in the policy template when it evaluates an authorization request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(software.amazon.awscdk.IResolvable resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Sets the value of {@link TemplateLinkedPolicyDefinitionProperty#getResource}
             * @param resource The resource associated with this template-linked policy.
             *                 Verified Permissions substitutes this resource for the <code>?resource</code> placeholder in the policy template when it evaluates an authorization request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(software.amazon.awscdk.services.verifiedpermissions.CfnPolicy.EntityIdentifierProperty resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TemplateLinkedPolicyDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TemplateLinkedPolicyDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TemplateLinkedPolicyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TemplateLinkedPolicyDefinitionProperty {
            private final java.lang.String policyTemplateId;
            private final java.lang.Object principal;
            private final java.lang.Object resource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.policyTemplateId = software.amazon.jsii.Kernel.get(this, "policyTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.principal = software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.policyTemplateId = java.util.Objects.requireNonNull(builder.policyTemplateId, "policyTemplateId is required");
                this.principal = builder.principal;
                this.resource = builder.resource;
            }

            @Override
            public final java.lang.String getPolicyTemplateId() {
                return this.policyTemplateId;
            }

            @Override
            public final java.lang.Object getPrincipal() {
                return this.principal;
            }

            @Override
            public final java.lang.Object getResource() {
                return this.resource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("policyTemplateId", om.valueToTree(this.getPolicyTemplateId()));
                if (this.getPrincipal() != null) {
                    data.set("principal", om.valueToTree(this.getPrincipal()));
                }
                if (this.getResource() != null) {
                    data.set("resource", om.valueToTree(this.getResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_verifiedpermissions.CfnPolicy.TemplateLinkedPolicyDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TemplateLinkedPolicyDefinitionProperty.Jsii$Proxy that = (TemplateLinkedPolicyDefinitionProperty.Jsii$Proxy) o;

                if (!policyTemplateId.equals(that.policyTemplateId)) return false;
                if (this.principal != null ? !this.principal.equals(that.principal) : that.principal != null) return false;
                return this.resource != null ? this.resource.equals(that.resource) : that.resource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.policyTemplateId.hashCode();
                result = 31 * result + (this.principal != null ? this.principal.hashCode() : 0);
                result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.verifiedpermissions.CfnPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.verifiedpermissions.CfnPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.verifiedpermissions.CfnPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.verifiedpermissions.CfnPolicyProps.Builder();
        }

        /**
         * Specifies the policy type and content to use for the new or updated policy.
         * <p>
         * The definition structure must include either a <code>Static</code> or a <code>TemplateLinked</code> element.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html#cfn-verifiedpermissions-policy-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html#cfn-verifiedpermissions-policy-definition</a>
         * @param definition Specifies the policy type and content to use for the new or updated policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final software.amazon.awscdk.IResolvable definition) {
            this.props.definition(definition);
            return this;
        }
        /**
         * Specifies the policy type and content to use for the new or updated policy.
         * <p>
         * The definition structure must include either a <code>Static</code> or a <code>TemplateLinked</code> element.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html#cfn-verifiedpermissions-policy-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html#cfn-verifiedpermissions-policy-definition</a>
         * @param definition Specifies the policy type and content to use for the new or updated policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final software.amazon.awscdk.services.verifiedpermissions.CfnPolicy.PolicyDefinitionProperty definition) {
            this.props.definition(definition);
            return this;
        }

        /**
         * Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html#cfn-verifiedpermissions-policy-policystoreid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-verifiedpermissions-policy.html#cfn-verifiedpermissions-policy-policystoreid</a>
         * @param policyStoreId Specifies the <code>PolicyStoreId</code> of the policy store you want to store the policy in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStoreId(final java.lang.String policyStoreId) {
            this.props.policyStoreId(policyStoreId);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.verifiedpermissions.CfnPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.verifiedpermissions.CfnPolicy build() {
            return new software.amazon.awscdk.services.verifiedpermissions.CfnPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
