package software.amazon.awscdk.services.waf.regional;

/**
 * <blockquote><p>This is <em>AWS WAF Classic</em> documentation.<p></blockquote>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html">AWS WAF Classic</a> in the developer guide.
 * <p>
 * <blockquote>
 * <p>
 * <em>For the latest version of AWS WAF</em> , use the AWS WAF V2 API and see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> . With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 * <p>
 * </blockquote>
 * <p>
 * A <code>RateBasedRule</code> is identical to a regular <code>Rule</code> , with one addition: a <code>RateBasedRule</code> counts the number of requests that arrive from a specified IP address every five minutes. For example, based on recent requests that you've seen from an attacker, you might create a <code>RateBasedRule</code> that includes the following conditions:
 * <p>
 * <ul>
 * <li>The requests come from 192.0.2.44.</li>
 * <li>They contain the value <code>BadBot</code> in the <code>User-Agent</code> header.</li>
 * </ul>
 * <p>
 * In the rule, you also define the rate limit as 15,000.
 * <p>
 * Requests that meet both of these conditions and exceed 15,000 requests every five minutes trigger the rule's action (block or count), which is defined in the web ACL.
 * <p>
 * Note you can only create rate-based rules using an AWS CloudFormation template. To add the rate-based rules created through AWS CloudFormation to a web ACL, use the AWS WAF console, API, or command line interface (CLI). For more information, see <a href="https://docs.aws.amazon.com/waf/latest/APIReference/API_regional_UpdateWebACL.html">UpdateWebACL</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.waf.regional.*;
 * CfnRateBasedRule cfnRateBasedRule = CfnRateBasedRule.Builder.create(this, "MyCfnRateBasedRule")
 *         .metricName("metricName")
 *         .name("name")
 *         .rateKey("rateKey")
 *         .rateLimit(123)
 *         // the properties below are optional
 *         .matchPredicates(List.of(PredicateProperty.builder()
 *                 .dataId("dataId")
 *                 .negated(false)
 *                 .type("type")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:45.974Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnRateBasedRule")
public class CfnRateBasedRule extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnRateBasedRule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRateBasedRule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.waf.regional.CfnRateBasedRule.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRateBasedRule(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.waf.regional.CfnRateBasedRuleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A name for the metrics for a <code>RateBasedRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMetricName() {
        return software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the metrics for a <code>RateBasedRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "metricName", java.util.Objects.requireNonNull(value, "metricName is required"));
    }

    /**
     * A friendly name or description for a <code>RateBasedRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A friendly name or description for a <code>RateBasedRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRateKey() {
        return software.amazon.jsii.Kernel.get(this, "rateKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRateKey(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "rateKey", java.util.Objects.requireNonNull(value, "rateKey is required"));
    }

    /**
     * The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code> , allowed in a five-minute period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getRateLimit() {
        return software.amazon.jsii.Kernel.get(this, "rateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code> , allowed in a five-minute period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRateLimit(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "rateLimit", java.util.Objects.requireNonNull(value, "rateLimit is required"));
    }

    /**
     * The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code> , <code>IPSet</code> , or <code>SqlInjectionMatchSet&gt;</code> object that you want to include in a <code>RateBasedRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMatchPredicates() {
        return software.amazon.jsii.Kernel.get(this, "matchPredicates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code> , <code>IPSet</code> , or <code>SqlInjectionMatchSet&gt;</code> object that you want to include in a <code>RateBasedRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMatchPredicates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "matchPredicates", value);
    }

    /**
     * The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code> , <code>IPSet</code> , or <code>SqlInjectionMatchSet&gt;</code> object that you want to include in a <code>RateBasedRule</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMatchPredicates(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.waf.regional.CfnRateBasedRule.PredicateProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.waf.regional.CfnRateBasedRule.PredicateProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "matchPredicates", value);
    }
    /**
     * Specifies the <code>ByteMatchSet</code> , <code>IPSet</code> , <code>SqlInjectionMatchSet</code> , <code>XssMatchSet</code> , <code>RegexMatchSet</code> , <code>GeoMatchSet</code> , and <code>SizeConstraintSet</code> objects that you want to add to a <code>Rule</code> and, for each object, indicates whether you want to negate the settings, for example, requests that do NOT originate from the IP address 192.0.2.44.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.waf.regional.*;
     * PredicateProperty predicateProperty = PredicateProperty.builder()
     *         .dataId("dataId")
     *         .negated(false)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-ratebasedrule-predicate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-ratebasedrule-predicate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnRateBasedRule.PredicateProperty")
    @software.amazon.jsii.Jsii.Proxy(PredicateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredicateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unique identifier for a predicate in a <code>Rule</code> , such as <code>ByteMatchSetId</code> or <code>IPSetId</code> .
         * <p>
         * The ID is returned by the corresponding <code>Create</code> or <code>List</code> command.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-ratebasedrule-predicate.html#cfn-wafregional-ratebasedrule-predicate-dataid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-ratebasedrule-predicate.html#cfn-wafregional-ratebasedrule-predicate-dataid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataId();

        /**
         * Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests based on the settings in the specified <code>ByteMatchSet</code> , <code>IPSet</code> , <code>SqlInjectionMatchSet</code> , <code>XssMatchSet</code> , <code>RegexMatchSet</code> , <code>GeoMatchSet</code> , or <code>SizeConstraintSet</code> .
         * <p>
         * For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code> , AWS WAF will allow or block requests based on that IP address.
         * <p>
         * Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on the negation of the settings in the <code>ByteMatchSet</code> , <code>IPSet</code> , <code>SqlInjectionMatchSet</code> , <code>XssMatchSet</code> , <code>RegexMatchSet</code> , <code>GeoMatchSet</code> , or <code>SizeConstraintSet</code> &gt;. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code> , AWS WAF will allow, block, or count requests based on all IP addresses <em>except</em> <code>192.0.2.44</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-ratebasedrule-predicate.html#cfn-wafregional-ratebasedrule-predicate-negated">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-ratebasedrule-predicate.html#cfn-wafregional-ratebasedrule-predicate-negated</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getNegated();

        /**
         * The type of predicate in a <code>Rule</code> , such as <code>ByteMatch</code> or <code>IPSet</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-ratebasedrule-predicate.html#cfn-wafregional-ratebasedrule-predicate-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafregional-ratebasedrule-predicate.html#cfn-wafregional-ratebasedrule-predicate-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link PredicateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredicateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredicateProperty> {
            java.lang.String dataId;
            java.lang.Object negated;
            java.lang.String type;

            /**
             * Sets the value of {@link PredicateProperty#getDataId}
             * @param dataId A unique identifier for a predicate in a <code>Rule</code> , such as <code>ByteMatchSetId</code> or <code>IPSetId</code> . This parameter is required.
             *               The ID is returned by the corresponding <code>Create</code> or <code>List</code> command.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataId(java.lang.String dataId) {
                this.dataId = dataId;
                return this;
            }

            /**
             * Sets the value of {@link PredicateProperty#getNegated}
             * @param negated Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests based on the settings in the specified <code>ByteMatchSet</code> , <code>IPSet</code> , <code>SqlInjectionMatchSet</code> , <code>XssMatchSet</code> , <code>RegexMatchSet</code> , <code>GeoMatchSet</code> , or <code>SizeConstraintSet</code> . This parameter is required.
             *                For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code> , AWS WAF will allow or block requests based on that IP address.
             *                <p>
             *                Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on the negation of the settings in the <code>ByteMatchSet</code> , <code>IPSet</code> , <code>SqlInjectionMatchSet</code> , <code>XssMatchSet</code> , <code>RegexMatchSet</code> , <code>GeoMatchSet</code> , or <code>SizeConstraintSet</code> &gt;. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code> , AWS WAF will allow, block, or count requests based on all IP addresses <em>except</em> <code>192.0.2.44</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder negated(java.lang.Boolean negated) {
                this.negated = negated;
                return this;
            }

            /**
             * Sets the value of {@link PredicateProperty#getNegated}
             * @param negated Set <code>Negated</code> to <code>False</code> if you want AWS WAF to allow, block, or count requests based on the settings in the specified <code>ByteMatchSet</code> , <code>IPSet</code> , <code>SqlInjectionMatchSet</code> , <code>XssMatchSet</code> , <code>RegexMatchSet</code> , <code>GeoMatchSet</code> , or <code>SizeConstraintSet</code> . This parameter is required.
             *                For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code> , AWS WAF will allow or block requests based on that IP address.
             *                <p>
             *                Set <code>Negated</code> to <code>True</code> if you want AWS WAF to allow or block a request based on the negation of the settings in the <code>ByteMatchSet</code> , <code>IPSet</code> , <code>SqlInjectionMatchSet</code> , <code>XssMatchSet</code> , <code>RegexMatchSet</code> , <code>GeoMatchSet</code> , or <code>SizeConstraintSet</code> &gt;. For example, if an <code>IPSet</code> includes the IP address <code>192.0.2.44</code> , AWS WAF will allow, block, or count requests based on all IP addresses <em>except</em> <code>192.0.2.44</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder negated(software.amazon.awscdk.IResolvable negated) {
                this.negated = negated;
                return this;
            }

            /**
             * Sets the value of {@link PredicateProperty#getType}
             * @param type The type of predicate in a <code>Rule</code> , such as <code>ByteMatch</code> or <code>IPSet</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredicateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredicateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredicateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredicateProperty {
            private final java.lang.String dataId;
            private final java.lang.Object negated;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataId = software.amazon.jsii.Kernel.get(this, "dataId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.negated = software.amazon.jsii.Kernel.get(this, "negated", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataId = java.util.Objects.requireNonNull(builder.dataId, "dataId is required");
                this.negated = java.util.Objects.requireNonNull(builder.negated, "negated is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getDataId() {
                return this.dataId;
            }

            @Override
            public final java.lang.Object getNegated() {
                return this.negated;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataId", om.valueToTree(this.getDataId()));
                data.set("negated", om.valueToTree(this.getNegated()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafregional.CfnRateBasedRule.PredicateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredicateProperty.Jsii$Proxy that = (PredicateProperty.Jsii$Proxy) o;

                if (!dataId.equals(that.dataId)) return false;
                if (!negated.equals(that.negated)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.dataId.hashCode();
                result = 31 * result + (this.negated.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.waf.regional.CfnRateBasedRule}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.waf.regional.CfnRateBasedRule> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.waf.regional.CfnRateBasedRuleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.waf.regional.CfnRateBasedRuleProps.Builder();
        }

        /**
         * A name for the metrics for a <code>RateBasedRule</code> .
         * <p>
         * The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF , including "All" and "Default_Action." You can't change the name of the metric after you create the <code>RateBasedRule</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-metricname</a>
         * @param metricName A name for the metrics for a <code>RateBasedRule</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(final java.lang.String metricName) {
            this.props.metricName(metricName);
            return this;
        }

        /**
         * A friendly name or description for a <code>RateBasedRule</code> .
         * <p>
         * You can't change the name of a <code>RateBasedRule</code> after you create it.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-name</a>
         * @param name A friendly name or description for a <code>RateBasedRule</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring.
         * <p>
         * The only valid value for <code>RateKey</code> is <code>IP</code> . <code>IP</code> indicates that requests arriving from the same IP address are subject to the <code>RateLimit</code> that is specified in the <code>RateBasedRule</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-ratekey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-ratekey</a>
         * @param rateKey The field that AWS WAF uses to determine if requests are likely arriving from single source and thus subject to rate monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rateKey(final java.lang.String rateKey) {
            this.props.rateKey(rateKey);
            return this;
        }

        /**
         * The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code> , allowed in a five-minute period.
         * <p>
         * If the number of requests exceeds the <code>RateLimit</code> and the other predicates specified in the rule are also met, AWS WAF triggers the action that is specified for this rule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-ratelimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-ratelimit</a>
         * @param rateLimit The maximum number of requests, which have an identical value in the field specified by the <code>RateKey</code> , allowed in a five-minute period. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rateLimit(final java.lang.Number rateLimit) {
            this.props.rateLimit(rateLimit);
            return this;
        }

        /**
         * The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code> , <code>IPSet</code> , or <code>SqlInjectionMatchSet&gt;</code> object that you want to include in a <code>RateBasedRule</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-matchpredicates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-matchpredicates</a>
         * @param matchPredicates The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code> , <code>IPSet</code> , or <code>SqlInjectionMatchSet&gt;</code> object that you want to include in a <code>RateBasedRule</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchPredicates(final software.amazon.awscdk.IResolvable matchPredicates) {
            this.props.matchPredicates(matchPredicates);
            return this;
        }
        /**
         * The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code> , <code>IPSet</code> , or <code>SqlInjectionMatchSet&gt;</code> object that you want to include in a <code>RateBasedRule</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-matchpredicates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ratebasedrule.html#cfn-wafregional-ratebasedrule-matchpredicates</a>
         * @param matchPredicates The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code> , <code>IPSet</code> , or <code>SqlInjectionMatchSet&gt;</code> object that you want to include in a <code>RateBasedRule</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder matchPredicates(final java.util.List<? extends java.lang.Object> matchPredicates) {
            this.props.matchPredicates(matchPredicates);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.waf.regional.CfnRateBasedRule}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.waf.regional.CfnRateBasedRule build() {
            return new software.amazon.awscdk.services.waf.regional.CfnRateBasedRule(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
