package software.amazon.awscdk.services.waf.regional;

/**
 * Properties for defining a <code>CfnRule</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.waf.regional.*;
 * CfnRuleProps cfnRuleProps = CfnRuleProps.builder()
 *         .metricName("metricName")
 *         .name("name")
 *         // the properties below are optional
 *         .predicates(List.of(PredicateProperty.builder()
 *                 .dataId("dataId")
 *                 .negated(false)
 *                 .type("type")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-rule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-rule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:45.979Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnRuleProps")
@software.amazon.jsii.Jsii.Proxy(CfnRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRuleProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the metrics for this <code>Rule</code> .
     * <p>
     * The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>Rule</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-rule.html#cfn-wafregional-rule-metricname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-rule.html#cfn-wafregional-rule-metricname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

    /**
     * The friendly name or description for the <code>Rule</code> .
     * <p>
     * You can't change the name of a <code>Rule</code> after you create it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-rule.html#cfn-wafregional-rule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-rule.html#cfn-wafregional-rule-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code> , <code>IPSet</code> , or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>Rule</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-rule.html#cfn-wafregional-rule-predicates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-rule.html#cfn-wafregional-rule-predicates</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPredicates() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRuleProps> {
        java.lang.String metricName;
        java.lang.String name;
        java.lang.Object predicates;

        /**
         * Sets the value of {@link CfnRuleProps#getMetricName}
         * @param metricName A name for the metrics for this <code>Rule</code> . This parameter is required.
         *                   The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length 128 and minimum length one. It can't contain whitespace or metric names reserved for AWS WAF, including "All" and "Default_Action." You can't change <code>MetricName</code> after you create the <code>Rule</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(java.lang.String metricName) {
            this.metricName = metricName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getName}
         * @param name The friendly name or description for the <code>Rule</code> . This parameter is required.
         *             You can't change the name of a <code>Rule</code> after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getPredicates}
         * @param predicates The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code> , <code>IPSet</code> , or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>Rule</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predicates(software.amazon.awscdk.IResolvable predicates) {
            this.predicates = predicates;
            return this;
        }

        /**
         * Sets the value of {@link CfnRuleProps#getPredicates}
         * @param predicates The <code>Predicates</code> object contains one <code>Predicate</code> element for each <code>ByteMatchSet</code> , <code>IPSet</code> , or <code>SqlInjectionMatchSet</code> object that you want to include in a <code>Rule</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predicates(java.util.List<? extends java.lang.Object> predicates) {
            this.predicates = predicates;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRuleProps {
        private final java.lang.String metricName;
        private final java.lang.String name;
        private final java.lang.Object predicates;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.predicates = software.amazon.jsii.Kernel.get(this, "predicates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.predicates = builder.predicates;
        }

        @Override
        public final java.lang.String getMetricName() {
            return this.metricName;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getPredicates() {
            return this.predicates;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("metricName", om.valueToTree(this.getMetricName()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getPredicates() != null) {
                data.set("predicates", om.valueToTree(this.getPredicates()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafregional.CfnRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRuleProps.Jsii$Proxy that = (CfnRuleProps.Jsii$Proxy) o;

            if (!metricName.equals(that.metricName)) return false;
            if (!name.equals(that.name)) return false;
            return this.predicates != null ? this.predicates.equals(that.predicates) : that.predicates == null;
        }

        @Override
        public final int hashCode() {
            int result = this.metricName.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.predicates != null ? this.predicates.hashCode() : 0);
            return result;
        }
    }
}
