package software.amazon.awscdk.services.wafv2;

/**
 * <blockquote><p>This is the latest version of <em>AWS WAF</em> , named AWS WAF V2, released in November, 2019.<p></blockquote>
 * <p>
 * For information, including how to migrate your AWS WAF resources from the prior release, see the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF developer guide</a> .
 * <p>
 * Use an <code>WebACL</code> to define a collection of rules to use to inspect and control web requests. Each rule in a web ACL has a statement that defines what to look for in web requests and an action that AWS WAF applies to requests that match the statement. In the web ACL, you assign a default action to take (allow, block) for any request that doesn't match any of the rules.
 * <p>
 * The rules in a web ACL can be a combination of explicitly defined rules and rule groups that you reference from the web ACL. The rule groups can be rule groups that you manage or rule groups that are managed by others.
 * <p>
 * You can associate a web ACL with one or more AWS resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer , an AWS AppSync GraphQL API , an Amazon Cognito user pool, an AWS App Runner service, an AWS Amplify application, or an AWS Verified Access instance.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/web-acl.html">Web access control lists (web ACLs)</a> in the <em>AWS WAF developer guide</em> .
 * <p>
 * <em>Web ACLs used in AWS Shield Advanced automatic application layer DDoS mitigation</em>
 * <p>
 * If you use Shield Advanced automatic application layer DDoS mitigation, the web ACLs that you use with automatic mitigation have a rule group rule whose name starts with <code>ShieldMitigationRuleGroup</code> . This rule is used for automatic mitigations and it's managed for you in the web ACL by Shield Advanced and AWS WAF . You'll see the rule listed among the web ACL rules when you view the web ACL through the AWS WAF interfaces.
 * <p>
 * When you manage the web ACL through AWS CloudFormation interfaces, you won't see the Shield Advanced rule. AWS CloudFormation doesn't include this type of rule in the stack drift status between the actual configuration of the web ACL and your web ACL template.
 * <p>
 * Don't add the Shield Advanced rule group rule to your web ACL template. The rule shouldn't be in your template. When you update the web ACL template in a stack, the Shield Advanced rule is maintained for you by AWS WAF in the resulting web ACL.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/ddos-automatic-app-layer-response.html">Shield Advanced automatic application layer DDoS mitigation</a> in the <em>AWS Shield Advanced developer guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafv2-webacl.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:46.095Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL")
public class CfnWebACL extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnWebACL(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWebACL(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.wafv2.CfnWebACL.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWebACL(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wafv2.CfnWebACLProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The web ACL capacity units (WCUs) currently being used by this web ACL.
     * <p>
     * AWS WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. AWS WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrCapacity() {
        return software.amazon.jsii.Kernel.get(this, "attrCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The ID of the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The label namespace prefix for this web ACL.
     * <p>
     * All labels added by rules in this web ACL have this prefix.
     * <p>
     * The syntax for the label namespace prefix for a web ACL is the following: <code>awswaf:&lt;account ID&gt;:webacl:&lt;web ACL name&gt;:</code>
     * <p>
     * When a rule with a label matches a web request, AWS WAF adds the fully qualified label to the request. A fully qualified label is made up of the label namespace from the rule group or web ACL where the rule is defined and the label from the rule, separated by a colon.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLabelNamespace() {
        return software.amazon.jsii.Kernel.get(this, "attrLabelNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefaultAction() {
        return software.amazon.jsii.Kernel.get(this, "defaultAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "defaultAction", java.util.Objects.requireNonNull(value, "defaultAction is required"));
    }

    /**
     * The action to perform if none of the <code>Rules</code> contained in the <code>WebACL</code> match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefaultAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wafv2.CfnWebACL.DefaultActionProperty value) {
        software.amazon.jsii.Kernel.set(this, "defaultAction", java.util.Objects.requireNonNull(value, "defaultAction is required"));
    }

    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getScope() {
        return software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScope(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scope", java.util.Objects.requireNonNull(value, "scope is required"));
    }

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getVisibilityConfig() {
        return software.amazon.jsii.Kernel.get(this, "visibilityConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisibilityConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "visibilityConfig", java.util.Objects.requireNonNull(value, "visibilityConfig is required"));
    }

    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVisibilityConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wafv2.CfnWebACL.VisibilityConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "visibilityConfig", java.util.Objects.requireNonNull(value, "visibilityConfig is required"));
    }

    /**
     * Specifies custom configurations for the associations between the web ACL and protected resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAssociationConfig() {
        return software.amazon.jsii.Kernel.get(this, "associationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies custom configurations for the associations between the web ACL and protected resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociationConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "associationConfig", value);
    }

    /**
     * Specifies custom configurations for the associations between the web ACL and protected resources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssociationConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wafv2.CfnWebACL.AssociationConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "associationConfig", value);
    }

    /**
     * Specifies how AWS WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCaptchaConfig() {
        return software.amazon.jsii.Kernel.get(this, "captchaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies how AWS WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCaptchaConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "captchaConfig", value);
    }

    /**
     * Specifies how AWS WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCaptchaConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wafv2.CfnWebACL.CaptchaConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "captchaConfig", value);
    }

    /**
     * Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own <code>ChallengeConfig</code> settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getChallengeConfig() {
        return software.amazon.jsii.Kernel.get(this, "challengeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own <code>ChallengeConfig</code> settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChallengeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "challengeConfig", value);
    }

    /**
     * Specifies how AWS WAF should handle challenge evaluations for rules that don't have their own <code>ChallengeConfig</code> settings.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChallengeConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wafv2.CfnWebACL.ChallengeConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "challengeConfig", value);
    }

    /**
     * A map of custom response keys and content bodies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomResponseBodies() {
        return software.amazon.jsii.Kernel.get(this, "customResponseBodies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A map of custom response keys and content bodies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomResponseBodies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customResponseBodies", value);
    }

    /**
     * A map of custom response keys and content bodies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomResponseBodies(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.wafv2.CfnWebACL.CustomResponseBodyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.wafv2.CfnWebACL.CustomResponseBodyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "customResponseBodies", value);
    }

    /**
     * Specifies data protection to apply to the web request data for the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataProtectionConfig() {
        return software.amazon.jsii.Kernel.get(this, "dataProtectionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies data protection to apply to the web request data for the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataProtectionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataProtectionConfig", value);
    }

    /**
     * Specifies data protection to apply to the web request data for the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataProtectionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wafv2.CfnWebACL.DataProtectionConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataProtectionConfig", value);
    }

    /**
     * A description of the web ACL that helps with identification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the web ACL that helps with identification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the web ACL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Configures the level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOnSourceDDoSProtectionConfig() {
        return software.amazon.jsii.Kernel.get(this, "onSourceDDoSProtectionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures the level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnSourceDDoSProtectionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "onSourceDDoSProtectionConfig", value);
    }

    /**
     * Configures the level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOnSourceDDoSProtectionConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wafv2.CfnWebACL.OnSourceDDoSProtectionConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "onSourceDDoSProtectionConfig", value);
    }

    /**
     * The rule statements used to identify the web requests that you want to manage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRules() {
        return software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The rule statements used to identify the web requests that you want to manage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRules(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "rules", value);
    }

    /**
     * The rule statements used to identify the web requests that you want to manage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRules(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.wafv2.CfnWebACL.RuleProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.wafv2.CfnWebACL.RuleProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "rules", value);
    }

    /**
     * Key:value pairs associated with an AWS resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Key:value pairs associated with an AWS resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Specifies the domains that AWS WAF should accept in a web request token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTokenDomains() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tokenDomains", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Specifies the domains that AWS WAF should accept in a web request token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTokenDomains(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tokenDomains", value);
    }
    /**
     * Details for your use of the account creation fraud prevention managed rule group, <code>AWSManagedRulesACFPRuleSet</code> .
     * <p>
     * This configuration is used in <code>ManagedRuleGroupConfig</code> .
     * <p>
     * For additional information about this and the other intelligent threat mitigation rule groups, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-managed-protections">Intelligent threat mitigation in AWS WAF</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list">AWS Managed Rules rule groups list</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * AWSManagedRulesACFPRuleSetProperty aWSManagedRulesACFPRuleSetProperty = AWSManagedRulesACFPRuleSetProperty.builder()
     *         .creationPath("creationPath")
     *         .registrationPagePath("registrationPagePath")
     *         .requestInspection(RequestInspectionACFPProperty.builder()
     *                 .payloadType("payloadType")
     *                 // the properties below are optional
     *                 .addressFields(List.of(FieldIdentifierProperty.builder()
     *                         .identifier("identifier")
     *                         .build()))
     *                 .emailField(FieldIdentifierProperty.builder()
     *                         .identifier("identifier")
     *                         .build())
     *                 .passwordField(FieldIdentifierProperty.builder()
     *                         .identifier("identifier")
     *                         .build())
     *                 .phoneNumberFields(List.of(FieldIdentifierProperty.builder()
     *                         .identifier("identifier")
     *                         .build()))
     *                 .usernameField(FieldIdentifierProperty.builder()
     *                         .identifier("identifier")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .enableRegexInPath(false)
     *         .responseInspection(ResponseInspectionProperty.builder()
     *                 .bodyContains(ResponseInspectionBodyContainsProperty.builder()
     *                         .failureStrings(List.of("failureStrings"))
     *                         .successStrings(List.of("successStrings"))
     *                         .build())
     *                 .header(ResponseInspectionHeaderProperty.builder()
     *                         .failureValues(List.of("failureValues"))
     *                         .name("name")
     *                         .successValues(List.of("successValues"))
     *                         .build())
     *                 .json(ResponseInspectionJsonProperty.builder()
     *                         .failureValues(List.of("failureValues"))
     *                         .identifier("identifier")
     *                         .successValues(List.of("successValues"))
     *                         .build())
     *                 .statusCode(ResponseInspectionStatusCodeProperty.builder()
     *                         .failureCodes(List.of(123))
     *                         .successCodes(List.of(123))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesACFPRuleSetProperty")
    @software.amazon.jsii.Jsii.Proxy(AWSManagedRulesACFPRuleSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AWSManagedRulesACFPRuleSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path of the account creation endpoint for your application.
         * <p>
         * This is the page on your website that accepts the completed registration form for a new user. This page must accept <code>POST</code> requests.
         * <p>
         * For example, for the URL <code>https://example.com/web/newaccount</code> , you would provide the path <code>/web/newaccount</code> . Account creation page paths that start with the path that you provide are considered a match. For example <code>/web/newaccount</code> matches the account creation paths <code>/web/newaccount</code> , <code>/web/newaccount/</code> , <code>/web/newaccountPage</code> , and <code>/web/newaccount/thisPage</code> , but doesn't match the path <code>/home/web/newaccount</code> or <code>/website/newaccount</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-creationpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-creationpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCreationPath();

        /**
         * The path of the account registration endpoint for your application.
         * <p>
         * This is the page on your website that presents the registration form to new users.
         * <p>
         * <blockquote>
         * <p>
         * This page must accept <code>GET</code> text/html requests.
         * <p>
         * </blockquote>
         * <p>
         * For example, for the URL <code>https://example.com/web/registration</code> , you would provide the path <code>/web/registration</code> . Registration page paths that start with the path that you provide are considered a match. For example <code>/web/registration</code> matches the registration paths <code>/web/registration</code> , <code>/web/registration/</code> , <code>/web/registrationPage</code> , and <code>/web/registration/thisPage</code> , but doesn't match the path <code>/home/web/registration</code> or <code>/website/registration</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-registrationpagepath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-registrationpagepath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegistrationPagePath();

        /**
         * The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-requestinspection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-requestinspection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRequestInspection();

        /**
         * Allow the use of regular expressions in the registration page path and the account creation path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-enableregexinpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-enableregexinpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableRegexInPath() {
            return null;
        }

        /**
         * The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account creation success rates.
         * <p>
         * <blockquote>
         * <p>
         * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
         * <p>
         * </blockquote>
         * <p>
         * The ACFP rule group evaluates the responses that your protected resources send back to client account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many successful account creation attempts in a short amount of time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-responseinspection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesacfpruleset.html#cfn-wafv2-webacl-awsmanagedrulesacfpruleset-responseinspection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseInspection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AWSManagedRulesACFPRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AWSManagedRulesACFPRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AWSManagedRulesACFPRuleSetProperty> {
            java.lang.String creationPath;
            java.lang.String registrationPagePath;
            java.lang.Object requestInspection;
            java.lang.Object enableRegexInPath;
            java.lang.Object responseInspection;

            /**
             * Sets the value of {@link AWSManagedRulesACFPRuleSetProperty#getCreationPath}
             * @param creationPath The path of the account creation endpoint for your application. This parameter is required.
             *                     This is the page on your website that accepts the completed registration form for a new user. This page must accept <code>POST</code> requests.
             *                     <p>
             *                     For example, for the URL <code>https://example.com/web/newaccount</code> , you would provide the path <code>/web/newaccount</code> . Account creation page paths that start with the path that you provide are considered a match. For example <code>/web/newaccount</code> matches the account creation paths <code>/web/newaccount</code> , <code>/web/newaccount/</code> , <code>/web/newaccountPage</code> , and <code>/web/newaccount/thisPage</code> , but doesn't match the path <code>/home/web/newaccount</code> or <code>/website/newaccount</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder creationPath(java.lang.String creationPath) {
                this.creationPath = creationPath;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesACFPRuleSetProperty#getRegistrationPagePath}
             * @param registrationPagePath The path of the account registration endpoint for your application. This parameter is required.
             *                             This is the page on your website that presents the registration form to new users.
             *                             <p>
             *                             <blockquote>
             *                             <p>
             *                             This page must accept <code>GET</code> text/html requests.
             *                             <p>
             *                             </blockquote>
             *                             <p>
             *                             For example, for the URL <code>https://example.com/web/registration</code> , you would provide the path <code>/web/registration</code> . Registration page paths that start with the path that you provide are considered a match. For example <code>/web/registration</code> matches the registration paths <code>/web/registration</code> , <code>/web/registration/</code> , <code>/web/registrationPage</code> , and <code>/web/registration/thisPage</code> , but doesn't match the path <code>/home/web/registration</code> or <code>/website/registration</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registrationPagePath(java.lang.String registrationPagePath) {
                this.registrationPagePath = registrationPagePath;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesACFPRuleSetProperty#getRequestInspection}
             * @param requestInspection The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestInspection(software.amazon.awscdk.IResolvable requestInspection) {
                this.requestInspection = requestInspection;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesACFPRuleSetProperty#getRequestInspection}
             * @param requestInspection The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestInspection(software.amazon.awscdk.services.wafv2.CfnWebACL.RequestInspectionACFPProperty requestInspection) {
                this.requestInspection = requestInspection;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesACFPRuleSetProperty#getEnableRegexInPath}
             * @param enableRegexInPath Allow the use of regular expressions in the registration page path and the account creation path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableRegexInPath(java.lang.Boolean enableRegexInPath) {
                this.enableRegexInPath = enableRegexInPath;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesACFPRuleSetProperty#getEnableRegexInPath}
             * @param enableRegexInPath Allow the use of regular expressions in the registration page path and the account creation path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableRegexInPath(software.amazon.awscdk.IResolvable enableRegexInPath) {
                this.enableRegexInPath = enableRegexInPath;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesACFPRuleSetProperty#getResponseInspection}
             * @param responseInspection The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account creation success rates.
             *                           <blockquote>
             *                           <p>
             *                           Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
             *                           <p>
             *                           </blockquote>
             *                           <p>
             *                           The ACFP rule group evaluates the responses that your protected resources send back to client account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many successful account creation attempts in a short amount of time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseInspection(software.amazon.awscdk.IResolvable responseInspection) {
                this.responseInspection = responseInspection;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesACFPRuleSetProperty#getResponseInspection}
             * @param responseInspection The criteria for inspecting responses to account creation requests, used by the ACFP rule group to track account creation success rates.
             *                           <blockquote>
             *                           <p>
             *                           Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
             *                           <p>
             *                           </blockquote>
             *                           <p>
             *                           The ACFP rule group evaluates the responses that your protected resources send back to client account creation attempts, keeping count of successful and failed attempts from each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many successful account creation attempts in a short amount of time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseInspection(software.amazon.awscdk.services.wafv2.CfnWebACL.ResponseInspectionProperty responseInspection) {
                this.responseInspection = responseInspection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AWSManagedRulesACFPRuleSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AWSManagedRulesACFPRuleSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AWSManagedRulesACFPRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AWSManagedRulesACFPRuleSetProperty {
            private final java.lang.String creationPath;
            private final java.lang.String registrationPagePath;
            private final java.lang.Object requestInspection;
            private final java.lang.Object enableRegexInPath;
            private final java.lang.Object responseInspection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.creationPath = software.amazon.jsii.Kernel.get(this, "creationPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.registrationPagePath = software.amazon.jsii.Kernel.get(this, "registrationPagePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.requestInspection = software.amazon.jsii.Kernel.get(this, "requestInspection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enableRegexInPath = software.amazon.jsii.Kernel.get(this, "enableRegexInPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.responseInspection = software.amazon.jsii.Kernel.get(this, "responseInspection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.creationPath = java.util.Objects.requireNonNull(builder.creationPath, "creationPath is required");
                this.registrationPagePath = java.util.Objects.requireNonNull(builder.registrationPagePath, "registrationPagePath is required");
                this.requestInspection = java.util.Objects.requireNonNull(builder.requestInspection, "requestInspection is required");
                this.enableRegexInPath = builder.enableRegexInPath;
                this.responseInspection = builder.responseInspection;
            }

            @Override
            public final java.lang.String getCreationPath() {
                return this.creationPath;
            }

            @Override
            public final java.lang.String getRegistrationPagePath() {
                return this.registrationPagePath;
            }

            @Override
            public final java.lang.Object getRequestInspection() {
                return this.requestInspection;
            }

            @Override
            public final java.lang.Object getEnableRegexInPath() {
                return this.enableRegexInPath;
            }

            @Override
            public final java.lang.Object getResponseInspection() {
                return this.responseInspection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("creationPath", om.valueToTree(this.getCreationPath()));
                data.set("registrationPagePath", om.valueToTree(this.getRegistrationPagePath()));
                data.set("requestInspection", om.valueToTree(this.getRequestInspection()));
                if (this.getEnableRegexInPath() != null) {
                    data.set("enableRegexInPath", om.valueToTree(this.getEnableRegexInPath()));
                }
                if (this.getResponseInspection() != null) {
                    data.set("responseInspection", om.valueToTree(this.getResponseInspection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesACFPRuleSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AWSManagedRulesACFPRuleSetProperty.Jsii$Proxy that = (AWSManagedRulesACFPRuleSetProperty.Jsii$Proxy) o;

                if (!creationPath.equals(that.creationPath)) return false;
                if (!registrationPagePath.equals(that.registrationPagePath)) return false;
                if (!requestInspection.equals(that.requestInspection)) return false;
                if (this.enableRegexInPath != null ? !this.enableRegexInPath.equals(that.enableRegexInPath) : that.enableRegexInPath != null) return false;
                return this.responseInspection != null ? this.responseInspection.equals(that.responseInspection) : that.responseInspection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.creationPath.hashCode();
                result = 31 * result + (this.registrationPagePath.hashCode());
                result = 31 * result + (this.requestInspection.hashCode());
                result = 31 * result + (this.enableRegexInPath != null ? this.enableRegexInPath.hashCode() : 0);
                result = 31 * result + (this.responseInspection != null ? this.responseInspection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details for your use of the account takeover prevention managed rule group, <code>AWSManagedRulesATPRuleSet</code> .
     * <p>
     * This configuration is used in <code>ManagedRuleGroupConfig</code> .
     * <p>
     * For additional information about this and the other intelligent threat mitigation rule groups, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-managed-protections">Intelligent threat mitigation in AWS WAF</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list">AWS Managed Rules rule groups list</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * AWSManagedRulesATPRuleSetProperty aWSManagedRulesATPRuleSetProperty = AWSManagedRulesATPRuleSetProperty.builder()
     *         .loginPath("loginPath")
     *         // the properties below are optional
     *         .enableRegexInPath(false)
     *         .requestInspection(RequestInspectionProperty.builder()
     *                 .passwordField(FieldIdentifierProperty.builder()
     *                         .identifier("identifier")
     *                         .build())
     *                 .payloadType("payloadType")
     *                 .usernameField(FieldIdentifierProperty.builder()
     *                         .identifier("identifier")
     *                         .build())
     *                 .build())
     *         .responseInspection(ResponseInspectionProperty.builder()
     *                 .bodyContains(ResponseInspectionBodyContainsProperty.builder()
     *                         .failureStrings(List.of("failureStrings"))
     *                         .successStrings(List.of("successStrings"))
     *                         .build())
     *                 .header(ResponseInspectionHeaderProperty.builder()
     *                         .failureValues(List.of("failureValues"))
     *                         .name("name")
     *                         .successValues(List.of("successValues"))
     *                         .build())
     *                 .json(ResponseInspectionJsonProperty.builder()
     *                         .failureValues(List.of("failureValues"))
     *                         .identifier("identifier")
     *                         .successValues(List.of("successValues"))
     *                         .build())
     *                 .statusCode(ResponseInspectionStatusCodeProperty.builder()
     *                         .failureCodes(List.of(123))
     *                         .successCodes(List.of(123))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesATPRuleSetProperty")
    @software.amazon.jsii.Jsii.Proxy(AWSManagedRulesATPRuleSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AWSManagedRulesATPRuleSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The path of the login endpoint for your application.
         * <p>
         * For example, for the URL <code>https://example.com/web/login</code> , you would provide the path <code>/web/login</code> . Login paths that start with the path that you provide are considered a match. For example <code>/web/login</code> matches the login paths <code>/web/login</code> , <code>/web/login/</code> , <code>/web/loginPage</code> , and <code>/web/login/thisPage</code> , but doesn't match the login path <code>/home/web/login</code> or <code>/website/login</code> .
         * <p>
         * The rule group inspects only HTTP <code>POST</code> requests to your specified login endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-loginpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-loginpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLoginPath();

        /**
         * Allow the use of regular expressions in the login page path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-enableregexinpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-enableregexinpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableRegexInPath() {
            return null;
        }

        /**
         * The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-requestinspection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-requestinspection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestInspection() {
            return null;
        }

        /**
         * The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates.
         * <p>
         * <blockquote>
         * <p>
         * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
         * <p>
         * </blockquote>
         * <p>
         * The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts for each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many failed login attempts in a short amount of time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-responseinspection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesatpruleset.html#cfn-wafv2-webacl-awsmanagedrulesatpruleset-responseinspection</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseInspection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AWSManagedRulesATPRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AWSManagedRulesATPRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AWSManagedRulesATPRuleSetProperty> {
            java.lang.String loginPath;
            java.lang.Object enableRegexInPath;
            java.lang.Object requestInspection;
            java.lang.Object responseInspection;

            /**
             * Sets the value of {@link AWSManagedRulesATPRuleSetProperty#getLoginPath}
             * @param loginPath The path of the login endpoint for your application. This parameter is required.
             *                  For example, for the URL <code>https://example.com/web/login</code> , you would provide the path <code>/web/login</code> . Login paths that start with the path that you provide are considered a match. For example <code>/web/login</code> matches the login paths <code>/web/login</code> , <code>/web/login/</code> , <code>/web/loginPage</code> , and <code>/web/login/thisPage</code> , but doesn't match the login path <code>/home/web/login</code> or <code>/website/login</code> .
             *                  <p>
             *                  The rule group inspects only HTTP <code>POST</code> requests to your specified login endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loginPath(java.lang.String loginPath) {
                this.loginPath = loginPath;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesATPRuleSetProperty#getEnableRegexInPath}
             * @param enableRegexInPath Allow the use of regular expressions in the login page path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableRegexInPath(java.lang.Boolean enableRegexInPath) {
                this.enableRegexInPath = enableRegexInPath;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesATPRuleSetProperty#getEnableRegexInPath}
             * @param enableRegexInPath Allow the use of regular expressions in the login page path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableRegexInPath(software.amazon.awscdk.IResolvable enableRegexInPath) {
                this.enableRegexInPath = enableRegexInPath;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesATPRuleSetProperty#getRequestInspection}
             * @param requestInspection The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestInspection(software.amazon.awscdk.IResolvable requestInspection) {
                this.requestInspection = requestInspection;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesATPRuleSetProperty#getRequestInspection}
             * @param requestInspection The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestInspection(software.amazon.awscdk.services.wafv2.CfnWebACL.RequestInspectionProperty requestInspection) {
                this.requestInspection = requestInspection;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesATPRuleSetProperty#getResponseInspection}
             * @param responseInspection The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates.
             *                           <blockquote>
             *                           <p>
             *                           Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
             *                           <p>
             *                           </blockquote>
             *                           <p>
             *                           The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts for each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many failed login attempts in a short amount of time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseInspection(software.amazon.awscdk.IResolvable responseInspection) {
                this.responseInspection = responseInspection;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesATPRuleSetProperty#getResponseInspection}
             * @param responseInspection The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates.
             *                           <blockquote>
             *                           <p>
             *                           Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
             *                           <p>
             *                           </blockquote>
             *                           <p>
             *                           The ATP rule group evaluates the responses that your protected resources send back to client login attempts, keeping count of successful and failed attempts for each IP address and client session. Using this information, the rule group labels and mitigates requests from client sessions and IP addresses that have had too many failed login attempts in a short amount of time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseInspection(software.amazon.awscdk.services.wafv2.CfnWebACL.ResponseInspectionProperty responseInspection) {
                this.responseInspection = responseInspection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AWSManagedRulesATPRuleSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AWSManagedRulesATPRuleSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AWSManagedRulesATPRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AWSManagedRulesATPRuleSetProperty {
            private final java.lang.String loginPath;
            private final java.lang.Object enableRegexInPath;
            private final java.lang.Object requestInspection;
            private final java.lang.Object responseInspection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.loginPath = software.amazon.jsii.Kernel.get(this, "loginPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enableRegexInPath = software.amazon.jsii.Kernel.get(this, "enableRegexInPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requestInspection = software.amazon.jsii.Kernel.get(this, "requestInspection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.responseInspection = software.amazon.jsii.Kernel.get(this, "responseInspection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.loginPath = java.util.Objects.requireNonNull(builder.loginPath, "loginPath is required");
                this.enableRegexInPath = builder.enableRegexInPath;
                this.requestInspection = builder.requestInspection;
                this.responseInspection = builder.responseInspection;
            }

            @Override
            public final java.lang.String getLoginPath() {
                return this.loginPath;
            }

            @Override
            public final java.lang.Object getEnableRegexInPath() {
                return this.enableRegexInPath;
            }

            @Override
            public final java.lang.Object getRequestInspection() {
                return this.requestInspection;
            }

            @Override
            public final java.lang.Object getResponseInspection() {
                return this.responseInspection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("loginPath", om.valueToTree(this.getLoginPath()));
                if (this.getEnableRegexInPath() != null) {
                    data.set("enableRegexInPath", om.valueToTree(this.getEnableRegexInPath()));
                }
                if (this.getRequestInspection() != null) {
                    data.set("requestInspection", om.valueToTree(this.getRequestInspection()));
                }
                if (this.getResponseInspection() != null) {
                    data.set("responseInspection", om.valueToTree(this.getResponseInspection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesATPRuleSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AWSManagedRulesATPRuleSetProperty.Jsii$Proxy that = (AWSManagedRulesATPRuleSetProperty.Jsii$Proxy) o;

                if (!loginPath.equals(that.loginPath)) return false;
                if (this.enableRegexInPath != null ? !this.enableRegexInPath.equals(that.enableRegexInPath) : that.enableRegexInPath != null) return false;
                if (this.requestInspection != null ? !this.requestInspection.equals(that.requestInspection) : that.requestInspection != null) return false;
                return this.responseInspection != null ? this.responseInspection.equals(that.responseInspection) : that.responseInspection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.loginPath.hashCode();
                result = 31 * result + (this.enableRegexInPath != null ? this.enableRegexInPath.hashCode() : 0);
                result = 31 * result + (this.requestInspection != null ? this.requestInspection.hashCode() : 0);
                result = 31 * result + (this.responseInspection != null ? this.responseInspection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures the use of the anti-DDoS managed rule group, <code>AWSManagedRulesAntiDDoSRuleSet</code> . This configuration is used in <code>ManagedRuleGroupConfig</code> .
     * <p>
     * The configuration that you provide here determines whether and how the rules in the rule group are used.
     * <p>
     * For additional information about this and the other intelligent threat mitigation rule groups, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-managed-protections">Intelligent threat mitigation in AWS WAF</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list">AWS Managed Rules rule groups list</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * AWSManagedRulesAntiDDoSRuleSetProperty aWSManagedRulesAntiDDoSRuleSetProperty = AWSManagedRulesAntiDDoSRuleSetProperty.builder()
     *         .clientSideActionConfig(ClientSideActionConfigProperty.builder()
     *                 .challenge(ClientSideActionProperty.builder()
     *                         .usageOfAction("usageOfAction")
     *                         // the properties below are optional
     *                         .exemptUriRegularExpressions(List.of(RegexProperty.builder()
     *                                 .regexString("regexString")
     *                                 .build()))
     *                         .sensitivity("sensitivity")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .sensitivityToBlock("sensitivityToBlock")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesantiddosruleset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesantiddosruleset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesAntiDDoSRuleSetProperty")
    @software.amazon.jsii.Jsii.Proxy(AWSManagedRulesAntiDDoSRuleSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AWSManagedRulesAntiDDoSRuleSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configures the request handling that's applied by the managed rule group rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> during a distributed denial of service (DDoS) attack.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesantiddosruleset.html#cfn-wafv2-webacl-awsmanagedrulesantiddosruleset-clientsideactionconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesantiddosruleset.html#cfn-wafv2-webacl-awsmanagedrulesantiddosruleset-clientsideactionconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getClientSideActionConfig();

        /**
         * The sensitivity that the rule group rule <code>DDoSRequests</code> uses when matching against the DDoS suspicion labeling on a request.
         * <p>
         * The managed rule group adds the labeling during DDoS events, before the <code>DDoSRequests</code> rule runs.
         * <p>
         * The higher the sensitivity, the more levels of labeling that the rule matches:
         * <p>
         * <ul>
         * <li>Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an attack, which are the requests with the high suspicion label <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code> .</li>
         * <li>Medium sensitivity causes the rule to match on the medium and high suspicion labels.</li>
         * <li>High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.</li>
         * </ul>
         * <p>
         * Default: <code>LOW</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesantiddosruleset.html#cfn-wafv2-webacl-awsmanagedrulesantiddosruleset-sensitivitytoblock">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesantiddosruleset.html#cfn-wafv2-webacl-awsmanagedrulesantiddosruleset-sensitivitytoblock</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSensitivityToBlock() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AWSManagedRulesAntiDDoSRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AWSManagedRulesAntiDDoSRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AWSManagedRulesAntiDDoSRuleSetProperty> {
            java.lang.Object clientSideActionConfig;
            java.lang.String sensitivityToBlock;

            /**
             * Sets the value of {@link AWSManagedRulesAntiDDoSRuleSetProperty#getClientSideActionConfig}
             * @param clientSideActionConfig Configures the request handling that's applied by the managed rule group rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> during a distributed denial of service (DDoS) attack. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSideActionConfig(software.amazon.awscdk.IResolvable clientSideActionConfig) {
                this.clientSideActionConfig = clientSideActionConfig;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesAntiDDoSRuleSetProperty#getClientSideActionConfig}
             * @param clientSideActionConfig Configures the request handling that's applied by the managed rule group rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> during a distributed denial of service (DDoS) attack. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSideActionConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.ClientSideActionConfigProperty clientSideActionConfig) {
                this.clientSideActionConfig = clientSideActionConfig;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesAntiDDoSRuleSetProperty#getSensitivityToBlock}
             * @param sensitivityToBlock The sensitivity that the rule group rule <code>DDoSRequests</code> uses when matching against the DDoS suspicion labeling on a request.
             *                           The managed rule group adds the labeling during DDoS events, before the <code>DDoSRequests</code> rule runs.
             *                           <p>
             *                           The higher the sensitivity, the more levels of labeling that the rule matches:
             *                           <p>
             *                           <ul>
             *                           <li>Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an attack, which are the requests with the high suspicion label <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code> .</li>
             *                           <li>Medium sensitivity causes the rule to match on the medium and high suspicion labels.</li>
             *                           <li>High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.</li>
             *                           </ul>
             *                           <p>
             *                           Default: <code>LOW</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sensitivityToBlock(java.lang.String sensitivityToBlock) {
                this.sensitivityToBlock = sensitivityToBlock;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AWSManagedRulesAntiDDoSRuleSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AWSManagedRulesAntiDDoSRuleSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AWSManagedRulesAntiDDoSRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AWSManagedRulesAntiDDoSRuleSetProperty {
            private final java.lang.Object clientSideActionConfig;
            private final java.lang.String sensitivityToBlock;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientSideActionConfig = software.amazon.jsii.Kernel.get(this, "clientSideActionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sensitivityToBlock = software.amazon.jsii.Kernel.get(this, "sensitivityToBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientSideActionConfig = java.util.Objects.requireNonNull(builder.clientSideActionConfig, "clientSideActionConfig is required");
                this.sensitivityToBlock = builder.sensitivityToBlock;
            }

            @Override
            public final java.lang.Object getClientSideActionConfig() {
                return this.clientSideActionConfig;
            }

            @Override
            public final java.lang.String getSensitivityToBlock() {
                return this.sensitivityToBlock;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientSideActionConfig", om.valueToTree(this.getClientSideActionConfig()));
                if (this.getSensitivityToBlock() != null) {
                    data.set("sensitivityToBlock", om.valueToTree(this.getSensitivityToBlock()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesAntiDDoSRuleSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AWSManagedRulesAntiDDoSRuleSetProperty.Jsii$Proxy that = (AWSManagedRulesAntiDDoSRuleSetProperty.Jsii$Proxy) o;

                if (!clientSideActionConfig.equals(that.clientSideActionConfig)) return false;
                return this.sensitivityToBlock != null ? this.sensitivityToBlock.equals(that.sensitivityToBlock) : that.sensitivityToBlock == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientSideActionConfig.hashCode();
                result = 31 * result + (this.sensitivityToBlock != null ? this.sensitivityToBlock.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details for your use of the Bot Control managed rule group, <code>AWSManagedRulesBotControlRuleSet</code> .
     * <p>
     * This configuration is used in <code>ManagedRuleGroupConfig</code> .
     * <p>
     * For additional information about this and the other intelligent threat mitigation rule groups, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-managed-protections">Intelligent threat mitigation in AWS WAF</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list">AWS Managed Rules rule groups list</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * AWSManagedRulesBotControlRuleSetProperty aWSManagedRulesBotControlRuleSetProperty = AWSManagedRulesBotControlRuleSetProperty.builder()
     *         .inspectionLevel("inspectionLevel")
     *         // the properties below are optional
     *         .enableMachineLearning(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty")
    @software.amazon.jsii.Jsii.Proxy(AWSManagedRulesBotControlRuleSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AWSManagedRulesBotControlRuleSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The inspection level to use for the Bot Control rule group.
         * <p>
         * The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">AWS WAF Bot Control rule group</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html#cfn-wafv2-webacl-awsmanagedrulesbotcontrolruleset-inspectionlevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html#cfn-wafv2-webacl-awsmanagedrulesbotcontrolruleset-inspectionlevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInspectionLevel();

        /**
         * Applies only to the targeted inspection level.
         * <p>
         * Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine learning is required for the Bot Control rules <code>TGT_ML_CoordinatedActivityLow</code> and <code>TGT_ML_CoordinatedActivityMedium</code> , which
         * inspect for anomalous behavior that might indicate distributed, coordinated bot activity.
         * <p>
         * For more information about this choice, see the listing for these rules in the table at <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules">Bot Control rules listing</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * Default: <code>TRUE</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html#cfn-wafv2-webacl-awsmanagedrulesbotcontrolruleset-enablemachinelearning">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-awsmanagedrulesbotcontrolruleset.html#cfn-wafv2-webacl-awsmanagedrulesbotcontrolruleset-enablemachinelearning</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableMachineLearning() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AWSManagedRulesBotControlRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AWSManagedRulesBotControlRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AWSManagedRulesBotControlRuleSetProperty> {
            java.lang.String inspectionLevel;
            java.lang.Object enableMachineLearning;

            /**
             * Sets the value of {@link AWSManagedRulesBotControlRuleSetProperty#getInspectionLevel}
             * @param inspectionLevel The inspection level to use for the Bot Control rule group. This parameter is required.
             *                        The common level is the least expensive. The targeted level includes all common level rules and adds rules with more advanced inspection criteria. For details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">AWS WAF Bot Control rule group</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inspectionLevel(java.lang.String inspectionLevel) {
                this.inspectionLevel = inspectionLevel;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesBotControlRuleSetProperty#getEnableMachineLearning}
             * @param enableMachineLearning Applies only to the targeted inspection level.
             *                              Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine learning is required for the Bot Control rules <code>TGT_ML_CoordinatedActivityLow</code> and <code>TGT_ML_CoordinatedActivityMedium</code> , which
             *                              inspect for anomalous behavior that might indicate distributed, coordinated bot activity.
             *                              <p>
             *                              For more information about this choice, see the listing for these rules in the table at <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules">Bot Control rules listing</a> in the <em>AWS WAF Developer Guide</em> .
             *                              <p>
             *                              Default: <code>TRUE</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableMachineLearning(java.lang.Boolean enableMachineLearning) {
                this.enableMachineLearning = enableMachineLearning;
                return this;
            }

            /**
             * Sets the value of {@link AWSManagedRulesBotControlRuleSetProperty#getEnableMachineLearning}
             * @param enableMachineLearning Applies only to the targeted inspection level.
             *                              Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Machine learning is required for the Bot Control rules <code>TGT_ML_CoordinatedActivityLow</code> and <code>TGT_ML_CoordinatedActivityMedium</code> , which
             *                              inspect for anomalous behavior that might indicate distributed, coordinated bot activity.
             *                              <p>
             *                              For more information about this choice, see the listing for these rules in the table at <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html#aws-managed-rule-groups-bot-rules">Bot Control rules listing</a> in the <em>AWS WAF Developer Guide</em> .
             *                              <p>
             *                              Default: <code>TRUE</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableMachineLearning(software.amazon.awscdk.IResolvable enableMachineLearning) {
                this.enableMachineLearning = enableMachineLearning;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AWSManagedRulesBotControlRuleSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AWSManagedRulesBotControlRuleSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AWSManagedRulesBotControlRuleSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AWSManagedRulesBotControlRuleSetProperty {
            private final java.lang.String inspectionLevel;
            private final java.lang.Object enableMachineLearning;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inspectionLevel = software.amazon.jsii.Kernel.get(this, "inspectionLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enableMachineLearning = software.amazon.jsii.Kernel.get(this, "enableMachineLearning", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inspectionLevel = java.util.Objects.requireNonNull(builder.inspectionLevel, "inspectionLevel is required");
                this.enableMachineLearning = builder.enableMachineLearning;
            }

            @Override
            public final java.lang.String getInspectionLevel() {
                return this.inspectionLevel;
            }

            @Override
            public final java.lang.Object getEnableMachineLearning() {
                return this.enableMachineLearning;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inspectionLevel", om.valueToTree(this.getInspectionLevel()));
                if (this.getEnableMachineLearning() != null) {
                    data.set("enableMachineLearning", om.valueToTree(this.getEnableMachineLearning()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AWSManagedRulesBotControlRuleSetProperty.Jsii$Proxy that = (AWSManagedRulesBotControlRuleSetProperty.Jsii$Proxy) o;

                if (!inspectionLevel.equals(that.inspectionLevel)) return false;
                return this.enableMachineLearning != null ? this.enableMachineLearning.equals(that.enableMachineLearning) : that.enableMachineLearning == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inspectionLevel.hashCode();
                result = 31 * result + (this.enableMachineLearning != null ? this.enableMachineLearning.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies that AWS WAF should allow the request and optionally defines additional custom handling for the request.
     * <p>
     * This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * AllowActionProperty allowActionProperty = AllowActionProperty.builder()
     *         .customRequestHandling(CustomRequestHandlingProperty.builder()
     *                 .insertHeaders(List.of(CustomHTTPHeaderProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-allowaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-allowaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.AllowActionProperty")
    @software.amazon.jsii.Jsii.Proxy(AllowActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AllowActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines custom handling for the web request.
         * <p>
         * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-allowaction.html#cfn-wafv2-webacl-allowaction-customrequesthandling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-allowaction.html#cfn-wafv2-webacl-allowaction-customrequesthandling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomRequestHandling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AllowActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AllowActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AllowActionProperty> {
            java.lang.Object customRequestHandling;

            /**
             * Sets the value of {@link AllowActionProperty#getCustomRequestHandling}
             * @param customRequestHandling Defines custom handling for the web request.
             *                              For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRequestHandling(software.amazon.awscdk.IResolvable customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            /**
             * Sets the value of {@link AllowActionProperty#getCustomRequestHandling}
             * @param customRequestHandling Defines custom handling for the web request.
             *                              For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRequestHandling(software.amazon.awscdk.services.wafv2.CfnWebACL.CustomRequestHandlingProperty customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AllowActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AllowActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AllowActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AllowActionProperty {
            private final java.lang.Object customRequestHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customRequestHandling = software.amazon.jsii.Kernel.get(this, "customRequestHandling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customRequestHandling = builder.customRequestHandling;
            }

            @Override
            public final java.lang.Object getCustomRequestHandling() {
                return this.customRequestHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomRequestHandling() != null) {
                    data.set("customRequestHandling", om.valueToTree(this.getCustomRequestHandling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.AllowActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AllowActionProperty.Jsii$Proxy that = (AllowActionProperty.Jsii$Proxy) o;

                return this.customRequestHandling != null ? this.customRequestHandling.equals(that.customRequestHandling) : that.customRequestHandling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customRequestHandling != null ? this.customRequestHandling.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A logical rule statement used to combine other rule statements with AND logic.
     * <p>
     * You provide more than one <code>Statement</code> within the <code>AndStatement</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.AndStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(AndStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AndStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The statements to combine with AND logic.
         * <p>
         * You can use any statements that can be nested.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatement.html#cfn-wafv2-webacl-andstatement-statements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-andstatement.html#cfn-wafv2-webacl-andstatement-statements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatements();

        /**
         * @return a {@link Builder} of {@link AndStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AndStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AndStatementProperty> {
            java.lang.Object statements;

            /**
             * Sets the value of {@link AndStatementProperty#getStatements}
             * @param statements The statements to combine with AND logic. This parameter is required.
             *                   You can use any statements that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statements(software.amazon.awscdk.IResolvable statements) {
                this.statements = statements;
                return this;
            }

            /**
             * Sets the value of {@link AndStatementProperty#getStatements}
             * @param statements The statements to combine with AND logic. This parameter is required.
             *                   You can use any statements that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statements(java.util.List<? extends java.lang.Object> statements) {
                this.statements = statements;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AndStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AndStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AndStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AndStatementProperty {
            private final java.lang.Object statements;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statements = software.amazon.jsii.Kernel.get(this, "statements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statements = java.util.Objects.requireNonNull(builder.statements, "statements is required");
            }

            @Override
            public final java.lang.Object getStatements() {
                return this.statements;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statements", om.valueToTree(this.getStatements()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.AndStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AndStatementProperty.Jsii$Proxy that = (AndStatementProperty.Jsii$Proxy) o;

                return this.statements.equals(that.statements);
            }

            @Override
            public final int hashCode() {
                int result = this.statements.hashCode();
                return result;
            }
        }
    }
    /**
     * A rule statement that inspects web traffic based on the Autonomous System Number (ASN) associated with the request's IP address.
     * <p>
     * For additional details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-asn-match.html">ASN match rule statement</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * AsnMatchStatementProperty asnMatchStatementProperty = AsnMatchStatementProperty.builder()
     *         .asnList(List.of(123))
     *         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                 .fallbackBehavior("fallbackBehavior")
     *                 .headerName("headerName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-asnmatchstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-asnmatchstatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.AsnMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(AsnMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AsnMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains one or more Autonomous System Numbers (ASNs).
         * <p>
         * ASNs are unique identifiers assigned to large internet networks managed by organizations such as internet service providers, enterprises, universities, or government agencies.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-asnmatchstatement.html#cfn-wafv2-webacl-asnmatchstatement-asnlist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-asnmatchstatement.html#cfn-wafv2-webacl-asnmatchstatement-asnlist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAsnList() {
            return null;
        }

        /**
         * The configuration for inspecting IP addresses to match against an ASN in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
         * <p>
         * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-asnmatchstatement.html#cfn-wafv2-webacl-asnmatchstatement-forwardedipconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-asnmatchstatement.html#cfn-wafv2-webacl-asnmatchstatement-forwardedipconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedIpConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AsnMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AsnMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AsnMatchStatementProperty> {
            java.lang.Object asnList;
            java.lang.Object forwardedIpConfig;

            /**
             * Sets the value of {@link AsnMatchStatementProperty#getAsnList}
             * @param asnList Contains one or more Autonomous System Numbers (ASNs).
             *                ASNs are unique identifiers assigned to large internet networks managed by organizations such as internet service providers, enterprises, universities, or government agencies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder asnList(java.util.List<? extends java.lang.Number> asnList) {
                this.asnList = asnList;
                return this;
            }

            /**
             * Sets the value of {@link AsnMatchStatementProperty#getAsnList}
             * @param asnList Contains one or more Autonomous System Numbers (ASNs).
             *                ASNs are unique identifiers assigned to large internet networks managed by organizations such as internet service providers, enterprises, universities, or government agencies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder asnList(software.amazon.awscdk.IResolvable asnList) {
                this.asnList = asnList;
                return this;
            }

            /**
             * Sets the value of {@link AsnMatchStatementProperty#getForwardedIpConfig}
             * @param forwardedIpConfig The configuration for inspecting IP addresses to match against an ASN in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                          Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIpConfig(software.amazon.awscdk.IResolvable forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link AsnMatchStatementProperty#getForwardedIpConfig}
             * @param forwardedIpConfig The configuration for inspecting IP addresses to match against an ASN in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                          Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIpConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.ForwardedIPConfigurationProperty forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AsnMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AsnMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AsnMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AsnMatchStatementProperty {
            private final java.lang.Object asnList;
            private final java.lang.Object forwardedIpConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.asnList = software.amazon.jsii.Kernel.get(this, "asnList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.forwardedIpConfig = software.amazon.jsii.Kernel.get(this, "forwardedIpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.asnList = builder.asnList;
                this.forwardedIpConfig = builder.forwardedIpConfig;
            }

            @Override
            public final java.lang.Object getAsnList() {
                return this.asnList;
            }

            @Override
            public final java.lang.Object getForwardedIpConfig() {
                return this.forwardedIpConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAsnList() != null) {
                    data.set("asnList", om.valueToTree(this.getAsnList()));
                }
                if (this.getForwardedIpConfig() != null) {
                    data.set("forwardedIpConfig", om.valueToTree(this.getForwardedIpConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.AsnMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AsnMatchStatementProperty.Jsii$Proxy that = (AsnMatchStatementProperty.Jsii$Proxy) o;

                if (this.asnList != null ? !this.asnList.equals(that.asnList) : that.asnList != null) return false;
                return this.forwardedIpConfig != null ? this.forwardedIpConfig.equals(that.forwardedIpConfig) : that.forwardedIpConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.asnList != null ? this.asnList.hashCode() : 0;
                result = 31 * result + (this.forwardedIpConfig != null ? this.forwardedIpConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies custom configurations for the associations between the web ACL and protected resources.
     * <p>
     * Use this to customize the maximum size of the request body that your protected resources forward to AWS WAF for inspection. You can customize this setting for CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resources. The default setting is 16 KB (16,384 bytes).
     * <p>
     * <blockquote>
     * <p>
     * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="https://docs.aws.amazon.com/waf/pricing/">AWS WAF Pricing</a> .
     * <p>
     * </blockquote>
     * <p>
     * For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * AssociationConfigProperty associationConfigProperty = AssociationConfigProperty.builder()
     *         .requestBody(Map.of(
     *                 "requestBodyKey", RequestBodyAssociatedResourceTypeConfigProperty.builder()
     *                         .defaultSizeInspectionLimit("defaultSizeInspectionLimit")
     *                         .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-associationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-associationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.AssociationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AssociationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssociationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to AWS WAF for inspection.
         * <p>
         * The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types.
         * <p>
         * <blockquote>
         * <p>
         * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="https://docs.aws.amazon.com/waf/pricing/">AWS WAF Pricing</a> .
         * <p>
         * </blockquote>
         * <p>
         * Example JSON: <code>{ "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }</code>
         * <p>
         * For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-associationconfig.html#cfn-wafv2-webacl-associationconfig-requestbody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-associationconfig.html#cfn-wafv2-webacl-associationconfig-requestbody</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRequestBody() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssociationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssociationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssociationConfigProperty> {
            java.lang.Object requestBody;

            /**
             * Sets the value of {@link AssociationConfigProperty#getRequestBody}
             * @param requestBody Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to AWS WAF for inspection.
             *                    The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="https://docs.aws.amazon.com/waf/pricing/">AWS WAF Pricing</a> .
             *                    <p>
             *                    </blockquote>
             *                    <p>
             *                    Example JSON: <code>{ "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }</code>
             *                    <p>
             *                    For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestBody(software.amazon.awscdk.IResolvable requestBody) {
                this.requestBody = requestBody;
                return this;
            }

            /**
             * Sets the value of {@link AssociationConfigProperty#getRequestBody}
             * @param requestBody Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to AWS WAF for inspection.
             *                    The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types.
             *                    <p>
             *                    <blockquote>
             *                    <p>
             *                    You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="https://docs.aws.amazon.com/waf/pricing/">AWS WAF Pricing</a> .
             *                    <p>
             *                    </blockquote>
             *                    <p>
             *                    Example JSON: <code>{ "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }</code>
             *                    <p>
             *                    For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requestBody(java.util.Map<java.lang.String, ? extends java.lang.Object> requestBody) {
                this.requestBody = requestBody;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssociationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssociationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssociationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssociationConfigProperty {
            private final java.lang.Object requestBody;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.requestBody = software.amazon.jsii.Kernel.get(this, "requestBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.requestBody = builder.requestBody;
            }

            @Override
            public final java.lang.Object getRequestBody() {
                return this.requestBody;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRequestBody() != null) {
                    data.set("requestBody", om.valueToTree(this.getRequestBody()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.AssociationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssociationConfigProperty.Jsii$Proxy that = (AssociationConfigProperty.Jsii$Proxy) o;

                return this.requestBody != null ? this.requestBody.equals(that.requestBody) : that.requestBody == null;
            }

            @Override
            public final int hashCode() {
                int result = this.requestBody != null ? this.requestBody.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies that AWS WAF should block the request and optionally defines additional custom handling for the response to the web request.
     * <p>
     * This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * BlockActionProperty blockActionProperty = BlockActionProperty.builder()
     *         .customResponse(CustomResponseProperty.builder()
     *                 .responseCode(123)
     *                 // the properties below are optional
     *                 .customResponseBodyKey("customResponseBodyKey")
     *                 .responseHeaders(List.of(CustomHTTPHeaderProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-blockaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-blockaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.BlockActionProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines a custom response for the web request.
         * <p>
         * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-blockaction.html#cfn-wafv2-webacl-blockaction-customresponse">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-blockaction.html#cfn-wafv2-webacl-blockaction-customresponse</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomResponse() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BlockActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlockActionProperty> {
            java.lang.Object customResponse;

            /**
             * Sets the value of {@link BlockActionProperty#getCustomResponse}
             * @param customResponse Defines a custom response for the web request.
             *                       For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customResponse(software.amazon.awscdk.IResolvable customResponse) {
                this.customResponse = customResponse;
                return this;
            }

            /**
             * Sets the value of {@link BlockActionProperty#getCustomResponse}
             * @param customResponse Defines a custom response for the web request.
             *                       For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customResponse(software.amazon.awscdk.services.wafv2.CfnWebACL.CustomResponseProperty customResponse) {
                this.customResponse = customResponse;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlockActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlockActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockActionProperty {
            private final java.lang.Object customResponse;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customResponse = software.amazon.jsii.Kernel.get(this, "customResponse", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customResponse = builder.customResponse;
            }

            @Override
            public final java.lang.Object getCustomResponse() {
                return this.customResponse;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomResponse() != null) {
                    data.set("customResponse", om.valueToTree(this.getCustomResponse()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.BlockActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockActionProperty.Jsii$Proxy that = (BlockActionProperty.Jsii$Proxy) o;

                return this.customResponse != null ? this.customResponse.equals(that.customResponse) : that.customResponse == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customResponse != null ? this.customResponse.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Inspect the body of the web request. The body immediately follows the request headers.
     * <p>
     * This is used to indicate the web request component to inspect, in the <code>FieldToMatch</code> specification.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * BodyProperty bodyProperty = BodyProperty.builder()
     *         .oversizeHandling("oversizeHandling")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-body.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-body.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.BodyProperty")
    @software.amazon.jsii.Jsii.Proxy(BodyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BodyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * What AWS WAF should do if the body is larger than AWS WAF can inspect.
         * <p>
         * AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
         * <p>
         * <ul>
         * <li>For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).</li>
         * <li>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code> , for additional processing fees.</li>
         * <li>For AWS Amplify , use the CloudFront limit.</li>
         * </ul>
         * <p>
         * The options for oversize handling are the following:
         * <p>
         * <ul>
         * <li><code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection criteria.</li>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.
         * <p>
         * Default: <code>CONTINUE</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-body.html#cfn-wafv2-webacl-body-oversizehandling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-body.html#cfn-wafv2-webacl-body-oversizehandling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOversizeHandling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BodyProperty> {
            java.lang.String oversizeHandling;

            /**
             * Sets the value of {@link BodyProperty#getOversizeHandling}
             * @param oversizeHandling What AWS WAF should do if the body is larger than AWS WAF can inspect.
             *                         AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
             *                         <p>
             *                         <ul>
             *                         <li>For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).</li>
             *                         <li>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code> , for additional processing fees.</li>
             *                         <li>For AWS Amplify , use the CloudFront limit.</li>
             *                         </ul>
             *                         <p>
             *                         The options for oversize handling are the following:
             *                         <p>
             *                         <ul>
             *                         <li><code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection criteria.</li>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             *                         <p>
             *                         You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.
             *                         <p>
             *                         Default: <code>CONTINUE</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oversizeHandling(java.lang.String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BodyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BodyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BodyProperty {
            private final java.lang.String oversizeHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.oversizeHandling = software.amazon.jsii.Kernel.get(this, "oversizeHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.oversizeHandling = builder.oversizeHandling;
            }

            @Override
            public final java.lang.String getOversizeHandling() {
                return this.oversizeHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOversizeHandling() != null) {
                    data.set("oversizeHandling", om.valueToTree(this.getOversizeHandling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.BodyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BodyProperty.Jsii$Proxy that = (BodyProperty.Jsii$Proxy) o;

                return this.oversizeHandling != null ? this.oversizeHandling.equals(that.oversizeHandling) : that.oversizeHandling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.oversizeHandling != null ? this.oversizeHandling.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A rule statement that defines a string match search for AWS WAF to apply to web requests.
     * <p>
     * The byte match statement provides the bytes to search for, the location in requests that you want AWS WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the AWS WAF console and the developer guide, this is called a string match statement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * ByteMatchStatementProperty byteMatchStatementProperty = ByteMatchStatementProperty.builder()
     *         .fieldToMatch(FieldToMatchProperty.builder()
     *                 .allQueryArguments(allQueryArguments)
     *                 .body(BodyProperty.builder()
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .cookies(CookiesProperty.builder()
     *                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedCookies(List.of("excludedCookies"))
     *                                 .includedCookies(List.of("includedCookies"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .headers(HeadersProperty.builder()
     *                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                 .includedHeaders(List.of("includedHeaders"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .ja3Fingerprint(JA3FingerprintProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .build())
     *                 .ja4Fingerprint(JA4FingerprintProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .build())
     *                 .jsonBody(JsonBodyProperty.builder()
     *                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .includedPaths(List.of("includedPaths"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         // the properties below are optional
     *                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .method(method)
     *                 .queryString(queryString)
     *                 .singleHeader(singleHeader)
     *                 .singleQueryArgument(singleQueryArgument)
     *                 .uriFragment(UriFragmentProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .build())
     *                 .uriPath(uriPath)
     *                 .build())
     *         .positionalConstraint("positionalConstraint")
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         // the properties below are optional
     *         .searchString("searchString")
     *         .searchStringBase64("searchStringBase64")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ByteMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(ByteMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ByteMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The part of the web request that you want AWS WAF to inspect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-fieldtomatch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-fieldtomatch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldToMatch();

        /**
         * The area within the portion of the web request that you want AWS WAF to search for <code>SearchString</code> .
         * <p>
         * Valid values include the following:
         * <p>
         * <em>CONTAINS</em>
         * <p>
         * The specified part of the web request must include the value of <code>SearchString</code> , but the location doesn't matter.
         * <p>
         * <em>CONTAINS_WORD</em>
         * <p>
         * The specified part of the web request must include the value of <code>SearchString</code> , and <code>SearchString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>SearchString</code> must be a word, which means that both of the following are true:
         * <p>
         * <ul>
         * <li><code>SearchString</code> is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and <code>;BadBot</code> .</li>
         * <li><code>SearchString</code> is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code> and <code>-BadBot;</code> .</li>
         * </ul>
         * <p>
         * <em>EXACTLY</em>
         * <p>
         * The value of the specified part of the web request must exactly match the value of <code>SearchString</code> .
         * <p>
         * <em>STARTS_WITH</em>
         * <p>
         * The value of <code>SearchString</code> must appear at the beginning of the specified part of the web request.
         * <p>
         * <em>ENDS_WITH</em>
         * <p>
         * The value of <code>SearchString</code> must appear at the end of the specified part of the web request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-positionalconstraint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-positionalconstraint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPositionalConstraint();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-texttransformations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-texttransformations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * A string value that you want AWS WAF to search for.
         * <p>
         * AWS WAF searches only in the part of web requests that you designate for inspection in <code>FieldToMatch</code> . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.
         * <p>
         * Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.
         * <p>
         * For example, suppose the value of <code>Type</code> is <code>HEADER</code> and the value of <code>Data</code> is <code>User-Agent</code> . If you want to search the <code>User-Agent</code> header for the value <code>BadBot</code> , you provide the string <code>BadBot</code> in the value of <code>SearchString</code> .
         * <p>
         * You must specify either <code>SearchString</code> or <code>SearchStringBase64</code> in a <code>ByteMatchStatement</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSearchString() {
            return null;
        }

        /**
         * String to search for in a web request component, base64-encoded.
         * <p>
         * If you don't want to encode the string, specify the unencoded value in <code>SearchString</code> instead.
         * <p>
         * You must specify either <code>SearchString</code> or <code>SearchStringBase64</code> in a <code>ByteMatchStatement</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstringbase64">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-bytematchstatement.html#cfn-wafv2-webacl-bytematchstatement-searchstringbase64</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSearchStringBase64() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ByteMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ByteMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ByteMatchStatementProperty> {
            java.lang.Object fieldToMatch;
            java.lang.String positionalConstraint;
            java.lang.Object textTransformations;
            java.lang.String searchString;
            java.lang.String searchStringBase64;

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getPositionalConstraint}
             * @param positionalConstraint The area within the portion of the web request that you want AWS WAF to search for <code>SearchString</code> . This parameter is required.
             *                             Valid values include the following:
             *                             <p>
             *                             <em>CONTAINS</em>
             *                             <p>
             *                             The specified part of the web request must include the value of <code>SearchString</code> , but the location doesn't matter.
             *                             <p>
             *                             <em>CONTAINS_WORD</em>
             *                             <p>
             *                             The specified part of the web request must include the value of <code>SearchString</code> , and <code>SearchString</code> must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, <code>SearchString</code> must be a word, which means that both of the following are true:
             *                             <p>
             *                             <ul>
             *                             <li><code>SearchString</code> is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and <code>;BadBot</code> .</li>
             *                             <li><code>SearchString</code> is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, <code>BadBot;</code> and <code>-BadBot;</code> .</li>
             *                             </ul>
             *                             <p>
             *                             <em>EXACTLY</em>
             *                             <p>
             *                             The value of the specified part of the web request must exactly match the value of <code>SearchString</code> .
             *                             <p>
             *                             <em>STARTS_WITH</em>
             *                             <p>
             *                             The value of <code>SearchString</code> must appear at the beginning of the specified part of the web request.
             *                             <p>
             *                             <em>ENDS_WITH</em>
             *                             <p>
             *                             The value of <code>SearchString</code> must appear at the end of the specified part of the web request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder positionalConstraint(java.lang.String positionalConstraint) {
                this.positionalConstraint = positionalConstraint;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getSearchString}
             * @param searchString A string value that you want AWS WAF to search for.
             *                     AWS WAF searches only in the part of web requests that you designate for inspection in <code>FieldToMatch</code> . The maximum length of the value is 200 bytes. For alphabetic characters A-Z and a-z, the value is case sensitive.
             *                     <p>
             *                     Don't encode this string. Provide the value that you want AWS WAF to search for. AWS CloudFormation automatically base64 encodes the value for you.
             *                     <p>
             *                     For example, suppose the value of <code>Type</code> is <code>HEADER</code> and the value of <code>Data</code> is <code>User-Agent</code> . If you want to search the <code>User-Agent</code> header for the value <code>BadBot</code> , you provide the string <code>BadBot</code> in the value of <code>SearchString</code> .
             *                     <p>
             *                     You must specify either <code>SearchString</code> or <code>SearchStringBase64</code> in a <code>ByteMatchStatement</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder searchString(java.lang.String searchString) {
                this.searchString = searchString;
                return this;
            }

            /**
             * Sets the value of {@link ByteMatchStatementProperty#getSearchStringBase64}
             * @param searchStringBase64 String to search for in a web request component, base64-encoded.
             *                           If you don't want to encode the string, specify the unencoded value in <code>SearchString</code> instead.
             *                           <p>
             *                           You must specify either <code>SearchString</code> or <code>SearchStringBase64</code> in a <code>ByteMatchStatement</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder searchStringBase64(java.lang.String searchStringBase64) {
                this.searchStringBase64 = searchStringBase64;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ByteMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ByteMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ByteMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ByteMatchStatementProperty {
            private final java.lang.Object fieldToMatch;
            private final java.lang.String positionalConstraint;
            private final java.lang.Object textTransformations;
            private final java.lang.String searchString;
            private final java.lang.String searchStringBase64;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldToMatch = software.amazon.jsii.Kernel.get(this, "fieldToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.positionalConstraint = software.amazon.jsii.Kernel.get(this, "positionalConstraint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.searchString = software.amazon.jsii.Kernel.get(this, "searchString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.searchStringBase64 = software.amazon.jsii.Kernel.get(this, "searchStringBase64", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldToMatch = java.util.Objects.requireNonNull(builder.fieldToMatch, "fieldToMatch is required");
                this.positionalConstraint = java.util.Objects.requireNonNull(builder.positionalConstraint, "positionalConstraint is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
                this.searchString = builder.searchString;
                this.searchStringBase64 = builder.searchStringBase64;
            }

            @Override
            public final java.lang.Object getFieldToMatch() {
                return this.fieldToMatch;
            }

            @Override
            public final java.lang.String getPositionalConstraint() {
                return this.positionalConstraint;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            public final java.lang.String getSearchString() {
                return this.searchString;
            }

            @Override
            public final java.lang.String getSearchStringBase64() {
                return this.searchStringBase64;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldToMatch", om.valueToTree(this.getFieldToMatch()));
                data.set("positionalConstraint", om.valueToTree(this.getPositionalConstraint()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));
                if (this.getSearchString() != null) {
                    data.set("searchString", om.valueToTree(this.getSearchString()));
                }
                if (this.getSearchStringBase64() != null) {
                    data.set("searchStringBase64", om.valueToTree(this.getSearchStringBase64()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ByteMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ByteMatchStatementProperty.Jsii$Proxy that = (ByteMatchStatementProperty.Jsii$Proxy) o;

                if (!fieldToMatch.equals(that.fieldToMatch)) return false;
                if (!positionalConstraint.equals(that.positionalConstraint)) return false;
                if (!textTransformations.equals(that.textTransformations)) return false;
                if (this.searchString != null ? !this.searchString.equals(that.searchString) : that.searchString != null) return false;
                return this.searchStringBase64 != null ? this.searchStringBase64.equals(that.searchStringBase64) : that.searchStringBase64 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldToMatch.hashCode();
                result = 31 * result + (this.positionalConstraint.hashCode());
                result = 31 * result + (this.textTransformations.hashCode());
                result = 31 * result + (this.searchString != null ? this.searchString.hashCode() : 0);
                result = 31 * result + (this.searchStringBase64 != null ? this.searchStringBase64.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies that AWS WAF should run a <code>CAPTCHA</code> check against the request:.
     * <p>
     * <ul>
     * <li>If the request includes a valid, unexpired <code>CAPTCHA</code> token, AWS WAF allows the web request inspection to proceed to the next rule, similar to a <code>CountAction</code> .</li>
     * <li>If the request doesn't include a valid, unexpired <code>CAPTCHA</code> token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.</li>
     * </ul>
     * <p>
     * AWS WAF generates a response that it sends back to the client, which includes the following:
     * <p>
     * <ul>
     * <li>The header <code>x-amzn-waf-action</code> with a value of <code>captcha</code> .</li>
     * <li>The HTTP status code <code>405 Method Not Allowed</code> .</li>
     * <li>If the request contains an <code>Accept</code> header with a value of <code>text/html</code> , the response includes a <code>CAPTCHA</code> challenge.</li>
     * </ul>
     * <p>
     * You can configure the expiration time in the <code>CaptchaConfig</code> <code>ImmunityTimeProperty</code> setting at the rule and web ACL level. The rule setting overrides the web ACL setting.
     * <p>
     * This action option is available for rules. It isn't available for web ACL default actions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * CaptchaActionProperty captchaActionProperty = CaptchaActionProperty.builder()
     *         .customRequestHandling(CustomRequestHandlingProperty.builder()
     *                 .insertHeaders(List.of(CustomHTTPHeaderProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.CaptchaActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptchaActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptchaActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines custom handling for the web request, used when the <code>CAPTCHA</code> inspection determines that the request's token is valid and unexpired.
         * <p>
         * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaaction.html#cfn-wafv2-webacl-captchaaction-customrequesthandling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaaction.html#cfn-wafv2-webacl-captchaaction-customrequesthandling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomRequestHandling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptchaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptchaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptchaActionProperty> {
            java.lang.Object customRequestHandling;

            /**
             * Sets the value of {@link CaptchaActionProperty#getCustomRequestHandling}
             * @param customRequestHandling Defines custom handling for the web request, used when the <code>CAPTCHA</code> inspection determines that the request's token is valid and unexpired.
             *                              For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRequestHandling(software.amazon.awscdk.IResolvable customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            /**
             * Sets the value of {@link CaptchaActionProperty#getCustomRequestHandling}
             * @param customRequestHandling Defines custom handling for the web request, used when the <code>CAPTCHA</code> inspection determines that the request's token is valid and unexpired.
             *                              For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRequestHandling(software.amazon.awscdk.services.wafv2.CfnWebACL.CustomRequestHandlingProperty customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptchaActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptchaActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptchaActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptchaActionProperty {
            private final java.lang.Object customRequestHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customRequestHandling = software.amazon.jsii.Kernel.get(this, "customRequestHandling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customRequestHandling = builder.customRequestHandling;
            }

            @Override
            public final java.lang.Object getCustomRequestHandling() {
                return this.customRequestHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomRequestHandling() != null) {
                    data.set("customRequestHandling", om.valueToTree(this.getCustomRequestHandling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.CaptchaActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptchaActionProperty.Jsii$Proxy that = (CaptchaActionProperty.Jsii$Proxy) o;

                return this.customRequestHandling != null ? this.customRequestHandling.equals(that.customRequestHandling) : that.customRequestHandling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customRequestHandling != null ? this.customRequestHandling.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies how AWS WAF should handle <code>CAPTCHA</code> evaluations for rules that don't have their own <code>CaptchaConfig</code> settings.
     * <p>
     * If you don't specify this, AWS WAF uses its default settings for <code>CaptchaConfig</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * CaptchaConfigProperty captchaConfigProperty = CaptchaConfigProperty.builder()
     *         .immunityTimeProperty(ImmunityTimePropertyProperty.builder()
     *                 .immunityTime(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.CaptchaConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CaptchaConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CaptchaConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines how long a <code>CAPTCHA</code> timestamp in the token remains valid after the client successfully solves a <code>CAPTCHA</code> puzzle.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaconfig.html#cfn-wafv2-webacl-captchaconfig-immunitytimeproperty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-captchaconfig.html#cfn-wafv2-webacl-captchaconfig-immunitytimeproperty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImmunityTimeProperty() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CaptchaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CaptchaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CaptchaConfigProperty> {
            java.lang.Object immunityTimeProperty;

            /**
             * Sets the value of {@link CaptchaConfigProperty#getImmunityTimeProperty}
             * @param immunityTimeProperty Determines how long a <code>CAPTCHA</code> timestamp in the token remains valid after the client successfully solves a <code>CAPTCHA</code> puzzle.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder immunityTimeProperty(software.amazon.awscdk.IResolvable immunityTimeProperty) {
                this.immunityTimeProperty = immunityTimeProperty;
                return this;
            }

            /**
             * Sets the value of {@link CaptchaConfigProperty#getImmunityTimeProperty}
             * @param immunityTimeProperty Determines how long a <code>CAPTCHA</code> timestamp in the token remains valid after the client successfully solves a <code>CAPTCHA</code> puzzle.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder immunityTimeProperty(software.amazon.awscdk.services.wafv2.CfnWebACL.ImmunityTimePropertyProperty immunityTimeProperty) {
                this.immunityTimeProperty = immunityTimeProperty;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CaptchaConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CaptchaConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CaptchaConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CaptchaConfigProperty {
            private final java.lang.Object immunityTimeProperty;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.immunityTimeProperty = software.amazon.jsii.Kernel.get(this, "immunityTimeProperty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.immunityTimeProperty = builder.immunityTimeProperty;
            }

            @Override
            public final java.lang.Object getImmunityTimeProperty() {
                return this.immunityTimeProperty;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getImmunityTimeProperty() != null) {
                    data.set("immunityTimeProperty", om.valueToTree(this.getImmunityTimeProperty()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.CaptchaConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CaptchaConfigProperty.Jsii$Proxy that = (CaptchaConfigProperty.Jsii$Proxy) o;

                return this.immunityTimeProperty != null ? this.immunityTimeProperty.equals(that.immunityTimeProperty) : that.immunityTimeProperty == null;
            }

            @Override
            public final int hashCode() {
                int result = this.immunityTimeProperty != null ? this.immunityTimeProperty.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies that AWS WAF should run a <code>Challenge</code> check against the request to verify that the request is coming from a legitimate client session:  - If the request includes a valid, unexpired challenge token, AWS WAF applies any custom request handling and labels that you've configured and then allows the web request inspection to proceed to the next rule, similar to a <code>CountAction</code> .
     * <p>
     * <ul>
     * <li>If the request doesn't include a valid, unexpired challenge token, AWS WAF discontinues the web ACL evaluation of the request and blocks it from going to its intended destination.</li>
     * </ul>
     * <p>
     * AWS WAF then generates a challenge response that it sends back to the client, which includes the following:
     * <p>
     * <ul>
     * <li>The header <code>x-amzn-waf-action</code> with a value of <code>challenge</code> .</li>
     * <li>The HTTP status code <code>202 Request Accepted</code> .</li>
     * <li>If the request contains an <code>Accept</code> header with a value of <code>text/html</code> , the response includes a JavaScript page interstitial with a challenge script.</li>
     * </ul>
     * <p>
     * Challenges run silent browser interrogations in the background, and don't generally affect the end user experience.
     * <p>
     * A challenge enforces token acquisition using an interstitial JavaScript challenge that inspects the client session for legitimate behavior. The challenge blocks bots or at least increases the cost of operating sophisticated bots.
     * <p>
     * After the client session successfully responds to the challenge, it receives a new token from AWS WAF , which the challenge script uses to resubmit the original request.
     * <p>
     * You can configure the expiration time in the <code>ChallengeConfig</code> <code>ImmunityTimeProperty</code> setting at the rule and web ACL level. The rule setting overrides the web ACL setting.
     * <p>
     * This action option is available for rules. It isn't available for web ACL default actions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ChallengeActionProperty challengeActionProperty = ChallengeActionProperty.builder()
     *         .customRequestHandling(CustomRequestHandlingProperty.builder()
     *                 .insertHeaders(List.of(CustomHTTPHeaderProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ChallengeActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ChallengeActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChallengeActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.
         * <p>
         * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF developer guide</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeaction.html#cfn-wafv2-webacl-challengeaction-customrequesthandling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeaction.html#cfn-wafv2-webacl-challengeaction-customrequesthandling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomRequestHandling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChallengeActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChallengeActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChallengeActionProperty> {
            java.lang.Object customRequestHandling;

            /**
             * Sets the value of {@link ChallengeActionProperty#getCustomRequestHandling}
             * @param customRequestHandling Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.
             *                              For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF developer guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRequestHandling(software.amazon.awscdk.IResolvable customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            /**
             * Sets the value of {@link ChallengeActionProperty#getCustomRequestHandling}
             * @param customRequestHandling Defines custom handling for the web request, used when the challenge inspection determines that the request's token is valid and unexpired.
             *                              For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF developer guide</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRequestHandling(software.amazon.awscdk.services.wafv2.CfnWebACL.CustomRequestHandlingProperty customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChallengeActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChallengeActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChallengeActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChallengeActionProperty {
            private final java.lang.Object customRequestHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customRequestHandling = software.amazon.jsii.Kernel.get(this, "customRequestHandling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customRequestHandling = builder.customRequestHandling;
            }

            @Override
            public final java.lang.Object getCustomRequestHandling() {
                return this.customRequestHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomRequestHandling() != null) {
                    data.set("customRequestHandling", om.valueToTree(this.getCustomRequestHandling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ChallengeActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChallengeActionProperty.Jsii$Proxy that = (ChallengeActionProperty.Jsii$Proxy) o;

                return this.customRequestHandling != null ? this.customRequestHandling.equals(that.customRequestHandling) : that.customRequestHandling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customRequestHandling != null ? this.customRequestHandling.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies how AWS WAF should handle <code>Challenge</code> evaluations.
     * <p>
     * This is available at the web ACL level and in each rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ChallengeConfigProperty challengeConfigProperty = ChallengeConfigProperty.builder()
     *         .immunityTimeProperty(ImmunityTimePropertyProperty.builder()
     *                 .immunityTime(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ChallengeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ChallengeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ChallengeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeconfig.html#cfn-wafv2-webacl-challengeconfig-immunitytimeproperty">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-challengeconfig.html#cfn-wafv2-webacl-challengeconfig-immunitytimeproperty</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImmunityTimeProperty() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ChallengeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ChallengeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ChallengeConfigProperty> {
            java.lang.Object immunityTimeProperty;

            /**
             * Sets the value of {@link ChallengeConfigProperty#getImmunityTimeProperty}
             * @param immunityTimeProperty Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder immunityTimeProperty(software.amazon.awscdk.IResolvable immunityTimeProperty) {
                this.immunityTimeProperty = immunityTimeProperty;
                return this;
            }

            /**
             * Sets the value of {@link ChallengeConfigProperty#getImmunityTimeProperty}
             * @param immunityTimeProperty Determines how long a challenge timestamp in the token remains valid after the client successfully responds to a challenge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder immunityTimeProperty(software.amazon.awscdk.services.wafv2.CfnWebACL.ImmunityTimePropertyProperty immunityTimeProperty) {
                this.immunityTimeProperty = immunityTimeProperty;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ChallengeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ChallengeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ChallengeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ChallengeConfigProperty {
            private final java.lang.Object immunityTimeProperty;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.immunityTimeProperty = software.amazon.jsii.Kernel.get(this, "immunityTimeProperty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.immunityTimeProperty = builder.immunityTimeProperty;
            }

            @Override
            public final java.lang.Object getImmunityTimeProperty() {
                return this.immunityTimeProperty;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getImmunityTimeProperty() != null) {
                    data.set("immunityTimeProperty", om.valueToTree(this.getImmunityTimeProperty()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ChallengeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ChallengeConfigProperty.Jsii$Proxy that = (ChallengeConfigProperty.Jsii$Proxy) o;

                return this.immunityTimeProperty != null ? this.immunityTimeProperty.equals(that.immunityTimeProperty) : that.immunityTimeProperty == null;
            }

            @Override
            public final int hashCode() {
                int result = this.immunityTimeProperty != null ? this.immunityTimeProperty.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * This is part of the configuration for the managed rules <code>AWSManagedRulesAntiDDoSRuleSet</code> in <code>ManagedRuleGroupConfig</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ClientSideActionConfigProperty clientSideActionConfigProperty = ClientSideActionConfigProperty.builder()
     *         .challenge(ClientSideActionProperty.builder()
     *                 .usageOfAction("usageOfAction")
     *                 // the properties below are optional
     *                 .exemptUriRegularExpressions(List.of(RegexProperty.builder()
     *                         .regexString("regexString")
     *                         .build()))
     *                 .sensitivity("sensitivity")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideactionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideactionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ClientSideActionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientSideActionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientSideActionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration for the use of the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> .
         * <p>
         * <blockquote>
         * <p>
         * This setting isn't related to the configuration of the <code>Challenge</code> action itself. It only configures the use of the two anti-DDoS rules named here.
         * <p>
         * </blockquote>
         * <p>
         * You can enable or disable the use of these rules, and you can configure how to use them when they are enabled.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideactionconfig.html#cfn-wafv2-webacl-clientsideactionconfig-challenge">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideactionconfig.html#cfn-wafv2-webacl-clientsideactionconfig-challenge</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getChallenge();

        /**
         * @return a {@link Builder} of {@link ClientSideActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientSideActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientSideActionConfigProperty> {
            java.lang.Object challenge;

            /**
             * Sets the value of {@link ClientSideActionConfigProperty#getChallenge}
             * @param challenge Configuration for the use of the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> . This parameter is required.
             *                  <blockquote>
             *                  <p>
             *                  This setting isn't related to the configuration of the <code>Challenge</code> action itself. It only configures the use of the two anti-DDoS rules named here.
             *                  <p>
             *                  </blockquote>
             *                  <p>
             *                  You can enable or disable the use of these rules, and you can configure how to use them when they are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder challenge(software.amazon.awscdk.IResolvable challenge) {
                this.challenge = challenge;
                return this;
            }

            /**
             * Sets the value of {@link ClientSideActionConfigProperty#getChallenge}
             * @param challenge Configuration for the use of the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> . This parameter is required.
             *                  <blockquote>
             *                  <p>
             *                  This setting isn't related to the configuration of the <code>Challenge</code> action itself. It only configures the use of the two anti-DDoS rules named here.
             *                  <p>
             *                  </blockquote>
             *                  <p>
             *                  You can enable or disable the use of these rules, and you can configure how to use them when they are enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder challenge(software.amazon.awscdk.services.wafv2.CfnWebACL.ClientSideActionProperty challenge) {
                this.challenge = challenge;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientSideActionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientSideActionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientSideActionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientSideActionConfigProperty {
            private final java.lang.Object challenge;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.challenge = software.amazon.jsii.Kernel.get(this, "challenge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.challenge = java.util.Objects.requireNonNull(builder.challenge, "challenge is required");
            }

            @Override
            public final java.lang.Object getChallenge() {
                return this.challenge;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("challenge", om.valueToTree(this.getChallenge()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ClientSideActionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientSideActionConfigProperty.Jsii$Proxy that = (ClientSideActionConfigProperty.Jsii$Proxy) o;

                return this.challenge.equals(that.challenge);
            }

            @Override
            public final int hashCode() {
                int result = this.challenge.hashCode();
                return result;
            }
        }
    }
    /**
     * This is part of the <code>AWSManagedRulesAntiDDoSRuleSet</code> <code>ClientSideActionConfig</code> configuration in <code>ManagedRuleGroupConfig</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ClientSideActionProperty clientSideActionProperty = ClientSideActionProperty.builder()
     *         .usageOfAction("usageOfAction")
     *         // the properties below are optional
     *         .exemptUriRegularExpressions(List.of(RegexProperty.builder()
     *                 .regexString("regexString")
     *                 .build()))
     *         .sensitivity("sensitivity")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ClientSideActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientSideActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientSideActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether to use the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the rule group evaluation and the related label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> .
         * <p>
         * <ul>
         * <li>If usage is enabled:</li>
         * <li>The managed rule group adds the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any web request whose URL does <em>NOT</em> match the regular expressions provided in the <code>ClientSideAction</code> setting <code>ExemptUriRegularExpressions</code> .</li>
         * <li>The two rules are evaluated against web requests for protected resources that are experiencing a DDoS attack. The two rules only apply their action to matching requests that have the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> .</li>
         * <li>If usage is disabled:</li>
         * <li>The managed rule group doesn't add the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any web requests.</li>
         * <li>The two rules are not evaluated.</li>
         * <li>None of the other <code>ClientSideAction</code> settings have any effect.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * This setting only enables or disables the use of the two anti-DDOS rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the anti-DDoS managed rule group.
         * <p>
         * This setting doesn't alter the action setting in the two rules. To override the actions used by the rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> , enable this setting, and then override the rule actions in the usual way, in your managed rule group configuration.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideaction.html#cfn-wafv2-webacl-clientsideaction-usageofaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideaction.html#cfn-wafv2-webacl-clientsideaction-usageofaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsageOfAction();

        /**
         * The regular expression to match against the web request URI, used to identify requests that can't handle a silent browser challenge.
         * <p>
         * When the <code>ClientSideAction</code> setting <code>UsageOfAction</code> is enabled, the managed rule group uses this setting to determine which requests to label with <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> . If <code>UsageOfAction</code> is disabled, this setting has no effect and the managed rule group doesn't add the label to any requests.
         * <p>
         * The anti-DDoS managed rule group doesn't evaluate the rules <code>ChallengeDDoSRequests</code> or <code>ChallengeAllDuringEvent</code> for web requests whose URIs match this regex. This is true regardless of whether you override the rule action for either of the rules in your web ACL configuration.
         * <p>
         * AWS recommends using a regular expression.
         * <p>
         * This setting is required if <code>UsageOfAction</code> is set to <code>ENABLED</code> . If required, you can provide between 1 and 5 regex objects in the array of settings.
         * <p>
         * AWS recommends starting with the following setting. Review and update it for your application's needs:
         * <p>
         * <code>\/api\/|\.(acc|avi|css|gif|jpe?g|js|mp[34]|ogg|otf|pdf|png|tiff?|ttf|webm|webp|woff2?)$</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideaction.html#cfn-wafv2-webacl-clientsideaction-exempturiregularexpressions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideaction.html#cfn-wafv2-webacl-clientsideaction-exempturiregularexpressions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExemptUriRegularExpressions() {
            return null;
        }

        /**
         * The sensitivity that the rule group rule <code>ChallengeDDoSRequests</code> uses when matching against the DDoS suspicion labeling on a request.
         * <p>
         * The managed rule group adds the labeling during DDoS events, before the <code>ChallengeDDoSRequests</code> rule runs.
         * <p>
         * The higher the sensitivity, the more levels of labeling that the rule matches:
         * <p>
         * <ul>
         * <li>Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an attack, which are the requests with the high suspicion label <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code> .</li>
         * <li>Medium sensitivity causes the rule to match on the medium and high suspicion labels.</li>
         * <li>High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.</li>
         * </ul>
         * <p>
         * Default: <code>HIGH</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideaction.html#cfn-wafv2-webacl-clientsideaction-sensitivity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-clientsideaction.html#cfn-wafv2-webacl-clientsideaction-sensitivity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSensitivity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientSideActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientSideActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientSideActionProperty> {
            java.lang.String usageOfAction;
            java.lang.Object exemptUriRegularExpressions;
            java.lang.String sensitivity;

            /**
             * Sets the value of {@link ClientSideActionProperty#getUsageOfAction}
             * @param usageOfAction Determines whether to use the <code>AWSManagedRulesAntiDDoSRuleSet</code> rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the rule group evaluation and the related label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> . This parameter is required.
             *                      <ul>
             *                      <li>If usage is enabled:</li>
             *                      <li>The managed rule group adds the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any web request whose URL does <em>NOT</em> match the regular expressions provided in the <code>ClientSideAction</code> setting <code>ExemptUriRegularExpressions</code> .</li>
             *                      <li>The two rules are evaluated against web requests for protected resources that are experiencing a DDoS attack. The two rules only apply their action to matching requests that have the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> .</li>
             *                      <li>If usage is disabled:</li>
             *                      <li>The managed rule group doesn't add the label <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> to any web requests.</li>
             *                      <li>The two rules are not evaluated.</li>
             *                      <li>None of the other <code>ClientSideAction</code> settings have any effect.</li>
             *                      </ul>
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      This setting only enables or disables the use of the two anti-DDOS rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> in the anti-DDoS managed rule group.
             *                      <p>
             *                      This setting doesn't alter the action setting in the two rules. To override the actions used by the rules <code>ChallengeAllDuringEvent</code> and <code>ChallengeDDoSRequests</code> , enable this setting, and then override the rule actions in the usual way, in your managed rule group configuration.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usageOfAction(java.lang.String usageOfAction) {
                this.usageOfAction = usageOfAction;
                return this;
            }

            /**
             * Sets the value of {@link ClientSideActionProperty#getExemptUriRegularExpressions}
             * @param exemptUriRegularExpressions The regular expression to match against the web request URI, used to identify requests that can't handle a silent browser challenge.
             *                                    When the <code>ClientSideAction</code> setting <code>UsageOfAction</code> is enabled, the managed rule group uses this setting to determine which requests to label with <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> . If <code>UsageOfAction</code> is disabled, this setting has no effect and the managed rule group doesn't add the label to any requests.
             *                                    <p>
             *                                    The anti-DDoS managed rule group doesn't evaluate the rules <code>ChallengeDDoSRequests</code> or <code>ChallengeAllDuringEvent</code> for web requests whose URIs match this regex. This is true regardless of whether you override the rule action for either of the rules in your web ACL configuration.
             *                                    <p>
             *                                    AWS recommends using a regular expression.
             *                                    <p>
             *                                    This setting is required if <code>UsageOfAction</code> is set to <code>ENABLED</code> . If required, you can provide between 1 and 5 regex objects in the array of settings.
             *                                    <p>
             *                                    AWS recommends starting with the following setting. Review and update it for your application's needs:
             *                                    <p>
             *                                    <code>\/api\/|\.(acc|avi|css|gif|jpe?g|js|mp[34]|ogg|otf|pdf|png|tiff?|ttf|webm|webp|woff2?)$</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exemptUriRegularExpressions(software.amazon.awscdk.IResolvable exemptUriRegularExpressions) {
                this.exemptUriRegularExpressions = exemptUriRegularExpressions;
                return this;
            }

            /**
             * Sets the value of {@link ClientSideActionProperty#getExemptUriRegularExpressions}
             * @param exemptUriRegularExpressions The regular expression to match against the web request URI, used to identify requests that can't handle a silent browser challenge.
             *                                    When the <code>ClientSideAction</code> setting <code>UsageOfAction</code> is enabled, the managed rule group uses this setting to determine which requests to label with <code>awswaf:managed:aws:anti-ddos:challengeable-request</code> . If <code>UsageOfAction</code> is disabled, this setting has no effect and the managed rule group doesn't add the label to any requests.
             *                                    <p>
             *                                    The anti-DDoS managed rule group doesn't evaluate the rules <code>ChallengeDDoSRequests</code> or <code>ChallengeAllDuringEvent</code> for web requests whose URIs match this regex. This is true regardless of whether you override the rule action for either of the rules in your web ACL configuration.
             *                                    <p>
             *                                    AWS recommends using a regular expression.
             *                                    <p>
             *                                    This setting is required if <code>UsageOfAction</code> is set to <code>ENABLED</code> . If required, you can provide between 1 and 5 regex objects in the array of settings.
             *                                    <p>
             *                                    AWS recommends starting with the following setting. Review and update it for your application's needs:
             *                                    <p>
             *                                    <code>\/api\/|\.(acc|avi|css|gif|jpe?g|js|mp[34]|ogg|otf|pdf|png|tiff?|ttf|webm|webp|woff2?)$</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exemptUriRegularExpressions(java.util.List<? extends java.lang.Object> exemptUriRegularExpressions) {
                this.exemptUriRegularExpressions = exemptUriRegularExpressions;
                return this;
            }

            /**
             * Sets the value of {@link ClientSideActionProperty#getSensitivity}
             * @param sensitivity The sensitivity that the rule group rule <code>ChallengeDDoSRequests</code> uses when matching against the DDoS suspicion labeling on a request.
             *                    The managed rule group adds the labeling during DDoS events, before the <code>ChallengeDDoSRequests</code> rule runs.
             *                    <p>
             *                    The higher the sensitivity, the more levels of labeling that the rule matches:
             *                    <p>
             *                    <ul>
             *                    <li>Low sensitivity is less sensitive, causing the rule to match only on the most likely participants in an attack, which are the requests with the high suspicion label <code>awswaf:managed:aws:anti-ddos:high-suspicion-ddos-request</code> .</li>
             *                    <li>Medium sensitivity causes the rule to match on the medium and high suspicion labels.</li>
             *                    <li>High sensitivity causes the rule to match on all of the suspicion labels: low, medium, and high.</li>
             *                    </ul>
             *                    <p>
             *                    Default: <code>HIGH</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sensitivity(java.lang.String sensitivity) {
                this.sensitivity = sensitivity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientSideActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientSideActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientSideActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientSideActionProperty {
            private final java.lang.String usageOfAction;
            private final java.lang.Object exemptUriRegularExpressions;
            private final java.lang.String sensitivity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.usageOfAction = software.amazon.jsii.Kernel.get(this, "usageOfAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.exemptUriRegularExpressions = software.amazon.jsii.Kernel.get(this, "exemptUriRegularExpressions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sensitivity = software.amazon.jsii.Kernel.get(this, "sensitivity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.usageOfAction = java.util.Objects.requireNonNull(builder.usageOfAction, "usageOfAction is required");
                this.exemptUriRegularExpressions = builder.exemptUriRegularExpressions;
                this.sensitivity = builder.sensitivity;
            }

            @Override
            public final java.lang.String getUsageOfAction() {
                return this.usageOfAction;
            }

            @Override
            public final java.lang.Object getExemptUriRegularExpressions() {
                return this.exemptUriRegularExpressions;
            }

            @Override
            public final java.lang.String getSensitivity() {
                return this.sensitivity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("usageOfAction", om.valueToTree(this.getUsageOfAction()));
                if (this.getExemptUriRegularExpressions() != null) {
                    data.set("exemptUriRegularExpressions", om.valueToTree(this.getExemptUriRegularExpressions()));
                }
                if (this.getSensitivity() != null) {
                    data.set("sensitivity", om.valueToTree(this.getSensitivity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ClientSideActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientSideActionProperty.Jsii$Proxy that = (ClientSideActionProperty.Jsii$Proxy) o;

                if (!usageOfAction.equals(that.usageOfAction)) return false;
                if (this.exemptUriRegularExpressions != null ? !this.exemptUriRegularExpressions.equals(that.exemptUriRegularExpressions) : that.exemptUriRegularExpressions != null) return false;
                return this.sensitivity != null ? this.sensitivity.equals(that.sensitivity) : that.sensitivity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.usageOfAction.hashCode();
                result = 31 * result + (this.exemptUriRegularExpressions != null ? this.exemptUriRegularExpressions.hashCode() : 0);
                result = 31 * result + (this.sensitivity != null ? this.sensitivity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The filter to use to identify the subset of cookies to inspect in a web request.
     * <p>
     * You must specify exactly one setting: either <code>All</code> , <code>IncludedCookies</code> , or <code>ExcludedCookies</code> .
     * <p>
     * Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * CookieMatchPatternProperty cookieMatchPatternProperty = CookieMatchPatternProperty.builder()
     *         .all(all)
     *         .excludedCookies(List.of("excludedCookies"))
     *         .includedCookies(List.of("includedCookies"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.CookieMatchPatternProperty")
    @software.amazon.jsii.Jsii.Proxy(CookieMatchPatternProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookieMatchPatternProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Inspect all cookies.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-all">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-all</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAll() {
            return null;
        }

        /**
         * Inspect only the cookies whose keys don't match any of the strings specified here.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-excludedcookies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-excludedcookies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedCookies() {
            return null;
        }

        /**
         * Inspect only the cookies that have a key that matches one of the strings specified here.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-includedcookies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookiematchpattern.html#cfn-wafv2-webacl-cookiematchpattern-includedcookies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedCookies() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CookieMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookieMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookieMatchPatternProperty> {
            java.lang.Object all;
            java.util.List<java.lang.String> excludedCookies;
            java.util.List<java.lang.String> includedCookies;

            /**
             * Sets the value of {@link CookieMatchPatternProperty#getAll}
             * @param all Inspect all cookies.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder all(java.lang.Object all) {
                this.all = all;
                return this;
            }

            /**
             * Sets the value of {@link CookieMatchPatternProperty#getExcludedCookies}
             * @param excludedCookies Inspect only the cookies whose keys don't match any of the strings specified here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedCookies(java.util.List<java.lang.String> excludedCookies) {
                this.excludedCookies = excludedCookies;
                return this;
            }

            /**
             * Sets the value of {@link CookieMatchPatternProperty#getIncludedCookies}
             * @param includedCookies Inspect only the cookies that have a key that matches one of the strings specified here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedCookies(java.util.List<java.lang.String> includedCookies) {
                this.includedCookies = includedCookies;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookieMatchPatternProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookieMatchPatternProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CookieMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookieMatchPatternProperty {
            private final java.lang.Object all;
            private final java.util.List<java.lang.String> excludedCookies;
            private final java.util.List<java.lang.String> includedCookies;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.all = software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludedCookies = software.amazon.jsii.Kernel.get(this, "excludedCookies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includedCookies = software.amazon.jsii.Kernel.get(this, "includedCookies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.all = builder.all;
                this.excludedCookies = builder.excludedCookies;
                this.includedCookies = builder.includedCookies;
            }

            @Override
            public final java.lang.Object getAll() {
                return this.all;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedCookies() {
                return this.excludedCookies;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedCookies() {
                return this.includedCookies;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAll() != null) {
                    data.set("all", om.valueToTree(this.getAll()));
                }
                if (this.getExcludedCookies() != null) {
                    data.set("excludedCookies", om.valueToTree(this.getExcludedCookies()));
                }
                if (this.getIncludedCookies() != null) {
                    data.set("includedCookies", om.valueToTree(this.getIncludedCookies()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.CookieMatchPatternProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookieMatchPatternProperty.Jsii$Proxy that = (CookieMatchPatternProperty.Jsii$Proxy) o;

                if (this.all != null ? !this.all.equals(that.all) : that.all != null) return false;
                if (this.excludedCookies != null ? !this.excludedCookies.equals(that.excludedCookies) : that.excludedCookies != null) return false;
                return this.includedCookies != null ? this.includedCookies.equals(that.includedCookies) : that.includedCookies == null;
            }

            @Override
            public final int hashCode() {
                int result = this.all != null ? this.all.hashCode() : 0;
                result = 31 * result + (this.excludedCookies != null ? this.excludedCookies.hashCode() : 0);
                result = 31 * result + (this.includedCookies != null ? this.includedCookies.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Inspect the cookies in the web request.
     * <p>
     * You can specify the parts of the cookies to inspect and you can narrow the set of cookies to inspect by including or excluding specific keys.
     * <p>
     * This is used to indicate the web request component to inspect, in the <code>FieldToMatch</code> specification.
     * <p>
     * Example JSON: <code>"Cookies": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * CookiesProperty cookiesProperty = CookiesProperty.builder()
     *         .matchPattern(CookieMatchPatternProperty.builder()
     *                 .all(all)
     *                 .excludedCookies(List.of("excludedCookies"))
     *                 .includedCookies(List.of("includedCookies"))
     *                 .build())
     *         .matchScope("matchScope")
     *         .oversizeHandling("oversizeHandling")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.CookiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CookiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The filter to use to identify the subset of cookies to inspect in a web request.
         * <p>
         * You must specify exactly one setting: either <code>All</code> , <code>IncludedCookies</code> , or <code>ExcludedCookies</code> .
         * <p>
         * Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-matchpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-matchpattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatchPattern();

        /**
         * The parts of the cookies to inspect with the rule inspection criteria.
         * <p>
         * If you specify <code>ALL</code> , AWS WAF inspects both keys and values.
         * <p>
         * <code>All</code> does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical <code>AND</code> statement to combine two match rules, one that inspects the keys and another that inspects the values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-matchscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-matchscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMatchScope();

        /**
         * What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect.
         * <p>
         * AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .
         * <p>
         * The options for oversize handling are the following:
         * <p>
         * <ul>
         * <li><code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection criteria.</li>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-oversizehandling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-cookies.html#cfn-wafv2-webacl-cookies-oversizehandling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOversizeHandling();

        /**
         * @return a {@link Builder} of {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookiesProperty> {
            java.lang.Object matchPattern;
            java.lang.String matchScope;
            java.lang.String oversizeHandling;

            /**
             * Sets the value of {@link CookiesProperty#getMatchPattern}
             * @param matchPattern The filter to use to identify the subset of cookies to inspect in a web request. This parameter is required.
             *                     You must specify exactly one setting: either <code>All</code> , <code>IncludedCookies</code> , or <code>ExcludedCookies</code> .
             *                     <p>
             *                     Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.IResolvable matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link CookiesProperty#getMatchPattern}
             * @param matchPattern The filter to use to identify the subset of cookies to inspect in a web request. This parameter is required.
             *                     You must specify exactly one setting: either <code>All</code> , <code>IncludedCookies</code> , or <code>ExcludedCookies</code> .
             *                     <p>
             *                     Example JSON: <code>"MatchPattern": { "IncludedCookies": [ "session-id-time", "session-id" ] }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.services.wafv2.CfnWebACL.CookieMatchPatternProperty matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link CookiesProperty#getMatchScope}
             * @param matchScope The parts of the cookies to inspect with the rule inspection criteria. This parameter is required.
             *                   If you specify <code>ALL</code> , AWS WAF inspects both keys and values.
             *                   <p>
             *                   <code>All</code> does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical <code>AND</code> statement to combine two match rules, one that inspects the keys and another that inspects the values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchScope(java.lang.String matchScope) {
                this.matchScope = matchScope;
                return this;
            }

            /**
             * Sets the value of {@link CookiesProperty#getOversizeHandling}
             * @param oversizeHandling What AWS WAF should do if the cookies of the request are more numerous or larger than AWS WAF can inspect. This parameter is required.
             *                         AWS WAF does not support inspecting the entire contents of request cookies when they exceed 8 KB (8192 bytes) or 200 total cookies. The underlying host service forwards a maximum of 200 cookies and at most 8 KB of cookie contents to AWS WAF .
             *                         <p>
             *                         The options for oversize handling are the following:
             *                         <p>
             *                         <ul>
             *                         <li><code>CONTINUE</code> - Inspect the available cookies normally, according to the rule inspection criteria.</li>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oversizeHandling(java.lang.String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookiesProperty {
            private final java.lang.Object matchPattern;
            private final java.lang.String matchScope;
            private final java.lang.String oversizeHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchPattern = software.amazon.jsii.Kernel.get(this, "matchPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchScope = software.amazon.jsii.Kernel.get(this, "matchScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oversizeHandling = software.amazon.jsii.Kernel.get(this, "oversizeHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchPattern = java.util.Objects.requireNonNull(builder.matchPattern, "matchPattern is required");
                this.matchScope = java.util.Objects.requireNonNull(builder.matchScope, "matchScope is required");
                this.oversizeHandling = java.util.Objects.requireNonNull(builder.oversizeHandling, "oversizeHandling is required");
            }

            @Override
            public final java.lang.Object getMatchPattern() {
                return this.matchPattern;
            }

            @Override
            public final java.lang.String getMatchScope() {
                return this.matchScope;
            }

            @Override
            public final java.lang.String getOversizeHandling() {
                return this.oversizeHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchPattern", om.valueToTree(this.getMatchPattern()));
                data.set("matchScope", om.valueToTree(this.getMatchScope()));
                data.set("oversizeHandling", om.valueToTree(this.getOversizeHandling()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.CookiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookiesProperty.Jsii$Proxy that = (CookiesProperty.Jsii$Proxy) o;

                if (!matchPattern.equals(that.matchPattern)) return false;
                if (!matchScope.equals(that.matchScope)) return false;
                return this.oversizeHandling.equals(that.oversizeHandling);
            }

            @Override
            public final int hashCode() {
                int result = this.matchPattern.hashCode();
                result = 31 * result + (this.matchScope.hashCode());
                result = 31 * result + (this.oversizeHandling.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies that AWS WAF should count the request. Optionally defines additional custom handling for the request.
     * <p>
     * This is used in the context of other settings, for example to specify values for a rule action or a web ACL default action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * CountActionProperty countActionProperty = CountActionProperty.builder()
     *         .customRequestHandling(CustomRequestHandlingProperty.builder()
     *                 .insertHeaders(List.of(CustomHTTPHeaderProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-countaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-countaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.CountActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CountActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CountActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines custom handling for the web request.
         * <p>
         * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-countaction.html#cfn-wafv2-webacl-countaction-customrequesthandling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-countaction.html#cfn-wafv2-webacl-countaction-customrequesthandling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomRequestHandling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CountActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CountActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CountActionProperty> {
            java.lang.Object customRequestHandling;

            /**
             * Sets the value of {@link CountActionProperty#getCustomRequestHandling}
             * @param customRequestHandling Defines custom handling for the web request.
             *                              For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRequestHandling(software.amazon.awscdk.IResolvable customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            /**
             * Sets the value of {@link CountActionProperty#getCustomRequestHandling}
             * @param customRequestHandling Defines custom handling for the web request.
             *                              For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customRequestHandling(software.amazon.awscdk.services.wafv2.CfnWebACL.CustomRequestHandlingProperty customRequestHandling) {
                this.customRequestHandling = customRequestHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CountActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CountActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CountActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CountActionProperty {
            private final java.lang.Object customRequestHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customRequestHandling = software.amazon.jsii.Kernel.get(this, "customRequestHandling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customRequestHandling = builder.customRequestHandling;
            }

            @Override
            public final java.lang.Object getCustomRequestHandling() {
                return this.customRequestHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomRequestHandling() != null) {
                    data.set("customRequestHandling", om.valueToTree(this.getCustomRequestHandling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.CountActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CountActionProperty.Jsii$Proxy that = (CountActionProperty.Jsii$Proxy) o;

                return this.customRequestHandling != null ? this.customRequestHandling.equals(that.customRequestHandling) : that.customRequestHandling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customRequestHandling != null ? this.customRequestHandling.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A custom header for custom request and response handling.
     * <p>
     * This is used in <code>CustomResponse</code> and <code>CustomRequestHandling</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * CustomHTTPHeaderProperty customHTTPHeaderProperty = CustomHTTPHeaderProperty.builder()
     *         .name("name")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.CustomHTTPHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomHTTPHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomHTTPHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the custom header.
         * <p>
         * For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name <code>x-amzn-waf-</code> , to avoid confusion with the headers that are already in the request. For example, for the header name <code>sample</code> , AWS WAF inserts the header <code>x-amzn-waf-sample</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html#cfn-wafv2-webacl-customhttpheader-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html#cfn-wafv2-webacl-customhttpheader-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of the custom header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html#cfn-wafv2-webacl-customhttpheader-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customhttpheader.html#cfn-wafv2-webacl-customhttpheader-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link CustomHTTPHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomHTTPHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomHTTPHeaderProperty> {
            java.lang.String name;
            java.lang.String value;

            /**
             * Sets the value of {@link CustomHTTPHeaderProperty#getName}
             * @param name The name of the custom header. This parameter is required.
             *             For custom request header insertion, when AWS WAF inserts the header into the request, it prefixes this name <code>x-amzn-waf-</code> , to avoid confusion with the headers that are already in the request. For example, for the header name <code>sample</code> , AWS WAF inserts the header <code>x-amzn-waf-sample</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link CustomHTTPHeaderProperty#getValue}
             * @param value The value of the custom header. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomHTTPHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomHTTPHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomHTTPHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomHTTPHeaderProperty {
            private final java.lang.String name;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.CustomHTTPHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomHTTPHeaderProperty.Jsii$Proxy that = (CustomHTTPHeaderProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Custom request handling behavior that inserts custom headers into a web request.
     * <p>
     * You can add custom request handling for AWS WAF to use when the rule action doesn't block the request. For example, <code>CaptchaAction</code> for requests with valid t okens, and <code>AllowAction</code> .
     * <p>
     * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * CustomRequestHandlingProperty customRequestHandlingProperty = CustomRequestHandlingProperty.builder()
     *         .insertHeaders(List.of(CustomHTTPHeaderProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customrequesthandling.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customrequesthandling.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.CustomRequestHandlingProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomRequestHandlingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomRequestHandlingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP headers to insert into the request. Duplicate header names are not allowed.
         * <p>
         * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customrequesthandling.html#cfn-wafv2-webacl-customrequesthandling-insertheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customrequesthandling.html#cfn-wafv2-webacl-customrequesthandling-insertheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInsertHeaders();

        /**
         * @return a {@link Builder} of {@link CustomRequestHandlingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomRequestHandlingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomRequestHandlingProperty> {
            java.lang.Object insertHeaders;

            /**
             * Sets the value of {@link CustomRequestHandlingProperty#getInsertHeaders}
             * @param insertHeaders The HTTP headers to insert into the request. Duplicate header names are not allowed. This parameter is required.
             *                      For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insertHeaders(software.amazon.awscdk.IResolvable insertHeaders) {
                this.insertHeaders = insertHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CustomRequestHandlingProperty#getInsertHeaders}
             * @param insertHeaders The HTTP headers to insert into the request. Duplicate header names are not allowed. This parameter is required.
             *                      For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insertHeaders(java.util.List<? extends java.lang.Object> insertHeaders) {
                this.insertHeaders = insertHeaders;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomRequestHandlingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomRequestHandlingProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomRequestHandlingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomRequestHandlingProperty {
            private final java.lang.Object insertHeaders;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.insertHeaders = software.amazon.jsii.Kernel.get(this, "insertHeaders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.insertHeaders = java.util.Objects.requireNonNull(builder.insertHeaders, "insertHeaders is required");
            }

            @Override
            public final java.lang.Object getInsertHeaders() {
                return this.insertHeaders;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("insertHeaders", om.valueToTree(this.getInsertHeaders()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.CustomRequestHandlingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomRequestHandlingProperty.Jsii$Proxy that = (CustomRequestHandlingProperty.Jsii$Proxy) o;

                return this.insertHeaders.equals(that.insertHeaders);
            }

            @Override
            public final int hashCode() {
                int result = this.insertHeaders.hashCode();
                return result;
            }
        }
    }
    /**
     * The response body to use in a custom response to a web request.
     * <p>
     * This is referenced by key from <code>CustomResponse</code> <code>CustomResponseBodyKey</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * CustomResponseBodyProperty customResponseBodyProperty = CustomResponseBodyProperty.builder()
     *         .content("content")
     *         .contentType("contentType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.CustomResponseBodyProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomResponseBodyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomResponseBodyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The payload of the custom response.
         * <p>
         * You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the <code>ContentType</code> setting.
         * <p>
         * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html#cfn-wafv2-webacl-customresponsebody-content">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html#cfn-wafv2-webacl-customresponsebody-content</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContent();

        /**
         * The type of content in the payload that you are defining in the <code>Content</code> string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html#cfn-wafv2-webacl-customresponsebody-contenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponsebody.html#cfn-wafv2-webacl-customresponsebody-contenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getContentType();

        /**
         * @return a {@link Builder} of {@link CustomResponseBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomResponseBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomResponseBodyProperty> {
            java.lang.String content;
            java.lang.String contentType;

            /**
             * Sets the value of {@link CustomResponseBodyProperty#getContent}
             * @param content The payload of the custom response. This parameter is required.
             *                You can use JSON escape strings in JSON content. To do this, you must specify JSON content in the <code>ContentType</code> setting.
             *                <p>
             *                For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder content(java.lang.String content) {
                this.content = content;
                return this;
            }

            /**
             * Sets the value of {@link CustomResponseBodyProperty#getContentType}
             * @param contentType The type of content in the payload that you are defining in the <code>Content</code> string. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentType(java.lang.String contentType) {
                this.contentType = contentType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomResponseBodyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomResponseBodyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomResponseBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomResponseBodyProperty {
            private final java.lang.String content;
            private final java.lang.String contentType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.content = software.amazon.jsii.Kernel.get(this, "content", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.content = java.util.Objects.requireNonNull(builder.content, "content is required");
                this.contentType = java.util.Objects.requireNonNull(builder.contentType, "contentType is required");
            }

            @Override
            public final java.lang.String getContent() {
                return this.content;
            }

            @Override
            public final java.lang.String getContentType() {
                return this.contentType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("content", om.valueToTree(this.getContent()));
                data.set("contentType", om.valueToTree(this.getContentType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.CustomResponseBodyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomResponseBodyProperty.Jsii$Proxy that = (CustomResponseBodyProperty.Jsii$Proxy) o;

                if (!content.equals(that.content)) return false;
                return this.contentType.equals(that.contentType);
            }

            @Override
            public final int hashCode() {
                int result = this.content.hashCode();
                result = 31 * result + (this.contentType.hashCode());
                return result;
            }
        }
    }
    /**
     * A custom response to send to the client.
     * <p>
     * You can define a custom response for rule actions and default web ACL actions that are set to the block action.
     * <p>
     * For information about customizing web requests and responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html">Customizing web requests and responses in AWS WAF</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF developer guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * CustomResponseProperty customResponseProperty = CustomResponseProperty.builder()
     *         .responseCode(123)
     *         // the properties below are optional
     *         .customResponseBodyKey("customResponseBodyKey")
     *         .responseHeaders(List.of(CustomHTTPHeaderProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.CustomResponseProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomResponseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTTP status code to return to the client.
         * <p>
         * For a list of status codes that you can use in your custom responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html">Supported status codes for custom response</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-responsecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-responsecode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getResponseCode();

        /**
         * References the response body that you want AWS WAF to return to the web request client.
         * <p>
         * You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the <code>CustomResponseBodies</code> setting for the <code>WebACL</code> or <code>RuleGroup</code> where you want to use it. Then, in the rule action or web ACL default action <code>BlockAction</code> setting, you reference the response body using this key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-customresponsebodykey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-customresponsebodykey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomResponseBodyKey() {
            return null;
        }

        /**
         * The HTTP headers to use in the response.
         * <p>
         * You can specify any header name except for <code>content-type</code> . Duplicate header names are not allowed.
         * <p>
         * For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-responseheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-customresponse.html#cfn-wafv2-webacl-customresponse-responseheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResponseHeaders() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomResponseProperty> {
            java.lang.Number responseCode;
            java.lang.String customResponseBodyKey;
            java.lang.Object responseHeaders;

            /**
             * Sets the value of {@link CustomResponseProperty#getResponseCode}
             * @param responseCode The HTTP status code to return to the client. This parameter is required.
             *                     For a list of status codes that you can use in your custom responses, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html">Supported status codes for custom response</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseCode(java.lang.Number responseCode) {
                this.responseCode = responseCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomResponseProperty#getCustomResponseBodyKey}
             * @param customResponseBodyKey References the response body that you want AWS WAF to return to the web request client.
             *                              You can define a custom response for a rule action or a default web ACL action that is set to block. To do this, you first define the response body key and value in the <code>CustomResponseBodies</code> setting for the <code>WebACL</code> or <code>RuleGroup</code> where you want to use it. Then, in the rule action or web ACL default action <code>BlockAction</code> setting, you reference the response body using this key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customResponseBodyKey(java.lang.String customResponseBodyKey) {
                this.customResponseBodyKey = customResponseBodyKey;
                return this;
            }

            /**
             * Sets the value of {@link CustomResponseProperty#getResponseHeaders}
             * @param responseHeaders The HTTP headers to use in the response.
             *                        You can specify any header name except for <code>content-type</code> . Duplicate header names are not allowed.
             *                        <p>
             *                        For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseHeaders(software.amazon.awscdk.IResolvable responseHeaders) {
                this.responseHeaders = responseHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CustomResponseProperty#getResponseHeaders}
             * @param responseHeaders The HTTP headers to use in the response.
             *                        You can specify any header name except for <code>content-type</code> . Duplicate header names are not allowed.
             *                        <p>
             *                        For information about the limits on count and size for custom request and response settings, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/limits.html">AWS WAF quotas</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseHeaders(java.util.List<? extends java.lang.Object> responseHeaders) {
                this.responseHeaders = responseHeaders;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomResponseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomResponseProperty {
            private final java.lang.Number responseCode;
            private final java.lang.String customResponseBodyKey;
            private final java.lang.Object responseHeaders;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.responseCode = software.amazon.jsii.Kernel.get(this, "responseCode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customResponseBodyKey = software.amazon.jsii.Kernel.get(this, "customResponseBodyKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.responseHeaders = software.amazon.jsii.Kernel.get(this, "responseHeaders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.responseCode = java.util.Objects.requireNonNull(builder.responseCode, "responseCode is required");
                this.customResponseBodyKey = builder.customResponseBodyKey;
                this.responseHeaders = builder.responseHeaders;
            }

            @Override
            public final java.lang.Number getResponseCode() {
                return this.responseCode;
            }

            @Override
            public final java.lang.String getCustomResponseBodyKey() {
                return this.customResponseBodyKey;
            }

            @Override
            public final java.lang.Object getResponseHeaders() {
                return this.responseHeaders;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("responseCode", om.valueToTree(this.getResponseCode()));
                if (this.getCustomResponseBodyKey() != null) {
                    data.set("customResponseBodyKey", om.valueToTree(this.getCustomResponseBodyKey()));
                }
                if (this.getResponseHeaders() != null) {
                    data.set("responseHeaders", om.valueToTree(this.getResponseHeaders()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.CustomResponseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomResponseProperty.Jsii$Proxy that = (CustomResponseProperty.Jsii$Proxy) o;

                if (!responseCode.equals(that.responseCode)) return false;
                if (this.customResponseBodyKey != null ? !this.customResponseBodyKey.equals(that.customResponseBodyKey) : that.customResponseBodyKey != null) return false;
                return this.responseHeaders != null ? this.responseHeaders.equals(that.responseHeaders) : that.responseHeaders == null;
            }

            @Override
            public final int hashCode() {
                int result = this.responseCode.hashCode();
                result = 31 * result + (this.customResponseBodyKey != null ? this.customResponseBodyKey.hashCode() : 0);
                result = 31 * result + (this.responseHeaders != null ? this.responseHeaders.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * DataProtectProperty dataProtectProperty = DataProtectProperty.builder()
     *         .action("action")
     *         .field(FieldToProtectProperty.builder()
     *                 .fieldType("fieldType")
     *                 // the properties below are optional
     *                 .fieldKeys(List.of("fieldKeys"))
     *                 .build())
     *         // the properties below are optional
     *         .excludeRateBasedDetails(false)
     *         .excludeRuleMatchDetails(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.DataProtectProperty")
    @software.amazon.jsii.Jsii.Proxy(DataProtectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataProtectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * Field in log to protect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getField();

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-excluderatebaseddetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-excluderatebaseddetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeRateBasedDetails() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-excluderulematchdetails">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotect.html#cfn-wafv2-webacl-dataprotect-excluderulematchdetails</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludeRuleMatchDetails() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataProtectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataProtectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataProtectProperty> {
            java.lang.String action;
            java.lang.Object field;
            java.lang.Object excludeRateBasedDetails;
            java.lang.Object excludeRuleMatchDetails;

            /**
             * Sets the value of {@link DataProtectProperty#getAction}
             * @param action the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link DataProtectProperty#getField}
             * @param field Field in log to protect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(software.amazon.awscdk.IResolvable field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link DataProtectProperty#getField}
             * @param field Field in log to protect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldToProtectProperty field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link DataProtectProperty#getExcludeRateBasedDetails}
             * @param excludeRateBasedDetails the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeRateBasedDetails(java.lang.Boolean excludeRateBasedDetails) {
                this.excludeRateBasedDetails = excludeRateBasedDetails;
                return this;
            }

            /**
             * Sets the value of {@link DataProtectProperty#getExcludeRateBasedDetails}
             * @param excludeRateBasedDetails the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeRateBasedDetails(software.amazon.awscdk.IResolvable excludeRateBasedDetails) {
                this.excludeRateBasedDetails = excludeRateBasedDetails;
                return this;
            }

            /**
             * Sets the value of {@link DataProtectProperty#getExcludeRuleMatchDetails}
             * @param excludeRuleMatchDetails the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeRuleMatchDetails(java.lang.Boolean excludeRuleMatchDetails) {
                this.excludeRuleMatchDetails = excludeRuleMatchDetails;
                return this;
            }

            /**
             * Sets the value of {@link DataProtectProperty#getExcludeRuleMatchDetails}
             * @param excludeRuleMatchDetails the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeRuleMatchDetails(software.amazon.awscdk.IResolvable excludeRuleMatchDetails) {
                this.excludeRuleMatchDetails = excludeRuleMatchDetails;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataProtectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataProtectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataProtectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataProtectProperty {
            private final java.lang.String action;
            private final java.lang.Object field;
            private final java.lang.Object excludeRateBasedDetails;
            private final java.lang.Object excludeRuleMatchDetails;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeRateBasedDetails = software.amazon.jsii.Kernel.get(this, "excludeRateBasedDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeRuleMatchDetails = software.amazon.jsii.Kernel.get(this, "excludeRuleMatchDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.field = java.util.Objects.requireNonNull(builder.field, "field is required");
                this.excludeRateBasedDetails = builder.excludeRateBasedDetails;
                this.excludeRuleMatchDetails = builder.excludeRuleMatchDetails;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getField() {
                return this.field;
            }

            @Override
            public final java.lang.Object getExcludeRateBasedDetails() {
                return this.excludeRateBasedDetails;
            }

            @Override
            public final java.lang.Object getExcludeRuleMatchDetails() {
                return this.excludeRuleMatchDetails;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("field", om.valueToTree(this.getField()));
                if (this.getExcludeRateBasedDetails() != null) {
                    data.set("excludeRateBasedDetails", om.valueToTree(this.getExcludeRateBasedDetails()));
                }
                if (this.getExcludeRuleMatchDetails() != null) {
                    data.set("excludeRuleMatchDetails", om.valueToTree(this.getExcludeRuleMatchDetails()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.DataProtectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataProtectProperty.Jsii$Proxy that = (DataProtectProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!field.equals(that.field)) return false;
                if (this.excludeRateBasedDetails != null ? !this.excludeRateBasedDetails.equals(that.excludeRateBasedDetails) : that.excludeRateBasedDetails != null) return false;
                return this.excludeRuleMatchDetails != null ? this.excludeRuleMatchDetails.equals(that.excludeRuleMatchDetails) : that.excludeRuleMatchDetails == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.field.hashCode());
                result = 31 * result + (this.excludeRateBasedDetails != null ? this.excludeRateBasedDetails.hashCode() : 0);
                result = 31 * result + (this.excludeRuleMatchDetails != null ? this.excludeRuleMatchDetails.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies data protection to apply to the web request data for the web ACL.
     * <p>
     * This is a web ACL level data protection option.
     * <p>
     * The data protection that you configure for the web ACL alters the data that's available for any other data collection activity, including your AWS WAF logging destinations, web ACL request sampling, and Amazon Security Lake data collection and management. Your other option for data protection is in the logging configuration, which only affects logging.
     * <p>
     * This is part of the data protection configuration for a web ACL.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * DataProtectionConfigProperty dataProtectionConfigProperty = DataProtectionConfigProperty.builder()
     *         .dataProtections(List.of(DataProtectProperty.builder()
     *                 .action("action")
     *                 .field(FieldToProtectProperty.builder()
     *                         .fieldType("fieldType")
     *                         // the properties below are optional
     *                         .fieldKeys(List.of("fieldKeys"))
     *                         .build())
     *                 // the properties below are optional
     *                 .excludeRateBasedDetails(false)
     *                 .excludeRuleMatchDetails(false)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotectionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotectionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.DataProtectionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DataProtectionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataProtectionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of data protection configurations for specific web request field types.
         * <p>
         * This is defined for each web ACL. AWS WAF applies the specified protection to all web requests that the web ACL inspects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotectionconfig.html#cfn-wafv2-webacl-dataprotectionconfig-dataprotections">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-dataprotectionconfig.html#cfn-wafv2-webacl-dataprotectionconfig-dataprotections</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDataProtections();

        /**
         * @return a {@link Builder} of {@link DataProtectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataProtectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataProtectionConfigProperty> {
            java.lang.Object dataProtections;

            /**
             * Sets the value of {@link DataProtectionConfigProperty#getDataProtections}
             * @param dataProtections An array of data protection configurations for specific web request field types. This parameter is required.
             *                        This is defined for each web ACL. AWS WAF applies the specified protection to all web requests that the web ACL inspects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataProtections(software.amazon.awscdk.IResolvable dataProtections) {
                this.dataProtections = dataProtections;
                return this;
            }

            /**
             * Sets the value of {@link DataProtectionConfigProperty#getDataProtections}
             * @param dataProtections An array of data protection configurations for specific web request field types. This parameter is required.
             *                        This is defined for each web ACL. AWS WAF applies the specified protection to all web requests that the web ACL inspects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataProtections(java.util.List<? extends java.lang.Object> dataProtections) {
                this.dataProtections = dataProtections;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataProtectionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataProtectionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataProtectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataProtectionConfigProperty {
            private final java.lang.Object dataProtections;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataProtections = software.amazon.jsii.Kernel.get(this, "dataProtections", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataProtections = java.util.Objects.requireNonNull(builder.dataProtections, "dataProtections is required");
            }

            @Override
            public final java.lang.Object getDataProtections() {
                return this.dataProtections;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataProtections", om.valueToTree(this.getDataProtections()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.DataProtectionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataProtectionConfigProperty.Jsii$Proxy that = (DataProtectionConfigProperty.Jsii$Proxy) o;

                return this.dataProtections.equals(that.dataProtections);
            }

            @Override
            public final int hashCode() {
                int result = this.dataProtections.hashCode();
                return result;
            }
        }
    }
    /**
     * In a <code>WebACL</code> , this is the action that you want AWS WAF to perform when a web request doesn't match any of the rules in the <code>WebACL</code> .
     * <p>
     * The default action must be a terminating action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * DefaultActionProperty defaultActionProperty = DefaultActionProperty.builder()
     *         .allow(AllowActionProperty.builder()
     *                 .customRequestHandling(CustomRequestHandlingProperty.builder()
     *                         .insertHeaders(List.of(CustomHTTPHeaderProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .block(BlockActionProperty.builder()
     *                 .customResponse(CustomResponseProperty.builder()
     *                         .responseCode(123)
     *                         // the properties below are optional
     *                         .customResponseBodyKey("customResponseBodyKey")
     *                         .responseHeaders(List.of(CustomHTTPHeaderProperty.builder()
     *                                 .name("name")
     *                                 .value("value")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.DefaultActionProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies that AWS WAF should allow requests by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-allow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-allow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllow() {
            return null;
        }

        /**
         * Specifies that AWS WAF should block requests by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-block">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-defaultaction.html#cfn-wafv2-webacl-defaultaction-block</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlock() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultActionProperty> {
            java.lang.Object allow;
            java.lang.Object block;

            /**
             * Sets the value of {@link DefaultActionProperty#getAllow}
             * @param allow Specifies that AWS WAF should allow requests by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allow(software.amazon.awscdk.IResolvable allow) {
                this.allow = allow;
                return this;
            }

            /**
             * Sets the value of {@link DefaultActionProperty#getAllow}
             * @param allow Specifies that AWS WAF should allow requests by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allow(software.amazon.awscdk.services.wafv2.CfnWebACL.AllowActionProperty allow) {
                this.allow = allow;
                return this;
            }

            /**
             * Sets the value of {@link DefaultActionProperty#getBlock}
             * @param block Specifies that AWS WAF should block requests by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder block(software.amazon.awscdk.IResolvable block) {
                this.block = block;
                return this;
            }

            /**
             * Sets the value of {@link DefaultActionProperty#getBlock}
             * @param block Specifies that AWS WAF should block requests by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder block(software.amazon.awscdk.services.wafv2.CfnWebACL.BlockActionProperty block) {
                this.block = block;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DefaultActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultActionProperty {
            private final java.lang.Object allow;
            private final java.lang.Object block;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allow = software.amazon.jsii.Kernel.get(this, "allow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.block = software.amazon.jsii.Kernel.get(this, "block", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allow = builder.allow;
                this.block = builder.block;
            }

            @Override
            public final java.lang.Object getAllow() {
                return this.allow;
            }

            @Override
            public final java.lang.Object getBlock() {
                return this.block;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllow() != null) {
                    data.set("allow", om.valueToTree(this.getAllow()));
                }
                if (this.getBlock() != null) {
                    data.set("block", om.valueToTree(this.getBlock()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.DefaultActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultActionProperty.Jsii$Proxy that = (DefaultActionProperty.Jsii$Proxy) o;

                if (this.allow != null ? !this.allow.equals(that.allow) : that.allow != null) return false;
                return this.block != null ? this.block.equals(that.block) : that.block == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allow != null ? this.allow.hashCode() : 0;
                result = 31 * result + (this.block != null ? this.block.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a single rule in a rule group whose action you want to override to <code>Count</code> .
     * <p>
     * <blockquote>
     * <p>
     * Instead of this option, use <code>RuleActionOverrides</code> . It accepts any valid action setting, including <code>Count</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ExcludedRuleProperty excludedRuleProperty = ExcludedRuleProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ExcludedRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(ExcludedRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ExcludedRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the rule whose action you want to override to <code>Count</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html#cfn-wafv2-webacl-excludedrule-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-excludedrule.html#cfn-wafv2-webacl-excludedrule-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link ExcludedRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ExcludedRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ExcludedRuleProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link ExcludedRuleProperty#getName}
             * @param name The name of the rule whose action you want to override to <code>Count</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ExcludedRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ExcludedRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ExcludedRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExcludedRuleProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ExcludedRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ExcludedRuleProperty.Jsii$Proxy that = (ExcludedRuleProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * The identifier of a field in the web request payload that contains customer data.
     * <p>
     * This data type is used to specify fields in the <code>RequestInspection</code> and <code>RequestInspectionACFP</code> configurations, which are used in the managed rule group configurations <code>AWSManagedRulesATPRuleSet</code> and <code>AWSManagedRulesACFPRuleSet</code> , respectively.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * FieldIdentifierProperty fieldIdentifierProperty = FieldIdentifierProperty.builder()
     *         .identifier("identifier")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldidentifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldidentifier.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.FieldIdentifierProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldIdentifierProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldIdentifierProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field.
         * <p>
         * When the <code>PayloadType</code> in the request inspection is <code>JSON</code> , this identifier must be in JSON pointer syntax. For example <code>/form/username</code> . For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .
         * <p>
         * When the <code>PayloadType</code> is <code>FORM_ENCODED</code> , use the HTML form names. For example, <code>username</code> .
         * <p>
         * For more information, see the descriptions for each field type in the request inspection properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldidentifier.html#cfn-wafv2-webacl-fieldidentifier-identifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldidentifier.html#cfn-wafv2-webacl-fieldidentifier-identifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIdentifier();

        /**
         * @return a {@link Builder} of {@link FieldIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldIdentifierProperty> {
            java.lang.String identifier;

            /**
             * Sets the value of {@link FieldIdentifierProperty#getIdentifier}
             * @param identifier The name of the field. This parameter is required.
             *                   When the <code>PayloadType</code> in the request inspection is <code>JSON</code> , this identifier must be in JSON pointer syntax. For example <code>/form/username</code> . For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .
             *                   <p>
             *                   When the <code>PayloadType</code> is <code>FORM_ENCODED</code> , use the HTML form names. For example, <code>username</code> .
             *                   <p>
             *                   For more information, see the descriptions for each field type in the request inspection properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identifier(java.lang.String identifier) {
                this.identifier = identifier;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldIdentifierProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldIdentifierProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldIdentifierProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldIdentifierProperty {
            private final java.lang.String identifier;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.identifier = java.util.Objects.requireNonNull(builder.identifier, "identifier is required");
            }

            @Override
            public final java.lang.String getIdentifier() {
                return this.identifier;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("identifier", om.valueToTree(this.getIdentifier()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.FieldIdentifierProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldIdentifierProperty.Jsii$Proxy that = (FieldIdentifierProperty.Jsii$Proxy) o;

                return this.identifier.equals(that.identifier);
            }

            @Override
            public final int hashCode() {
                int result = this.identifier.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies a web request component to be used in a rule match statement or in a logging configuration.
     * <p>
     * <ul>
     * <li>In a rule statement, this is the part of the web request that you want AWS WAF to inspect. Include the single <code>FieldToMatch</code> type that you want to inspect, with additional specifications as needed, according to the type. You specify a single request component in <code>FieldToMatch</code> for each rule statement that requires it. To inspect more than one component of the web request, create a separate rule statement for each component.</li>
     * </ul>
     * <p>
     * Example JSON for a <code>QueryString</code> field to match:
     * <p>
     * <code>"FieldToMatch": { "QueryString": {} }</code>
     * <p>
     * Example JSON for a <code>Method</code> field to match specification:
     * <p>
     * <code>"FieldToMatch": { "Method": { "Name": "DELETE" } }</code>
     * <p>
     * <ul>
     * <li>In a logging configuration, this is used in the <code>RedactedFields</code> property to specify a field to redact from the logging records. For this use case, note the following:</li>
     * <li>Even though all <code>FieldToMatch</code> settings are available, the only valid settings for field redaction are <code>UriPath</code> , <code>QueryString</code> , <code>SingleHeader</code> , and <code>Method</code> .</li>
     * <li>In this documentation, the descriptions of the individual fields talk about specifying the web request component to inspect, but for field redaction, you are specifying the component type to redact from the logs.</li>
     * <li>If you have request sampling enabled, the redacted fields configuration for logging has no impact on sampling. You can only exclude fields from request sampling by disabling sampling in the web ACL visibility configuration or by configuring data protection for the web ACL.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * FieldToMatchProperty fieldToMatchProperty = FieldToMatchProperty.builder()
     *         .allQueryArguments(allQueryArguments)
     *         .body(BodyProperty.builder()
     *                 .oversizeHandling("oversizeHandling")
     *                 .build())
     *         .cookies(CookiesProperty.builder()
     *                 .matchPattern(CookieMatchPatternProperty.builder()
     *                         .all(all)
     *                         .excludedCookies(List.of("excludedCookies"))
     *                         .includedCookies(List.of("includedCookies"))
     *                         .build())
     *                 .matchScope("matchScope")
     *                 .oversizeHandling("oversizeHandling")
     *                 .build())
     *         .headers(HeadersProperty.builder()
     *                 .matchPattern(HeaderMatchPatternProperty.builder()
     *                         .all(all)
     *                         .excludedHeaders(List.of("excludedHeaders"))
     *                         .includedHeaders(List.of("includedHeaders"))
     *                         .build())
     *                 .matchScope("matchScope")
     *                 .oversizeHandling("oversizeHandling")
     *                 .build())
     *         .ja3Fingerprint(JA3FingerprintProperty.builder()
     *                 .fallbackBehavior("fallbackBehavior")
     *                 .build())
     *         .ja4Fingerprint(JA4FingerprintProperty.builder()
     *                 .fallbackBehavior("fallbackBehavior")
     *                 .build())
     *         .jsonBody(JsonBodyProperty.builder()
     *                 .matchPattern(JsonMatchPatternProperty.builder()
     *                         .all(all)
     *                         .includedPaths(List.of("includedPaths"))
     *                         .build())
     *                 .matchScope("matchScope")
     *                 // the properties below are optional
     *                 .invalidFallbackBehavior("invalidFallbackBehavior")
     *                 .oversizeHandling("oversizeHandling")
     *                 .build())
     *         .method(method)
     *         .queryString(queryString)
     *         .singleHeader(singleHeader)
     *         .singleQueryArgument(singleQueryArgument)
     *         .uriFragment(UriFragmentProperty.builder()
     *                 .fallbackBehavior("fallbackBehavior")
     *                 .build())
     *         .uriPath(uriPath)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.FieldToMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldToMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldToMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Inspect all query arguments.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-allqueryarguments">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-allqueryarguments</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllQueryArguments() {
            return null;
        }

        /**
         * Inspect the request body as plain text.
         * <p>
         * The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
         * <p>
         * AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
         * <p>
         * <ul>
         * <li>For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).</li>
         * <li>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code> , for additional processing fees.</li>
         * <li>For AWS Amplify , use the CloudFront limit.</li>
         * </ul>
         * <p>
         * For information about how to handle oversized request bodies, see the <code>Body</code> object configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-body">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-body</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBody() {
            return null;
        }

        /**
         * Inspect the request cookies.
         * <p>
         * You must configure scope and pattern matching filters in the <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.
         * <p>
         * Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the <code>Cookies</code> object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-cookies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-cookies</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCookies() {
            return null;
        }

        /**
         * Inspect the request headers.
         * <p>
         * You must configure scope and pattern matching filters in the <code>Headers</code> object, to define the set of headers to and the parts of the headers that AWS WAF inspects.
         * <p>
         * Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the <code>Headers</code> object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-headers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-headers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaders() {
            return null;
        }

        /**
         * Available for use with Amazon CloudFront distributions and Application Load Balancers.
         * <p>
         * Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
         * <p>
         * <blockquote>
         * <p>
         * You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code> .
         * <p>
         * </blockquote>
         * <p>
         * You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-ja3fingerprint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-ja3fingerprint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJa3Fingerprint() {
            return null;
        }

        /**
         * Available for use with Amazon CloudFront distributions and Application Load Balancers.
         * <p>
         * Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
         * <p>
         * <blockquote>
         * <p>
         * You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code> .
         * <p>
         * </blockquote>
         * <p>
         * You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-ja4fingerprint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-ja4fingerprint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJa4Fingerprint() {
            return null;
        }

        /**
         * Inspect the request body as JSON.
         * <p>
         * The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
         * <p>
         * AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
         * <p>
         * <ul>
         * <li>For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).</li>
         * <li>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code> , for additional processing fees.</li>
         * <li>For AWS Amplify , use the CloudFront limit.</li>
         * </ul>
         * <p>
         * For information about how to handle oversized request bodies, see the <code>JsonBody</code> object configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-jsonbody">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-jsonbody</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJsonBody() {
            return null;
        }

        /**
         * Inspect the HTTP method.
         * <p>
         * The method indicates the type of operation that the request is asking the origin to perform.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-method">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-method</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMethod() {
            return null;
        }

        /**
         * Inspect the query string.
         * <p>
         * This is the part of a URL that appears after a <code>?</code> character, if any.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-querystring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-querystring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryString() {
            return null;
        }

        /**
         * Inspect a single header.
         * <p>
         * Provide the name of the header to inspect, for example, <code>User-Agent</code> or <code>Referer</code> . This setting isn't case sensitive.
         * <p>
         * Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
         * <p>
         * Alternately, you can filter and inspect all headers with the <code>Headers</code> <code>FieldToMatch</code> setting.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singleheader">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singleheader</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleHeader() {
            return null;
        }

        /**
         * Inspect a single query argument.
         * <p>
         * Provide the name of the query argument to inspect, such as <em>UserName</em> or <em>SalesRegion</em> . The name can be up to 30 characters long and isn't case sensitive.
         * <p>
         * Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singlequeryargument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-singlequeryargument</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingleQueryArgument() {
            return null;
        }

        /**
         * Inspect fragments of the request URI.
         * <p>
         * You must configure scope and pattern matching filters in the <code>UriFragment</code> object, to define the fragment of a URI that AWS WAF inspects.
         * <p>
         * Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the <code>UriFragment</code> object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-urifragment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-urifragment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUriFragment() {
            return null;
        }

        /**
         * Inspect the request URI path.
         * <p>
         * This is the part of the web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-uripath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtomatch.html#cfn-wafv2-webacl-fieldtomatch-uripath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUriPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldToMatchProperty> {
            java.lang.Object allQueryArguments;
            java.lang.Object body;
            java.lang.Object cookies;
            java.lang.Object headers;
            java.lang.Object ja3Fingerprint;
            java.lang.Object ja4Fingerprint;
            java.lang.Object jsonBody;
            java.lang.Object method;
            java.lang.Object queryString;
            java.lang.Object singleHeader;
            java.lang.Object singleQueryArgument;
            java.lang.Object uriFragment;
            java.lang.Object uriPath;

            /**
             * Sets the value of {@link FieldToMatchProperty#getAllQueryArguments}
             * @param allQueryArguments Inspect all query arguments.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allQueryArguments(java.lang.Object allQueryArguments) {
                this.allQueryArguments = allQueryArguments;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getBody}
             * @param body Inspect the request body as plain text.
             *             The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
             *             <p>
             *             AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
             *             <p>
             *             <ul>
             *             <li>For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).</li>
             *             <li>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code> , for additional processing fees.</li>
             *             <li>For AWS Amplify , use the CloudFront limit.</li>
             *             </ul>
             *             <p>
             *             For information about how to handle oversized request bodies, see the <code>Body</code> object configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(software.amazon.awscdk.IResolvable body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getBody}
             * @param body Inspect the request body as plain text.
             *             The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
             *             <p>
             *             AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
             *             <p>
             *             <ul>
             *             <li>For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).</li>
             *             <li>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code> , for additional processing fees.</li>
             *             <li>For AWS Amplify , use the CloudFront limit.</li>
             *             </ul>
             *             <p>
             *             For information about how to handle oversized request bodies, see the <code>Body</code> object configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder body(software.amazon.awscdk.services.wafv2.CfnWebACL.BodyProperty body) {
                this.body = body;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getCookies}
             * @param cookies Inspect the request cookies.
             *                You must configure scope and pattern matching filters in the <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.
             *                <p>
             *                Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the <code>Cookies</code> object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(software.amazon.awscdk.IResolvable cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getCookies}
             * @param cookies Inspect the request cookies.
             *                You must configure scope and pattern matching filters in the <code>Cookies</code> object, to define the set of cookies and the parts of the cookies that AWS WAF inspects.
             *                <p>
             *                Only the first 8 KB (8192 bytes) of a request's cookies and only the first 200 cookies are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize cookie content in the <code>Cookies</code> object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(software.amazon.awscdk.services.wafv2.CfnWebACL.CookiesProperty cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getHeaders}
             * @param headers Inspect the request headers.
             *                You must configure scope and pattern matching filters in the <code>Headers</code> object, to define the set of headers to and the parts of the headers that AWS WAF inspects.
             *                <p>
             *                Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the <code>Headers</code> object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.IResolvable headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getHeaders}
             * @param headers Inspect the request headers.
             *                You must configure scope and pattern matching filters in the <code>Headers</code> object, to define the set of headers to and the parts of the headers that AWS WAF inspects.
             *                <p>
             *                Only the first 8 KB (8192 bytes) of a request's headers and only the first 200 headers are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize header content in the <code>Headers</code> object. AWS WAF applies the pattern matching filters to the headers that it receives from the underlying host service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.services.wafv2.CfnWebACL.HeadersProperty headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getJa3Fingerprint}
             * @param ja3Fingerprint Available for use with Amazon CloudFront distributions and Application Load Balancers.
             *                       Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code> .
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <em>AWS WAF Developer Guide</em> .
             *                       <p>
             *                       Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ja3Fingerprint(software.amazon.awscdk.IResolvable ja3Fingerprint) {
                this.ja3Fingerprint = ja3Fingerprint;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getJa3Fingerprint}
             * @param ja3Fingerprint Available for use with Amazon CloudFront distributions and Application Load Balancers.
             *                       Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code> .
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <em>AWS WAF Developer Guide</em> .
             *                       <p>
             *                       Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ja3Fingerprint(software.amazon.awscdk.services.wafv2.CfnWebACL.JA3FingerprintProperty ja3Fingerprint) {
                this.ja3Fingerprint = ja3Fingerprint;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getJa4Fingerprint}
             * @param ja4Fingerprint Available for use with Amazon CloudFront distributions and Application Load Balancers.
             *                       Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code> .
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <em>AWS WAF Developer Guide</em> .
             *                       <p>
             *                       Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ja4Fingerprint(software.amazon.awscdk.IResolvable ja4Fingerprint) {
                this.ja4Fingerprint = ja4Fingerprint;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getJa4Fingerprint}
             * @param ja4Fingerprint Available for use with Amazon CloudFront distributions and Application Load Balancers.
             *                       Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code> .
             *                       <p>
             *                       </blockquote>
             *                       <p>
             *                       You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <em>AWS WAF Developer Guide</em> .
             *                       <p>
             *                       Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ja4Fingerprint(software.amazon.awscdk.services.wafv2.CfnWebACL.JA4FingerprintProperty ja4Fingerprint) {
                this.ja4Fingerprint = ja4Fingerprint;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getJsonBody}
             * @param jsonBody Inspect the request body as JSON.
             *                 The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
             *                 <p>
             *                 AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
             *                 <p>
             *                 <ul>
             *                 <li>For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).</li>
             *                 <li>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code> , for additional processing fees.</li>
             *                 <li>For AWS Amplify , use the CloudFront limit.</li>
             *                 </ul>
             *                 <p>
             *                 For information about how to handle oversized request bodies, see the <code>JsonBody</code> object configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonBody(software.amazon.awscdk.IResolvable jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getJsonBody}
             * @param jsonBody Inspect the request body as JSON.
             *                 The request body immediately follows the request headers. This is the part of a request that contains any additional data that you want to send to your web server as the HTTP request body, such as data from a form.
             *                 <p>
             *                 AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
             *                 <p>
             *                 <ul>
             *                 <li>For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).</li>
             *                 <li>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code> , for additional processing fees.</li>
             *                 <li>For AWS Amplify , use the CloudFront limit.</li>
             *                 </ul>
             *                 <p>
             *                 For information about how to handle oversized request bodies, see the <code>JsonBody</code> object configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonBody(software.amazon.awscdk.services.wafv2.CfnWebACL.JsonBodyProperty jsonBody) {
                this.jsonBody = jsonBody;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getMethod}
             * @param method Inspect the HTTP method.
             *               The method indicates the type of operation that the request is asking the origin to perform.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.Object method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getQueryString}
             * @param queryString Inspect the query string.
             *                    This is the part of a URL that appears after a <code>?</code> character, if any.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(java.lang.Object queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getSingleHeader}
             * @param singleHeader Inspect a single header.
             *                     Provide the name of the header to inspect, for example, <code>User-Agent</code> or <code>Referer</code> . This setting isn't case sensitive.
             *                     <p>
             *                     Example JSON: <code>"SingleHeader": { "Name": "haystack" }</code>
             *                     <p>
             *                     Alternately, you can filter and inspect all headers with the <code>Headers</code> <code>FieldToMatch</code> setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleHeader(java.lang.Object singleHeader) {
                this.singleHeader = singleHeader;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getSingleQueryArgument}
             * @param singleQueryArgument Inspect a single query argument.
             *                            Provide the name of the query argument to inspect, such as <em>UserName</em> or <em>SalesRegion</em> . The name can be up to 30 characters long and isn't case sensitive.
             *                            <p>
             *                            Example JSON: <code>"SingleQueryArgument": { "Name": "myArgument" }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singleQueryArgument(java.lang.Object singleQueryArgument) {
                this.singleQueryArgument = singleQueryArgument;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getUriFragment}
             * @param uriFragment Inspect fragments of the request URI.
             *                    You must configure scope and pattern matching filters in the <code>UriFragment</code> object, to define the fragment of a URI that AWS WAF inspects.
             *                    <p>
             *                    Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the <code>UriFragment</code> object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uriFragment(software.amazon.awscdk.IResolvable uriFragment) {
                this.uriFragment = uriFragment;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getUriFragment}
             * @param uriFragment Inspect fragments of the request URI.
             *                    You must configure scope and pattern matching filters in the <code>UriFragment</code> object, to define the fragment of a URI that AWS WAF inspects.
             *                    <p>
             *                    Only the first 8 KB (8192 bytes) of a request's URI fragments and only the first 200 URI fragments are forwarded to AWS WAF for inspection by the underlying host service. You must configure how to handle any oversize URI fragment content in the <code>UriFragment</code> object. AWS WAF applies the pattern matching filters to the cookies that it receives from the underlying host service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uriFragment(software.amazon.awscdk.services.wafv2.CfnWebACL.UriFragmentProperty uriFragment) {
                this.uriFragment = uriFragment;
                return this;
            }

            /**
             * Sets the value of {@link FieldToMatchProperty#getUriPath}
             * @param uriPath Inspect the request URI path.
             *                This is the part of the web request that identifies a resource, for example, <code>/images/daily-ad.jpg</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uriPath(java.lang.Object uriPath) {
                this.uriPath = uriPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldToMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldToMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldToMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldToMatchProperty {
            private final java.lang.Object allQueryArguments;
            private final java.lang.Object body;
            private final java.lang.Object cookies;
            private final java.lang.Object headers;
            private final java.lang.Object ja3Fingerprint;
            private final java.lang.Object ja4Fingerprint;
            private final java.lang.Object jsonBody;
            private final java.lang.Object method;
            private final java.lang.Object queryString;
            private final java.lang.Object singleHeader;
            private final java.lang.Object singleQueryArgument;
            private final java.lang.Object uriFragment;
            private final java.lang.Object uriPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allQueryArguments = software.amazon.jsii.Kernel.get(this, "allQueryArguments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cookies = software.amazon.jsii.Kernel.get(this, "cookies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ja3Fingerprint = software.amazon.jsii.Kernel.get(this, "ja3Fingerprint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ja4Fingerprint = software.amazon.jsii.Kernel.get(this, "ja4Fingerprint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jsonBody = software.amazon.jsii.Kernel.get(this, "jsonBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleHeader = software.amazon.jsii.Kernel.get(this, "singleHeader", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singleQueryArgument = software.amazon.jsii.Kernel.get(this, "singleQueryArgument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.uriFragment = software.amazon.jsii.Kernel.get(this, "uriFragment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.uriPath = software.amazon.jsii.Kernel.get(this, "uriPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allQueryArguments = builder.allQueryArguments;
                this.body = builder.body;
                this.cookies = builder.cookies;
                this.headers = builder.headers;
                this.ja3Fingerprint = builder.ja3Fingerprint;
                this.ja4Fingerprint = builder.ja4Fingerprint;
                this.jsonBody = builder.jsonBody;
                this.method = builder.method;
                this.queryString = builder.queryString;
                this.singleHeader = builder.singleHeader;
                this.singleQueryArgument = builder.singleQueryArgument;
                this.uriFragment = builder.uriFragment;
                this.uriPath = builder.uriPath;
            }

            @Override
            public final java.lang.Object getAllQueryArguments() {
                return this.allQueryArguments;
            }

            @Override
            public final java.lang.Object getBody() {
                return this.body;
            }

            @Override
            public final java.lang.Object getCookies() {
                return this.cookies;
            }

            @Override
            public final java.lang.Object getHeaders() {
                return this.headers;
            }

            @Override
            public final java.lang.Object getJa3Fingerprint() {
                return this.ja3Fingerprint;
            }

            @Override
            public final java.lang.Object getJa4Fingerprint() {
                return this.ja4Fingerprint;
            }

            @Override
            public final java.lang.Object getJsonBody() {
                return this.jsonBody;
            }

            @Override
            public final java.lang.Object getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.Object getQueryString() {
                return this.queryString;
            }

            @Override
            public final java.lang.Object getSingleHeader() {
                return this.singleHeader;
            }

            @Override
            public final java.lang.Object getSingleQueryArgument() {
                return this.singleQueryArgument;
            }

            @Override
            public final java.lang.Object getUriFragment() {
                return this.uriFragment;
            }

            @Override
            public final java.lang.Object getUriPath() {
                return this.uriPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllQueryArguments() != null) {
                    data.set("allQueryArguments", om.valueToTree(this.getAllQueryArguments()));
                }
                if (this.getBody() != null) {
                    data.set("body", om.valueToTree(this.getBody()));
                }
                if (this.getCookies() != null) {
                    data.set("cookies", om.valueToTree(this.getCookies()));
                }
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }
                if (this.getJa3Fingerprint() != null) {
                    data.set("ja3Fingerprint", om.valueToTree(this.getJa3Fingerprint()));
                }
                if (this.getJa4Fingerprint() != null) {
                    data.set("ja4Fingerprint", om.valueToTree(this.getJa4Fingerprint()));
                }
                if (this.getJsonBody() != null) {
                    data.set("jsonBody", om.valueToTree(this.getJsonBody()));
                }
                if (this.getMethod() != null) {
                    data.set("method", om.valueToTree(this.getMethod()));
                }
                if (this.getQueryString() != null) {
                    data.set("queryString", om.valueToTree(this.getQueryString()));
                }
                if (this.getSingleHeader() != null) {
                    data.set("singleHeader", om.valueToTree(this.getSingleHeader()));
                }
                if (this.getSingleQueryArgument() != null) {
                    data.set("singleQueryArgument", om.valueToTree(this.getSingleQueryArgument()));
                }
                if (this.getUriFragment() != null) {
                    data.set("uriFragment", om.valueToTree(this.getUriFragment()));
                }
                if (this.getUriPath() != null) {
                    data.set("uriPath", om.valueToTree(this.getUriPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.FieldToMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldToMatchProperty.Jsii$Proxy that = (FieldToMatchProperty.Jsii$Proxy) o;

                if (this.allQueryArguments != null ? !this.allQueryArguments.equals(that.allQueryArguments) : that.allQueryArguments != null) return false;
                if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
                if (this.cookies != null ? !this.cookies.equals(that.cookies) : that.cookies != null) return false;
                if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
                if (this.ja3Fingerprint != null ? !this.ja3Fingerprint.equals(that.ja3Fingerprint) : that.ja3Fingerprint != null) return false;
                if (this.ja4Fingerprint != null ? !this.ja4Fingerprint.equals(that.ja4Fingerprint) : that.ja4Fingerprint != null) return false;
                if (this.jsonBody != null ? !this.jsonBody.equals(that.jsonBody) : that.jsonBody != null) return false;
                if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
                if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) return false;
                if (this.singleHeader != null ? !this.singleHeader.equals(that.singleHeader) : that.singleHeader != null) return false;
                if (this.singleQueryArgument != null ? !this.singleQueryArgument.equals(that.singleQueryArgument) : that.singleQueryArgument != null) return false;
                if (this.uriFragment != null ? !this.uriFragment.equals(that.uriFragment) : that.uriFragment != null) return false;
                return this.uriPath != null ? this.uriPath.equals(that.uriPath) : that.uriPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allQueryArguments != null ? this.allQueryArguments.hashCode() : 0;
                result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
                result = 31 * result + (this.cookies != null ? this.cookies.hashCode() : 0);
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                result = 31 * result + (this.ja3Fingerprint != null ? this.ja3Fingerprint.hashCode() : 0);
                result = 31 * result + (this.ja4Fingerprint != null ? this.ja4Fingerprint.hashCode() : 0);
                result = 31 * result + (this.jsonBody != null ? this.jsonBody.hashCode() : 0);
                result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
                result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
                result = 31 * result + (this.singleHeader != null ? this.singleHeader.hashCode() : 0);
                result = 31 * result + (this.singleQueryArgument != null ? this.singleQueryArgument.hashCode() : 0);
                result = 31 * result + (this.uriFragment != null ? this.uriFragment.hashCode() : 0);
                result = 31 * result + (this.uriPath != null ? this.uriPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a field type and keys to protect in stored web request data.
     * <p>
     * This is part of the data protection configuration for a web ACL.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * FieldToProtectProperty fieldToProtectProperty = FieldToProtectProperty.builder()
     *         .fieldType("fieldType")
     *         // the properties below are optional
     *         .fieldKeys(List.of("fieldKeys"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtoprotect.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtoprotect.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.FieldToProtectProperty")
    @software.amazon.jsii.Jsii.Proxy(FieldToProtectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FieldToProtectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the web request component type to protect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtoprotect.html#cfn-wafv2-webacl-fieldtoprotect-fieldtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtoprotect.html#cfn-wafv2-webacl-fieldtoprotect-fieldtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFieldType();

        /**
         * Specifies the keys to protect for the specified field type.
         * <p>
         * If you don't specify any key, then all keys for the field type are protected.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtoprotect.html#cfn-wafv2-webacl-fieldtoprotect-fieldkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-fieldtoprotect.html#cfn-wafv2-webacl-fieldtoprotect-fieldkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFieldKeys() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FieldToProtectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FieldToProtectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FieldToProtectProperty> {
            java.lang.String fieldType;
            java.util.List<java.lang.String> fieldKeys;

            /**
             * Sets the value of {@link FieldToProtectProperty#getFieldType}
             * @param fieldType Specifies the web request component type to protect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldType(java.lang.String fieldType) {
                this.fieldType = fieldType;
                return this;
            }

            /**
             * Sets the value of {@link FieldToProtectProperty#getFieldKeys}
             * @param fieldKeys Specifies the keys to protect for the specified field type.
             *                  If you don't specify any key, then all keys for the field type are protected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldKeys(java.util.List<java.lang.String> fieldKeys) {
                this.fieldKeys = fieldKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FieldToProtectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FieldToProtectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FieldToProtectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldToProtectProperty {
            private final java.lang.String fieldType;
            private final java.util.List<java.lang.String> fieldKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldType = software.amazon.jsii.Kernel.get(this, "fieldType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldKeys = software.amazon.jsii.Kernel.get(this, "fieldKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldType = java.util.Objects.requireNonNull(builder.fieldType, "fieldType is required");
                this.fieldKeys = builder.fieldKeys;
            }

            @Override
            public final java.lang.String getFieldType() {
                return this.fieldType;
            }

            @Override
            public final java.util.List<java.lang.String> getFieldKeys() {
                return this.fieldKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldType", om.valueToTree(this.getFieldType()));
                if (this.getFieldKeys() != null) {
                    data.set("fieldKeys", om.valueToTree(this.getFieldKeys()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.FieldToProtectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FieldToProtectProperty.Jsii$Proxy that = (FieldToProtectProperty.Jsii$Proxy) o;

                if (!fieldType.equals(that.fieldType)) return false;
                return this.fieldKeys != null ? this.fieldKeys.equals(that.fieldKeys) : that.fieldKeys == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldType.hashCode();
                result = 31 * result + (this.fieldKeys != null ? this.fieldKeys.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
     * <p>
     * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
     * <p>
     * <blockquote>
     * <p>
     * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
     * <p>
     * </blockquote>
     * <p>
     * This configuration is used for <code>GeoMatchStatement</code> , <code>AsnMatchStatement</code> , and <code>RateBasedStatement</code> . For <code>IPSetReferenceStatement</code> , use <code>IPSetForwardedIPConfig</code> instead.
     * <p>
     * AWS WAF only evaluates the first IP address found in the specified HTTP header.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ForwardedIPConfigurationProperty forwardedIPConfigurationProperty = ForwardedIPConfigurationProperty.builder()
     *         .fallbackBehavior("fallbackBehavior")
     *         .headerName("headerName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ForwardedIPConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ForwardedIPConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ForwardedIPConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         * <p>
         * You can specify the following fallback behaviors:
         * <p>
         * <ul>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html#cfn-wafv2-webacl-forwardedipconfiguration-fallbackbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html#cfn-wafv2-webacl-forwardedipconfiguration-fallbackbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFallbackBehavior();

        /**
         * The name of the HTTP header to use for the IP address.
         * <p>
         * For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code> .
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html#cfn-wafv2-webacl-forwardedipconfiguration-headername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-forwardedipconfiguration.html#cfn-wafv2-webacl-forwardedipconfiguration-headername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderName();

        /**
         * @return a {@link Builder} of {@link ForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ForwardedIPConfigurationProperty> {
            java.lang.String fallbackBehavior;
            java.lang.String headerName;

            /**
             * Sets the value of {@link ForwardedIPConfigurationProperty#getFallbackBehavior}
             * @param fallbackBehavior The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. This parameter is required.
             *                         <blockquote>
             *                         <p>
             *                         If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         You can specify the following fallback behaviors:
             *                         <p>
             *                         <ul>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fallbackBehavior(java.lang.String fallbackBehavior) {
                this.fallbackBehavior = fallbackBehavior;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedIPConfigurationProperty#getHeaderName}
             * @param headerName The name of the HTTP header to use for the IP address. This parameter is required.
             *                   For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerName(java.lang.String headerName) {
                this.headerName = headerName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ForwardedIPConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ForwardedIPConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ForwardedIPConfigurationProperty {
            private final java.lang.String fallbackBehavior;
            private final java.lang.String headerName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fallbackBehavior = software.amazon.jsii.Kernel.get(this, "fallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerName = software.amazon.jsii.Kernel.get(this, "headerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fallbackBehavior = java.util.Objects.requireNonNull(builder.fallbackBehavior, "fallbackBehavior is required");
                this.headerName = java.util.Objects.requireNonNull(builder.headerName, "headerName is required");
            }

            @Override
            public final java.lang.String getFallbackBehavior() {
                return this.fallbackBehavior;
            }

            @Override
            public final java.lang.String getHeaderName() {
                return this.headerName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fallbackBehavior", om.valueToTree(this.getFallbackBehavior()));
                data.set("headerName", om.valueToTree(this.getHeaderName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ForwardedIPConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ForwardedIPConfigurationProperty.Jsii$Proxy that = (ForwardedIPConfigurationProperty.Jsii$Proxy) o;

                if (!fallbackBehavior.equals(that.fallbackBehavior)) return false;
                return this.headerName.equals(that.headerName);
            }

            @Override
            public final int hashCode() {
                int result = this.fallbackBehavior.hashCode();
                result = 31 * result + (this.headerName.hashCode());
                return result;
            }
        }
    }
    /**
     * A rule statement that labels web requests by country and region and that matches against web requests based on country code.
     * <p>
     * A geo match rule labels every request that it inspects regardless of whether it finds a match.
     * <p>
     * <ul>
     * <li>To manage requests only by country, you can use this statement by itself and specify the countries that you want to match against in the <code>CountryCodes</code> array.</li>
     * <li>Otherwise, configure your geo match rule with Count action so that it only labels requests. Then, add one or more label match rules to run after the geo match rule and configure them to match against the geographic labels and handle the requests as needed.</li>
     * </ul>
     * <p>
     * AWS WAF labels requests using the alpha-2 country and region codes from the International Organization for Standardization (ISO) 3166 standard. AWS WAF determines the codes using either the IP address in the web request origin or, if you specify it, the address in the geo match <code>ForwardedIPConfig</code> .
     * <p>
     * If you use the web request origin, the label formats are <code>awswaf:clientip:geo:region:&lt;ISO country code&gt;-&lt;ISO region code&gt;</code> and <code>awswaf:clientip:geo:country:&lt;ISO country code&gt;</code> .
     * <p>
     * If you use a forwarded IP address, the label formats are <code>awswaf:forwardedip:geo:region:&lt;ISO country code&gt;-&lt;ISO region code&gt;</code> and <code>awswaf:forwardedip:geo:country:&lt;ISO country code&gt;</code> .
     * <p>
     * For additional details, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-type-geo-match.html">Geographic match rule statement</a> in the <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html">AWS WAF Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * GeoMatchStatementProperty geoMatchStatementProperty = GeoMatchStatementProperty.builder()
     *         .countryCodes(List.of("countryCodes"))
     *         .forwardedIpConfig(ForwardedIPConfigurationProperty.builder()
     *                 .fallbackBehavior("fallbackBehavior")
     *                 .headerName("headerName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.GeoMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of two-character country codes that you want to match against, for example, <code>[ "US", "CN" ]</code> , from the alpha-2 country ISO codes of the ISO 3166 international standard.
         * <p>
         * When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-countrycodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-countrycodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCountryCodes() {
            return null;
        }

        /**
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
         * <p>
         * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-forwardedipconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-geomatchstatement.html#cfn-wafv2-webacl-geomatchstatement-forwardedipconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedIpConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoMatchStatementProperty> {
            java.util.List<java.lang.String> countryCodes;
            java.lang.Object forwardedIpConfig;

            /**
             * Sets the value of {@link GeoMatchStatementProperty#getCountryCodes}
             * @param countryCodes An array of two-character country codes that you want to match against, for example, <code>[ "US", "CN" ]</code> , from the alpha-2 country ISO codes of the ISO 3166 international standard.
             *                     When you use a geo match statement just for the region and country labels that it adds to requests, you still have to supply a country code for the rule to evaluate. In this case, you configure the rule to only count matching requests, but it will still generate logging and count metrics for any matches. You can reduce the logging and metrics that the rule produces by specifying a country that's unlikely to be a source of traffic to your site.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder countryCodes(java.util.List<java.lang.String> countryCodes) {
                this.countryCodes = countryCodes;
                return this;
            }

            /**
             * Sets the value of {@link GeoMatchStatementProperty#getForwardedIpConfig}
             * @param forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                          Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIpConfig(software.amazon.awscdk.IResolvable forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link GeoMatchStatementProperty#getForwardedIpConfig}
             * @param forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                          Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                          <p>
             *                          </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIpConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.ForwardedIPConfigurationProperty forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GeoMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoMatchStatementProperty {
            private final java.util.List<java.lang.String> countryCodes;
            private final java.lang.Object forwardedIpConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.countryCodes = software.amazon.jsii.Kernel.get(this, "countryCodes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.forwardedIpConfig = software.amazon.jsii.Kernel.get(this, "forwardedIpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.countryCodes = builder.countryCodes;
                this.forwardedIpConfig = builder.forwardedIpConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getCountryCodes() {
                return this.countryCodes;
            }

            @Override
            public final java.lang.Object getForwardedIpConfig() {
                return this.forwardedIpConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCountryCodes() != null) {
                    data.set("countryCodes", om.valueToTree(this.getCountryCodes()));
                }
                if (this.getForwardedIpConfig() != null) {
                    data.set("forwardedIpConfig", om.valueToTree(this.getForwardedIpConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.GeoMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoMatchStatementProperty.Jsii$Proxy that = (GeoMatchStatementProperty.Jsii$Proxy) o;

                if (this.countryCodes != null ? !this.countryCodes.equals(that.countryCodes) : that.countryCodes != null) return false;
                return this.forwardedIpConfig != null ? this.forwardedIpConfig.equals(that.forwardedIpConfig) : that.forwardedIpConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.countryCodes != null ? this.countryCodes.hashCode() : 0;
                result = 31 * result + (this.forwardedIpConfig != null ? this.forwardedIpConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The filter to use to identify the subset of headers to inspect in a web request.
     * <p>
     * You must specify exactly one setting: either <code>All</code> , <code>IncludedHeaders</code> , or <code>ExcludedHeaders</code> .
     * <p>
     * Example JSON: <code>"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * HeaderMatchPatternProperty headerMatchPatternProperty = HeaderMatchPatternProperty.builder()
     *         .all(all)
     *         .excludedHeaders(List.of("excludedHeaders"))
     *         .includedHeaders(List.of("includedHeaders"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.HeaderMatchPatternProperty")
    @software.amazon.jsii.Jsii.Proxy(HeaderMatchPatternProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeaderMatchPatternProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Inspect all headers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-all">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-all</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAll() {
            return null;
        }

        /**
         * Inspect only the headers whose keys don't match any of the strings specified here.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-excludedheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-excludedheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludedHeaders() {
            return null;
        }

        /**
         * Inspect only the headers that have a key that matches one of the strings specified here.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-includedheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headermatchpattern.html#cfn-wafv2-webacl-headermatchpattern-includedheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedHeaders() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HeaderMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeaderMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeaderMatchPatternProperty> {
            java.lang.Object all;
            java.util.List<java.lang.String> excludedHeaders;
            java.util.List<java.lang.String> includedHeaders;

            /**
             * Sets the value of {@link HeaderMatchPatternProperty#getAll}
             * @param all Inspect all headers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder all(java.lang.Object all) {
                this.all = all;
                return this;
            }

            /**
             * Sets the value of {@link HeaderMatchPatternProperty#getExcludedHeaders}
             * @param excludedHeaders Inspect only the headers whose keys don't match any of the strings specified here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedHeaders(java.util.List<java.lang.String> excludedHeaders) {
                this.excludedHeaders = excludedHeaders;
                return this;
            }

            /**
             * Sets the value of {@link HeaderMatchPatternProperty#getIncludedHeaders}
             * @param includedHeaders Inspect only the headers that have a key that matches one of the strings specified here.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedHeaders(java.util.List<java.lang.String> includedHeaders) {
                this.includedHeaders = includedHeaders;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeaderMatchPatternProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeaderMatchPatternProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HeaderMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeaderMatchPatternProperty {
            private final java.lang.Object all;
            private final java.util.List<java.lang.String> excludedHeaders;
            private final java.util.List<java.lang.String> includedHeaders;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.all = software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludedHeaders = software.amazon.jsii.Kernel.get(this, "excludedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includedHeaders = software.amazon.jsii.Kernel.get(this, "includedHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.all = builder.all;
                this.excludedHeaders = builder.excludedHeaders;
                this.includedHeaders = builder.includedHeaders;
            }

            @Override
            public final java.lang.Object getAll() {
                return this.all;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludedHeaders() {
                return this.excludedHeaders;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedHeaders() {
                return this.includedHeaders;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAll() != null) {
                    data.set("all", om.valueToTree(this.getAll()));
                }
                if (this.getExcludedHeaders() != null) {
                    data.set("excludedHeaders", om.valueToTree(this.getExcludedHeaders()));
                }
                if (this.getIncludedHeaders() != null) {
                    data.set("includedHeaders", om.valueToTree(this.getIncludedHeaders()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.HeaderMatchPatternProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeaderMatchPatternProperty.Jsii$Proxy that = (HeaderMatchPatternProperty.Jsii$Proxy) o;

                if (this.all != null ? !this.all.equals(that.all) : that.all != null) return false;
                if (this.excludedHeaders != null ? !this.excludedHeaders.equals(that.excludedHeaders) : that.excludedHeaders != null) return false;
                return this.includedHeaders != null ? this.includedHeaders.equals(that.includedHeaders) : that.includedHeaders == null;
            }

            @Override
            public final int hashCode() {
                int result = this.all != null ? this.all.hashCode() : 0;
                result = 31 * result + (this.excludedHeaders != null ? this.excludedHeaders.hashCode() : 0);
                result = 31 * result + (this.includedHeaders != null ? this.includedHeaders.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Inspect all headers in the web request.
     * <p>
     * You can specify the parts of the headers to inspect and you can narrow the set of headers to inspect by including or excluding specific keys.
     * <p>
     * This is used to indicate the web request component to inspect, in the <code>FieldToMatch</code> specification.
     * <p>
     * If you want to inspect just the value of a single header, use the <code>SingleHeader</code> <code>FieldToMatch</code> setting instead.
     * <p>
     * Example JSON: <code>"Headers": { "MatchPattern": { "All": {} }, "MatchScope": "KEY", "OversizeHandling": "MATCH" }</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * HeadersProperty headersProperty = HeadersProperty.builder()
     *         .matchPattern(HeaderMatchPatternProperty.builder()
     *                 .all(all)
     *                 .excludedHeaders(List.of("excludedHeaders"))
     *                 .includedHeaders(List.of("includedHeaders"))
     *                 .build())
     *         .matchScope("matchScope")
     *         .oversizeHandling("oversizeHandling")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.HeadersProperty")
    @software.amazon.jsii.Jsii.Proxy(HeadersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeadersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The filter to use to identify the subset of headers to inspect in a web request.
         * <p>
         * You must specify exactly one setting: either <code>All</code> , <code>IncludedHeaders</code> , or <code>ExcludedHeaders</code> .
         * <p>
         * Example JSON: <code>"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-matchpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-matchpattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatchPattern();

        /**
         * The parts of the headers to match with the rule inspection criteria.
         * <p>
         * If you specify <code>ALL</code> , AWS WAF inspects both keys and values.
         * <p>
         * <code>All</code> does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical <code>AND</code> statement to combine two match rules, one that inspects the keys and another that inspects the values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-matchscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-matchscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMatchScope();

        /**
         * What AWS WAF should do if the headers determined by your match scope are more numerous or larger than AWS WAF can inspect.
         * <p>
         * AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .
         * <p>
         * The options for oversize handling are the following:
         * <p>
         * <ul>
         * <li><code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection criteria.</li>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-oversizehandling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-headers.html#cfn-wafv2-webacl-headers-oversizehandling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOversizeHandling();

        /**
         * @return a {@link Builder} of {@link HeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeadersProperty> {
            java.lang.Object matchPattern;
            java.lang.String matchScope;
            java.lang.String oversizeHandling;

            /**
             * Sets the value of {@link HeadersProperty#getMatchPattern}
             * @param matchPattern The filter to use to identify the subset of headers to inspect in a web request. This parameter is required.
             *                     You must specify exactly one setting: either <code>All</code> , <code>IncludedHeaders</code> , or <code>ExcludedHeaders</code> .
             *                     <p>
             *                     Example JSON: <code>"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.IResolvable matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link HeadersProperty#getMatchPattern}
             * @param matchPattern The filter to use to identify the subset of headers to inspect in a web request. This parameter is required.
             *                     You must specify exactly one setting: either <code>All</code> , <code>IncludedHeaders</code> , or <code>ExcludedHeaders</code> .
             *                     <p>
             *                     Example JSON: <code>"MatchPattern": { "ExcludedHeaders": [ "KeyToExclude1", "KeyToExclude2" ] }</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.services.wafv2.CfnWebACL.HeaderMatchPatternProperty matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link HeadersProperty#getMatchScope}
             * @param matchScope The parts of the headers to match with the rule inspection criteria. This parameter is required.
             *                   If you specify <code>ALL</code> , AWS WAF inspects both keys and values.
             *                   <p>
             *                   <code>All</code> does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical <code>AND</code> statement to combine two match rules, one that inspects the keys and another that inspects the values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchScope(java.lang.String matchScope) {
                this.matchScope = matchScope;
                return this;
            }

            /**
             * Sets the value of {@link HeadersProperty#getOversizeHandling}
             * @param oversizeHandling What AWS WAF should do if the headers determined by your match scope are more numerous or larger than AWS WAF can inspect. This parameter is required.
             *                         AWS WAF does not support inspecting the entire contents of request headers when they exceed 8 KB (8192 bytes) or 200 total headers. The underlying host service forwards a maximum of 200 headers and at most 8 KB of header contents to AWS WAF .
             *                         <p>
             *                         The options for oversize handling are the following:
             *                         <p>
             *                         <ul>
             *                         <li><code>CONTINUE</code> - Inspect the available headers normally, according to the rule inspection criteria.</li>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oversizeHandling(java.lang.String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeadersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeadersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HeadersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeadersProperty {
            private final java.lang.Object matchPattern;
            private final java.lang.String matchScope;
            private final java.lang.String oversizeHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchPattern = software.amazon.jsii.Kernel.get(this, "matchPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchScope = software.amazon.jsii.Kernel.get(this, "matchScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oversizeHandling = software.amazon.jsii.Kernel.get(this, "oversizeHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchPattern = java.util.Objects.requireNonNull(builder.matchPattern, "matchPattern is required");
                this.matchScope = java.util.Objects.requireNonNull(builder.matchScope, "matchScope is required");
                this.oversizeHandling = java.util.Objects.requireNonNull(builder.oversizeHandling, "oversizeHandling is required");
            }

            @Override
            public final java.lang.Object getMatchPattern() {
                return this.matchPattern;
            }

            @Override
            public final java.lang.String getMatchScope() {
                return this.matchScope;
            }

            @Override
            public final java.lang.String getOversizeHandling() {
                return this.oversizeHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchPattern", om.valueToTree(this.getMatchPattern()));
                data.set("matchScope", om.valueToTree(this.getMatchScope()));
                data.set("oversizeHandling", om.valueToTree(this.getOversizeHandling()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.HeadersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeadersProperty.Jsii$Proxy that = (HeadersProperty.Jsii$Proxy) o;

                if (!matchPattern.equals(that.matchPattern)) return false;
                if (!matchScope.equals(that.matchScope)) return false;
                return this.oversizeHandling.equals(that.oversizeHandling);
            }

            @Override
            public final int hashCode() {
                int result = this.matchPattern.hashCode();
                result = 31 * result + (this.matchScope.hashCode());
                result = 31 * result + (this.oversizeHandling.hashCode());
                return result;
            }
        }
    }
    /**
     * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
     * <p>
     * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
     * <p>
     * <blockquote>
     * <p>
     * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
     * <p>
     * </blockquote>
     * <p>
     * This configuration is used only for <code>IPSetReferenceStatement</code> . For <code>GeoMatchStatement</code> and <code>RateBasedStatement</code> , use <code>ForwardedIPConfig</code> instead.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * IPSetForwardedIPConfigurationProperty iPSetForwardedIPConfigurationProperty = Map.of(
     *         "fallbackBehavior", "fallbackBehavior",
     *         "headerName", "headerName",
     *         "position", "position");
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.IPSetForwardedIPConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(IPSetForwardedIPConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IPSetForwardedIPConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The match status to assign to the web request if the request doesn't have a valid IP address in the specified position.
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         * <p>
         * You can specify the following fallback behaviors:
         * <p>
         * <ul>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-fallbackbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-fallbackbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFallbackBehavior();

        /**
         * The name of the HTTP header to use for the IP address.
         * <p>
         * For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code> .
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-headername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-headername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderName();

        /**
         * The position in the header to search for the IP address.
         * <p>
         * The header can contain IP addresses of the original client and also of proxies. For example, the header value could be <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original client and the rest identify proxies that the request went through.
         * <p>
         * The options for this setting are the following:
         * <p>
         * <ul>
         * <li>FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.</li>
         * <li>LAST - Inspect the last IP address in the list of IP addresses in the header.</li>
         * <li>ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-position">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetforwardedipconfiguration.html#cfn-wafv2-webacl-ipsetforwardedipconfiguration-position</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPosition();

        /**
         * @return a {@link Builder} of {@link IPSetForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IPSetForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IPSetForwardedIPConfigurationProperty> {
            java.lang.String fallbackBehavior;
            java.lang.String headerName;
            java.lang.String position;

            /**
             * Sets the value of {@link IPSetForwardedIPConfigurationProperty#getFallbackBehavior}
             * @param fallbackBehavior The match status to assign to the web request if the request doesn't have a valid IP address in the specified position. This parameter is required.
             *                         <blockquote>
             *                         <p>
             *                         If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         You can specify the following fallback behaviors:
             *                         <p>
             *                         <ul>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fallbackBehavior(java.lang.String fallbackBehavior) {
                this.fallbackBehavior = fallbackBehavior;
                return this;
            }

            /**
             * Sets the value of {@link IPSetForwardedIPConfigurationProperty#getHeaderName}
             * @param headerName The name of the HTTP header to use for the IP address. This parameter is required.
             *                   For example, to use the X-Forwarded-For (XFF) header, set this to <code>X-Forwarded-For</code> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerName(java.lang.String headerName) {
                this.headerName = headerName;
                return this;
            }

            /**
             * Sets the value of {@link IPSetForwardedIPConfigurationProperty#getPosition}
             * @param position The position in the header to search for the IP address. This parameter is required.
             *                 The header can contain IP addresses of the original client and also of proxies. For example, the header value could be <code>10.1.1.1, 127.0.0.0, 10.10.10.10</code> where the first IP address identifies the original client and the rest identify proxies that the request went through.
             *                 <p>
             *                 The options for this setting are the following:
             *                 <p>
             *                 <ul>
             *                 <li>FIRST - Inspect the first IP address in the list of IP addresses in the header. This is usually the client's original IP.</li>
             *                 <li>LAST - Inspect the last IP address in the list of IP addresses in the header.</li>
             *                 <li>ANY - Inspect all IP addresses in the header for a match. If the header contains more than 10 IP addresses, AWS WAF inspects the last 10.</li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder position(java.lang.String position) {
                this.position = position;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IPSetForwardedIPConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IPSetForwardedIPConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IPSetForwardedIPConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPSetForwardedIPConfigurationProperty {
            private final java.lang.String fallbackBehavior;
            private final java.lang.String headerName;
            private final java.lang.String position;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fallbackBehavior = software.amazon.jsii.Kernel.get(this, "fallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerName = software.amazon.jsii.Kernel.get(this, "headerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.position = software.amazon.jsii.Kernel.get(this, "position", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fallbackBehavior = java.util.Objects.requireNonNull(builder.fallbackBehavior, "fallbackBehavior is required");
                this.headerName = java.util.Objects.requireNonNull(builder.headerName, "headerName is required");
                this.position = java.util.Objects.requireNonNull(builder.position, "position is required");
            }

            @Override
            public final java.lang.String getFallbackBehavior() {
                return this.fallbackBehavior;
            }

            @Override
            public final java.lang.String getHeaderName() {
                return this.headerName;
            }

            @Override
            public final java.lang.String getPosition() {
                return this.position;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fallbackBehavior", om.valueToTree(this.getFallbackBehavior()));
                data.set("headerName", om.valueToTree(this.getHeaderName()));
                data.set("position", om.valueToTree(this.getPosition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.IPSetForwardedIPConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IPSetForwardedIPConfigurationProperty.Jsii$Proxy that = (IPSetForwardedIPConfigurationProperty.Jsii$Proxy) o;

                if (!fallbackBehavior.equals(that.fallbackBehavior)) return false;
                if (!headerName.equals(that.headerName)) return false;
                return this.position.equals(that.position);
            }

            @Override
            public final int hashCode() {
                int result = this.fallbackBehavior.hashCode();
                result = 31 * result + (this.headerName.hashCode());
                result = 31 * result + (this.position.hashCode());
                return result;
            }
        }
    }
    /**
     * A rule statement used to detect web requests coming from particular IP addresses or address ranges.
     * <p>
     * To use this, create an <code>IPSet</code> that specifies the addresses you want to detect, then use the ARN of that set in this statement.
     * <p>
     * Each IP set rule statement references an IP set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * IPSetReferenceStatementProperty iPSetReferenceStatementProperty = Map.of(
     *         "arn", "arn",
     *         // the properties below are optional
     *         "ipSetForwardedIpConfig", Map.of(
     *                 "fallbackBehavior", "fallbackBehavior",
     *                 "headerName", "headerName",
     *                 "position", "position"));
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.IPSetReferenceStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(IPSetReferenceStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IPSetReferenceStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the <code>IPSet</code> that this statement references.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
         * <p>
         * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-ipsetforwardedipconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ipsetreferencestatement.html#cfn-wafv2-webacl-ipsetreferencestatement-ipsetforwardedipconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpSetForwardedIpConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IPSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IPSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IPSetReferenceStatementProperty> {
            java.lang.String arn;
            java.lang.Object ipSetForwardedIpConfig;

            /**
             * Sets the value of {@link IPSetReferenceStatementProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the <code>IPSet</code> that this statement references. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link IPSetReferenceStatementProperty#getIpSetForwardedIpConfig}
             * @param ipSetForwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                               Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipSetForwardedIpConfig(software.amazon.awscdk.IResolvable ipSetForwardedIpConfig) {
                this.ipSetForwardedIpConfig = ipSetForwardedIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link IPSetReferenceStatementProperty#getIpSetForwardedIpConfig}
             * @param ipSetForwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                               Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                               <p>
             *                               <blockquote>
             *                               <p>
             *                               If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                               <p>
             *                               </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipSetForwardedIpConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.IPSetForwardedIPConfigurationProperty ipSetForwardedIpConfig) {
                this.ipSetForwardedIpConfig = ipSetForwardedIpConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IPSetReferenceStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IPSetReferenceStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IPSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IPSetReferenceStatementProperty {
            private final java.lang.String arn;
            private final java.lang.Object ipSetForwardedIpConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipSetForwardedIpConfig = software.amazon.jsii.Kernel.get(this, "ipSetForwardedIpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.ipSetForwardedIpConfig = builder.ipSetForwardedIpConfig;
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.Object getIpSetForwardedIpConfig() {
                return this.ipSetForwardedIpConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                if (this.getIpSetForwardedIpConfig() != null) {
                    data.set("ipSetForwardedIpConfig", om.valueToTree(this.getIpSetForwardedIpConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.IPSetReferenceStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IPSetReferenceStatementProperty.Jsii$Proxy that = (IPSetReferenceStatementProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                return this.ipSetForwardedIpConfig != null ? this.ipSetForwardedIpConfig.equals(that.ipSetForwardedIpConfig) : that.ipSetForwardedIpConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.ipSetForwardedIpConfig != null ? this.ipSetForwardedIpConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Used for CAPTCHA and challenge token settings.
     * <p>
     * Determines how long a <code>CAPTCHA</code> or challenge timestamp remains valid after AWS WAF updates it for a successful <code>CAPTCHA</code> or challenge response.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ImmunityTimePropertyProperty immunityTimePropertyProperty = ImmunityTimePropertyProperty.builder()
     *         .immunityTime(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-immunitytimeproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-immunitytimeproperty.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ImmunityTimePropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(ImmunityTimePropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImmunityTimePropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of time, in seconds, that a <code>CAPTCHA</code> or challenge timestamp is considered valid by AWS WAF .
         * <p>
         * The default setting is 300.
         * <p>
         * For the Challenge action, the minimum setting is 300.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-immunitytimeproperty.html#cfn-wafv2-webacl-immunitytimeproperty-immunitytime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-immunitytimeproperty.html#cfn-wafv2-webacl-immunitytimeproperty-immunitytime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getImmunityTime();

        /**
         * @return a {@link Builder} of {@link ImmunityTimePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImmunityTimePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImmunityTimePropertyProperty> {
            java.lang.Number immunityTime;

            /**
             * Sets the value of {@link ImmunityTimePropertyProperty#getImmunityTime}
             * @param immunityTime The amount of time, in seconds, that a <code>CAPTCHA</code> or challenge timestamp is considered valid by AWS WAF . This parameter is required.
             *                     The default setting is 300.
             *                     <p>
             *                     For the Challenge action, the minimum setting is 300.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder immunityTime(java.lang.Number immunityTime) {
                this.immunityTime = immunityTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImmunityTimePropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImmunityTimePropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImmunityTimePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImmunityTimePropertyProperty {
            private final java.lang.Number immunityTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.immunityTime = software.amazon.jsii.Kernel.get(this, "immunityTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.immunityTime = java.util.Objects.requireNonNull(builder.immunityTime, "immunityTime is required");
            }

            @Override
            public final java.lang.Number getImmunityTime() {
                return this.immunityTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("immunityTime", om.valueToTree(this.getImmunityTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ImmunityTimePropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImmunityTimePropertyProperty.Jsii$Proxy that = (ImmunityTimePropertyProperty.Jsii$Proxy) o;

                return this.immunityTime.equals(that.immunityTime);
            }

            @Override
            public final int hashCode() {
                int result = this.immunityTime.hashCode();
                return result;
            }
        }
    }
    /**
     * Available for use with Amazon CloudFront distributions and Application Load Balancers.
     * <p>
     * Match against the request's JA3 fingerprint. The JA3 fingerprint is a 32-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
     * <p>
     * <blockquote>
     * <p>
     * You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code> .
     * <p>
     * </blockquote>
     * <p>
     * You can obtain the JA3 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * Provide the JA3 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * JA3FingerprintProperty jA3FingerprintProperty = JA3FingerprintProperty.builder()
     *         .fallbackBehavior("fallbackBehavior")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja3fingerprint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja3fingerprint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.JA3FingerprintProperty")
    @software.amazon.jsii.Jsii.Proxy(JA3FingerprintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JA3FingerprintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The match status to assign to the web request if the request doesn't have a JA3 fingerprint.
         * <p>
         * You can specify the following fallback behaviors:
         * <p>
         * <ul>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja3fingerprint.html#cfn-wafv2-webacl-ja3fingerprint-fallbackbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja3fingerprint.html#cfn-wafv2-webacl-ja3fingerprint-fallbackbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFallbackBehavior();

        /**
         * @return a {@link Builder} of {@link JA3FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JA3FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JA3FingerprintProperty> {
            java.lang.String fallbackBehavior;

            /**
             * Sets the value of {@link JA3FingerprintProperty#getFallbackBehavior}
             * @param fallbackBehavior The match status to assign to the web request if the request doesn't have a JA3 fingerprint. This parameter is required.
             *                         You can specify the following fallback behaviors:
             *                         <p>
             *                         <ul>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fallbackBehavior(java.lang.String fallbackBehavior) {
                this.fallbackBehavior = fallbackBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JA3FingerprintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JA3FingerprintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JA3FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JA3FingerprintProperty {
            private final java.lang.String fallbackBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fallbackBehavior = software.amazon.jsii.Kernel.get(this, "fallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fallbackBehavior = java.util.Objects.requireNonNull(builder.fallbackBehavior, "fallbackBehavior is required");
            }

            @Override
            public final java.lang.String getFallbackBehavior() {
                return this.fallbackBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fallbackBehavior", om.valueToTree(this.getFallbackBehavior()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.JA3FingerprintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JA3FingerprintProperty.Jsii$Proxy that = (JA3FingerprintProperty.Jsii$Proxy) o;

                return this.fallbackBehavior.equals(that.fallbackBehavior);
            }

            @Override
            public final int hashCode() {
                int result = this.fallbackBehavior.hashCode();
                return result;
            }
        }
    }
    /**
     * Available for use with Amazon CloudFront distributions and Application Load Balancers.
     * <p>
     * Match against the request's JA4 fingerprint. The JA4 fingerprint is a 36-character hash derived from the TLS Client Hello of an incoming request. This fingerprint serves as a unique identifier for the client's TLS configuration. AWS WAF calculates and logs this fingerprint for each request that has enough TLS Client Hello information for the calculation. Almost all web requests include this information.
     * <p>
     * <blockquote>
     * <p>
     * You can use this choice only with a string match <code>ByteMatchStatement</code> with the <code>PositionalConstraint</code> set to <code>EXACTLY</code> .
     * <p>
     * </blockquote>
     * <p>
     * You can obtain the JA4 fingerprint for client requests from the web ACL logs. If AWS WAF is able to calculate the fingerprint, it includes it in the logs. For information about the logging fields, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/logging-fields.html">Log fields</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * Provide the JA4 fingerprint string from the logs in your string match statement specification, to match with any future requests that have the same TLS configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * JA4FingerprintProperty jA4FingerprintProperty = JA4FingerprintProperty.builder()
     *         .fallbackBehavior("fallbackBehavior")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja4fingerprint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja4fingerprint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.JA4FingerprintProperty")
    @software.amazon.jsii.Jsii.Proxy(JA4FingerprintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JA4FingerprintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The match status to assign to the web request if the request doesn't have a JA4 fingerprint.
         * <p>
         * You can specify the following fallback behaviors:
         * <p>
         * <ul>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja4fingerprint.html#cfn-wafv2-webacl-ja4fingerprint-fallbackbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ja4fingerprint.html#cfn-wafv2-webacl-ja4fingerprint-fallbackbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFallbackBehavior();

        /**
         * @return a {@link Builder} of {@link JA4FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JA4FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JA4FingerprintProperty> {
            java.lang.String fallbackBehavior;

            /**
             * Sets the value of {@link JA4FingerprintProperty#getFallbackBehavior}
             * @param fallbackBehavior The match status to assign to the web request if the request doesn't have a JA4 fingerprint. This parameter is required.
             *                         You can specify the following fallback behaviors:
             *                         <p>
             *                         <ul>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fallbackBehavior(java.lang.String fallbackBehavior) {
                this.fallbackBehavior = fallbackBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JA4FingerprintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JA4FingerprintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JA4FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JA4FingerprintProperty {
            private final java.lang.String fallbackBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fallbackBehavior = software.amazon.jsii.Kernel.get(this, "fallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fallbackBehavior = java.util.Objects.requireNonNull(builder.fallbackBehavior, "fallbackBehavior is required");
            }

            @Override
            public final java.lang.String getFallbackBehavior() {
                return this.fallbackBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fallbackBehavior", om.valueToTree(this.getFallbackBehavior()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.JA4FingerprintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JA4FingerprintProperty.Jsii$Proxy that = (JA4FingerprintProperty.Jsii$Proxy) o;

                return this.fallbackBehavior.equals(that.fallbackBehavior);
            }

            @Override
            public final int hashCode() {
                int result = this.fallbackBehavior.hashCode();
                return result;
            }
        }
    }
    /**
     * Inspect the body of the web request as JSON. The body immediately follows the request headers.
     * <p>
     * This is used to indicate the web request component to inspect, in the <code>FieldToMatch</code> specification.
     * <p>
     * Use the specifications in this object to indicate which parts of the JSON body to inspect using the rule's inspection criteria. AWS WAF inspects only the parts of the JSON that result from the matches that you indicate.
     * <p>
     * Example JSON: <code>"JsonBody": { "MatchPattern": { "All": {} }, "MatchScope": "ALL" }</code>
     * <p>
     * For additional information about this request component option, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body">JSON body</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * JsonBodyProperty jsonBodyProperty = JsonBodyProperty.builder()
     *         .matchPattern(JsonMatchPatternProperty.builder()
     *                 .all(all)
     *                 .includedPaths(List.of("includedPaths"))
     *                 .build())
     *         .matchScope("matchScope")
     *         // the properties below are optional
     *         .invalidFallbackBehavior("invalidFallbackBehavior")
     *         .oversizeHandling("oversizeHandling")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.JsonBodyProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonBodyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonBodyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The patterns to look for in the JSON body.
         * <p>
         * AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-matchpattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-matchpattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatchPattern();

        /**
         * The parts of the JSON to match against using the <code>MatchPattern</code> .
         * <p>
         * If you specify <code>ALL</code> , AWS WAF matches against keys and values.
         * <p>
         * <code>All</code> does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical <code>AND</code> statement to combine two match rules, one that inspects the keys and another that inspects the values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-matchscope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-matchscope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMatchScope();

        /**
         * What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.
         * <p>
         * <ul>
         * <li><code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.</li>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.
         * <p>
         * <blockquote>
         * <p>
         * AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body">JSON body</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-invalidfallbackbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-invalidfallbackbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInvalidFallbackBehavior() {
            return null;
        }

        /**
         * What AWS WAF should do if the body is larger than AWS WAF can inspect.
         * <p>
         * AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
         * <p>
         * <ul>
         * <li>For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).</li>
         * <li>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code> , for additional processing fees.</li>
         * <li>For AWS Amplify , use the CloudFront limit.</li>
         * </ul>
         * <p>
         * The options for oversize handling are the following:
         * <p>
         * <ul>
         * <li><code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection criteria.</li>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.
         * <p>
         * Default: <code>CONTINUE</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-oversizehandling">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonbody.html#cfn-wafv2-webacl-jsonbody-oversizehandling</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOversizeHandling() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JsonBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonBodyProperty> {
            java.lang.Object matchPattern;
            java.lang.String matchScope;
            java.lang.String invalidFallbackBehavior;
            java.lang.String oversizeHandling;

            /**
             * Sets the value of {@link JsonBodyProperty#getMatchPattern}
             * @param matchPattern The patterns to look for in the JSON body. This parameter is required.
             *                     AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.IResolvable matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getMatchPattern}
             * @param matchPattern The patterns to look for in the JSON body. This parameter is required.
             *                     AWS WAF inspects the results of these pattern matches against the rule inspection criteria.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchPattern(software.amazon.awscdk.services.wafv2.CfnWebACL.JsonMatchPatternProperty matchPattern) {
                this.matchPattern = matchPattern;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getMatchScope}
             * @param matchScope The parts of the JSON to match against using the <code>MatchPattern</code> . This parameter is required.
             *                   If you specify <code>ALL</code> , AWS WAF matches against keys and values.
             *                   <p>
             *                   <code>All</code> does not require a match to be found in the keys and a match to be found in the values. It requires a match to be found in the keys or the values or both. To require a match in the keys and in the values, use a logical <code>AND</code> statement to combine two match rules, one that inspects the keys and another that inspects the values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchScope(java.lang.String matchScope) {
                this.matchScope = matchScope;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getInvalidFallbackBehavior}
             * @param invalidFallbackBehavior What AWS WAF should do if it fails to completely parse the JSON body. The options are the following:.
             *                                <ul>
             *                                <li><code>EVALUATE_AS_STRING</code> - Inspect the body as plain text. AWS WAF applies the text transformations and inspection criteria that you defined for the JSON inspection to the body text string.</li>
             *                                <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                                <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                                </ul>
             *                                <p>
             *                                If you don't provide this setting, AWS WAF parses and evaluates the content only up to the first parsing failure that it encounters.
             *                                <p>
             *                                <blockquote>
             *                                <p>
             *                                AWS WAF parsing doesn't fully validate the input JSON string, so parsing can succeed even for invalid JSON. When parsing succeeds, AWS WAF doesn't apply the fallback behavior. For more information, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-fields-list.html#waf-rule-statement-request-component-json-body">JSON body</a> in the <em>AWS WAF Developer Guide</em> .
             *                                <p>
             *                                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invalidFallbackBehavior(java.lang.String invalidFallbackBehavior) {
                this.invalidFallbackBehavior = invalidFallbackBehavior;
                return this;
            }

            /**
             * Sets the value of {@link JsonBodyProperty#getOversizeHandling}
             * @param oversizeHandling What AWS WAF should do if the body is larger than AWS WAF can inspect.
             *                         AWS WAF does not support inspecting the entire contents of the web request body if the body exceeds the limit for the resource type. When a web request body is larger than the limit, the underlying host service only forwards the contents that are within the limit to AWS WAF for inspection.
             *                         <p>
             *                         <ul>
             *                         <li>For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).</li>
             *                         <li>For CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access, the default limit is 16 KB (16,384 bytes), and you can increase the limit for each resource type in the web ACL <code>AssociationConfig</code> , for additional processing fees.</li>
             *                         <li>For AWS Amplify , use the CloudFront limit.</li>
             *                         </ul>
             *                         <p>
             *                         The options for oversize handling are the following:
             *                         <p>
             *                         <ul>
             *                         <li><code>CONTINUE</code> - Inspect the available body contents normally, according to the rule inspection criteria.</li>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             *                         <p>
             *                         You can combine the <code>MATCH</code> or <code>NO_MATCH</code> settings for oversize handling with your rule and web ACL action settings, so that you block any request whose body is over the limit.
             *                         <p>
             *                         Default: <code>CONTINUE</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oversizeHandling(java.lang.String oversizeHandling) {
                this.oversizeHandling = oversizeHandling;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonBodyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonBodyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonBodyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonBodyProperty {
            private final java.lang.Object matchPattern;
            private final java.lang.String matchScope;
            private final java.lang.String invalidFallbackBehavior;
            private final java.lang.String oversizeHandling;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.matchPattern = software.amazon.jsii.Kernel.get(this, "matchPattern", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.matchScope = software.amazon.jsii.Kernel.get(this, "matchScope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invalidFallbackBehavior = software.amazon.jsii.Kernel.get(this, "invalidFallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.oversizeHandling = software.amazon.jsii.Kernel.get(this, "oversizeHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.matchPattern = java.util.Objects.requireNonNull(builder.matchPattern, "matchPattern is required");
                this.matchScope = java.util.Objects.requireNonNull(builder.matchScope, "matchScope is required");
                this.invalidFallbackBehavior = builder.invalidFallbackBehavior;
                this.oversizeHandling = builder.oversizeHandling;
            }

            @Override
            public final java.lang.Object getMatchPattern() {
                return this.matchPattern;
            }

            @Override
            public final java.lang.String getMatchScope() {
                return this.matchScope;
            }

            @Override
            public final java.lang.String getInvalidFallbackBehavior() {
                return this.invalidFallbackBehavior;
            }

            @Override
            public final java.lang.String getOversizeHandling() {
                return this.oversizeHandling;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("matchPattern", om.valueToTree(this.getMatchPattern()));
                data.set("matchScope", om.valueToTree(this.getMatchScope()));
                if (this.getInvalidFallbackBehavior() != null) {
                    data.set("invalidFallbackBehavior", om.valueToTree(this.getInvalidFallbackBehavior()));
                }
                if (this.getOversizeHandling() != null) {
                    data.set("oversizeHandling", om.valueToTree(this.getOversizeHandling()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.JsonBodyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonBodyProperty.Jsii$Proxy that = (JsonBodyProperty.Jsii$Proxy) o;

                if (!matchPattern.equals(that.matchPattern)) return false;
                if (!matchScope.equals(that.matchScope)) return false;
                if (this.invalidFallbackBehavior != null ? !this.invalidFallbackBehavior.equals(that.invalidFallbackBehavior) : that.invalidFallbackBehavior != null) return false;
                return this.oversizeHandling != null ? this.oversizeHandling.equals(that.oversizeHandling) : that.oversizeHandling == null;
            }

            @Override
            public final int hashCode() {
                int result = this.matchPattern.hashCode();
                result = 31 * result + (this.matchScope.hashCode());
                result = 31 * result + (this.invalidFallbackBehavior != null ? this.invalidFallbackBehavior.hashCode() : 0);
                result = 31 * result + (this.oversizeHandling != null ? this.oversizeHandling.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The patterns to look for in the JSON body.
     * <p>
     * AWS WAF inspects the results of these pattern matches against the rule inspection criteria. This is used with the <code>FieldToMatch</code> option <code>JsonBody</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * JsonMatchPatternProperty jsonMatchPatternProperty = JsonMatchPatternProperty.builder()
     *         .all(all)
     *         .includedPaths(List.of("includedPaths"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.JsonMatchPatternProperty")
    @software.amazon.jsii.Jsii.Proxy(JsonMatchPatternProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JsonMatchPatternProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Match all of the elements. See also <code>MatchScope</code> in the <code>JsonBody</code> <code>FieldToMatch</code> specification.
         * <p>
         * You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html#cfn-wafv2-webacl-jsonmatchpattern-all">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html#cfn-wafv2-webacl-jsonmatchpattern-all</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAll() {
            return null;
        }

        /**
         * Match only the specified include paths. See also <code>MatchScope</code> in the <code>JsonBody</code> <code>FieldToMatch</code> specification.
         * <p>
         * Provide the include paths using JSON Pointer syntax. For example, <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code> . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .
         * <p>
         * You must specify either this setting or the <code>All</code> setting, but not both.
         * <p>
         * <blockquote>
         * <p>
         * Don't use this option to include all paths. Instead, use the <code>All</code> setting.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html#cfn-wafv2-webacl-jsonmatchpattern-includedpaths">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-jsonmatchpattern.html#cfn-wafv2-webacl-jsonmatchpattern-includedpaths</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludedPaths() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JsonMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JsonMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JsonMatchPatternProperty> {
            java.lang.Object all;
            java.util.List<java.lang.String> includedPaths;

            /**
             * Sets the value of {@link JsonMatchPatternProperty#getAll}
             * @param all Match all of the elements. See also <code>MatchScope</code> in the <code>JsonBody</code> <code>FieldToMatch</code> specification.
             *            You must specify either this setting or the <code>IncludedPaths</code> setting, but not both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder all(java.lang.Object all) {
                this.all = all;
                return this;
            }

            /**
             * Sets the value of {@link JsonMatchPatternProperty#getIncludedPaths}
             * @param includedPaths Match only the specified include paths. See also <code>MatchScope</code> in the <code>JsonBody</code> <code>FieldToMatch</code> specification.
             *                      Provide the include paths using JSON Pointer syntax. For example, <code>"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]</code> . For information about this syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .
             *                      <p>
             *                      You must specify either this setting or the <code>All</code> setting, but not both.
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      Don't use this option to include all paths. Instead, use the <code>All</code> setting.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includedPaths(java.util.List<java.lang.String> includedPaths) {
                this.includedPaths = includedPaths;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JsonMatchPatternProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JsonMatchPatternProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JsonMatchPatternProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JsonMatchPatternProperty {
            private final java.lang.Object all;
            private final java.util.List<java.lang.String> includedPaths;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.all = software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includedPaths = software.amazon.jsii.Kernel.get(this, "includedPaths", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.all = builder.all;
                this.includedPaths = builder.includedPaths;
            }

            @Override
            public final java.lang.Object getAll() {
                return this.all;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludedPaths() {
                return this.includedPaths;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAll() != null) {
                    data.set("all", om.valueToTree(this.getAll()));
                }
                if (this.getIncludedPaths() != null) {
                    data.set("includedPaths", om.valueToTree(this.getIncludedPaths()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.JsonMatchPatternProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JsonMatchPatternProperty.Jsii$Proxy that = (JsonMatchPatternProperty.Jsii$Proxy) o;

                if (this.all != null ? !this.all.equals(that.all) : that.all != null) return false;
                return this.includedPaths != null ? this.includedPaths.equals(that.includedPaths) : that.includedPaths == null;
            }

            @Override
            public final int hashCode() {
                int result = this.all != null ? this.all.hashCode() : 0;
                result = 31 * result + (this.includedPaths != null ? this.includedPaths.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A rule statement to match against labels that have been added to the web request by rules that have already run in the web ACL.
     * <p>
     * The label match statement provides the label or namespace string to search for. The label string can represent a part or all of the fully qualified label name that had been added to the web request. Fully qualified labels have a prefix, optional namespaces, and label name. The prefix identifies the rule group or web ACL context of the rule that added the label. If you do not provide the fully qualified name in your label match string, AWS WAF performs the search for labels that were added in the same context as the label match statement.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * LabelMatchStatementProperty labelMatchStatementProperty = LabelMatchStatementProperty.builder()
     *         .key("key")
     *         .scope("scope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.LabelMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(LabelMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LabelMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The string to match against. The setting you provide for this depends on the match statement's <code>Scope</code> setting:.
         * <p>
         * <ul>
         * <li>If the <code>Scope</code> indicates <code>LABEL</code> , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.</li>
         * <li>If the <code>Scope</code> indicates <code>NAMESPACE</code> , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.</li>
         * </ul>
         * <p>
         * Labels are case sensitive and components of a label must be separated by colon, for example <code>NS1:NS2:name</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html#cfn-wafv2-webacl-labelmatchstatement-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html#cfn-wafv2-webacl-labelmatchstatement-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * Specify whether you want to match using the label name or just the namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html#cfn-wafv2-webacl-labelmatchstatement-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-labelmatchstatement.html#cfn-wafv2-webacl-labelmatchstatement-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScope();

        /**
         * @return a {@link Builder} of {@link LabelMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LabelMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LabelMatchStatementProperty> {
            java.lang.String key;
            java.lang.String scope;

            /**
             * Sets the value of {@link LabelMatchStatementProperty#getKey}
             * @param key The string to match against. The setting you provide for this depends on the match statement's <code>Scope</code> setting:. This parameter is required.
             *            <ul>
             *            <li>If the <code>Scope</code> indicates <code>LABEL</code> , then this specification must include the name and can include any number of preceding namespace specifications and prefix up to providing the fully qualified label name.</li>
             *            <li>If the <code>Scope</code> indicates <code>NAMESPACE</code> , then this specification can include any number of contiguous namespace strings, and can include the entire label namespace prefix from the rule group or web ACL where the label originates.</li>
             *            </ul>
             *            <p>
             *            Labels are case sensitive and components of a label must be separated by colon, for example <code>NS1:NS2:name</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link LabelMatchStatementProperty#getScope}
             * @param scope Specify whether you want to match using the label name or just the namespace. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LabelMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LabelMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LabelMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LabelMatchStatementProperty {
            private final java.lang.String key;
            private final java.lang.String scope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("scope", om.valueToTree(this.getScope()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.LabelMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LabelMatchStatementProperty.Jsii$Proxy that = (LabelMatchStatementProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.scope.equals(that.scope);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.scope.hashCode());
                return result;
            }
        }
    }
    /**
     * A single label container.
     * <p>
     * This is used as an element of a label array in <code>RuleLabels</code> inside a rule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * LabelProperty labelProperty = LabelProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-label.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-label.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.LabelProperty")
    @software.amazon.jsii.Jsii.Proxy(LabelProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LabelProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The label string.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-label.html#cfn-wafv2-webacl-label-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-label.html#cfn-wafv2-webacl-label-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LabelProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link LabelProperty#getName}
             * @param name The label string. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LabelProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LabelProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LabelProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LabelProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.LabelProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LabelProperty.Jsii$Proxy that = (LabelProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * Additional information that's used by a managed rule group. Many managed rule groups don't require this.
     * <p>
     * The rule groups used for intelligent threat mitigation require additional configuration:
     * <p>
     * <ul>
     * <li>Use the <code>AWSManagedRulesACFPRuleSet</code> configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields.</li>
     * <li>Use the <code>AWSManagedRulesATPRuleSet</code> configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password.</li>
     * <li>Use the <code>AWSManagedRulesBotControlRuleSet</code> configuration object to configure the protection level that you want the Bot Control rule group to use.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ManagedRuleGroupConfigProperty managedRuleGroupConfigProperty = ManagedRuleGroupConfigProperty.builder()
     *         .awsManagedRulesAcfpRuleSet(AWSManagedRulesACFPRuleSetProperty.builder()
     *                 .creationPath("creationPath")
     *                 .registrationPagePath("registrationPagePath")
     *                 .requestInspection(RequestInspectionACFPProperty.builder()
     *                         .payloadType("payloadType")
     *                         // the properties below are optional
     *                         .addressFields(List.of(FieldIdentifierProperty.builder()
     *                                 .identifier("identifier")
     *                                 .build()))
     *                         .emailField(FieldIdentifierProperty.builder()
     *                                 .identifier("identifier")
     *                                 .build())
     *                         .passwordField(FieldIdentifierProperty.builder()
     *                                 .identifier("identifier")
     *                                 .build())
     *                         .phoneNumberFields(List.of(FieldIdentifierProperty.builder()
     *                                 .identifier("identifier")
     *                                 .build()))
     *                         .usernameField(FieldIdentifierProperty.builder()
     *                                 .identifier("identifier")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .enableRegexInPath(false)
     *                 .responseInspection(ResponseInspectionProperty.builder()
     *                         .bodyContains(ResponseInspectionBodyContainsProperty.builder()
     *                                 .failureStrings(List.of("failureStrings"))
     *                                 .successStrings(List.of("successStrings"))
     *                                 .build())
     *                         .header(ResponseInspectionHeaderProperty.builder()
     *                                 .failureValues(List.of("failureValues"))
     *                                 .name("name")
     *                                 .successValues(List.of("successValues"))
     *                                 .build())
     *                         .json(ResponseInspectionJsonProperty.builder()
     *                                 .failureValues(List.of("failureValues"))
     *                                 .identifier("identifier")
     *                                 .successValues(List.of("successValues"))
     *                                 .build())
     *                         .statusCode(ResponseInspectionStatusCodeProperty.builder()
     *                                 .failureCodes(List.of(123))
     *                                 .successCodes(List.of(123))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .awsManagedRulesAntiDDoSRuleSet(AWSManagedRulesAntiDDoSRuleSetProperty.builder()
     *                 .clientSideActionConfig(ClientSideActionConfigProperty.builder()
     *                         .challenge(ClientSideActionProperty.builder()
     *                                 .usageOfAction("usageOfAction")
     *                                 // the properties below are optional
     *                                 .exemptUriRegularExpressions(List.of(RegexProperty.builder()
     *                                         .regexString("regexString")
     *                                         .build()))
     *                                 .sensitivity("sensitivity")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .sensitivityToBlock("sensitivityToBlock")
     *                 .build())
     *         .awsManagedRulesAtpRuleSet(AWSManagedRulesATPRuleSetProperty.builder()
     *                 .loginPath("loginPath")
     *                 // the properties below are optional
     *                 .enableRegexInPath(false)
     *                 .requestInspection(RequestInspectionProperty.builder()
     *                         .passwordField(FieldIdentifierProperty.builder()
     *                                 .identifier("identifier")
     *                                 .build())
     *                         .payloadType("payloadType")
     *                         .usernameField(FieldIdentifierProperty.builder()
     *                                 .identifier("identifier")
     *                                 .build())
     *                         .build())
     *                 .responseInspection(ResponseInspectionProperty.builder()
     *                         .bodyContains(ResponseInspectionBodyContainsProperty.builder()
     *                                 .failureStrings(List.of("failureStrings"))
     *                                 .successStrings(List.of("successStrings"))
     *                                 .build())
     *                         .header(ResponseInspectionHeaderProperty.builder()
     *                                 .failureValues(List.of("failureValues"))
     *                                 .name("name")
     *                                 .successValues(List.of("successValues"))
     *                                 .build())
     *                         .json(ResponseInspectionJsonProperty.builder()
     *                                 .failureValues(List.of("failureValues"))
     *                                 .identifier("identifier")
     *                                 .successValues(List.of("successValues"))
     *                                 .build())
     *                         .statusCode(ResponseInspectionStatusCodeProperty.builder()
     *                                 .failureCodes(List.of(123))
     *                                 .successCodes(List.of(123))
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .awsManagedRulesBotControlRuleSet(AWSManagedRulesBotControlRuleSetProperty.builder()
     *                 .inspectionLevel("inspectionLevel")
     *                 // the properties below are optional
     *                 .enableMachineLearning(false)
     *                 .build())
     *         .loginPath("loginPath")
     *         .passwordField(FieldIdentifierProperty.builder()
     *                 .identifier("identifier")
     *                 .build())
     *         .payloadType("payloadType")
     *         .usernameField(FieldIdentifierProperty.builder()
     *                 .identifier("identifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ManagedRuleGroupConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedRuleGroupConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedRuleGroupConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Additional configuration for using the account creation fraud prevention (ACFP) managed rule group, <code>AWSManagedRulesACFPRuleSet</code> .
         * <p>
         * Use this to provide account creation request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to account creation requests.
         * <p>
         * For information about using the ACFP managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-acfp.html">AWS WAF Fraud Control account creation fraud prevention (ACFP) rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-acfp.html">AWS WAF Fraud Control account creation fraud prevention (ACFP)</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesacfpruleset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesacfpruleset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsManagedRulesAcfpRuleSet() {
            return null;
        }

        /**
         * Additional configuration for using the anti-DDoS managed rule group, <code>AWSManagedRulesAntiDDoSRuleSet</code> .
         * <p>
         * Use this to configure anti-DDoS behavior for the rule group.
         * <p>
         * For information about using the anti-DDoS managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-anti-ddos.html">AWS WAF Anti-DDoS rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-anti-ddos.html">Distributed Denial of Service (DDoS) prevention</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesantiddosruleset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesantiddosruleset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsManagedRulesAntiDDoSRuleSet() {
            return null;
        }

        /**
         * Additional configuration for using the account takeover prevention (ATP) managed rule group, <code>AWSManagedRulesATPRuleSet</code> .
         * <p>
         * Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests.
         * <p>
         * This configuration replaces the individual configuration fields in <code>ManagedRuleGroupConfig</code> and provides additional feature configuration.
         * <p>
         * For information about using the ATP managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html">AWS WAF Fraud Control account takeover prevention (ATP) rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html">AWS WAF Fraud Control account takeover prevention (ATP)</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesatpruleset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesatpruleset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsManagedRulesAtpRuleSet() {
            return null;
        }

        /**
         * Additional configuration for using the Bot Control managed rule group.
         * <p>
         * Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">AWS WAF Bot Control rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html">AWS WAF Bot Control</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesbotcontrolruleset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-awsmanagedrulesbotcontrolruleset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsManagedRulesBotControlRuleSet() {
            return null;
        }

        /**
         * <blockquote><p>Instead of this setting, provide your configuration under <code>AWSManagedRulesATPRuleSet</code> .<p></blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-loginpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-loginpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoginPath() {
            return null;
        }

        /**
         * <blockquote><p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code> .<p></blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-passwordfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-passwordfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPasswordField() {
            return null;
        }

        /**
         * <blockquote><p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code> .<p></blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-payloadtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-payloadtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayloadType() {
            return null;
        }

        /**
         * <blockquote><p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code> .<p></blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-usernamefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupconfig.html#cfn-wafv2-webacl-managedrulegroupconfig-usernamefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUsernameField() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedRuleGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedRuleGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedRuleGroupConfigProperty> {
            java.lang.Object awsManagedRulesAcfpRuleSet;
            java.lang.Object awsManagedRulesAntiDDoSRuleSet;
            java.lang.Object awsManagedRulesAtpRuleSet;
            java.lang.Object awsManagedRulesBotControlRuleSet;
            java.lang.String loginPath;
            java.lang.Object passwordField;
            java.lang.String payloadType;
            java.lang.Object usernameField;

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getAwsManagedRulesAcfpRuleSet}
             * @param awsManagedRulesAcfpRuleSet Additional configuration for using the account creation fraud prevention (ACFP) managed rule group, <code>AWSManagedRulesACFPRuleSet</code> .
             *                                   Use this to provide account creation request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to account creation requests.
             *                                   <p>
             *                                   For information about using the ACFP managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-acfp.html">AWS WAF Fraud Control account creation fraud prevention (ACFP) rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-acfp.html">AWS WAF Fraud Control account creation fraud prevention (ACFP)</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsManagedRulesAcfpRuleSet(software.amazon.awscdk.IResolvable awsManagedRulesAcfpRuleSet) {
                this.awsManagedRulesAcfpRuleSet = awsManagedRulesAcfpRuleSet;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getAwsManagedRulesAcfpRuleSet}
             * @param awsManagedRulesAcfpRuleSet Additional configuration for using the account creation fraud prevention (ACFP) managed rule group, <code>AWSManagedRulesACFPRuleSet</code> .
             *                                   Use this to provide account creation request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to account creation requests.
             *                                   <p>
             *                                   For information about using the ACFP managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-acfp.html">AWS WAF Fraud Control account creation fraud prevention (ACFP) rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-acfp.html">AWS WAF Fraud Control account creation fraud prevention (ACFP)</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsManagedRulesAcfpRuleSet(software.amazon.awscdk.services.wafv2.CfnWebACL.AWSManagedRulesACFPRuleSetProperty awsManagedRulesAcfpRuleSet) {
                this.awsManagedRulesAcfpRuleSet = awsManagedRulesAcfpRuleSet;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getAwsManagedRulesAntiDDoSRuleSet}
             * @param awsManagedRulesAntiDDoSRuleSet Additional configuration for using the anti-DDoS managed rule group, <code>AWSManagedRulesAntiDDoSRuleSet</code> .
             *                                       Use this to configure anti-DDoS behavior for the rule group.
             *                                       <p>
             *                                       For information about using the anti-DDoS managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-anti-ddos.html">AWS WAF Anti-DDoS rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-anti-ddos.html">Distributed Denial of Service (DDoS) prevention</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsManagedRulesAntiDDoSRuleSet(software.amazon.awscdk.IResolvable awsManagedRulesAntiDDoSRuleSet) {
                this.awsManagedRulesAntiDDoSRuleSet = awsManagedRulesAntiDDoSRuleSet;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getAwsManagedRulesAntiDDoSRuleSet}
             * @param awsManagedRulesAntiDDoSRuleSet Additional configuration for using the anti-DDoS managed rule group, <code>AWSManagedRulesAntiDDoSRuleSet</code> .
             *                                       Use this to configure anti-DDoS behavior for the rule group.
             *                                       <p>
             *                                       For information about using the anti-DDoS managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-anti-ddos.html">AWS WAF Anti-DDoS rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-anti-ddos.html">Distributed Denial of Service (DDoS) prevention</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsManagedRulesAntiDDoSRuleSet(software.amazon.awscdk.services.wafv2.CfnWebACL.AWSManagedRulesAntiDDoSRuleSetProperty awsManagedRulesAntiDDoSRuleSet) {
                this.awsManagedRulesAntiDDoSRuleSet = awsManagedRulesAntiDDoSRuleSet;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getAwsManagedRulesAtpRuleSet}
             * @param awsManagedRulesAtpRuleSet Additional configuration for using the account takeover prevention (ATP) managed rule group, <code>AWSManagedRulesATPRuleSet</code> .
             *                                  Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests.
             *                                  <p>
             *                                  This configuration replaces the individual configuration fields in <code>ManagedRuleGroupConfig</code> and provides additional feature configuration.
             *                                  <p>
             *                                  For information about using the ATP managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html">AWS WAF Fraud Control account takeover prevention (ATP) rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html">AWS WAF Fraud Control account takeover prevention (ATP)</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsManagedRulesAtpRuleSet(software.amazon.awscdk.IResolvable awsManagedRulesAtpRuleSet) {
                this.awsManagedRulesAtpRuleSet = awsManagedRulesAtpRuleSet;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getAwsManagedRulesAtpRuleSet}
             * @param awsManagedRulesAtpRuleSet Additional configuration for using the account takeover prevention (ATP) managed rule group, <code>AWSManagedRulesATPRuleSet</code> .
             *                                  Use this to provide login request information to the rule group. For web ACLs that protect CloudFront distributions, use this to also provide the information about how your distribution responds to login requests.
             *                                  <p>
             *                                  This configuration replaces the individual configuration fields in <code>ManagedRuleGroupConfig</code> and provides additional feature configuration.
             *                                  <p>
             *                                  For information about using the ATP managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-atp.html">AWS WAF Fraud Control account takeover prevention (ATP) rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-atp.html">AWS WAF Fraud Control account takeover prevention (ATP)</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsManagedRulesAtpRuleSet(software.amazon.awscdk.services.wafv2.CfnWebACL.AWSManagedRulesATPRuleSetProperty awsManagedRulesAtpRuleSet) {
                this.awsManagedRulesAtpRuleSet = awsManagedRulesAtpRuleSet;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getAwsManagedRulesBotControlRuleSet}
             * @param awsManagedRulesBotControlRuleSet Additional configuration for using the Bot Control managed rule group.
             *                                         Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">AWS WAF Bot Control rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html">AWS WAF Bot Control</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsManagedRulesBotControlRuleSet(software.amazon.awscdk.IResolvable awsManagedRulesBotControlRuleSet) {
                this.awsManagedRulesBotControlRuleSet = awsManagedRulesBotControlRuleSet;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getAwsManagedRulesBotControlRuleSet}
             * @param awsManagedRulesBotControlRuleSet Additional configuration for using the Bot Control managed rule group.
             *                                         Use this to specify the inspection level that you want to use. For information about using the Bot Control managed rule group, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-bot.html">AWS WAF Bot Control rule group</a> and <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-bot-control.html">AWS WAF Bot Control</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsManagedRulesBotControlRuleSet(software.amazon.awscdk.services.wafv2.CfnWebACL.AWSManagedRulesBotControlRuleSetProperty awsManagedRulesBotControlRuleSet) {
                this.awsManagedRulesBotControlRuleSet = awsManagedRulesBotControlRuleSet;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getLoginPath}
             * @param loginPath <blockquote><p>Instead of this setting, provide your configuration under <code>AWSManagedRulesATPRuleSet</code> .<p></blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loginPath(java.lang.String loginPath) {
                this.loginPath = loginPath;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getPasswordField}
             * @param passwordField <blockquote><p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code> .<p></blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passwordField(software.amazon.awscdk.IResolvable passwordField) {
                this.passwordField = passwordField;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getPasswordField}
             * @param passwordField <blockquote><p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code> .<p></blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passwordField(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldIdentifierProperty passwordField) {
                this.passwordField = passwordField;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getPayloadType}
             * @param payloadType <blockquote><p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code> .<p></blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadType(java.lang.String payloadType) {
                this.payloadType = payloadType;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getUsernameField}
             * @param usernameField <blockquote><p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code> .<p></blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernameField(software.amazon.awscdk.IResolvable usernameField) {
                this.usernameField = usernameField;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupConfigProperty#getUsernameField}
             * @param usernameField <blockquote><p>Instead of this setting, provide your configuration under the request inspection configuration for <code>AWSManagedRulesATPRuleSet</code> or <code>AWSManagedRulesACFPRuleSet</code> .<p></blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernameField(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldIdentifierProperty usernameField) {
                this.usernameField = usernameField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedRuleGroupConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedRuleGroupConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedRuleGroupConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedRuleGroupConfigProperty {
            private final java.lang.Object awsManagedRulesAcfpRuleSet;
            private final java.lang.Object awsManagedRulesAntiDDoSRuleSet;
            private final java.lang.Object awsManagedRulesAtpRuleSet;
            private final java.lang.Object awsManagedRulesBotControlRuleSet;
            private final java.lang.String loginPath;
            private final java.lang.Object passwordField;
            private final java.lang.String payloadType;
            private final java.lang.Object usernameField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsManagedRulesAcfpRuleSet = software.amazon.jsii.Kernel.get(this, "awsManagedRulesAcfpRuleSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awsManagedRulesAntiDDoSRuleSet = software.amazon.jsii.Kernel.get(this, "awsManagedRulesAntiDDoSRuleSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awsManagedRulesAtpRuleSet = software.amazon.jsii.Kernel.get(this, "awsManagedRulesAtpRuleSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awsManagedRulesBotControlRuleSet = software.amazon.jsii.Kernel.get(this, "awsManagedRulesBotControlRuleSet", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loginPath = software.amazon.jsii.Kernel.get(this, "loginPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.passwordField = software.amazon.jsii.Kernel.get(this, "passwordField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.payloadType = software.amazon.jsii.Kernel.get(this, "payloadType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.usernameField = software.amazon.jsii.Kernel.get(this, "usernameField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsManagedRulesAcfpRuleSet = builder.awsManagedRulesAcfpRuleSet;
                this.awsManagedRulesAntiDDoSRuleSet = builder.awsManagedRulesAntiDDoSRuleSet;
                this.awsManagedRulesAtpRuleSet = builder.awsManagedRulesAtpRuleSet;
                this.awsManagedRulesBotControlRuleSet = builder.awsManagedRulesBotControlRuleSet;
                this.loginPath = builder.loginPath;
                this.passwordField = builder.passwordField;
                this.payloadType = builder.payloadType;
                this.usernameField = builder.usernameField;
            }

            @Override
            public final java.lang.Object getAwsManagedRulesAcfpRuleSet() {
                return this.awsManagedRulesAcfpRuleSet;
            }

            @Override
            public final java.lang.Object getAwsManagedRulesAntiDDoSRuleSet() {
                return this.awsManagedRulesAntiDDoSRuleSet;
            }

            @Override
            public final java.lang.Object getAwsManagedRulesAtpRuleSet() {
                return this.awsManagedRulesAtpRuleSet;
            }

            @Override
            public final java.lang.Object getAwsManagedRulesBotControlRuleSet() {
                return this.awsManagedRulesBotControlRuleSet;
            }

            @Override
            public final java.lang.String getLoginPath() {
                return this.loginPath;
            }

            @Override
            public final java.lang.Object getPasswordField() {
                return this.passwordField;
            }

            @Override
            public final java.lang.String getPayloadType() {
                return this.payloadType;
            }

            @Override
            public final java.lang.Object getUsernameField() {
                return this.usernameField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsManagedRulesAcfpRuleSet() != null) {
                    data.set("awsManagedRulesAcfpRuleSet", om.valueToTree(this.getAwsManagedRulesAcfpRuleSet()));
                }
                if (this.getAwsManagedRulesAntiDDoSRuleSet() != null) {
                    data.set("awsManagedRulesAntiDDoSRuleSet", om.valueToTree(this.getAwsManagedRulesAntiDDoSRuleSet()));
                }
                if (this.getAwsManagedRulesAtpRuleSet() != null) {
                    data.set("awsManagedRulesAtpRuleSet", om.valueToTree(this.getAwsManagedRulesAtpRuleSet()));
                }
                if (this.getAwsManagedRulesBotControlRuleSet() != null) {
                    data.set("awsManagedRulesBotControlRuleSet", om.valueToTree(this.getAwsManagedRulesBotControlRuleSet()));
                }
                if (this.getLoginPath() != null) {
                    data.set("loginPath", om.valueToTree(this.getLoginPath()));
                }
                if (this.getPasswordField() != null) {
                    data.set("passwordField", om.valueToTree(this.getPasswordField()));
                }
                if (this.getPayloadType() != null) {
                    data.set("payloadType", om.valueToTree(this.getPayloadType()));
                }
                if (this.getUsernameField() != null) {
                    data.set("usernameField", om.valueToTree(this.getUsernameField()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ManagedRuleGroupConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedRuleGroupConfigProperty.Jsii$Proxy that = (ManagedRuleGroupConfigProperty.Jsii$Proxy) o;

                if (this.awsManagedRulesAcfpRuleSet != null ? !this.awsManagedRulesAcfpRuleSet.equals(that.awsManagedRulesAcfpRuleSet) : that.awsManagedRulesAcfpRuleSet != null) return false;
                if (this.awsManagedRulesAntiDDoSRuleSet != null ? !this.awsManagedRulesAntiDDoSRuleSet.equals(that.awsManagedRulesAntiDDoSRuleSet) : that.awsManagedRulesAntiDDoSRuleSet != null) return false;
                if (this.awsManagedRulesAtpRuleSet != null ? !this.awsManagedRulesAtpRuleSet.equals(that.awsManagedRulesAtpRuleSet) : that.awsManagedRulesAtpRuleSet != null) return false;
                if (this.awsManagedRulesBotControlRuleSet != null ? !this.awsManagedRulesBotControlRuleSet.equals(that.awsManagedRulesBotControlRuleSet) : that.awsManagedRulesBotControlRuleSet != null) return false;
                if (this.loginPath != null ? !this.loginPath.equals(that.loginPath) : that.loginPath != null) return false;
                if (this.passwordField != null ? !this.passwordField.equals(that.passwordField) : that.passwordField != null) return false;
                if (this.payloadType != null ? !this.payloadType.equals(that.payloadType) : that.payloadType != null) return false;
                return this.usernameField != null ? this.usernameField.equals(that.usernameField) : that.usernameField == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsManagedRulesAcfpRuleSet != null ? this.awsManagedRulesAcfpRuleSet.hashCode() : 0;
                result = 31 * result + (this.awsManagedRulesAntiDDoSRuleSet != null ? this.awsManagedRulesAntiDDoSRuleSet.hashCode() : 0);
                result = 31 * result + (this.awsManagedRulesAtpRuleSet != null ? this.awsManagedRulesAtpRuleSet.hashCode() : 0);
                result = 31 * result + (this.awsManagedRulesBotControlRuleSet != null ? this.awsManagedRulesBotControlRuleSet.hashCode() : 0);
                result = 31 * result + (this.loginPath != null ? this.loginPath.hashCode() : 0);
                result = 31 * result + (this.passwordField != null ? this.passwordField.hashCode() : 0);
                result = 31 * result + (this.payloadType != null ? this.payloadType.hashCode() : 0);
                result = 31 * result + (this.usernameField != null ? this.usernameField.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A rule statement used to run the rules that are defined in a managed rule group.
     * <p>
     * To use this, provide the vendor name and the name of the rule group in this statement. You can retrieve the required names through the API call <code>ListAvailableManagedRuleGroups</code> .
     * <p>
     * You cannot nest a <code>ManagedRuleGroupStatement</code> , for example for use inside a <code>NotStatement</code> or <code>OrStatement</code> . You cannot use a managed rule group statement inside another rule group. You can only use a managed rule group statement as a top-level statement in a rule that you define in a web ACL.
     * <p>
     * <blockquote>
     * <p>
     * You are charged additional fees when you use the AWS WAF Bot Control managed rule group <code>AWSManagedRulesBotControlRuleSet</code> , the AWS WAF Fraud Control account takeover prevention (ATP) managed rule group <code>AWSManagedRulesATPRuleSet</code> , or the AWS WAF Fraud Control account creation fraud prevention (ACFP) managed rule group <code>AWSManagedRulesACFPRuleSet</code> . For more information, see <a href="https://docs.aws.amazon.com/waf/pricing/">AWS WAF Pricing</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ManagedRuleGroupStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(ManagedRuleGroupStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManagedRuleGroupStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the managed rule group.
         * <p>
         * You use this, along with the vendor name, to identify the rule group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The name of the managed rule group vendor.
         * <p>
         * You use this, along with the rule group name, to identify a rule group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-vendorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-vendorname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVendorName();

        /**
         * Rules in the referenced rule group whose actions are set to <code>Count</code> .
         * <p>
         * <blockquote>
         * <p>
         * Instead of this option, use <code>RuleActionOverrides</code> . It accepts any valid action setting, including <code>Count</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-excludedrules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-excludedrules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExcludedRules() {
            return null;
        }

        /**
         * Additional information that's used by a managed rule group. Many managed rule groups don't require this.
         * <p>
         * The rule groups used for intelligent threat mitigation require additional configuration:
         * <p>
         * <ul>
         * <li>Use the <code>AWSManagedRulesACFPRuleSet</code> configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields.</li>
         * <li>Use the <code>AWSManagedRulesAntiDDoSRuleSet</code> configuration object to configure the anti-DDoS managed rule group. The configuration includes the sensitivity levels to use in the rules that typically block and challenge requests that might be participating in DDoS attacks and the specification to use to indicate whether a request can handle a silent browser challenge.</li>
         * <li>Use the <code>AWSManagedRulesATPRuleSet</code> configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password.</li>
         * <li>Use the <code>AWSManagedRulesBotControlRuleSet</code> configuration object to configure the protection level that you want the Bot Control rule group to use.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-managedrulegroupconfigs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-managedrulegroupconfigs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedRuleGroupConfigs() {
            return null;
        }

        /**
         * Action settings to use in the place of the rule actions that are configured inside the rule group.
         * <p>
         * You specify one override for each rule whose action you want to change.
         * <p>
         * <blockquote>
         * <p>
         * Verify the rule names in your overrides carefully. With managed rule groups, AWS WAF silently ignores any override that uses an invalid rule name. With customer-owned rule groups, invalid rule names in your overrides will cause web ACL updates to fail. An invalid rule name is any name that doesn't exactly match the case-sensitive name of an existing rule in the rule group.
         * <p>
         * </blockquote>
         * <p>
         * You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-ruleactionoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-ruleactionoverrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuleActionOverrides() {
            return null;
        }

        /**
         * An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group.
         * <p>
         * Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable <code>Statement</code> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-scopedownstatement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-scopedownstatement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScopeDownStatement() {
            return null;
        }

        /**
         * The version of the managed rule group to use.
         * <p>
         * If you specify this, the version setting is fixed until you change it. If you don't specify this, AWS WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-managedrulegroupstatement.html#cfn-wafv2-webacl-managedrulegroupstatement-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManagedRuleGroupStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManagedRuleGroupStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManagedRuleGroupStatementProperty> {
            java.lang.String name;
            java.lang.String vendorName;
            java.lang.Object excludedRules;
            java.lang.Object managedRuleGroupConfigs;
            java.lang.Object ruleActionOverrides;
            java.lang.Object scopeDownStatement;
            java.lang.String version;

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getName}
             * @param name The name of the managed rule group. This parameter is required.
             *             You use this, along with the vendor name, to identify the rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getVendorName}
             * @param vendorName The name of the managed rule group vendor. This parameter is required.
             *                   You use this, along with the rule group name, to identify a rule group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vendorName(java.lang.String vendorName) {
                this.vendorName = vendorName;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getExcludedRules}
             * @param excludedRules Rules in the referenced rule group whose actions are set to <code>Count</code> .
             *                      <blockquote>
             *                      <p>
             *                      Instead of this option, use <code>RuleActionOverrides</code> . It accepts any valid action setting, including <code>Count</code> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedRules(software.amazon.awscdk.IResolvable excludedRules) {
                this.excludedRules = excludedRules;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getExcludedRules}
             * @param excludedRules Rules in the referenced rule group whose actions are set to <code>Count</code> .
             *                      <blockquote>
             *                      <p>
             *                      Instead of this option, use <code>RuleActionOverrides</code> . It accepts any valid action setting, including <code>Count</code> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludedRules(java.util.List<? extends java.lang.Object> excludedRules) {
                this.excludedRules = excludedRules;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getManagedRuleGroupConfigs}
             * @param managedRuleGroupConfigs Additional information that's used by a managed rule group. Many managed rule groups don't require this.
             *                                The rule groups used for intelligent threat mitigation require additional configuration:
             *                                <p>
             *                                <ul>
             *                                <li>Use the <code>AWSManagedRulesACFPRuleSet</code> configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields.</li>
             *                                <li>Use the <code>AWSManagedRulesAntiDDoSRuleSet</code> configuration object to configure the anti-DDoS managed rule group. The configuration includes the sensitivity levels to use in the rules that typically block and challenge requests that might be participating in DDoS attacks and the specification to use to indicate whether a request can handle a silent browser challenge.</li>
             *                                <li>Use the <code>AWSManagedRulesATPRuleSet</code> configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password.</li>
             *                                <li>Use the <code>AWSManagedRulesBotControlRuleSet</code> configuration object to configure the protection level that you want the Bot Control rule group to use.</li>
             *                                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedRuleGroupConfigs(software.amazon.awscdk.IResolvable managedRuleGroupConfigs) {
                this.managedRuleGroupConfigs = managedRuleGroupConfigs;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getManagedRuleGroupConfigs}
             * @param managedRuleGroupConfigs Additional information that's used by a managed rule group. Many managed rule groups don't require this.
             *                                The rule groups used for intelligent threat mitigation require additional configuration:
             *                                <p>
             *                                <ul>
             *                                <li>Use the <code>AWSManagedRulesACFPRuleSet</code> configuration object to configure the account creation fraud prevention managed rule group. The configuration includes the registration and sign-up pages of your application and the locations in the account creation request payload of data, such as the user email and phone number fields.</li>
             *                                <li>Use the <code>AWSManagedRulesAntiDDoSRuleSet</code> configuration object to configure the anti-DDoS managed rule group. The configuration includes the sensitivity levels to use in the rules that typically block and challenge requests that might be participating in DDoS attacks and the specification to use to indicate whether a request can handle a silent browser challenge.</li>
             *                                <li>Use the <code>AWSManagedRulesATPRuleSet</code> configuration object to configure the account takeover prevention managed rule group. The configuration includes the sign-in page of your application and the locations in the login request payload of data such as the username and password.</li>
             *                                <li>Use the <code>AWSManagedRulesBotControlRuleSet</code> configuration object to configure the protection level that you want the Bot Control rule group to use.</li>
             *                                </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedRuleGroupConfigs(java.util.List<? extends java.lang.Object> managedRuleGroupConfigs) {
                this.managedRuleGroupConfigs = managedRuleGroupConfigs;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getRuleActionOverrides}
             * @param ruleActionOverrides Action settings to use in the place of the rule actions that are configured inside the rule group.
             *                            You specify one override for each rule whose action you want to change.
             *                            <p>
             *                            <blockquote>
             *                            <p>
             *                            Verify the rule names in your overrides carefully. With managed rule groups, AWS WAF silently ignores any override that uses an invalid rule name. With customer-owned rule groups, invalid rule names in your overrides will cause web ACL updates to fail. An invalid rule name is any name that doesn't exactly match the case-sensitive name of an existing rule in the rule group.
             *                            <p>
             *                            </blockquote>
             *                            <p>
             *                            You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleActionOverrides(software.amazon.awscdk.IResolvable ruleActionOverrides) {
                this.ruleActionOverrides = ruleActionOverrides;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getRuleActionOverrides}
             * @param ruleActionOverrides Action settings to use in the place of the rule actions that are configured inside the rule group.
             *                            You specify one override for each rule whose action you want to change.
             *                            <p>
             *                            <blockquote>
             *                            <p>
             *                            Verify the rule names in your overrides carefully. With managed rule groups, AWS WAF silently ignores any override that uses an invalid rule name. With customer-owned rule groups, invalid rule names in your overrides will cause web ACL updates to fail. An invalid rule name is any name that doesn't exactly match the case-sensitive name of an existing rule in the rule group.
             *                            <p>
             *                            </blockquote>
             *                            <p>
             *                            You can use overrides for testing, for example you can override all of rule actions to <code>Count</code> and then monitor the resulting count metrics to understand how the rule group would handle your web traffic. You can also permanently override some or all actions, to modify how the rule group manages your web traffic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleActionOverrides(java.util.List<? extends java.lang.Object> ruleActionOverrides) {
                this.ruleActionOverrides = ruleActionOverrides;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getScopeDownStatement}
             * @param scopeDownStatement An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group.
             *                           Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable <code>Statement</code> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scopeDownStatement(software.amazon.awscdk.IResolvable scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getScopeDownStatement}
             * @param scopeDownStatement An optional nested statement that narrows the scope of the web requests that are evaluated by the managed rule group.
             *                           Requests are only evaluated by the rule group if they match the scope-down statement. You can use any nestable <code>Statement</code> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scopeDownStatement(software.amazon.awscdk.services.wafv2.CfnWebACL.StatementProperty scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            /**
             * Sets the value of {@link ManagedRuleGroupStatementProperty#getVersion}
             * @param version The version of the managed rule group to use.
             *                If you specify this, the version setting is fixed until you change it. If you don't specify this, AWS WAF uses the vendor's default version, and then keeps the version at the vendor's default when the vendor updates the managed rule group settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManagedRuleGroupStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManagedRuleGroupStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManagedRuleGroupStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedRuleGroupStatementProperty {
            private final java.lang.String name;
            private final java.lang.String vendorName;
            private final java.lang.Object excludedRules;
            private final java.lang.Object managedRuleGroupConfigs;
            private final java.lang.Object ruleActionOverrides;
            private final java.lang.Object scopeDownStatement;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vendorName = software.amazon.jsii.Kernel.get(this, "vendorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.excludedRules = software.amazon.jsii.Kernel.get(this, "excludedRules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.managedRuleGroupConfigs = software.amazon.jsii.Kernel.get(this, "managedRuleGroupConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ruleActionOverrides = software.amazon.jsii.Kernel.get(this, "ruleActionOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scopeDownStatement = software.amazon.jsii.Kernel.get(this, "scopeDownStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.vendorName = java.util.Objects.requireNonNull(builder.vendorName, "vendorName is required");
                this.excludedRules = builder.excludedRules;
                this.managedRuleGroupConfigs = builder.managedRuleGroupConfigs;
                this.ruleActionOverrides = builder.ruleActionOverrides;
                this.scopeDownStatement = builder.scopeDownStatement;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getVendorName() {
                return this.vendorName;
            }

            @Override
            public final java.lang.Object getExcludedRules() {
                return this.excludedRules;
            }

            @Override
            public final java.lang.Object getManagedRuleGroupConfigs() {
                return this.managedRuleGroupConfigs;
            }

            @Override
            public final java.lang.Object getRuleActionOverrides() {
                return this.ruleActionOverrides;
            }

            @Override
            public final java.lang.Object getScopeDownStatement() {
                return this.scopeDownStatement;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("vendorName", om.valueToTree(this.getVendorName()));
                if (this.getExcludedRules() != null) {
                    data.set("excludedRules", om.valueToTree(this.getExcludedRules()));
                }
                if (this.getManagedRuleGroupConfigs() != null) {
                    data.set("managedRuleGroupConfigs", om.valueToTree(this.getManagedRuleGroupConfigs()));
                }
                if (this.getRuleActionOverrides() != null) {
                    data.set("ruleActionOverrides", om.valueToTree(this.getRuleActionOverrides()));
                }
                if (this.getScopeDownStatement() != null) {
                    data.set("scopeDownStatement", om.valueToTree(this.getScopeDownStatement()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ManagedRuleGroupStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManagedRuleGroupStatementProperty.Jsii$Proxy that = (ManagedRuleGroupStatementProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!vendorName.equals(that.vendorName)) return false;
                if (this.excludedRules != null ? !this.excludedRules.equals(that.excludedRules) : that.excludedRules != null) return false;
                if (this.managedRuleGroupConfigs != null ? !this.managedRuleGroupConfigs.equals(that.managedRuleGroupConfigs) : that.managedRuleGroupConfigs != null) return false;
                if (this.ruleActionOverrides != null ? !this.ruleActionOverrides.equals(that.ruleActionOverrides) : that.ruleActionOverrides != null) return false;
                if (this.scopeDownStatement != null ? !this.scopeDownStatement.equals(that.scopeDownStatement) : that.scopeDownStatement != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.vendorName.hashCode());
                result = 31 * result + (this.excludedRules != null ? this.excludedRules.hashCode() : 0);
                result = 31 * result + (this.managedRuleGroupConfigs != null ? this.managedRuleGroupConfigs.hashCode() : 0);
                result = 31 * result + (this.ruleActionOverrides != null ? this.ruleActionOverrides.hashCode() : 0);
                result = 31 * result + (this.scopeDownStatement != null ? this.scopeDownStatement.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A logical rule statement used to negate the results of another rule statement.
     * <p>
     * You provide one <code>Statement</code> within the <code>NotStatement</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-notstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-notstatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.NotStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(NotStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The statement to negate.
         * <p>
         * You can use any statement that can be nested.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-notstatement.html#cfn-wafv2-webacl-notstatement-statement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-notstatement.html#cfn-wafv2-webacl-notstatement-statement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatement();

        /**
         * @return a {@link Builder} of {@link NotStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotStatementProperty> {
            java.lang.Object statement;

            /**
             * Sets the value of {@link NotStatementProperty#getStatement}
             * @param statement The statement to negate. This parameter is required.
             *                  You can use any statement that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statement(software.amazon.awscdk.IResolvable statement) {
                this.statement = statement;
                return this;
            }

            /**
             * Sets the value of {@link NotStatementProperty#getStatement}
             * @param statement The statement to negate. This parameter is required.
             *                  You can use any statement that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statement(software.amazon.awscdk.services.wafv2.CfnWebACL.StatementProperty statement) {
                this.statement = statement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotStatementProperty {
            private final java.lang.Object statement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statement = software.amazon.jsii.Kernel.get(this, "statement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statement = java.util.Objects.requireNonNull(builder.statement, "statement is required");
            }

            @Override
            public final java.lang.Object getStatement() {
                return this.statement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statement", om.valueToTree(this.getStatement()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.NotStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotStatementProperty.Jsii$Proxy that = (NotStatementProperty.Jsii$Proxy) o;

                return this.statement.equals(that.statement);
            }

            @Override
            public final int hashCode() {
                int result = this.statement.hashCode();
                return result;
            }
        }
    }
    /**
     * Configures the level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * OnSourceDDoSProtectionConfigProperty onSourceDDoSProtectionConfigProperty = OnSourceDDoSProtectionConfigProperty.builder()
     *         .albLowReputationMode("albLowReputationMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-onsourceddosprotectionconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-onsourceddosprotectionconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.OnSourceDDoSProtectionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OnSourceDDoSProtectionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OnSourceDDoSProtectionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The level of DDoS protection that applies to web ACLs associated with Application Load Balancers.
         * <p>
         * <code>ACTIVE_UNDER_DDOS</code> protection is enabled by default whenever a web ACL is associated with an Application Load Balancer. In the event that an Application Load Balancer experiences high-load conditions or suspected DDoS attacks, the <code>ACTIVE_UNDER_DDOS</code> protection automatically rate limits traffic from known low reputation sources without disrupting Application Load Balancer availability. <code>ALWAYS_ON</code> protection provides constant, always-on monitoring of known low reputation sources for suspected DDoS attacks. While this provides a higher level of protection, there may be potential impacts on legitimate traffic.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-onsourceddosprotectionconfig.html#cfn-wafv2-webacl-onsourceddosprotectionconfig-alblowreputationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-onsourceddosprotectionconfig.html#cfn-wafv2-webacl-onsourceddosprotectionconfig-alblowreputationmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAlbLowReputationMode();

        /**
         * @return a {@link Builder} of {@link OnSourceDDoSProtectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OnSourceDDoSProtectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OnSourceDDoSProtectionConfigProperty> {
            java.lang.String albLowReputationMode;

            /**
             * Sets the value of {@link OnSourceDDoSProtectionConfigProperty#getAlbLowReputationMode}
             * @param albLowReputationMode The level of DDoS protection that applies to web ACLs associated with Application Load Balancers. This parameter is required.
             *                             <code>ACTIVE_UNDER_DDOS</code> protection is enabled by default whenever a web ACL is associated with an Application Load Balancer. In the event that an Application Load Balancer experiences high-load conditions or suspected DDoS attacks, the <code>ACTIVE_UNDER_DDOS</code> protection automatically rate limits traffic from known low reputation sources without disrupting Application Load Balancer availability. <code>ALWAYS_ON</code> protection provides constant, always-on monitoring of known low reputation sources for suspected DDoS attacks. While this provides a higher level of protection, there may be potential impacts on legitimate traffic.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder albLowReputationMode(java.lang.String albLowReputationMode) {
                this.albLowReputationMode = albLowReputationMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OnSourceDDoSProtectionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OnSourceDDoSProtectionConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OnSourceDDoSProtectionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OnSourceDDoSProtectionConfigProperty {
            private final java.lang.String albLowReputationMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.albLowReputationMode = software.amazon.jsii.Kernel.get(this, "albLowReputationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.albLowReputationMode = java.util.Objects.requireNonNull(builder.albLowReputationMode, "albLowReputationMode is required");
            }

            @Override
            public final java.lang.String getAlbLowReputationMode() {
                return this.albLowReputationMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("albLowReputationMode", om.valueToTree(this.getAlbLowReputationMode()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.OnSourceDDoSProtectionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OnSourceDDoSProtectionConfigProperty.Jsii$Proxy that = (OnSourceDDoSProtectionConfigProperty.Jsii$Proxy) o;

                return this.albLowReputationMode.equals(that.albLowReputationMode);
            }

            @Override
            public final int hashCode() {
                int result = this.albLowReputationMode.hashCode();
                return result;
            }
        }
    }
    /**
     * A logical rule statement used to combine other rule statements with OR logic.
     * <p>
     * You provide more than one <code>Statement</code> within the <code>OrStatement</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-orstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-orstatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.OrStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(OrStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The statements to combine with OR logic.
         * <p>
         * You can use any statements that can be nested.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-orstatement.html#cfn-wafv2-webacl-orstatement-statements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-orstatement.html#cfn-wafv2-webacl-orstatement-statements</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatements();

        /**
         * @return a {@link Builder} of {@link OrStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrStatementProperty> {
            java.lang.Object statements;

            /**
             * Sets the value of {@link OrStatementProperty#getStatements}
             * @param statements The statements to combine with OR logic. This parameter is required.
             *                   You can use any statements that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statements(software.amazon.awscdk.IResolvable statements) {
                this.statements = statements;
                return this;
            }

            /**
             * Sets the value of {@link OrStatementProperty#getStatements}
             * @param statements The statements to combine with OR logic. This parameter is required.
             *                   You can use any statements that can be nested.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statements(java.util.List<? extends java.lang.Object> statements) {
                this.statements = statements;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrStatementProperty {
            private final java.lang.Object statements;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statements = software.amazon.jsii.Kernel.get(this, "statements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statements = java.util.Objects.requireNonNull(builder.statements, "statements is required");
            }

            @Override
            public final java.lang.Object getStatements() {
                return this.statements;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statements", om.valueToTree(this.getStatements()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.OrStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrStatementProperty.Jsii$Proxy that = (OrStatementProperty.Jsii$Proxy) o;

                return this.statements.equals(that.statements);
            }

            @Override
            public final int hashCode() {
                int result = this.statements.hashCode();
                return result;
            }
        }
    }
    /**
     * The action to use in the place of the action that results from the rule group evaluation.
     * <p>
     * Set the override action to none to leave the result of the rule group alone. Set it to count to override the result to count only.
     * <p>
     * You can only use this for rule statements that reference a rule group, like <code>RuleGroupReferenceStatement</code> and <code>ManagedRuleGroupStatement</code> .
     * <p>
     * <blockquote>
     * <p>
     * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with <code>Count</code> action, in your rule group reference statement settings.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object count;
     * Object none;
     * OverrideActionProperty overrideActionProperty = OverrideActionProperty.builder()
     *         .count(count)
     *         .none(none)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.OverrideActionProperty")
    @software.amazon.jsii.Jsii.Proxy(OverrideActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OverrideActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Override the rule group evaluation result to count only.
         * <p>
         * <blockquote>
         * <p>
         * This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with <code>Count</code> action, in your rule group reference statement settings.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html#cfn-wafv2-webacl-overrideaction-count">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html#cfn-wafv2-webacl-overrideaction-count</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCount() {
            return null;
        }

        /**
         * Don't override the rule group evaluation result.
         * <p>
         * This is the most common setting.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html#cfn-wafv2-webacl-overrideaction-none">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-overrideaction.html#cfn-wafv2-webacl-overrideaction-none</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OverrideActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OverrideActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OverrideActionProperty> {
            java.lang.Object count;
            java.lang.Object none;

            /**
             * Sets the value of {@link OverrideActionProperty#getCount}
             * @param count Override the rule group evaluation result to count only.
             *              <blockquote>
             *              <p>
             *              This option is usually set to none. It does not affect how the rules in the rule group are evaluated. If you want the rules in the rule group to only count matches, do not use this and instead use the rule action override option, with <code>Count</code> action, in your rule group reference statement settings.
             *              <p>
             *              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Object count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link OverrideActionProperty#getNone}
             * @param none Don't override the rule group evaluation result.
             *             This is the most common setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder none(java.lang.Object none) {
                this.none = none;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OverrideActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OverrideActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OverrideActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OverrideActionProperty {
            private final java.lang.Object count;
            private final java.lang.Object none;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.none = software.amazon.jsii.Kernel.get(this, "none", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = builder.count;
                this.none = builder.none;
            }

            @Override
            public final java.lang.Object getCount() {
                return this.count;
            }

            @Override
            public final java.lang.Object getNone() {
                return this.none;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getNone() != null) {
                    data.set("none", om.valueToTree(this.getNone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.OverrideActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OverrideActionProperty.Jsii$Proxy that = (OverrideActionProperty.Jsii$Proxy) o;

                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                return this.none != null ? this.none.equals(that.none) : that.none == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                result = 31 * result + (this.none != null ? this.none.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a single custom aggregate key for a rate-base rule.
     * <p>
     * <blockquote>
     * <p>
     * Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object asn;
     * Object forwardedIp;
     * Object httpMethod;
     * Object ip;
     * RateBasedStatementCustomKeyProperty rateBasedStatementCustomKeyProperty = RateBasedStatementCustomKeyProperty.builder()
     *         .asn(asn)
     *         .cookie(RateLimitCookieProperty.builder()
     *                 .name("name")
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .forwardedIp(forwardedIp)
     *         .header(RateLimitHeaderProperty.builder()
     *                 .name("name")
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .httpMethod(httpMethod)
     *         .ip(ip)
     *         .ja3Fingerprint(RateLimitJA3FingerprintProperty.builder()
     *                 .fallbackBehavior("fallbackBehavior")
     *                 .build())
     *         .ja4Fingerprint(RateLimitJA4FingerprintProperty.builder()
     *                 .fallbackBehavior("fallbackBehavior")
     *                 .build())
     *         .labelNamespace(RateLimitLabelNamespaceProperty.builder()
     *                 .namespace("namespace")
     *                 .build())
     *         .queryArgument(RateLimitQueryArgumentProperty.builder()
     *                 .name("name")
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .queryString(RateLimitQueryStringProperty.builder()
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .uriPath(RateLimitUriPathProperty.builder()
     *                 .textTransformations(List.of(TextTransformationProperty.builder()
     *                         .priority(123)
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RateBasedStatementCustomKeyProperty")
    @software.amazon.jsii.Jsii.Proxy(RateBasedStatementCustomKeyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateBasedStatementCustomKeyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Use an Autonomous System Number (ASN) derived from the request's originating or forwarded IP address as an aggregate key.
         * <p>
         * Each distinct ASN contributes to the aggregation instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-asn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-asn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAsn() {
            return null;
        }

        /**
         * Use the value of a cookie in the request as an aggregate key.
         * <p>
         * Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-cookie">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-cookie</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCookie() {
            return null;
        }

        /**
         * Use the first IP address in an HTTP header as an aggregate key.
         * <p>
         * Each distinct forwarded IP address contributes to the aggregation instance.
         * <p>
         * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying <code>FORWARDED_IP</code> in your rate-based statement's <code>AggregateKeyType</code> .
         * <p>
         * With this option, you must specify the header to use in the rate-based rule's <code>ForwardedIPConfig</code> property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-forwardedip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-forwardedip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedIp() {
            return null;
        }

        /**
         * Use the value of a header in the request as an aggregate key.
         * <p>
         * Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-header">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-header</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeader() {
            return null;
        }

        /**
         * Use the request's HTTP method as an aggregate key.
         * <p>
         * Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-httpmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-httpmethod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttpMethod() {
            return null;
        }

        /**
         * Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance.
         * <p>
         * When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying <code>IP</code> in your rate-based statement's <code>AggregateKeyType</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-ip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-ip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIp() {
            return null;
        }

        /**
         * Use the request's JA3 fingerprint as an aggregate key.
         * <p>
         * If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-ja3fingerprint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-ja3fingerprint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJa3Fingerprint() {
            return null;
        }

        /**
         * Use the request's JA4 fingerprint as an aggregate key.
         * <p>
         * If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-ja4fingerprint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-ja4fingerprint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJa4Fingerprint() {
            return null;
        }

        /**
         * Use the specified label namespace as an aggregate key.
         * <p>
         * Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.
         * <p>
         * This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.
         * <p>
         * For information about label namespaces and names, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label syntax and naming requirements</a> in the <em>AWS WAF Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-labelnamespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-labelnamespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLabelNamespace() {
            return null;
        }

        /**
         * Use the specified query argument as an aggregate key.
         * <p>
         * Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-queryargument">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-queryargument</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryArgument() {
            return null;
        }

        /**
         * Use the request's query string as an aggregate key.
         * <p>
         * Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-querystring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-querystring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryString() {
            return null;
        }

        /**
         * Use the request's URI path as an aggregate key.
         * <p>
         * Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-uripath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatementcustomkey.html#cfn-wafv2-webacl-ratebasedstatementcustomkey-uripath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUriPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RateBasedStatementCustomKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateBasedStatementCustomKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateBasedStatementCustomKeyProperty> {
            java.lang.Object asn;
            java.lang.Object cookie;
            java.lang.Object forwardedIp;
            java.lang.Object header;
            java.lang.Object httpMethod;
            java.lang.Object ip;
            java.lang.Object ja3Fingerprint;
            java.lang.Object ja4Fingerprint;
            java.lang.Object labelNamespace;
            java.lang.Object queryArgument;
            java.lang.Object queryString;
            java.lang.Object uriPath;

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getAsn}
             * @param asn Use an Autonomous System Number (ASN) derived from the request's originating or forwarded IP address as an aggregate key.
             *            Each distinct ASN contributes to the aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder asn(java.lang.Object asn) {
                this.asn = asn;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getCookie}
             * @param cookie Use the value of a cookie in the request as an aggregate key.
             *               Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookie(software.amazon.awscdk.IResolvable cookie) {
                this.cookie = cookie;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getCookie}
             * @param cookie Use the value of a cookie in the request as an aggregate key.
             *               Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookie(software.amazon.awscdk.services.wafv2.CfnWebACL.RateLimitCookieProperty cookie) {
                this.cookie = cookie;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getForwardedIp}
             * @param forwardedIp Use the first IP address in an HTTP header as an aggregate key.
             *                    Each distinct forwarded IP address contributes to the aggregation instance.
             *                    <p>
             *                    When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the forwarded IP address by specifying <code>FORWARDED_IP</code> in your rate-based statement's <code>AggregateKeyType</code> .
             *                    <p>
             *                    With this option, you must specify the header to use in the rate-based rule's <code>ForwardedIPConfig</code> property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIp(java.lang.Object forwardedIp) {
                this.forwardedIp = forwardedIp;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getHeader}
             * @param header Use the value of a header in the request as an aggregate key.
             *               Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(software.amazon.awscdk.IResolvable header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getHeader}
             * @param header Use the value of a header in the request as an aggregate key.
             *               Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder header(software.amazon.awscdk.services.wafv2.CfnWebACL.RateLimitHeaderProperty header) {
                this.header = header;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getHttpMethod}
             * @param httpMethod Use the request's HTTP method as an aggregate key.
             *                   Each distinct HTTP method contributes to the aggregation instance. If you use just the HTTP method as your custom key, then each method fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpMethod(java.lang.Object httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getIp}
             * @param ip Use the request's originating IP address as an aggregate key. Each distinct IP address contributes to the aggregation instance.
             *           When you specify an IP or forwarded IP in the custom key settings, you must also specify at least one other key to use. You can aggregate on only the IP address by specifying <code>IP</code> in your rate-based statement's <code>AggregateKeyType</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ip(java.lang.Object ip) {
                this.ip = ip;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getJa3Fingerprint}
             * @param ja3Fingerprint Use the request's JA3 fingerprint as an aggregate key.
             *                       If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ja3Fingerprint(software.amazon.awscdk.IResolvable ja3Fingerprint) {
                this.ja3Fingerprint = ja3Fingerprint;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getJa3Fingerprint}
             * @param ja3Fingerprint Use the request's JA3 fingerprint as an aggregate key.
             *                       If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ja3Fingerprint(software.amazon.awscdk.services.wafv2.CfnWebACL.RateLimitJA3FingerprintProperty ja3Fingerprint) {
                this.ja3Fingerprint = ja3Fingerprint;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getJa4Fingerprint}
             * @param ja4Fingerprint Use the request's JA4 fingerprint as an aggregate key.
             *                       If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ja4Fingerprint(software.amazon.awscdk.IResolvable ja4Fingerprint) {
                this.ja4Fingerprint = ja4Fingerprint;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getJa4Fingerprint}
             * @param ja4Fingerprint Use the request's JA4 fingerprint as an aggregate key.
             *                       If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ja4Fingerprint(software.amazon.awscdk.services.wafv2.CfnWebACL.RateLimitJA4FingerprintProperty ja4Fingerprint) {
                this.ja4Fingerprint = ja4Fingerprint;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getLabelNamespace}
             * @param labelNamespace Use the specified label namespace as an aggregate key.
             *                       Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.
             *                       <p>
             *                       This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.
             *                       <p>
             *                       For information about label namespaces and names, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label syntax and naming requirements</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelNamespace(software.amazon.awscdk.IResolvable labelNamespace) {
                this.labelNamespace = labelNamespace;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getLabelNamespace}
             * @param labelNamespace Use the specified label namespace as an aggregate key.
             *                       Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.
             *                       <p>
             *                       This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.
             *                       <p>
             *                       For information about label namespaces and names, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label syntax and naming requirements</a> in the <em>AWS WAF Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder labelNamespace(software.amazon.awscdk.services.wafv2.CfnWebACL.RateLimitLabelNamespaceProperty labelNamespace) {
                this.labelNamespace = labelNamespace;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getQueryArgument}
             * @param queryArgument Use the specified query argument as an aggregate key.
             *                      Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryArgument(software.amazon.awscdk.IResolvable queryArgument) {
                this.queryArgument = queryArgument;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getQueryArgument}
             * @param queryArgument Use the specified query argument as an aggregate key.
             *                      Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryArgument(software.amazon.awscdk.services.wafv2.CfnWebACL.RateLimitQueryArgumentProperty queryArgument) {
                this.queryArgument = queryArgument;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getQueryString}
             * @param queryString Use the request's query string as an aggregate key.
             *                    Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(software.amazon.awscdk.IResolvable queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getQueryString}
             * @param queryString Use the request's query string as an aggregate key.
             *                    Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(software.amazon.awscdk.services.wafv2.CfnWebACL.RateLimitQueryStringProperty queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getUriPath}
             * @param uriPath Use the request's URI path as an aggregate key.
             *                Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uriPath(software.amazon.awscdk.IResolvable uriPath) {
                this.uriPath = uriPath;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementCustomKeyProperty#getUriPath}
             * @param uriPath Use the request's URI path as an aggregate key.
             *                Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder uriPath(software.amazon.awscdk.services.wafv2.CfnWebACL.RateLimitUriPathProperty uriPath) {
                this.uriPath = uriPath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateBasedStatementCustomKeyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateBasedStatementCustomKeyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateBasedStatementCustomKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateBasedStatementCustomKeyProperty {
            private final java.lang.Object asn;
            private final java.lang.Object cookie;
            private final java.lang.Object forwardedIp;
            private final java.lang.Object header;
            private final java.lang.Object httpMethod;
            private final java.lang.Object ip;
            private final java.lang.Object ja3Fingerprint;
            private final java.lang.Object ja4Fingerprint;
            private final java.lang.Object labelNamespace;
            private final java.lang.Object queryArgument;
            private final java.lang.Object queryString;
            private final java.lang.Object uriPath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.asn = software.amazon.jsii.Kernel.get(this, "asn", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cookie = software.amazon.jsii.Kernel.get(this, "cookie", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.forwardedIp = software.amazon.jsii.Kernel.get(this, "forwardedIp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.header = software.amazon.jsii.Kernel.get(this, "header", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ip = software.amazon.jsii.Kernel.get(this, "ip", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ja3Fingerprint = software.amazon.jsii.Kernel.get(this, "ja3Fingerprint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ja4Fingerprint = software.amazon.jsii.Kernel.get(this, "ja4Fingerprint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.labelNamespace = software.amazon.jsii.Kernel.get(this, "labelNamespace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryArgument = software.amazon.jsii.Kernel.get(this, "queryArgument", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.uriPath = software.amazon.jsii.Kernel.get(this, "uriPath", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.asn = builder.asn;
                this.cookie = builder.cookie;
                this.forwardedIp = builder.forwardedIp;
                this.header = builder.header;
                this.httpMethod = builder.httpMethod;
                this.ip = builder.ip;
                this.ja3Fingerprint = builder.ja3Fingerprint;
                this.ja4Fingerprint = builder.ja4Fingerprint;
                this.labelNamespace = builder.labelNamespace;
                this.queryArgument = builder.queryArgument;
                this.queryString = builder.queryString;
                this.uriPath = builder.uriPath;
            }

            @Override
            public final java.lang.Object getAsn() {
                return this.asn;
            }

            @Override
            public final java.lang.Object getCookie() {
                return this.cookie;
            }

            @Override
            public final java.lang.Object getForwardedIp() {
                return this.forwardedIp;
            }

            @Override
            public final java.lang.Object getHeader() {
                return this.header;
            }

            @Override
            public final java.lang.Object getHttpMethod() {
                return this.httpMethod;
            }

            @Override
            public final java.lang.Object getIp() {
                return this.ip;
            }

            @Override
            public final java.lang.Object getJa3Fingerprint() {
                return this.ja3Fingerprint;
            }

            @Override
            public final java.lang.Object getJa4Fingerprint() {
                return this.ja4Fingerprint;
            }

            @Override
            public final java.lang.Object getLabelNamespace() {
                return this.labelNamespace;
            }

            @Override
            public final java.lang.Object getQueryArgument() {
                return this.queryArgument;
            }

            @Override
            public final java.lang.Object getQueryString() {
                return this.queryString;
            }

            @Override
            public final java.lang.Object getUriPath() {
                return this.uriPath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAsn() != null) {
                    data.set("asn", om.valueToTree(this.getAsn()));
                }
                if (this.getCookie() != null) {
                    data.set("cookie", om.valueToTree(this.getCookie()));
                }
                if (this.getForwardedIp() != null) {
                    data.set("forwardedIp", om.valueToTree(this.getForwardedIp()));
                }
                if (this.getHeader() != null) {
                    data.set("header", om.valueToTree(this.getHeader()));
                }
                if (this.getHttpMethod() != null) {
                    data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                }
                if (this.getIp() != null) {
                    data.set("ip", om.valueToTree(this.getIp()));
                }
                if (this.getJa3Fingerprint() != null) {
                    data.set("ja3Fingerprint", om.valueToTree(this.getJa3Fingerprint()));
                }
                if (this.getJa4Fingerprint() != null) {
                    data.set("ja4Fingerprint", om.valueToTree(this.getJa4Fingerprint()));
                }
                if (this.getLabelNamespace() != null) {
                    data.set("labelNamespace", om.valueToTree(this.getLabelNamespace()));
                }
                if (this.getQueryArgument() != null) {
                    data.set("queryArgument", om.valueToTree(this.getQueryArgument()));
                }
                if (this.getQueryString() != null) {
                    data.set("queryString", om.valueToTree(this.getQueryString()));
                }
                if (this.getUriPath() != null) {
                    data.set("uriPath", om.valueToTree(this.getUriPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RateBasedStatementCustomKeyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateBasedStatementCustomKeyProperty.Jsii$Proxy that = (RateBasedStatementCustomKeyProperty.Jsii$Proxy) o;

                if (this.asn != null ? !this.asn.equals(that.asn) : that.asn != null) return false;
                if (this.cookie != null ? !this.cookie.equals(that.cookie) : that.cookie != null) return false;
                if (this.forwardedIp != null ? !this.forwardedIp.equals(that.forwardedIp) : that.forwardedIp != null) return false;
                if (this.header != null ? !this.header.equals(that.header) : that.header != null) return false;
                if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) return false;
                if (this.ip != null ? !this.ip.equals(that.ip) : that.ip != null) return false;
                if (this.ja3Fingerprint != null ? !this.ja3Fingerprint.equals(that.ja3Fingerprint) : that.ja3Fingerprint != null) return false;
                if (this.ja4Fingerprint != null ? !this.ja4Fingerprint.equals(that.ja4Fingerprint) : that.ja4Fingerprint != null) return false;
                if (this.labelNamespace != null ? !this.labelNamespace.equals(that.labelNamespace) : that.labelNamespace != null) return false;
                if (this.queryArgument != null ? !this.queryArgument.equals(that.queryArgument) : that.queryArgument != null) return false;
                if (this.queryString != null ? !this.queryString.equals(that.queryString) : that.queryString != null) return false;
                return this.uriPath != null ? this.uriPath.equals(that.uriPath) : that.uriPath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.asn != null ? this.asn.hashCode() : 0;
                result = 31 * result + (this.cookie != null ? this.cookie.hashCode() : 0);
                result = 31 * result + (this.forwardedIp != null ? this.forwardedIp.hashCode() : 0);
                result = 31 * result + (this.header != null ? this.header.hashCode() : 0);
                result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
                result = 31 * result + (this.ip != null ? this.ip.hashCode() : 0);
                result = 31 * result + (this.ja3Fingerprint != null ? this.ja3Fingerprint.hashCode() : 0);
                result = 31 * result + (this.ja4Fingerprint != null ? this.ja4Fingerprint.hashCode() : 0);
                result = 31 * result + (this.labelNamespace != null ? this.labelNamespace.hashCode() : 0);
                result = 31 * result + (this.queryArgument != null ? this.queryArgument.hashCode() : 0);
                result = 31 * result + (this.queryString != null ? this.queryString.hashCode() : 0);
                result = 31 * result + (this.uriPath != null ? this.uriPath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A rate-based rule counts incoming requests and rate limits requests when they are coming at too fast a rate.
     * <p>
     * The rule categorizes requests according to your aggregation criteria, collects them into aggregation instances, and counts and rate limits the requests for each instance.
     * <p>
     * <blockquote>
     * <p>
     * If you change any of these settings in a rule that's currently in use, the change resets the rule's rate limiting counts. This can pause the rule's rate limiting activities for up to a minute.
     * <p>
     * </blockquote>
     * <p>
     * You can specify individual aggregation keys, like IP address or HTTP method. You can also specify aggregation key combinations, like IP address and HTTP method, or HTTP method, query argument, and cookie.
     * <p>
     * Each unique set of values for the aggregation keys that you specify is a separate aggregation instance, with the value from each key contributing to the aggregation instance definition.
     * <p>
     * For example, assume the rule evaluates web requests with the following IP address and HTTP method values:
     * <p>
     * <ul>
     * <li>IP address 10.1.1.1, HTTP method POST</li>
     * <li>IP address 10.1.1.1, HTTP method GET</li>
     * <li>IP address 127.0.0.0, HTTP method POST</li>
     * <li>IP address 10.1.1.1, HTTP method GET</li>
     * </ul>
     * <p>
     * The rule would create different aggregation instances according to your aggregation criteria, for example:
     * <p>
     * <ul>
     * <li>If the aggregation criteria is just the IP address, then each individual address is an aggregation instance, and AWS WAF counts requests separately for each. The aggregation instances and request counts for our example would be the following:</li>
     * <li>IP address 10.1.1.1: count 3</li>
     * <li>IP address 127.0.0.0: count 1</li>
     * <li>If the aggregation criteria is HTTP method, then each individual HTTP method is an aggregation instance. The aggregation instances and request counts for our example would be the following:</li>
     * <li>HTTP method POST: count 2</li>
     * <li>HTTP method GET: count 2</li>
     * <li>If the aggregation criteria is IP address and HTTP method, then each IP address and each HTTP method would contribute to the combined aggregation instance. The aggregation instances and request counts for our example would be the following:</li>
     * <li>IP address 10.1.1.1, HTTP method POST: count 1</li>
     * <li>IP address 10.1.1.1, HTTP method GET: count 2</li>
     * <li>IP address 127.0.0.0, HTTP method POST: count 1</li>
     * </ul>
     * <p>
     * For any n-tuple of aggregation keys, each unique combination of values for the keys defines a separate aggregation instance, which AWS WAF counts and rate-limits individually.
     * <p>
     * You can optionally nest another statement inside the rate-based statement, to narrow the scope of the rule so that it only counts and rate limits requests that match the nested statement. You can use this nested scope-down statement in conjunction with your aggregation key specifications or you can just count and rate limit all requests that match the scope-down statement, without additional aggregation. When you choose to just manage all requests that match a scope-down statement, the aggregation instance is singular for the rule.
     * <p>
     * You cannot nest a <code>RateBasedStatement</code> inside another statement, for example inside a <code>NotStatement</code> or <code>OrStatement</code> . You can define a <code>RateBasedStatement</code> inside a web ACL and inside a rule group.
     * <p>
     * For additional information about the options, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rate-based-rules.html">Rate limiting web requests using rate-based rules</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * If you only aggregate on the individual IP address or forwarded IP address, you can retrieve the list of IP addresses that AWS WAF is currently rate limiting for a rule through the API call <code>GetRateBasedStatementManagedKeys</code> . This option is not available for other aggregation configurations.
     * <p>
     * AWS WAF tracks and manages web requests separately for each instance of a rate-based rule that you use. For example, if you provide the same rate-based rule settings in two web ACLs, each of the two rule statements represents a separate instance of the rate-based rule and gets its own tracking and management by AWS WAF . If you define a rate-based rule inside a rule group, and then use that rule group in multiple places, each use creates a separate instance of the rate-based rule that gets its own tracking and management by AWS WAF .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RateBasedStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(RateBasedStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateBasedStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Setting that indicates how to aggregate the request counts.
         * <p>
         * <blockquote>
         * <p>
         * Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><code>CONSTANT</code> - Count and limit the requests that match the rate-based rule's scope-down statement. With this option, the counted requests aren't further aggregated. The scope-down statement is the only specification used. When the count of all requests that satisfy the scope-down statement goes over the limit, AWS WAF applies the rule action to all requests that satisfy the scope-down statement.</li>
         * </ul>
         * <p>
         * With this option, you must configure the <code>ScopeDownStatement</code> property.
         * <p>
         * <ul>
         * <li><code>CUSTOM_KEYS</code> - Aggregate the request counts using one or more web request components as the aggregate keys.</li>
         * </ul>
         * <p>
         * With this option, you must specify the aggregate keys in the <code>CustomKeys</code> property.
         * <p>
         * To aggregate on only the IP address or only the forwarded IP address, don't use custom keys. Instead, set the aggregate key type to <code>IP</code> or <code>FORWARDED_IP</code> .
         * <p>
         * <ul>
         * <li><code>FORWARDED_IP</code> - Aggregate the request counts on the first IP address in an HTTP header.</li>
         * </ul>
         * <p>
         * With this option, you must specify the header to use in the <code>ForwardedIPConfig</code> property.
         * <p>
         * To aggregate on a combination of the forwarded IP address with other aggregate keys, use <code>CUSTOM_KEYS</code> .
         * <p>
         * <ul>
         * <li><code>IP</code> - Aggregate the request counts on the IP address from the web request origin.</li>
         * </ul>
         * <p>
         * To aggregate on a combination of the IP address with other aggregate keys, use <code>CUSTOM_KEYS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-aggregatekeytype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-aggregatekeytype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAggregateKeyType();

        /**
         * The limit on requests during the specified evaluation window for a single aggregation instance for the rate-based rule.
         * <p>
         * If the rate-based statement includes a <code>ScopeDownStatement</code> , this limit is applied only to the requests that match the statement.
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li>If you aggregate on just the IP address, this is the limit on requests from any single IP address.</li>
         * <li>If you aggregate on the HTTP method and the query argument name "city", then this is the limit on requests for any single method, city pair.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-limit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-limit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLimit();

        /**
         * Specifies the aggregate keys to use in a rate-base rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-customkeys">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-customkeys</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomKeys() {
            return null;
        }

        /**
         * The amount of time, in seconds, that AWS WAF should include in its request counts, looking back from the current time.
         * <p>
         * For example, for a setting of 120, when AWS WAF checks the rate, it counts the requests for the 2 minutes immediately preceding the current time. Valid settings are 60, 120, 300, and 600.
         * <p>
         * This setting doesn't determine how often AWS WAF checks the rate, but how far back it looks each time it checks. AWS WAF checks the rate about every 10 seconds.
         * <p>
         * Default: <code>300</code> (5 minutes)
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-evaluationwindowsec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-evaluationwindowsec</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getEvaluationWindowSec() {
            return null;
        }

        /**
         * The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
         * <p>
         * Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
         * <p>
         * <blockquote>
         * <p>
         * If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
         * <p>
         * </blockquote>
         * <p>
         * This is required if you specify a forwarded IP in the rule's aggregate key settings.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-forwardedipconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-forwardedipconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedIpConfig() {
            return null;
        }

        /**
         * An optional nested statement that narrows the scope of the web requests that are evaluated and managed by the rate-based statement.
         * <p>
         * When you use a scope-down statement, the rate-based rule only tracks and rate limits requests that match the scope-down statement. You can use any nestable <code>Statement</code> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-scopedownstatement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratebasedstatement.html#cfn-wafv2-webacl-ratebasedstatement-scopedownstatement</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScopeDownStatement() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RateBasedStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateBasedStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateBasedStatementProperty> {
            java.lang.String aggregateKeyType;
            java.lang.Number limit;
            java.lang.Object customKeys;
            java.lang.Number evaluationWindowSec;
            java.lang.Object forwardedIpConfig;
            java.lang.Object scopeDownStatement;

            /**
             * Sets the value of {@link RateBasedStatementProperty#getAggregateKeyType}
             * @param aggregateKeyType Setting that indicates how to aggregate the request counts. This parameter is required.
             *                         <blockquote>
             *                         <p>
             *                         Web requests that are missing any of the components specified in the aggregation keys are omitted from the rate-based rule evaluation and handling.
             *                         <p>
             *                         </blockquote>
             *                         <p>
             *                         <ul>
             *                         <li><code>CONSTANT</code> - Count and limit the requests that match the rate-based rule's scope-down statement. With this option, the counted requests aren't further aggregated. The scope-down statement is the only specification used. When the count of all requests that satisfy the scope-down statement goes over the limit, AWS WAF applies the rule action to all requests that satisfy the scope-down statement.</li>
             *                         </ul>
             *                         <p>
             *                         With this option, you must configure the <code>ScopeDownStatement</code> property.
             *                         <p>
             *                         <ul>
             *                         <li><code>CUSTOM_KEYS</code> - Aggregate the request counts using one or more web request components as the aggregate keys.</li>
             *                         </ul>
             *                         <p>
             *                         With this option, you must specify the aggregate keys in the <code>CustomKeys</code> property.
             *                         <p>
             *                         To aggregate on only the IP address or only the forwarded IP address, don't use custom keys. Instead, set the aggregate key type to <code>IP</code> or <code>FORWARDED_IP</code> .
             *                         <p>
             *                         <ul>
             *                         <li><code>FORWARDED_IP</code> - Aggregate the request counts on the first IP address in an HTTP header.</li>
             *                         </ul>
             *                         <p>
             *                         With this option, you must specify the header to use in the <code>ForwardedIPConfig</code> property.
             *                         <p>
             *                         To aggregate on a combination of the forwarded IP address with other aggregate keys, use <code>CUSTOM_KEYS</code> .
             *                         <p>
             *                         <ul>
             *                         <li><code>IP</code> - Aggregate the request counts on the IP address from the web request origin.</li>
             *                         </ul>
             *                         <p>
             *                         To aggregate on a combination of the IP address with other aggregate keys, use <code>CUSTOM_KEYS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregateKeyType(java.lang.String aggregateKeyType) {
                this.aggregateKeyType = aggregateKeyType;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getLimit}
             * @param limit The limit on requests during the specified evaluation window for a single aggregation instance for the rate-based rule. This parameter is required.
             *              If the rate-based statement includes a <code>ScopeDownStatement</code> , this limit is applied only to the requests that match the statement.
             *              <p>
             *              Examples:
             *              <p>
             *              <ul>
             *              <li>If you aggregate on just the IP address, this is the limit on requests from any single IP address.</li>
             *              <li>If you aggregate on the HTTP method and the query argument name "city", then this is the limit on requests for any single method, city pair.</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder limit(java.lang.Number limit) {
                this.limit = limit;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getCustomKeys}
             * @param customKeys Specifies the aggregate keys to use in a rate-base rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customKeys(software.amazon.awscdk.IResolvable customKeys) {
                this.customKeys = customKeys;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getCustomKeys}
             * @param customKeys Specifies the aggregate keys to use in a rate-base rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customKeys(java.util.List<? extends java.lang.Object> customKeys) {
                this.customKeys = customKeys;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getEvaluationWindowSec}
             * @param evaluationWindowSec The amount of time, in seconds, that AWS WAF should include in its request counts, looking back from the current time.
             *                            For example, for a setting of 120, when AWS WAF checks the rate, it counts the requests for the 2 minutes immediately preceding the current time. Valid settings are 60, 120, 300, and 600.
             *                            <p>
             *                            This setting doesn't determine how often AWS WAF checks the rate, but how far back it looks each time it checks. AWS WAF checks the rate about every 10 seconds.
             *                            <p>
             *                            Default: <code>300</code> (5 minutes)
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder evaluationWindowSec(java.lang.Number evaluationWindowSec) {
                this.evaluationWindowSec = evaluationWindowSec;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getForwardedIpConfig}
             * @param forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                          Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                          <p>
             *                          </blockquote>
             *                          <p>
             *                          This is required if you specify a forwarded IP in the rule's aggregate key settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIpConfig(software.amazon.awscdk.IResolvable forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getForwardedIpConfig}
             * @param forwardedIpConfig The configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin.
             *                          Commonly, this is the X-Forwarded-For (XFF) header, but you can specify any header name.
             *                          <p>
             *                          <blockquote>
             *                          <p>
             *                          If the specified header isn't present in the request, AWS WAF doesn't apply the rule to the web request at all.
             *                          <p>
             *                          </blockquote>
             *                          <p>
             *                          This is required if you specify a forwarded IP in the rule's aggregate key settings.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedIpConfig(software.amazon.awscdk.services.wafv2.CfnWebACL.ForwardedIPConfigurationProperty forwardedIpConfig) {
                this.forwardedIpConfig = forwardedIpConfig;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getScopeDownStatement}
             * @param scopeDownStatement An optional nested statement that narrows the scope of the web requests that are evaluated and managed by the rate-based statement.
             *                           When you use a scope-down statement, the rate-based rule only tracks and rate limits requests that match the scope-down statement. You can use any nestable <code>Statement</code> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scopeDownStatement(software.amazon.awscdk.IResolvable scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            /**
             * Sets the value of {@link RateBasedStatementProperty#getScopeDownStatement}
             * @param scopeDownStatement An optional nested statement that narrows the scope of the web requests that are evaluated and managed by the rate-based statement.
             *                           When you use a scope-down statement, the rate-based rule only tracks and rate limits requests that match the scope-down statement. You can use any nestable <code>Statement</code> in the scope-down statement, and you can nest statements at any level, the same as you can for a rule statement.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scopeDownStatement(software.amazon.awscdk.services.wafv2.CfnWebACL.StatementProperty scopeDownStatement) {
                this.scopeDownStatement = scopeDownStatement;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateBasedStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateBasedStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateBasedStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateBasedStatementProperty {
            private final java.lang.String aggregateKeyType;
            private final java.lang.Number limit;
            private final java.lang.Object customKeys;
            private final java.lang.Number evaluationWindowSec;
            private final java.lang.Object forwardedIpConfig;
            private final java.lang.Object scopeDownStatement;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregateKeyType = software.amazon.jsii.Kernel.get(this, "aggregateKeyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.limit = software.amazon.jsii.Kernel.get(this, "limit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customKeys = software.amazon.jsii.Kernel.get(this, "customKeys", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.evaluationWindowSec = software.amazon.jsii.Kernel.get(this, "evaluationWindowSec", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.forwardedIpConfig = software.amazon.jsii.Kernel.get(this, "forwardedIpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scopeDownStatement = software.amazon.jsii.Kernel.get(this, "scopeDownStatement", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregateKeyType = java.util.Objects.requireNonNull(builder.aggregateKeyType, "aggregateKeyType is required");
                this.limit = java.util.Objects.requireNonNull(builder.limit, "limit is required");
                this.customKeys = builder.customKeys;
                this.evaluationWindowSec = builder.evaluationWindowSec;
                this.forwardedIpConfig = builder.forwardedIpConfig;
                this.scopeDownStatement = builder.scopeDownStatement;
            }

            @Override
            public final java.lang.String getAggregateKeyType() {
                return this.aggregateKeyType;
            }

            @Override
            public final java.lang.Number getLimit() {
                return this.limit;
            }

            @Override
            public final java.lang.Object getCustomKeys() {
                return this.customKeys;
            }

            @Override
            public final java.lang.Number getEvaluationWindowSec() {
                return this.evaluationWindowSec;
            }

            @Override
            public final java.lang.Object getForwardedIpConfig() {
                return this.forwardedIpConfig;
            }

            @Override
            public final java.lang.Object getScopeDownStatement() {
                return this.scopeDownStatement;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("aggregateKeyType", om.valueToTree(this.getAggregateKeyType()));
                data.set("limit", om.valueToTree(this.getLimit()));
                if (this.getCustomKeys() != null) {
                    data.set("customKeys", om.valueToTree(this.getCustomKeys()));
                }
                if (this.getEvaluationWindowSec() != null) {
                    data.set("evaluationWindowSec", om.valueToTree(this.getEvaluationWindowSec()));
                }
                if (this.getForwardedIpConfig() != null) {
                    data.set("forwardedIpConfig", om.valueToTree(this.getForwardedIpConfig()));
                }
                if (this.getScopeDownStatement() != null) {
                    data.set("scopeDownStatement", om.valueToTree(this.getScopeDownStatement()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RateBasedStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateBasedStatementProperty.Jsii$Proxy that = (RateBasedStatementProperty.Jsii$Proxy) o;

                if (!aggregateKeyType.equals(that.aggregateKeyType)) return false;
                if (!limit.equals(that.limit)) return false;
                if (this.customKeys != null ? !this.customKeys.equals(that.customKeys) : that.customKeys != null) return false;
                if (this.evaluationWindowSec != null ? !this.evaluationWindowSec.equals(that.evaluationWindowSec) : that.evaluationWindowSec != null) return false;
                if (this.forwardedIpConfig != null ? !this.forwardedIpConfig.equals(that.forwardedIpConfig) : that.forwardedIpConfig != null) return false;
                return this.scopeDownStatement != null ? this.scopeDownStatement.equals(that.scopeDownStatement) : that.scopeDownStatement == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregateKeyType.hashCode();
                result = 31 * result + (this.limit.hashCode());
                result = 31 * result + (this.customKeys != null ? this.customKeys.hashCode() : 0);
                result = 31 * result + (this.evaluationWindowSec != null ? this.evaluationWindowSec.hashCode() : 0);
                result = 31 * result + (this.forwardedIpConfig != null ? this.forwardedIpConfig.hashCode() : 0);
                result = 31 * result + (this.scopeDownStatement != null ? this.scopeDownStatement.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a cookie as an aggregate key for a rate-based rule.
     * <p>
     * Each distinct value in the cookie contributes to the aggregation instance. If you use a single cookie as your custom key, then each value fully defines an aggregation instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RateLimitCookieProperty rateLimitCookieProperty = RateLimitCookieProperty.builder()
     *         .name("name")
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitcookie.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitcookie.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitCookieProperty")
    @software.amazon.jsii.Jsii.Proxy(RateLimitCookieProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateLimitCookieProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the cookie to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitcookie.html#cfn-wafv2-webacl-ratelimitcookie-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitcookie.html#cfn-wafv2-webacl-ratelimitcookie-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitcookie.html#cfn-wafv2-webacl-ratelimitcookie-texttransformations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitcookie.html#cfn-wafv2-webacl-ratelimitcookie-texttransformations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link RateLimitCookieProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateLimitCookieProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateLimitCookieProperty> {
            java.lang.String name;
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link RateLimitCookieProperty#getName}
             * @param name The name of the cookie to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RateLimitCookieProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link RateLimitCookieProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateLimitCookieProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateLimitCookieProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateLimitCookieProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateLimitCookieProperty {
            private final java.lang.String name;
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitCookieProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateLimitCookieProperty.Jsii$Proxy that = (RateLimitCookieProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.textTransformations.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies a header as an aggregate key for a rate-based rule.
     * <p>
     * Each distinct value in the header contributes to the aggregation instance. If you use a single header as your custom key, then each value fully defines an aggregation instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RateLimitHeaderProperty rateLimitHeaderProperty = RateLimitHeaderProperty.builder()
     *         .name("name")
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(RateLimitHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateLimitHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the header to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitheader.html#cfn-wafv2-webacl-ratelimitheader-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitheader.html#cfn-wafv2-webacl-ratelimitheader-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitheader.html#cfn-wafv2-webacl-ratelimitheader-texttransformations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitheader.html#cfn-wafv2-webacl-ratelimitheader-texttransformations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link RateLimitHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateLimitHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateLimitHeaderProperty> {
            java.lang.String name;
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link RateLimitHeaderProperty#getName}
             * @param name The name of the header to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RateLimitHeaderProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link RateLimitHeaderProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateLimitHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateLimitHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateLimitHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateLimitHeaderProperty {
            private final java.lang.String name;
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateLimitHeaderProperty.Jsii$Proxy that = (RateLimitHeaderProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.textTransformations.hashCode());
                return result;
            }
        }
    }
    /**
     * Use the request's JA3 fingerprint derived from the TLS Client Hello of an incoming request as an aggregate key.
     * <p>
     * If you use a single JA3 fingerprint as your custom key, then each value fully defines an aggregation instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RateLimitJA3FingerprintProperty rateLimitJA3FingerprintProperty = RateLimitJA3FingerprintProperty.builder()
     *         .fallbackBehavior("fallbackBehavior")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitja3fingerprint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitja3fingerprint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitJA3FingerprintProperty")
    @software.amazon.jsii.Jsii.Proxy(RateLimitJA3FingerprintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateLimitJA3FingerprintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA3 fingerprint.
         * <p>
         * You can specify the following fallback behaviors:
         * <p>
         * <ul>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitja3fingerprint.html#cfn-wafv2-webacl-ratelimitja3fingerprint-fallbackbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitja3fingerprint.html#cfn-wafv2-webacl-ratelimitja3fingerprint-fallbackbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFallbackBehavior();

        /**
         * @return a {@link Builder} of {@link RateLimitJA3FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateLimitJA3FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateLimitJA3FingerprintProperty> {
            java.lang.String fallbackBehavior;

            /**
             * Sets the value of {@link RateLimitJA3FingerprintProperty#getFallbackBehavior}
             * @param fallbackBehavior The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA3 fingerprint. This parameter is required.
             *                         You can specify the following fallback behaviors:
             *                         <p>
             *                         <ul>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fallbackBehavior(java.lang.String fallbackBehavior) {
                this.fallbackBehavior = fallbackBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateLimitJA3FingerprintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateLimitJA3FingerprintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateLimitJA3FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateLimitJA3FingerprintProperty {
            private final java.lang.String fallbackBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fallbackBehavior = software.amazon.jsii.Kernel.get(this, "fallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fallbackBehavior = java.util.Objects.requireNonNull(builder.fallbackBehavior, "fallbackBehavior is required");
            }

            @Override
            public final java.lang.String getFallbackBehavior() {
                return this.fallbackBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fallbackBehavior", om.valueToTree(this.getFallbackBehavior()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitJA3FingerprintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateLimitJA3FingerprintProperty.Jsii$Proxy that = (RateLimitJA3FingerprintProperty.Jsii$Proxy) o;

                return this.fallbackBehavior.equals(that.fallbackBehavior);
            }

            @Override
            public final int hashCode() {
                int result = this.fallbackBehavior.hashCode();
                return result;
            }
        }
    }
    /**
     * Use the request's JA4 fingerprint derived from the TLS Client Hello of an incoming request as an aggregate key.
     * <p>
     * If you use a single JA4 fingerprint as your custom key, then each value fully defines an aggregation instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RateLimitJA4FingerprintProperty rateLimitJA4FingerprintProperty = RateLimitJA4FingerprintProperty.builder()
     *         .fallbackBehavior("fallbackBehavior")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitja4fingerprint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitja4fingerprint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitJA4FingerprintProperty")
    @software.amazon.jsii.Jsii.Proxy(RateLimitJA4FingerprintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateLimitJA4FingerprintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA4 fingerprint.
         * <p>
         * You can specify the following fallback behaviors:
         * <p>
         * <ul>
         * <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
         * <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitja4fingerprint.html#cfn-wafv2-webacl-ratelimitja4fingerprint-fallbackbehavior">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitja4fingerprint.html#cfn-wafv2-webacl-ratelimitja4fingerprint-fallbackbehavior</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFallbackBehavior();

        /**
         * @return a {@link Builder} of {@link RateLimitJA4FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateLimitJA4FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateLimitJA4FingerprintProperty> {
            java.lang.String fallbackBehavior;

            /**
             * Sets the value of {@link RateLimitJA4FingerprintProperty#getFallbackBehavior}
             * @param fallbackBehavior The match status to assign to the web request if there is insufficient TSL Client Hello information to compute the JA4 fingerprint. This parameter is required.
             *                         You can specify the following fallback behaviors:
             *                         <p>
             *                         <ul>
             *                         <li><code>MATCH</code> - Treat the web request as matching the rule statement. AWS WAF applies the rule action to the request.</li>
             *                         <li><code>NO_MATCH</code> - Treat the web request as not matching the rule statement.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fallbackBehavior(java.lang.String fallbackBehavior) {
                this.fallbackBehavior = fallbackBehavior;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateLimitJA4FingerprintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateLimitJA4FingerprintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateLimitJA4FingerprintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateLimitJA4FingerprintProperty {
            private final java.lang.String fallbackBehavior;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fallbackBehavior = software.amazon.jsii.Kernel.get(this, "fallbackBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fallbackBehavior = java.util.Objects.requireNonNull(builder.fallbackBehavior, "fallbackBehavior is required");
            }

            @Override
            public final java.lang.String getFallbackBehavior() {
                return this.fallbackBehavior;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fallbackBehavior", om.valueToTree(this.getFallbackBehavior()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitJA4FingerprintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateLimitJA4FingerprintProperty.Jsii$Proxy that = (RateLimitJA4FingerprintProperty.Jsii$Proxy) o;

                return this.fallbackBehavior.equals(that.fallbackBehavior);
            }

            @Override
            public final int hashCode() {
                int result = this.fallbackBehavior.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies a label namespace to use as an aggregate key for a rate-based rule.
     * <p>
     * Each distinct fully qualified label name that has the specified label namespace contributes to the aggregation instance. If you use just one label namespace as your custom key, then each label name fully defines an aggregation instance.
     * <p>
     * This uses only labels that have been added to the request by rules that are evaluated before this rate-based rule in the web ACL.
     * <p>
     * For information about label namespaces and names, see <a href="https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-label-requirements.html">Label syntax and naming requirements</a> in the <em>AWS WAF Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RateLimitLabelNamespaceProperty rateLimitLabelNamespaceProperty = RateLimitLabelNamespaceProperty.builder()
     *         .namespace("namespace")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitlabelnamespace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitlabelnamespace.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitLabelNamespaceProperty")
    @software.amazon.jsii.Jsii.Proxy(RateLimitLabelNamespaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateLimitLabelNamespaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The namespace to use for aggregation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitlabelnamespace.html#cfn-wafv2-webacl-ratelimitlabelnamespace-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitlabelnamespace.html#cfn-wafv2-webacl-ratelimitlabelnamespace-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

        /**
         * @return a {@link Builder} of {@link RateLimitLabelNamespaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateLimitLabelNamespaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateLimitLabelNamespaceProperty> {
            java.lang.String namespace;

            /**
             * Sets the value of {@link RateLimitLabelNamespaceProperty#getNamespace}
             * @param namespace The namespace to use for aggregation. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateLimitLabelNamespaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateLimitLabelNamespaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateLimitLabelNamespaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateLimitLabelNamespaceProperty {
            private final java.lang.String namespace;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("namespace", om.valueToTree(this.getNamespace()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitLabelNamespaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateLimitLabelNamespaceProperty.Jsii$Proxy that = (RateLimitLabelNamespaceProperty.Jsii$Proxy) o;

                return this.namespace.equals(that.namespace);
            }

            @Override
            public final int hashCode() {
                int result = this.namespace.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies a query argument in the request as an aggregate key for a rate-based rule.
     * <p>
     * Each distinct value for the named query argument contributes to the aggregation instance. If you use a single query argument as your custom key, then each value fully defines an aggregation instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RateLimitQueryArgumentProperty rateLimitQueryArgumentProperty = RateLimitQueryArgumentProperty.builder()
     *         .name("name")
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitqueryargument.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitqueryargument.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitQueryArgumentProperty")
    @software.amazon.jsii.Jsii.Proxy(RateLimitQueryArgumentProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateLimitQueryArgumentProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the query argument to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitqueryargument.html#cfn-wafv2-webacl-ratelimitqueryargument-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitqueryargument.html#cfn-wafv2-webacl-ratelimitqueryargument-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitqueryargument.html#cfn-wafv2-webacl-ratelimitqueryargument-texttransformations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitqueryargument.html#cfn-wafv2-webacl-ratelimitqueryargument-texttransformations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link RateLimitQueryArgumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateLimitQueryArgumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateLimitQueryArgumentProperty> {
            java.lang.String name;
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link RateLimitQueryArgumentProperty#getName}
             * @param name The name of the query argument to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RateLimitQueryArgumentProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link RateLimitQueryArgumentProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateLimitQueryArgumentProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateLimitQueryArgumentProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateLimitQueryArgumentProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateLimitQueryArgumentProperty {
            private final java.lang.String name;
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitQueryArgumentProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateLimitQueryArgumentProperty.Jsii$Proxy that = (RateLimitQueryArgumentProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.textTransformations.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the request's query string as an aggregate key for a rate-based rule.
     * <p>
     * Each distinct string contributes to the aggregation instance. If you use just the query string as your custom key, then each string fully defines an aggregation instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RateLimitQueryStringProperty rateLimitQueryStringProperty = RateLimitQueryStringProperty.builder()
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitquerystring.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitquerystring.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitQueryStringProperty")
    @software.amazon.jsii.Jsii.Proxy(RateLimitQueryStringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateLimitQueryStringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitquerystring.html#cfn-wafv2-webacl-ratelimitquerystring-texttransformations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimitquerystring.html#cfn-wafv2-webacl-ratelimitquerystring-texttransformations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link RateLimitQueryStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateLimitQueryStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateLimitQueryStringProperty> {
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link RateLimitQueryStringProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link RateLimitQueryStringProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateLimitQueryStringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateLimitQueryStringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateLimitQueryStringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateLimitQueryStringProperty {
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitQueryStringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateLimitQueryStringProperty.Jsii$Proxy that = (RateLimitQueryStringProperty.Jsii$Proxy) o;

                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.textTransformations.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the request's URI path as an aggregate key for a rate-based rule.
     * <p>
     * Each distinct URI path contributes to the aggregation instance. If you use just the URI path as your custom key, then each URI path fully defines an aggregation instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RateLimitUriPathProperty rateLimitUriPathProperty = RateLimitUriPathProperty.builder()
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimituripath.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimituripath.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitUriPathProperty")
    @software.amazon.jsii.Jsii.Proxy(RateLimitUriPathProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RateLimitUriPathProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimituripath.html#cfn-wafv2-webacl-ratelimituripath-texttransformations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-ratelimituripath.html#cfn-wafv2-webacl-ratelimituripath-texttransformations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link RateLimitUriPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RateLimitUriPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RateLimitUriPathProperty> {
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link RateLimitUriPathProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link RateLimitUriPathProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            Text transformations are used in rule match statements, to transform the <code>FieldToMatch</code> request component before inspecting it, and they're used in rate-based rule statements, to transform request components before using them as custom aggregation keys. If you specify one or more transformations to apply, AWS WAF performs all transformations on the specified content, starting from the lowest priority setting, and then uses the transformed component contents.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RateLimitUriPathProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RateLimitUriPathProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RateLimitUriPathProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RateLimitUriPathProperty {
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RateLimitUriPathProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RateLimitUriPathProperty.Jsii$Proxy that = (RateLimitUriPathProperty.Jsii$Proxy) o;

                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.textTransformations.hashCode();
                return result;
            }
        }
    }
    /**
     * A rule statement used to search web request components for a match against a single regular expression.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * RegexMatchStatementProperty regexMatchStatementProperty = RegexMatchStatementProperty.builder()
     *         .fieldToMatch(FieldToMatchProperty.builder()
     *                 .allQueryArguments(allQueryArguments)
     *                 .body(BodyProperty.builder()
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .cookies(CookiesProperty.builder()
     *                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedCookies(List.of("excludedCookies"))
     *                                 .includedCookies(List.of("includedCookies"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .headers(HeadersProperty.builder()
     *                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                 .includedHeaders(List.of("includedHeaders"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .ja3Fingerprint(JA3FingerprintProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .build())
     *                 .ja4Fingerprint(JA4FingerprintProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .build())
     *                 .jsonBody(JsonBodyProperty.builder()
     *                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .includedPaths(List.of("includedPaths"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         // the properties below are optional
     *                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .method(method)
     *                 .queryString(queryString)
     *                 .singleHeader(singleHeader)
     *                 .singleQueryArgument(singleQueryArgument)
     *                 .uriFragment(UriFragmentProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .build())
     *                 .uriPath(uriPath)
     *                 .build())
     *         .regexString("regexString")
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RegexMatchStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(RegexMatchStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegexMatchStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The part of the web request that you want AWS WAF to inspect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html#cfn-wafv2-webacl-regexmatchstatement-fieldtomatch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html#cfn-wafv2-webacl-regexmatchstatement-fieldtomatch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldToMatch();

        /**
         * The string representing the regular expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html#cfn-wafv2-webacl-regexmatchstatement-regexstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html#cfn-wafv2-webacl-regexmatchstatement-regexstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegexString();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html#cfn-wafv2-webacl-regexmatchstatement-texttransformations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexmatchstatement.html#cfn-wafv2-webacl-regexmatchstatement-texttransformations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link RegexMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegexMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegexMatchStatementProperty> {
            java.lang.Object fieldToMatch;
            java.lang.String regexString;
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link RegexMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link RegexMatchStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link RegexMatchStatementProperty#getRegexString}
             * @param regexString The string representing the regular expression. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexString(java.lang.String regexString) {
                this.regexString = regexString;
                return this;
            }

            /**
             * Sets the value of {@link RegexMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link RegexMatchStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegexMatchStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegexMatchStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegexMatchStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegexMatchStatementProperty {
            private final java.lang.Object fieldToMatch;
            private final java.lang.String regexString;
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldToMatch = software.amazon.jsii.Kernel.get(this, "fieldToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regexString = software.amazon.jsii.Kernel.get(this, "regexString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldToMatch = java.util.Objects.requireNonNull(builder.fieldToMatch, "fieldToMatch is required");
                this.regexString = java.util.Objects.requireNonNull(builder.regexString, "regexString is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.Object getFieldToMatch() {
                return this.fieldToMatch;
            }

            @Override
            public final java.lang.String getRegexString() {
                return this.regexString;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldToMatch", om.valueToTree(this.getFieldToMatch()));
                data.set("regexString", om.valueToTree(this.getRegexString()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RegexMatchStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegexMatchStatementProperty.Jsii$Proxy that = (RegexMatchStatementProperty.Jsii$Proxy) o;

                if (!fieldToMatch.equals(that.fieldToMatch)) return false;
                if (!regexString.equals(that.regexString)) return false;
                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.fieldToMatch.hashCode();
                result = 31 * result + (this.regexString.hashCode());
                result = 31 * result + (this.textTransformations.hashCode());
                return result;
            }
        }
    }
    /**
     * A rule statement used to search web request components for matches with regular expressions.
     * <p>
     * To use this, create a <code>RegexPatternSet</code> that specifies the expressions that you want to detect, then use that set in this statement. A web request matches the pattern set rule statement if the request component matches any of the patterns in the set.
     * <p>
     * Each regex pattern set rule statement references a regex pattern set. You create and maintain the set independent of your rules. This allows you to use the single set in multiple rules. When you update the referenced set, AWS WAF automatically updates all rules that reference it.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * Object all;
     * Object allQueryArguments;
     * Object method;
     * Object queryString;
     * Object singleHeader;
     * Object singleQueryArgument;
     * Object uriPath;
     * RegexPatternSetReferenceStatementProperty regexPatternSetReferenceStatementProperty = RegexPatternSetReferenceStatementProperty.builder()
     *         .arn("arn")
     *         .fieldToMatch(FieldToMatchProperty.builder()
     *                 .allQueryArguments(allQueryArguments)
     *                 .body(BodyProperty.builder()
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .cookies(CookiesProperty.builder()
     *                         .matchPattern(CookieMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedCookies(List.of("excludedCookies"))
     *                                 .includedCookies(List.of("includedCookies"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .headers(HeadersProperty.builder()
     *                         .matchPattern(HeaderMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .excludedHeaders(List.of("excludedHeaders"))
     *                                 .includedHeaders(List.of("includedHeaders"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .ja3Fingerprint(JA3FingerprintProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .build())
     *                 .ja4Fingerprint(JA4FingerprintProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .build())
     *                 .jsonBody(JsonBodyProperty.builder()
     *                         .matchPattern(JsonMatchPatternProperty.builder()
     *                                 .all(all)
     *                                 .includedPaths(List.of("includedPaths"))
     *                                 .build())
     *                         .matchScope("matchScope")
     *                         // the properties below are optional
     *                         .invalidFallbackBehavior("invalidFallbackBehavior")
     *                         .oversizeHandling("oversizeHandling")
     *                         .build())
     *                 .method(method)
     *                 .queryString(queryString)
     *                 .singleHeader(singleHeader)
     *                 .singleQueryArgument(singleQueryArgument)
     *                 .uriFragment(UriFragmentProperty.builder()
     *                         .fallbackBehavior("fallbackBehavior")
     *                         .build())
     *                 .uriPath(uriPath)
     *                 .build())
     *         .textTransformations(List.of(TextTransformationProperty.builder()
     *                 .priority(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RegexPatternSetReferenceStatementProperty")
    @software.amazon.jsii.Jsii.Proxy(RegexPatternSetReferenceStatementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegexPatternSetReferenceStatementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the <code>RegexPatternSet</code> that this statement references.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The part of the web request that you want AWS WAF to inspect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-fieldtomatch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-fieldtomatch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldToMatch();

        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
         * <p>
         * If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-texttransformations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regexpatternsetreferencestatement.html#cfn-wafv2-webacl-regexpatternsetreferencestatement-texttransformations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTextTransformations();

        /**
         * @return a {@link Builder} of {@link RegexPatternSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegexPatternSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegexPatternSetReferenceStatementProperty> {
            java.lang.String arn;
            java.lang.Object fieldToMatch;
            java.lang.Object textTransformations;

            /**
             * Sets the value of {@link RegexPatternSetReferenceStatementProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the <code>RegexPatternSet</code> that this statement references. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link RegexPatternSetReferenceStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.IResolvable fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link RegexPatternSetReferenceStatementProperty#getFieldToMatch}
             * @param fieldToMatch The part of the web request that you want AWS WAF to inspect. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldToMatch(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldToMatchProperty fieldToMatch) {
                this.fieldToMatch = fieldToMatch;
                return this;
            }

            /**
             * Sets the value of {@link RegexPatternSetReferenceStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(software.amazon.awscdk.IResolvable textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Sets the value of {@link RegexPatternSetReferenceStatementProperty#getTextTransformations}
             * @param textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. This parameter is required.
             *                            If you specify one or more transformations in a rule statement, AWS WAF performs all transformations on the content of the request component identified by <code>FieldToMatch</code> , starting from the lowest priority setting, before inspecting the content for a match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder textTransformations(java.util.List<? extends java.lang.Object> textTransformations) {
                this.textTransformations = textTransformations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegexPatternSetReferenceStatementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegexPatternSetReferenceStatementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegexPatternSetReferenceStatementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegexPatternSetReferenceStatementProperty {
            private final java.lang.String arn;
            private final java.lang.Object fieldToMatch;
            private final java.lang.Object textTransformations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.fieldToMatch = software.amazon.jsii.Kernel.get(this, "fieldToMatch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.textTransformations = software.amazon.jsii.Kernel.get(this, "textTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.fieldToMatch = java.util.Objects.requireNonNull(builder.fieldToMatch, "fieldToMatch is required");
                this.textTransformations = java.util.Objects.requireNonNull(builder.textTransformations, "textTransformations is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.Object getFieldToMatch() {
                return this.fieldToMatch;
            }

            @Override
            public final java.lang.Object getTextTransformations() {
                return this.textTransformations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("fieldToMatch", om.valueToTree(this.getFieldToMatch()));
                data.set("textTransformations", om.valueToTree(this.getTextTransformations()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RegexPatternSetReferenceStatementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegexPatternSetReferenceStatementProperty.Jsii$Proxy that = (RegexPatternSetReferenceStatementProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                if (!fieldToMatch.equals(that.fieldToMatch)) return false;
                return this.textTransformations.equals(that.textTransformations);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.fieldToMatch.hashCode());
                result = 31 * result + (this.textTransformations.hashCode());
                return result;
            }
        }
    }
    /**
     * A single regular expression.
     * <p>
     * This is used in a <code>RegexPatternSet</code> and also in the configuration for the AWS Managed Rules rule group <code>AWSManagedRulesAntiDDoSRuleSet</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RegexProperty regexProperty = RegexProperty.builder()
     *         .regexString("regexString")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regex.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regex.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RegexProperty")
    @software.amazon.jsii.Jsii.Proxy(RegexProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RegexProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The string representing the regular expression.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regex.html#cfn-wafv2-webacl-regex-regexstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-regex.html#cfn-wafv2-webacl-regex-regexstring</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegexString() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RegexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RegexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RegexProperty> {
            java.lang.String regexString;

            /**
             * Sets the value of {@link RegexProperty#getRegexString}
             * @param regexString The string representing the regular expression.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexString(java.lang.String regexString) {
                this.regexString = regexString;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RegexProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RegexProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RegexProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RegexProperty {
            private final java.lang.String regexString;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.regexString = software.amazon.jsii.Kernel.get(this, "regexString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.regexString = builder.regexString;
            }

            @Override
            public final java.lang.String getRegexString() {
                return this.regexString;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRegexString() != null) {
                    data.set("regexString", om.valueToTree(this.getRegexString()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RegexProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RegexProperty.Jsii$Proxy that = (RegexProperty.Jsii$Proxy) o;

                return this.regexString != null ? this.regexString.equals(that.regexString) : that.regexString == null;
            }

            @Override
            public final int hashCode() {
                int result = this.regexString != null ? this.regexString.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Customizes the maximum size of the request body that your protected CloudFront, API Gateway, Amazon Cognito, App Runner, and Verified Access resources forward to AWS WAF for inspection.
     * <p>
     * The default size is 16 KB (16,384 bytes). You can change the setting for any of the available resource types.
     * <p>
     * <blockquote>
     * <p>
     * You are charged additional fees when your protected resources forward body sizes that are larger than the default. For more information, see <a href="https://docs.aws.amazon.com/waf/pricing/">AWS WAF Pricing</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example JSON: <code>{ "API_GATEWAY": "KB_48", "APP_RUNNER_SERVICE": "KB_32" }</code>
     * <p>
     * For Application Load Balancer and AWS AppSync , the limit is fixed at 8 KB (8,192 bytes).
     * <p>
     * This is used in the <code>AssociationConfig</code> of the web ACL.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RequestBodyAssociatedResourceTypeConfigProperty requestBodyAssociatedResourceTypeConfigProperty = RequestBodyAssociatedResourceTypeConfigProperty.builder()
     *         .defaultSizeInspectionLimit("defaultSizeInspectionLimit")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestbodyassociatedresourcetypeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestbodyassociatedresourcetypeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(RequestBodyAssociatedResourceTypeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RequestBodyAssociatedResourceTypeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resource should send to AWS WAF for inspection.
         * <p>
         * This applies to statements in the web ACL that inspect the body or JSON body.
         * <p>
         * Default: <code>16 KB (16,384 bytes)</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestbodyassociatedresourcetypeconfig.html#cfn-wafv2-webacl-requestbodyassociatedresourcetypeconfig-defaultsizeinspectionlimit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestbodyassociatedresourcetypeconfig.html#cfn-wafv2-webacl-requestbodyassociatedresourcetypeconfig-defaultsizeinspectionlimit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDefaultSizeInspectionLimit();

        /**
         * @return a {@link Builder} of {@link RequestBodyAssociatedResourceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RequestBodyAssociatedResourceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RequestBodyAssociatedResourceTypeConfigProperty> {
            java.lang.String defaultSizeInspectionLimit;

            /**
             * Sets the value of {@link RequestBodyAssociatedResourceTypeConfigProperty#getDefaultSizeInspectionLimit}
             * @param defaultSizeInspectionLimit Specifies the maximum size of the web request body component that an associated CloudFront, API Gateway, Amazon Cognito, App Runner, or Verified Access resource should send to AWS WAF for inspection. This parameter is required.
             *                                   This applies to statements in the web ACL that inspect the body or JSON body.
             *                                   <p>
             *                                   Default: <code>16 KB (16,384 bytes)</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultSizeInspectionLimit(java.lang.String defaultSizeInspectionLimit) {
                this.defaultSizeInspectionLimit = defaultSizeInspectionLimit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RequestBodyAssociatedResourceTypeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RequestBodyAssociatedResourceTypeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RequestBodyAssociatedResourceTypeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestBodyAssociatedResourceTypeConfigProperty {
            private final java.lang.String defaultSizeInspectionLimit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultSizeInspectionLimit = software.amazon.jsii.Kernel.get(this, "defaultSizeInspectionLimit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultSizeInspectionLimit = java.util.Objects.requireNonNull(builder.defaultSizeInspectionLimit, "defaultSizeInspectionLimit is required");
            }

            @Override
            public final java.lang.String getDefaultSizeInspectionLimit() {
                return this.defaultSizeInspectionLimit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("defaultSizeInspectionLimit", om.valueToTree(this.getDefaultSizeInspectionLimit()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RequestBodyAssociatedResourceTypeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RequestBodyAssociatedResourceTypeConfigProperty.Jsii$Proxy that = (RequestBodyAssociatedResourceTypeConfigProperty.Jsii$Proxy) o;

                return this.defaultSizeInspectionLimit.equals(that.defaultSizeInspectionLimit);
            }

            @Override
            public final int hashCode() {
                int result = this.defaultSizeInspectionLimit.hashCode();
                return result;
            }
        }
    }
    /**
     * The criteria for inspecting account creation requests, used by the ACFP rule group to validate and track account creation attempts.
     * <p>
     * This is part of the <code>AWSManagedRulesACFPRuleSet</code> configuration in <code>ManagedRuleGroupConfig</code> .
     * <p>
     * In these settings, you specify how your application accepts account creation attempts by providing the request payload type and the names of the fields within the request body where the username, password, email, and primary address and phone number fields are provided.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RequestInspectionACFPProperty requestInspectionACFPProperty = RequestInspectionACFPProperty.builder()
     *         .payloadType("payloadType")
     *         // the properties below are optional
     *         .addressFields(List.of(FieldIdentifierProperty.builder()
     *                 .identifier("identifier")
     *                 .build()))
     *         .emailField(FieldIdentifierProperty.builder()
     *                 .identifier("identifier")
     *                 .build())
     *         .passwordField(FieldIdentifierProperty.builder()
     *                 .identifier("identifier")
     *                 .build())
     *         .phoneNumberFields(List.of(FieldIdentifierProperty.builder()
     *                 .identifier("identifier")
     *                 .build()))
     *         .usernameField(FieldIdentifierProperty.builder()
     *                 .identifier("identifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RequestInspectionACFPProperty")
    @software.amazon.jsii.Jsii.Proxy(RequestInspectionACFPProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RequestInspectionACFPProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The payload type for your account creation endpoint, either JSON or form encoded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-payloadtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-payloadtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPayloadType();

        /**
         * The names of the fields in the request payload that contain your customer's primary physical address.
         * <p>
         * Order the address fields in the array exactly as they are ordered in the request payload.
         * <p>
         * How you specify the address fields depends on the request inspection payload type.
         * <p>
         * <ul>
         * <li>For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
         * </ul>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code> , the address field idenfiers are <code>/form/primaryaddressline1</code> , <code>/form/primaryaddressline2</code> , and <code>/form/primaryaddressline3</code> .
         * <p>
         * <ul>
         * <li>For form encoded payload types, use the HTML form names.</li>
         * </ul>
         * <p>
         * For example, for an HTML form with input elements named <code>primaryaddressline1</code> , <code>primaryaddressline2</code> , and <code>primaryaddressline3</code> , the address fields identifiers are <code>primaryaddressline1</code> , <code>primaryaddressline2</code> , and <code>primaryaddressline3</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-addressfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-addressfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAddressFields() {
            return null;
        }

        /**
         * The name of the field in the request payload that contains your customer's email.
         * <p>
         * How you specify this depends on the request inspection payload type.
         * <p>
         * <ul>
         * <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
         * </ul>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "email": "THE_EMAIL" } }</code> , the email field specification is <code>/form/email</code> .
         * <p>
         * <ul>
         * <li>For form encoded payload types, use the HTML form names.</li>
         * </ul>
         * <p>
         * For example, for an HTML form with the input element named <code>email1</code> , the email field specification is <code>email1</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-emailfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-emailfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEmailField() {
            return null;
        }

        /**
         * The name of the field in the request payload that contains your customer's password.
         * <p>
         * How you specify this depends on the request inspection payload type.
         * <p>
         * <ul>
         * <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
         * </ul>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code> , the password field specification is <code>/form/password</code> .
         * <p>
         * <ul>
         * <li>For form encoded payload types, use the HTML form names.</li>
         * </ul>
         * <p>
         * For example, for an HTML form with the input element named <code>password1</code> , the password field specification is <code>password1</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-passwordfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-passwordfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPasswordField() {
            return null;
        }

        /**
         * The names of the fields in the request payload that contain your customer's primary phone number.
         * <p>
         * Order the phone number fields in the array exactly as they are ordered in the request payload.
         * <p>
         * How you specify the phone number fields depends on the request inspection payload type.
         * <p>
         * <ul>
         * <li>For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
         * </ul>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code> , the phone number field identifiers are <code>/form/primaryphoneline1</code> , <code>/form/primaryphoneline2</code> , and <code>/form/primaryphoneline3</code> .
         * <p>
         * <ul>
         * <li>For form encoded payload types, use the HTML form names.</li>
         * </ul>
         * <p>
         * For example, for an HTML form with input elements named <code>primaryphoneline1</code> , <code>primaryphoneline2</code> , and <code>primaryphoneline3</code> , the phone number field identifiers are <code>primaryphoneline1</code> , <code>primaryphoneline2</code> , and <code>primaryphoneline3</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-phonenumberfields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-phonenumberfields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhoneNumberFields() {
            return null;
        }

        /**
         * The name of the field in the request payload that contains your customer's username.
         * <p>
         * How you specify this depends on the request inspection payload type.
         * <p>
         * <ul>
         * <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
         * </ul>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code> , the username field specification is <code>/form/username</code> .
         * <p>
         * <ul>
         * <li>For form encoded payload types, use the HTML form names.</li>
         * </ul>
         * <p>
         * For example, for an HTML form with the input element named <code>username1</code> , the username field specification is <code>username1</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-usernamefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspectionacfp.html#cfn-wafv2-webacl-requestinspectionacfp-usernamefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUsernameField() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RequestInspectionACFPProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RequestInspectionACFPProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RequestInspectionACFPProperty> {
            java.lang.String payloadType;
            java.lang.Object addressFields;
            java.lang.Object emailField;
            java.lang.Object passwordField;
            java.lang.Object phoneNumberFields;
            java.lang.Object usernameField;

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getPayloadType}
             * @param payloadType The payload type for your account creation endpoint, either JSON or form encoded. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadType(java.lang.String payloadType) {
                this.payloadType = payloadType;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getAddressFields}
             * @param addressFields The names of the fields in the request payload that contain your customer's primary physical address.
             *                      Order the address fields in the array exactly as they are ordered in the request payload.
             *                      <p>
             *                      How you specify the address fields depends on the request inspection payload type.
             *                      <p>
             *                      <ul>
             *                      <li>For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                      </ul>
             *                      <p>
             *                      For example, for the JSON payload <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code> , the address field idenfiers are <code>/form/primaryaddressline1</code> , <code>/form/primaryaddressline2</code> , and <code>/form/primaryaddressline3</code> .
             *                      <p>
             *                      <ul>
             *                      <li>For form encoded payload types, use the HTML form names.</li>
             *                      </ul>
             *                      <p>
             *                      For example, for an HTML form with input elements named <code>primaryaddressline1</code> , <code>primaryaddressline2</code> , and <code>primaryaddressline3</code> , the address fields identifiers are <code>primaryaddressline1</code> , <code>primaryaddressline2</code> , and <code>primaryaddressline3</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addressFields(software.amazon.awscdk.IResolvable addressFields) {
                this.addressFields = addressFields;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getAddressFields}
             * @param addressFields The names of the fields in the request payload that contain your customer's primary physical address.
             *                      Order the address fields in the array exactly as they are ordered in the request payload.
             *                      <p>
             *                      How you specify the address fields depends on the request inspection payload type.
             *                      <p>
             *                      <ul>
             *                      <li>For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                      </ul>
             *                      <p>
             *                      For example, for the JSON payload <code>{ "form": { "primaryaddressline1": "THE_ADDRESS1", "primaryaddressline2": "THE_ADDRESS2", "primaryaddressline3": "THE_ADDRESS3" } }</code> , the address field idenfiers are <code>/form/primaryaddressline1</code> , <code>/form/primaryaddressline2</code> , and <code>/form/primaryaddressline3</code> .
             *                      <p>
             *                      <ul>
             *                      <li>For form encoded payload types, use the HTML form names.</li>
             *                      </ul>
             *                      <p>
             *                      For example, for an HTML form with input elements named <code>primaryaddressline1</code> , <code>primaryaddressline2</code> , and <code>primaryaddressline3</code> , the address fields identifiers are <code>primaryaddressline1</code> , <code>primaryaddressline2</code> , and <code>primaryaddressline3</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder addressFields(java.util.List<? extends java.lang.Object> addressFields) {
                this.addressFields = addressFields;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getEmailField}
             * @param emailField The name of the field in the request payload that contains your customer's email.
             *                   How you specify this depends on the request inspection payload type.
             *                   <p>
             *                   <ul>
             *                   <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                   </ul>
             *                   <p>
             *                   For example, for the JSON payload <code>{ "form": { "email": "THE_EMAIL" } }</code> , the email field specification is <code>/form/email</code> .
             *                   <p>
             *                   <ul>
             *                   <li>For form encoded payload types, use the HTML form names.</li>
             *                   </ul>
             *                   <p>
             *                   For example, for an HTML form with the input element named <code>email1</code> , the email field specification is <code>email1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailField(software.amazon.awscdk.IResolvable emailField) {
                this.emailField = emailField;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getEmailField}
             * @param emailField The name of the field in the request payload that contains your customer's email.
             *                   How you specify this depends on the request inspection payload type.
             *                   <p>
             *                   <ul>
             *                   <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                   </ul>
             *                   <p>
             *                   For example, for the JSON payload <code>{ "form": { "email": "THE_EMAIL" } }</code> , the email field specification is <code>/form/email</code> .
             *                   <p>
             *                   <ul>
             *                   <li>For form encoded payload types, use the HTML form names.</li>
             *                   </ul>
             *                   <p>
             *                   For example, for an HTML form with the input element named <code>email1</code> , the email field specification is <code>email1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder emailField(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldIdentifierProperty emailField) {
                this.emailField = emailField;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getPasswordField}
             * @param passwordField The name of the field in the request payload that contains your customer's password.
             *                      How you specify this depends on the request inspection payload type.
             *                      <p>
             *                      <ul>
             *                      <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                      </ul>
             *                      <p>
             *                      For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code> , the password field specification is <code>/form/password</code> .
             *                      <p>
             *                      <ul>
             *                      <li>For form encoded payload types, use the HTML form names.</li>
             *                      </ul>
             *                      <p>
             *                      For example, for an HTML form with the input element named <code>password1</code> , the password field specification is <code>password1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passwordField(software.amazon.awscdk.IResolvable passwordField) {
                this.passwordField = passwordField;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getPasswordField}
             * @param passwordField The name of the field in the request payload that contains your customer's password.
             *                      How you specify this depends on the request inspection payload type.
             *                      <p>
             *                      <ul>
             *                      <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                      </ul>
             *                      <p>
             *                      For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code> , the password field specification is <code>/form/password</code> .
             *                      <p>
             *                      <ul>
             *                      <li>For form encoded payload types, use the HTML form names.</li>
             *                      </ul>
             *                      <p>
             *                      For example, for an HTML form with the input element named <code>password1</code> , the password field specification is <code>password1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passwordField(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldIdentifierProperty passwordField) {
                this.passwordField = passwordField;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getPhoneNumberFields}
             * @param phoneNumberFields The names of the fields in the request payload that contain your customer's primary phone number.
             *                          Order the phone number fields in the array exactly as they are ordered in the request payload.
             *                          <p>
             *                          How you specify the phone number fields depends on the request inspection payload type.
             *                          <p>
             *                          <ul>
             *                          <li>For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                          </ul>
             *                          <p>
             *                          For example, for the JSON payload <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code> , the phone number field identifiers are <code>/form/primaryphoneline1</code> , <code>/form/primaryphoneline2</code> , and <code>/form/primaryphoneline3</code> .
             *                          <p>
             *                          <ul>
             *                          <li>For form encoded payload types, use the HTML form names.</li>
             *                          </ul>
             *                          <p>
             *                          For example, for an HTML form with input elements named <code>primaryphoneline1</code> , <code>primaryphoneline2</code> , and <code>primaryphoneline3</code> , the phone number field identifiers are <code>primaryphoneline1</code> , <code>primaryphoneline2</code> , and <code>primaryphoneline3</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phoneNumberFields(software.amazon.awscdk.IResolvable phoneNumberFields) {
                this.phoneNumberFields = phoneNumberFields;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getPhoneNumberFields}
             * @param phoneNumberFields The names of the fields in the request payload that contain your customer's primary phone number.
             *                          Order the phone number fields in the array exactly as they are ordered in the request payload.
             *                          <p>
             *                          How you specify the phone number fields depends on the request inspection payload type.
             *                          <p>
             *                          <ul>
             *                          <li>For JSON payloads, specify the field identifiers in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                          </ul>
             *                          <p>
             *                          For example, for the JSON payload <code>{ "form": { "primaryphoneline1": "THE_PHONE1", "primaryphoneline2": "THE_PHONE2", "primaryphoneline3": "THE_PHONE3" } }</code> , the phone number field identifiers are <code>/form/primaryphoneline1</code> , <code>/form/primaryphoneline2</code> , and <code>/form/primaryphoneline3</code> .
             *                          <p>
             *                          <ul>
             *                          <li>For form encoded payload types, use the HTML form names.</li>
             *                          </ul>
             *                          <p>
             *                          For example, for an HTML form with input elements named <code>primaryphoneline1</code> , <code>primaryphoneline2</code> , and <code>primaryphoneline3</code> , the phone number field identifiers are <code>primaryphoneline1</code> , <code>primaryphoneline2</code> , and <code>primaryphoneline3</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phoneNumberFields(java.util.List<? extends java.lang.Object> phoneNumberFields) {
                this.phoneNumberFields = phoneNumberFields;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getUsernameField}
             * @param usernameField The name of the field in the request payload that contains your customer's username.
             *                      How you specify this depends on the request inspection payload type.
             *                      <p>
             *                      <ul>
             *                      <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                      </ul>
             *                      <p>
             *                      For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code> , the username field specification is <code>/form/username</code> .
             *                      <p>
             *                      <ul>
             *                      <li>For form encoded payload types, use the HTML form names.</li>
             *                      </ul>
             *                      <p>
             *                      For example, for an HTML form with the input element named <code>username1</code> , the username field specification is <code>username1</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernameField(software.amazon.awscdk.IResolvable usernameField) {
                this.usernameField = usernameField;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionACFPProperty#getUsernameField}
             * @param usernameField The name of the field in the request payload that contains your customer's username.
             *                      How you specify this depends on the request inspection payload type.
             *                      <p>
             *                      <ul>
             *                      <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                      </ul>
             *                      <p>
             *                      For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code> , the username field specification is <code>/form/username</code> .
             *                      <p>
             *                      <ul>
             *                      <li>For form encoded payload types, use the HTML form names.</li>
             *                      </ul>
             *                      <p>
             *                      For example, for an HTML form with the input element named <code>username1</code> , the username field specification is <code>username1</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernameField(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldIdentifierProperty usernameField) {
                this.usernameField = usernameField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RequestInspectionACFPProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RequestInspectionACFPProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RequestInspectionACFPProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestInspectionACFPProperty {
            private final java.lang.String payloadType;
            private final java.lang.Object addressFields;
            private final java.lang.Object emailField;
            private final java.lang.Object passwordField;
            private final java.lang.Object phoneNumberFields;
            private final java.lang.Object usernameField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.payloadType = software.amazon.jsii.Kernel.get(this, "payloadType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.addressFields = software.amazon.jsii.Kernel.get(this, "addressFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.emailField = software.amazon.jsii.Kernel.get(this, "emailField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.passwordField = software.amazon.jsii.Kernel.get(this, "passwordField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.phoneNumberFields = software.amazon.jsii.Kernel.get(this, "phoneNumberFields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.usernameField = software.amazon.jsii.Kernel.get(this, "usernameField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.payloadType = java.util.Objects.requireNonNull(builder.payloadType, "payloadType is required");
                this.addressFields = builder.addressFields;
                this.emailField = builder.emailField;
                this.passwordField = builder.passwordField;
                this.phoneNumberFields = builder.phoneNumberFields;
                this.usernameField = builder.usernameField;
            }

            @Override
            public final java.lang.String getPayloadType() {
                return this.payloadType;
            }

            @Override
            public final java.lang.Object getAddressFields() {
                return this.addressFields;
            }

            @Override
            public final java.lang.Object getEmailField() {
                return this.emailField;
            }

            @Override
            public final java.lang.Object getPasswordField() {
                return this.passwordField;
            }

            @Override
            public final java.lang.Object getPhoneNumberFields() {
                return this.phoneNumberFields;
            }

            @Override
            public final java.lang.Object getUsernameField() {
                return this.usernameField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("payloadType", om.valueToTree(this.getPayloadType()));
                if (this.getAddressFields() != null) {
                    data.set("addressFields", om.valueToTree(this.getAddressFields()));
                }
                if (this.getEmailField() != null) {
                    data.set("emailField", om.valueToTree(this.getEmailField()));
                }
                if (this.getPasswordField() != null) {
                    data.set("passwordField", om.valueToTree(this.getPasswordField()));
                }
                if (this.getPhoneNumberFields() != null) {
                    data.set("phoneNumberFields", om.valueToTree(this.getPhoneNumberFields()));
                }
                if (this.getUsernameField() != null) {
                    data.set("usernameField", om.valueToTree(this.getUsernameField()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RequestInspectionACFPProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RequestInspectionACFPProperty.Jsii$Proxy that = (RequestInspectionACFPProperty.Jsii$Proxy) o;

                if (!payloadType.equals(that.payloadType)) return false;
                if (this.addressFields != null ? !this.addressFields.equals(that.addressFields) : that.addressFields != null) return false;
                if (this.emailField != null ? !this.emailField.equals(that.emailField) : that.emailField != null) return false;
                if (this.passwordField != null ? !this.passwordField.equals(that.passwordField) : that.passwordField != null) return false;
                if (this.phoneNumberFields != null ? !this.phoneNumberFields.equals(that.phoneNumberFields) : that.phoneNumberFields != null) return false;
                return this.usernameField != null ? this.usernameField.equals(that.usernameField) : that.usernameField == null;
            }

            @Override
            public final int hashCode() {
                int result = this.payloadType.hashCode();
                result = 31 * result + (this.addressFields != null ? this.addressFields.hashCode() : 0);
                result = 31 * result + (this.emailField != null ? this.emailField.hashCode() : 0);
                result = 31 * result + (this.passwordField != null ? this.passwordField.hashCode() : 0);
                result = 31 * result + (this.phoneNumberFields != null ? this.phoneNumberFields.hashCode() : 0);
                result = 31 * result + (this.usernameField != null ? this.usernameField.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage.
     * <p>
     * This is part of the <code>AWSManagedRulesATPRuleSet</code> configuration in <code>ManagedRuleGroupConfig</code> .
     * <p>
     * In these settings, you specify how your application accepts login attempts by providing the request payload type and the names of the fields within the request body where the username and password are provided.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * RequestInspectionProperty requestInspectionProperty = RequestInspectionProperty.builder()
     *         .passwordField(FieldIdentifierProperty.builder()
     *                 .identifier("identifier")
     *                 .build())
     *         .payloadType("payloadType")
     *         .usernameField(FieldIdentifierProperty.builder()
     *                 .identifier("identifier")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.RequestInspectionProperty")
    @software.amazon.jsii.Jsii.Proxy(RequestInspectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RequestInspectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the field in the request payload that contains your customer's password.
         * <p>
         * How you specify this depends on the request inspection payload type.
         * <p>
         * <ul>
         * <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
         * </ul>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code> , the password field specification is <code>/form/password</code> .
         * <p>
         * <ul>
         * <li>For form encoded payload types, use the HTML form names.</li>
         * </ul>
         * <p>
         * For example, for an HTML form with the input element named <code>password1</code> , the password field specification is <code>password1</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html#cfn-wafv2-webacl-requestinspection-passwordfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html#cfn-wafv2-webacl-requestinspection-passwordfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPasswordField();

        /**
         * The payload type for your login endpoint, either JSON or form encoded.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html#cfn-wafv2-webacl-requestinspection-payloadtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html#cfn-wafv2-webacl-requestinspection-payloadtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPayloadType();

        /**
         * The name of the field in the request payload that contains your customer's username.
         * <p>
         * How you specify this depends on the request inspection payload type.
         * <p>
         * <ul>
         * <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
         * </ul>
         * <p>
         * For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code> , the username field specification is <code>/form/username</code> .
         * <p>
         * <ul>
         * <li>For form encoded payload types, use the HTML form names.</li>
         * </ul>
         * <p>
         * For example, for an HTML form with the input element named <code>username1</code> , the username field specification is <code>username1</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html#cfn-wafv2-webacl-requestinspection-usernamefield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-requestinspection.html#cfn-wafv2-webacl-requestinspection-usernamefield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getUsernameField();

        /**
         * @return a {@link Builder} of {@link RequestInspectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RequestInspectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RequestInspectionProperty> {
            java.lang.Object passwordField;
            java.lang.String payloadType;
            java.lang.Object usernameField;

            /**
             * Sets the value of {@link RequestInspectionProperty#getPasswordField}
             * @param passwordField The name of the field in the request payload that contains your customer's password. This parameter is required.
             *                      How you specify this depends on the request inspection payload type.
             *                      <p>
             *                      <ul>
             *                      <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                      </ul>
             *                      <p>
             *                      For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code> , the password field specification is <code>/form/password</code> .
             *                      <p>
             *                      <ul>
             *                      <li>For form encoded payload types, use the HTML form names.</li>
             *                      </ul>
             *                      <p>
             *                      For example, for an HTML form with the input element named <code>password1</code> , the password field specification is <code>password1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passwordField(software.amazon.awscdk.IResolvable passwordField) {
                this.passwordField = passwordField;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionProperty#getPasswordField}
             * @param passwordField The name of the field in the request payload that contains your customer's password. This parameter is required.
             *                      How you specify this depends on the request inspection payload type.
             *                      <p>
             *                      <ul>
             *                      <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                      </ul>
             *                      <p>
             *                      For example, for the JSON payload <code>{ "form": { "password": "THE_PASSWORD" } }</code> , the password field specification is <code>/form/password</code> .
             *                      <p>
             *                      <ul>
             *                      <li>For form encoded payload types, use the HTML form names.</li>
             *                      </ul>
             *                      <p>
             *                      For example, for an HTML form with the input element named <code>password1</code> , the password field specification is <code>password1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder passwordField(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldIdentifierProperty passwordField) {
                this.passwordField = passwordField;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionProperty#getPayloadType}
             * @param payloadType The payload type for your login endpoint, either JSON or form encoded. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadType(java.lang.String payloadType) {
                this.payloadType = payloadType;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionProperty#getUsernameField}
             * @param usernameField The name of the field in the request payload that contains your customer's username. This parameter is required.
             *                      How you specify this depends on the request inspection payload type.
             *                      <p>
             *                      <ul>
             *                      <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                      </ul>
             *                      <p>
             *                      For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code> , the username field specification is <code>/form/username</code> .
             *                      <p>
             *                      <ul>
             *                      <li>For form encoded payload types, use the HTML form names.</li>
             *                      </ul>
             *                      <p>
             *                      For example, for an HTML form with the input element named <code>username1</code> , the username field specification is <code>username1</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernameField(software.amazon.awscdk.IResolvable usernameField) {
                this.usernameField = usernameField;
                return this;
            }

            /**
             * Sets the value of {@link RequestInspectionProperty#getUsernameField}
             * @param usernameField The name of the field in the request payload that contains your customer's username. This parameter is required.
             *                      How you specify this depends on the request inspection payload type.
             *                      <p>
             *                      <ul>
             *                      <li>For JSON payloads, specify the field name in JSON pointer syntax. For information about the JSON Pointer syntax, see the Internet Engineering Task Force (IETF) documentation <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JavaScript Object Notation (JSON) Pointer</a> .</li>
             *                      </ul>
             *                      <p>
             *                      For example, for the JSON payload <code>{ "form": { "username": "THE_USERNAME" } }</code> , the username field specification is <code>/form/username</code> .
             *                      <p>
             *                      <ul>
             *                      <li>For form encoded payload types, use the HTML form names.</li>
             *                      </ul>
             *                      <p>
             *                      For example, for an HTML form with the input element named <code>username1</code> , the username field specification is <code>username1</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder usernameField(software.amazon.awscdk.services.wafv2.CfnWebACL.FieldIdentifierProperty usernameField) {
                this.usernameField = usernameField;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RequestInspectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RequestInspectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RequestInspectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RequestInspectionProperty {
            private final java.lang.Object passwordField;
            private final java.lang.String payloadType;
            private final java.lang.Object usernameField;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.passwordField = software.amazon.jsii.Kernel.get(this, "passwordField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.payloadType = software.amazon.jsii.Kernel.get(this, "payloadType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.usernameField = software.amazon.jsii.Kernel.get(this, "usernameField", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.passwordField = java.util.Objects.requireNonNull(builder.passwordField, "passwordField is required");
                this.payloadType = java.util.Objects.requireNonNull(builder.payloadType, "payloadType is required");
                this.usernameField = java.util.Objects.requireNonNull(builder.usernameField, "usernameField is required");
            }

            @Override
            public final java.lang.Object getPasswordField() {
                return this.passwordField;
            }

            @Override
            public final java.lang.String getPayloadType() {
                return this.payloadType;
            }

            @Override
            public final java.lang.Object getUsernameField() {
                return this.usernameField;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("passwordField", om.valueToTree(this.getPasswordField()));
                data.set("payloadType", om.valueToTree(this.getPayloadType()));
                data.set("usernameField", om.valueToTree(this.getUsernameField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.RequestInspectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RequestInspectionProperty.Jsii$Proxy that = (RequestInspectionProperty.Jsii$Proxy) o;

                if (!passwordField.equals(that.passwordField)) return false;
                if (!payloadType.equals(that.payloadType)) return false;
                return this.usernameField.equals(that.usernameField);
            }

            @Override
            public final int hashCode() {
                int result = this.passwordField.hashCode();
                result = 31 * result + (this.payloadType.hashCode());
                result = 31 * result + (this.usernameField.hashCode());
                return result;
            }
        }
    }
    /**
     * Configures inspection of the response body.
     * <p>
     * AWS WAF can inspect the first 65,536 bytes (64 KB) of the response body. This is part of the <code>ResponseInspection</code> configuration for <code>AWSManagedRulesATPRuleSet</code> and <code>AWSManagedRulesACFPRuleSet</code> .
     * <p>
     * <blockquote>
     * <p>
     * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ResponseInspectionBodyContainsProperty responseInspectionBodyContainsProperty = ResponseInspectionBodyContainsProperty.builder()
     *         .failureStrings(List.of("failureStrings"))
     *         .successStrings(List.of("successStrings"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionbodycontains.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionbodycontains.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty")
    @software.amazon.jsii.Jsii.Proxy(ResponseInspectionBodyContainsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResponseInspectionBodyContainsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Strings in the body of the response that indicate a failed login or account creation attempt.
         * <p>
         * To be counted as a failure, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.
         * <p>
         * JSON example: <code>"FailureStrings": [ "Request failed" ]</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionbodycontains.html#cfn-wafv2-webacl-responseinspectionbodycontains-failurestrings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionbodycontains.html#cfn-wafv2-webacl-responseinspectionbodycontains-failurestrings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getFailureStrings();

        /**
         * Strings in the body of the response that indicate a successful login or account creation attempt.
         * <p>
         * To be counted as a success, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.
         * <p>
         * JSON examples: <code>"SuccessStrings": [ "Login successful" ]</code> and <code>"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionbodycontains.html#cfn-wafv2-webacl-responseinspectionbodycontains-successstrings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionbodycontains.html#cfn-wafv2-webacl-responseinspectionbodycontains-successstrings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSuccessStrings();

        /**
         * @return a {@link Builder} of {@link ResponseInspectionBodyContainsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResponseInspectionBodyContainsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResponseInspectionBodyContainsProperty> {
            java.util.List<java.lang.String> failureStrings;
            java.util.List<java.lang.String> successStrings;

            /**
             * Sets the value of {@link ResponseInspectionBodyContainsProperty#getFailureStrings}
             * @param failureStrings Strings in the body of the response that indicate a failed login or account creation attempt. This parameter is required.
             *                       To be counted as a failure, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.
             *                       <p>
             *                       JSON example: <code>"FailureStrings": [ "Request failed" ]</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureStrings(java.util.List<java.lang.String> failureStrings) {
                this.failureStrings = failureStrings;
                return this;
            }

            /**
             * Sets the value of {@link ResponseInspectionBodyContainsProperty#getSuccessStrings}
             * @param successStrings Strings in the body of the response that indicate a successful login or account creation attempt. This parameter is required.
             *                       To be counted as a success, the string can be anywhere in the body and must be an exact match, including case. Each string must be unique among the success and failure strings.
             *                       <p>
             *                       JSON examples: <code>"SuccessStrings": [ "Login successful" ]</code> and <code>"SuccessStrings": [ "Account creation successful", "Welcome to our site!" ]</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successStrings(java.util.List<java.lang.String> successStrings) {
                this.successStrings = successStrings;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResponseInspectionBodyContainsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResponseInspectionBodyContainsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResponseInspectionBodyContainsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResponseInspectionBodyContainsProperty {
            private final java.util.List<java.lang.String> failureStrings;
            private final java.util.List<java.lang.String> successStrings;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failureStrings = software.amazon.jsii.Kernel.get(this, "failureStrings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.successStrings = software.amazon.jsii.Kernel.get(this, "successStrings", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failureStrings = java.util.Objects.requireNonNull(builder.failureStrings, "failureStrings is required");
                this.successStrings = java.util.Objects.requireNonNull(builder.successStrings, "successStrings is required");
            }

            @Override
            public final java.util.List<java.lang.String> getFailureStrings() {
                return this.failureStrings;
            }

            @Override
            public final java.util.List<java.lang.String> getSuccessStrings() {
                return this.successStrings;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("failureStrings", om.valueToTree(this.getFailureStrings()));
                data.set("successStrings", om.valueToTree(this.getSuccessStrings()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafv2.CfnWebACL.ResponseInspectionBodyContainsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResponseInspectionBodyContainsProperty.Jsii$Proxy that = (ResponseInspectionBodyContainsProperty.Jsii$Proxy) o;

                if (!failureStrings.equals(that.failureStrings)) return false;
                return this.successStrings.equals(that.successStrings);
            }

            @Override
            public final int hashCode() {
                int result = this.failureStrings.hashCode();
                result = 31 * result + (this.successStrings.hashCode());
                return result;
            }
        }
    }
    /**
     * Configures inspection of the response header. This is part of the <code>ResponseInspection</code> configuration for <code>AWSManagedRulesATPRuleSet</code> and <code>AWSManagedRulesACFPRuleSet</code> .
     * <p>
     * <blockquote>
     * <p>
     * Response inspection is available only in web ACLs that protect Amazon CloudFront distributions.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wafv2.*;
     * ResponseInspectionHeaderProperty responseInspectionHeaderProperty = ResponseInspectionHeaderProperty.builder()
     *         .failureValues(List.of("failureValues"))
     *         .name("name")
     *         .successValues(List.of("successValues"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafv2.CfnWebACL.ResponseInspectionHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(ResponseInspectionHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResponseInspectionHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Values in the response header with the specified name that indicate a failed login or account creation attempt.
         * <p>
         * To be counted as a failure, the value must be an exact match, including case. Each value must be unique among the success and failure values.
         * <p>
         * JSON examples: <code>"FailureValues": [ "LoginFailed", "Failed login" ]</code> and <code>"FailureValues": [ "AccountCreationFailed" ]</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html#cfn-wafv2-webacl-responseinspectionheader-failurevalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html#cfn-wafv2-webacl-responseinspectionheader-failurevalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getFailureValues();

        /**
         * The name of the header to match against. The name must be an exact match, including case.
         * <p>
         * JSON example: <code>"Name": [ "RequestResult" ]</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html#cfn-wafv2-webacl-responseinspectionheader-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html#cfn-wafv2-webacl-responseinspectionheader-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Values in the response header with the specified name that indicate a successful login or account creation attempt.
         * <p>
         * To be counted as a success, the value must be an exact match, including case. Each value must be unique among the success and failure values.
         * <p>
         * JSON examples: <code>"SuccessValues": [ "LoginPassed", "Successful login" ]</code> and <code>"SuccessValues": [ "AccountCreated", "Successful account creation" ]</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html#cfn-wafv2-webacl-responseinspectionheader-successvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wafv2-webacl-responseinspectionheader.html#cfn-wafv2-webacl-responseinspectionheader-successvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSuccessValues();

        /**
         * @return a {@link Builder} of {@link ResponseInspectionHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResponseInspectionHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResponseInspectionHeaderProperty> {
            java.util.List<java.lang.String> failureValues;
            java.lang.String name;
            java.util.List<java.lang.String> successValues;

            /**
             * Sets the value of {@link ResponseInspectionHeaderProperty#getFailureValues}
             * @param failureValues Values in the response header with the specified name that indicate a failed login or account creation attempt. This parameter is required.
             *                      To be counted as a failure, the value must be an exact match, including case. Each value must be unique among the success and failure values.
             *                      <p>
             *                      JSON examples: <code>"FailureValues": [ "LoginFailed", "Failed login" ]</code> and <code>"FailureValues": [ "AccountCreationFailed" ]</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureValues(java.util.List<java.lang.String> failureValues) {
                this.failureValues = failureValues;
                return this;
            }

            /**
             * Sets the value of {@link ResponseInspectionHeaderProperty#getName}
             * @param name The name of the header to match against. The name must be an exact match, including case. This parameter is required.
             *             JSON example: <code>"Name": [ "RequestResult" ]</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ResponseInspectionHeaderProperty#getSuccessValues}
             * @param successValues Values in the response header with the specified name that indicate a successful login or account creation attempt. This parameter is required.
             *                      To be counted as a success, the value must be an exact match, including case. Each value must be unique among the success and failure values.
             *                      <p>
             *                      JSON examples: <code>"SuccessValues": [ "LoginPassed", "Successful login" ]</code> and <code>"SuccessValues": [ "AccountCreated", "Successful account creation" ]</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successValues(java.util.List<java.lang.String> successValues) {
                this.successValues = successValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResponseInspectionHeaderProperty}
             * @throws NullPointerException if any required attribute was not provi