package software.amazon.awscdk.services.wisdom;

/**
 * Creates an Amazon Q in Connect AI Agent.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnAIAgent cfnAIAgent = CfnAIAgent.Builder.create(this, "MyCfnAIAgent")
 *         .assistantId("assistantId")
 *         .configuration(AIAgentConfigurationProperty.builder()
 *                 .answerRecommendationAiAgentConfiguration(AnswerRecommendationAIAgentConfigurationProperty.builder()
 *                         .answerGenerationAiGuardrailId("answerGenerationAiGuardrailId")
 *                         .answerGenerationAiPromptId("answerGenerationAiPromptId")
 *                         .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
 *                                 .associationConfigurationData(AssociationConfigurationDataProperty.builder()
 *                                         .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
 *                                                 .contentTagFilter(TagFilterProperty.builder()
 *                                                         .andConditions(List.of(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .orConditions(List.of(OrConditionProperty.builder()
 *                                                                 .andConditions(List.of(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .tagCondition(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .tagCondition(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .maxResults(123)
 *                                                 .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
 *                                                 .build())
 *                                         .build())
 *                                 .associationId("associationId")
 *                                 .associationType("associationType")
 *                                 .build()))
 *                         .intentLabelingGenerationAiPromptId("intentLabelingGenerationAiPromptId")
 *                         .locale("locale")
 *                         .queryReformulationAiPromptId("queryReformulationAiPromptId")
 *                         .build())
 *                 .manualSearchAiAgentConfiguration(ManualSearchAIAgentConfigurationProperty.builder()
 *                         .answerGenerationAiGuardrailId("answerGenerationAiGuardrailId")
 *                         .answerGenerationAiPromptId("answerGenerationAiPromptId")
 *                         .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
 *                                 .associationConfigurationData(AssociationConfigurationDataProperty.builder()
 *                                         .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
 *                                                 .contentTagFilter(TagFilterProperty.builder()
 *                                                         .andConditions(List.of(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .orConditions(List.of(OrConditionProperty.builder()
 *                                                                 .andConditions(List.of(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .tagCondition(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .tagCondition(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .maxResults(123)
 *                                                 .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
 *                                                 .build())
 *                                         .build())
 *                                 .associationId("associationId")
 *                                 .associationType("associationType")
 *                                 .build()))
 *                         .locale("locale")
 *                         .build())
 *                 .selfServiceAiAgentConfiguration(SelfServiceAIAgentConfigurationProperty.builder()
 *                         .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
 *                                 .associationConfigurationData(AssociationConfigurationDataProperty.builder()
 *                                         .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
 *                                                 .contentTagFilter(TagFilterProperty.builder()
 *                                                         .andConditions(List.of(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .orConditions(List.of(OrConditionProperty.builder()
 *                                                                 .andConditions(List.of(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build()))
 *                                                                 .tagCondition(TagConditionProperty.builder()
 *                                                                         .key("key")
 *                                                                         // the properties below are optional
 *                                                                         .value("value")
 *                                                                         .build())
 *                                                                 .build()))
 *                                                         .tagCondition(TagConditionProperty.builder()
 *                                                                 .key("key")
 *                                                                 // the properties below are optional
 *                                                                 .value("value")
 *                                                                 .build())
 *                                                         .build())
 *                                                 .maxResults(123)
 *                                                 .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
 *                                                 .build())
 *                                         .build())
 *                                 .associationId("associationId")
 *                                 .associationType("associationType")
 *                                 .build()))
 *                         .selfServiceAiGuardrailId("selfServiceAiGuardrailId")
 *                         .selfServiceAnswerGenerationAiPromptId("selfServiceAnswerGenerationAiPromptId")
 *                         .selfServicePreProcessingAiPromptId("selfServicePreProcessingAiPromptId")
 *                         .build())
 *                 .build())
 *         .type("type")
 *         // the properties below are optional
 *         .description("description")
 *         .name("name")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:46.191Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent")
public class CfnAIAgent extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnAIAgent(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAIAgent(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.wisdom.CfnAIAgent.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAIAgent(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wisdom.CfnAIAgentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the AI agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAiAgentArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAiAgentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the AI Agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAiAgentId() {
        return software.amazon.jsii.Kernel.get(this, "attrAiAgentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssistantArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAssistantArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrModifiedTimeSeconds() {
        return software.amazon.jsii.Kernel.get(this, "attrModifiedTimeSeconds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The identifier of the Amazon Q in Connect assistant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssistantId() {
        return software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Q in Connect assistant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssistantId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assistantId", java.util.Objects.requireNonNull(value, "assistantId is required"));
    }

    /**
     * Configuration for the AI Agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration for the AI Agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * Configuration for the AI Agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wisdom.CfnAIAgent.AIAgentConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", java.util.Objects.requireNonNull(value, "configuration is required"));
    }

    /**
     * The type of the AI Agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the AI Agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The description of the AI Agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the AI Agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the AI Agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the AI Agent.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * A typed union that specifies the configuration based on the type of AI Agent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AIAgentConfigurationProperty aIAgentConfigurationProperty = AIAgentConfigurationProperty.builder()
     *         .answerRecommendationAiAgentConfiguration(AnswerRecommendationAIAgentConfigurationProperty.builder()
     *                 .answerGenerationAiGuardrailId("answerGenerationAiGuardrailId")
     *                 .answerGenerationAiPromptId("answerGenerationAiPromptId")
     *                 .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
     *                         .associationConfigurationData(AssociationConfigurationDataProperty.builder()
     *                                 .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
     *                                         .contentTagFilter(TagFilterProperty.builder()
     *                                                 .andConditions(List.of(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .orConditions(List.of(OrConditionProperty.builder()
     *                                                         .andConditions(List.of(TagConditionProperty.builder()
     *                                                                 .key("key")
     *                                                                 // the properties below are optional
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .tagCondition(TagConditionProperty.builder()
     *                                                                 .key("key")
     *                                                                 // the properties below are optional
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .tagCondition(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         .maxResults(123)
     *                                         .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
     *                                         .build())
     *                                 .build())
     *                         .associationId("associationId")
     *                         .associationType("associationType")
     *                         .build()))
     *                 .intentLabelingGenerationAiPromptId("intentLabelingGenerationAiPromptId")
     *                 .locale("locale")
     *                 .queryReformulationAiPromptId("queryReformulationAiPromptId")
     *                 .build())
     *         .manualSearchAiAgentConfiguration(ManualSearchAIAgentConfigurationProperty.builder()
     *                 .answerGenerationAiGuardrailId("answerGenerationAiGuardrailId")
     *                 .answerGenerationAiPromptId("answerGenerationAiPromptId")
     *                 .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
     *                         .associationConfigurationData(AssociationConfigurationDataProperty.builder()
     *                                 .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
     *                                         .contentTagFilter(TagFilterProperty.builder()
     *                                                 .andConditions(List.of(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .orConditions(List.of(OrConditionProperty.builder()
     *                                                         .andConditions(List.of(TagConditionProperty.builder()
     *                                                                 .key("key")
     *                                                                 // the properties below are optional
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .tagCondition(TagConditionProperty.builder()
     *                                                                 .key("key")
     *                                                                 // the properties below are optional
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .tagCondition(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         .maxResults(123)
     *                                         .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
     *                                         .build())
     *                                 .build())
     *                         .associationId("associationId")
     *                         .associationType("associationType")
     *                         .build()))
     *                 .locale("locale")
     *                 .build())
     *         .selfServiceAiAgentConfiguration(SelfServiceAIAgentConfigurationProperty.builder()
     *                 .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
     *                         .associationConfigurationData(AssociationConfigurationDataProperty.builder()
     *                                 .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
     *                                         .contentTagFilter(TagFilterProperty.builder()
     *                                                 .andConditions(List.of(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .orConditions(List.of(OrConditionProperty.builder()
     *                                                         .andConditions(List.of(TagConditionProperty.builder()
     *                                                                 .key("key")
     *                                                                 // the properties below are optional
     *                                                                 .value("value")
     *                                                                 .build()))
     *                                                         .tagCondition(TagConditionProperty.builder()
     *                                                                 .key("key")
     *                                                                 // the properties below are optional
     *                                                                 .value("value")
     *                                                                 .build())
     *                                                         .build()))
     *                                                 .tagCondition(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build())
     *                                         .maxResults(123)
     *                                         .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
     *                                         .build())
     *                                 .build())
     *                         .associationId("associationId")
     *                         .associationType("associationType")
     *                         .build()))
     *                 .selfServiceAiGuardrailId("selfServiceAiGuardrailId")
     *                 .selfServiceAnswerGenerationAiPromptId("selfServiceAnswerGenerationAiPromptId")
     *                 .selfServicePreProcessingAiPromptId("selfServicePreProcessingAiPromptId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-aiagentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-aiagentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent.AIAgentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AIAgentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AIAgentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-aiagentconfiguration.html#cfn-wisdom-aiagent-aiagentconfiguration-answerrecommendationaiagentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-aiagentconfiguration.html#cfn-wisdom-aiagent-aiagentconfiguration-answerrecommendationaiagentconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnswerRecommendationAiAgentConfiguration() {
            return null;
        }

        /**
         * The configuration for AI Agents of type <code>MANUAL_SEARCH</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-aiagentconfiguration.html#cfn-wisdom-aiagent-aiagentconfiguration-manualsearchaiagentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-aiagentconfiguration.html#cfn-wisdom-aiagent-aiagentconfiguration-manualsearchaiagentconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManualSearchAiAgentConfiguration() {
            return null;
        }

        /**
         * The self-service AI agent configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-aiagentconfiguration.html#cfn-wisdom-aiagent-aiagentconfiguration-selfserviceaiagentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-aiagentconfiguration.html#cfn-wisdom-aiagent-aiagentconfiguration-selfserviceaiagentconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSelfServiceAiAgentConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AIAgentConfigurationProperty> {
            java.lang.Object answerRecommendationAiAgentConfiguration;
            java.lang.Object manualSearchAiAgentConfiguration;
            java.lang.Object selfServiceAiAgentConfiguration;

            /**
             * Sets the value of {@link AIAgentConfigurationProperty#getAnswerRecommendationAiAgentConfiguration}
             * @param answerRecommendationAiAgentConfiguration The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerRecommendationAiAgentConfiguration(software.amazon.awscdk.IResolvable answerRecommendationAiAgentConfiguration) {
                this.answerRecommendationAiAgentConfiguration = answerRecommendationAiAgentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AIAgentConfigurationProperty#getAnswerRecommendationAiAgentConfiguration}
             * @param answerRecommendationAiAgentConfiguration The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerRecommendationAiAgentConfiguration(software.amazon.awscdk.services.wisdom.CfnAIAgent.AnswerRecommendationAIAgentConfigurationProperty answerRecommendationAiAgentConfiguration) {
                this.answerRecommendationAiAgentConfiguration = answerRecommendationAiAgentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AIAgentConfigurationProperty#getManualSearchAiAgentConfiguration}
             * @param manualSearchAiAgentConfiguration The configuration for AI Agents of type <code>MANUAL_SEARCH</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manualSearchAiAgentConfiguration(software.amazon.awscdk.IResolvable manualSearchAiAgentConfiguration) {
                this.manualSearchAiAgentConfiguration = manualSearchAiAgentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AIAgentConfigurationProperty#getManualSearchAiAgentConfiguration}
             * @param manualSearchAiAgentConfiguration The configuration for AI Agents of type <code>MANUAL_SEARCH</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manualSearchAiAgentConfiguration(software.amazon.awscdk.services.wisdom.CfnAIAgent.ManualSearchAIAgentConfigurationProperty manualSearchAiAgentConfiguration) {
                this.manualSearchAiAgentConfiguration = manualSearchAiAgentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AIAgentConfigurationProperty#getSelfServiceAiAgentConfiguration}
             * @param selfServiceAiAgentConfiguration The self-service AI agent configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfServiceAiAgentConfiguration(software.amazon.awscdk.IResolvable selfServiceAiAgentConfiguration) {
                this.selfServiceAiAgentConfiguration = selfServiceAiAgentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link AIAgentConfigurationProperty#getSelfServiceAiAgentConfiguration}
             * @param selfServiceAiAgentConfiguration The self-service AI agent configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfServiceAiAgentConfiguration(software.amazon.awscdk.services.wisdom.CfnAIAgent.SelfServiceAIAgentConfigurationProperty selfServiceAiAgentConfiguration) {
                this.selfServiceAiAgentConfiguration = selfServiceAiAgentConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AIAgentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AIAgentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AIAgentConfigurationProperty {
            private final java.lang.Object answerRecommendationAiAgentConfiguration;
            private final java.lang.Object manualSearchAiAgentConfiguration;
            private final java.lang.Object selfServiceAiAgentConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.answerRecommendationAiAgentConfiguration = software.amazon.jsii.Kernel.get(this, "answerRecommendationAiAgentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.manualSearchAiAgentConfiguration = software.amazon.jsii.Kernel.get(this, "manualSearchAiAgentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.selfServiceAiAgentConfiguration = software.amazon.jsii.Kernel.get(this, "selfServiceAiAgentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.answerRecommendationAiAgentConfiguration = builder.answerRecommendationAiAgentConfiguration;
                this.manualSearchAiAgentConfiguration = builder.manualSearchAiAgentConfiguration;
                this.selfServiceAiAgentConfiguration = builder.selfServiceAiAgentConfiguration;
            }

            @Override
            public final java.lang.Object getAnswerRecommendationAiAgentConfiguration() {
                return this.answerRecommendationAiAgentConfiguration;
            }

            @Override
            public final java.lang.Object getManualSearchAiAgentConfiguration() {
                return this.manualSearchAiAgentConfiguration;
            }

            @Override
            public final java.lang.Object getSelfServiceAiAgentConfiguration() {
                return this.selfServiceAiAgentConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnswerRecommendationAiAgentConfiguration() != null) {
                    data.set("answerRecommendationAiAgentConfiguration", om.valueToTree(this.getAnswerRecommendationAiAgentConfiguration()));
                }
                if (this.getManualSearchAiAgentConfiguration() != null) {
                    data.set("manualSearchAiAgentConfiguration", om.valueToTree(this.getManualSearchAiAgentConfiguration()));
                }
                if (this.getSelfServiceAiAgentConfiguration() != null) {
                    data.set("selfServiceAiAgentConfiguration", om.valueToTree(this.getSelfServiceAiAgentConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgent.AIAgentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AIAgentConfigurationProperty.Jsii$Proxy that = (AIAgentConfigurationProperty.Jsii$Proxy) o;

                if (this.answerRecommendationAiAgentConfiguration != null ? !this.answerRecommendationAiAgentConfiguration.equals(that.answerRecommendationAiAgentConfiguration) : that.answerRecommendationAiAgentConfiguration != null) return false;
                if (this.manualSearchAiAgentConfiguration != null ? !this.manualSearchAiAgentConfiguration.equals(that.manualSearchAiAgentConfiguration) : that.manualSearchAiAgentConfiguration != null) return false;
                return this.selfServiceAiAgentConfiguration != null ? this.selfServiceAiAgentConfiguration.equals(that.selfServiceAiAgentConfiguration) : that.selfServiceAiAgentConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.answerRecommendationAiAgentConfiguration != null ? this.answerRecommendationAiAgentConfiguration.hashCode() : 0;
                result = 31 * result + (this.manualSearchAiAgentConfiguration != null ? this.manualSearchAiAgentConfiguration.hashCode() : 0);
                result = 31 * result + (this.selfServiceAiAgentConfiguration != null ? this.selfServiceAiAgentConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for AI Agents of type <code>ANSWER_RECOMMENDATION</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AnswerRecommendationAIAgentConfigurationProperty answerRecommendationAIAgentConfigurationProperty = AnswerRecommendationAIAgentConfigurationProperty.builder()
     *         .answerGenerationAiGuardrailId("answerGenerationAiGuardrailId")
     *         .answerGenerationAiPromptId("answerGenerationAiPromptId")
     *         .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
     *                 .associationConfigurationData(AssociationConfigurationDataProperty.builder()
     *                         .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
     *                                 .contentTagFilter(TagFilterProperty.builder()
     *                                         .andConditions(List.of(TagConditionProperty.builder()
     *                                                 .key("key")
     *                                                 // the properties below are optional
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .orConditions(List.of(OrConditionProperty.builder()
     *                                                 .andConditions(List.of(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .tagCondition(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .tagCondition(TagConditionProperty.builder()
     *                                                 .key("key")
     *                                                 // the properties below are optional
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 .maxResults(123)
     *                                 .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
     *                                 .build())
     *                         .build())
     *                 .associationId("associationId")
     *                 .associationType("associationType")
     *                 .build()))
     *         .intentLabelingGenerationAiPromptId("intentLabelingGenerationAiPromptId")
     *         .locale("locale")
     *         .queryReformulationAiPromptId("queryReformulationAiPromptId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent.AnswerRecommendationAIAgentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AnswerRecommendationAIAgentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AnswerRecommendationAIAgentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the answer generation AI guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-answergenerationaiguardrailid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-answergenerationaiguardrailid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAnswerGenerationAiGuardrailId() {
            return null;
        }

        /**
         * The AI Prompt identifier for the Answer Generation prompt used by the <code>ANSWER_RECOMMENDATION</code> AI Agent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-answergenerationaipromptid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-answergenerationaipromptid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAnswerGenerationAiPromptId() {
            return null;
        }

        /**
         * The association configurations for overriding behavior on this AI Agent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-associationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-associationconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociationConfigurations() {
            return null;
        }

        /**
         * The AI Prompt identifier for the Intent Labeling prompt used by the <code>ANSWER_RECOMMENDATION</code> AI Agent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-intentlabelinggenerationaipromptid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-intentlabelinggenerationaipromptid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIntentLabelingGenerationAiPromptId() {
            return null;
        }

        /**
         * The locale to which specifies the language and region settings that determine the response language for <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_QueryAssistant.html">QueryAssistant</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-locale">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-locale</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocale() {
            return null;
        }

        /**
         * The AI Prompt identifier for the Query Reformulation prompt used by the <code>ANSWER_RECOMMENDATION</code> AI Agent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-queryreformulationaipromptid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-answerrecommendationaiagentconfiguration.html#cfn-wisdom-aiagent-answerrecommendationaiagentconfiguration-queryreformulationaipromptid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getQueryReformulationAiPromptId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AnswerRecommendationAIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AnswerRecommendationAIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AnswerRecommendationAIAgentConfigurationProperty> {
            java.lang.String answerGenerationAiGuardrailId;
            java.lang.String answerGenerationAiPromptId;
            java.lang.Object associationConfigurations;
            java.lang.String intentLabelingGenerationAiPromptId;
            java.lang.String locale;
            java.lang.String queryReformulationAiPromptId;

            /**
             * Sets the value of {@link AnswerRecommendationAIAgentConfigurationProperty#getAnswerGenerationAiGuardrailId}
             * @param answerGenerationAiGuardrailId The ID of the answer generation AI guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerGenerationAiGuardrailId(java.lang.String answerGenerationAiGuardrailId) {
                this.answerGenerationAiGuardrailId = answerGenerationAiGuardrailId;
                return this;
            }

            /**
             * Sets the value of {@link AnswerRecommendationAIAgentConfigurationProperty#getAnswerGenerationAiPromptId}
             * @param answerGenerationAiPromptId The AI Prompt identifier for the Answer Generation prompt used by the <code>ANSWER_RECOMMENDATION</code> AI Agent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerGenerationAiPromptId(java.lang.String answerGenerationAiPromptId) {
                this.answerGenerationAiPromptId = answerGenerationAiPromptId;
                return this;
            }

            /**
             * Sets the value of {@link AnswerRecommendationAIAgentConfigurationProperty#getAssociationConfigurations}
             * @param associationConfigurations The association configurations for overriding behavior on this AI Agent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationConfigurations(software.amazon.awscdk.IResolvable associationConfigurations) {
                this.associationConfigurations = associationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link AnswerRecommendationAIAgentConfigurationProperty#getAssociationConfigurations}
             * @param associationConfigurations The association configurations for overriding behavior on this AI Agent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationConfigurations(java.util.List<? extends java.lang.Object> associationConfigurations) {
                this.associationConfigurations = associationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link AnswerRecommendationAIAgentConfigurationProperty#getIntentLabelingGenerationAiPromptId}
             * @param intentLabelingGenerationAiPromptId The AI Prompt identifier for the Intent Labeling prompt used by the <code>ANSWER_RECOMMENDATION</code> AI Agent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intentLabelingGenerationAiPromptId(java.lang.String intentLabelingGenerationAiPromptId) {
                this.intentLabelingGenerationAiPromptId = intentLabelingGenerationAiPromptId;
                return this;
            }

            /**
             * Sets the value of {@link AnswerRecommendationAIAgentConfigurationProperty#getLocale}
             * @param locale The locale to which specifies the language and region settings that determine the response language for <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_QueryAssistant.html">QueryAssistant</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locale(java.lang.String locale) {
                this.locale = locale;
                return this;
            }

            /**
             * Sets the value of {@link AnswerRecommendationAIAgentConfigurationProperty#getQueryReformulationAiPromptId}
             * @param queryReformulationAiPromptId The AI Prompt identifier for the Query Reformulation prompt used by the <code>ANSWER_RECOMMENDATION</code> AI Agent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryReformulationAiPromptId(java.lang.String queryReformulationAiPromptId) {
                this.queryReformulationAiPromptId = queryReformulationAiPromptId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AnswerRecommendationAIAgentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AnswerRecommendationAIAgentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AnswerRecommendationAIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AnswerRecommendationAIAgentConfigurationProperty {
            private final java.lang.String answerGenerationAiGuardrailId;
            private final java.lang.String answerGenerationAiPromptId;
            private final java.lang.Object associationConfigurations;
            private final java.lang.String intentLabelingGenerationAiPromptId;
            private final java.lang.String locale;
            private final java.lang.String queryReformulationAiPromptId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.answerGenerationAiGuardrailId = software.amazon.jsii.Kernel.get(this, "answerGenerationAiGuardrailId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.answerGenerationAiPromptId = software.amazon.jsii.Kernel.get(this, "answerGenerationAiPromptId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.associationConfigurations = software.amazon.jsii.Kernel.get(this, "associationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.intentLabelingGenerationAiPromptId = software.amazon.jsii.Kernel.get(this, "intentLabelingGenerationAiPromptId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.locale = software.amazon.jsii.Kernel.get(this, "locale", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryReformulationAiPromptId = software.amazon.jsii.Kernel.get(this, "queryReformulationAiPromptId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.answerGenerationAiGuardrailId = builder.answerGenerationAiGuardrailId;
                this.answerGenerationAiPromptId = builder.answerGenerationAiPromptId;
                this.associationConfigurations = builder.associationConfigurations;
                this.intentLabelingGenerationAiPromptId = builder.intentLabelingGenerationAiPromptId;
                this.locale = builder.locale;
                this.queryReformulationAiPromptId = builder.queryReformulationAiPromptId;
            }

            @Override
            public final java.lang.String getAnswerGenerationAiGuardrailId() {
                return this.answerGenerationAiGuardrailId;
            }

            @Override
            public final java.lang.String getAnswerGenerationAiPromptId() {
                return this.answerGenerationAiPromptId;
            }

            @Override
            public final java.lang.Object getAssociationConfigurations() {
                return this.associationConfigurations;
            }

            @Override
            public final java.lang.String getIntentLabelingGenerationAiPromptId() {
                return this.intentLabelingGenerationAiPromptId;
            }

            @Override
            public final java.lang.String getLocale() {
                return this.locale;
            }

            @Override
            public final java.lang.String getQueryReformulationAiPromptId() {
                return this.queryReformulationAiPromptId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnswerGenerationAiGuardrailId() != null) {
                    data.set("answerGenerationAiGuardrailId", om.valueToTree(this.getAnswerGenerationAiGuardrailId()));
                }
                if (this.getAnswerGenerationAiPromptId() != null) {
                    data.set("answerGenerationAiPromptId", om.valueToTree(this.getAnswerGenerationAiPromptId()));
                }
                if (this.getAssociationConfigurations() != null) {
                    data.set("associationConfigurations", om.valueToTree(this.getAssociationConfigurations()));
                }
                if (this.getIntentLabelingGenerationAiPromptId() != null) {
                    data.set("intentLabelingGenerationAiPromptId", om.valueToTree(this.getIntentLabelingGenerationAiPromptId()));
                }
                if (this.getLocale() != null) {
                    data.set("locale", om.valueToTree(this.getLocale()));
                }
                if (this.getQueryReformulationAiPromptId() != null) {
                    data.set("queryReformulationAiPromptId", om.valueToTree(this.getQueryReformulationAiPromptId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgent.AnswerRecommendationAIAgentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AnswerRecommendationAIAgentConfigurationProperty.Jsii$Proxy that = (AnswerRecommendationAIAgentConfigurationProperty.Jsii$Proxy) o;

                if (this.answerGenerationAiGuardrailId != null ? !this.answerGenerationAiGuardrailId.equals(that.answerGenerationAiGuardrailId) : that.answerGenerationAiGuardrailId != null) return false;
                if (this.answerGenerationAiPromptId != null ? !this.answerGenerationAiPromptId.equals(that.answerGenerationAiPromptId) : that.answerGenerationAiPromptId != null) return false;
                if (this.associationConfigurations != null ? !this.associationConfigurations.equals(that.associationConfigurations) : that.associationConfigurations != null) return false;
                if (this.intentLabelingGenerationAiPromptId != null ? !this.intentLabelingGenerationAiPromptId.equals(that.intentLabelingGenerationAiPromptId) : that.intentLabelingGenerationAiPromptId != null) return false;
                if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) return false;
                return this.queryReformulationAiPromptId != null ? this.queryReformulationAiPromptId.equals(that.queryReformulationAiPromptId) : that.queryReformulationAiPromptId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.answerGenerationAiGuardrailId != null ? this.answerGenerationAiGuardrailId.hashCode() : 0;
                result = 31 * result + (this.answerGenerationAiPromptId != null ? this.answerGenerationAiPromptId.hashCode() : 0);
                result = 31 * result + (this.associationConfigurations != null ? this.associationConfigurations.hashCode() : 0);
                result = 31 * result + (this.intentLabelingGenerationAiPromptId != null ? this.intentLabelingGenerationAiPromptId.hashCode() : 0);
                result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
                result = 31 * result + (this.queryReformulationAiPromptId != null ? this.queryReformulationAiPromptId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A typed union of the data of the configuration for an Amazon Q in Connect Assistant Association.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AssociationConfigurationDataProperty associationConfigurationDataProperty = AssociationConfigurationDataProperty.builder()
     *         .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
     *                 .contentTagFilter(TagFilterProperty.builder()
     *                         .andConditions(List.of(TagConditionProperty.builder()
     *                                 .key("key")
     *                                 // the properties below are optional
     *                                 .value("value")
     *                                 .build()))
     *                         .orConditions(List.of(OrConditionProperty.builder()
     *                                 .andConditions(List.of(TagConditionProperty.builder()
     *                                         .key("key")
     *                                         // the properties below are optional
     *                                         .value("value")
     *                                         .build()))
     *                                 .tagCondition(TagConditionProperty.builder()
     *                                         .key("key")
     *                                         // the properties below are optional
     *                                         .value("value")
     *                                         .build())
     *                                 .build()))
     *                         .tagCondition(TagConditionProperty.builder()
     *                                 .key("key")
     *                                 // the properties below are optional
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 .maxResults(123)
     *                 .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfigurationdata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfigurationdata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent.AssociationConfigurationDataProperty")
    @software.amazon.jsii.Jsii.Proxy(AssociationConfigurationDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssociationConfigurationDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant Association.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfigurationdata.html#cfn-wisdom-aiagent-associationconfigurationdata-knowledgebaseassociationconfigurationdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfigurationdata.html#cfn-wisdom-aiagent-associationconfigurationdata-knowledgebaseassociationconfigurationdata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getKnowledgeBaseAssociationConfigurationData();

        /**
         * @return a {@link Builder} of {@link AssociationConfigurationDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssociationConfigurationDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssociationConfigurationDataProperty> {
            java.lang.Object knowledgeBaseAssociationConfigurationData;

            /**
             * Sets the value of {@link AssociationConfigurationDataProperty#getKnowledgeBaseAssociationConfigurationData}
             * @param knowledgeBaseAssociationConfigurationData The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant Association. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeBaseAssociationConfigurationData(software.amazon.awscdk.IResolvable knowledgeBaseAssociationConfigurationData) {
                this.knowledgeBaseAssociationConfigurationData = knowledgeBaseAssociationConfigurationData;
                return this;
            }

            /**
             * Sets the value of {@link AssociationConfigurationDataProperty#getKnowledgeBaseAssociationConfigurationData}
             * @param knowledgeBaseAssociationConfigurationData The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant Association. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeBaseAssociationConfigurationData(software.amazon.awscdk.services.wisdom.CfnAIAgent.KnowledgeBaseAssociationConfigurationDataProperty knowledgeBaseAssociationConfigurationData) {
                this.knowledgeBaseAssociationConfigurationData = knowledgeBaseAssociationConfigurationData;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssociationConfigurationDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssociationConfigurationDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssociationConfigurationDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssociationConfigurationDataProperty {
            private final java.lang.Object knowledgeBaseAssociationConfigurationData;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.knowledgeBaseAssociationConfigurationData = software.amazon.jsii.Kernel.get(this, "knowledgeBaseAssociationConfigurationData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.knowledgeBaseAssociationConfigurationData = java.util.Objects.requireNonNull(builder.knowledgeBaseAssociationConfigurationData, "knowledgeBaseAssociationConfigurationData is required");
            }

            @Override
            public final java.lang.Object getKnowledgeBaseAssociationConfigurationData() {
                return this.knowledgeBaseAssociationConfigurationData;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("knowledgeBaseAssociationConfigurationData", om.valueToTree(this.getKnowledgeBaseAssociationConfigurationData()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgent.AssociationConfigurationDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssociationConfigurationDataProperty.Jsii$Proxy that = (AssociationConfigurationDataProperty.Jsii$Proxy) o;

                return this.knowledgeBaseAssociationConfigurationData.equals(that.knowledgeBaseAssociationConfigurationData);
            }

            @Override
            public final int hashCode() {
                int result = this.knowledgeBaseAssociationConfigurationData.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration for an Amazon Q in Connect Assistant Association.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AssociationConfigurationProperty associationConfigurationProperty = AssociationConfigurationProperty.builder()
     *         .associationConfigurationData(AssociationConfigurationDataProperty.builder()
     *                 .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
     *                         .contentTagFilter(TagFilterProperty.builder()
     *                                 .andConditions(List.of(TagConditionProperty.builder()
     *                                         .key("key")
     *                                         // the properties below are optional
     *                                         .value("value")
     *                                         .build()))
     *                                 .orConditions(List.of(OrConditionProperty.builder()
     *                                         .andConditions(List.of(TagConditionProperty.builder()
     *                                                 .key("key")
     *                                                 // the properties below are optional
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .tagCondition(TagConditionProperty.builder()
     *                                                 .key("key")
     *                                                 // the properties below are optional
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build()))
     *                                 .tagCondition(TagConditionProperty.builder()
     *                                         .key("key")
     *                                         // the properties below are optional
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         .maxResults(123)
     *                         .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
     *                         .build())
     *                 .build())
     *         .associationId("associationId")
     *         .associationType("associationType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent.AssociationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AssociationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssociationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A typed union of the data of the configuration for an Amazon Q in Connect Assistant Association.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfiguration.html#cfn-wisdom-aiagent-associationconfiguration-associationconfigurationdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfiguration.html#cfn-wisdom-aiagent-associationconfiguration-associationconfigurationdata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociationConfigurationData() {
            return null;
        }

        /**
         * The identifier of the association for this Association Configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfiguration.html#cfn-wisdom-aiagent-associationconfiguration-associationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfiguration.html#cfn-wisdom-aiagent-associationconfiguration-associationid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssociationId() {
            return null;
        }

        /**
         * The type of the association for this Association Configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfiguration.html#cfn-wisdom-aiagent-associationconfiguration-associationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-associationconfiguration.html#cfn-wisdom-aiagent-associationconfiguration-associationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssociationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssociationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssociationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssociationConfigurationProperty> {
            java.lang.Object associationConfigurationData;
            java.lang.String associationId;
            java.lang.String associationType;

            /**
             * Sets the value of {@link AssociationConfigurationProperty#getAssociationConfigurationData}
             * @param associationConfigurationData A typed union of the data of the configuration for an Amazon Q in Connect Assistant Association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationConfigurationData(software.amazon.awscdk.IResolvable associationConfigurationData) {
                this.associationConfigurationData = associationConfigurationData;
                return this;
            }

            /**
             * Sets the value of {@link AssociationConfigurationProperty#getAssociationConfigurationData}
             * @param associationConfigurationData A typed union of the data of the configuration for an Amazon Q in Connect Assistant Association.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationConfigurationData(software.amazon.awscdk.services.wisdom.CfnAIAgent.AssociationConfigurationDataProperty associationConfigurationData) {
                this.associationConfigurationData = associationConfigurationData;
                return this;
            }

            /**
             * Sets the value of {@link AssociationConfigurationProperty#getAssociationId}
             * @param associationId The identifier of the association for this Association Configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationId(java.lang.String associationId) {
                this.associationId = associationId;
                return this;
            }

            /**
             * Sets the value of {@link AssociationConfigurationProperty#getAssociationType}
             * @param associationType The type of the association for this Association Configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationType(java.lang.String associationType) {
                this.associationType = associationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssociationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssociationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssociationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssociationConfigurationProperty {
            private final java.lang.Object associationConfigurationData;
            private final java.lang.String associationId;
            private final java.lang.String associationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.associationConfigurationData = software.amazon.jsii.Kernel.get(this, "associationConfigurationData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.associationId = software.amazon.jsii.Kernel.get(this, "associationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.associationType = software.amazon.jsii.Kernel.get(this, "associationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.associationConfigurationData = builder.associationConfigurationData;
                this.associationId = builder.associationId;
                this.associationType = builder.associationType;
            }

            @Override
            public final java.lang.Object getAssociationConfigurationData() {
                return this.associationConfigurationData;
            }

            @Override
            public final java.lang.String getAssociationId() {
                return this.associationId;
            }

            @Override
            public final java.lang.String getAssociationType() {
                return this.associationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssociationConfigurationData() != null) {
                    data.set("associationConfigurationData", om.valueToTree(this.getAssociationConfigurationData()));
                }
                if (this.getAssociationId() != null) {
                    data.set("associationId", om.valueToTree(this.getAssociationId()));
                }
                if (this.getAssociationType() != null) {
                    data.set("associationType", om.valueToTree(this.getAssociationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgent.AssociationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssociationConfigurationProperty.Jsii$Proxy that = (AssociationConfigurationProperty.Jsii$Proxy) o;

                if (this.associationConfigurationData != null ? !this.associationConfigurationData.equals(that.associationConfigurationData) : that.associationConfigurationData != null) return false;
                if (this.associationId != null ? !this.associationId.equals(that.associationId) : that.associationId != null) return false;
                return this.associationType != null ? this.associationType.equals(that.associationType) : that.associationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.associationConfigurationData != null ? this.associationConfigurationData.hashCode() : 0;
                result = 31 * result + (this.associationId != null ? this.associationId.hashCode() : 0);
                result = 31 * result + (this.associationType != null ? this.associationType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The data of the configuration for a <code>KNOWLEDGE_BASE</code> type Amazon Q in Connect Assistant Association.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * KnowledgeBaseAssociationConfigurationDataProperty knowledgeBaseAssociationConfigurationDataProperty = KnowledgeBaseAssociationConfigurationDataProperty.builder()
     *         .contentTagFilter(TagFilterProperty.builder()
     *                 .andConditions(List.of(TagConditionProperty.builder()
     *                         .key("key")
     *                         // the properties below are optional
     *                         .value("value")
     *                         .build()))
     *                 .orConditions(List.of(OrConditionProperty.builder()
     *                         .andConditions(List.of(TagConditionProperty.builder()
     *                                 .key("key")
     *                                 // the properties below are optional
     *                                 .value("value")
     *                                 .build()))
     *                         .tagCondition(TagConditionProperty.builder()
     *                                 .key("key")
     *                                 // the properties below are optional
     *                                 .value("value")
     *                                 .build())
     *                         .build()))
     *                 .tagCondition(TagConditionProperty.builder()
     *                         .key("key")
     *                         // the properties below are optional
     *                         .value("value")
     *                         .build())
     *                 .build())
     *         .maxResults(123)
     *         .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-knowledgebaseassociationconfigurationdata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-knowledgebaseassociationconfigurationdata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent.KnowledgeBaseAssociationConfigurationDataProperty")
    @software.amazon.jsii.Jsii.Proxy(KnowledgeBaseAssociationConfigurationDataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KnowledgeBaseAssociationConfigurationDataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that can be used to specify Tag conditions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-knowledgebaseassociationconfigurationdata.html#cfn-wisdom-aiagent-knowledgebaseassociationconfigurationdata-contenttagfilter">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-knowledgebaseassociationconfigurationdata.html#cfn-wisdom-aiagent-knowledgebaseassociationconfigurationdata-contenttagfilter</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getContentTagFilter() {
            return null;
        }

        /**
         * The maximum number of results to return per page.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-knowledgebaseassociationconfigurationdata.html#cfn-wisdom-aiagent-knowledgebaseassociationconfigurationdata-maxresults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-knowledgebaseassociationconfigurationdata.html#cfn-wisdom-aiagent-knowledgebaseassociationconfigurationdata-maxresults</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxResults() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-knowledgebaseassociationconfigurationdata.html#cfn-wisdom-aiagent-knowledgebaseassociationconfigurationdata-overrideknowledgebasesearchtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-knowledgebaseassociationconfigurationdata.html#cfn-wisdom-aiagent-knowledgebaseassociationconfigurationdata-overrideknowledgebasesearchtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOverrideKnowledgeBaseSearchType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KnowledgeBaseAssociationConfigurationDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KnowledgeBaseAssociationConfigurationDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KnowledgeBaseAssociationConfigurationDataProperty> {
            java.lang.Object contentTagFilter;
            java.lang.Number maxResults;
            java.lang.String overrideKnowledgeBaseSearchType;

            /**
             * Sets the value of {@link KnowledgeBaseAssociationConfigurationDataProperty#getContentTagFilter}
             * @param contentTagFilter An object that can be used to specify Tag conditions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentTagFilter(software.amazon.awscdk.IResolvable contentTagFilter) {
                this.contentTagFilter = contentTagFilter;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseAssociationConfigurationDataProperty#getContentTagFilter}
             * @param contentTagFilter An object that can be used to specify Tag conditions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder contentTagFilter(software.amazon.awscdk.services.wisdom.CfnAIAgent.TagFilterProperty contentTagFilter) {
                this.contentTagFilter = contentTagFilter;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseAssociationConfigurationDataProperty#getMaxResults}
             * @param maxResults The maximum number of results to return per page.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxResults(java.lang.Number maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseAssociationConfigurationDataProperty#getOverrideKnowledgeBaseSearchType}
             * @param overrideKnowledgeBaseSearchType the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrideKnowledgeBaseSearchType(java.lang.String overrideKnowledgeBaseSearchType) {
                this.overrideKnowledgeBaseSearchType = overrideKnowledgeBaseSearchType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KnowledgeBaseAssociationConfigurationDataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KnowledgeBaseAssociationConfigurationDataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KnowledgeBaseAssociationConfigurationDataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KnowledgeBaseAssociationConfigurationDataProperty {
            private final java.lang.Object contentTagFilter;
            private final java.lang.Number maxResults;
            private final java.lang.String overrideKnowledgeBaseSearchType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.contentTagFilter = software.amazon.jsii.Kernel.get(this, "contentTagFilter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxResults = software.amazon.jsii.Kernel.get(this, "maxResults", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.overrideKnowledgeBaseSearchType = software.amazon.jsii.Kernel.get(this, "overrideKnowledgeBaseSearchType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.contentTagFilter = builder.contentTagFilter;
                this.maxResults = builder.maxResults;
                this.overrideKnowledgeBaseSearchType = builder.overrideKnowledgeBaseSearchType;
            }

            @Override
            public final java.lang.Object getContentTagFilter() {
                return this.contentTagFilter;
            }

            @Override
            public final java.lang.Number getMaxResults() {
                return this.maxResults;
            }

            @Override
            public final java.lang.String getOverrideKnowledgeBaseSearchType() {
                return this.overrideKnowledgeBaseSearchType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContentTagFilter() != null) {
                    data.set("contentTagFilter", om.valueToTree(this.getContentTagFilter()));
                }
                if (this.getMaxResults() != null) {
                    data.set("maxResults", om.valueToTree(this.getMaxResults()));
                }
                if (this.getOverrideKnowledgeBaseSearchType() != null) {
                    data.set("overrideKnowledgeBaseSearchType", om.valueToTree(this.getOverrideKnowledgeBaseSearchType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgent.KnowledgeBaseAssociationConfigurationDataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KnowledgeBaseAssociationConfigurationDataProperty.Jsii$Proxy that = (KnowledgeBaseAssociationConfigurationDataProperty.Jsii$Proxy) o;

                if (this.contentTagFilter != null ? !this.contentTagFilter.equals(that.contentTagFilter) : that.contentTagFilter != null) return false;
                if (this.maxResults != null ? !this.maxResults.equals(that.maxResults) : that.maxResults != null) return false;
                return this.overrideKnowledgeBaseSearchType != null ? this.overrideKnowledgeBaseSearchType.equals(that.overrideKnowledgeBaseSearchType) : that.overrideKnowledgeBaseSearchType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.contentTagFilter != null ? this.contentTagFilter.hashCode() : 0;
                result = 31 * result + (this.maxResults != null ? this.maxResults.hashCode() : 0);
                result = 31 * result + (this.overrideKnowledgeBaseSearchType != null ? this.overrideKnowledgeBaseSearchType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for AI Agents of type <code>MANUAL_SEARCH</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * ManualSearchAIAgentConfigurationProperty manualSearchAIAgentConfigurationProperty = ManualSearchAIAgentConfigurationProperty.builder()
     *         .answerGenerationAiGuardrailId("answerGenerationAiGuardrailId")
     *         .answerGenerationAiPromptId("answerGenerationAiPromptId")
     *         .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
     *                 .associationConfigurationData(AssociationConfigurationDataProperty.builder()
     *                         .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
     *                                 .contentTagFilter(TagFilterProperty.builder()
     *                                         .andConditions(List.of(TagConditionProperty.builder()
     *                                                 .key("key")
     *                                                 // the properties below are optional
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .orConditions(List.of(OrConditionProperty.builder()
     *                                                 .andConditions(List.of(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .tagCondition(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .tagCondition(TagConditionProperty.builder()
     *                                                 .key("key")
     *                                                 // the properties below are optional
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 .maxResults(123)
     *                                 .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
     *                                 .build())
     *                         .build())
     *                 .associationId("associationId")
     *                 .associationType("associationType")
     *                 .build()))
     *         .locale("locale")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-manualsearchaiagentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-manualsearchaiagentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent.ManualSearchAIAgentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ManualSearchAIAgentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ManualSearchAIAgentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the answer generation AI guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-manualsearchaiagentconfiguration.html#cfn-wisdom-aiagent-manualsearchaiagentconfiguration-answergenerationaiguardrailid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-manualsearchaiagentconfiguration.html#cfn-wisdom-aiagent-manualsearchaiagentconfiguration-answergenerationaiguardrailid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAnswerGenerationAiGuardrailId() {
            return null;
        }

        /**
         * The AI Prompt identifier for the Answer Generation prompt used by the <code>ANSWER_RECOMMENDATION</code> AI Agent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-manualsearchaiagentconfiguration.html#cfn-wisdom-aiagent-manualsearchaiagentconfiguration-answergenerationaipromptid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-manualsearchaiagentconfiguration.html#cfn-wisdom-aiagent-manualsearchaiagentconfiguration-answergenerationaipromptid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAnswerGenerationAiPromptId() {
            return null;
        }

        /**
         * The association configurations for overriding behavior on this AI Agent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-manualsearchaiagentconfiguration.html#cfn-wisdom-aiagent-manualsearchaiagentconfiguration-associationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-manualsearchaiagentconfiguration.html#cfn-wisdom-aiagent-manualsearchaiagentconfiguration-associationconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociationConfigurations() {
            return null;
        }

        /**
         * The locale to which specifies the language and region settings that determine the response language for <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_QueryAssistant.html">QueryAssistant</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-manualsearchaiagentconfiguration.html#cfn-wisdom-aiagent-manualsearchaiagentconfiguration-locale">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-manualsearchaiagentconfiguration.html#cfn-wisdom-aiagent-manualsearchaiagentconfiguration-locale</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLocale() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ManualSearchAIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ManualSearchAIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ManualSearchAIAgentConfigurationProperty> {
            java.lang.String answerGenerationAiGuardrailId;
            java.lang.String answerGenerationAiPromptId;
            java.lang.Object associationConfigurations;
            java.lang.String locale;

            /**
             * Sets the value of {@link ManualSearchAIAgentConfigurationProperty#getAnswerGenerationAiGuardrailId}
             * @param answerGenerationAiGuardrailId The ID of the answer generation AI guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerGenerationAiGuardrailId(java.lang.String answerGenerationAiGuardrailId) {
                this.answerGenerationAiGuardrailId = answerGenerationAiGuardrailId;
                return this;
            }

            /**
             * Sets the value of {@link ManualSearchAIAgentConfigurationProperty#getAnswerGenerationAiPromptId}
             * @param answerGenerationAiPromptId The AI Prompt identifier for the Answer Generation prompt used by the <code>ANSWER_RECOMMENDATION</code> AI Agent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder answerGenerationAiPromptId(java.lang.String answerGenerationAiPromptId) {
                this.answerGenerationAiPromptId = answerGenerationAiPromptId;
                return this;
            }

            /**
             * Sets the value of {@link ManualSearchAIAgentConfigurationProperty#getAssociationConfigurations}
             * @param associationConfigurations The association configurations for overriding behavior on this AI Agent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationConfigurations(software.amazon.awscdk.IResolvable associationConfigurations) {
                this.associationConfigurations = associationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ManualSearchAIAgentConfigurationProperty#getAssociationConfigurations}
             * @param associationConfigurations The association configurations for overriding behavior on this AI Agent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationConfigurations(java.util.List<? extends java.lang.Object> associationConfigurations) {
                this.associationConfigurations = associationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link ManualSearchAIAgentConfigurationProperty#getLocale}
             * @param locale The locale to which specifies the language and region settings that determine the response language for <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_amazon-q-connect_QueryAssistant.html">QueryAssistant</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locale(java.lang.String locale) {
                this.locale = locale;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ManualSearchAIAgentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ManualSearchAIAgentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ManualSearchAIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManualSearchAIAgentConfigurationProperty {
            private final java.lang.String answerGenerationAiGuardrailId;
            private final java.lang.String answerGenerationAiPromptId;
            private final java.lang.Object associationConfigurations;
            private final java.lang.String locale;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.answerGenerationAiGuardrailId = software.amazon.jsii.Kernel.get(this, "answerGenerationAiGuardrailId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.answerGenerationAiPromptId = software.amazon.jsii.Kernel.get(this, "answerGenerationAiPromptId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.associationConfigurations = software.amazon.jsii.Kernel.get(this, "associationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.locale = software.amazon.jsii.Kernel.get(this, "locale", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.answerGenerationAiGuardrailId = builder.answerGenerationAiGuardrailId;
                this.answerGenerationAiPromptId = builder.answerGenerationAiPromptId;
                this.associationConfigurations = builder.associationConfigurations;
                this.locale = builder.locale;
            }

            @Override
            public final java.lang.String getAnswerGenerationAiGuardrailId() {
                return this.answerGenerationAiGuardrailId;
            }

            @Override
            public final java.lang.String getAnswerGenerationAiPromptId() {
                return this.answerGenerationAiPromptId;
            }

            @Override
            public final java.lang.Object getAssociationConfigurations() {
                return this.associationConfigurations;
            }

            @Override
            public final java.lang.String getLocale() {
                return this.locale;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnswerGenerationAiGuardrailId() != null) {
                    data.set("answerGenerationAiGuardrailId", om.valueToTree(this.getAnswerGenerationAiGuardrailId()));
                }
                if (this.getAnswerGenerationAiPromptId() != null) {
                    data.set("answerGenerationAiPromptId", om.valueToTree(this.getAnswerGenerationAiPromptId()));
                }
                if (this.getAssociationConfigurations() != null) {
                    data.set("associationConfigurations", om.valueToTree(this.getAssociationConfigurations()));
                }
                if (this.getLocale() != null) {
                    data.set("locale", om.valueToTree(this.getLocale()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgent.ManualSearchAIAgentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ManualSearchAIAgentConfigurationProperty.Jsii$Proxy that = (ManualSearchAIAgentConfigurationProperty.Jsii$Proxy) o;

                if (this.answerGenerationAiGuardrailId != null ? !this.answerGenerationAiGuardrailId.equals(that.answerGenerationAiGuardrailId) : that.answerGenerationAiGuardrailId != null) return false;
                if (this.answerGenerationAiPromptId != null ? !this.answerGenerationAiPromptId.equals(that.answerGenerationAiPromptId) : that.answerGenerationAiPromptId != null) return false;
                if (this.associationConfigurations != null ? !this.associationConfigurations.equals(that.associationConfigurations) : that.associationConfigurations != null) return false;
                return this.locale != null ? this.locale.equals(that.locale) : that.locale == null;
            }

            @Override
            public final int hashCode() {
                int result = this.answerGenerationAiGuardrailId != null ? this.answerGenerationAiGuardrailId.hashCode() : 0;
                result = 31 * result + (this.answerGenerationAiPromptId != null ? this.answerGenerationAiPromptId.hashCode() : 0);
                result = 31 * result + (this.associationConfigurations != null ? this.associationConfigurations.hashCode() : 0);
                result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * OrConditionProperty orConditionProperty = OrConditionProperty.builder()
     *         .andConditions(List.of(TagConditionProperty.builder()
     *                 .key("key")
     *                 // the properties below are optional
     *                 .value("value")
     *                 .build()))
     *         .tagCondition(TagConditionProperty.builder()
     *                 .key("key")
     *                 // the properties below are optional
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-orcondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-orcondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent.OrConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(OrConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-orcondition.html#cfn-wisdom-aiagent-orcondition-andconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-orcondition.html#cfn-wisdom-aiagent-orcondition-andconditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAndConditions() {
            return null;
        }

        /**
         * A leaf node condition which can be used to specify a tag condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-orcondition.html#cfn-wisdom-aiagent-orcondition-tagcondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-orcondition.html#cfn-wisdom-aiagent-orcondition-tagcondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrConditionProperty> {
            java.lang.Object andConditions;
            java.lang.Object tagCondition;

            /**
             * Sets the value of {@link OrConditionProperty#getAndConditions}
             * @param andConditions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder andConditions(software.amazon.awscdk.IResolvable andConditions) {
                this.andConditions = andConditions;
                return this;
            }

            /**
             * Sets the value of {@link OrConditionProperty#getAndConditions}
             * @param andConditions the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder andConditions(java.util.List<? extends java.lang.Object> andConditions) {
                this.andConditions = andConditions;
                return this;
            }

            /**
             * Sets the value of {@link OrConditionProperty#getTagCondition}
             * @param tagCondition A leaf node condition which can be used to specify a tag condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagCondition(software.amazon.awscdk.IResolvable tagCondition) {
                this.tagCondition = tagCondition;
                return this;
            }

            /**
             * Sets the value of {@link OrConditionProperty#getTagCondition}
             * @param tagCondition A leaf node condition which can be used to specify a tag condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagCondition(software.amazon.awscdk.services.wisdom.CfnAIAgent.TagConditionProperty tagCondition) {
                this.tagCondition = tagCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrConditionProperty {
            private final java.lang.Object andConditions;
            private final java.lang.Object tagCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.andConditions = software.amazon.jsii.Kernel.get(this, "andConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagCondition = software.amazon.jsii.Kernel.get(this, "tagCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.andConditions = builder.andConditions;
                this.tagCondition = builder.tagCondition;
            }

            @Override
            public final java.lang.Object getAndConditions() {
                return this.andConditions;
            }

            @Override
            public final java.lang.Object getTagCondition() {
                return this.tagCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAndConditions() != null) {
                    data.set("andConditions", om.valueToTree(this.getAndConditions()));
                }
                if (this.getTagCondition() != null) {
                    data.set("tagCondition", om.valueToTree(this.getTagCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgent.OrConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrConditionProperty.Jsii$Proxy that = (OrConditionProperty.Jsii$Proxy) o;

                if (this.andConditions != null ? !this.andConditions.equals(that.andConditions) : that.andConditions != null) return false;
                return this.tagCondition != null ? this.tagCondition.equals(that.tagCondition) : that.tagCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.andConditions != null ? this.andConditions.hashCode() : 0;
                result = 31 * result + (this.tagCondition != null ? this.tagCondition.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of the self-service AI agent.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * SelfServiceAIAgentConfigurationProperty selfServiceAIAgentConfigurationProperty = SelfServiceAIAgentConfigurationProperty.builder()
     *         .associationConfigurations(List.of(AssociationConfigurationProperty.builder()
     *                 .associationConfigurationData(AssociationConfigurationDataProperty.builder()
     *                         .knowledgeBaseAssociationConfigurationData(KnowledgeBaseAssociationConfigurationDataProperty.builder()
     *                                 .contentTagFilter(TagFilterProperty.builder()
     *                                         .andConditions(List.of(TagConditionProperty.builder()
     *                                                 .key("key")
     *                                                 // the properties below are optional
     *                                                 .value("value")
     *                                                 .build()))
     *                                         .orConditions(List.of(OrConditionProperty.builder()
     *                                                 .andConditions(List.of(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build()))
     *                                                 .tagCondition(TagConditionProperty.builder()
     *                                                         .key("key")
     *                                                         // the properties below are optional
     *                                                         .value("value")
     *                                                         .build())
     *                                                 .build()))
     *                                         .tagCondition(TagConditionProperty.builder()
     *                                                 .key("key")
     *                                                 // the properties below are optional
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 .maxResults(123)
     *                                 .overrideKnowledgeBaseSearchType("overrideKnowledgeBaseSearchType")
     *                                 .build())
     *                         .build())
     *                 .associationId("associationId")
     *                 .associationType("associationType")
     *                 .build()))
     *         .selfServiceAiGuardrailId("selfServiceAiGuardrailId")
     *         .selfServiceAnswerGenerationAiPromptId("selfServiceAnswerGenerationAiPromptId")
     *         .selfServicePreProcessingAiPromptId("selfServicePreProcessingAiPromptId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-selfserviceaiagentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-selfserviceaiagentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent.SelfServiceAIAgentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SelfServiceAIAgentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SelfServiceAIAgentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The association configuration of the self-service AI agent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-selfserviceaiagentconfiguration.html#cfn-wisdom-aiagent-selfserviceaiagentconfiguration-associationconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-selfserviceaiagentconfiguration.html#cfn-wisdom-aiagent-selfserviceaiagentconfiguration-associationconfigurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssociationConfigurations() {
            return null;
        }

        /**
         * The ID of the self-service AI guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-selfserviceaiagentconfiguration.html#cfn-wisdom-aiagent-selfserviceaiagentconfiguration-selfserviceaiguardrailid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-selfserviceaiagentconfiguration.html#cfn-wisdom-aiagent-selfserviceaiagentconfiguration-selfserviceaiguardrailid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelfServiceAiGuardrailId() {
            return null;
        }

        /**
         * The ID of the self-service answer generation AI prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-selfserviceaiagentconfiguration.html#cfn-wisdom-aiagent-selfserviceaiagentconfiguration-selfserviceanswergenerationaipromptid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-selfserviceaiagentconfiguration.html#cfn-wisdom-aiagent-selfserviceaiagentconfiguration-selfserviceanswergenerationaipromptid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelfServiceAnswerGenerationAiPromptId() {
            return null;
        }

        /**
         * The ID of the self-service preprocessing AI prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-selfserviceaiagentconfiguration.html#cfn-wisdom-aiagent-selfserviceaiagentconfiguration-selfservicepreprocessingaipromptid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-selfserviceaiagentconfiguration.html#cfn-wisdom-aiagent-selfserviceaiagentconfiguration-selfservicepreprocessingaipromptid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSelfServicePreProcessingAiPromptId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SelfServiceAIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SelfServiceAIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SelfServiceAIAgentConfigurationProperty> {
            java.lang.Object associationConfigurations;
            java.lang.String selfServiceAiGuardrailId;
            java.lang.String selfServiceAnswerGenerationAiPromptId;
            java.lang.String selfServicePreProcessingAiPromptId;

            /**
             * Sets the value of {@link SelfServiceAIAgentConfigurationProperty#getAssociationConfigurations}
             * @param associationConfigurations The association configuration of the self-service AI agent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationConfigurations(software.amazon.awscdk.IResolvable associationConfigurations) {
                this.associationConfigurations = associationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link SelfServiceAIAgentConfigurationProperty#getAssociationConfigurations}
             * @param associationConfigurations The association configuration of the self-service AI agent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder associationConfigurations(java.util.List<? extends java.lang.Object> associationConfigurations) {
                this.associationConfigurations = associationConfigurations;
                return this;
            }

            /**
             * Sets the value of {@link SelfServiceAIAgentConfigurationProperty#getSelfServiceAiGuardrailId}
             * @param selfServiceAiGuardrailId The ID of the self-service AI guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfServiceAiGuardrailId(java.lang.String selfServiceAiGuardrailId) {
                this.selfServiceAiGuardrailId = selfServiceAiGuardrailId;
                return this;
            }

            /**
             * Sets the value of {@link SelfServiceAIAgentConfigurationProperty#getSelfServiceAnswerGenerationAiPromptId}
             * @param selfServiceAnswerGenerationAiPromptId The ID of the self-service answer generation AI prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfServiceAnswerGenerationAiPromptId(java.lang.String selfServiceAnswerGenerationAiPromptId) {
                this.selfServiceAnswerGenerationAiPromptId = selfServiceAnswerGenerationAiPromptId;
                return this;
            }

            /**
             * Sets the value of {@link SelfServiceAIAgentConfigurationProperty#getSelfServicePreProcessingAiPromptId}
             * @param selfServicePreProcessingAiPromptId The ID of the self-service preprocessing AI prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder selfServicePreProcessingAiPromptId(java.lang.String selfServicePreProcessingAiPromptId) {
                this.selfServicePreProcessingAiPromptId = selfServicePreProcessingAiPromptId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SelfServiceAIAgentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SelfServiceAIAgentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SelfServiceAIAgentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelfServiceAIAgentConfigurationProperty {
            private final java.lang.Object associationConfigurations;
            private final java.lang.String selfServiceAiGuardrailId;
            private final java.lang.String selfServiceAnswerGenerationAiPromptId;
            private final java.lang.String selfServicePreProcessingAiPromptId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.associationConfigurations = software.amazon.jsii.Kernel.get(this, "associationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.selfServiceAiGuardrailId = software.amazon.jsii.Kernel.get(this, "selfServiceAiGuardrailId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selfServiceAnswerGenerationAiPromptId = software.amazon.jsii.Kernel.get(this, "selfServiceAnswerGenerationAiPromptId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.selfServicePreProcessingAiPromptId = software.amazon.jsii.Kernel.get(this, "selfServicePreProcessingAiPromptId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.associationConfigurations = builder.associationConfigurations;
                this.selfServiceAiGuardrailId = builder.selfServiceAiGuardrailId;
                this.selfServiceAnswerGenerationAiPromptId = builder.selfServiceAnswerGenerationAiPromptId;
                this.selfServicePreProcessingAiPromptId = builder.selfServicePreProcessingAiPromptId;
            }

            @Override
            public final java.lang.Object getAssociationConfigurations() {
                return this.associationConfigurations;
            }

            @Override
            public final java.lang.String getSelfServiceAiGuardrailId() {
                return this.selfServiceAiGuardrailId;
            }

            @Override
            public final java.lang.String getSelfServiceAnswerGenerationAiPromptId() {
                return this.selfServiceAnswerGenerationAiPromptId;
            }

            @Override
            public final java.lang.String getSelfServicePreProcessingAiPromptId() {
                return this.selfServicePreProcessingAiPromptId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssociationConfigurations() != null) {
                    data.set("associationConfigurations", om.valueToTree(this.getAssociationConfigurations()));
                }
                if (this.getSelfServiceAiGuardrailId() != null) {
                    data.set("selfServiceAiGuardrailId", om.valueToTree(this.getSelfServiceAiGuardrailId()));
                }
                if (this.getSelfServiceAnswerGenerationAiPromptId() != null) {
                    data.set("selfServiceAnswerGenerationAiPromptId", om.valueToTree(this.getSelfServiceAnswerGenerationAiPromptId()));
                }
                if (this.getSelfServicePreProcessingAiPromptId() != null) {
                    data.set("selfServicePreProcessingAiPromptId", om.valueToTree(this.getSelfServicePreProcessingAiPromptId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgent.SelfServiceAIAgentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SelfServiceAIAgentConfigurationProperty.Jsii$Proxy that = (SelfServiceAIAgentConfigurationProperty.Jsii$Proxy) o;

                if (this.associationConfigurations != null ? !this.associationConfigurations.equals(that.associationConfigurations) : that.associationConfigurations != null) return false;
                if (this.selfServiceAiGuardrailId != null ? !this.selfServiceAiGuardrailId.equals(that.selfServiceAiGuardrailId) : that.selfServiceAiGuardrailId != null) return false;
                if (this.selfServiceAnswerGenerationAiPromptId != null ? !this.selfServiceAnswerGenerationAiPromptId.equals(that.selfServiceAnswerGenerationAiPromptId) : that.selfServiceAnswerGenerationAiPromptId != null) return false;
                return this.selfServicePreProcessingAiPromptId != null ? this.selfServicePreProcessingAiPromptId.equals(that.selfServicePreProcessingAiPromptId) : that.selfServicePreProcessingAiPromptId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.associationConfigurations != null ? this.associationConfigurations.hashCode() : 0;
                result = 31 * result + (this.selfServiceAiGuardrailId != null ? this.selfServiceAiGuardrailId.hashCode() : 0);
                result = 31 * result + (this.selfServiceAnswerGenerationAiPromptId != null ? this.selfServiceAnswerGenerationAiPromptId.hashCode() : 0);
                result = 31 * result + (this.selfServicePreProcessingAiPromptId != null ? this.selfServicePreProcessingAiPromptId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that can be used to specify tag conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * TagConditionProperty tagConditionProperty = TagConditionProperty.builder()
     *         .key("key")
     *         // the properties below are optional
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagcondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagcondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent.TagConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(TagConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The tag key in the tag condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagcondition.html#cfn-wisdom-aiagent-tagcondition-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagcondition.html#cfn-wisdom-aiagent-tagcondition-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The tag value in the tag condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagcondition.html#cfn-wisdom-aiagent-tagcondition-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagcondition.html#cfn-wisdom-aiagent-tagcondition-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagConditionProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link TagConditionProperty#getKey}
             * @param key The tag key in the tag condition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagConditionProperty#getValue}
             * @param value The tag value in the tag condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagConditionProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgent.TagConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagConditionProperty.Jsii$Proxy that = (TagConditionProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that can be used to specify tag conditions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * TagFilterProperty tagFilterProperty = TagFilterProperty.builder()
     *         .andConditions(List.of(TagConditionProperty.builder()
     *                 .key("key")
     *                 // the properties below are optional
     *                 .value("value")
     *                 .build()))
     *         .orConditions(List.of(OrConditionProperty.builder()
     *                 .andConditions(List.of(TagConditionProperty.builder()
     *                         .key("key")
     *                         // the properties below are optional
     *                         .value("value")
     *                         .build()))
     *                 .tagCondition(TagConditionProperty.builder()
     *                         .key("key")
     *                         // the properties below are optional
     *                         .value("value")
     *                         .build())
     *                 .build()))
     *         .tagCondition(TagConditionProperty.builder()
     *                 .key("key")
     *                 // the properties below are optional
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIAgent.TagFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(TagFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of conditions which would be applied together with an <code>AND</code> condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagfilter.html#cfn-wisdom-aiagent-tagfilter-andconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagfilter.html#cfn-wisdom-aiagent-tagfilter-andconditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAndConditions() {
            return null;
        }

        /**
         * A list of conditions which would be applied together with an <code>OR</code> condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagfilter.html#cfn-wisdom-aiagent-tagfilter-orconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagfilter.html#cfn-wisdom-aiagent-tagfilter-orconditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrConditions() {
            return null;
        }

        /**
         * A leaf node condition which can be used to specify a tag condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagfilter.html#cfn-wisdom-aiagent-tagfilter-tagcondition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiagent-tagfilter.html#cfn-wisdom-aiagent-tagfilter-tagcondition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagCondition() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagFilterProperty> {
            java.lang.Object andConditions;
            java.lang.Object orConditions;
            java.lang.Object tagCondition;

            /**
             * Sets the value of {@link TagFilterProperty#getAndConditions}
             * @param andConditions A list of conditions which would be applied together with an <code>AND</code> condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder andConditions(software.amazon.awscdk.IResolvable andConditions) {
                this.andConditions = andConditions;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getAndConditions}
             * @param andConditions A list of conditions which would be applied together with an <code>AND</code> condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder andConditions(java.util.List<? extends java.lang.Object> andConditions) {
                this.andConditions = andConditions;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getOrConditions}
             * @param orConditions A list of conditions which would be applied together with an <code>OR</code> condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orConditions(software.amazon.awscdk.IResolvable orConditions) {
                this.orConditions = orConditions;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getOrConditions}
             * @param orConditions A list of conditions which would be applied together with an <code>OR</code> condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder orConditions(java.util.List<? extends java.lang.Object> orConditions) {
                this.orConditions = orConditions;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getTagCondition}
             * @param tagCondition A leaf node condition which can be used to specify a tag condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagCondition(software.amazon.awscdk.IResolvable tagCondition) {
                this.tagCondition = tagCondition;
                return this;
            }

            /**
             * Sets the value of {@link TagFilterProperty#getTagCondition}
             * @param tagCondition A leaf node condition which can be used to specify a tag condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagCondition(software.amazon.awscdk.services.wisdom.CfnAIAgent.TagConditionProperty tagCondition) {
                this.tagCondition = tagCondition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagFilterProperty {
            private final java.lang.Object andConditions;
            private final java.lang.Object orConditions;
            private final java.lang.Object tagCondition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.andConditions = software.amazon.jsii.Kernel.get(this, "andConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.orConditions = software.amazon.jsii.Kernel.get(this, "orConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tagCondition = software.amazon.jsii.Kernel.get(this, "tagCondition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.andConditions = builder.andConditions;
                this.orConditions = builder.orConditions;
                this.tagCondition = builder.tagCondition;
            }

            @Override
            public final java.lang.Object getAndConditions() {
                return this.andConditions;
            }

            @Override
            public final java.lang.Object getOrConditions() {
                return this.orConditions;
            }

            @Override
            public final java.lang.Object getTagCondition() {
                return this.tagCondition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAndConditions() != null) {
                    data.set("andConditions", om.valueToTree(this.getAndConditions()));
                }
                if (this.getOrConditions() != null) {
                    data.set("orConditions", om.valueToTree(this.getOrConditions()));
                }
                if (this.getTagCondition() != null) {
                    data.set("tagCondition", om.valueToTree(this.getTagCondition()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIAgent.TagFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagFilterProperty.Jsii$Proxy that = (TagFilterProperty.Jsii$Proxy) o;

                if (this.andConditions != null ? !this.andConditions.equals(that.andConditions) : that.andConditions != null) return false;
                if (this.orConditions != null ? !this.orConditions.equals(that.orConditions) : that.orConditions != null) return false;
                return this.tagCondition != null ? this.tagCondition.equals(that.tagCondition) : that.tagCondition == null;
            }

            @Override
            public final int hashCode() {
                int result = this.andConditions != null ? this.andConditions.hashCode() : 0;
                result = 31 * result + (this.orConditions != null ? this.orConditions.hashCode() : 0);
                result = 31 * result + (this.tagCondition != null ? this.tagCondition.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.wisdom.CfnAIAgent}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.wisdom.CfnAIAgent> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.wisdom.CfnAIAgentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.wisdom.CfnAIAgentProps.Builder();
        }

        /**
         * The identifier of the Amazon Q in Connect assistant.
         * <p>
         * Can be either the ID or the ARN. URLs cannot contain the ARN.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-assistantid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-assistantid</a>
         * @param assistantId The identifier of the Amazon Q in Connect assistant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(final java.lang.String assistantId) {
            this.props.assistantId(assistantId);
            return this;
        }

        /**
         * Configuration for the AI Agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-configuration</a>
         * @param configuration Configuration for the AI Agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * Configuration for the AI Agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-configuration</a>
         * @param configuration Configuration for the AI Agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.wisdom.CfnAIAgent.AIAgentConfigurationProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * The type of the AI Agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-type</a>
         * @param type The type of the AI Agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The description of the AI Agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-description</a>
         * @param description The description of the AI Agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the AI Agent.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-name</a>
         * @param name The name of the AI Agent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiagent.html#cfn-wisdom-aiagent-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.wisdom.CfnAIAgent}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.wisdom.CfnAIAgent build() {
            return new software.amazon.awscdk.services.wisdom.CfnAIAgent(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
