package software.amazon.awscdk.services.wisdom;

/**
 * Creates an Amazon Q in Connect AI Guardrail.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnAIGuardrail cfnAIGuardrail = CfnAIGuardrail.Builder.create(this, "MyCfnAIGuardrail")
 *         .assistantId("assistantId")
 *         .blockedInputMessaging("blockedInputMessaging")
 *         .blockedOutputsMessaging("blockedOutputsMessaging")
 *         // the properties below are optional
 *         .contentPolicyConfig(AIGuardrailContentPolicyConfigProperty.builder()
 *                 .filtersConfig(List.of(GuardrailContentFilterConfigProperty.builder()
 *                         .inputStrength("inputStrength")
 *                         .outputStrength("outputStrength")
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .contextualGroundingPolicyConfig(AIGuardrailContextualGroundingPolicyConfigProperty.builder()
 *                 .filtersConfig(List.of(GuardrailContextualGroundingFilterConfigProperty.builder()
 *                         .threshold(123)
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .description("description")
 *         .name("name")
 *         .sensitiveInformationPolicyConfig(AIGuardrailSensitiveInformationPolicyConfigProperty.builder()
 *                 .piiEntitiesConfig(List.of(GuardrailPiiEntityConfigProperty.builder()
 *                         .action("action")
 *                         .type("type")
 *                         .build()))
 *                 .regexesConfig(List.of(GuardrailRegexConfigProperty.builder()
 *                         .action("action")
 *                         .name("name")
 *                         .pattern("pattern")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .build()))
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .topicPolicyConfig(AIGuardrailTopicPolicyConfigProperty.builder()
 *                 .topicsConfig(List.of(GuardrailTopicConfigProperty.builder()
 *                         .definition("definition")
 *                         .name("name")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .examples(List.of("examples"))
 *                         .build()))
 *                 .build())
 *         .wordPolicyConfig(AIGuardrailWordPolicyConfigProperty.builder()
 *                 .managedWordListsConfig(List.of(GuardrailManagedWordsConfigProperty.builder()
 *                         .type("type")
 *                         .build()))
 *                 .wordsConfig(List.of(GuardrailWordConfigProperty.builder()
 *                         .text("text")
 *                         .build()))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-15T12:25:46.203Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail")
public class CfnAIGuardrail extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnAIGuardrail(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnAIGuardrail(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.wisdom.CfnAIGuardrail.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnAIGuardrail(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.wisdom.CfnAIGuardrailProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAiGuardrailArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAiGuardrailArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Q in Connect AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAiGuardrailId() {
        return software.amazon.jsii.Kernel.get(this, "attrAiGuardrailId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Q in Connect assistant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAssistantArn() {
        return software.amazon.jsii.Kernel.get(this, "attrAssistantArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The identifier of the Amazon Q in Connect assistant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssistantId() {
        return software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the Amazon Q in Connect assistant.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAssistantId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "assistantId", java.util.Objects.requireNonNull(value, "assistantId is required"));
    }

    /**
     * The message to return when the AI Guardrail blocks a prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBlockedInputMessaging() {
        return software.amazon.jsii.Kernel.get(this, "blockedInputMessaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The message to return when the AI Guardrail blocks a prompt.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlockedInputMessaging(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "blockedInputMessaging", java.util.Objects.requireNonNull(value, "blockedInputMessaging is required"));
    }

    /**
     * The message to return when the AI Guardrail blocks a model response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBlockedOutputsMessaging() {
        return software.amazon.jsii.Kernel.get(this, "blockedOutputsMessaging", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The message to return when the AI Guardrail blocks a model response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBlockedOutputsMessaging(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "blockedOutputsMessaging", java.util.Objects.requireNonNull(value, "blockedOutputsMessaging is required"));
    }

    /**
     * Contains details about how to handle harmful content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContentPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "contentPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about how to handle harmful content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "contentPolicyConfig", value);
    }

    /**
     * Contains details about how to handle harmful content.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContentPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailContentPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "contentPolicyConfig", value);
    }

    /**
     * The policy configuration details for the AI Guardrail's contextual grounding policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getContextualGroundingPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "contextualGroundingPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The policy configuration details for the AI Guardrail's contextual grounding policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContextualGroundingPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "contextualGroundingPolicyConfig", value);
    }

    /**
     * The policy configuration details for the AI Guardrail's contextual grounding policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContextualGroundingPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailContextualGroundingPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "contextualGroundingPolicyConfig", value);
    }

    /**
     * A description of the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSensitiveInformationPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "sensitiveInformationPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSensitiveInformationPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sensitiveInformationPolicyConfig", value);
    }

    /**
     * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSensitiveInformationPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailSensitiveInformationPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "sensitiveInformationPolicyConfig", value);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * Contains details about topics that the AI Guardrail should identify and deny.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTopicPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "topicPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about topics that the AI Guardrail should identify and deny.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTopicPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "topicPolicyConfig", value);
    }

    /**
     * Contains details about topics that the AI Guardrail should identify and deny.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTopicPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailTopicPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "topicPolicyConfig", value);
    }

    /**
     * Contains details about the word policy to configured for the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWordPolicyConfig() {
        return software.amazon.jsii.Kernel.get(this, "wordPolicyConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains details about the word policy to configured for the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWordPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "wordPolicyConfig", value);
    }

    /**
     * Contains details about the word policy to configured for the AI Guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWordPolicyConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailWordPolicyConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "wordPolicyConfig", value);
    }
    /**
     * Content policy config for a guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AIGuardrailContentPolicyConfigProperty aIGuardrailContentPolicyConfigProperty = AIGuardrailContentPolicyConfigProperty.builder()
     *         .filtersConfig(List.of(GuardrailContentFilterConfigProperty.builder()
     *                 .inputStrength("inputStrength")
     *                 .outputStrength("outputStrength")
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailcontentpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailcontentpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.AIGuardrailContentPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AIGuardrailContentPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AIGuardrailContentPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of content filter configurations in a content policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailcontentpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailcontentpolicyconfig-filtersconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailcontentpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailcontentpolicyconfig-filtersconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFiltersConfig();

        /**
         * @return a {@link Builder} of {@link AIGuardrailContentPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AIGuardrailContentPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AIGuardrailContentPolicyConfigProperty> {
            java.lang.Object filtersConfig;

            /**
             * Sets the value of {@link AIGuardrailContentPolicyConfigProperty#getFiltersConfig}
             * @param filtersConfig List of content filter configurations in a content policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filtersConfig(software.amazon.awscdk.IResolvable filtersConfig) {
                this.filtersConfig = filtersConfig;
                return this;
            }

            /**
             * Sets the value of {@link AIGuardrailContentPolicyConfigProperty#getFiltersConfig}
             * @param filtersConfig List of content filter configurations in a content policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filtersConfig(java.util.List<? extends java.lang.Object> filtersConfig) {
                this.filtersConfig = filtersConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AIGuardrailContentPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AIGuardrailContentPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AIGuardrailContentPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AIGuardrailContentPolicyConfigProperty {
            private final java.lang.Object filtersConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filtersConfig = software.amazon.jsii.Kernel.get(this, "filtersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filtersConfig = java.util.Objects.requireNonNull(builder.filtersConfig, "filtersConfig is required");
            }

            @Override
            public final java.lang.Object getFiltersConfig() {
                return this.filtersConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filtersConfig", om.valueToTree(this.getFiltersConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.AIGuardrailContentPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AIGuardrailContentPolicyConfigProperty.Jsii$Proxy that = (AIGuardrailContentPolicyConfigProperty.Jsii$Proxy) o;

                return this.filtersConfig.equals(that.filtersConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.filtersConfig.hashCode();
                return result;
            }
        }
    }
    /**
     * Contextual grounding policy config for a guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AIGuardrailContextualGroundingPolicyConfigProperty aIGuardrailContextualGroundingPolicyConfigProperty = AIGuardrailContextualGroundingPolicyConfigProperty.builder()
     *         .filtersConfig(List.of(GuardrailContextualGroundingFilterConfigProperty.builder()
     *                 .threshold(123)
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailcontextualgroundingpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailcontextualgroundingpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.AIGuardrailContextualGroundingPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AIGuardrailContextualGroundingPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AIGuardrailContextualGroundingPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of contextual grounding filter configs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailcontextualgroundingpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailcontextualgroundingpolicyconfig-filtersconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailcontextualgroundingpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailcontextualgroundingpolicyconfig-filtersconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFiltersConfig();

        /**
         * @return a {@link Builder} of {@link AIGuardrailContextualGroundingPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AIGuardrailContextualGroundingPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AIGuardrailContextualGroundingPolicyConfigProperty> {
            java.lang.Object filtersConfig;

            /**
             * Sets the value of {@link AIGuardrailContextualGroundingPolicyConfigProperty#getFiltersConfig}
             * @param filtersConfig List of contextual grounding filter configs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filtersConfig(software.amazon.awscdk.IResolvable filtersConfig) {
                this.filtersConfig = filtersConfig;
                return this;
            }

            /**
             * Sets the value of {@link AIGuardrailContextualGroundingPolicyConfigProperty#getFiltersConfig}
             * @param filtersConfig List of contextual grounding filter configs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filtersConfig(java.util.List<? extends java.lang.Object> filtersConfig) {
                this.filtersConfig = filtersConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AIGuardrailContextualGroundingPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AIGuardrailContextualGroundingPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AIGuardrailContextualGroundingPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AIGuardrailContextualGroundingPolicyConfigProperty {
            private final java.lang.Object filtersConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.filtersConfig = software.amazon.jsii.Kernel.get(this, "filtersConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.filtersConfig = java.util.Objects.requireNonNull(builder.filtersConfig, "filtersConfig is required");
            }

            @Override
            public final java.lang.Object getFiltersConfig() {
                return this.filtersConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("filtersConfig", om.valueToTree(this.getFiltersConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.AIGuardrailContextualGroundingPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AIGuardrailContextualGroundingPolicyConfigProperty.Jsii$Proxy that = (AIGuardrailContextualGroundingPolicyConfigProperty.Jsii$Proxy) o;

                return this.filtersConfig.equals(that.filtersConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.filtersConfig.hashCode();
                return result;
            }
        }
    }
    /**
     * Sensitive information policy configuration for a guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AIGuardrailSensitiveInformationPolicyConfigProperty aIGuardrailSensitiveInformationPolicyConfigProperty = AIGuardrailSensitiveInformationPolicyConfigProperty.builder()
     *         .piiEntitiesConfig(List.of(GuardrailPiiEntityConfigProperty.builder()
     *                 .action("action")
     *                 .type("type")
     *                 .build()))
     *         .regexesConfig(List.of(GuardrailRegexConfigProperty.builder()
     *                 .action("action")
     *                 .name("name")
     *                 .pattern("pattern")
     *                 // the properties below are optional
     *                 .description("description")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailsensitiveinformationpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailsensitiveinformationpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.AIGuardrailSensitiveInformationPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AIGuardrailSensitiveInformationPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AIGuardrailSensitiveInformationPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of entities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailsensitiveinformationpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailsensitiveinformationpolicyconfig-piientitiesconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailsensitiveinformationpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailsensitiveinformationpolicyconfig-piientitiesconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPiiEntitiesConfig() {
            return null;
        }

        /**
         * List of regex.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailsensitiveinformationpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailsensitiveinformationpolicyconfig-regexesconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailsensitiveinformationpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailsensitiveinformationpolicyconfig-regexesconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRegexesConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AIGuardrailSensitiveInformationPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AIGuardrailSensitiveInformationPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AIGuardrailSensitiveInformationPolicyConfigProperty> {
            java.lang.Object piiEntitiesConfig;
            java.lang.Object regexesConfig;

            /**
             * Sets the value of {@link AIGuardrailSensitiveInformationPolicyConfigProperty#getPiiEntitiesConfig}
             * @param piiEntitiesConfig List of entities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder piiEntitiesConfig(software.amazon.awscdk.IResolvable piiEntitiesConfig) {
                this.piiEntitiesConfig = piiEntitiesConfig;
                return this;
            }

            /**
             * Sets the value of {@link AIGuardrailSensitiveInformationPolicyConfigProperty#getPiiEntitiesConfig}
             * @param piiEntitiesConfig List of entities.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder piiEntitiesConfig(java.util.List<? extends java.lang.Object> piiEntitiesConfig) {
                this.piiEntitiesConfig = piiEntitiesConfig;
                return this;
            }

            /**
             * Sets the value of {@link AIGuardrailSensitiveInformationPolicyConfigProperty#getRegexesConfig}
             * @param regexesConfig List of regex.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexesConfig(software.amazon.awscdk.IResolvable regexesConfig) {
                this.regexesConfig = regexesConfig;
                return this;
            }

            /**
             * Sets the value of {@link AIGuardrailSensitiveInformationPolicyConfigProperty#getRegexesConfig}
             * @param regexesConfig List of regex.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regexesConfig(java.util.List<? extends java.lang.Object> regexesConfig) {
                this.regexesConfig = regexesConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AIGuardrailSensitiveInformationPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AIGuardrailSensitiveInformationPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AIGuardrailSensitiveInformationPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AIGuardrailSensitiveInformationPolicyConfigProperty {
            private final java.lang.Object piiEntitiesConfig;
            private final java.lang.Object regexesConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.piiEntitiesConfig = software.amazon.jsii.Kernel.get(this, "piiEntitiesConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regexesConfig = software.amazon.jsii.Kernel.get(this, "regexesConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.piiEntitiesConfig = builder.piiEntitiesConfig;
                this.regexesConfig = builder.regexesConfig;
            }

            @Override
            public final java.lang.Object getPiiEntitiesConfig() {
                return this.piiEntitiesConfig;
            }

            @Override
            public final java.lang.Object getRegexesConfig() {
                return this.regexesConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPiiEntitiesConfig() != null) {
                    data.set("piiEntitiesConfig", om.valueToTree(this.getPiiEntitiesConfig()));
                }
                if (this.getRegexesConfig() != null) {
                    data.set("regexesConfig", om.valueToTree(this.getRegexesConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.AIGuardrailSensitiveInformationPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AIGuardrailSensitiveInformationPolicyConfigProperty.Jsii$Proxy that = (AIGuardrailSensitiveInformationPolicyConfigProperty.Jsii$Proxy) o;

                if (this.piiEntitiesConfig != null ? !this.piiEntitiesConfig.equals(that.piiEntitiesConfig) : that.piiEntitiesConfig != null) return false;
                return this.regexesConfig != null ? this.regexesConfig.equals(that.regexesConfig) : that.regexesConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.piiEntitiesConfig != null ? this.piiEntitiesConfig.hashCode() : 0;
                result = 31 * result + (this.regexesConfig != null ? this.regexesConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Topic policy configuration for a guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AIGuardrailTopicPolicyConfigProperty aIGuardrailTopicPolicyConfigProperty = AIGuardrailTopicPolicyConfigProperty.builder()
     *         .topicsConfig(List.of(GuardrailTopicConfigProperty.builder()
     *                 .definition("definition")
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .examples(List.of("examples"))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailtopicpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailtopicpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.AIGuardrailTopicPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AIGuardrailTopicPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AIGuardrailTopicPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of topic configs in topic policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailtopicpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailtopicpolicyconfig-topicsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailtopicpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailtopicpolicyconfig-topicsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTopicsConfig();

        /**
         * @return a {@link Builder} of {@link AIGuardrailTopicPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AIGuardrailTopicPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AIGuardrailTopicPolicyConfigProperty> {
            java.lang.Object topicsConfig;

            /**
             * Sets the value of {@link AIGuardrailTopicPolicyConfigProperty#getTopicsConfig}
             * @param topicsConfig List of topic configs in topic policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicsConfig(software.amazon.awscdk.IResolvable topicsConfig) {
                this.topicsConfig = topicsConfig;
                return this;
            }

            /**
             * Sets the value of {@link AIGuardrailTopicPolicyConfigProperty#getTopicsConfig}
             * @param topicsConfig List of topic configs in topic policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topicsConfig(java.util.List<? extends java.lang.Object> topicsConfig) {
                this.topicsConfig = topicsConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AIGuardrailTopicPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AIGuardrailTopicPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AIGuardrailTopicPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AIGuardrailTopicPolicyConfigProperty {
            private final java.lang.Object topicsConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.topicsConfig = software.amazon.jsii.Kernel.get(this, "topicsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.topicsConfig = java.util.Objects.requireNonNull(builder.topicsConfig, "topicsConfig is required");
            }

            @Override
            public final java.lang.Object getTopicsConfig() {
                return this.topicsConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("topicsConfig", om.valueToTree(this.getTopicsConfig()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.AIGuardrailTopicPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AIGuardrailTopicPolicyConfigProperty.Jsii$Proxy that = (AIGuardrailTopicPolicyConfigProperty.Jsii$Proxy) o;

                return this.topicsConfig.equals(that.topicsConfig);
            }

            @Override
            public final int hashCode() {
                int result = this.topicsConfig.hashCode();
                return result;
            }
        }
    }
    /**
     * Word policy config for a guardrail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * AIGuardrailWordPolicyConfigProperty aIGuardrailWordPolicyConfigProperty = AIGuardrailWordPolicyConfigProperty.builder()
     *         .managedWordListsConfig(List.of(GuardrailManagedWordsConfigProperty.builder()
     *                 .type("type")
     *                 .build()))
     *         .wordsConfig(List.of(GuardrailWordConfigProperty.builder()
     *                 .text("text")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailwordpolicyconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailwordpolicyconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.AIGuardrailWordPolicyConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AIGuardrailWordPolicyConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AIGuardrailWordPolicyConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A config for the list of managed words.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailwordpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailwordpolicyconfig-managedwordlistsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailwordpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailwordpolicyconfig-managedwordlistsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedWordListsConfig() {
            return null;
        }

        /**
         * List of custom word configurations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailwordpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailwordpolicyconfig-wordsconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-aiguardrailwordpolicyconfig.html#cfn-wisdom-aiguardrail-aiguardrailwordpolicyconfig-wordsconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWordsConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AIGuardrailWordPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AIGuardrailWordPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AIGuardrailWordPolicyConfigProperty> {
            java.lang.Object managedWordListsConfig;
            java.lang.Object wordsConfig;

            /**
             * Sets the value of {@link AIGuardrailWordPolicyConfigProperty#getManagedWordListsConfig}
             * @param managedWordListsConfig A config for the list of managed words.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedWordListsConfig(software.amazon.awscdk.IResolvable managedWordListsConfig) {
                this.managedWordListsConfig = managedWordListsConfig;
                return this;
            }

            /**
             * Sets the value of {@link AIGuardrailWordPolicyConfigProperty#getManagedWordListsConfig}
             * @param managedWordListsConfig A config for the list of managed words.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedWordListsConfig(java.util.List<? extends java.lang.Object> managedWordListsConfig) {
                this.managedWordListsConfig = managedWordListsConfig;
                return this;
            }

            /**
             * Sets the value of {@link AIGuardrailWordPolicyConfigProperty#getWordsConfig}
             * @param wordsConfig List of custom word configurations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wordsConfig(software.amazon.awscdk.IResolvable wordsConfig) {
                this.wordsConfig = wordsConfig;
                return this;
            }

            /**
             * Sets the value of {@link AIGuardrailWordPolicyConfigProperty#getWordsConfig}
             * @param wordsConfig List of custom word configurations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder wordsConfig(java.util.List<? extends java.lang.Object> wordsConfig) {
                this.wordsConfig = wordsConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AIGuardrailWordPolicyConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AIGuardrailWordPolicyConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AIGuardrailWordPolicyConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AIGuardrailWordPolicyConfigProperty {
            private final java.lang.Object managedWordListsConfig;
            private final java.lang.Object wordsConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.managedWordListsConfig = software.amazon.jsii.Kernel.get(this, "managedWordListsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.wordsConfig = software.amazon.jsii.Kernel.get(this, "wordsConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.managedWordListsConfig = builder.managedWordListsConfig;
                this.wordsConfig = builder.wordsConfig;
            }

            @Override
            public final java.lang.Object getManagedWordListsConfig() {
                return this.managedWordListsConfig;
            }

            @Override
            public final java.lang.Object getWordsConfig() {
                return this.wordsConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getManagedWordListsConfig() != null) {
                    data.set("managedWordListsConfig", om.valueToTree(this.getManagedWordListsConfig()));
                }
                if (this.getWordsConfig() != null) {
                    data.set("wordsConfig", om.valueToTree(this.getWordsConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.AIGuardrailWordPolicyConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AIGuardrailWordPolicyConfigProperty.Jsii$Proxy that = (AIGuardrailWordPolicyConfigProperty.Jsii$Proxy) o;

                if (this.managedWordListsConfig != null ? !this.managedWordListsConfig.equals(that.managedWordListsConfig) : that.managedWordListsConfig != null) return false;
                return this.wordsConfig != null ? this.wordsConfig.equals(that.wordsConfig) : that.wordsConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.managedWordListsConfig != null ? this.managedWordListsConfig.hashCode() : 0;
                result = 31 * result + (this.wordsConfig != null ? this.wordsConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Content filter configuration in content policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * GuardrailContentFilterConfigProperty guardrailContentFilterConfigProperty = GuardrailContentFilterConfigProperty.builder()
     *         .inputStrength("inputStrength")
     *         .outputStrength("outputStrength")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontentfilterconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontentfilterconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailContentFilterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailContentFilterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailContentFilterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The strength of the input for the guardrail content filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontentfilterconfig.html#cfn-wisdom-aiguardrail-guardrailcontentfilterconfig-inputstrength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontentfilterconfig.html#cfn-wisdom-aiguardrail-guardrailcontentfilterconfig-inputstrength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInputStrength();

        /**
         * The output strength of the guardrail content filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontentfilterconfig.html#cfn-wisdom-aiguardrail-guardrailcontentfilterconfig-outputstrength">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontentfilterconfig.html#cfn-wisdom-aiguardrail-guardrailcontentfilterconfig-outputstrength</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOutputStrength();

        /**
         * The type of the guardrail content filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontentfilterconfig.html#cfn-wisdom-aiguardrail-guardrailcontentfilterconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontentfilterconfig.html#cfn-wisdom-aiguardrail-guardrailcontentfilterconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link GuardrailContentFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailContentFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailContentFilterConfigProperty> {
            java.lang.String inputStrength;
            java.lang.String outputStrength;
            java.lang.String type;

            /**
             * Sets the value of {@link GuardrailContentFilterConfigProperty#getInputStrength}
             * @param inputStrength The strength of the input for the guardrail content filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputStrength(java.lang.String inputStrength) {
                this.inputStrength = inputStrength;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailContentFilterConfigProperty#getOutputStrength}
             * @param outputStrength The output strength of the guardrail content filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputStrength(java.lang.String outputStrength) {
                this.outputStrength = outputStrength;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailContentFilterConfigProperty#getType}
             * @param type The type of the guardrail content filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailContentFilterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailContentFilterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailContentFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailContentFilterConfigProperty {
            private final java.lang.String inputStrength;
            private final java.lang.String outputStrength;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inputStrength = software.amazon.jsii.Kernel.get(this, "inputStrength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputStrength = software.amazon.jsii.Kernel.get(this, "outputStrength", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inputStrength = java.util.Objects.requireNonNull(builder.inputStrength, "inputStrength is required");
                this.outputStrength = java.util.Objects.requireNonNull(builder.outputStrength, "outputStrength is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getInputStrength() {
                return this.inputStrength;
            }

            @Override
            public final java.lang.String getOutputStrength() {
                return this.outputStrength;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("inputStrength", om.valueToTree(this.getInputStrength()));
                data.set("outputStrength", om.valueToTree(this.getOutputStrength()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailContentFilterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailContentFilterConfigProperty.Jsii$Proxy that = (GuardrailContentFilterConfigProperty.Jsii$Proxy) o;

                if (!inputStrength.equals(that.inputStrength)) return false;
                if (!outputStrength.equals(that.outputStrength)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.inputStrength.hashCode();
                result = 31 * result + (this.outputStrength.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * A configuration for grounding filter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * GuardrailContextualGroundingFilterConfigProperty guardrailContextualGroundingFilterConfigProperty = GuardrailContextualGroundingFilterConfigProperty.builder()
     *         .threshold(123)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontextualgroundingfilterconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontextualgroundingfilterconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailContextualGroundingFilterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailContextualGroundingFilterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailContextualGroundingFilterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The threshold for this filter.
         * <p>
         * Default: - 0
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontextualgroundingfilterconfig.html#cfn-wisdom-aiguardrail-guardrailcontextualgroundingfilterconfig-threshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontextualgroundingfilterconfig.html#cfn-wisdom-aiguardrail-guardrailcontextualgroundingfilterconfig-threshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getThreshold();

        /**
         * The type of this filter.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontextualgroundingfilterconfig.html#cfn-wisdom-aiguardrail-guardrailcontextualgroundingfilterconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailcontextualgroundingfilterconfig.html#cfn-wisdom-aiguardrail-guardrailcontextualgroundingfilterconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link GuardrailContextualGroundingFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailContextualGroundingFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailContextualGroundingFilterConfigProperty> {
            java.lang.Number threshold;
            java.lang.String type;

            /**
             * Sets the value of {@link GuardrailContextualGroundingFilterConfigProperty#getThreshold}
             * @param threshold The threshold for this filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder threshold(java.lang.Number threshold) {
                this.threshold = threshold;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailContextualGroundingFilterConfigProperty#getType}
             * @param type The type of this filter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailContextualGroundingFilterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailContextualGroundingFilterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailContextualGroundingFilterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailContextualGroundingFilterConfigProperty {
            private final java.lang.Number threshold;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.threshold = software.amazon.jsii.Kernel.get(this, "threshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.threshold = java.util.Objects.requireNonNull(builder.threshold, "threshold is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.Number getThreshold() {
                return this.threshold;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("threshold", om.valueToTree(this.getThreshold()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailContextualGroundingFilterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailContextualGroundingFilterConfigProperty.Jsii$Proxy that = (GuardrailContextualGroundingFilterConfigProperty.Jsii$Proxy) o;

                if (!threshold.equals(that.threshold)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.threshold.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * A managed words config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * GuardrailManagedWordsConfigProperty guardrailManagedWordsConfigProperty = GuardrailManagedWordsConfigProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailmanagedwordsconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailmanagedwordsconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailManagedWordsConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailManagedWordsConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailManagedWordsConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of guardrail managed words.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailmanagedwordsconfig.html#cfn-wisdom-aiguardrail-guardrailmanagedwordsconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailmanagedwordsconfig.html#cfn-wisdom-aiguardrail-guardrailmanagedwordsconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link GuardrailManagedWordsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailManagedWordsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailManagedWordsConfigProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link GuardrailManagedWordsConfigProperty#getType}
             * @param type The type of guardrail managed words. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailManagedWordsConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailManagedWordsConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailManagedWordsConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailManagedWordsConfigProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailManagedWordsConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailManagedWordsConfigProperty.Jsii$Proxy that = (GuardrailManagedWordsConfigProperty.Jsii$Proxy) o;

                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                return result;
            }
        }
    }
    /**
     * PII entity configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * GuardrailPiiEntityConfigProperty guardrailPiiEntityConfigProperty = GuardrailPiiEntityConfigProperty.builder()
     *         .action("action")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailpiientityconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailpiientityconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailPiiEntityConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailPiiEntityConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailPiiEntityConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action of guardrail PII entity configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailpiientityconfig.html#cfn-wisdom-aiguardrail-guardrailpiientityconfig-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailpiientityconfig.html#cfn-wisdom-aiguardrail-guardrailpiientityconfig-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * The currently supported PII entities.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailpiientityconfig.html#cfn-wisdom-aiguardrail-guardrailpiientityconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailpiientityconfig.html#cfn-wisdom-aiguardrail-guardrailpiientityconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link GuardrailPiiEntityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailPiiEntityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailPiiEntityConfigProperty> {
            java.lang.String action;
            java.lang.String type;

            /**
             * Sets the value of {@link GuardrailPiiEntityConfigProperty#getAction}
             * @param action The action of guardrail PII entity configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailPiiEntityConfigProperty#getType}
             * @param type The currently supported PII entities. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailPiiEntityConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailPiiEntityConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailPiiEntityConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailPiiEntityConfigProperty {
            private final java.lang.String action;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailPiiEntityConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailPiiEntityConfigProperty.Jsii$Proxy that = (GuardrailPiiEntityConfigProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * A regex configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * GuardrailRegexConfigProperty guardrailRegexConfigProperty = GuardrailRegexConfigProperty.builder()
     *         .action("action")
     *         .name("name")
     *         .pattern("pattern")
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailregexconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailregexconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailRegexConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailRegexConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailRegexConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action of the guardrail regex configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailregexconfig.html#cfn-wisdom-aiguardrail-guardrailregexconfig-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailregexconfig.html#cfn-wisdom-aiguardrail-guardrailregexconfig-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * A regex configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailregexconfig.html#cfn-wisdom-aiguardrail-guardrailregexconfig-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailregexconfig.html#cfn-wisdom-aiguardrail-guardrailregexconfig-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The regex pattern.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailregexconfig.html#cfn-wisdom-aiguardrail-guardrailregexconfig-pattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailregexconfig.html#cfn-wisdom-aiguardrail-guardrailregexconfig-pattern</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPattern();

        /**
         * The regex description.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailregexconfig.html#cfn-wisdom-aiguardrail-guardrailregexconfig-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailregexconfig.html#cfn-wisdom-aiguardrail-guardrailregexconfig-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GuardrailRegexConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailRegexConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailRegexConfigProperty> {
            java.lang.String action;
            java.lang.String name;
            java.lang.String pattern;
            java.lang.String description;

            /**
             * Sets the value of {@link GuardrailRegexConfigProperty#getAction}
             * @param action The action of the guardrail regex configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailRegexConfigProperty#getName}
             * @param name A regex configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailRegexConfigProperty#getPattern}
             * @param pattern The regex pattern. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pattern(java.lang.String pattern) {
                this.pattern = pattern;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailRegexConfigProperty#getDescription}
             * @param description The regex description.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailRegexConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailRegexConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailRegexConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailRegexConfigProperty {
            private final java.lang.String action;
            private final java.lang.String name;
            private final java.lang.String pattern;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getPattern() {
                return this.pattern;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("pattern", om.valueToTree(this.getPattern()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailRegexConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailRegexConfigProperty.Jsii$Proxy that = (GuardrailRegexConfigProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!name.equals(that.name)) return false;
                if (!pattern.equals(that.pattern)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.pattern.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Topic configuration in topic policy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * GuardrailTopicConfigProperty guardrailTopicConfigProperty = GuardrailTopicConfigProperty.builder()
     *         .definition("definition")
     *         .name("name")
     *         .type("type")
     *         // the properties below are optional
     *         .examples(List.of("examples"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailtopicconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailtopicconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailTopicConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailTopicConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailTopicConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Definition of topic in topic policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailtopicconfig.html#cfn-wisdom-aiguardrail-guardrailtopicconfig-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailtopicconfig.html#cfn-wisdom-aiguardrail-guardrailtopicconfig-definition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDefinition();

        /**
         * Name of topic in topic policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailtopicconfig.html#cfn-wisdom-aiguardrail-guardrailtopicconfig-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailtopicconfig.html#cfn-wisdom-aiguardrail-guardrailtopicconfig-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Type of topic in a policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailtopicconfig.html#cfn-wisdom-aiguardrail-guardrailtopicconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailtopicconfig.html#cfn-wisdom-aiguardrail-guardrailtopicconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Text example in topic policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailtopicconfig.html#cfn-wisdom-aiguardrail-guardrailtopicconfig-examples">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailtopicconfig.html#cfn-wisdom-aiguardrail-guardrailtopicconfig-examples</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExamples() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GuardrailTopicConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailTopicConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailTopicConfigProperty> {
            java.lang.String definition;
            java.lang.String name;
            java.lang.String type;
            java.util.List<java.lang.String> examples;

            /**
             * Sets the value of {@link GuardrailTopicConfigProperty#getDefinition}
             * @param definition Definition of topic in topic policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder definition(java.lang.String definition) {
                this.definition = definition;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailTopicConfigProperty#getName}
             * @param name Name of topic in topic policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailTopicConfigProperty#getType}
             * @param type Type of topic in a policy. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailTopicConfigProperty#getExamples}
             * @param examples Text example in topic policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder examples(java.util.List<java.lang.String> examples) {
                this.examples = examples;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailTopicConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailTopicConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailTopicConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailTopicConfigProperty {
            private final java.lang.String definition;
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.util.List<java.lang.String> examples;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.examples = software.amazon.jsii.Kernel.get(this, "examples", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.definition = java.util.Objects.requireNonNull(builder.definition, "definition is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.examples = builder.examples;
            }

            @Override
            public final java.lang.String getDefinition() {
                return this.definition;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.util.List<java.lang.String> getExamples() {
                return this.examples;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("definition", om.valueToTree(this.getDefinition()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getExamples() != null) {
                    data.set("examples", om.valueToTree(this.getExamples()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailTopicConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailTopicConfigProperty.Jsii$Proxy that = (GuardrailTopicConfigProperty.Jsii$Proxy) o;

                if (!definition.equals(that.definition)) return false;
                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                return this.examples != null ? this.examples.equals(that.examples) : that.examples == null;
            }

            @Override
            public final int hashCode() {
                int result = this.definition.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.examples != null ? this.examples.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A custom word config.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.wisdom.*;
     * GuardrailWordConfigProperty guardrailWordConfigProperty = GuardrailWordConfigProperty.builder()
     *         .text("text")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailwordconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailwordconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailWordConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailWordConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailWordConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The custom word text.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailwordconfig.html#cfn-wisdom-aiguardrail-guardrailwordconfig-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-wisdom-aiguardrail-guardrailwordconfig.html#cfn-wisdom-aiguardrail-guardrailwordconfig-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getText();

        /**
         * @return a {@link Builder} of {@link GuardrailWordConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailWordConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailWordConfigProperty> {
            java.lang.String text;

            /**
             * Sets the value of {@link GuardrailWordConfigProperty#getText}
             * @param text The custom word text. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailWordConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailWordConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailWordConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailWordConfigProperty {
            private final java.lang.String text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIGuardrail.GuardrailWordConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailWordConfigProperty.Jsii$Proxy that = (GuardrailWordConfigProperty.Jsii$Proxy) o;

                return this.text.equals(that.text);
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.wisdom.CfnAIGuardrail}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.wisdom.CfnAIGuardrail> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.wisdom.CfnAIGuardrailProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.wisdom.CfnAIGuardrailProps.Builder();
        }

        /**
         * The identifier of the Amazon Q in Connect assistant.
         * <p>
         * Can be either the ID or the ARN. URLs cannot contain the ARN.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-assistantid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-assistantid</a>
         * @param assistantId The identifier of the Amazon Q in Connect assistant. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(final java.lang.String assistantId) {
            this.props.assistantId(assistantId);
            return this;
        }

        /**
         * The message to return when the AI Guardrail blocks a prompt.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-blockedinputmessaging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-blockedinputmessaging</a>
         * @param blockedInputMessaging The message to return when the AI Guardrail blocks a prompt. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockedInputMessaging(final java.lang.String blockedInputMessaging) {
            this.props.blockedInputMessaging(blockedInputMessaging);
            return this;
        }

        /**
         * The message to return when the AI Guardrail blocks a model response.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-blockedoutputsmessaging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-blockedoutputsmessaging</a>
         * @param blockedOutputsMessaging The message to return when the AI Guardrail blocks a model response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockedOutputsMessaging(final java.lang.String blockedOutputsMessaging) {
            this.props.blockedOutputsMessaging(blockedOutputsMessaging);
            return this;
        }

        /**
         * Contains details about how to handle harmful content.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contentpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contentpolicyconfig</a>
         * @param contentPolicyConfig Contains details about how to handle harmful content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentPolicyConfig(final software.amazon.awscdk.IResolvable contentPolicyConfig) {
            this.props.contentPolicyConfig(contentPolicyConfig);
            return this;
        }
        /**
         * Contains details about how to handle harmful content.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contentpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contentpolicyconfig</a>
         * @param contentPolicyConfig Contains details about how to handle harmful content. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentPolicyConfig(final software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailContentPolicyConfigProperty contentPolicyConfig) {
            this.props.contentPolicyConfig(contentPolicyConfig);
            return this;
        }

        /**
         * The policy configuration details for the AI Guardrail's contextual grounding policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contextualgroundingpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contextualgroundingpolicyconfig</a>
         * @param contextualGroundingPolicyConfig The policy configuration details for the AI Guardrail's contextual grounding policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contextualGroundingPolicyConfig(final software.amazon.awscdk.IResolvable contextualGroundingPolicyConfig) {
            this.props.contextualGroundingPolicyConfig(contextualGroundingPolicyConfig);
            return this;
        }
        /**
         * The policy configuration details for the AI Guardrail's contextual grounding policy.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contextualgroundingpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-contextualgroundingpolicyconfig</a>
         * @param contextualGroundingPolicyConfig The policy configuration details for the AI Guardrail's contextual grounding policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contextualGroundingPolicyConfig(final software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailContextualGroundingPolicyConfigProperty contextualGroundingPolicyConfig) {
            this.props.contextualGroundingPolicyConfig(contextualGroundingPolicyConfig);
            return this;
        }

        /**
         * A description of the AI Guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-description</a>
         * @param description A description of the AI Guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the AI Guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-name</a>
         * @param name The name of the AI Guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-sensitiveinformationpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-sensitiveinformationpolicyconfig</a>
         * @param sensitiveInformationPolicyConfig Contains details about PII entities and regular expressions to configure for the AI Guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sensitiveInformationPolicyConfig(final software.amazon.awscdk.IResolvable sensitiveInformationPolicyConfig) {
            this.props.sensitiveInformationPolicyConfig(sensitiveInformationPolicyConfig);
            return this;
        }
        /**
         * Contains details about PII entities and regular expressions to configure for the AI Guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-sensitiveinformationpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-sensitiveinformationpolicyconfig</a>
         * @param sensitiveInformationPolicyConfig Contains details about PII entities and regular expressions to configure for the AI Guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sensitiveInformationPolicyConfig(final software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailSensitiveInformationPolicyConfigProperty sensitiveInformationPolicyConfig) {
            this.props.sensitiveInformationPolicyConfig(sensitiveInformationPolicyConfig);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-tags</a>
         * @param tags The tags used to organize, track, or control access for this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Contains details about topics that the AI Guardrail should identify and deny.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-topicpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-topicpolicyconfig</a>
         * @param topicPolicyConfig Contains details about topics that the AI Guardrail should identify and deny. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicPolicyConfig(final software.amazon.awscdk.IResolvable topicPolicyConfig) {
            this.props.topicPolicyConfig(topicPolicyConfig);
            return this;
        }
        /**
         * Contains details about topics that the AI Guardrail should identify and deny.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-topicpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-topicpolicyconfig</a>
         * @param topicPolicyConfig Contains details about topics that the AI Guardrail should identify and deny. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topicPolicyConfig(final software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailTopicPolicyConfigProperty topicPolicyConfig) {
            this.props.topicPolicyConfig(topicPolicyConfig);
            return this;
        }

        /**
         * Contains details about the word policy to configured for the AI Guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-wordpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-wordpolicyconfig</a>
         * @param wordPolicyConfig Contains details about the word policy to configured for the AI Guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wordPolicyConfig(final software.amazon.awscdk.IResolvable wordPolicyConfig) {
            this.props.wordPolicyConfig(wordPolicyConfig);
            return this;
        }
        /**
         * Contains details about the word policy to configured for the AI Guardrail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-wordpolicyconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aiguardrail.html#cfn-wisdom-aiguardrail-wordpolicyconfig</a>
         * @param wordPolicyConfig Contains details about the word policy to configured for the AI Guardrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wordPolicyConfig(final software.amazon.awscdk.services.wisdom.CfnAIGuardrail.AIGuardrailWordPolicyConfigProperty wordPolicyConfig) {
            this.props.wordPolicyConfig(wordPolicyConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.wisdom.CfnAIGuardrail}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.wisdom.CfnAIGuardrail build() {
            return new software.amazon.awscdk.services.wisdom.CfnAIGuardrail(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
