/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.services.appsync.AuthorizationConfig;
import software.amazon.awscdk.services.appsync.AuthorizationType;
import software.amazon.awscdk.services.appsync.Definition;
import software.amazon.awscdk.services.appsync.DomainOptions;
import software.amazon.awscdk.services.appsync.GraphqlApiAttributes;
import software.amazon.awscdk.services.appsync.GraphqlApiBase;
import software.amazon.awscdk.services.appsync.GraphqlApiProps;
import software.amazon.awscdk.services.appsync.IGraphqlApi;
import software.amazon.awscdk.services.appsync.ISchema;
import software.amazon.awscdk.services.appsync.IntrospectionConfig;
import software.amazon.awscdk.services.appsync.LogConfig;
import software.amazon.awscdk.services.appsync.Visibility;
import software.amazon.awscdk.services.logs.ILogGroup;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appsync.GraphqlApi")
public class GraphqlApi
extends GraphqlApiBase {
    public static final String PROPERTY_INJECTION_ID = (String)JsiiObject.jsiiStaticGet(GraphqlApi.class, (String)"PROPERTY_INJECTION_ID", (NativeType)NativeType.forClass(String.class));

    protected GraphqlApi(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GraphqlApi(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public GraphqlApi(@NotNull Construct scope, @NotNull String id, @NotNull GraphqlApiProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IGraphqlApi fromGraphqlApiAttributes(@NotNull Construct scope, @NotNull String id, @NotNull GraphqlApiAttributes attrs) {
        return (IGraphqlApi)JsiiObject.jsiiStaticCall(GraphqlApi.class, (String)"fromGraphqlApiAttributes", (NativeType)NativeType.forClass(IGraphqlApi.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    public void addEnvironmentVariable(@NotNull String key, @NotNull String value) {
        Kernel.call((Object)this, (String)"addEnvironmentVariable", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), Objects.requireNonNull(value, "value is required")});
    }

    @Override
    @NotNull
    public Boolean addSchemaDependency(@NotNull CfnResource construct) {
        return (Boolean)Kernel.call((Object)this, (String)"addSchemaDependency", (NativeType)NativeType.forClass(Boolean.class), (Object[])new Object[]{Objects.requireNonNull(construct, "construct is required")});
    }

    @Override
    @NotNull
    public String getApiId() {
        return (String)Kernel.get((Object)this, (String)"apiId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAppSyncDomainName() {
        return (String)Kernel.get((Object)this, (String)"appSyncDomainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getArn() {
        return (String)Kernel.get((Object)this, (String)"arn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getGraphQLEndpointArn() {
        return (String)Kernel.get((Object)this, (String)"graphQLEndpointArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getGraphqlUrl() {
        return (String)Kernel.get((Object)this, (String)"graphqlUrl", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public ILogGroup getLogGroup() {
        return (ILogGroup)Kernel.get((Object)this, (String)"logGroup", (NativeType)NativeType.forClass(ILogGroup.class));
    }

    @Override
    @NotNull
    public List<AuthorizationType> getModes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"modes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(AuthorizationType.class))));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public ISchema getSchema() {
        return (ISchema)Kernel.get((Object)this, (String)"schema", (NativeType)NativeType.forClass(ISchema.class));
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return (Visibility)((Object)Kernel.get((Object)this, (String)"visibility", (NativeType)NativeType.forClass(Visibility.class)));
    }

    @Nullable
    public String getApiKey() {
        return (String)Kernel.get((Object)this, (String)"apiKey", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<GraphqlApi> {
        private final Construct scope;
        private final String id;
        private final GraphqlApiProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new GraphqlApiProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder authorizationConfig(AuthorizationConfig authorizationConfig) {
            this.props.authorizationConfig(authorizationConfig);
            return this;
        }

        public Builder definition(Definition definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder domainName(DomainOptions domainName) {
            this.props.domainName(domainName);
            return this;
        }

        public Builder environmentVariables(Map<String, String> environmentVariables) {
            this.props.environmentVariables(environmentVariables);
            return this;
        }

        public Builder introspectionConfig(IntrospectionConfig introspectionConfig) {
            this.props.introspectionConfig(introspectionConfig);
            return this;
        }

        public Builder logConfig(LogConfig logConfig) {
            this.props.logConfig(logConfig);
            return this;
        }

        public Builder ownerContact(String ownerContact) {
            this.props.ownerContact(ownerContact);
            return this;
        }

        public Builder queryDepthLimit(Number queryDepthLimit) {
            this.props.queryDepthLimit(queryDepthLimit);
            return this;
        }

        public Builder resolverCountLimit(Number resolverCountLimit) {
            this.props.resolverCountLimit(resolverCountLimit);
            return this;
        }

        @Deprecated
        public Builder schema(ISchema schema) {
            this.props.schema(schema);
            return this;
        }

        public Builder visibility(Visibility visibility) {
            this.props.visibility(visibility);
            return this;
        }

        public Builder xrayEnabled(Boolean xrayEnabled) {
            this.props.xrayEnabled(xrayEnabled);
            return this;
        }

        public GraphqlApi build() {
            return new GraphqlApi(this.scope, this.id, this.props.build());
        }
    }
}

