/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.batch.EcsEc2ContainerDefinitionProps;
import software.amazon.awscdk.services.batch.EcsVolume;
import software.amazon.awscdk.services.batch.IEcsContainerDefinition;
import software.amazon.awscdk.services.batch.IEcsEc2ContainerDefinition;
import software.amazon.awscdk.services.batch.LinuxParameters;
import software.amazon.awscdk.services.batch.Secret;
import software.amazon.awscdk.services.batch.Ulimit;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.awscdk.services.ecs.LogDriver;
import software.amazon.awscdk.services.ecs.LogDriverConfig;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.EcsEc2ContainerDefinition")
public class EcsEc2ContainerDefinition
extends Construct
implements IEcsEc2ContainerDefinition,
IEcsContainerDefinition {
    public static final String PROPERTY_INJECTION_ID = (String)JsiiObject.jsiiStaticGet(EcsEc2ContainerDefinition.class, (String)"PROPERTY_INJECTION_ID", (NativeType)NativeType.forClass(String.class));

    protected EcsEc2ContainerDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsEc2ContainerDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EcsEc2ContainerDefinition(@NotNull Construct scope, @NotNull String id, @NotNull EcsEc2ContainerDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void addUlimit(@NotNull Ulimit ulimit) {
        Kernel.call((Object)this, (String)"addUlimit", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(ulimit, "ulimit is required")});
    }

    @Override
    public void addVolume(@NotNull EcsVolume volume) {
        Kernel.call((Object)this, (String)"addVolume", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(volume, "volume is required")});
    }

    @Override
    @NotNull
    public Number getCpu() {
        return (Number)Kernel.get((Object)this, (String)"cpu", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @NotNull
    public IRole getExecutionRole() {
        return (IRole)Kernel.get((Object)this, (String)"executionRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @NotNull
    public ContainerImage getImage() {
        return (ContainerImage)((Object)Kernel.get((Object)this, (String)"image", (NativeType)NativeType.forClass(ContainerImage.class)));
    }

    @Override
    @NotNull
    public Size getMemory() {
        return (Size)((Object)Kernel.get((Object)this, (String)"memory", (NativeType)NativeType.forClass(Size.class)));
    }

    @Override
    @NotNull
    public List<Ulimit> getUlimits() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"ulimits", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(Ulimit.class))));
    }

    @Override
    @NotNull
    public List<EcsVolume> getVolumes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"volumes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(EcsVolume.class))));
    }

    @Override
    @Nullable
    public List<String> getCommand() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"command", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    @Nullable
    public Map<String, String> getEnvironment() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"environment", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Override
    @Nullable
    public Number getGpu() {
        return (Number)Kernel.get((Object)this, (String)"gpu", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public IRole getJobRole() {
        return (IRole)Kernel.get((Object)this, (String)"jobRole", (NativeType)NativeType.forClass(IRole.class));
    }

    @Override
    @Nullable
    public LinuxParameters getLinuxParameters() {
        return (LinuxParameters)((Object)Kernel.get((Object)this, (String)"linuxParameters", (NativeType)NativeType.forClass(LinuxParameters.class)));
    }

    @Override
    @Nullable
    public LogDriverConfig getLogDriverConfig() {
        return (LogDriverConfig)Kernel.get((Object)this, (String)"logDriverConfig", (NativeType)NativeType.forClass(LogDriverConfig.class));
    }

    @Override
    @Nullable
    public Boolean getPrivileged() {
        return (Boolean)Kernel.get((Object)this, (String)"privileged", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public Boolean getReadonlyRootFilesystem() {
        return (Boolean)Kernel.get((Object)this, (String)"readonlyRootFilesystem", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public Map<String, Secret> getSecrets() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"secrets", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Secret.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Override
    @Nullable
    public String getUser() {
        return (String)Kernel.get((Object)this, (String)"user", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EcsEc2ContainerDefinition> {
        private final Construct scope;
        private final String id;
        private final EcsEc2ContainerDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EcsEc2ContainerDefinitionProps.Builder();
        }

        public Builder cpu(Number cpu) {
            this.props.cpu(cpu);
            return this;
        }

        public Builder image(ContainerImage image) {
            this.props.image(image);
            return this;
        }

        public Builder memory(Size memory) {
            this.props.memory(memory);
            return this;
        }

        public Builder command(List<String> command) {
            this.props.command(command);
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.props.environment(environment);
            return this;
        }

        public Builder executionRole(IRole executionRole) {
            this.props.executionRole(executionRole);
            return this;
        }

        public Builder jobRole(IRole jobRole) {
            this.props.jobRole(jobRole);
            return this;
        }

        public Builder linuxParameters(LinuxParameters linuxParameters) {
            this.props.linuxParameters(linuxParameters);
            return this;
        }

        public Builder logging(LogDriver logging) {
            this.props.logging(logging);
            return this;
        }

        public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.props.readonlyRootFilesystem(readonlyRootFilesystem);
            return this;
        }

        public Builder secrets(Map<String, ? extends Secret> secrets) {
            this.props.secrets(secrets);
            return this;
        }

        public Builder user(String user) {
            this.props.user(user);
            return this;
        }

        public Builder volumes(List<? extends EcsVolume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        public Builder gpu(Number gpu) {
            this.props.gpu(gpu);
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.props.privileged(privileged);
            return this;
        }

        public Builder ulimits(List<? extends Ulimit> ulimits) {
            this.props.ulimits(ulimits);
            return this;
        }

        public EcsEc2ContainerDefinition build() {
            return new EcsEc2ContainerDefinition(this.scope, this.id, this.props.build());
        }
    }
}

