/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.batch.EksContainerDefinitionProps;
import software.amazon.awscdk.services.batch.EksVolume;
import software.amazon.awscdk.services.batch.IEksContainerDefinition;
import software.amazon.awscdk.services.batch.ImagePullPolicy;
import software.amazon.awscdk.services.ecs.ContainerImage;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.EksContainerDefinition")
public class EksContainerDefinition
extends Construct
implements IEksContainerDefinition {
    public static final String PROPERTY_INJECTION_ID = (String)JsiiObject.jsiiStaticGet(EksContainerDefinition.class, (String)"PROPERTY_INJECTION_ID", (NativeType)NativeType.forClass(String.class));

    protected EksContainerDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EksContainerDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EksContainerDefinition(@NotNull Construct scope, @NotNull String id, @NotNull EksContainerDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void addVolume(@NotNull EksVolume volume) {
        Kernel.call((Object)this, (String)"addVolume", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(volume, "volume is required")});
    }

    @Override
    @NotNull
    public ContainerImage getImage() {
        return (ContainerImage)((Object)Kernel.get((Object)this, (String)"image", (NativeType)NativeType.forClass(ContainerImage.class)));
    }

    @Override
    @NotNull
    public List<EksVolume> getVolumes() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"volumes", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(EksVolume.class))));
    }

    @Override
    @Nullable
    public List<String> getArgs() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"args", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    @Nullable
    public List<String> getCommand() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"command", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    @Override
    @Nullable
    public Number getCpuLimit() {
        return (Number)Kernel.get((Object)this, (String)"cpuLimit", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Number getCpuReservation() {
        return (Number)Kernel.get((Object)this, (String)"cpuReservation", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Map<String, String> getEnv() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"env", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Override
    @Nullable
    public Number getGpuLimit() {
        return (Number)Kernel.get((Object)this, (String)"gpuLimit", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Number getGpuReservation() {
        return (Number)Kernel.get((Object)this, (String)"gpuReservation", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public ImagePullPolicy getImagePullPolicy() {
        return (ImagePullPolicy)((Object)Kernel.get((Object)this, (String)"imagePullPolicy", (NativeType)NativeType.forClass(ImagePullPolicy.class)));
    }

    @Override
    @Nullable
    public Size getMemoryLimit() {
        return (Size)((Object)Kernel.get((Object)this, (String)"memoryLimit", (NativeType)NativeType.forClass(Size.class)));
    }

    @Override
    @Nullable
    public Size getMemoryReservation() {
        return (Size)((Object)Kernel.get((Object)this, (String)"memoryReservation", (NativeType)NativeType.forClass(Size.class)));
    }

    @Override
    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public Boolean getPrivileged() {
        return (Boolean)Kernel.get((Object)this, (String)"privileged", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public Boolean getReadonlyRootFilesystem() {
        return (Boolean)Kernel.get((Object)this, (String)"readonlyRootFilesystem", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public Number getRunAsGroup() {
        return (Number)Kernel.get((Object)this, (String)"runAsGroup", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Boolean getRunAsRoot() {
        return (Boolean)Kernel.get((Object)this, (String)"runAsRoot", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public Number getRunAsUser() {
        return (Number)Kernel.get((Object)this, (String)"runAsUser", (NativeType)NativeType.forClass(Number.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EksContainerDefinition> {
        private final Construct scope;
        private final String id;
        private final EksContainerDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EksContainerDefinitionProps.Builder();
        }

        public Builder image(ContainerImage image) {
            this.props.image(image);
            return this;
        }

        public Builder args(List<String> args) {
            this.props.args(args);
            return this;
        }

        public Builder command(List<String> command) {
            this.props.command(command);
            return this;
        }

        public Builder cpuLimit(Number cpuLimit) {
            this.props.cpuLimit(cpuLimit);
            return this;
        }

        public Builder cpuReservation(Number cpuReservation) {
            this.props.cpuReservation(cpuReservation);
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.props.env(env);
            return this;
        }

        public Builder gpuLimit(Number gpuLimit) {
            this.props.gpuLimit(gpuLimit);
            return this;
        }

        public Builder gpuReservation(Number gpuReservation) {
            this.props.gpuReservation(gpuReservation);
            return this;
        }

        public Builder imagePullPolicy(ImagePullPolicy imagePullPolicy) {
            this.props.imagePullPolicy(imagePullPolicy);
            return this;
        }

        public Builder memoryLimit(Size memoryLimit) {
            this.props.memoryLimit(memoryLimit);
            return this;
        }

        public Builder memoryReservation(Size memoryReservation) {
            this.props.memoryReservation(memoryReservation);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder privileged(Boolean privileged) {
            this.props.privileged(privileged);
            return this;
        }

        public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.props.readonlyRootFilesystem(readonlyRootFilesystem);
            return this;
        }

        public Builder runAsGroup(Number runAsGroup) {
            this.props.runAsGroup(runAsGroup);
            return this;
        }

        public Builder runAsRoot(Boolean runAsRoot) {
            this.props.runAsRoot(runAsRoot);
            return this;
        }

        public Builder runAsUser(Number runAsUser) {
            this.props.runAsUser(runAsUser);
            return this;
        }

        public Builder volumes(List<? extends EksVolume> volumes) {
            this.props.volumes(volumes);
            return this;
        }

        public EksContainerDefinition build() {
            return new EksContainerDefinition(this.scope, this.id, this.props.build());
        }
    }
}

