/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.bedrock;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.bedrock.CfnFlowAlias;
import software.amazon.awscdk.services.bedrock.CfnFlowAliasProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowAlias")
public class CfnFlowAlias
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFlowAlias.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFlowAlias(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowAlias(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFlowAlias(@NotNull Construct scope, @NotNull String id, @NotNull CfnFlowAliasProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrFlowId() {
        return (String)Kernel.get((Object)this, (String)"attrFlowId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrUpdatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrUpdatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getFlowArn() {
        return (String)Kernel.get((Object)this, (String)"flowArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setFlowArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"flowArn", (Object)Objects.requireNonNull(value, "flowArn is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public Object getRoutingConfiguration() {
        return Kernel.get((Object)this, (String)"routingConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRoutingConfiguration(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"routingConfiguration", (Object)Objects.requireNonNull(value, "routingConfiguration is required"));
    }

    public void setRoutingConfiguration(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof FlowAliasRoutingConfigurationListItemProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.bedrock.CfnFlowAlias.FlowAliasRoutingConfigurationListItemProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"routingConfiguration", Objects.requireNonNull(value, "routingConfiguration is required"));
    }

    @Nullable
    public Object getConcurrencyConfiguration() {
        return Kernel.get((Object)this, (String)"concurrencyConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConcurrencyConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"concurrencyConfiguration", (Object)value);
    }

    public void setConcurrencyConfiguration(@Nullable FlowAliasConcurrencyConfigurationProperty value) {
        Kernel.set((Object)this, (String)"concurrencyConfiguration", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Map<String, String> getTags() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowAlias.FlowAliasRoutingConfigurationListItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowAliasRoutingConfigurationListItemProperty
    extends JsiiSerializable {
        @Nullable
        default public String getFlowVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowAliasRoutingConfigurationListItemProperty> {
            String flowVersion;

            public Builder flowVersion(String flowVersion) {
                this.flowVersion = flowVersion;
                return this;
            }

            public FlowAliasRoutingConfigurationListItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFlowAlias> {
        private final Construct scope;
        private final String id;
        private final CfnFlowAliasProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFlowAliasProps.Builder();
        }

        public Builder flowArn(String flowArn) {
            this.props.flowArn(flowArn);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder routingConfiguration(IResolvable routingConfiguration) {
            this.props.routingConfiguration(routingConfiguration);
            return this;
        }

        public Builder routingConfiguration(List<? extends Object> routingConfiguration) {
            this.props.routingConfiguration(routingConfiguration);
            return this;
        }

        public Builder concurrencyConfiguration(IResolvable concurrencyConfiguration) {
            this.props.concurrencyConfiguration(concurrencyConfiguration);
            return this;
        }

        public Builder concurrencyConfiguration(FlowAliasConcurrencyConfigurationProperty concurrencyConfiguration) {
            this.props.concurrencyConfiguration(concurrencyConfiguration);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnFlowAlias build() {
            return new CfnFlowAlias(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowAlias.FlowAliasConcurrencyConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowAliasConcurrencyConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Number getMaxConcurrency() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowAliasConcurrencyConfigurationProperty> {
            String type;
            Number maxConcurrency;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder maxConcurrency(Number maxConcurrency) {
                this.maxConcurrency = maxConcurrency;
                return this;
            }

            public FlowAliasConcurrencyConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

