/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.bedrock;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.bedrock.CfnFlowVersion;
import software.amazon.awscdk.services.bedrock.CfnFlowVersionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion")
public class CfnFlowVersion
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFlowVersion.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFlowVersion(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlowVersion(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFlowVersion(@NotNull Construct scope, @NotNull String id, @NotNull CfnFlowVersionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreatedAt() {
        return (String)Kernel.get((Object)this, (String)"attrCreatedAt", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCustomerEncryptionKeyArn() {
        return (String)Kernel.get((Object)this, (String)"attrCustomerEncryptionKeyArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public IResolvable getAttrDefinition() {
        return (IResolvable)Kernel.get((Object)this, (String)"attrDefinition", (NativeType)NativeType.forClass(IResolvable.class));
    }

    @NotNull
    public String getAttrExecutionRoleArn() {
        return (String)Kernel.get((Object)this, (String)"attrExecutionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrFlowId() {
        return (String)Kernel.get((Object)this, (String)"attrFlowId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)this, (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrVersion() {
        return (String)Kernel.get((Object)this, (String)"attrVersion", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getFlowArn() {
        return (String)Kernel.get((Object)this, (String)"flowArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setFlowArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"flowArn", (Object)Objects.requireNonNull(value, "flowArn is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFlowVersion> {
        private final Construct scope;
        private final String id;
        private final CfnFlowVersionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFlowVersionProps.Builder();
        }

        public Builder flowArn(String flowArn) {
            this.props.flowArn(flowArn);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public CfnFlowVersion build() {
            return new CfnFlowVersion(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.VectorSearchRerankingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VectorSearchRerankingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getBedrockRerankingConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VectorSearchRerankingConfigurationProperty> {
            String type;
            Object bedrockRerankingConfiguration;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder bedrockRerankingConfiguration(IResolvable bedrockRerankingConfiguration) {
                this.bedrockRerankingConfiguration = bedrockRerankingConfiguration;
                return this;
            }

            public Builder bedrockRerankingConfiguration(VectorSearchBedrockRerankingConfigurationProperty bedrockRerankingConfiguration) {
                this.bedrockRerankingConfiguration = bedrockRerankingConfiguration;
                return this;
            }

            public VectorSearchRerankingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.VectorSearchBedrockRerankingModelConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VectorSearchBedrockRerankingModelConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getModelArn();

        @Nullable
        default public Object getAdditionalModelRequestFields() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VectorSearchBedrockRerankingModelConfigurationProperty> {
            String modelArn;
            Object additionalModelRequestFields;

            public Builder modelArn(String modelArn) {
                this.modelArn = modelArn;
                return this;
            }

            public Builder additionalModelRequestFields(Object additionalModelRequestFields) {
                this.additionalModelRequestFields = additionalModelRequestFields;
                return this;
            }

            public VectorSearchBedrockRerankingModelConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.VectorSearchBedrockRerankingConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VectorSearchBedrockRerankingConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getModelConfiguration();

        @Nullable
        default public Object getMetadataConfiguration() {
            return null;
        }

        @Nullable
        default public Number getNumberOfRerankedResults() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VectorSearchBedrockRerankingConfigurationProperty> {
            Object modelConfiguration;
            Object metadataConfiguration;
            Number numberOfRerankedResults;

            public Builder modelConfiguration(IResolvable modelConfiguration) {
                this.modelConfiguration = modelConfiguration;
                return this;
            }

            public Builder modelConfiguration(VectorSearchBedrockRerankingModelConfigurationProperty modelConfiguration) {
                this.modelConfiguration = modelConfiguration;
                return this;
            }

            public Builder metadataConfiguration(IResolvable metadataConfiguration) {
                this.metadataConfiguration = metadataConfiguration;
                return this;
            }

            public Builder metadataConfiguration(MetadataConfigurationForRerankingProperty metadataConfiguration) {
                this.metadataConfiguration = metadataConfiguration;
                return this;
            }

            public Builder numberOfRerankedResults(Number numberOfRerankedResults) {
                this.numberOfRerankedResults = numberOfRerankedResults;
                return this;
            }

            public VectorSearchBedrockRerankingConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.TextPromptTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TextPromptTemplateConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getText();

        @Nullable
        default public Object getInputVariables() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TextPromptTemplateConfigurationProperty> {
            String text;
            Object inputVariables;

            public Builder text(String text) {
                this.text = text;
                return this;
            }

            public Builder inputVariables(IResolvable inputVariables) {
                this.inputVariables = inputVariables;
                return this;
            }

            public Builder inputVariables(List<? extends Object> inputVariables) {
                this.inputVariables = inputVariables;
                return this;
            }

            public TextPromptTemplateConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.StorageFlowNodeServiceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageFlowNodeServiceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StorageFlowNodeServiceConfigurationProperty> {
            Object s3;

            public Builder s3(IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            public Builder s3(StorageFlowNodeS3ConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            public StorageFlowNodeServiceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.StorageFlowNodeS3ConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageFlowNodeS3ConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StorageFlowNodeS3ConfigurationProperty> {
            String bucketName;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public StorageFlowNodeS3ConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.StorageFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StorageFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getServiceConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StorageFlowNodeConfigurationProperty> {
            Object serviceConfiguration;

            public Builder serviceConfiguration(IResolvable serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            public Builder serviceConfiguration(StorageFlowNodeServiceConfigurationProperty serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            public StorageFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.RetrievalFlowNodeServiceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetrievalFlowNodeServiceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getS3() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetrievalFlowNodeServiceConfigurationProperty> {
            Object s3;

            public Builder s3(IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            public Builder s3(RetrievalFlowNodeS3ConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            public RetrievalFlowNodeServiceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.RetrievalFlowNodeS3ConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetrievalFlowNodeS3ConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBucketName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetrievalFlowNodeS3ConfigurationProperty> {
            String bucketName;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public RetrievalFlowNodeS3ConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.RetrievalFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetrievalFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getServiceConfiguration();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetrievalFlowNodeConfigurationProperty> {
            Object serviceConfiguration;

            public Builder serviceConfiguration(IResolvable serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            public Builder serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            public RetrievalFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.RerankingMetadataSelectiveModeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RerankingMetadataSelectiveModeConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFieldsToExclude() {
            return null;
        }

        @Nullable
        default public Object getFieldsToInclude() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RerankingMetadataSelectiveModeConfigurationProperty> {
            Object fieldsToExclude;
            Object fieldsToInclude;

            public Builder fieldsToExclude(IResolvable fieldsToExclude) {
                this.fieldsToExclude = fieldsToExclude;
                return this;
            }

            public Builder fieldsToExclude(List<? extends Object> fieldsToExclude) {
                this.fieldsToExclude = fieldsToExclude;
                return this;
            }

            public Builder fieldsToInclude(IResolvable fieldsToInclude) {
                this.fieldsToInclude = fieldsToInclude;
                return this;
            }

            public Builder fieldsToInclude(List<? extends Object> fieldsToInclude) {
                this.fieldsToInclude = fieldsToInclude;
                return this;
            }

            public RerankingMetadataSelectiveModeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptTemplateConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getText();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptTemplateConfigurationProperty> {
            Object text;

            public Builder text(IResolvable text) {
                this.text = text;
                return this;
            }

            public Builder text(TextPromptTemplateConfigurationProperty text) {
                this.text = text;
                return this;
            }

            public PromptTemplateConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptModelInferenceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptModelInferenceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getMaxTokens() {
            return null;
        }

        @Nullable
        default public List<String> getStopSequences() {
            return null;
        }

        @Nullable
        default public Number getTemperature() {
            return null;
        }

        @Nullable
        default public Number getTopP() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptModelInferenceConfigurationProperty> {
            Number maxTokens;
            List<String> stopSequences;
            Number temperature;
            Number topP;

            public Builder maxTokens(Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            public Builder stopSequences(List<String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            public Builder temperature(Number temperature) {
                this.temperature = temperature;
                return this;
            }

            public Builder topP(Number topP) {
                this.topP = topP;
                return this;
            }

            public PromptModelInferenceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptInputVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptInputVariableProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptInputVariableProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public PromptInputVariableProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptInferenceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptInferenceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getText();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptInferenceConfigurationProperty> {
            Object text;

            public Builder text(IResolvable text) {
                this.text = text;
                return this;
            }

            public Builder text(PromptModelInferenceConfigurationProperty text) {
                this.text = text;
                return this;
            }

            public PromptInferenceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeSourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptFlowNodeSourceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getInline() {
            return null;
        }

        @Nullable
        default public Object getResource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptFlowNodeSourceConfigurationProperty> {
            Object inline;
            Object resource;

            public Builder inline(IResolvable inline) {
                this.inline = inline;
                return this;
            }

            public Builder inline(PromptFlowNodeInlineConfigurationProperty inline) {
                this.inline = inline;
                return this;
            }

            public Builder resource(IResolvable resource) {
                this.resource = resource;
                return this;
            }

            public Builder resource(PromptFlowNodeResourceConfigurationProperty resource) {
                this.resource = resource;
                return this;
            }

            public PromptFlowNodeSourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeResourceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptFlowNodeResourceConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getPromptArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptFlowNodeResourceConfigurationProperty> {
            String promptArn;

            public Builder promptArn(String promptArn) {
                this.promptArn = promptArn;
                return this;
            }

            public PromptFlowNodeResourceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeInlineConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptFlowNodeInlineConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getModelId();

        @NotNull
        public Object getTemplateConfiguration();

        @NotNull
        public String getTemplateType();

        @Nullable
        default public Object getInferenceConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptFlowNodeInlineConfigurationProperty> {
            String modelId;
            Object templateConfiguration;
            String templateType;
            Object inferenceConfiguration;

            public Builder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public Builder templateConfiguration(IResolvable templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            public Builder templateConfiguration(PromptTemplateConfigurationProperty templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            public Builder templateType(String templateType) {
                this.templateType = templateType;
                return this;
            }

            public Builder inferenceConfiguration(IResolvable inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            public Builder inferenceConfiguration(PromptInferenceConfigurationProperty inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            public PromptFlowNodeInlineConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.PromptFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PromptFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getSourceConfiguration();

        @Nullable
        default public Object getGuardrailConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PromptFlowNodeConfigurationProperty> {
            Object sourceConfiguration;
            Object guardrailConfiguration;

            public Builder sourceConfiguration(IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder sourceConfiguration(PromptFlowNodeSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            public Builder guardrailConfiguration(IResolvable guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            public Builder guardrailConfiguration(GuardrailConfigurationProperty guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            public PromptFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.PerformanceConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PerformanceConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLatency() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PerformanceConfigurationProperty> {
            String latency;

            public Builder latency(String latency) {
                this.latency = latency;
                return this;
            }

            public PerformanceConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.MetadataConfigurationForRerankingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetadataConfigurationForRerankingProperty
    extends JsiiSerializable {
        @NotNull
        public String getSelectionMode();

        @Nullable
        default public Object getSelectiveModeConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetadataConfigurationForRerankingProperty> {
            String selectionMode;
            Object selectiveModeConfiguration;

            public Builder selectionMode(String selectionMode) {
                this.selectionMode = selectionMode;
                return this;
            }

            public Builder selectiveModeConfiguration(IResolvable selectiveModeConfiguration) {
                this.selectiveModeConfiguration = selectiveModeConfiguration;
                return this;
            }

            public Builder selectiveModeConfiguration(RerankingMetadataSelectiveModeConfigurationProperty selectiveModeConfiguration) {
                this.selectiveModeConfiguration = selectiveModeConfiguration;
                return this;
            }

            public MetadataConfigurationForRerankingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.LoopFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoopFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDefinition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoopFlowNodeConfigurationProperty> {
            Object definition;

            public Builder definition(IResolvable definition) {
                this.definition = definition;
                return this;
            }

            public Builder definition(FlowDefinitionProperty definition) {
                this.definition = definition;
                return this;
            }

            public LoopFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.LoopControllerFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LoopControllerFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getContinueCondition();

        @Nullable
        default public Number getMaxIterations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LoopControllerFlowNodeConfigurationProperty> {
            Object continueCondition;
            Number maxIterations;

            public Builder continueCondition(IResolvable continueCondition) {
                this.continueCondition = continueCondition;
                return this;
            }

            public Builder continueCondition(FlowConditionProperty continueCondition) {
                this.continueCondition = continueCondition;
                return this;
            }

            public Builder maxIterations(Number maxIterations) {
                this.maxIterations = maxIterations;
                return this;
            }

            public LoopControllerFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.LexFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LexFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getBotAliasArn();

        @NotNull
        public String getLocaleId();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LexFlowNodeConfigurationProperty> {
            String botAliasArn;
            String localeId;

            public Builder botAliasArn(String botAliasArn) {
                this.botAliasArn = botAliasArn;
                return this;
            }

            public Builder localeId(String localeId) {
                this.localeId = localeId;
                return this;
            }

            public LexFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.LambdaFunctionFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LambdaFunctionFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getLambdaArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LambdaFunctionFlowNodeConfigurationProperty> {
            String lambdaArn;

            public Builder lambdaArn(String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            public LambdaFunctionFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.KnowledgeBasePromptTemplateProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KnowledgeBasePromptTemplateProperty
    extends JsiiSerializable {
        @NotNull
        public String getTextPromptTemplate();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KnowledgeBasePromptTemplateProperty> {
            String textPromptTemplate;

            public Builder textPromptTemplate(String textPromptTemplate) {
                this.textPromptTemplate = textPromptTemplate;
                return this;
            }

            public KnowledgeBasePromptTemplateProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.KnowledgeBaseOrchestrationConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KnowledgeBaseOrchestrationConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAdditionalModelRequestFields() {
            return null;
        }

        @Nullable
        default public Object getInferenceConfig() {
            return null;
        }

        @Nullable
        default public Object getPerformanceConfig() {
            return null;
        }

        @Nullable
        default public Object getPromptTemplate() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KnowledgeBaseOrchestrationConfigurationProperty> {
            Object additionalModelRequestFields;
            Object inferenceConfig;
            Object performanceConfig;
            Object promptTemplate;

            public Builder additionalModelRequestFields(Object additionalModelRequestFields) {
                this.additionalModelRequestFields = additionalModelRequestFields;
                return this;
            }

            public Builder inferenceConfig(IResolvable inferenceConfig) {
                this.inferenceConfig = inferenceConfig;
                return this;
            }

            public Builder inferenceConfig(PromptInferenceConfigurationProperty inferenceConfig) {
                this.inferenceConfig = inferenceConfig;
                return this;
            }

            public Builder performanceConfig(IResolvable performanceConfig) {
                this.performanceConfig = performanceConfig;
                return this;
            }

            public Builder performanceConfig(PerformanceConfigurationProperty performanceConfig) {
                this.performanceConfig = performanceConfig;
                return this;
            }

            public Builder promptTemplate(IResolvable promptTemplate) {
                this.promptTemplate = promptTemplate;
                return this;
            }

            public Builder promptTemplate(KnowledgeBasePromptTemplateProperty promptTemplate) {
                this.promptTemplate = promptTemplate;
                return this;
            }

            public KnowledgeBaseOrchestrationConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.KnowledgeBaseFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KnowledgeBaseFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getKnowledgeBaseId();

        @Nullable
        default public Object getGuardrailConfiguration() {
            return null;
        }

        @Nullable
        default public Object getInferenceConfiguration() {
            return null;
        }

        @Nullable
        default public String getModelId() {
            return null;
        }

        @Nullable
        default public Number getNumberOfResults() {
            return null;
        }

        @Nullable
        default public Object getOrchestrationConfiguration() {
            return null;
        }

        @Nullable
        default public Object getPromptTemplate() {
            return null;
        }

        @Nullable
        default public Object getRerankingConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KnowledgeBaseFlowNodeConfigurationProperty> {
            String knowledgeBaseId;
            Object guardrailConfiguration;
            Object inferenceConfiguration;
            String modelId;
            Number numberOfResults;
            Object orchestrationConfiguration;
            Object promptTemplate;
            Object rerankingConfiguration;

            public Builder knowledgeBaseId(String knowledgeBaseId) {
                this.knowledgeBaseId = knowledgeBaseId;
                return this;
            }

            public Builder guardrailConfiguration(IResolvable guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            public Builder guardrailConfiguration(GuardrailConfigurationProperty guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            public Builder inferenceConfiguration(IResolvable inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            public Builder inferenceConfiguration(PromptInferenceConfigurationProperty inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            public Builder modelId(String modelId) {
                this.modelId = modelId;
                return this;
            }

            public Builder numberOfResults(Number numberOfResults) {
                this.numberOfResults = numberOfResults;
                return this;
            }

            public Builder orchestrationConfiguration(IResolvable orchestrationConfiguration) {
                this.orchestrationConfiguration = orchestrationConfiguration;
                return this;
            }

            public Builder orchestrationConfiguration(KnowledgeBaseOrchestrationConfigurationProperty orchestrationConfiguration) {
                this.orchestrationConfiguration = orchestrationConfiguration;
                return this;
            }

            public Builder promptTemplate(IResolvable promptTemplate) {
                this.promptTemplate = promptTemplate;
                return this;
            }

            public Builder promptTemplate(KnowledgeBasePromptTemplateProperty promptTemplate) {
                this.promptTemplate = promptTemplate;
                return this;
            }

            public Builder rerankingConfiguration(IResolvable rerankingConfiguration) {
                this.rerankingConfiguration = rerankingConfiguration;
                return this;
            }

            public Builder rerankingConfiguration(VectorSearchRerankingConfigurationProperty rerankingConfiguration) {
                this.rerankingConfiguration = rerankingConfiguration;
                return this;
            }

            public KnowledgeBaseFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.InlineCodeFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface InlineCodeFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getCode();

        @NotNull
        public String getLanguage();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<InlineCodeFlowNodeConfigurationProperty> {
            String code;
            String language;

            public Builder code(String code) {
                this.code = code;
                return this;
            }

            public Builder language(String language) {
                this.language = language;
                return this;
            }

            public InlineCodeFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.GuardrailConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface GuardrailConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getGuardrailIdentifier() {
            return null;
        }

        @Nullable
        default public String getGuardrailVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<GuardrailConfigurationProperty> {
            String guardrailIdentifier;
            String guardrailVersion;

            public Builder guardrailIdentifier(String guardrailIdentifier) {
                this.guardrailIdentifier = guardrailIdentifier;
                return this;
            }

            public Builder guardrailVersion(String guardrailVersion) {
                this.guardrailVersion = guardrailVersion;
                return this;
            }

            public GuardrailConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowNodeProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getType();

        @Nullable
        default public Object getConfiguration() {
            return null;
        }

        @Nullable
        default public Object getInputs() {
            return null;
        }

        @Nullable
        default public Object getOutputs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowNodeProperty> {
            String name;
            String type;
            Object configuration;
            Object inputs;
            Object outputs;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder configuration(IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder configuration(FlowNodeConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder inputs(IResolvable inputs) {
                this.inputs = inputs;
                return this;
            }

            public Builder inputs(List<? extends Object> inputs) {
                this.inputs = inputs;
                return this;
            }

            public Builder outputs(IResolvable outputs) {
                this.outputs = outputs;
                return this;
            }

            public Builder outputs(List<? extends Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            public FlowNodeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowNodeOutputProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowNodeOutputProperty> {
            String name;
            String type;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FlowNodeOutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowNodeInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getExpression();

        @NotNull
        public String getName();

        @NotNull
        public String getType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowNodeInputProperty> {
            String expression;
            String name;
            String type;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public FlowNodeInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowNodeConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAgent() {
            return null;
        }

        @Nullable
        default public Object getCollector() {
            return null;
        }

        @Nullable
        default public Object getCondition() {
            return null;
        }

        @Nullable
        default public Object getInlineCode() {
            return null;
        }

        @Nullable
        default public Object getInput() {
            return null;
        }

        @Nullable
        default public Object getIterator() {
            return null;
        }

        @Nullable
        default public Object getKnowledgeBase() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunction() {
            return null;
        }

        @Nullable
        default public Object getLex() {
            return null;
        }

        @Nullable
        default public Object getLoop() {
            return null;
        }

        @Nullable
        default public Object getLoopController() {
            return null;
        }

        @Nullable
        default public Object getLoopInput() {
            return null;
        }

        @Nullable
        default public Object getOutput() {
            return null;
        }

        @Nullable
        default public Object getPrompt() {
            return null;
        }

        @Nullable
        default public Object getRetrieval() {
            return null;
        }

        @Nullable
        default public Object getStorage() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowNodeConfigurationProperty> {
            Object agent;
            Object collector;
            Object condition;
            Object inlineCode;
            Object input;
            Object iterator;
            Object knowledgeBase;
            Object lambdaFunction;
            Object lex;
            Object loop;
            Object loopController;
            Object loopInput;
            Object output;
            Object prompt;
            Object retrieval;
            Object storage;

            public Builder agent(IResolvable agent) {
                this.agent = agent;
                return this;
            }

            public Builder agent(AgentFlowNodeConfigurationProperty agent) {
                this.agent = agent;
                return this;
            }

            public Builder collector(Object collector) {
                this.collector = collector;
                return this;
            }

            public Builder condition(IResolvable condition) {
                this.condition = condition;
                return this;
            }

            public Builder condition(ConditionFlowNodeConfigurationProperty condition) {
                this.condition = condition;
                return this;
            }

            public Builder inlineCode(IResolvable inlineCode) {
                this.inlineCode = inlineCode;
                return this;
            }

            public Builder inlineCode(InlineCodeFlowNodeConfigurationProperty inlineCode) {
                this.inlineCode = inlineCode;
                return this;
            }

            public Builder input(Object input) {
                this.input = input;
                return this;
            }

            public Builder iterator(Object iterator) {
                this.iterator = iterator;
                return this;
            }

            public Builder knowledgeBase(IResolvable knowledgeBase) {
                this.knowledgeBase = knowledgeBase;
                return this;
            }

            public Builder knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty knowledgeBase) {
                this.knowledgeBase = knowledgeBase;
                return this;
            }

            public Builder lambdaFunction(IResolvable lambdaFunction) {
                this.lambdaFunction = lambdaFunction;
                return this;
            }

            public Builder lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty lambdaFunction) {
                this.lambdaFunction = lambdaFunction;
                return this;
            }

            public Builder lex(IResolvable lex) {
                this.lex = lex;
                return this;
            }

            public Builder lex(LexFlowNodeConfigurationProperty lex) {
                this.lex = lex;
                return this;
            }

            public Builder loop(IResolvable loop) {
                this.loop = loop;
                return this;
            }

            public Builder loop(LoopFlowNodeConfigurationProperty loop) {
                this.loop = loop;
                return this;
            }

            public Builder loopController(IResolvable loopController) {
                this.loopController = loopController;
                return this;
            }

            public Builder loopController(LoopControllerFlowNodeConfigurationProperty loopController) {
                this.loopController = loopController;
                return this;
            }

            public Builder loopInput(Object loopInput) {
                this.loopInput = loopInput;
                return this;
            }

            public Builder output(Object output) {
                this.output = output;
                return this;
            }

            public Builder prompt(IResolvable prompt) {
                this.prompt = prompt;
                return this;
            }

            public Builder prompt(PromptFlowNodeConfigurationProperty prompt) {
                this.prompt = prompt;
                return this;
            }

            public Builder retrieval(IResolvable retrieval) {
                this.retrieval = retrieval;
                return this;
            }

            public Builder retrieval(RetrievalFlowNodeConfigurationProperty retrieval) {
                this.retrieval = retrieval;
                return this;
            }

            public Builder storage(IResolvable storage) {
                this.storage = storage;
                return this;
            }

            public Builder storage(StorageFlowNodeConfigurationProperty storage) {
                this.storage = storage;
                return this;
            }

            public FlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowDefinitionProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConnections() {
            return null;
        }

        @Nullable
        default public Object getNodes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowDefinitionProperty> {
            Object connections;
            Object nodes;

            public Builder connections(IResolvable connections) {
                this.connections = connections;
                return this;
            }

            public Builder connections(List<? extends Object> connections) {
                this.connections = connections;
                return this;
            }

            public Builder nodes(IResolvable nodes) {
                this.nodes = nodes;
                return this;
            }

            public Builder nodes(List<? extends Object> nodes) {
                this.nodes = nodes;
                return this;
            }

            public FlowDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowDataConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowDataConnectionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getSourceOutput();

        @NotNull
        public String getTargetInput();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowDataConnectionConfigurationProperty> {
            String sourceOutput;
            String targetInput;

            public Builder sourceOutput(String sourceOutput) {
                this.sourceOutput = sourceOutput;
                return this;
            }

            public Builder targetInput(String targetInput) {
                this.targetInput = targetInput;
                return this;
            }

            public FlowDataConnectionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConnectionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowConnectionProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getSource();

        @NotNull
        public String getTarget();

        @NotNull
        public String getType();

        @Nullable
        default public Object getConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowConnectionProperty> {
            String name;
            String source;
            String target;
            String type;
            Object configuration;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder source(String source) {
                this.source = source;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder configuration(IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            public Builder configuration(FlowConnectionConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            public FlowConnectionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowConnectionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConditional() {
            return null;
        }

        @Nullable
        default public Object getData() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowConnectionConfigurationProperty> {
            Object conditional;
            Object data;

            public Builder conditional(IResolvable conditional) {
                this.conditional = conditional;
                return this;
            }

            public Builder conditional(FlowConditionalConnectionConfigurationProperty conditional) {
                this.conditional = conditional;
                return this;
            }

            public Builder data(IResolvable data) {
                this.data = data;
                return this;
            }

            public Builder data(FlowDataConnectionConfigurationProperty data) {
                this.data = data;
                return this;
            }

            public FlowConnectionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConditionalConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowConditionalConnectionConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getCondition();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowConditionalConnectionConfigurationProperty> {
            String condition;

            public Builder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public FlowConditionalConnectionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FlowConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FlowConditionProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public String getExpression() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FlowConditionProperty> {
            String name;
            String expression;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public FlowConditionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.FieldForRerankingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FieldForRerankingProperty
    extends JsiiSerializable {
        @NotNull
        public String getFieldName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FieldForRerankingProperty> {
            String fieldName;

            public Builder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public FieldForRerankingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.ConditionFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConditionFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Object getConditions();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConditionFlowNodeConfigurationProperty> {
            Object conditions;

            public Builder conditions(IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            public Builder conditions(List<? extends Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            public ConditionFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_bedrock.CfnFlowVersion.AgentFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AgentFlowNodeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAgentAliasArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AgentFlowNodeConfigurationProperty> {
            String agentAliasArn;

            public Builder agentAliasArn(String agentAliasArn) {
                this.agentAliasArn = agentAliasArn;
                return this;
            }

            public AgentFlowNodeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

