/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudfront;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.services.cloudfront.IVpcOrigin;
import software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy;
import software.amazon.awscdk.services.cloudfront.OriginSslPolicy;
import software.amazon.awscdk.services.cloudfront.VpcOriginAttributes;
import software.amazon.awscdk.services.cloudfront.VpcOriginEndpoint;
import software.amazon.awscdk.services.cloudfront.VpcOriginProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudfront.VpcOrigin")
public class VpcOrigin
extends Resource
implements IVpcOrigin,
ITaggableV2 {
    public static final String PROPERTY_INJECTION_ID = (String)JsiiObject.jsiiStaticGet(VpcOrigin.class, (String)"PROPERTY_INJECTION_ID", (NativeType)NativeType.forClass(String.class));

    protected VpcOrigin(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcOrigin(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public VpcOrigin(@NotNull Construct scope, @NotNull String id, @NotNull VpcOriginProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IVpcOrigin fromVpcOriginArn(@NotNull Construct scope, @NotNull String id, @NotNull String vpcOriginArn) {
        return (IVpcOrigin)JsiiObject.jsiiStaticCall(VpcOrigin.class, (String)"fromVpcOriginArn", (NativeType)NativeType.forClass(IVpcOrigin.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(vpcOriginArn, "vpcOriginArn is required")});
    }

    @NotNull
    public static IVpcOrigin fromVpcOriginAttributes(@NotNull Construct scope, @NotNull String id, @NotNull VpcOriginAttributes attrs) {
        return (IVpcOrigin)JsiiObject.jsiiStaticCall(VpcOrigin.class, (String)"fromVpcOriginAttributes", (NativeType)NativeType.forClass(IVpcOrigin.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IVpcOrigin fromVpcOriginId(@NotNull Construct scope, @NotNull String id, @NotNull String vpcOriginId) {
        return (IVpcOrigin)JsiiObject.jsiiStaticCall(VpcOrigin.class, (String)"fromVpcOriginId", (NativeType)NativeType.forClass(IVpcOrigin.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(vpcOriginId, "vpcOriginId is required")});
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    public String getVpcOriginArn() {
        return (String)Kernel.get((Object)this, (String)"vpcOriginArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getVpcOriginId() {
        return (String)Kernel.get((Object)this, (String)"vpcOriginId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public String getDomainName() {
        return (String)Kernel.get((Object)this, (String)"domainName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<VpcOrigin> {
        private final Construct scope;
        private final String id;
        private final VpcOriginProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new VpcOriginProps.Builder();
        }

        public Builder httpPort(Number httpPort) {
            this.props.httpPort(httpPort);
            return this;
        }

        public Builder httpsPort(Number httpsPort) {
            this.props.httpsPort(httpsPort);
            return this;
        }

        public Builder originSslProtocols(List<? extends OriginSslPolicy> originSslProtocols) {
            this.props.originSslProtocols(originSslProtocols);
            return this;
        }

        public Builder protocolPolicy(OriginProtocolPolicy protocolPolicy) {
            this.props.protocolPolicy(protocolPolicy);
            return this;
        }

        public Builder vpcOriginName(String vpcOriginName) {
            this.props.vpcOriginName(vpcOriginName);
            return this;
        }

        public Builder endpoint(VpcOriginEndpoint endpoint) {
            this.props.endpoint(endpoint);
            return this;
        }

        public VpcOrigin build() {
            return new VpcOrigin(this.scope, this.id, this.props.build());
        }
    }
}

