/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.gameliftstreams;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.gameliftstreams.CfnApplication;
import software.amazon.awscdk.services.gameliftstreams.CfnApplicationProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_gameliftstreams.CfnApplication")
public class CfnApplication
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnApplication.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnApplication(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnApplication(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnApplication(@NotNull Construct scope, @NotNull String id, @NotNull CfnApplicationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getApplicationSourceUri() {
        return (String)Kernel.get((Object)this, (String)"applicationSourceUri", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationSourceUri(@NotNull String value) {
        Kernel.set((Object)this, (String)"applicationSourceUri", (Object)Objects.requireNonNull(value, "applicationSourceUri is required"));
    }

    @NotNull
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@NotNull String value) {
        Kernel.set((Object)this, (String)"description", (Object)Objects.requireNonNull(value, "description is required"));
    }

    @NotNull
    public String getExecutablePath() {
        return (String)Kernel.get((Object)this, (String)"executablePath", (NativeType)NativeType.forClass(String.class));
    }

    public void setExecutablePath(@NotNull String value) {
        Kernel.set((Object)this, (String)"executablePath", (Object)Objects.requireNonNull(value, "executablePath is required"));
    }

    @NotNull
    public Object getRuntimeEnvironment() {
        return Kernel.get((Object)this, (String)"runtimeEnvironment", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRuntimeEnvironment(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"runtimeEnvironment", (Object)Objects.requireNonNull(value, "runtimeEnvironment is required"));
    }

    public void setRuntimeEnvironment(@NotNull RuntimeEnvironmentProperty value) {
        Kernel.set((Object)this, (String)"runtimeEnvironment", (Object)Objects.requireNonNull(value, "runtimeEnvironment is required"));
    }

    @Nullable
    public String getApplicationLogOutputUri() {
        return (String)Kernel.get((Object)this, (String)"applicationLogOutputUri", (NativeType)NativeType.forClass(String.class));
    }

    public void setApplicationLogOutputUri(@Nullable String value) {
        Kernel.set((Object)this, (String)"applicationLogOutputUri", (Object)value);
    }

    @Nullable
    public List<String> getApplicationLogPaths() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"applicationLogPaths", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setApplicationLogPaths(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"applicationLogPaths", value);
    }

    @Nullable
    public Map<String, String> getTags() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnApplication> {
        private final Construct scope;
        private final String id;
        private final CfnApplicationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnApplicationProps.Builder();
        }

        public Builder applicationSourceUri(String applicationSourceUri) {
            this.props.applicationSourceUri(applicationSourceUri);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder executablePath(String executablePath) {
            this.props.executablePath(executablePath);
            return this;
        }

        public Builder runtimeEnvironment(IResolvable runtimeEnvironment) {
            this.props.runtimeEnvironment(runtimeEnvironment);
            return this;
        }

        public Builder runtimeEnvironment(RuntimeEnvironmentProperty runtimeEnvironment) {
            this.props.runtimeEnvironment(runtimeEnvironment);
            return this;
        }

        public Builder applicationLogOutputUri(String applicationLogOutputUri) {
            this.props.applicationLogOutputUri(applicationLogOutputUri);
            return this;
        }

        public Builder applicationLogPaths(List<String> applicationLogPaths) {
            this.props.applicationLogPaths(applicationLogPaths);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnApplication build() {
            return new CfnApplication(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_gameliftstreams.CfnApplication.RuntimeEnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuntimeEnvironmentProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @NotNull
        public String getVersion();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RuntimeEnvironmentProperty> {
            String type;
            String version;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder version(String version) {
                this.version = version;
                return this;
            }

            public RuntimeEnvironmentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

