/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.inspectorv2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.inspectorv2.CfnFilter;
import software.amazon.awscdk.services.inspectorv2.CfnFilterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_inspectorv2.CfnFilter")
public class CfnFilter
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnFilter.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnFilter(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFilter(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnFilter(@NotNull Construct scope, @NotNull String id, @NotNull CfnFilterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getFilterAction() {
        return (String)Kernel.get((Object)this, (String)"filterAction", (NativeType)NativeType.forClass(String.class));
    }

    public void setFilterAction(@NotNull String value) {
        Kernel.set((Object)this, (String)"filterAction", (Object)Objects.requireNonNull(value, "filterAction is required"));
    }

    @NotNull
    public Object getFilterCriteria() {
        return Kernel.get((Object)this, (String)"filterCriteria", (NativeType)NativeType.forClass(Object.class));
    }

    public void setFilterCriteria(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"filterCriteria", (Object)Objects.requireNonNull(value, "filterCriteria is required"));
    }

    public void setFilterCriteria(@NotNull FilterCriteriaProperty value) {
        Kernel.set((Object)this, (String)"filterCriteria", (Object)Objects.requireNonNull(value, "filterCriteria is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Map<String, String> getTags() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTags(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnFilter> {
        private final Construct scope;
        private final String id;
        private final CfnFilterProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnFilterProps.Builder();
        }

        public Builder filterAction(String filterAction) {
            this.props.filterAction(filterAction);
            return this;
        }

        public Builder filterCriteria(IResolvable filterCriteria) {
            this.props.filterCriteria(filterCriteria);
            return this;
        }

        public Builder filterCriteria(FilterCriteriaProperty filterCriteria) {
            this.props.filterCriteria(filterCriteria);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnFilter build() {
            return new CfnFilter(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_inspectorv2.CfnFilter.StringFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StringFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getComparison();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StringFilterProperty> {
            String comparison;
            String value;

            public Builder comparison(String comparison) {
                this.comparison = comparison;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public StringFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_inspectorv2.CfnFilter.PortRangeFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PortRangeFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBeginInclusive() {
            return null;
        }

        @Nullable
        default public Number getEndInclusive() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PortRangeFilterProperty> {
            Number beginInclusive;
            Number endInclusive;

            public Builder beginInclusive(Number beginInclusive) {
                this.beginInclusive = beginInclusive;
                return this;
            }

            public Builder endInclusive(Number endInclusive) {
                this.endInclusive = endInclusive;
                return this;
            }

            public PortRangeFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_inspectorv2.CfnFilter.PackageFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PackageFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getArchitecture() {
            return null;
        }

        @Nullable
        default public Object getEpoch() {
            return null;
        }

        @Nullable
        default public Object getFilePath() {
            return null;
        }

        @Nullable
        default public Object getName() {
            return null;
        }

        @Nullable
        default public Object getRelease() {
            return null;
        }

        @Nullable
        default public Object getSourceLambdaLayerArn() {
            return null;
        }

        @Nullable
        default public Object getSourceLayerHash() {
            return null;
        }

        @Nullable
        default public Object getVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PackageFilterProperty> {
            Object architecture;
            Object epoch;
            Object filePath;
            Object name;
            Object release;
            Object sourceLambdaLayerArn;
            Object sourceLayerHash;
            Object version;

            public Builder architecture(IResolvable architecture) {
                this.architecture = architecture;
                return this;
            }

            public Builder architecture(StringFilterProperty architecture) {
                this.architecture = architecture;
                return this;
            }

            public Builder epoch(IResolvable epoch) {
                this.epoch = epoch;
                return this;
            }

            public Builder epoch(NumberFilterProperty epoch) {
                this.epoch = epoch;
                return this;
            }

            public Builder filePath(IResolvable filePath) {
                this.filePath = filePath;
                return this;
            }

            public Builder filePath(StringFilterProperty filePath) {
                this.filePath = filePath;
                return this;
            }

            public Builder name(IResolvable name) {
                this.name = name;
                return this;
            }

            public Builder name(StringFilterProperty name) {
                this.name = name;
                return this;
            }

            public Builder release(IResolvable release) {
                this.release = release;
                return this;
            }

            public Builder release(StringFilterProperty release) {
                this.release = release;
                return this;
            }

            public Builder sourceLambdaLayerArn(IResolvable sourceLambdaLayerArn) {
                this.sourceLambdaLayerArn = sourceLambdaLayerArn;
                return this;
            }

            public Builder sourceLambdaLayerArn(StringFilterProperty sourceLambdaLayerArn) {
                this.sourceLambdaLayerArn = sourceLambdaLayerArn;
                return this;
            }

            public Builder sourceLayerHash(IResolvable sourceLayerHash) {
                this.sourceLayerHash = sourceLayerHash;
                return this;
            }

            public Builder sourceLayerHash(StringFilterProperty sourceLayerHash) {
                this.sourceLayerHash = sourceLayerHash;
                return this;
            }

            public Builder version(IResolvable version) {
                this.version = version;
                return this;
            }

            public Builder version(StringFilterProperty version) {
                this.version = version;
                return this;
            }

            public PackageFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_inspectorv2.CfnFilter.NumberFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NumberFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getLowerInclusive() {
            return null;
        }

        @Nullable
        default public Number getUpperInclusive() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NumberFilterProperty> {
            Number lowerInclusive;
            Number upperInclusive;

            public Builder lowerInclusive(Number lowerInclusive) {
                this.lowerInclusive = lowerInclusive;
                return this;
            }

            public Builder upperInclusive(Number upperInclusive) {
                this.upperInclusive = upperInclusive;
                return this;
            }

            public NumberFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_inspectorv2.CfnFilter.MapFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MapFilterProperty
    extends JsiiSerializable {
        @NotNull
        public String getComparison();

        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MapFilterProperty> {
            String comparison;
            String key;
            String value;

            public Builder comparison(String comparison) {
                this.comparison = comparison;
                return this;
            }

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public MapFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_inspectorv2.CfnFilter.FilterCriteriaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterCriteriaProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAwsAccountId() {
            return null;
        }

        @Nullable
        default public Object getCodeVulnerabilityDetectorName() {
            return null;
        }

        @Nullable
        default public Object getCodeVulnerabilityDetectorTags() {
            return null;
        }

        @Nullable
        default public Object getCodeVulnerabilityFilePath() {
            return null;
        }

        @Nullable
        default public Object getComponentId() {
            return null;
        }

        @Nullable
        default public Object getComponentType() {
            return null;
        }

        @Nullable
        default public Object getEc2InstanceImageId() {
            return null;
        }

        @Nullable
        default public Object getEc2InstanceSubnetId() {
            return null;
        }

        @Nullable
        default public Object getEc2InstanceVpcId() {
            return null;
        }

        @Nullable
        default public Object getEcrImageArchitecture() {
            return null;
        }

        @Nullable
        default public Object getEcrImageHash() {
            return null;
        }

        @Nullable
        default public Object getEcrImagePushedAt() {
            return null;
        }

        @Nullable
        default public Object getEcrImageRegistry() {
            return null;
        }

        @Nullable
        default public Object getEcrImageRepositoryName() {
            return null;
        }

        @Nullable
        default public Object getEcrImageTags() {
            return null;
        }

        @Nullable
        default public Object getEpssScore() {
            return null;
        }

        @Nullable
        default public Object getExploitAvailable() {
            return null;
        }

        @Nullable
        default public Object getFindingArn() {
            return null;
        }

        @Nullable
        default public Object getFindingStatus() {
            return null;
        }

        @Nullable
        default public Object getFindingType() {
            return null;
        }

        @Nullable
        default public Object getFirstObservedAt() {
            return null;
        }

        @Nullable
        default public Object getFixAvailable() {
            return null;
        }

        @Nullable
        default public Object getInspectorScore() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunctionExecutionRoleArn() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunctionLastModifiedAt() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunctionLayers() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunctionName() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunctionRuntime() {
            return null;
        }

        @Nullable
        default public Object getLastObservedAt() {
            return null;
        }

        @Nullable
        default public Object getNetworkProtocol() {
            return null;
        }

        @Nullable
        default public Object getPortRange() {
            return null;
        }

        @Nullable
        default public Object getRelatedVulnerabilities() {
            return null;
        }

        @Nullable
        default public Object getResourceId() {
            return null;
        }

        @Nullable
        default public Object getResourceTags() {
            return null;
        }

        @Nullable
        default public Object getResourceType() {
            return null;
        }

        @Nullable
        default public Object getSeverity() {
            return null;
        }

        @Nullable
        default public Object getTitle() {
            return null;
        }

        @Nullable
        default public Object getUpdatedAt() {
            return null;
        }

        @Nullable
        default public Object getVendorSeverity() {
            return null;
        }

        @Nullable
        default public Object getVulnerabilityId() {
            return null;
        }

        @Nullable
        default public Object getVulnerabilitySource() {
            return null;
        }

        @Nullable
        default public Object getVulnerablePackages() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterCriteriaProperty> {
            Object awsAccountId;
            Object codeVulnerabilityDetectorName;
            Object codeVulnerabilityDetectorTags;
            Object codeVulnerabilityFilePath;
            Object componentId;
            Object componentType;
            Object ec2InstanceImageId;
            Object ec2InstanceSubnetId;
            Object ec2InstanceVpcId;
            Object ecrImageArchitecture;
            Object ecrImageHash;
            Object ecrImagePushedAt;
            Object ecrImageRegistry;
            Object ecrImageRepositoryName;
            Object ecrImageTags;
            Object epssScore;
            Object exploitAvailable;
            Object findingArn;
            Object findingStatus;
            Object findingType;
            Object firstObservedAt;
            Object fixAvailable;
            Object inspectorScore;
            Object lambdaFunctionExecutionRoleArn;
            Object lambdaFunctionLastModifiedAt;
            Object lambdaFunctionLayers;
            Object lambdaFunctionName;
            Object lambdaFunctionRuntime;
            Object lastObservedAt;
            Object networkProtocol;
            Object portRange;
            Object relatedVulnerabilities;
            Object resourceId;
            Object resourceTags;
            Object resourceType;
            Object severity;
            Object title;
            Object updatedAt;
            Object vendorSeverity;
            Object vulnerabilityId;
            Object vulnerabilitySource;
            Object vulnerablePackages;

            public Builder awsAccountId(IResolvable awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            public Builder awsAccountId(List<? extends Object> awsAccountId) {
                this.awsAccountId = awsAccountId;
                return this;
            }

            public Builder codeVulnerabilityDetectorName(IResolvable codeVulnerabilityDetectorName) {
                this.codeVulnerabilityDetectorName = codeVulnerabilityDetectorName;
                return this;
            }

            public Builder codeVulnerabilityDetectorName(List<? extends Object> codeVulnerabilityDetectorName) {
                this.codeVulnerabilityDetectorName = codeVulnerabilityDetectorName;
                return this;
            }

            public Builder codeVulnerabilityDetectorTags(IResolvable codeVulnerabilityDetectorTags) {
                this.codeVulnerabilityDetectorTags = codeVulnerabilityDetectorTags;
                return this;
            }

            public Builder codeVulnerabilityDetectorTags(List<? extends Object> codeVulnerabilityDetectorTags) {
                this.codeVulnerabilityDetectorTags = codeVulnerabilityDetectorTags;
                return this;
            }

            public Builder codeVulnerabilityFilePath(IResolvable codeVulnerabilityFilePath) {
                this.codeVulnerabilityFilePath = codeVulnerabilityFilePath;
                return this;
            }

            public Builder codeVulnerabilityFilePath(List<? extends Object> codeVulnerabilityFilePath) {
                this.codeVulnerabilityFilePath = codeVulnerabilityFilePath;
                return this;
            }

            public Builder componentId(IResolvable componentId) {
                this.componentId = componentId;
                return this;
            }

            public Builder componentId(List<? extends Object> componentId) {
                this.componentId = componentId;
                return this;
            }

            public Builder componentType(IResolvable componentType) {
                this.componentType = componentType;
                return this;
            }

            public Builder componentType(List<? extends Object> componentType) {
                this.componentType = componentType;
                return this;
            }

            public Builder ec2InstanceImageId(IResolvable ec2InstanceImageId) {
                this.ec2InstanceImageId = ec2InstanceImageId;
                return this;
            }

            public Builder ec2InstanceImageId(List<? extends Object> ec2InstanceImageId) {
                this.ec2InstanceImageId = ec2InstanceImageId;
                return this;
            }

            public Builder ec2InstanceSubnetId(IResolvable ec2InstanceSubnetId) {
                this.ec2InstanceSubnetId = ec2InstanceSubnetId;
                return this;
            }

            public Builder ec2InstanceSubnetId(List<? extends Object> ec2InstanceSubnetId) {
                this.ec2InstanceSubnetId = ec2InstanceSubnetId;
                return this;
            }

            public Builder ec2InstanceVpcId(IResolvable ec2InstanceVpcId) {
                this.ec2InstanceVpcId = ec2InstanceVpcId;
                return this;
            }

            public Builder ec2InstanceVpcId(List<? extends Object> ec2InstanceVpcId) {
                this.ec2InstanceVpcId = ec2InstanceVpcId;
                return this;
            }

            public Builder ecrImageArchitecture(IResolvable ecrImageArchitecture) {
                this.ecrImageArchitecture = ecrImageArchitecture;
                return this;
            }

            public Builder ecrImageArchitecture(List<? extends Object> ecrImageArchitecture) {
                this.ecrImageArchitecture = ecrImageArchitecture;
                return this;
            }

            public Builder ecrImageHash(IResolvable ecrImageHash) {
                this.ecrImageHash = ecrImageHash;
                return this;
            }

            public Builder ecrImageHash(List<? extends Object> ecrImageHash) {
                this.ecrImageHash = ecrImageHash;
                return this;
            }

            public Builder ecrImagePushedAt(IResolvable ecrImagePushedAt) {
                this.ecrImagePushedAt = ecrImagePushedAt;
                return this;
            }

            public Builder ecrImagePushedAt(List<? extends Object> ecrImagePushedAt) {
                this.ecrImagePushedAt = ecrImagePushedAt;
                return this;
            }

            public Builder ecrImageRegistry(IResolvable ecrImageRegistry) {
                this.ecrImageRegistry = ecrImageRegistry;
                return this;
            }

            public Builder ecrImageRegistry(List<? extends Object> ecrImageRegistry) {
                this.ecrImageRegistry = ecrImageRegistry;
                return this;
            }

            public Builder ecrImageRepositoryName(IResolvable ecrImageRepositoryName) {
                this.ecrImageRepositoryName = ecrImageRepositoryName;
                return this;
            }

            public Builder ecrImageRepositoryName(List<? extends Object> ecrImageRepositoryName) {
                this.ecrImageRepositoryName = ecrImageRepositoryName;
                return this;
            }

            public Builder ecrImageTags(IResolvable ecrImageTags) {
                this.ecrImageTags = ecrImageTags;
                return this;
            }

            public Builder ecrImageTags(List<? extends Object> ecrImageTags) {
                this.ecrImageTags = ecrImageTags;
                return this;
            }

            public Builder epssScore(IResolvable epssScore) {
                this.epssScore = epssScore;
                return this;
            }

            public Builder epssScore(List<? extends Object> epssScore) {
                this.epssScore = epssScore;
                return this;
            }

            public Builder exploitAvailable(IResolvable exploitAvailable) {
                this.exploitAvailable = exploitAvailable;
                return this;
            }

            public Builder exploitAvailable(List<? extends Object> exploitAvailable) {
                this.exploitAvailable = exploitAvailable;
                return this;
            }

            public Builder findingArn(IResolvable findingArn) {
                this.findingArn = findingArn;
                return this;
            }

            public Builder findingArn(List<? extends Object> findingArn) {
                this.findingArn = findingArn;
                return this;
            }

            public Builder findingStatus(IResolvable findingStatus) {
                this.findingStatus = findingStatus;
                return this;
            }

            public Builder findingStatus(List<? extends Object> findingStatus) {
                this.findingStatus = findingStatus;
                return this;
            }

            public Builder findingType(IResolvable findingType) {
                this.findingType = findingType;
                return this;
            }

            public Builder findingType(List<? extends Object> findingType) {
                this.findingType = findingType;
                return this;
            }

            public Builder firstObservedAt(IResolvable firstObservedAt) {
                this.firstObservedAt = firstObservedAt;
                return this;
            }

            public Builder firstObservedAt(List<? extends Object> firstObservedAt) {
                this.firstObservedAt = firstObservedAt;
                return this;
            }

            public Builder fixAvailable(IResolvable fixAvailable) {
                this.fixAvailable = fixAvailable;
                return this;
            }

            public Builder fixAvailable(List<? extends Object> fixAvailable) {
                this.fixAvailable = fixAvailable;
                return this;
            }

            public Builder inspectorScore(IResolvable inspectorScore) {
                this.inspectorScore = inspectorScore;
                return this;
            }

            public Builder inspectorScore(List<? extends Object> inspectorScore) {
                this.inspectorScore = inspectorScore;
                return this;
            }

            public Builder lambdaFunctionExecutionRoleArn(IResolvable lambdaFunctionExecutionRoleArn) {
                this.lambdaFunctionExecutionRoleArn = lambdaFunctionExecutionRoleArn;
                return this;
            }

            public Builder lambdaFunctionExecutionRoleArn(List<? extends Object> lambdaFunctionExecutionRoleArn) {
                this.lambdaFunctionExecutionRoleArn = lambdaFunctionExecutionRoleArn;
                return this;
            }

            public Builder lambdaFunctionLastModifiedAt(IResolvable lambdaFunctionLastModifiedAt) {
                this.lambdaFunctionLastModifiedAt = lambdaFunctionLastModifiedAt;
                return this;
            }

            public Builder lambdaFunctionLastModifiedAt(List<? extends Object> lambdaFunctionLastModifiedAt) {
                this.lambdaFunctionLastModifiedAt = lambdaFunctionLastModifiedAt;
                return this;
            }

            public Builder lambdaFunctionLayers(IResolvable lambdaFunctionLayers) {
                this.lambdaFunctionLayers = lambdaFunctionLayers;
                return this;
            }

            public Builder lambdaFunctionLayers(List<? extends Object> lambdaFunctionLayers) {
                this.lambdaFunctionLayers = lambdaFunctionLayers;
                return this;
            }

            public Builder lambdaFunctionName(IResolvable lambdaFunctionName) {
                this.lambdaFunctionName = lambdaFunctionName;
                return this;
            }

            public Builder lambdaFunctionName(List<? extends Object> lambdaFunctionName) {
                this.lambdaFunctionName = lambdaFunctionName;
                return this;
            }

            public Builder lambdaFunctionRuntime(IResolvable lambdaFunctionRuntime) {
                this.lambdaFunctionRuntime = lambdaFunctionRuntime;
                return this;
            }

            public Builder lambdaFunctionRuntime(List<? extends Object> lambdaFunctionRuntime) {
                this.lambdaFunctionRuntime = lambdaFunctionRuntime;
                return this;
            }

            public Builder lastObservedAt(IResolvable lastObservedAt) {
                this.lastObservedAt = lastObservedAt;
                return this;
            }

            public Builder lastObservedAt(List<? extends Object> lastObservedAt) {
                this.lastObservedAt = lastObservedAt;
                return this;
            }

            public Builder networkProtocol(IResolvable networkProtocol) {
                this.networkProtocol = networkProtocol;
                return this;
            }

            public Builder networkProtocol(List<? extends Object> networkProtocol) {
                this.networkProtocol = networkProtocol;
                return this;
            }

            public Builder portRange(IResolvable portRange) {
                this.portRange = portRange;
                return this;
            }

            public Builder portRange(List<? extends Object> portRange) {
                this.portRange = portRange;
                return this;
            }

            public Builder relatedVulnerabilities(IResolvable relatedVulnerabilities) {
                this.relatedVulnerabilities = relatedVulnerabilities;
                return this;
            }

            public Builder relatedVulnerabilities(List<? extends Object> relatedVulnerabilities) {
                this.relatedVulnerabilities = relatedVulnerabilities;
                return this;
            }

            public Builder resourceId(IResolvable resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            public Builder resourceId(List<? extends Object> resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            public Builder resourceTags(IResolvable resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            public Builder resourceTags(List<? extends Object> resourceTags) {
                this.resourceTags = resourceTags;
                return this;
            }

            public Builder resourceType(IResolvable resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder resourceType(List<? extends Object> resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            public Builder severity(IResolvable severity) {
                this.severity = severity;
                return this;
            }

            public Builder severity(List<? extends Object> severity) {
                this.severity = severity;
                return this;
            }

            public Builder title(IResolvable title) {
                this.title = title;
                return this;
            }

            public Builder title(List<? extends Object> title) {
                this.title = title;
                return this;
            }

            public Builder updatedAt(IResolvable updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            public Builder updatedAt(List<? extends Object> updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            public Builder vendorSeverity(IResolvable vendorSeverity) {
                this.vendorSeverity = vendorSeverity;
                return this;
            }

            public Builder vendorSeverity(List<? extends Object> vendorSeverity) {
                this.vendorSeverity = vendorSeverity;
                return this;
            }

            public Builder vulnerabilityId(IResolvable vulnerabilityId) {
                this.vulnerabilityId = vulnerabilityId;
                return this;
            }

            public Builder vulnerabilityId(List<? extends Object> vulnerabilityId) {
                this.vulnerabilityId = vulnerabilityId;
                return this;
            }

            public Builder vulnerabilitySource(IResolvable vulnerabilitySource) {
                this.vulnerabilitySource = vulnerabilitySource;
                return this;
            }

            public Builder vulnerabilitySource(List<? extends Object> vulnerabilitySource) {
                this.vulnerabilitySource = vulnerabilitySource;
                return this;
            }

            public Builder vulnerablePackages(IResolvable vulnerablePackages) {
                this.vulnerablePackages = vulnerablePackages;
                return this;
            }

            public Builder vulnerablePackages(List<? extends Object> vulnerablePackages) {
                this.vulnerablePackages = vulnerablePackages;
                return this;
            }

            public FilterCriteriaProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_inspectorv2.CfnFilter.DateFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DateFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getEndInclusive() {
            return null;
        }

        @Nullable
        default public Number getStartInclusive() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DateFilterProperty> {
            Number endInclusive;
            Number startInclusive;

            public Builder endInclusive(Number endInclusive) {
                this.endInclusive = endInclusive;
                return this;
            }

            public Builder startInclusive(Number startInclusive) {
                this.startInclusive = startInclusive;
                return this;
            }

            public DateFilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

