/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.lambda;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.lambda.EventSourceMappingOptions;
import software.amazon.awscdk.services.lambda.EventSourceMappingProps;
import software.amazon.awscdk.services.lambda.IEventSourceDlq;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.lambda.ISchemaRegistry;
import software.amazon.awscdk.services.lambda.MetricsConfig;
import software.amazon.awscdk.services.lambda.ProvisionedPollerConfig;
import software.amazon.awscdk.services.lambda.SourceAccessConfiguration;
import software.amazon.awscdk.services.lambda.StartingPosition;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_lambda.EventSourceMappingProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface EventSourceMappingProps
extends JsiiSerializable,
EventSourceMappingOptions {
    @NotNull
    public IFunction getTarget();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EventSourceMappingProps> {
        IFunction target;
        Number batchSize;
        Boolean bisectBatchOnError;
        Boolean enabled;
        String eventSourceArn;
        IKey filterEncryption;
        List<Map<String, Object>> filters;
        List<String> kafkaBootstrapServers;
        String kafkaConsumerGroupId;
        String kafkaTopic;
        Duration maxBatchingWindow;
        Number maxConcurrency;
        Duration maxRecordAge;
        MetricsConfig metricsConfig;
        IEventSourceDlq onFailure;
        Number parallelizationFactor;
        ProvisionedPollerConfig provisionedPollerConfig;
        Boolean reportBatchItemFailures;
        Number retryAttempts;
        ISchemaRegistry schemaRegistryConfig;
        List<SourceAccessConfiguration> sourceAccessConfigurations;
        StartingPosition startingPosition;
        Number startingPositionTimestamp;
        Boolean supportS3OnFailureDestination;
        Duration tumblingWindow;

        public Builder target(IFunction target) {
            this.target = target;
            return this;
        }

        public Builder batchSize(Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder bisectBatchOnError(Boolean bisectBatchOnError) {
            this.bisectBatchOnError = bisectBatchOnError;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public Builder filterEncryption(IKey filterEncryption) {
            this.filterEncryption = filterEncryption;
            return this;
        }

        public Builder filters(List<? extends Map<String, ? extends Object>> filters) {
            this.filters = filters;
            return this;
        }

        public Builder kafkaBootstrapServers(List<String> kafkaBootstrapServers) {
            this.kafkaBootstrapServers = kafkaBootstrapServers;
            return this;
        }

        public Builder kafkaConsumerGroupId(String kafkaConsumerGroupId) {
            this.kafkaConsumerGroupId = kafkaConsumerGroupId;
            return this;
        }

        public Builder kafkaTopic(String kafkaTopic) {
            this.kafkaTopic = kafkaTopic;
            return this;
        }

        public Builder maxBatchingWindow(Duration maxBatchingWindow) {
            this.maxBatchingWindow = maxBatchingWindow;
            return this;
        }

        public Builder maxConcurrency(Number maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public Builder maxRecordAge(Duration maxRecordAge) {
            this.maxRecordAge = maxRecordAge;
            return this;
        }

        public Builder metricsConfig(MetricsConfig metricsConfig) {
            this.metricsConfig = metricsConfig;
            return this;
        }

        public Builder onFailure(IEventSourceDlq onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public Builder parallelizationFactor(Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public Builder provisionedPollerConfig(ProvisionedPollerConfig provisionedPollerConfig) {
            this.provisionedPollerConfig = provisionedPollerConfig;
            return this;
        }

        public Builder reportBatchItemFailures(Boolean reportBatchItemFailures) {
            this.reportBatchItemFailures = reportBatchItemFailures;
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        public Builder schemaRegistryConfig(ISchemaRegistry schemaRegistryConfig) {
            this.schemaRegistryConfig = schemaRegistryConfig;
            return this;
        }

        public Builder sourceAccessConfigurations(List<? extends SourceAccessConfiguration> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = sourceAccessConfigurations;
            return this;
        }

        public Builder startingPosition(StartingPosition startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        public Builder startingPositionTimestamp(Number startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        public Builder supportS3OnFailureDestination(Boolean supportS3OnFailureDestination) {
            this.supportS3OnFailureDestination = supportS3OnFailureDestination;
            return this;
        }

        public Builder tumblingWindow(Duration tumblingWindow) {
            this.tumblingWindow = tumblingWindow;
            return this;
        }

        public EventSourceMappingProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

