/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.mpa;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.mpa.CfnIdentitySource;
import software.amazon.awscdk.services.mpa.CfnIdentitySourceProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mpa.CfnIdentitySource")
public class CfnIdentitySource
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnIdentitySource.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnIdentitySource(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIdentitySource(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnIdentitySource(@NotNull Construct scope, @NotNull String id, @NotNull CfnIdentitySourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreationTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrIdentitySourceArn() {
        return (String)Kernel.get((Object)this, (String)"attrIdentitySourceArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrIdentitySourceParametersIamIdentityCenterApprovalPortalUrl() {
        return (String)Kernel.get((Object)this, (String)"attrIdentitySourceParametersIamIdentityCenterApprovalPortalUrl", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrIdentitySourceType() {
        return (String)Kernel.get((Object)this, (String)"attrIdentitySourceType", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatus() {
        return (String)Kernel.get((Object)this, (String)"attrStatus", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatusCode() {
        return (String)Kernel.get((Object)this, (String)"attrStatusCode", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStatusMessage() {
        return (String)Kernel.get((Object)this, (String)"attrStatusMessage", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getIdentitySourceParameters() {
        return Kernel.get((Object)this, (String)"identitySourceParameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIdentitySourceParameters(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"identitySourceParameters", (Object)Objects.requireNonNull(value, "identitySourceParameters is required"));
    }

    public void setIdentitySourceParameters(@NotNull IdentitySourceParametersProperty value) {
        Kernel.set((Object)this, (String)"identitySourceParameters", (Object)Objects.requireNonNull(value, "identitySourceParameters is required"));
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnIdentitySource> {
        private final Construct scope;
        private final String id;
        private final CfnIdentitySourceProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnIdentitySourceProps.Builder();
        }

        public Builder identitySourceParameters(IResolvable identitySourceParameters) {
            this.props.identitySourceParameters(identitySourceParameters);
            return this;
        }

        public Builder identitySourceParameters(IdentitySourceParametersProperty identitySourceParameters) {
            this.props.identitySourceParameters(identitySourceParameters);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnIdentitySource build() {
            return new CfnIdentitySource(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mpa.CfnIdentitySource.IdentitySourceParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IdentitySourceParametersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getIamIdentityCenter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IdentitySourceParametersProperty> {
            Object iamIdentityCenter;

            public Builder iamIdentityCenter(IResolvable iamIdentityCenter) {
                this.iamIdentityCenter = iamIdentityCenter;
                return this;
            }

            public Builder iamIdentityCenter(IamIdentityCenterProperty iamIdentityCenter) {
                this.iamIdentityCenter = iamIdentityCenter;
                return this;
            }

            public IdentitySourceParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_mpa.CfnIdentitySource.IamIdentityCenterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IamIdentityCenterProperty
    extends JsiiSerializable {
        @NotNull
        public String getInstanceArn();

        @NotNull
        public String getRegion();

        @Nullable
        default public String getApprovalPortalUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IamIdentityCenterProperty> {
            String instanceArn;
            String region;
            String approvalPortalUrl;

            public Builder instanceArn(String instanceArn) {
                this.instanceArn = instanceArn;
                return this;
            }

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder approvalPortalUrl(String approvalPortalUrl) {
                this.approvalPortalUrl = approvalPortalUrl;
                return this;
            }

            public IamIdentityCenterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

