/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sagemaker;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.sagemaker.CfnMonitoringSchedule;
import software.amazon.awscdk.services.sagemaker.CfnMonitoringScheduleProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule")
public class CfnMonitoringSchedule
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnMonitoringSchedule.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnMonitoringSchedule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMonitoringSchedule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnMonitoringSchedule(@NotNull Construct scope, @NotNull String id, @NotNull CfnMonitoringScheduleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrCreationTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLastModifiedTime() {
        return (String)Kernel.get((Object)this, (String)"attrLastModifiedTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrMonitoringScheduleArn() {
        return (String)Kernel.get((Object)this, (String)"attrMonitoringScheduleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getMonitoringScheduleConfig() {
        return Kernel.get((Object)this, (String)"monitoringScheduleConfig", (NativeType)NativeType.forClass(Object.class));
    }

    public void setMonitoringScheduleConfig(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"monitoringScheduleConfig", (Object)Objects.requireNonNull(value, "monitoringScheduleConfig is required"));
    }

    public void setMonitoringScheduleConfig(@NotNull MonitoringScheduleConfigProperty value) {
        Kernel.set((Object)this, (String)"monitoringScheduleConfig", (Object)Objects.requireNonNull(value, "monitoringScheduleConfig is required"));
    }

    @NotNull
    public String getMonitoringScheduleName() {
        return (String)Kernel.get((Object)this, (String)"monitoringScheduleName", (NativeType)NativeType.forClass(String.class));
    }

    public void setMonitoringScheduleName(@NotNull String value) {
        Kernel.set((Object)this, (String)"monitoringScheduleName", (Object)Objects.requireNonNull(value, "monitoringScheduleName is required"));
    }

    @Nullable
    public String getEndpointName() {
        return (String)Kernel.get((Object)this, (String)"endpointName", (NativeType)NativeType.forClass(String.class));
    }

    public void setEndpointName(@Nullable String value) {
        Kernel.set((Object)this, (String)"endpointName", (Object)value);
    }

    @Nullable
    public String getFailureReason() {
        return (String)Kernel.get((Object)this, (String)"failureReason", (NativeType)NativeType.forClass(String.class));
    }

    public void setFailureReason(@Nullable String value) {
        Kernel.set((Object)this, (String)"failureReason", (Object)value);
    }

    @Nullable
    public Object getLastMonitoringExecutionSummary() {
        return Kernel.get((Object)this, (String)"lastMonitoringExecutionSummary", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLastMonitoringExecutionSummary(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"lastMonitoringExecutionSummary", (Object)value);
    }

    public void setLastMonitoringExecutionSummary(@Nullable MonitoringExecutionSummaryProperty value) {
        Kernel.set((Object)this, (String)"lastMonitoringExecutionSummary", (Object)value);
    }

    @Nullable
    public String getMonitoringScheduleStatus() {
        return (String)Kernel.get((Object)this, (String)"monitoringScheduleStatus", (NativeType)NativeType.forClass(String.class));
    }

    public void setMonitoringScheduleStatus(@Nullable String value) {
        Kernel.set((Object)this, (String)"monitoringScheduleStatus", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTagsRaw() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTagsRaw(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnMonitoringSchedule> {
        private final Construct scope;
        private final String id;
        private final CfnMonitoringScheduleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnMonitoringScheduleProps.Builder();
        }

        public Builder monitoringScheduleConfig(IResolvable monitoringScheduleConfig) {
            this.props.monitoringScheduleConfig(monitoringScheduleConfig);
            return this;
        }

        public Builder monitoringScheduleConfig(MonitoringScheduleConfigProperty monitoringScheduleConfig) {
            this.props.monitoringScheduleConfig(monitoringScheduleConfig);
            return this;
        }

        public Builder monitoringScheduleName(String monitoringScheduleName) {
            this.props.monitoringScheduleName(monitoringScheduleName);
            return this;
        }

        public Builder endpointName(String endpointName) {
            this.props.endpointName(endpointName);
            return this;
        }

        public Builder failureReason(String failureReason) {
            this.props.failureReason(failureReason);
            return this;
        }

        public Builder lastMonitoringExecutionSummary(IResolvable lastMonitoringExecutionSummary) {
            this.props.lastMonitoringExecutionSummary(lastMonitoringExecutionSummary);
            return this;
        }

        public Builder lastMonitoringExecutionSummary(MonitoringExecutionSummaryProperty lastMonitoringExecutionSummary) {
            this.props.lastMonitoringExecutionSummary(lastMonitoringExecutionSummary);
            return this;
        }

        public Builder monitoringScheduleStatus(String monitoringScheduleStatus) {
            this.props.monitoringScheduleStatus(monitoringScheduleStatus);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnMonitoringSchedule build() {
            return new CfnMonitoringSchedule(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.VpcConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnets();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcConfigProperty> {
            List<String> securityGroupIds;
            List<String> subnets;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public VpcConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.StoppingConditionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StoppingConditionProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxRuntimeInSeconds();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StoppingConditionProperty> {
            Number maxRuntimeInSeconds;

            public Builder maxRuntimeInSeconds(Number maxRuntimeInSeconds) {
                this.maxRuntimeInSeconds = maxRuntimeInSeconds;
                return this;
            }

            public StoppingConditionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.StatisticsResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface StatisticsResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getS3Uri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<StatisticsResourceProperty> {
            String s3Uri;

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public StatisticsResourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.ScheduleConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleConfigProperty
    extends JsiiSerializable {
        @NotNull
        public String getScheduleExpression();

        @Nullable
        default public String getDataAnalysisEndTime() {
            return null;
        }

        @Nullable
        default public String getDataAnalysisStartTime() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleConfigProperty> {
            String scheduleExpression;
            String dataAnalysisEndTime;
            String dataAnalysisStartTime;

            public Builder scheduleExpression(String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            public Builder dataAnalysisEndTime(String dataAnalysisEndTime) {
                this.dataAnalysisEndTime = dataAnalysisEndTime;
                return this;
            }

            public Builder dataAnalysisStartTime(String dataAnalysisStartTime) {
                this.dataAnalysisStartTime = dataAnalysisStartTime;
                return this;
            }

            public ScheduleConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.S3OutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3OutputProperty
    extends JsiiSerializable {
        @NotNull
        public String getLocalPath();

        @NotNull
        public String getS3Uri();

        @Nullable
        default public String getS3UploadMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3OutputProperty> {
            String localPath;
            String s3Uri;
            String s3UploadMode;

            public Builder localPath(String localPath) {
                this.localPath = localPath;
                return this;
            }

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public Builder s3UploadMode(String s3UploadMode) {
                this.s3UploadMode = s3UploadMode;
                return this;
            }

            public S3OutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.NetworkConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableInterContainerTrafficEncryption() {
            return null;
        }

        @Nullable
        default public Object getEnableNetworkIsolation() {
            return null;
        }

        @Nullable
        default public Object getVpcConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkConfigProperty> {
            Object enableInterContainerTrafficEncryption;
            Object enableNetworkIsolation;
            Object vpcConfig;

            public Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            public Builder enableInterContainerTrafficEncryption(IResolvable enableInterContainerTrafficEncryption) {
                this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
                return this;
            }

            public Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            public Builder enableNetworkIsolation(IResolvable enableNetworkIsolation) {
                this.enableNetworkIsolation = enableNetworkIsolation;
                return this;
            }

            public Builder vpcConfig(IResolvable vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            public Builder vpcConfig(VpcConfigProperty vpcConfig) {
                this.vpcConfig = vpcConfig;
                return this;
            }

            public NetworkConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringScheduleConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringScheduleConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getMonitoringJobDefinition() {
            return null;
        }

        @Nullable
        default public String getMonitoringJobDefinitionName() {
            return null;
        }

        @Nullable
        default public String getMonitoringType() {
            return null;
        }

        @Nullable
        default public Object getScheduleConfig() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringScheduleConfigProperty> {
            Object monitoringJobDefinition;
            String monitoringJobDefinitionName;
            String monitoringType;
            Object scheduleConfig;

            public Builder monitoringJobDefinition(IResolvable monitoringJobDefinition) {
                this.monitoringJobDefinition = monitoringJobDefinition;
                return this;
            }

            public Builder monitoringJobDefinition(MonitoringJobDefinitionProperty monitoringJobDefinition) {
                this.monitoringJobDefinition = monitoringJobDefinition;
                return this;
            }

            public Builder monitoringJobDefinitionName(String monitoringJobDefinitionName) {
                this.monitoringJobDefinitionName = monitoringJobDefinitionName;
                return this;
            }

            public Builder monitoringType(String monitoringType) {
                this.monitoringType = monitoringType;
                return this;
            }

            public Builder scheduleConfig(IResolvable scheduleConfig) {
                this.scheduleConfig = scheduleConfig;
                return this;
            }

            public Builder scheduleConfig(ScheduleConfigProperty scheduleConfig) {
                this.scheduleConfig = scheduleConfig;
                return this;
            }

            public MonitoringScheduleConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringResourcesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringResourcesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getClusterConfig();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringResourcesProperty> {
            Object clusterConfig;

            public Builder clusterConfig(IResolvable clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            public Builder clusterConfig(ClusterConfigProperty clusterConfig) {
                this.clusterConfig = clusterConfig;
                return this;
            }

            public MonitoringResourcesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringOutputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringOutputProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3Output();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringOutputProperty> {
            Object s3Output;

            public Builder s3Output(IResolvable s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            public Builder s3Output(S3OutputProperty s3Output) {
                this.s3Output = s3Output;
                return this;
            }

            public MonitoringOutputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringOutputConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringOutputConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMonitoringOutputs();

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringOutputConfigProperty> {
            Object monitoringOutputs;
            String kmsKeyId;

            public Builder monitoringOutputs(IResolvable monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            public Builder monitoringOutputs(List<? extends Object> monitoringOutputs) {
                this.monitoringOutputs = monitoringOutputs;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public MonitoringOutputConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringJobDefinitionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringJobDefinitionProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMonitoringAppSpecification();

        @NotNull
        public Object getMonitoringInputs();

        @NotNull
        public Object getMonitoringOutputConfig();

        @NotNull
        public Object getMonitoringResources();

        @NotNull
        public String getRoleArn();

        @Nullable
        default public Object getBaselineConfig() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public Object getNetworkConfig() {
            return null;
        }

        @Nullable
        default public Object getStoppingCondition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringJobDefinitionProperty> {
            Object monitoringAppSpecification;
            Object monitoringInputs;
            Object monitoringOutputConfig;
            Object monitoringResources;
            String roleArn;
            Object baselineConfig;
            Object environment;
            Object networkConfig;
            Object stoppingCondition;

            public Builder monitoringAppSpecification(IResolvable monitoringAppSpecification) {
                this.monitoringAppSpecification = monitoringAppSpecification;
                return this;
            }

            public Builder monitoringAppSpecification(MonitoringAppSpecificationProperty monitoringAppSpecification) {
                this.monitoringAppSpecification = monitoringAppSpecification;
                return this;
            }

            public Builder monitoringInputs(IResolvable monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            public Builder monitoringInputs(List<? extends Object> monitoringInputs) {
                this.monitoringInputs = monitoringInputs;
                return this;
            }

            public Builder monitoringOutputConfig(IResolvable monitoringOutputConfig) {
                this.monitoringOutputConfig = monitoringOutputConfig;
                return this;
            }

            public Builder monitoringOutputConfig(MonitoringOutputConfigProperty monitoringOutputConfig) {
                this.monitoringOutputConfig = monitoringOutputConfig;
                return this;
            }

            public Builder monitoringResources(IResolvable monitoringResources) {
                this.monitoringResources = monitoringResources;
                return this;
            }

            public Builder monitoringResources(MonitoringResourcesProperty monitoringResources) {
                this.monitoringResources = monitoringResources;
                return this;
            }

            public Builder roleArn(String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            public Builder baselineConfig(IResolvable baselineConfig) {
                this.baselineConfig = baselineConfig;
                return this;
            }

            public Builder baselineConfig(BaselineConfigProperty baselineConfig) {
                this.baselineConfig = baselineConfig;
                return this;
            }

            public Builder environment(Map<String, String> environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder networkConfig(IResolvable networkConfig) {
                this.networkConfig = networkConfig;
                return this;
            }

            public Builder networkConfig(NetworkConfigProperty networkConfig) {
                this.networkConfig = networkConfig;
                return this;
            }

            public Builder stoppingCondition(IResolvable stoppingCondition) {
                this.stoppingCondition = stoppingCondition;
                return this;
            }

            public Builder stoppingCondition(StoppingConditionProperty stoppingCondition) {
                this.stoppingCondition = stoppingCondition;
                return this;
            }

            public MonitoringJobDefinitionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBatchTransformInput() {
            return null;
        }

        @Nullable
        default public Object getEndpointInput() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringInputProperty> {
            Object batchTransformInput;
            Object endpointInput;

            public Builder batchTransformInput(IResolvable batchTransformInput) {
                this.batchTransformInput = batchTransformInput;
                return this;
            }

            public Builder batchTransformInput(BatchTransformInputProperty batchTransformInput) {
                this.batchTransformInput = batchTransformInput;
                return this;
            }

            public Builder endpointInput(IResolvable endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            public Builder endpointInput(EndpointInputProperty endpointInput) {
                this.endpointInput = endpointInput;
                return this;
            }

            public MonitoringInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringExecutionSummaryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringExecutionSummaryProperty
    extends JsiiSerializable {
        @NotNull
        public String getCreationTime();

        @NotNull
        public String getLastModifiedTime();

        @NotNull
        public String getMonitoringExecutionStatus();

        @NotNull
        public String getMonitoringScheduleName();

        @NotNull
        public String getScheduledTime();

        @Nullable
        default public String getEndpointName() {
            return null;
        }

        @Nullable
        default public String getFailureReason() {
            return null;
        }

        @Nullable
        default public String getProcessingJobArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringExecutionSummaryProperty> {
            String creationTime;
            String lastModifiedTime;
            String monitoringExecutionStatus;
            String monitoringScheduleName;
            String scheduledTime;
            String endpointName;
            String failureReason;
            String processingJobArn;

            public Builder creationTime(String creationTime) {
                this.creationTime = creationTime;
                return this;
            }

            public Builder lastModifiedTime(String lastModifiedTime) {
                this.lastModifiedTime = lastModifiedTime;
                return this;
            }

            public Builder monitoringExecutionStatus(String monitoringExecutionStatus) {
                this.monitoringExecutionStatus = monitoringExecutionStatus;
                return this;
            }

            public Builder monitoringScheduleName(String monitoringScheduleName) {
                this.monitoringScheduleName = monitoringScheduleName;
                return this;
            }

            public Builder scheduledTime(String scheduledTime) {
                this.scheduledTime = scheduledTime;
                return this;
            }

            public Builder endpointName(String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            public Builder failureReason(String failureReason) {
                this.failureReason = failureReason;
                return this;
            }

            public Builder processingJobArn(String processingJobArn) {
                this.processingJobArn = processingJobArn;
                return this;
            }

            public MonitoringExecutionSummaryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.MonitoringAppSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MonitoringAppSpecificationProperty
    extends JsiiSerializable {
        @NotNull
        public String getImageUri();

        @Nullable
        default public List<String> getContainerArguments() {
            return null;
        }

        @Nullable
        default public List<String> getContainerEntrypoint() {
            return null;
        }

        @Nullable
        default public String getPostAnalyticsProcessorSourceUri() {
            return null;
        }

        @Nullable
        default public String getRecordPreprocessorSourceUri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MonitoringAppSpecificationProperty> {
            String imageUri;
            List<String> containerArguments;
            List<String> containerEntrypoint;
            String postAnalyticsProcessorSourceUri;
            String recordPreprocessorSourceUri;

            public Builder imageUri(String imageUri) {
                this.imageUri = imageUri;
                return this;
            }

            public Builder containerArguments(List<String> containerArguments) {
                this.containerArguments = containerArguments;
                return this;
            }

            public Builder containerEntrypoint(List<String> containerEntrypoint) {
                this.containerEntrypoint = containerEntrypoint;
                return this;
            }

            public Builder postAnalyticsProcessorSourceUri(String postAnalyticsProcessorSourceUri) {
                this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
                return this;
            }

            public Builder recordPreprocessorSourceUri(String recordPreprocessorSourceUri) {
                this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
                return this;
            }

            public MonitoringAppSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.JsonProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JsonProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLine() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JsonProperty> {
            Object line;

            public Builder line(Boolean line) {
                this.line = line;
                return this;
            }

            public Builder line(IResolvable line) {
                this.line = line;
                return this;
            }

            public JsonProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.EndpointInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getEndpointName();

        @NotNull
        public String getLocalPath();

        @Nullable
        default public String getExcludeFeaturesAttribute() {
            return null;
        }

        @Nullable
        default public String getS3DataDistributionType() {
            return null;
        }

        @Nullable
        default public String getS3InputMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointInputProperty> {
            String endpointName;
            String localPath;
            String excludeFeaturesAttribute;
            String s3DataDistributionType;
            String s3InputMode;

            public Builder endpointName(String endpointName) {
                this.endpointName = endpointName;
                return this;
            }

            public Builder localPath(String localPath) {
                this.localPath = localPath;
                return this;
            }

            public Builder excludeFeaturesAttribute(String excludeFeaturesAttribute) {
                this.excludeFeaturesAttribute = excludeFeaturesAttribute;
                return this;
            }

            public Builder s3DataDistributionType(String s3DataDistributionType) {
                this.s3DataDistributionType = s3DataDistributionType;
                return this;
            }

            public Builder s3InputMode(String s3InputMode) {
                this.s3InputMode = s3InputMode;
                return this;
            }

            public EndpointInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.DatasetFormatProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DatasetFormatProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCsv() {
            return null;
        }

        @Nullable
        default public Object getJson() {
            return null;
        }

        @Nullable
        default public Object getParquet() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DatasetFormatProperty> {
            Object csv;
            Object json;
            Object parquet;

            public Builder csv(IResolvable csv) {
                this.csv = csv;
                return this;
            }

            public Builder csv(CsvProperty csv) {
                this.csv = csv;
                return this;
            }

            public Builder json(IResolvable json) {
                this.json = json;
                return this;
            }

            public Builder json(JsonProperty json) {
                this.json = json;
                return this;
            }

            public Builder parquet(Boolean parquet) {
                this.parquet = parquet;
                return this;
            }

            public Builder parquet(IResolvable parquet) {
                this.parquet = parquet;
                return this;
            }

            public DatasetFormatProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.CsvProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CsvProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHeader() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CsvProperty> {
            Object header;

            public Builder header(Boolean header) {
                this.header = header;
                return this;
            }

            public Builder header(IResolvable header) {
                this.header = header;
                return this;
            }

            public CsvProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.ConstraintsResourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConstraintsResourceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getS3Uri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConstraintsResourceProperty> {
            String s3Uri;

            public Builder s3Uri(String s3Uri) {
                this.s3Uri = s3Uri;
                return this;
            }

            public ConstraintsResourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.ClusterConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ClusterConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Number getInstanceCount();

        @NotNull
        public String getInstanceType();

        @NotNull
        public Number getVolumeSizeInGb();

        @Nullable
        default public String getVolumeKmsKeyId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ClusterConfigProperty> {
            Number instanceCount;
            String instanceType;
            Number volumeSizeInGb;
            String volumeKmsKeyId;

            public Builder instanceCount(Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder volumeSizeInGb(Number volumeSizeInGb) {
                this.volumeSizeInGb = volumeSizeInGb;
                return this;
            }

            public Builder volumeKmsKeyId(String volumeKmsKeyId) {
                this.volumeKmsKeyId = volumeKmsKeyId;
                return this;
            }

            public ClusterConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.BatchTransformInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchTransformInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getDataCapturedDestinationS3Uri();

        @NotNull
        public Object getDatasetFormat();

        @NotNull
        public String getLocalPath();

        @Nullable
        default public String getExcludeFeaturesAttribute() {
            return null;
        }

        @Nullable
        default public String getS3DataDistributionType() {
            return null;
        }

        @Nullable
        default public String getS3InputMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BatchTransformInputProperty> {
            String dataCapturedDestinationS3Uri;
            Object datasetFormat;
            String localPath;
            String excludeFeaturesAttribute;
            String s3DataDistributionType;
            String s3InputMode;

            public Builder dataCapturedDestinationS3Uri(String dataCapturedDestinationS3Uri) {
                this.dataCapturedDestinationS3Uri = dataCapturedDestinationS3Uri;
                return this;
            }

            public Builder datasetFormat(IResolvable datasetFormat) {
                this.datasetFormat = datasetFormat;
                return this;
            }

            public Builder datasetFormat(DatasetFormatProperty datasetFormat) {
                this.datasetFormat = datasetFormat;
                return this;
            }

            public Builder localPath(String localPath) {
                this.localPath = localPath;
                return this;
            }

            public Builder excludeFeaturesAttribute(String excludeFeaturesAttribute) {
                this.excludeFeaturesAttribute = excludeFeaturesAttribute;
                return this;
            }

            public Builder s3DataDistributionType(String s3DataDistributionType) {
                this.s3DataDistributionType = s3DataDistributionType;
                return this;
            }

            public Builder s3InputMode(String s3InputMode) {
                this.s3InputMode = s3InputMode;
                return this;
            }

            public BatchTransformInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sagemaker.CfnMonitoringSchedule.BaselineConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BaselineConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getConstraintsResource() {
            return null;
        }

        @Nullable
        default public Object getStatisticsResource() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BaselineConfigProperty> {
            Object constraintsResource;
            Object statisticsResource;

            public Builder constraintsResource(IResolvable constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            public Builder constraintsResource(ConstraintsResourceProperty constraintsResource) {
                this.constraintsResource = constraintsResource;
                return this;
            }

            public Builder statisticsResource(IResolvable statisticsResource) {
                this.statisticsResource = statisticsResource;
                return this;
            }

            public Builder statisticsResource(StatisticsResourceProperty statisticsResource) {
                this.statisticsResource = statisticsResource;
                return this;
            }

            public BaselineConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

