/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.scheduler;

import java.time.Instant;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.scheduler.ISchedule;
import software.amazon.awscdk.services.scheduler.IScheduleGroup;
import software.amazon.awscdk.services.scheduler.IScheduleTarget;
import software.amazon.awscdk.services.scheduler.ScheduleExpression;
import software.amazon.awscdk.services.scheduler.ScheduleProps;
import software.amazon.awscdk.services.scheduler.TimeWindow;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_scheduler.Schedule")
public class Schedule
extends Resource
implements ISchedule {
    public static final String PROPERTY_INJECTION_ID = (String)JsiiObject.jsiiStaticGet(Schedule.class, (String)"PROPERTY_INJECTION_ID", (NativeType)NativeType.forClass(String.class));

    protected Schedule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Schedule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Schedule(@NotNull Construct scope, @NotNull String id, @NotNull ScheduleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static ISchedule fromScheduleArn(@NotNull Construct scope, @NotNull String id, @NotNull String scheduleArn) {
        return (ISchedule)JsiiObject.jsiiStaticCall(Schedule.class, (String)"fromScheduleArn", (NativeType)NativeType.forClass(ISchedule.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(scheduleArn, "scheduleArn is required")});
    }

    @NotNull
    public static Metric metricAll(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAll", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @NotNull
    public static Metric metricAll(@NotNull String metricName) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAll", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @NotNull
    public static Metric metricAllAttempts(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllAttempts", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllAttempts() {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllAttempts", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllDropped(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllDropped", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllDropped() {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllDropped", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllErrors(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllErrors() {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllFailedToBeSentToDLQ(@Nullable String errorCode, @Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllFailedToBeSentToDLQ", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{errorCode, props});
    }

    @NotNull
    public static Metric metricAllFailedToBeSentToDLQ(@Nullable String errorCode) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllFailedToBeSentToDLQ", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{errorCode});
    }

    @NotNull
    public static Metric metricAllFailedToBeSentToDLQ() {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllFailedToBeSentToDLQ", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllSentToDLQ(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllSentToDLQ", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllSentToDLQ() {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllSentToDLQ", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllSentToDLQTruncated(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllSentToDLQTruncated", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllSentToDLQTruncated() {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllSentToDLQTruncated", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllTargetThrottled(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllTargetThrottled", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllTargetThrottled() {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllTargetThrottled", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public static Metric metricAllThrottled(@Nullable MetricOptions props) {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllThrottled", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @NotNull
    public static Metric metricAllThrottled() {
        return (Metric)JsiiObject.jsiiStaticCall(Schedule.class, (String)"metricAllThrottled", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getScheduleArn() {
        return (String)Kernel.get((Object)this, (String)"scheduleArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getScheduleName() {
        return (String)Kernel.get((Object)this, (String)"scheduleName", (NativeType)NativeType.forClass(String.class));
    }

    @Nullable
    public IKey getKey() {
        return (IKey)Kernel.get((Object)this, (String)"key", (NativeType)NativeType.forClass(IKey.class));
    }

    @Override
    @Nullable
    public IScheduleGroup getScheduleGroup() {
        return (IScheduleGroup)Kernel.get((Object)this, (String)"scheduleGroup", (NativeType)NativeType.forClass(IScheduleGroup.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Schedule> {
        private final Construct scope;
        private final String id;
        private final ScheduleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ScheduleProps.Builder();
        }

        public Builder schedule(ScheduleExpression schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder target(IScheduleTarget target) {
            this.props.target(target);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        public Builder end(Instant end) {
            this.props.end(end);
            return this;
        }

        public Builder key(IKey key) {
            this.props.key(key);
            return this;
        }

        public Builder scheduleGroup(IScheduleGroup scheduleGroup) {
            this.props.scheduleGroup(scheduleGroup);
            return this;
        }

        public Builder scheduleName(String scheduleName) {
            this.props.scheduleName(scheduleName);
            return this;
        }

        public Builder start(Instant start) {
            this.props.start(start);
            return this;
        }

        public Builder timeWindow(TimeWindow timeWindow) {
            this.props.timeWindow(timeWindow);
            return this;
        }

        public Schedule build() {
            return new Schedule(this.scope, this.id, this.props.build());
        }
    }
}

