/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.scheduler.targets;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.awscdk.services.scheduler.ISchedule;
import software.amazon.awscdk.services.scheduler.IScheduleTarget;
import software.amazon.awscdk.services.scheduler.ScheduleTargetConfig;
import software.amazon.awscdk.services.scheduler.ScheduleTargetInput;
import software.amazon.awscdk.services.scheduler.targets.KinesisStreamPutRecordProps;
import software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBase;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_scheduler_targets.KinesisStreamPutRecord")
public class KinesisStreamPutRecord
extends ScheduleTargetBase
implements IScheduleTarget {
    protected KinesisStreamPutRecord(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KinesisStreamPutRecord(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public KinesisStreamPutRecord(@NotNull IStream stream, @NotNull KinesisStreamPutRecordProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(stream, "stream is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    protected void addTargetActionToRole(@NotNull IRole role) {
        Kernel.call((Object)this, (String)"addTargetActionToRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(role, "role is required")});
    }

    @Override
    @NotNull
    protected ScheduleTargetConfig bindBaseTargetConfig(@NotNull ISchedule _schedule) {
        return (ScheduleTargetConfig)Kernel.call((Object)this, (String)"bindBaseTargetConfig", (NativeType)NativeType.forClass(ScheduleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_schedule, "_schedule is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<KinesisStreamPutRecord> {
        private final IStream stream;
        private final KinesisStreamPutRecordProps.Builder props;

        public static Builder create(IStream stream) {
            return new Builder(stream);
        }

        private Builder(IStream stream) {
            this.stream = stream;
            this.props = new KinesisStreamPutRecordProps.Builder();
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder input(ScheduleTargetInput input) {
            this.props.input(input);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder partitionKey(String partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        public KinesisStreamPutRecord build() {
            return new KinesisStreamPutRecord(this.stream, this.props.build());
        }
    }
}

