/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.sns.subscriptions;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kinesisfirehose.IDeliveryStream;
import software.amazon.awscdk.services.sns.FilterOrPolicy;
import software.amazon.awscdk.services.sns.ITopic;
import software.amazon.awscdk.services.sns.ITopicSubscription;
import software.amazon.awscdk.services.sns.SubscriptionFilter;
import software.amazon.awscdk.services.sns.TopicSubscriptionConfig;
import software.amazon.awscdk.services.sns.subscriptions.FirehoseSubscriptionProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_sns_subscriptions.FirehoseSubscription")
public class FirehoseSubscription
extends JsiiObject
implements ITopicSubscription {
    protected FirehoseSubscription(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FirehoseSubscription(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public FirehoseSubscription(@NotNull IDeliveryStream deliveryStream, @Nullable FirehoseSubscriptionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(deliveryStream, "deliveryStream is required"), props});
    }

    public FirehoseSubscription(@NotNull IDeliveryStream deliveryStream) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(deliveryStream, "deliveryStream is required")});
    }

    @Override
    @NotNull
    public TopicSubscriptionConfig bind(@NotNull ITopic topic) {
        return (TopicSubscriptionConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(TopicSubscriptionConfig.class), (Object[])new Object[]{Objects.requireNonNull(topic, "topic is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<FirehoseSubscription> {
        private final IDeliveryStream deliveryStream;
        private FirehoseSubscriptionProps.Builder props;

        public static Builder create(IDeliveryStream deliveryStream) {
            return new Builder(deliveryStream);
        }

        private Builder(IDeliveryStream deliveryStream) {
            this.deliveryStream = deliveryStream;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder filterPolicy(Map<String, ? extends SubscriptionFilter> filterPolicy) {
            this.props().filterPolicy(filterPolicy);
            return this;
        }

        public Builder filterPolicyWithMessageBody(Map<String, ? extends FilterOrPolicy> filterPolicyWithMessageBody) {
            this.props().filterPolicyWithMessageBody(filterPolicyWithMessageBody);
            return this;
        }

        public Builder rawMessageDelivery(Boolean rawMessageDelivery) {
            this.props().rawMessageDelivery(rawMessageDelivery);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public FirehoseSubscription build() {
            return new FirehoseSubscription(this.deliveryStream, this.props != null ? this.props.build() : null);
        }

        private FirehoseSubscriptionProps.Builder props() {
            if (this.props == null) {
                this.props = new FirehoseSubscriptionProps.Builder();
            }
            return this.props;
        }
    }
}

