package software.amazon.awscdk.cloud_assembly_schema;

/**
 * Where to publish docker images.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * Object assumeRoleAdditionalOptions;
 * DockerImageDestination dockerImageDestination = DockerImageDestination.builder()
 *         .imageTag("imageTag")
 *         .repositoryName("repositoryName")
 *         // the properties below are optional
 *         .assumeRoleAdditionalOptions(Map.of(
 *                 "assumeRoleAdditionalOptionsKey", assumeRoleAdditionalOptions))
 *         .assumeRoleArn("assumeRoleArn")
 *         .assumeRoleExternalId("assumeRoleExternalId")
 *         .region("region")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:24.710Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.DockerImageDestination")
@software.amazon.jsii.Jsii.Proxy(DockerImageDestination.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DockerImageDestination extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloud_assembly_schema.AwsDestination {

    /**
     * Tag of the image to publish.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getImageTag();

    /**
     * Name of the ECR repository to publish to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName();

    /**
     * @return a {@link Builder} of {@link DockerImageDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DockerImageDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DockerImageDestination> {
        java.lang.String imageTag;
        java.lang.String repositoryName;
        java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        java.lang.String assumeRoleArn;
        java.lang.String assumeRoleExternalId;
        java.lang.String region;

        /**
         * Sets the value of {@link DockerImageDestination#getImageTag}
         * @param imageTag Tag of the image to publish. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTag(java.lang.String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageDestination#getRepositoryName}
         * @param repositoryName Name of the ECR repository to publish to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageDestination#getAssumeRoleAdditionalOptions}
         * @param assumeRoleAdditionalOptions Additional options to pass to STS when assuming the role.
         *                                    <ul>
         *                                    <li><code>RoleArn</code> should not be used. Use the dedicated <code>assumeRoleArn</code> property instead.</li>
         *                                    <li><code>ExternalId</code> should not be used. Use the dedicated <code>assumeRoleExternalId</code> instead.</li>
         *                                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assumeRoleAdditionalOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> assumeRoleAdditionalOptions) {
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)assumeRoleAdditionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageDestination#getAssumeRoleArn}
         * @param assumeRoleArn The role that needs to be assumed while publishing this asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleArn(java.lang.String assumeRoleArn) {
            this.assumeRoleArn = assumeRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageDestination#getAssumeRoleExternalId}
         * @param assumeRoleExternalId The ExternalId that needs to be supplied while assuming this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRoleExternalId(java.lang.String assumeRoleExternalId) {
            this.assumeRoleExternalId = assumeRoleExternalId;
            return this;
        }

        /**
         * Sets the value of {@link DockerImageDestination#getRegion}
         * @param region The region where this asset will need to be published.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DockerImageDestination}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DockerImageDestination build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DockerImageDestination}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DockerImageDestination {
        private final java.lang.String imageTag;
        private final java.lang.String repositoryName;
        private final java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        private final java.lang.String assumeRoleArn;
        private final java.lang.String assumeRoleExternalId;
        private final java.lang.String region;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.imageTag = software.amazon.jsii.Kernel.get(this, "imageTag", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRoleAdditionalOptions = software.amazon.jsii.Kernel.get(this, "assumeRoleAdditionalOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.assumeRoleArn = software.amazon.jsii.Kernel.get(this, "assumeRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRoleExternalId = software.amazon.jsii.Kernel.get(this, "assumeRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.imageTag = java.util.Objects.requireNonNull(builder.imageTag, "imageTag is required");
            this.repositoryName = java.util.Objects.requireNonNull(builder.repositoryName, "repositoryName is required");
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.assumeRoleAdditionalOptions;
            this.assumeRoleArn = builder.assumeRoleArn;
            this.assumeRoleExternalId = builder.assumeRoleExternalId;
            this.region = builder.region;
        }

        @Override
        public final java.lang.String getImageTag() {
            return this.imageTag;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssumeRoleAdditionalOptions() {
            return this.assumeRoleAdditionalOptions;
        }

        @Override
        public final java.lang.String getAssumeRoleArn() {
            return this.assumeRoleArn;
        }

        @Override
        public final java.lang.String getAssumeRoleExternalId() {
            return this.assumeRoleExternalId;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("imageTag", om.valueToTree(this.getImageTag()));
            data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            if (this.getAssumeRoleAdditionalOptions() != null) {
                data.set("assumeRoleAdditionalOptions", om.valueToTree(this.getAssumeRoleAdditionalOptions()));
            }
            if (this.getAssumeRoleArn() != null) {
                data.set("assumeRoleArn", om.valueToTree(this.getAssumeRoleArn()));
            }
            if (this.getAssumeRoleExternalId() != null) {
                data.set("assumeRoleExternalId", om.valueToTree(this.getAssumeRoleExternalId()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.DockerImageDestination"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DockerImageDestination.Jsii$Proxy that = (DockerImageDestination.Jsii$Proxy) o;

            if (!imageTag.equals(that.imageTag)) return false;
            if (!repositoryName.equals(that.repositoryName)) return false;
            if (this.assumeRoleAdditionalOptions != null ? !this.assumeRoleAdditionalOptions.equals(that.assumeRoleAdditionalOptions) : that.assumeRoleAdditionalOptions != null) return false;
            if (this.assumeRoleArn != null ? !this.assumeRoleArn.equals(that.assumeRoleArn) : that.assumeRoleArn != null) return false;
            if (this.assumeRoleExternalId != null ? !this.assumeRoleExternalId.equals(that.assumeRoleExternalId) : that.assumeRoleExternalId != null) return false;
            return this.region != null ? this.region.equals(that.region) : that.region == null;
        }

        @Override
        public final int hashCode() {
            int result = this.imageTag.hashCode();
            result = 31 * result + (this.repositoryName.hashCode());
            result = 31 * result + (this.assumeRoleAdditionalOptions != null ? this.assumeRoleAdditionalOptions.hashCode() : 0);
            result = 31 * result + (this.assumeRoleArn != null ? this.assumeRoleArn.hashCode() : 0);
            result = 31 * result + (this.assumeRoleExternalId != null ? this.assumeRoleExternalId.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            return result;
        }
    }
}
