package software.amazon.awscdk.cloud_assembly_schema;

/**
 * Query input for looking up a KMS Key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * Object assumeRoleAdditionalOptions;
 * KeyContextQuery keyContextQuery = KeyContextQuery.builder()
 *         .account("account")
 *         .aliasName("aliasName")
 *         .region("region")
 *         // the properties below are optional
 *         .assumeRoleAdditionalOptions(Map.of(
 *                 "assumeRoleAdditionalOptionsKey", assumeRoleAdditionalOptions))
 *         .lookupRoleArn("lookupRoleArn")
 *         .lookupRoleExternalId("lookupRoleExternalId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:24.717Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.KeyContextQuery")
@software.amazon.jsii.Jsii.Proxy(KeyContextQuery.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KeyContextQuery extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloud_assembly_schema.ContextLookupRoleOptions {

    /**
     * Alias name used to search the Key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAliasName();

    /**
     * @return a {@link Builder} of {@link KeyContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KeyContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KeyContextQuery> {
        java.lang.String aliasName;
        java.lang.String account;
        java.lang.String region;
        java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        java.lang.String lookupRoleArn;
        java.lang.String lookupRoleExternalId;

        /**
         * Sets the value of {@link KeyContextQuery#getAliasName}
         * @param aliasName Alias name used to search the Key. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aliasName(java.lang.String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        /**
         * Sets the value of {@link KeyContextQuery#getAccount}
         * @param account Query account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder account(java.lang.String account) {
            this.account = account;
            return this;
        }

        /**
         * Sets the value of {@link KeyContextQuery#getRegion}
         * @param region Query region. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link KeyContextQuery#getAssumeRoleAdditionalOptions}
         * @param assumeRoleAdditionalOptions Additional options to pass to STS when assuming the lookup role.
         *                                    <ul>
         *                                    <li><code>RoleArn</code> should not be used. Use the dedicated <code>lookupRoleArn</code> property instead.</li>
         *                                    <li><code>ExternalId</code> should not be used. Use the dedicated <code>lookupRoleExternalId</code> instead.</li>
         *                                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assumeRoleAdditionalOptions(java.util.Map<java.lang.String, ? extends java.lang.Object> assumeRoleAdditionalOptions) {
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)assumeRoleAdditionalOptions;
            return this;
        }

        /**
         * Sets the value of {@link KeyContextQuery#getLookupRoleArn}
         * @param lookupRoleArn The ARN of the role that should be used to look up the missing values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleArn(java.lang.String lookupRoleArn) {
            this.lookupRoleArn = lookupRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link KeyContextQuery#getLookupRoleExternalId}
         * @param lookupRoleExternalId The ExternalId that needs to be supplied while assuming this role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookupRoleExternalId(java.lang.String lookupRoleExternalId) {
            this.lookupRoleExternalId = lookupRoleExternalId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KeyContextQuery}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KeyContextQuery build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KeyContextQuery}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KeyContextQuery {
        private final java.lang.String aliasName;
        private final java.lang.String account;
        private final java.lang.String region;
        private final java.util.Map<java.lang.String, java.lang.Object> assumeRoleAdditionalOptions;
        private final java.lang.String lookupRoleArn;
        private final java.lang.String lookupRoleExternalId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aliasName = software.amazon.jsii.Kernel.get(this, "aliasName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.account = software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assumeRoleAdditionalOptions = software.amazon.jsii.Kernel.get(this, "assumeRoleAdditionalOptions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.lookupRoleArn = software.amazon.jsii.Kernel.get(this, "lookupRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.lookupRoleExternalId = software.amazon.jsii.Kernel.get(this, "lookupRoleExternalId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aliasName = java.util.Objects.requireNonNull(builder.aliasName, "aliasName is required");
            this.account = java.util.Objects.requireNonNull(builder.account, "account is required");
            this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            this.assumeRoleAdditionalOptions = (java.util.Map<java.lang.String, java.lang.Object>)builder.assumeRoleAdditionalOptions;
            this.lookupRoleArn = builder.lookupRoleArn;
            this.lookupRoleExternalId = builder.lookupRoleExternalId;
        }

        @Override
        public final java.lang.String getAliasName() {
            return this.aliasName;
        }

        @Override
        public final java.lang.String getAccount() {
            return this.account;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssumeRoleAdditionalOptions() {
            return this.assumeRoleAdditionalOptions;
        }

        @Override
        public final java.lang.String getLookupRoleArn() {
            return this.lookupRoleArn;
        }

        @Override
        public final java.lang.String getLookupRoleExternalId() {
            return this.lookupRoleExternalId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aliasName", om.valueToTree(this.getAliasName()));
            data.set("account", om.valueToTree(this.getAccount()));
            data.set("region", om.valueToTree(this.getRegion()));
            if (this.getAssumeRoleAdditionalOptions() != null) {
                data.set("assumeRoleAdditionalOptions", om.valueToTree(this.getAssumeRoleAdditionalOptions()));
            }
            if (this.getLookupRoleArn() != null) {
                data.set("lookupRoleArn", om.valueToTree(this.getLookupRoleArn()));
            }
            if (this.getLookupRoleExternalId() != null) {
                data.set("lookupRoleExternalId", om.valueToTree(this.getLookupRoleExternalId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.KeyContextQuery"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KeyContextQuery.Jsii$Proxy that = (KeyContextQuery.Jsii$Proxy) o;

            if (!aliasName.equals(that.aliasName)) return false;
            if (!account.equals(that.account)) return false;
            if (!region.equals(that.region)) return false;
            if (this.assumeRoleAdditionalOptions != null ? !this.assumeRoleAdditionalOptions.equals(that.assumeRoleAdditionalOptions) : that.assumeRoleAdditionalOptions != null) return false;
            if (this.lookupRoleArn != null ? !this.lookupRoleArn.equals(that.lookupRoleArn) : that.lookupRoleArn != null) return false;
            return this.lookupRoleExternalId != null ? this.lookupRoleExternalId.equals(that.lookupRoleExternalId) : that.lookupRoleExternalId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.aliasName.hashCode();
            result = 31 * result + (this.account.hashCode());
            result = 31 * result + (this.region.hashCode());
            result = 31 * result + (this.assumeRoleAdditionalOptions != null ? this.assumeRoleAdditionalOptions.hashCode() : 0);
            result = 31 * result + (this.lookupRoleArn != null ? this.lookupRoleArn.hashCode() : 0);
            result = 31 * result + (this.lookupRoleExternalId != null ? this.lookupRoleExternalId.hashCode() : 0);
            return result;
        }
    }
}
