package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * Object default_;
 * Object enum_;
 * JsonSchema jsonSchema_;
 * RestApi restApi;
 * ModelProps modelProps = ModelProps.builder()
 *         .restApi(restApi)
 *         .schema(JsonSchema.builder()
 *                 .additionalItems(false)
 *                 .additionalProperties(false)
 *                 .allOf(List.of(jsonSchema_))
 *                 .anyOf(List.of(jsonSchema_))
 *                 .contains(jsonSchema_)
 *                 .default(default_)
 *                 .definitions(Map.of(
 *                         "definitionsKey", jsonSchema_))
 *                 .dependencies(Map.of(
 *                         "dependenciesKey", List.of("dependencies")))
 *                 .description("description")
 *                 .enum(List.of(enum_))
 *                 .exclusiveMaximum(false)
 *                 .exclusiveMinimum(false)
 *                 .format("format")
 *                 .id("id")
 *                 .items(jsonSchema_)
 *                 .maximum(123)
 *                 .maxItems(123)
 *                 .maxLength(123)
 *                 .maxProperties(123)
 *                 .minimum(123)
 *                 .minItems(123)
 *                 .minLength(123)
 *                 .minProperties(123)
 *                 .multipleOf(123)
 *                 .not(jsonSchema_)
 *                 .oneOf(List.of(jsonSchema_))
 *                 .pattern("pattern")
 *                 .patternProperties(Map.of(
 *                         "patternPropertiesKey", jsonSchema_))
 *                 .properties(Map.of(
 *                         "propertiesKey", jsonSchema_))
 *                 .propertyNames(jsonSchema_)
 *                 .ref("ref")
 *                 .required(List.of("required"))
 *                 .schema(JsonSchemaVersion.DRAFT4)
 *                 .title("title")
 *                 .type(JsonSchemaType.NULL)
 *                 .uniqueItems(false)
 *                 .build())
 *         // the properties below are optional
 *         .contentType("contentType")
 *         .description("description")
 *         .modelName("modelName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:08.805Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.ModelProps")
@software.amazon.jsii.Jsii.Proxy(ModelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ModelProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ModelOptions {

    /**
     * The rest API that this model is part of.
     * <p>
     * The reason we need the RestApi object itself and not just the ID is because the model
     * is being tracked by the top-level RestApi object for the purpose of calculating it's
     * hash to determine the ID of the deployment. This allows us to automatically update
     * the deployment when the model of the REST API changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi getRestApi();

    /**
     * @return a {@link Builder} of {@link ModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ModelProps> {
        software.amazon.awscdk.services.apigateway.IRestApi restApi;
        software.amazon.awscdk.services.apigateway.JsonSchema schema;
        java.lang.String contentType;
        java.lang.String description;
        java.lang.String modelName;

        /**
         * Sets the value of {@link ModelProps#getRestApi}
         * @param restApi The rest API that this model is part of. This parameter is required.
         *                The reason we need the RestApi object itself and not just the ID is because the model
         *                is being tracked by the top-level RestApi object for the purpose of calculating it's
         *                hash to determine the ID of the deployment. This allows us to automatically update
         *                the deployment when the model of the REST API changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApi(software.amazon.awscdk.services.apigateway.IRestApi restApi) {
            this.restApi = restApi;
            return this;
        }

        /**
         * Sets the value of {@link ModelProps#getSchema}
         * @param schema The schema to use to transform data to one or more output formats. This parameter is required.
         *               Specify null ({}) if you don't want to specify a schema.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schema(software.amazon.awscdk.services.apigateway.JsonSchema schema) {
            this.schema = schema;
            return this;
        }

        /**
         * Sets the value of {@link ModelProps#getContentType}
         * @param contentType The content type for the model.
         *                    You can also force a
         *                    content type in the request or response model mapping.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentType(java.lang.String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Sets the value of {@link ModelProps#getDescription}
         * @param description A description that identifies this model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ModelProps#getModelName}
         * @param modelName A name for the model.
         *                  Important
         *                  If you specify a name, you cannot perform updates that
         *                  require replacement of this resource. You can perform
         *                  updates that require no or some interruption. If you
         *                  must replace the resource, specify a new name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelName(java.lang.String modelName) {
            this.modelName = modelName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ModelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ModelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelProps {
        private final software.amazon.awscdk.services.apigateway.IRestApi restApi;
        private final software.amazon.awscdk.services.apigateway.JsonSchema schema;
        private final java.lang.String contentType;
        private final java.lang.String description;
        private final java.lang.String modelName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.restApi = software.amazon.jsii.Kernel.get(this, "restApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class));
            this.schema = software.amazon.jsii.Kernel.get(this, "schema", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.JsonSchema.class));
            this.contentType = software.amazon.jsii.Kernel.get(this, "contentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelName = software.amazon.jsii.Kernel.get(this, "modelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restApi = java.util.Objects.requireNonNull(builder.restApi, "restApi is required");
            this.schema = java.util.Objects.requireNonNull(builder.schema, "schema is required");
            this.contentType = builder.contentType;
            this.description = builder.description;
            this.modelName = builder.modelName;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IRestApi getRestApi() {
            return this.restApi;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.JsonSchema getSchema() {
            return this.schema;
        }

        @Override
        public final java.lang.String getContentType() {
            return this.contentType;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getModelName() {
            return this.modelName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("restApi", om.valueToTree(this.getRestApi()));
            data.set("schema", om.valueToTree(this.getSchema()));
            if (this.getContentType() != null) {
                data.set("contentType", om.valueToTree(this.getContentType()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getModelName() != null) {
                data.set("modelName", om.valueToTree(this.getModelName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.ModelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ModelProps.Jsii$Proxy that = (ModelProps.Jsii$Proxy) o;

            if (!restApi.equals(that.restApi)) return false;
            if (!schema.equals(that.schema)) return false;
            if (this.contentType != null ? !this.contentType.equals(that.contentType) : that.contentType != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.modelName != null ? this.modelName.equals(that.modelName) : that.modelName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.restApi.hashCode();
            result = 31 * result + (this.schema.hashCode());
            result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.modelName != null ? this.modelName.hashCode() : 0);
            return result;
        }
    }
}
