package software.amazon.awscdk.services.apigatewayv2;

/**
 * Attributes for importing a WebSocketApi into the CDK.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IWebSocketApi webSocketApi = WebSocketApi.fromWebSocketApiAttributes(this, "mywsapi", WebSocketApiAttributes.builder().webSocketId("api-1234").build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:09.015Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketApiAttributes")
@software.amazon.jsii.Jsii.Proxy(WebSocketApiAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketApiAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the WebSocketApi.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getWebSocketId();

    /**
     * The endpoint URL of the WebSocketApi.
     * <p>
     * Default: - throw san error if apiEndpoint is accessed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiEndpoint() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketApiAttributes> {
        java.lang.String webSocketId;
        java.lang.String apiEndpoint;

        /**
         * Sets the value of {@link WebSocketApiAttributes#getWebSocketId}
         * @param webSocketId The identifier of the WebSocketApi. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webSocketId(java.lang.String webSocketId) {
            this.webSocketId = webSocketId;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketApiAttributes#getApiEndpoint}
         * @param apiEndpoint The endpoint URL of the WebSocketApi.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiEndpoint(java.lang.String apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketApiAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketApiAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketApiAttributes {
        private final java.lang.String webSocketId;
        private final java.lang.String apiEndpoint;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.webSocketId = software.amazon.jsii.Kernel.get(this, "webSocketId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiEndpoint = software.amazon.jsii.Kernel.get(this, "apiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.webSocketId = java.util.Objects.requireNonNull(builder.webSocketId, "webSocketId is required");
            this.apiEndpoint = builder.apiEndpoint;
        }

        @Override
        public final java.lang.String getWebSocketId() {
            return this.webSocketId;
        }

        @Override
        public final java.lang.String getApiEndpoint() {
            return this.apiEndpoint;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("webSocketId", om.valueToTree(this.getWebSocketId()));
            if (this.getApiEndpoint() != null) {
                data.set("apiEndpoint", om.valueToTree(this.getApiEndpoint()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketApiAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketApiAttributes.Jsii$Proxy that = (WebSocketApiAttributes.Jsii$Proxy) o;

            if (!webSocketId.equals(that.webSocketId)) return false;
            return this.apiEndpoint != null ? this.apiEndpoint.equals(that.apiEndpoint) : that.apiEndpoint == null;
        }

        @Override
        public final int hashCode() {
            int result = this.webSocketId.hashCode();
            result = 31 * result + (this.apiEndpoint != null ? this.apiEndpoint.hashCode() : 0);
            return result;
        }
    }
}
