package software.amazon.awscdk.services.appmesh;

/**
 * Configuration for <code>HeaderMatch</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * HeaderMatchConfig headerMatchConfig = HeaderMatchConfig.builder()
 *         .headerMatch(HttpRouteHeaderProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .invert(false)
 *                 .match(HeaderMatchMethodProperty.builder()
 *                         .exact("exact")
 *                         .prefix("prefix")
 *                         .range(MatchRangeProperty.builder()
 *                                 .end(123)
 *                                 .start(123)
 *                                 .build())
 *                         .regex("regex")
 *                         .suffix("suffix")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:09.511Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HeaderMatchConfig")
@software.amazon.jsii.Jsii.Proxy(HeaderMatchConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HeaderMatchConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Route CFN configuration for the route header match.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteHeaderProperty getHeaderMatch();

    /**
     * @return a {@link Builder} of {@link HeaderMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HeaderMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HeaderMatchConfig> {
        software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteHeaderProperty headerMatch;

        /**
         * Sets the value of {@link HeaderMatchConfig#getHeaderMatch}
         * @param headerMatch Route CFN configuration for the route header match. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headerMatch(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteHeaderProperty headerMatch) {
            this.headerMatch = headerMatch;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HeaderMatchConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HeaderMatchConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HeaderMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeaderMatchConfig {
        private final software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteHeaderProperty headerMatch;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.headerMatch = software.amazon.jsii.Kernel.get(this, "headerMatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteHeaderProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.headerMatch = java.util.Objects.requireNonNull(builder.headerMatch, "headerMatch is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteHeaderProperty getHeaderMatch() {
            return this.headerMatch;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("headerMatch", om.valueToTree(this.getHeaderMatch()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.HeaderMatchConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HeaderMatchConfig.Jsii$Proxy that = (HeaderMatchConfig.Jsii$Proxy) o;

            return this.headerMatch.equals(that.headerMatch);
        }

        @Override
        public final int hashCode() {
            int result = this.headerMatch.hashCode();
            return result;
        }
    }
}
