package software.amazon.awscdk.services.appmesh;

/**
 * The type returned from the <code>bind()</code> method in <code>HttpRoutePathMatch</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * HttpRoutePathMatchConfig httpRoutePathMatchConfig = HttpRoutePathMatchConfig.builder()
 *         .prefixPathMatch("prefixPathMatch")
 *         .wholePathMatch(HttpPathMatchProperty.builder()
 *                 .exact("exact")
 *                 .regex("regex")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:09.519Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HttpRoutePathMatchConfig")
@software.amazon.jsii.Jsii.Proxy(HttpRoutePathMatchConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpRoutePathMatchConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * Route configuration for matching on the prefix of the URL path of the request.
     * <p>
     * Default: - no matching will be performed on the prefix of the URL path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefixPathMatch() {
        return null;
    }

    /**
     * Route configuration for matching on the complete URL path of the request.
     * <p>
     * Default: - no matching will be performed on the complete URL path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appmesh.CfnRoute.HttpPathMatchProperty getWholePathMatch() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpRoutePathMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpRoutePathMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpRoutePathMatchConfig> {
        java.lang.String prefixPathMatch;
        software.amazon.awscdk.services.appmesh.CfnRoute.HttpPathMatchProperty wholePathMatch;

        /**
         * Sets the value of {@link HttpRoutePathMatchConfig#getPrefixPathMatch}
         * @param prefixPathMatch Route configuration for matching on the prefix of the URL path of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefixPathMatch(java.lang.String prefixPathMatch) {
            this.prefixPathMatch = prefixPathMatch;
            return this;
        }

        /**
         * Sets the value of {@link HttpRoutePathMatchConfig#getWholePathMatch}
         * @param wholePathMatch Route configuration for matching on the complete URL path of the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wholePathMatch(software.amazon.awscdk.services.appmesh.CfnRoute.HttpPathMatchProperty wholePathMatch) {
            this.wholePathMatch = wholePathMatch;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpRoutePathMatchConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpRoutePathMatchConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpRoutePathMatchConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRoutePathMatchConfig {
        private final java.lang.String prefixPathMatch;
        private final software.amazon.awscdk.services.appmesh.CfnRoute.HttpPathMatchProperty wholePathMatch;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.prefixPathMatch = software.amazon.jsii.Kernel.get(this, "prefixPathMatch", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.wholePathMatch = software.amazon.jsii.Kernel.get(this, "wholePathMatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.CfnRoute.HttpPathMatchProperty.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.prefixPathMatch = builder.prefixPathMatch;
            this.wholePathMatch = builder.wholePathMatch;
        }

        @Override
        public final java.lang.String getPrefixPathMatch() {
            return this.prefixPathMatch;
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.CfnRoute.HttpPathMatchProperty getWholePathMatch() {
            return this.wholePathMatch;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPrefixPathMatch() != null) {
                data.set("prefixPathMatch", om.valueToTree(this.getPrefixPathMatch()));
            }
            if (this.getWholePathMatch() != null) {
                data.set("wholePathMatch", om.valueToTree(this.getWholePathMatch()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.HttpRoutePathMatchConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpRoutePathMatchConfig.Jsii$Proxy that = (HttpRoutePathMatchConfig.Jsii$Proxy) o;

            if (this.prefixPathMatch != null ? !this.prefixPathMatch.equals(that.prefixPathMatch) : that.prefixPathMatch != null) return false;
            return this.wholePathMatch != null ? this.wholePathMatch.equals(that.wholePathMatch) : that.wholePathMatch == null;
        }

        @Override
        public final int hashCode() {
            int result = this.prefixPathMatch != null ? this.prefixPathMatch.hashCode() : 0;
            result = 31 * result + (this.wholePathMatch != null ? this.wholePathMatch.hashCode() : 0);
            return result;
        }
    }
}
