package software.amazon.awscdk.services.appsync;

/**
 * enum with all possible values for AppSync authorization type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * AppSyncAuthProvider apiKeyProvider = AppSyncAuthProvider.builder()
 *         .authorizationType(AppSyncAuthorizationType.API_KEY)
 *         .build();
 * EventApi api = EventApi.Builder.create(this, "api")
 *         .apiName("Api")
 *         .ownerContact("OwnerContact")
 *         .authorizationConfig(EventApiAuthConfig.builder()
 *                 .authProviders(List.of(apiKeyProvider))
 *                 .connectionAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultPublishAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultSubscribeAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .build())
 *         .logConfig(AppSyncLogConfig.builder()
 *                 .fieldLogLevel(AppSyncFieldLogLevel.INFO)
 *                 .retention(RetentionDays.ONE_WEEK)
 *                 .build())
 *         .build();
 * api.addChannelNamespace("default");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:09.673Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncAuthorizationType")
public enum AppSyncAuthorizationType {
    /**
     * API Key authorization type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    API_KEY,
    /**
     * AWS IAM authorization type.
     * <p>
     * Can be used with Cognito Identity Pool federated credentials
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IAM,
    /**
     * Cognito User Pool authorization type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    USER_POOL,
    /**
     * OpenID Connect authorization type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OIDC,
    /**
     * Lambda authorization type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA,
}
