package software.amazon.awscdk.services.appsync;

/**
 * Attributes for Event API imports.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * EventApiAttributes eventApiAttributes = EventApiAttributes.builder()
 *         .apiId("apiId")
 *         .httpDns("httpDns")
 *         .realtimeDns("realtimeDns")
 *         // the properties below are optional
 *         .apiArn("apiArn")
 *         .apiName("apiName")
 *         .authProviderTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:09.786Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.EventApiAttributes")
@software.amazon.jsii.Jsii.Proxy(EventApiAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EventApiAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * an unique AWS AppSync Event API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * the domain name of the Api's HTTP endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHttpDns();

    /**
     * the domain name of the Api's real-time endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRealtimeDns();

    /**
     * the ARN of the Event API.
     * <p>
     * Default: - constructed arn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiArn() {
        return null;
    }

    /**
     * the name of the Event API.
     * <p>
     * Default: - not needed to import API
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiName() {
        return null;
    }

    /**
     * The Authorization Types for this Event Api.
     * <p>
     * Default: - none, required to construct event rules from imported APIs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getAuthProviderTypes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EventApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EventApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EventApiAttributes> {
        java.lang.String apiId;
        java.lang.String httpDns;
        java.lang.String realtimeDns;
        java.lang.String apiArn;
        java.lang.String apiName;
        java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> authProviderTypes;

        /**
         * Sets the value of {@link EventApiAttributes#getApiId}
         * @param apiId an unique AWS AppSync Event API identifier i.e. 'lxz775lwdrgcndgz3nurvac7oa'. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link EventApiAttributes#getHttpDns}
         * @param httpDns the domain name of the Api's HTTP endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpDns(java.lang.String httpDns) {
            this.httpDns = httpDns;
            return this;
        }

        /**
         * Sets the value of {@link EventApiAttributes#getRealtimeDns}
         * @param realtimeDns the domain name of the Api's real-time endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder realtimeDns(java.lang.String realtimeDns) {
            this.realtimeDns = realtimeDns;
            return this;
        }

        /**
         * Sets the value of {@link EventApiAttributes#getApiArn}
         * @param apiArn the ARN of the Event API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiArn(java.lang.String apiArn) {
            this.apiArn = apiArn;
            return this;
        }

        /**
         * Sets the value of {@link EventApiAttributes#getApiName}
         * @param apiName the name of the Event API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiName(java.lang.String apiName) {
            this.apiName = apiName;
            return this;
        }

        /**
         * Sets the value of {@link EventApiAttributes#getAuthProviderTypes}
         * @param authProviderTypes The Authorization Types for this Event Api.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder authProviderTypes(java.util.List<? extends software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> authProviderTypes) {
            this.authProviderTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)authProviderTypes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EventApiAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EventApiAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EventApiAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventApiAttributes {
        private final java.lang.String apiId;
        private final java.lang.String httpDns;
        private final java.lang.String realtimeDns;
        private final java.lang.String apiArn;
        private final java.lang.String apiName;
        private final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> authProviderTypes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.httpDns = software.amazon.jsii.Kernel.get(this, "httpDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.realtimeDns = software.amazon.jsii.Kernel.get(this, "realtimeDns", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiArn = software.amazon.jsii.Kernel.get(this, "apiArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiName = software.amazon.jsii.Kernel.get(this, "apiName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authProviderTypes = software.amazon.jsii.Kernel.get(this, "authProviderTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncAuthorizationType.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.httpDns = java.util.Objects.requireNonNull(builder.httpDns, "httpDns is required");
            this.realtimeDns = java.util.Objects.requireNonNull(builder.realtimeDns, "realtimeDns is required");
            this.apiArn = builder.apiArn;
            this.apiName = builder.apiName;
            this.authProviderTypes = (java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType>)builder.authProviderTypes;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getHttpDns() {
            return this.httpDns;
        }

        @Override
        public final java.lang.String getRealtimeDns() {
            return this.realtimeDns;
        }

        @Override
        public final java.lang.String getApiArn() {
            return this.apiArn;
        }

        @Override
        public final java.lang.String getApiName() {
            return this.apiName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.AppSyncAuthorizationType> getAuthProviderTypes() {
            return this.authProviderTypes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            data.set("httpDns", om.valueToTree(this.getHttpDns()));
            data.set("realtimeDns", om.valueToTree(this.getRealtimeDns()));
            if (this.getApiArn() != null) {
                data.set("apiArn", om.valueToTree(this.getApiArn()));
            }
            if (this.getApiName() != null) {
                data.set("apiName", om.valueToTree(this.getApiName()));
            }
            if (this.getAuthProviderTypes() != null) {
                data.set("authProviderTypes", om.valueToTree(this.getAuthProviderTypes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appsync.EventApiAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EventApiAttributes.Jsii$Proxy that = (EventApiAttributes.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!httpDns.equals(that.httpDns)) return false;
            if (!realtimeDns.equals(that.realtimeDns)) return false;
            if (this.apiArn != null ? !this.apiArn.equals(that.apiArn) : that.apiArn != null) return false;
            if (this.apiName != null ? !this.apiName.equals(that.apiName) : that.apiName != null) return false;
            return this.authProviderTypes != null ? this.authProviderTypes.equals(that.authProviderTypes) : that.authProviderTypes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.httpDns.hashCode());
            result = 31 * result + (this.realtimeDns.hashCode());
            result = 31 * result + (this.apiArn != null ? this.apiArn.hashCode() : 0);
            result = 31 * result + (this.apiName != null ? this.apiName.hashCode() : 0);
            result = 31 * result + (this.authProviderTypes != null ? this.authProviderTypes.hashCode() : 0);
            return result;
        }
    }
}
