package software.amazon.awscdk.services.arczonalshift;

/**
 * Properties for defining a <code>CfnZonalAutoshiftConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.arczonalshift.*;
 * CfnZonalAutoshiftConfigurationProps cfnZonalAutoshiftConfigurationProps = CfnZonalAutoshiftConfigurationProps.builder()
 *         .resourceIdentifier("resourceIdentifier")
 *         // the properties below are optional
 *         .practiceRunConfiguration(PracticeRunConfigurationProperty.builder()
 *                 .outcomeAlarms(List.of(ControlConditionProperty.builder()
 *                         .alarmIdentifier("alarmIdentifier")
 *                         .type("type")
 *                         .build()))
 *                 // the properties below are optional
 *                 .blockedDates(List.of("blockedDates"))
 *                 .blockedWindows(List.of("blockedWindows"))
 *                 .blockingAlarms(List.of(ControlConditionProperty.builder()
 *                         .alarmIdentifier("alarmIdentifier")
 *                         .type("type")
 *                         .build()))
 *                 .build())
 *         .zonalAutoshiftStatus("zonalAutoshiftStatus")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:09.883Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_arczonalshift.CfnZonalAutoshiftConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnZonalAutoshiftConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnZonalAutoshiftConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier for the resource that AWS shifts traffic for.
     * <p>
     * The identifier is the Amazon Resource Name (ARN) for the resource.
     * <p>
     * At this time, supported resources are Network Load Balancers and Application Load Balancers.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-resourceidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-resourceidentifier</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getResourceIdentifier();

    /**
     * A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run.
     * <p>
     * When a resource has a practice run configuration, ARC shifts traffic for the resource weekly for practice runs.
     * <p>
     * Practice runs are required for zonal autoshift. The zonal shifts that ARC starts for practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.
     * <p>
     * You can update or delete a practice run configuration. Before you delete a practice run configuration, you must disable zonal autoshift for the resource. A practice run configuration is required when zonal autoshift is enabled.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-practicerunconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPracticeRunConfiguration() {
        return null;
    }

    /**
     * When zonal autoshift is <code>ENABLED</code> , you authorize AWS to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery.
     * <p>
     * Traffic is also shifted away for the required weekly practice runs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-zonalautoshiftstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-arczonalshift-zonalautoshiftconfiguration.html#cfn-arczonalshift-zonalautoshiftconfiguration-zonalautoshiftstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getZonalAutoshiftStatus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnZonalAutoshiftConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnZonalAutoshiftConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnZonalAutoshiftConfigurationProps> {
        java.lang.String resourceIdentifier;
        java.lang.Object practiceRunConfiguration;
        java.lang.String zonalAutoshiftStatus;

        /**
         * Sets the value of {@link CfnZonalAutoshiftConfigurationProps#getResourceIdentifier}
         * @param resourceIdentifier The identifier for the resource that AWS shifts traffic for. This parameter is required.
         *                           The identifier is the Amazon Resource Name (ARN) for the resource.
         *                           <p>
         *                           At this time, supported resources are Network Load Balancers and Application Load Balancers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceIdentifier(java.lang.String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnZonalAutoshiftConfigurationProps#getPracticeRunConfiguration}
         * @param practiceRunConfiguration A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run.
         *                                 When a resource has a practice run configuration, ARC shifts traffic for the resource weekly for practice runs.
         *                                 <p>
         *                                 Practice runs are required for zonal autoshift. The zonal shifts that ARC starts for practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.
         *                                 <p>
         *                                 You can update or delete a practice run configuration. Before you delete a practice run configuration, you must disable zonal autoshift for the resource. A practice run configuration is required when zonal autoshift is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder practiceRunConfiguration(software.amazon.awscdk.IResolvable practiceRunConfiguration) {
            this.practiceRunConfiguration = practiceRunConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnZonalAutoshiftConfigurationProps#getPracticeRunConfiguration}
         * @param practiceRunConfiguration A practice run configuration for a resource includes the Amazon CloudWatch alarms that you've specified for a practice run, as well as any blocked dates or blocked windows for the practice run.
         *                                 When a resource has a practice run configuration, ARC shifts traffic for the resource weekly for practice runs.
         *                                 <p>
         *                                 Practice runs are required for zonal autoshift. The zonal shifts that ARC starts for practice runs help you to ensure that shifting away traffic from an Availability Zone during an autoshift is safe for your application.
         *                                 <p>
         *                                 You can update or delete a practice run configuration. Before you delete a practice run configuration, you must disable zonal autoshift for the resource. A practice run configuration is required when zonal autoshift is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder practiceRunConfiguration(software.amazon.awscdk.services.arczonalshift.CfnZonalAutoshiftConfiguration.PracticeRunConfigurationProperty practiceRunConfiguration) {
            this.practiceRunConfiguration = practiceRunConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnZonalAutoshiftConfigurationProps#getZonalAutoshiftStatus}
         * @param zonalAutoshiftStatus When zonal autoshift is <code>ENABLED</code> , you authorize AWS to shift away resource traffic for an application from an Availability Zone during events, on your behalf, to help reduce time to recovery.
         *                             Traffic is also shifted away for the required weekly practice runs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zonalAutoshiftStatus(java.lang.String zonalAutoshiftStatus) {
            this.zonalAutoshiftStatus = zonalAutoshiftStatus;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnZonalAutoshiftConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnZonalAutoshiftConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnZonalAutoshiftConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnZonalAutoshiftConfigurationProps {
        private final java.lang.String resourceIdentifier;
        private final java.lang.Object practiceRunConfiguration;
        private final java.lang.String zonalAutoshiftStatus;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.resourceIdentifier = software.amazon.jsii.Kernel.get(this, "resourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.practiceRunConfiguration = software.amazon.jsii.Kernel.get(this, "practiceRunConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.zonalAutoshiftStatus = software.amazon.jsii.Kernel.get(this, "zonalAutoshiftStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.resourceIdentifier = java.util.Objects.requireNonNull(builder.resourceIdentifier, "resourceIdentifier is required");
            this.practiceRunConfiguration = builder.practiceRunConfiguration;
            this.zonalAutoshiftStatus = builder.zonalAutoshiftStatus;
        }

        @Override
        public final java.lang.String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final java.lang.Object getPracticeRunConfiguration() {
            return this.practiceRunConfiguration;
        }

        @Override
        public final java.lang.String getZonalAutoshiftStatus() {
            return this.zonalAutoshiftStatus;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("resourceIdentifier", om.valueToTree(this.getResourceIdentifier()));
            if (this.getPracticeRunConfiguration() != null) {
                data.set("practiceRunConfiguration", om.valueToTree(this.getPracticeRunConfiguration()));
            }
            if (this.getZonalAutoshiftStatus() != null) {
                data.set("zonalAutoshiftStatus", om.valueToTree(this.getZonalAutoshiftStatus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_arczonalshift.CfnZonalAutoshiftConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnZonalAutoshiftConfigurationProps.Jsii$Proxy that = (CfnZonalAutoshiftConfigurationProps.Jsii$Proxy) o;

            if (!resourceIdentifier.equals(that.resourceIdentifier)) return false;
            if (this.practiceRunConfiguration != null ? !this.practiceRunConfiguration.equals(that.practiceRunConfiguration) : that.practiceRunConfiguration != null) return false;
            return this.zonalAutoshiftStatus != null ? this.zonalAutoshiftStatus.equals(that.zonalAutoshiftStatus) : that.zonalAutoshiftStatus == null;
        }

        @Override
        public final int hashCode() {
            int result = this.resourceIdentifier.hashCode();
            result = 31 * result + (this.practiceRunConfiguration != null ? this.practiceRunConfiguration.hashCode() : 0);
            result = 31 * result + (this.zonalAutoshiftStatus != null ? this.zonalAutoshiftStatus.hashCode() : 0);
            return result;
        }
    }
}
