package software.amazon.awscdk.services.autoscaling;

/**
 * Properties for defining a <code>CfnLaunchConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * CfnLaunchConfigurationProps cfnLaunchConfigurationProps = CfnLaunchConfigurationProps.builder()
 *         .imageId("imageId")
 *         .instanceType("instanceType")
 *         // the properties below are optional
 *         .associatePublicIpAddress(false)
 *         .blockDeviceMappings(List.of(BlockDeviceMappingProperty.builder()
 *                 .deviceName("deviceName")
 *                 // the properties below are optional
 *                 .ebs(BlockDeviceProperty.builder()
 *                         .deleteOnTermination(false)
 *                         .encrypted(false)
 *                         .iops(123)
 *                         .snapshotId("snapshotId")
 *                         .throughput(123)
 *                         .volumeSize(123)
 *                         .volumeType("volumeType")
 *                         .build())
 *                 .noDevice(false)
 *                 .virtualName("virtualName")
 *                 .build()))
 *         .classicLinkVpcId("classicLinkVpcId")
 *         .classicLinkVpcSecurityGroups(List.of("classicLinkVpcSecurityGroups"))
 *         .ebsOptimized(false)
 *         .iamInstanceProfile("iamInstanceProfile")
 *         .instanceId("instanceId")
 *         .instanceMonitoring(false)
 *         .kernelId("kernelId")
 *         .keyName("keyName")
 *         .launchConfigurationName("launchConfigurationName")
 *         .metadataOptions(MetadataOptionsProperty.builder()
 *                 .httpEndpoint("httpEndpoint")
 *                 .httpPutResponseHopLimit(123)
 *                 .httpTokens("httpTokens")
 *                 .build())
 *         .placementTenancy("placementTenancy")
 *         .ramDiskId("ramDiskId")
 *         .securityGroups(List.of("securityGroups"))
 *         .spotPrice("spotPrice")
 *         .userData("userData")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:10.009Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnLaunchConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnLaunchConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLaunchConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the Amazon Machine Image (AMI) that was assigned during registration.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Find a Linux AMI</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * If you specify <code>InstanceId</code> , an <code>ImageId</code> is not required.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-imageid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-imageid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getImageId();

    /**
     * Specifies the instance type of the EC2 instance.
     * <p>
     * For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available instance types</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * If you specify <code>InstanceId</code> , an <code>InstanceType</code> is not required.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-instancetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

    /**
     * Specifies whether to assign a public IPv4 address to the group's instances.
     * <p>
     * If the instance is launched into a default subnet, the default is to assign a public IPv4 address, unless you disabled the option to assign a public IPv4 address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IPv4 address, unless you enabled the option to assign a public IPv4 address on the subnet.
     * <p>
     * If you specify <code>true</code> , each instance in the Auto Scaling group receives a unique public IPv4 address. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Provide network connectivity for your Auto Scaling instances using Amazon VPC</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * If you specify this property, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-associatepublicipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-associatepublicipaddress</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAssociatePublicIpAddress() {
        return null;
    }

    /**
     * The block device mapping entries that define the block devices to attach to the instances at launch.
     * <p>
     * By default, the block devices specified in the block device mapping for the AMI are used. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block device mappings</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-blockdevicemappings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-blockdevicemappings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
        return null;
    }

    /**
     * Available for backward compatibility.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-classiclinkvpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-classiclinkvpcid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClassicLinkVpcId() {
        return null;
    }

    /**
     * Available for backward compatibility.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-classiclinkvpcsecuritygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-classiclinkvpcsecuritygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getClassicLinkVpcSecurityGroups() {
        return null;
    }

    /**
     * Specifies whether the launch configuration is optimized for EBS I/O ( <code>true</code> ) or not ( <code>false</code> ).
     * <p>
     * The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS-optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * The default value is <code>false</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-ebsoptimized">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-ebsoptimized</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
        return null;
    }

    /**
     * The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance.
     * <p>
     * The instance profile contains the IAM role. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run on Amazon EC2 instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-iaminstanceprofile">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-iaminstanceprofile</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIamInstanceProfile() {
        return null;
    }

    /**
     * The ID of the Amazon EC2 instance to use to create the launch configuration.
     * <p>
     * When you use an instance to create a launch configuration, all properties are derived from the instance with the exception of <code>BlockDeviceMapping</code> and <code>AssociatePublicIpAddress</code> . You can override any properties from the instance by specifying them in the launch configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-instanceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-instanceid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return null;
    }

    /**
     * Controls whether instances in this group are launched with detailed ( <code>true</code> ) or basic ( <code>false</code> ) monitoring.
     * <p>
     * The default value is <code>true</code> (enabled).
     * <p>
     * <blockquote>
     * <p>
     * When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure monitoring for Auto Scaling instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-instancemonitoring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-instancemonitoring</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceMonitoring() {
        return null;
    }

    /**
     * The ID of the kernel associated with the AMI.
     * <p>
     * <blockquote>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided kernels</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-kernelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-kernelid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKernelId() {
        return null;
    }

    /**
     * The name of the key pair.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs and Amazon EC2 instances</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-keyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-keyname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * The name of the launch configuration.
     * <p>
     * This name must be unique per Region per account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-launchconfigurationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-launchconfigurationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLaunchConfigurationName() {
        return null;
    }

    /**
     * The metadata options for the instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configure the instance metadata options</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-metadataoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-metadataoptions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getMetadataOptions() {
        return null;
    }

    /**
     * The tenancy of the instance, either <code>default</code> or <code>dedicated</code> .
     * <p>
     * An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC. To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to <code>default</code> ), you must set the value of this property to <code>dedicated</code> .
     * <p>
     * If you specify <code>PlacementTenancy</code> , you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.
     * <p>
     * Valid values: <code>default</code> | <code>dedicated</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-placementtenancy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-placementtenancy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPlacementTenancy() {
        return null;
    }

    /**
     * The ID of the RAM disk to select.
     * <p>
     * <blockquote>
     * <p>
     * We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided kernels</a> in the <em>Amazon EC2 User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-ramdiskid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-ramdiskid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRamDiskId() {
        return null;
    }

    /**
     * A list that contains the security groups to assign to the instances in the Auto Scaling group.
     * <p>
     * The list can contain both the IDs of existing security groups and references to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html">SecurityGroup</a> resources created in the template.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Control traffic to resources using security groups</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-securitygroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return null;
    }

    /**
     * The maximum hourly price to be paid for any Spot Instance launched to fulfill the request.
     * <p>
     * Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-template-spot-instances.html">Request Spot Instances for fault-tolerant and flexible applications</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * Valid Range: Minimum value of 0.001
     * <p>
     * <blockquote>
     * <p>
     * When you change your maximum price by creating a new launch configuration, running instances will continue to run as long as the maximum price for those running instances is higher than the current Spot price.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-spotprice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-spotprice</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSpotPrice() {
        return null;
    }

    /**
     * The Base64-encoded user data to make available to the launched EC2 instances.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-userdata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscaling-launchconfiguration.html#cfn-autoscaling-launchconfiguration-userdata</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserData() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLaunchConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLaunchConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLaunchConfigurationProps> {
        java.lang.String imageId;
        java.lang.String instanceType;
        java.lang.Object associatePublicIpAddress;
        java.lang.Object blockDeviceMappings;
        java.lang.String classicLinkVpcId;
        java.util.List<java.lang.String> classicLinkVpcSecurityGroups;
        java.lang.Object ebsOptimized;
        java.lang.String iamInstanceProfile;
        java.lang.String instanceId;
        java.lang.Object instanceMonitoring;
        java.lang.String kernelId;
        java.lang.String keyName;
        java.lang.String launchConfigurationName;
        java.lang.Object metadataOptions;
        java.lang.String placementTenancy;
        java.lang.String ramDiskId;
        java.util.List<java.lang.String> securityGroups;
        java.lang.String spotPrice;
        java.lang.String userData;

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getImageId}
         * @param imageId The ID of the Amazon Machine Image (AMI) that was assigned during registration. This parameter is required.
         *                For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html">Find a Linux AMI</a> in the <em>Amazon EC2 User Guide</em> .
         *                <p>
         *                If you specify <code>InstanceId</code> , an <code>ImageId</code> is not required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageId(java.lang.String imageId) {
            this.imageId = imageId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getInstanceType}
         * @param instanceType Specifies the instance type of the EC2 instance. This parameter is required.
         *                     For information about available instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes">Available instance types</a> in the <em>Amazon EC2 User Guide</em> .
         *                     <p>
         *                     If you specify <code>InstanceId</code> , an <code>InstanceType</code> is not required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Specifies whether to assign a public IPv4 address to the group's instances.
         *                                 If the instance is launched into a default subnet, the default is to assign a public IPv4 address, unless you disabled the option to assign a public IPv4 address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IPv4 address, unless you enabled the option to assign a public IPv4 address on the subnet.
         *                                 <p>
         *                                 If you specify <code>true</code> , each instance in the Auto Scaling group receives a unique public IPv4 address. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Provide network connectivity for your Auto Scaling instances using Amazon VPC</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                                 <p>
         *                                 If you specify this property, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Specifies whether to assign a public IPv4 address to the group's instances.
         *                                 If the instance is launched into a default subnet, the default is to assign a public IPv4 address, unless you disabled the option to assign a public IPv4 address on the subnet. If the instance is launched into a nondefault subnet, the default is not to assign a public IPv4 address, unless you enabled the option to assign a public IPv4 address on the subnet.
         *                                 <p>
         *                                 If you specify <code>true</code> , each instance in the Auto Scaling group receives a unique public IPv4 address. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html">Provide network connectivity for your Auto Scaling instances using Amazon VPC</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                                 <p>
         *                                 If you specify this property, you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(software.amazon.awscdk.IResolvable associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getBlockDeviceMappings}
         * @param blockDeviceMappings The block device mapping entries that define the block devices to attach to the instances at launch.
         *                            By default, the block devices specified in the block device mapping for the AMI are used. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block device mappings</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(software.amazon.awscdk.IResolvable blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getBlockDeviceMappings}
         * @param blockDeviceMappings The block device mapping entries that define the block devices to attach to the instances at launch.
         *                            By default, the block devices specified in the block device mapping for the AMI are used. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block device mappings</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(java.util.List<? extends java.lang.Object> blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getClassicLinkVpcId}
         * @param classicLinkVpcId Available for backward compatibility.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classicLinkVpcId(java.lang.String classicLinkVpcId) {
            this.classicLinkVpcId = classicLinkVpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getClassicLinkVpcSecurityGroups}
         * @param classicLinkVpcSecurityGroups Available for backward compatibility.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder classicLinkVpcSecurityGroups(java.util.List<java.lang.String> classicLinkVpcSecurityGroups) {
            this.classicLinkVpcSecurityGroups = classicLinkVpcSecurityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getEbsOptimized}
         * @param ebsOptimized Specifies whether the launch configuration is optimized for EBS I/O ( <code>true</code> ) or not ( <code>false</code> ).
         *                     The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS-optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
         *                     <p>
         *                     The default value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getEbsOptimized}
         * @param ebsOptimized Specifies whether the launch configuration is optimized for EBS I/O ( <code>true</code> ) or not ( <code>false</code> ).
         *                     The optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization is not available with all instance types. Additional fees are incurred when you enable EBS optimization for an instance type that is not EBS-optimized by default. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS-optimized instances</a> in the <em>Amazon EC2 User Guide</em> .
         *                     <p>
         *                     The default value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(software.amazon.awscdk.IResolvable ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getIamInstanceProfile}
         * @param iamInstanceProfile The name or the Amazon Resource Name (ARN) of the instance profile associated with the IAM role for the instance.
         *                           The instance profile contains the IAM role. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html">IAM role for applications that run on Amazon EC2 instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamInstanceProfile(java.lang.String iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getInstanceId}
         * @param instanceId The ID of the Amazon EC2 instance to use to create the launch configuration.
         *                   When you use an instance to create a launch configuration, all properties are derived from the instance with the exception of <code>BlockDeviceMapping</code> and <code>AssociatePublicIpAddress</code> . You can override any properties from the instance by specifying them in the launch configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getInstanceMonitoring}
         * @param instanceMonitoring Controls whether instances in this group are launched with detailed ( <code>true</code> ) or basic ( <code>false</code> ) monitoring.
         *                           The default value is <code>true</code> (enabled).
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure monitoring for Auto Scaling instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMonitoring(java.lang.Boolean instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getInstanceMonitoring}
         * @param instanceMonitoring Controls whether instances in this group are launched with detailed ( <code>true</code> ) or basic ( <code>false</code> ) monitoring.
         *                           The default value is <code>true</code> (enabled).
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           When detailed monitoring is enabled, Amazon CloudWatch generates metrics every minute and your account is charged a fee. When you disable detailed monitoring, CloudWatch generates metrics every 5 minutes. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html">Configure monitoring for Auto Scaling instances</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceMonitoring(software.amazon.awscdk.IResolvable instanceMonitoring) {
            this.instanceMonitoring = instanceMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getKernelId}
         * @param kernelId The ID of the kernel associated with the AMI.
         *                 <blockquote>
         *                 <p>
         *                 We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided kernels</a> in the <em>Amazon EC2 User Guide</em> .
         *                 <p>
         *                 </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kernelId(java.lang.String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getKeyName}
         * @param keyName The name of the key pair.
         *                For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html">Amazon EC2 key pairs and Amazon EC2 instances</a> in the <em>Amazon EC2 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getLaunchConfigurationName}
         * @param launchConfigurationName The name of the launch configuration.
         *                                This name must be unique per Region per account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchConfigurationName(java.lang.String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getMetadataOptions}
         * @param metadataOptions The metadata options for the instances.
         *                        For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configure the instance metadata options</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataOptions(software.amazon.awscdk.IResolvable metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getMetadataOptions}
         * @param metadataOptions The metadata options for the instances.
         *                        For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds">Configure the instance metadata options</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataOptions(software.amazon.awscdk.services.autoscaling.CfnLaunchConfiguration.MetadataOptionsProperty metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getPlacementTenancy}
         * @param placementTenancy The tenancy of the instance, either <code>default</code> or <code>dedicated</code> .
         *                         An instance with <code>dedicated</code> tenancy runs on isolated, single-tenant hardware and can only be launched into a VPC. To launch dedicated instances into a shared tenancy VPC (a VPC with the instance placement tenancy attribute set to <code>default</code> ), you must set the value of this property to <code>dedicated</code> .
         *                         <p>
         *                         If you specify <code>PlacementTenancy</code> , you must specify at least one subnet for <code>VPCZoneIdentifier</code> when you create your group.
         *                         <p>
         *                         Valid values: <code>default</code> | <code>dedicated</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementTenancy(java.lang.String placementTenancy) {
            this.placementTenancy = placementTenancy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getRamDiskId}
         * @param ramDiskId The ID of the RAM disk to select.
         *                  <blockquote>
         *                  <p>
         *                  We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html">User provided kernels</a> in the <em>Amazon EC2 User Guide</em> .
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ramDiskId(java.lang.String ramDiskId) {
            this.ramDiskId = ramDiskId;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getSecurityGroups}
         * @param securityGroups A list that contains the security groups to assign to the instances in the Auto Scaling group.
         *                       The list can contain both the IDs of existing security groups and references to <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html">SecurityGroup</a> resources created in the template.
         *                       <p>
         *                       For more information, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html">Control traffic to resources using security groups</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getSpotPrice}
         * @param spotPrice The maximum hourly price to be paid for any Spot Instance launched to fulfill the request.
         *                  Spot Instances are launched when the price you specify exceeds the current Spot price. For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/launch-template-spot-instances.html">Request Spot Instances for fault-tolerant and flexible applications</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                  <p>
         *                  Valid Range: Minimum value of 0.001
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  When you change your maximum price by creating a new launch configuration, running instances will continue to run as long as the maximum price for those running instances is higher than the current Spot price.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotPrice(java.lang.String spotPrice) {
            this.spotPrice = spotPrice;
            return this;
        }

        /**
         * Sets the value of {@link CfnLaunchConfigurationProps#getUserData}
         * @param userData The Base64-encoded user data to make available to the launched EC2 instances.
         *                 For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html">Instance metadata and user data</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(java.lang.String userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLaunchConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLaunchConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLaunchConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLaunchConfigurationProps {
        private final java.lang.String imageId;
        private final java.lang.String instanceType;
        private final java.lang.Object associatePublicIpAddress;
        private final java.lang.Object blockDeviceMappings;
        private final java.lang.String classicLinkVpcId;
        private final java.util.List<java.lang.String> classicLinkVpcSecurityGroups;
        private final java.lang.Object ebsOptimized;
        private final java.lang.String iamInstanceProfile;
        private final java.lang.String instanceId;
        private final java.lang.Object instanceMonitoring;
        private final java.lang.String kernelId;
        private final java.lang.String keyName;
        private final java.lang.String launchConfigurationName;
        private final java.lang.Object metadataOptions;
        private final java.lang.String placementTenancy;
        private final java.lang.String ramDiskId;
        private final java.util.List<java.lang.String> securityGroups;
        private final java.lang.String spotPrice;
        private final java.lang.String userData;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.imageId = software.amazon.jsii.Kernel.get(this, "imageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.blockDeviceMappings = software.amazon.jsii.Kernel.get(this, "blockDeviceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.classicLinkVpcId = software.amazon.jsii.Kernel.get(this, "classicLinkVpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.classicLinkVpcSecurityGroups = software.amazon.jsii.Kernel.get(this, "classicLinkVpcSecurityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.iamInstanceProfile = software.amazon.jsii.Kernel.get(this, "iamInstanceProfile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceMonitoring = software.amazon.jsii.Kernel.get(this, "instanceMonitoring", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kernelId = software.amazon.jsii.Kernel.get(this, "kernelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.launchConfigurationName = software.amazon.jsii.Kernel.get(this, "launchConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.metadataOptions = software.amazon.jsii.Kernel.get(this, "metadataOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.placementTenancy = software.amazon.jsii.Kernel.get(this, "placementTenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ramDiskId = software.amazon.jsii.Kernel.get(this, "ramDiskId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.spotPrice = software.amazon.jsii.Kernel.get(this, "spotPrice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.imageId = java.util.Objects.requireNonNull(builder.imageId, "imageId is required");
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.associatePublicIpAddress = builder.associatePublicIpAddress;
            this.blockDeviceMappings = builder.blockDeviceMappings;
            this.classicLinkVpcId = builder.classicLinkVpcId;
            this.classicLinkVpcSecurityGroups = builder.classicLinkVpcSecurityGroups;
            this.ebsOptimized = builder.ebsOptimized;
            this.iamInstanceProfile = builder.iamInstanceProfile;
            this.instanceId = builder.instanceId;
            this.instanceMonitoring = builder.instanceMonitoring;
            this.kernelId = builder.kernelId;
            this.keyName = builder.keyName;
            this.launchConfigurationName = builder.launchConfigurationName;
            this.metadataOptions = builder.metadataOptions;
            this.placementTenancy = builder.placementTenancy;
            this.ramDiskId = builder.ramDiskId;
            this.securityGroups = builder.securityGroups;
            this.spotPrice = builder.spotPrice;
            this.userData = builder.userData;
        }

        @Override
        public final java.lang.String getImageId() {
            return this.imageId;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.lang.Object getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final java.lang.Object getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final java.lang.String getClassicLinkVpcId() {
            return this.classicLinkVpcId;
        }

        @Override
        public final java.util.List<java.lang.String> getClassicLinkVpcSecurityGroups() {
            return this.classicLinkVpcSecurityGroups;
        }

        @Override
        public final java.lang.Object getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final java.lang.String getIamInstanceProfile() {
            return this.iamInstanceProfile;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final java.lang.Object getInstanceMonitoring() {
            return this.instanceMonitoring;
        }

        @Override
        public final java.lang.String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final java.lang.String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final java.lang.Object getMetadataOptions() {
            return this.metadataOptions;
        }

        @Override
        public final java.lang.String getPlacementTenancy() {
            return this.placementTenancy;
        }

        @Override
        public final java.lang.String getRamDiskId() {
            return this.ramDiskId;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.String getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public final java.lang.String getUserData() {
            return this.userData;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("imageId", om.valueToTree(this.getImageId()));
            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            if (this.getAssociatePublicIpAddress() != null) {
                data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
            }
            if (this.getBlockDeviceMappings() != null) {
                data.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
            }
            if (this.getClassicLinkVpcId() != null) {
                data.set("classicLinkVpcId", om.valueToTree(this.getClassicLinkVpcId()));
            }
            if (this.getClassicLinkVpcSecurityGroups() != null) {
                data.set("classicLinkVpcSecurityGroups", om.valueToTree(this.getClassicLinkVpcSecurityGroups()));
            }
            if (this.getEbsOptimized() != null) {
                data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
            }
            if (this.getIamInstanceProfile() != null) {
                data.set("iamInstanceProfile", om.valueToTree(this.getIamInstanceProfile()));
            }
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }
            if (this.getInstanceMonitoring() != null) {
                data.set("instanceMonitoring", om.valueToTree(this.getInstanceMonitoring()));
            }
            if (this.getKernelId() != null) {
                data.set("kernelId", om.valueToTree(this.getKernelId()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getLaunchConfigurationName() != null) {
                data.set("launchConfigurationName", om.valueToTree(this.getLaunchConfigurationName()));
            }
            if (this.getMetadataOptions() != null) {
                data.set("metadataOptions", om.valueToTree(this.getMetadataOptions()));
            }
            if (this.getPlacementTenancy() != null) {
                data.set("placementTenancy", om.valueToTree(this.getPlacementTenancy()));
            }
            if (this.getRamDiskId() != null) {
                data.set("ramDiskId", om.valueToTree(this.getRamDiskId()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSpotPrice() != null) {
                data.set("spotPrice", om.valueToTree(this.getSpotPrice()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnLaunchConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLaunchConfigurationProps.Jsii$Proxy that = (CfnLaunchConfigurationProps.Jsii$Proxy) o;

            if (!imageId.equals(that.imageId)) return false;
            if (!instanceType.equals(that.instanceType)) return false;
            if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
            if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
            if (this.classicLinkVpcId != null ? !this.classicLinkVpcId.equals(that.classicLinkVpcId) : that.classicLinkVpcId != null) return false;
            if (this.classicLinkVpcSecurityGroups != null ? !this.classicLinkVpcSecurityGroups.equals(that.classicLinkVpcSecurityGroups) : that.classicLinkVpcSecurityGroups != null) return false;
            if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
            if (this.iamInstanceProfile != null ? !this.iamInstanceProfile.equals(that.iamInstanceProfile) : that.iamInstanceProfile != null) return false;
            if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) return false;
            if (this.instanceMonitoring != null ? !this.instanceMonitoring.equals(that.instanceMonitoring) : that.instanceMonitoring != null) return false;
            if (this.kernelId != null ? !this.kernelId.equals(that.kernelId) : that.kernelId != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.launchConfigurationName != null ? !this.launchConfigurationName.equals(that.launchConfigurationName) : that.launchConfigurationName != null) return false;
            if (this.metadataOptions != null ? !this.metadataOptions.equals(that.metadataOptions) : that.metadataOptions != null) return false;
            if (this.placementTenancy != null ? !this.placementTenancy.equals(that.placementTenancy) : that.placementTenancy != null) return false;
            if (this.ramDiskId != null ? !this.ramDiskId.equals(that.ramDiskId) : that.ramDiskId != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.spotPrice != null ? !this.spotPrice.equals(that.spotPrice) : that.spotPrice != null) return false;
            return this.userData != null ? this.userData.equals(that.userData) : that.userData == null;
        }

        @Override
        public final int hashCode() {
            int result = this.imageId.hashCode();
            result = 31 * result + (this.instanceType.hashCode());
            result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
            result = 31 * result + (this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0);
            result = 31 * result + (this.classicLinkVpcId != null ? this.classicLinkVpcId.hashCode() : 0);
            result = 31 * result + (this.classicLinkVpcSecurityGroups != null ? this.classicLinkVpcSecurityGroups.hashCode() : 0);
            result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
            result = 31 * result + (this.iamInstanceProfile != null ? this.iamInstanceProfile.hashCode() : 0);
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            result = 31 * result + (this.instanceMonitoring != null ? this.instanceMonitoring.hashCode() : 0);
            result = 31 * result + (this.kernelId != null ? this.kernelId.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.launchConfigurationName != null ? this.launchConfigurationName.hashCode() : 0);
            result = 31 * result + (this.metadataOptions != null ? this.metadataOptions.hashCode() : 0);
            result = 31 * result + (this.placementTenancy != null ? this.placementTenancy.hashCode() : 0);
            result = 31 * result + (this.ramDiskId != null ? this.ramDiskId.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            return result;
        }
    }
}
