package software.amazon.awscdk.services.autoscaling;

/**
 * Health check settings for multiple types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.MICRO))
 *         .machineImage(MachineImage.latestAmazonLinux2())
 *         .healthChecks(HealthChecks.ec2(Ec2HealthChecksOptions.builder()
 *                 .gracePeriod(Duration.seconds(100))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:10.064Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.HealthChecks")
public class HealthChecks extends software.amazon.jsii.JsiiObject {

    protected HealthChecks(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HealthChecks(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Use EC2 only for health checks.
     * <p>
     * @param options EC2 health checks options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.HealthChecks ec2(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.Ec2HealthChecksOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.HealthChecks.class, "ec2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.HealthChecks.class), new Object[] { options });
    }

    /**
     * Use EC2 only for health checks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.HealthChecks ec2() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.HealthChecks.class, "ec2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.HealthChecks.class));
    }

    /**
     * Use additional health checks other than EC2.
     * <p>
     * Specify types other than EC2, as EC2 is always enabled.
     * It considers the instance unhealthy if it fails either the EC2 status checks or the additional health checks.
     * <p>
     * @param options Additional health checks options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.HealthChecks withAdditionalChecks(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.AdditionalHealthChecksOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.autoscaling.HealthChecks.class, "withAdditionalChecks", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.HealthChecks.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTypes() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getGracePeriod() {
        return software.amazon.jsii.Kernel.get(this, "gracePeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }
}
