package software.amazon.awscdk.services.backup;

/**
 * Properties for defining a <code>CfnRestoreTestingPlan</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * CfnRestoreTestingPlanProps cfnRestoreTestingPlanProps = CfnRestoreTestingPlanProps.builder()
 *         .recoveryPointSelection(RestoreTestingRecoveryPointSelectionProperty.builder()
 *                 .algorithm("algorithm")
 *                 .includeVaults(List.of("includeVaults"))
 *                 .recoveryPointTypes(List.of("recoveryPointTypes"))
 *                 // the properties below are optional
 *                 .excludeVaults(List.of("excludeVaults"))
 *                 .selectionWindowDays(123)
 *                 .build())
 *         .restoreTestingPlanName("restoreTestingPlanName")
 *         .scheduleExpression("scheduleExpression")
 *         // the properties below are optional
 *         .scheduleExpressionTimezone("scheduleExpressionTimezone")
 *         .startWindowHours(123)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:10.193Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnRestoreTestingPlanProps")
@software.amazon.jsii.Jsii.Proxy(CfnRestoreTestingPlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRestoreTestingPlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The specified criteria to assign a set of resources, such as recovery point types or backup vaults.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-recoverypointselection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-recoverypointselection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRecoveryPointSelection();

    /**
     * The RestoreTestingPlanName is a unique string that is the name of the restore testing plan.
     * <p>
     * This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-restoretestingplanname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-restoretestingplanname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestoreTestingPlanName();

    /**
     * A CRON expression in specified timezone when a restore testing plan is executed.
     * <p>
     * When no CRON expression is provided, AWS Backup will use the default expression <code>cron(0 5 ? * * *)</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-scheduleexpression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

    /**
     * Optional.
     * <p>
     * This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-scheduleexpressiontimezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-scheduleexpressiontimezone</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheduleExpressionTimezone() {
        return null;
    }

    /**
     * Defaults to 24 hours.
     * <p>
     * A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-startwindowhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-startwindowhours</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStartWindowHours() {
        return null;
    }

    /**
     * Optional tags to include.
     * <p>
     * A tag is a key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters,numbers, spaces, and the following characters: <code>+ - = . _ : /.</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingplan.html#cfn-backup-restoretestingplan-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRestoreTestingPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRestoreTestingPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRestoreTestingPlanProps> {
        java.lang.Object recoveryPointSelection;
        java.lang.String restoreTestingPlanName;
        java.lang.String scheduleExpression;
        java.lang.String scheduleExpressionTimezone;
        java.lang.Number startWindowHours;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnRestoreTestingPlanProps#getRecoveryPointSelection}
         * @param recoveryPointSelection The specified criteria to assign a set of resources, such as recovery point types or backup vaults. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryPointSelection(software.amazon.awscdk.IResolvable recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingPlanProps#getRecoveryPointSelection}
         * @param recoveryPointSelection The specified criteria to assign a set of resources, such as recovery point types or backup vaults. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryPointSelection(software.amazon.awscdk.services.backup.CfnRestoreTestingPlan.RestoreTestingRecoveryPointSelectionProperty recoveryPointSelection) {
            this.recoveryPointSelection = recoveryPointSelection;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingPlanProps#getRestoreTestingPlanName}
         * @param restoreTestingPlanName The RestoreTestingPlanName is a unique string that is the name of the restore testing plan. This parameter is required.
         *                               This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTestingPlanName(java.lang.String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingPlanProps#getScheduleExpression}
         * @param scheduleExpression A CRON expression in specified timezone when a restore testing plan is executed. This parameter is required.
         *                           When no CRON expression is provided, AWS Backup will use the default expression <code>cron(0 5 ? * * *)</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpression(java.lang.String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingPlanProps#getScheduleExpressionTimezone}
         * @param scheduleExpressionTimezone Optional.
         *                                   This is the timezone in which the schedule expression is set. By default, ScheduleExpressions are in UTC. You can modify this to a specified timezone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleExpressionTimezone(java.lang.String scheduleExpressionTimezone) {
            this.scheduleExpressionTimezone = scheduleExpressionTimezone;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingPlanProps#getStartWindowHours}
         * @param startWindowHours Defaults to 24 hours.
         *                         A value in hours after a restore test is scheduled before a job will be canceled if it doesn't start successfully. This value is optional. If this value is included, this parameter has a maximum value of 168 hours (one week).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startWindowHours(java.lang.Number startWindowHours) {
            this.startWindowHours = startWindowHours;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingPlanProps#getTags}
         * @param tags Optional tags to include.
         *             A tag is a key-value pair you can use to manage, filter, and search for your resources. Allowed characters include UTF-8 letters,numbers, spaces, and the following characters: <code>+ - = . _ : /.</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRestoreTestingPlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRestoreTestingPlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRestoreTestingPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRestoreTestingPlanProps {
        private final java.lang.Object recoveryPointSelection;
        private final java.lang.String restoreTestingPlanName;
        private final java.lang.String scheduleExpression;
        private final java.lang.String scheduleExpressionTimezone;
        private final java.lang.Number startWindowHours;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.recoveryPointSelection = software.amazon.jsii.Kernel.get(this, "recoveryPointSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.restoreTestingPlanName = software.amazon.jsii.Kernel.get(this, "restoreTestingPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scheduleExpressionTimezone = software.amazon.jsii.Kernel.get(this, "scheduleExpressionTimezone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.startWindowHours = software.amazon.jsii.Kernel.get(this, "startWindowHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.recoveryPointSelection = java.util.Objects.requireNonNull(builder.recoveryPointSelection, "recoveryPointSelection is required");
            this.restoreTestingPlanName = java.util.Objects.requireNonNull(builder.restoreTestingPlanName, "restoreTestingPlanName is required");
            this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
            this.scheduleExpressionTimezone = builder.scheduleExpressionTimezone;
            this.startWindowHours = builder.startWindowHours;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getRecoveryPointSelection() {
            return this.recoveryPointSelection;
        }

        @Override
        public final java.lang.String getRestoreTestingPlanName() {
            return this.restoreTestingPlanName;
        }

        @Override
        public final java.lang.String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final java.lang.String getScheduleExpressionTimezone() {
            return this.scheduleExpressionTimezone;
        }

        @Override
        public final java.lang.Number getStartWindowHours() {
            return this.startWindowHours;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("recoveryPointSelection", om.valueToTree(this.getRecoveryPointSelection()));
            data.set("restoreTestingPlanName", om.valueToTree(this.getRestoreTestingPlanName()));
            data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
            if (this.getScheduleExpressionTimezone() != null) {
                data.set("scheduleExpressionTimezone", om.valueToTree(this.getScheduleExpressionTimezone()));
            }
            if (this.getStartWindowHours() != null) {
                data.set("startWindowHours", om.valueToTree(this.getStartWindowHours()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnRestoreTestingPlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRestoreTestingPlanProps.Jsii$Proxy that = (CfnRestoreTestingPlanProps.Jsii$Proxy) o;

            if (!recoveryPointSelection.equals(that.recoveryPointSelection)) return false;
            if (!restoreTestingPlanName.equals(that.restoreTestingPlanName)) return false;
            if (!scheduleExpression.equals(that.scheduleExpression)) return false;
            if (this.scheduleExpressionTimezone != null ? !this.scheduleExpressionTimezone.equals(that.scheduleExpressionTimezone) : that.scheduleExpressionTimezone != null) return false;
            if (this.startWindowHours != null ? !this.startWindowHours.equals(that.startWindowHours) : that.startWindowHours != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.recoveryPointSelection.hashCode();
            result = 31 * result + (this.restoreTestingPlanName.hashCode());
            result = 31 * result + (this.scheduleExpression.hashCode());
            result = 31 * result + (this.scheduleExpressionTimezone != null ? this.scheduleExpressionTimezone.hashCode() : 0);
            result = 31 * result + (this.startWindowHours != null ? this.startWindowHours.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
