package software.amazon.awscdk.services.backup;

/**
 * Properties for defining a <code>CfnRestoreTestingSelection</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * CfnRestoreTestingSelectionProps cfnRestoreTestingSelectionProps = CfnRestoreTestingSelectionProps.builder()
 *         .iamRoleArn("iamRoleArn")
 *         .protectedResourceType("protectedResourceType")
 *         .restoreTestingPlanName("restoreTestingPlanName")
 *         .restoreTestingSelectionName("restoreTestingSelectionName")
 *         // the properties below are optional
 *         .protectedResourceArns(List.of("protectedResourceArns"))
 *         .protectedResourceConditions(ProtectedResourceConditionsProperty.builder()
 *                 .stringEquals(List.of(KeyValueProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .stringNotEquals(List.of(KeyValueProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .restoreMetadataOverrides(Map.of(
 *                 "restoreMetadataOverridesKey", "restoreMetadataOverrides"))
 *         .validationWindowHours(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:10.196Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnRestoreTestingSelectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnRestoreTestingSelectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRestoreTestingSelectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the IAM role that AWS Backup uses to create the target resource;
     * <p>
     * for example: <code>arn:aws:iam::123456789012:role/S3Access</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-iamrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-iamrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIamRoleArn();

    /**
     * The type of AWS resource included in a resource testing selection;
     * <p>
     * for example, an Amazon EBS volume or an Amazon RDS database.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourcetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProtectedResourceType();

    /**
     * Unique string that is the name of the restore testing plan.
     * <p>
     * The name cannot be changed after creation. The name must consist of only alphanumeric characters and underscores. Maximum length is 50.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoretestingplanname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoretestingplanname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestoreTestingPlanName();

    /**
     * The unique name of the restore testing selection that belongs to the related restore testing plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoretestingselectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoretestingselectionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRestoreTestingSelectionName();

    /**
     * You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code> , but not both.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourcearns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourcearns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getProtectedResourceArns() {
        return null;
    }

    /**
     * In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourceconditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-protectedresourceconditions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProtectedResourceConditions() {
        return null;
    }

    /**
     * You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code> .
     * <p>
     * Key values are not case sensitive.
     * <p>
     * See the complete list of <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore testing inferred metadata</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoremetadataoverrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-restoremetadataoverrides</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRestoreMetadataOverrides() {
        return null;
    }

    /**
     * This is amount of hours (1 to 168) available to run a validation script on the data.
     * <p>
     * The data will be deleted upon the completion of the validation script or the end of the specified retention period, whichever comes first.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-validationwindowhours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-restoretestingselection.html#cfn-backup-restoretestingselection-validationwindowhours</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getValidationWindowHours() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRestoreTestingSelectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRestoreTestingSelectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRestoreTestingSelectionProps> {
        java.lang.String iamRoleArn;
        java.lang.String protectedResourceType;
        java.lang.String restoreTestingPlanName;
        java.lang.String restoreTestingSelectionName;
        java.util.List<java.lang.String> protectedResourceArns;
        java.lang.Object protectedResourceConditions;
        java.lang.Object restoreMetadataOverrides;
        java.lang.Number validationWindowHours;

        /**
         * Sets the value of {@link CfnRestoreTestingSelectionProps#getIamRoleArn}
         * @param iamRoleArn The Amazon Resource Name (ARN) of the IAM role that AWS Backup uses to create the target resource;. This parameter is required.
         *                   for example: <code>arn:aws:iam::123456789012:role/S3Access</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iamRoleArn(java.lang.String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingSelectionProps#getProtectedResourceType}
         * @param protectedResourceType The type of AWS resource included in a resource testing selection;. This parameter is required.
         *                              for example, an Amazon EBS volume or an Amazon RDS database.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectedResourceType(java.lang.String protectedResourceType) {
            this.protectedResourceType = protectedResourceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingSelectionProps#getRestoreTestingPlanName}
         * @param restoreTestingPlanName Unique string that is the name of the restore testing plan. This parameter is required.
         *                               The name cannot be changed after creation. The name must consist of only alphanumeric characters and underscores. Maximum length is 50.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTestingPlanName(java.lang.String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingSelectionProps#getRestoreTestingSelectionName}
         * @param restoreTestingSelectionName The unique name of the restore testing selection that belongs to the related restore testing plan. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreTestingSelectionName(java.lang.String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingSelectionProps#getProtectedResourceArns}
         * @param protectedResourceArns You can include specific ARNs, such as <code>ProtectedResourceArns: ["arn:aws:...", "arn:aws:..."]</code> or you can include a wildcard: <code>ProtectedResourceArns: ["*"]</code> , but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectedResourceArns(java.util.List<java.lang.String> protectedResourceArns) {
            this.protectedResourceArns = protectedResourceArns;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingSelectionProps#getProtectedResourceConditions}
         * @param protectedResourceConditions In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectedResourceConditions(software.amazon.awscdk.IResolvable protectedResourceConditions) {
            this.protectedResourceConditions = protectedResourceConditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingSelectionProps#getProtectedResourceConditions}
         * @param protectedResourceConditions In a resource testing selection, this parameter filters by specific conditions such as <code>StringEquals</code> or <code>StringNotEquals</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protectedResourceConditions(software.amazon.awscdk.services.backup.CfnRestoreTestingSelection.ProtectedResourceConditionsProperty protectedResourceConditions) {
            this.protectedResourceConditions = protectedResourceConditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingSelectionProps#getRestoreMetadataOverrides}
         * @param restoreMetadataOverrides You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code> .
         *                                 Key values are not case sensitive.
         *                                 <p>
         *                                 See the complete list of <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore testing inferred metadata</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreMetadataOverrides(java.util.Map<java.lang.String, java.lang.String> restoreMetadataOverrides) {
            this.restoreMetadataOverrides = restoreMetadataOverrides;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingSelectionProps#getRestoreMetadataOverrides}
         * @param restoreMetadataOverrides You can override certain restore metadata keys by including the parameter <code>RestoreMetadataOverrides</code> in the body of <code>RestoreTestingSelection</code> .
         *                                 Key values are not case sensitive.
         *                                 <p>
         *                                 See the complete list of <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html">restore testing inferred metadata</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restoreMetadataOverrides(software.amazon.awscdk.IResolvable restoreMetadataOverrides) {
            this.restoreMetadataOverrides = restoreMetadataOverrides;
            return this;
        }

        /**
         * Sets the value of {@link CfnRestoreTestingSelectionProps#getValidationWindowHours}
         * @param validationWindowHours This is amount of hours (1 to 168) available to run a validation script on the data.
         *                              The data will be deleted upon the completion of the validation script or the end of the specified retention period, whichever comes first.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationWindowHours(java.lang.Number validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRestoreTestingSelectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRestoreTestingSelectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRestoreTestingSelectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRestoreTestingSelectionProps {
        private final java.lang.String iamRoleArn;
        private final java.lang.String protectedResourceType;
        private final java.lang.String restoreTestingPlanName;
        private final java.lang.String restoreTestingSelectionName;
        private final java.util.List<java.lang.String> protectedResourceArns;
        private final java.lang.Object protectedResourceConditions;
        private final java.lang.Object restoreMetadataOverrides;
        private final java.lang.Number validationWindowHours;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.iamRoleArn = software.amazon.jsii.Kernel.get(this, "iamRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protectedResourceType = software.amazon.jsii.Kernel.get(this, "protectedResourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restoreTestingPlanName = software.amazon.jsii.Kernel.get(this, "restoreTestingPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.restoreTestingSelectionName = software.amazon.jsii.Kernel.get(this, "restoreTestingSelectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protectedResourceArns = software.amazon.jsii.Kernel.get(this, "protectedResourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.protectedResourceConditions = software.amazon.jsii.Kernel.get(this, "protectedResourceConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.restoreMetadataOverrides = software.amazon.jsii.Kernel.get(this, "restoreMetadataOverrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.validationWindowHours = software.amazon.jsii.Kernel.get(this, "validationWindowHours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.iamRoleArn = java.util.Objects.requireNonNull(builder.iamRoleArn, "iamRoleArn is required");
            this.protectedResourceType = java.util.Objects.requireNonNull(builder.protectedResourceType, "protectedResourceType is required");
            this.restoreTestingPlanName = java.util.Objects.requireNonNull(builder.restoreTestingPlanName, "restoreTestingPlanName is required");
            this.restoreTestingSelectionName = java.util.Objects.requireNonNull(builder.restoreTestingSelectionName, "restoreTestingSelectionName is required");
            this.protectedResourceArns = builder.protectedResourceArns;
            this.protectedResourceConditions = builder.protectedResourceConditions;
            this.restoreMetadataOverrides = builder.restoreMetadataOverrides;
            this.validationWindowHours = builder.validationWindowHours;
        }

        @Override
        public final java.lang.String getIamRoleArn() {
            return this.iamRoleArn;
        }

        @Override
        public final java.lang.String getProtectedResourceType() {
            return this.protectedResourceType;
        }

        @Override
        public final java.lang.String getRestoreTestingPlanName() {
            return this.restoreTestingPlanName;
        }

        @Override
        public final java.lang.String getRestoreTestingSelectionName() {
            return this.restoreTestingSelectionName;
        }

        @Override
        public final java.util.List<java.lang.String> getProtectedResourceArns() {
            return this.protectedResourceArns;
        }

        @Override
        public final java.lang.Object getProtectedResourceConditions() {
            return this.protectedResourceConditions;
        }

        @Override
        public final java.lang.Object getRestoreMetadataOverrides() {
            return this.restoreMetadataOverrides;
        }

        @Override
        public final java.lang.Number getValidationWindowHours() {
            return this.validationWindowHours;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("iamRoleArn", om.valueToTree(this.getIamRoleArn()));
            data.set("protectedResourceType", om.valueToTree(this.getProtectedResourceType()));
            data.set("restoreTestingPlanName", om.valueToTree(this.getRestoreTestingPlanName()));
            data.set("restoreTestingSelectionName", om.valueToTree(this.getRestoreTestingSelectionName()));
            if (this.getProtectedResourceArns() != null) {
                data.set("protectedResourceArns", om.valueToTree(this.getProtectedResourceArns()));
            }
            if (this.getProtectedResourceConditions() != null) {
                data.set("protectedResourceConditions", om.valueToTree(this.getProtectedResourceConditions()));
            }
            if (this.getRestoreMetadataOverrides() != null) {
                data.set("restoreMetadataOverrides", om.valueToTree(this.getRestoreMetadataOverrides()));
            }
            if (this.getValidationWindowHours() != null) {
                data.set("validationWindowHours", om.valueToTree(this.getValidationWindowHours()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnRestoreTestingSelectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRestoreTestingSelectionProps.Jsii$Proxy that = (CfnRestoreTestingSelectionProps.Jsii$Proxy) o;

            if (!iamRoleArn.equals(that.iamRoleArn)) return false;
            if (!protectedResourceType.equals(that.protectedResourceType)) return false;
            if (!restoreTestingPlanName.equals(that.restoreTestingPlanName)) return false;
            if (!restoreTestingSelectionName.equals(that.restoreTestingSelectionName)) return false;
            if (this.protectedResourceArns != null ? !this.protectedResourceArns.equals(that.protectedResourceArns) : that.protectedResourceArns != null) return false;
            if (this.protectedResourceConditions != null ? !this.protectedResourceConditions.equals(that.protectedResourceConditions) : that.protectedResourceConditions != null) return false;
            if (this.restoreMetadataOverrides != null ? !this.restoreMetadataOverrides.equals(that.restoreMetadataOverrides) : that.restoreMetadataOverrides != null) return false;
            return this.validationWindowHours != null ? this.validationWindowHours.equals(that.validationWindowHours) : that.validationWindowHours == null;
        }

        @Override
        public final int hashCode() {
            int result = this.iamRoleArn.hashCode();
            result = 31 * result + (this.protectedResourceType.hashCode());
            result = 31 * result + (this.restoreTestingPlanName.hashCode());
            result = 31 * result + (this.restoreTestingSelectionName.hashCode());
            result = 31 * result + (this.protectedResourceArns != null ? this.protectedResourceArns.hashCode() : 0);
            result = 31 * result + (this.protectedResourceConditions != null ? this.protectedResourceConditions.hashCode() : 0);
            result = 31 * result + (this.restoreMetadataOverrides != null ? this.restoreMetadataOverrides.hashCode() : 0);
            result = 31 * result + (this.validationWindowHours != null ? this.validationWindowHours.hashCode() : 0);
            return result;
        }
    }
}
