package software.amazon.awscdk.services.batch;

/**
 * Props for EksJobDefinition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EksJobDefinition jobDefn = EksJobDefinition.Builder.create(this, "eksf2")
 *         .container(EksContainerDefinition.Builder.create(this, "container")
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .volumes(List.of(EksVolume.emptyDir(EmptyDirVolumeOptions.builder()
 *                         .name("myEmptyDirVolume")
 *                         .mountPath("/mount/path")
 *                         .medium(EmptyDirMediumType.MEMORY)
 *                         .readonly(true)
 *                         .sizeLimit(Size.mebibytes(2048))
 *                         .build())))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:10.332Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EksJobDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(EksJobDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EksJobDefinitionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.JobDefinitionProps {

    /**
     * The container this Job Definition will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EksContainerDefinition getContainer();

    /**
     * The DNS Policy of the pod used by this Job Definition.
     * <p>
     * Default: `DnsPolicy.CLUSTER_FIRST`
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy">https://kubernetes.io/docs/concepts/services-networking/dns-pod-service/#pod-s-dns-policy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.DnsPolicy getDnsPolicy() {
        return null;
    }

    /**
     * The name of the service account that's used to run the container.
     * <p>
     * service accounts are Kubernetes method of identification and authentication,
     * roughly analogous to IAM users.
     * <p>
     * Default: - the default service account of the container
     * <p>
     * @see <a href="https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html">https://docs.aws.amazon.com/eks/latest/userguide/associate-service-account-role.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceAccount() {
        return null;
    }

    /**
     * If specified, the Pod used by this Job Definition will use the host's network IP address.
     * <p>
     * Otherwise, the Kubernetes pod networking model is enabled.
     * Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
     * <p>
     * Default: true
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking">https://kubernetes.io/docs/concepts/workloads/pods/#pod-networking</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseHostNetwork() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EksJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EksJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EksJobDefinitionProps> {
        software.amazon.awscdk.services.batch.EksContainerDefinition container;
        software.amazon.awscdk.services.batch.DnsPolicy dnsPolicy;
        java.lang.String serviceAccount;
        java.lang.Boolean useHostNetwork;
        java.lang.String jobDefinitionName;
        java.util.Map<java.lang.String, java.lang.Object> parameters;
        java.lang.Number retryAttempts;
        java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies;
        java.lang.Number schedulingPriority;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link EksJobDefinitionProps#getContainer}
         * @param container The container this Job Definition will run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder container(software.amazon.awscdk.services.batch.EksContainerDefinition container) {
            this.container = container;
            return this;
        }

        /**
         * Sets the value of {@link EksJobDefinitionProps#getDnsPolicy}
         * @param dnsPolicy The DNS Policy of the pod used by this Job Definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dnsPolicy(software.amazon.awscdk.services.batch.DnsPolicy dnsPolicy) {
            this.dnsPolicy = dnsPolicy;
            return this;
        }

        /**
         * Sets the value of {@link EksJobDefinitionProps#getServiceAccount}
         * @param serviceAccount The name of the service account that's used to run the container.
         *                       service accounts are Kubernetes method of identification and authentication,
         *                       roughly analogous to IAM users.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceAccount(java.lang.String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        /**
         * Sets the value of {@link EksJobDefinitionProps#getUseHostNetwork}
         * @param useHostNetwork If specified, the Pod used by this Job Definition will use the host's network IP address.
         *                       Otherwise, the Kubernetes pod networking model is enabled.
         *                       Most AWS Batch workloads are egress-only and don't require the overhead of IP allocation for each pod for incoming connections.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useHostNetwork(java.lang.Boolean useHostNetwork) {
            this.useHostNetwork = useHostNetwork;
            return this;
        }

        /**
         * Sets the value of {@link EksJobDefinitionProps#getJobDefinitionName}
         * @param jobDefinitionName The name of this job definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(java.lang.String jobDefinitionName) {
            this.jobDefinitionName = jobDefinitionName;
            return this;
        }

        /**
         * Sets the value of {@link EksJobDefinitionProps#getParameters}
         * @param parameters The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder parameters(java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)parameters;
            return this;
        }

        /**
         * Sets the value of {@link EksJobDefinitionProps#getRetryAttempts}
         * @param retryAttempts The number of times to retry a job.
         *                      The job is retried on failure the same number of attempts as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link EksJobDefinitionProps#getRetryStrategies}
         * @param retryStrategies Defines the retry behavior for this job.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder retryStrategies(java.util.List<? extends software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies) {
            this.retryStrategies = (java.util.List<software.amazon.awscdk.services.batch.RetryStrategy>)retryStrategies;
            return this;
        }

        /**
         * Sets the value of {@link EksJobDefinitionProps#getSchedulingPriority}
         * @param schedulingPriority The priority of this Job.
         *                           Only used in Fairshare Scheduling
         *                           to decide which job to run first when there are multiple jobs
         *                           with the same share identifier.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPriority(java.lang.Number schedulingPriority) {
            this.schedulingPriority = schedulingPriority;
            return this;
        }

        /**
         * Sets the value of {@link EksJobDefinitionProps#getTimeout}
         * @param timeout The timeout time for jobs that are submitted with this job definition.
         *                After the amount of time you specify passes,
         *                Batch terminates your jobs if they aren't finished.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EksJobDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EksJobDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EksJobDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EksJobDefinitionProps {
        private final software.amazon.awscdk.services.batch.EksContainerDefinition container;
        private final software.amazon.awscdk.services.batch.DnsPolicy dnsPolicy;
        private final java.lang.String serviceAccount;
        private final java.lang.Boolean useHostNetwork;
        private final java.lang.String jobDefinitionName;
        private final java.util.Map<java.lang.String, java.lang.Object> parameters;
        private final java.lang.Number retryAttempts;
        private final java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies;
        private final java.lang.Number schedulingPriority;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.container = software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EksContainerDefinition.class));
            this.dnsPolicy = software.amazon.jsii.Kernel.get(this, "dnsPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.DnsPolicy.class));
            this.serviceAccount = software.amazon.jsii.Kernel.get(this, "serviceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.useHostNetwork = software.amazon.jsii.Kernel.get(this, "useHostNetwork", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.jobDefinitionName = software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.retryStrategies = software.amazon.jsii.Kernel.get(this, "retryStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.RetryStrategy.class)));
            this.schedulingPriority = software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.container = java.util.Objects.requireNonNull(builder.container, "container is required");
            this.dnsPolicy = builder.dnsPolicy;
            this.serviceAccount = builder.serviceAccount;
            this.useHostNetwork = builder.useHostNetwork;
            this.jobDefinitionName = builder.jobDefinitionName;
            this.parameters = (java.util.Map<java.lang.String, java.lang.Object>)builder.parameters;
            this.retryAttempts = builder.retryAttempts;
            this.retryStrategies = (java.util.List<software.amazon.awscdk.services.batch.RetryStrategy>)builder.retryStrategies;
            this.schedulingPriority = builder.schedulingPriority;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.batch.EksContainerDefinition getContainer() {
            return this.container;
        }

        @Override
        public final software.amazon.awscdk.services.batch.DnsPolicy getDnsPolicy() {
            return this.dnsPolicy;
        }

        @Override
        public final java.lang.String getServiceAccount() {
            return this.serviceAccount;
        }

        @Override
        public final java.lang.Boolean getUseHostNetwork() {
            return this.useHostNetwork;
        }

        @Override
        public final java.lang.String getJobDefinitionName() {
            return this.jobDefinitionName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getParameters() {
            return this.parameters;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> getRetryStrategies() {
            return this.retryStrategies;
        }

        @Override
        public final java.lang.Number getSchedulingPriority() {
            return this.schedulingPriority;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("container", om.valueToTree(this.getContainer()));
            if (this.getDnsPolicy() != null) {
                data.set("dnsPolicy", om.valueToTree(this.getDnsPolicy()));
            }
            if (this.getServiceAccount() != null) {
                data.set("serviceAccount", om.valueToTree(this.getServiceAccount()));
            }
            if (this.getUseHostNetwork() != null) {
                data.set("useHostNetwork", om.valueToTree(this.getUseHostNetwork()));
            }
            if (this.getJobDefinitionName() != null) {
                data.set("jobDefinitionName", om.valueToTree(this.getJobDefinitionName()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }
            if (this.getRetryStrategies() != null) {
                data.set("retryStrategies", om.valueToTree(this.getRetryStrategies()));
            }
            if (this.getSchedulingPriority() != null) {
                data.set("schedulingPriority", om.valueToTree(this.getSchedulingPriority()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.EksJobDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EksJobDefinitionProps.Jsii$Proxy that = (EksJobDefinitionProps.Jsii$Proxy) o;

            if (!container.equals(that.container)) return false;
            if (this.dnsPolicy != null ? !this.dnsPolicy.equals(that.dnsPolicy) : that.dnsPolicy != null) return false;
            if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) return false;
            if (this.useHostNetwork != null ? !this.useHostNetwork.equals(that.useHostNetwork) : that.useHostNetwork != null) return false;
            if (this.jobDefinitionName != null ? !this.jobDefinitionName.equals(that.jobDefinitionName) : that.jobDefinitionName != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.retryAttempts != null ? !this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts != null) return false;
            if (this.retryStrategies != null ? !this.retryStrategies.equals(that.retryStrategies) : that.retryStrategies != null) return false;
            if (this.schedulingPriority != null ? !this.schedulingPriority.equals(that.schedulingPriority) : that.schedulingPriority != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.container.hashCode();
            result = 31 * result + (this.dnsPolicy != null ? this.dnsPolicy.hashCode() : 0);
            result = 31 * result + (this.serviceAccount != null ? this.serviceAccount.hashCode() : 0);
            result = 31 * result + (this.useHostNetwork != null ? this.useHostNetwork.hashCode() : 0);
            result = 31 * result + (this.jobDefinitionName != null ? this.jobDefinitionName.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            result = 31 * result + (this.retryStrategies != null ? this.retryStrategies.hashCode() : 0);
            result = 31 * result + (this.schedulingPriority != null ? this.schedulingPriority.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
