package software.amazon.awscdk.services.batch;

/**
 * Represents a JobQueue.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:10.362Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.IJobQueue")
@software.amazon.jsii.Jsii.Proxy(IJobQueue.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IJobQueue extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IResource {

    /**
     * The set of compute environments mapped to a job queue and their order relative to each other.
     * <p>
     * The job scheduler uses this parameter to determine which compute environment runs a specific job.
     * Compute environments must be in the VALID state before you can associate them with a job queue.
     * You can associate up to three compute environments with a job queue.
     * All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT);
     * EC2 and Fargate compute environments can't be mixed.
     * <p>
     * <em>Note</em>: All compute environments that are associated with a job queue must share the same architecture.
     * AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.OrderedComputeEnvironment> getComputeEnvironments();

    /**
     * The ARN of this job queue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobQueueArn();

    /**
     * The name of the job queue.
     * <p>
     * It can be up to 128 letters long.
     * It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobQueueName();

    /**
     * The priority of the job queue.
     * <p>
     * Job queues with a higher priority are evaluated first when associated with the same compute environment.
     * Priority is determined in descending order.
     * For example, a job queue with a priority value of 10 is given scheduling preference over a job queue with a priority value of 1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * If the job queue is enabled, it is able to accept jobs.
     * <p>
     * Otherwise, new jobs can't be added to the queue, but jobs already in the queue can finish.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return null;
    }

    /**
     * The SchedulingPolicy for this JobQueue.
     * <p>
     * Instructs the Scheduler how to schedule different jobs.
     * <p>
     * Default: - no scheduling policy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ISchedulingPolicy getSchedulingPolicy() {
        return null;
    }

    /**
     * Add a <code>ComputeEnvironment</code> to this Queue.
     * <p>
     * The Queue will prefer lower-order <code>ComputeEnvironment</code>s.
     * <p>
     * @param computeEnvironment This parameter is required.
     * @param order This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addComputeEnvironment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IComputeEnvironment computeEnvironment, final @org.jetbrains.annotations.NotNull java.lang.Number order);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.batch.IJobQueue.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The set of compute environments mapped to a job queue and their order relative to each other.
         * <p>
         * The job scheduler uses this parameter to determine which compute environment runs a specific job.
         * Compute environments must be in the VALID state before you can associate them with a job queue.
         * You can associate up to three compute environments with a job queue.
         * All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT);
         * EC2 and Fargate compute environments can't be mixed.
         * <p>
         * <em>Note</em>: All compute environments that are associated with a job queue must share the same architecture.
         * AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.OrderedComputeEnvironment> getComputeEnvironments() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "computeEnvironments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.OrderedComputeEnvironment.class))));
        }

        /**
         * The ARN of this job queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getJobQueueArn() {
            return software.amazon.jsii.Kernel.get(this, "jobQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the job queue.
         * <p>
         * It can be up to 128 letters long.
         * It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getJobQueueName() {
            return software.amazon.jsii.Kernel.get(this, "jobQueueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The priority of the job queue.
         * <p>
         * Job queues with a higher priority are evaluated first when associated with the same compute environment.
         * Priority is determined in descending order.
         * For example, a job queue with a priority value of 10 is given scheduling preference over a job queue with a priority value of 1.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.Number getPriority() {
            return software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * If the job queue is enabled, it is able to accept jobs.
         * <p>
         * Otherwise, new jobs can't be added to the queue, but jobs already in the queue can finish.
         * <p>
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
            return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The SchedulingPolicy for this JobQueue.
         * <p>
         * Instructs the Scheduler how to schedule different jobs.
         * <p>
         * Default: - no scheduling policy
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ISchedulingPolicy getSchedulingPolicy() {
            return software.amazon.jsii.Kernel.get(this, "schedulingPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ISchedulingPolicy.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Add a <code>ComputeEnvironment</code> to this Queue.
         * <p>
         * The Queue will prefer lower-order <code>ComputeEnvironment</code>s.
         * <p>
         * @param computeEnvironment This parameter is required.
         * @param order This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addComputeEnvironment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IComputeEnvironment computeEnvironment, final @org.jetbrains.annotations.NotNull java.lang.Number order) {
            software.amazon.jsii.Kernel.call(this, "addComputeEnvironment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(computeEnvironment, "computeEnvironment is required"), java.util.Objects.requireNonNull(order, "order is required") });
        }
    }

    /**
     * Internal default implementation for {@link IJobQueue}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IJobQueue, software.amazon.awscdk.IResource.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The set of compute environments mapped to a job queue and their order relative to each other.
         * <p>
         * The job scheduler uses this parameter to determine which compute environment runs a specific job.
         * Compute environments must be in the VALID state before you can associate them with a job queue.
         * You can associate up to three compute environments with a job queue.
         * All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT);
         * EC2 and Fargate compute environments can't be mixed.
         * <p>
         * <em>Note</em>: All compute environments that are associated with a job queue must share the same architecture.
         * AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.OrderedComputeEnvironment> getComputeEnvironments() {
            return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "computeEnvironments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.OrderedComputeEnvironment.class))));
        }

        /**
         * The ARN of this job queue.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getJobQueueArn() {
            return software.amazon.jsii.Kernel.get(this, "jobQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The name of the job queue.
         * <p>
         * It can be up to 128 letters long.
         * It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_)
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getJobQueueName() {
            return software.amazon.jsii.Kernel.get(this, "jobQueueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The priority of the job queue.
         * <p>
         * Job queues with a higher priority are evaluated first when associated with the same compute environment.
         * Priority is determined in descending order.
         * For example, a job queue with a priority value of 10 is given scheduling preference over a job queue with a priority value of 1.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.Number getPriority() {
            return software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * If the job queue is enabled, it is able to accept jobs.
         * <p>
         * Otherwise, new jobs can't be added to the queue, but jobs already in the queue can finish.
         * <p>
         * Default: true
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
            return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * The SchedulingPolicy for this JobQueue.
         * <p>
         * Instructs the Scheduler how to schedule different jobs.
         * <p>
         * Default: - no scheduling policy
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ISchedulingPolicy getSchedulingPolicy() {
            return software.amazon.jsii.Kernel.get(this, "schedulingPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ISchedulingPolicy.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Add a <code>ComputeEnvironment</code> to this Queue.
         * <p>
         * The Queue will prefer lower-order <code>ComputeEnvironment</code>s.
         * <p>
         * @param computeEnvironment This parameter is required.
         * @param order This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addComputeEnvironment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IComputeEnvironment computeEnvironment, final @org.jetbrains.annotations.NotNull java.lang.Number order) {
            software.amazon.jsii.Kernel.call(this, "addComputeEnvironment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(computeEnvironment, "computeEnvironment is required"), java.util.Objects.requireNonNull(order, "order is required") });
        }
    }
}
