package software.amazon.awscdk.services.batch;

/**
 * The reason to log for the action being taken.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * JobQueue.Builder.create(this, "JobQueue")
 *         .jobStateTimeLimitActions(List.of(JobStateTimeLimitAction.builder()
 *                 .action(JobStateTimeLimitActionsAction.CANCEL)
 *                 .maxTime(Duration.minutes(10))
 *                 .reason(JobStateTimeLimitActionsReason.INSUFFICIENT_INSTANCE_CAPACITY)
 *                 .state(JobStateTimeLimitActionsState.RUNNABLE)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable">https://docs.aws.amazon.com/batch/latest/userguide/troubleshooting.html#job_stuck_in_runnable</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:10.382Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.JobStateTimeLimitActionsReason")
public enum JobStateTimeLimitActionsReason {
    /**
     * All connected compute environments have insufficient capacity errors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INSUFFICIENT_INSTANCE_CAPACITY,
    /**
     * All compute environments have a maxvCpus parameter that is smaller than the job requirements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE_ENVIRONMENT_MAX_RESOURCE,
    /**
     * None of the compute environments have instances that meet the job requirements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    JOB_RESOURCE_REQUIREMENT,
}
