package software.amazon.awscdk.services.batch;

/**
 * Runs the container on nodes [startNode, endNode].
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * MultiNodeJobDefinition multiNodeJob = MultiNodeJobDefinition.Builder.create(this, "JobDefinition")
 *         .instanceType(InstanceType.of(InstanceClass.R4, InstanceSize.LARGE)) // optional, omit to let Batch choose the type for you
 *         .containers(List.of(MultiNodeContainer.builder()
 *                 .container(EcsEc2ContainerDefinition.Builder.create(this, "mainMPIContainer")
 *                         .image(ContainerImage.fromRegistry("yourregsitry.com/yourMPIImage:latest"))
 *                         .cpu(256)
 *                         .memory(Size.mebibytes(2048))
 *                         .build())
 *                 .startNode(0)
 *                 .endNode(5)
 *                 .build()))
 *         .build();
 * // convenience method
 * multiNodeJob.addContainer(MultiNodeContainer.builder()
 *         .startNode(6)
 *         .endNode(10)
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "multiContainer")
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .cpu(256)
 *                 .memory(Size.mebibytes(2048))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:10.394Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.MultiNodeContainer")
@software.amazon.jsii.Jsii.Proxy(MultiNodeContainer.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MultiNodeContainer extends software.amazon.jsii.JsiiSerializable {

    /**
     * The container that this node range will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IEcsContainerDefinition getContainer();

    /**
     * The index of the last node to run this container.
     * <p>
     * The container is run on all nodes in the range [startNode, endNode] (inclusive)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getEndNode();

    /**
     * The index of the first node to run this container.
     * <p>
     * The container is run on all nodes in the range [startNode, endNode] (inclusive)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getStartNode();

    /**
     * @return a {@link Builder} of {@link MultiNodeContainer}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MultiNodeContainer}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MultiNodeContainer> {
        software.amazon.awscdk.services.batch.IEcsContainerDefinition container;
        java.lang.Number endNode;
        java.lang.Number startNode;

        /**
         * Sets the value of {@link MultiNodeContainer#getContainer}
         * @param container The container that this node range will run. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder container(software.amazon.awscdk.services.batch.IEcsContainerDefinition container) {
            this.container = container;
            return this;
        }

        /**
         * Sets the value of {@link MultiNodeContainer#getEndNode}
         * @param endNode The index of the last node to run this container. This parameter is required.
         *                The container is run on all nodes in the range [startNode, endNode] (inclusive)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endNode(java.lang.Number endNode) {
            this.endNode = endNode;
            return this;
        }

        /**
         * Sets the value of {@link MultiNodeContainer#getStartNode}
         * @param startNode The index of the first node to run this container. This parameter is required.
         *                  The container is run on all nodes in the range [startNode, endNode] (inclusive)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startNode(java.lang.Number startNode) {
            this.startNode = startNode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MultiNodeContainer}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MultiNodeContainer build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link MultiNodeContainer}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MultiNodeContainer {
        private final software.amazon.awscdk.services.batch.IEcsContainerDefinition container;
        private final java.lang.Number endNode;
        private final java.lang.Number startNode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.container = software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IEcsContainerDefinition.class));
            this.endNode = software.amazon.jsii.Kernel.get(this, "endNode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.startNode = software.amazon.jsii.Kernel.get(this, "startNode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.container = java.util.Objects.requireNonNull(builder.container, "container is required");
            this.endNode = java.util.Objects.requireNonNull(builder.endNode, "endNode is required");
            this.startNode = java.util.Objects.requireNonNull(builder.startNode, "startNode is required");
        }

        @Override
        public final software.amazon.awscdk.services.batch.IEcsContainerDefinition getContainer() {
            return this.container;
        }

        @Override
        public final java.lang.Number getEndNode() {
            return this.endNode;
        }

        @Override
        public final java.lang.Number getStartNode() {
            return this.startNode;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("container", om.valueToTree(this.getContainer()));
            data.set("endNode", om.valueToTree(this.getEndNode()));
            data.set("startNode", om.valueToTree(this.getStartNode()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.MultiNodeContainer"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MultiNodeContainer.Jsii$Proxy that = (MultiNodeContainer.Jsii$Proxy) o;

            if (!container.equals(that.container)) return false;
            if (!endNode.equals(that.endNode)) return false;
            return this.startNode.equals(that.startNode);
        }

        @Override
        public final int hashCode() {
            int result = this.container.hashCode();
            result = 31 * result + (this.endNode.hashCode());
            result = 31 * result + (this.startNode.hashCode());
            return result;
        }
    }
}
