package software.amazon.awscdk.services.batch;

/**
 * A JobDefinition that uses Ecs orchestration to run multiple containers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * MultiNodeJobDefinition multiNodeJob = MultiNodeJobDefinition.Builder.create(this, "JobDefinition")
 *         .instanceType(InstanceType.of(InstanceClass.R4, InstanceSize.LARGE)) // optional, omit to let Batch choose the type for you
 *         .containers(List.of(MultiNodeContainer.builder()
 *                 .container(EcsEc2ContainerDefinition.Builder.create(this, "mainMPIContainer")
 *                         .image(ContainerImage.fromRegistry("yourregsitry.com/yourMPIImage:latest"))
 *                         .cpu(256)
 *                         .memory(Size.mebibytes(2048))
 *                         .build())
 *                 .startNode(0)
 *                 .endNode(5)
 *                 .build()))
 *         .build();
 * // convenience method
 * multiNodeJob.addContainer(MultiNodeContainer.builder()
 *         .startNode(6)
 *         .endNode(10)
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "multiContainer")
 *                 .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *                 .cpu(256)
 *                 .memory(Size.mebibytes(2048))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:10.395Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.MultiNodeJobDefinition")
public class MultiNodeJobDefinition extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.batch.IJobDefinition {

    protected MultiNodeJobDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MultiNodeJobDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.batch.MultiNodeJobDefinition.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MultiNodeJobDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.MultiNodeJobDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MultiNodeJobDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * refer to an existing JobDefinition by its arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param jobDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IJobDefinition fromJobDefinitionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String jobDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.MultiNodeJobDefinition.class, "fromJobDefinitionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IJobDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobDefinitionArn, "jobDefinitionArn is required") });
    }

    /**
     * Add a container to this multinode job.
     * <p>
     * @param container This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addContainer(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.MultiNodeContainer container) {
        software.amazon.jsii.Kernel.call(this, "addContainer", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(container, "container is required") });
    }

    /**
     * Add a RetryStrategy to this JobDefinition.
     * <p>
     * @param strategy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addRetryStrategy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.RetryStrategy strategy) {
        software.amazon.jsii.Kernel.call(this, "addRetryStrategy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(strategy, "strategy is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * The containers that this multinode job will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.MultiNodeContainer> getContainers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "containers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.MultiNodeContainer.class))));
    }

    /**
     * If the prop <code>instanceType</code> is left <code>undefined</code>, then this will hold a fake instance type, for backwards compatibility reasons.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
    }

    /**
     * The ARN of this job definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this job definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Defines the retry behavior for this job.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> getRetryStrategies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "retryStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.RetryStrategy.class))));
    }

    /**
     * The index of the main node in this job.
     * <p>
     * The main node is responsible for orchestration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMainNode() {
        return software.amazon.jsii.Kernel.get(this, "mainNode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.Object>)(software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Whether to propagate tags from the JobDefinition to the ECS task that Batch spawns.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getPropagateTags() {
        return software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The number of times to retry a job.
     * <p>
     * The job is retried on failure the same number of attempts as the value.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
        return software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The priority of this Job.
     * <p>
     * Only used in Fairshare Scheduling
     * to decide which job to run first when there are multiple jobs
     * with the same share identifier.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingPriority() {
        return software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     * <p>
     * After the amount of time you specify passes,
     * Batch terminates your jobs if they aren't finished.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.MultiNodeJobDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.MultiNodeJobDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.batch.MultiNodeJobDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of this job definition.
         * <p>
         * Default: - generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param jobDefinitionName The name of this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(final java.lang.String jobDefinitionName) {
            this.props().jobDefinitionName(jobDefinitionName);
            return this;
        }

        /**
         * The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters">https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters</a>
         * @param parameters The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * The number of times to retry a job.
         * <p>
         * The job is retried on failure the same number of attempts as the value.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param retryAttempts The number of times to retry a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        /**
         * Defines the retry behavior for this job.
         * <p>
         * Default: - no `RetryStrategy`
         * <p>
         * @return {@code this}
         * @param retryStrategies Defines the retry behavior for this job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategies(final java.util.List<? extends software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies) {
            this.props().retryStrategies(retryStrategies);
            return this;
        }

        /**
         * The priority of this Job.
         * <p>
         * Only used in Fairshare Scheduling
         * to decide which job to run first when there are multiple jobs
         * with the same share identifier.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param schedulingPriority The priority of this Job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPriority(final java.lang.Number schedulingPriority) {
            this.props().schedulingPriority(schedulingPriority);
            return this;
        }

        /**
         * The timeout time for jobs that are submitted with this job definition.
         * <p>
         * After the amount of time you specify passes,
         * Batch terminates your jobs if they aren't finished.
         * <p>
         * Default: - no timeout
         * <p>
         * @return {@code this}
         * @param timeout The timeout time for jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        /**
         * The containers that this multinode job will run.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @see <a href="https://aws.amazon.com/blogs/compute/building-a-tightly-coupled-molecular-dynamics-workflow-with-multi-node-parallel-jobs-in-aws-batch/">https://aws.amazon.com/blogs/compute/building-a-tightly-coupled-molecular-dynamics-workflow-with-multi-node-parallel-jobs-in-aws-batch/</a>
         * @param containers The containers that this multinode job will run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containers(final java.util.List<? extends software.amazon.awscdk.services.batch.MultiNodeContainer> containers) {
            this.props().containers(containers);
            return this;
        }

        /**
         * The instance type that this job definition will run.
         * <p>
         * Default: - optimal instance, selected by Batch
         * <p>
         * @return {@code this}
         * @param instanceType The instance type that this job definition will run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props().instanceType(instanceType);
            return this;
        }

        /**
         * The index of the main node in this job.
         * <p>
         * The main node is responsible for orchestration.
         * <p>
         * Default: 0
         * <p>
         * @return {@code this}
         * @param mainNode The index of the main node in this job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mainNode(final java.lang.Number mainNode) {
            this.props().mainNode(mainNode);
            return this;
        }

        /**
         * Whether to propagate tags from the JobDefinition to the ECS task that Batch spawns.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param propagateTags Whether to propagate tags from the JobDefinition to the ECS task that Batch spawns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final java.lang.Boolean propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.MultiNodeJobDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.MultiNodeJobDefinition build() {
            return new software.amazon.awscdk.services.batch.MultiNodeJobDefinition(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.batch.MultiNodeJobDefinitionProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.batch.MultiNodeJobDefinitionProps.Builder();
            }
            return this.props;
        }
    }
}
