package software.amazon.awscdk.services.certificatemanager;

/**
 * Certificate Manager key algorithm.
 * <p>
 * If you need to use an algorithm that doesn't exist as a static member, you
 * can instantiate a <code>KeyAlgorithm</code> object, e.g: <code>new KeyAlgorithm('RSA_2048')</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.acmpca.*;
 * PrivateCertificate.Builder.create(this, "PrivateCertificate")
 *         .domainName("test.example.com")
 *         .subjectAlternativeNames(List.of("cool.example.com", "test.example.net")) // optional
 *         .certificateAuthority(CertificateAuthority.fromCertificateAuthorityArn(this, "CA", "arn:aws:acm-pca:us-east-1:123456789012:certificate-authority/023077d8-2bfa-4eb0-8f22-05c96deade77"))
 *         .keyAlgorithm(KeyAlgorithm.RSA_2048)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-keyalgorithm">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-keyalgorithm</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-07-16T11:43:10.759Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_certificatemanager.KeyAlgorithm")
public class KeyAlgorithm extends software.amazon.jsii.JsiiObject {

    protected KeyAlgorithm(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KeyAlgorithm(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        EC_PRIME256_V1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class, "EC_PRIME256V1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class));
        EC_SECP384_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class, "EC_SECP384R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class));
        EC_SECP521_R1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class, "EC_SECP521R1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class));
        RSA_1024 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class, "RSA_1024", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class));
        RSA_2048 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class, "RSA_2048", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class));
        RSA_3072 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class, "RSA_3072", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class));
        RSA_4096 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class, "RSA_4096", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.KeyAlgorithm.class));
    }

    /**
     * @param name The name of the algorithm. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KeyAlgorithm(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * EC_prime256v1 algorithm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.certificatemanager.KeyAlgorithm EC_PRIME256_V1;

    /**
     * EC_secp384r1 algorithm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.certificatemanager.KeyAlgorithm EC_SECP384_R1;

    /**
     * EC_secp521r1 algorithm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.certificatemanager.KeyAlgorithm EC_SECP521_R1;

    /**
     * RSA_1024 algorithm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.certificatemanager.KeyAlgorithm RSA_1024;

    /**
     * RSA_2048 algorithm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.certificatemanager.KeyAlgorithm RSA_2048;

    /**
     * RSA_3072 algorithm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.certificatemanager.KeyAlgorithm RSA_3072;

    /**
     * RSA_4096 algorithm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.certificatemanager.KeyAlgorithm RSA_4096;

    /**
     * The name of the algorithm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
